#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/miscdevice.h>
#include <asm/uaccess.h>
#include <linux/slab.h>

#define WIFI_IOCTL_STOP   0x0
#define WIFI_IOCTL_START 0x1
#define WIFI_IOCTL_START_TESTMODE 0x3
extern int rwnx_mod_init(void);
extern void rwnx_mod_exit(void);
extern int testmode;
int aic_runmode = 0;
extern void aic8800_wifi_disable(int bval);
extern void aic8800_wifi_re_enable(int bval);
void dw_mci_rescan_card(unsigned id, unsigned insert);
struct wifi_dev {
	uint32_t dev_state;
};

struct wifi_dev *wifidev = NULL;
static const char wifi_shortname[] = "wifi_device";

static int wifi_dev_open(struct inode *ip, struct file *fp);
static int wifi_dev_release(struct inode *ip, struct file *fp);
static long wifi_dev_ioctl(struct file *fp, unsigned int cmd, unsigned long arg);

/* file operations for volte device /dev/volte_device */
static const struct file_operations wifi_dev_fops = {
	.owner = THIS_MODULE,
	.unlocked_ioctl = wifi_dev_ioctl,
	.open = wifi_dev_open,
	.release = wifi_dev_open,
};

static struct miscdevice wifi_device = {
	.minor = MISC_DYNAMIC_MINOR,
	.name = wifi_shortname,
	.fops = &wifi_dev_fops,
};

static long wifi_dev_ioctl(struct file *fp, unsigned int cmd, unsigned long arg)
{
	int ret = 0;
	void __user *argp = (void __user *) arg;

	switch (cmd) {
	case WIFI_IOCTL_STOP: {
		if((aic_runmode == WIFI_IOCTL_START) || (aic_runmode == WIFI_IOCTL_START_TESTMODE)){
	      printk(KERN_INFO "@@@exit Wlan@@@\n");
		rwnx_mod_exit();
		aic8800_wifi_disable(1);
		testmode = 0;
			if(!ret)
			aic_runmode = WIFI_IOCTL_STOP;
		}else
			printk("aic wifi not load %d,cant stop!\n", aic_runmode);
		break;
	}
	case WIFI_IOCTL_START: {
		if(!aic_runmode){
	      printk(KERN_INFO "@@@initWlan@@@\n");
		  aic8800_wifi_re_enable(1);
		  dw_mci_rescan_card(0,1);
             ret = rwnx_mod_init();
			if(!ret)
			aic_runmode = WIFI_IOCTL_START;
		}else
			printk("aic wifi has loaded %d,cant start in normal!\n", aic_runmode);
		break;	
	}
	
	case WIFI_IOCTL_START_TESTMODE: {
		if(!aic_runmode){
	      printk(KERN_INFO "@@@initWlan Testmode@@@\n");
		  	 testmode = 1;
			  aic8800_wifi_re_enable(1);
			  dw_mci_rescan_card(0, 1);
             ret = rwnx_mod_init();
			  if(!ret)
			  aic_runmode = WIFI_IOCTL_START_TESTMODE;
		}else
			printk("aic wifi has loaded %d,cant start in testmode!\n", aic_runmode);
		break;	
	}

	default: {
		printk(KERN_INFO "wifi_ioctl  invalid cmd!\n");
		break;
	}
	}
	
	return ret;
}

static int wifi_dev_open(struct inode *ip, struct file *fp)
{
	if (wifidev == NULL) {
		wifidev = kzalloc(sizeof(*wifidev), GFP_KERNEL);
		if (!wifidev) {
			pr_info("wifi dev malloc error\n");
			return -ENOMEM;
		}

	}
	return 0;
}

static int wifi_dev_release(struct inode *ip, struct file *fp)
{
	if (wifidev) {
		kfree(wifidev);
		wifidev = NULL;
		printk("release wifi dev!\n");

	}
	return 0;
}


int  wifi_dev_init(void)
{
	int ret;
       printk(KERN_ERR "@@@@@wifi dev register@@@@@\n");
	ret = misc_register(&wifi_device);
	if (ret) {
		printk(KERN_ERR "wifi dev failed to initialize\n");
		return -EFAULT;
	}
	printk("qqq wifi_dev_init.\n");
	return 0;
}

void  wifi_dev_exit(void)
{
	misc_deregister(&wifi_device);
}

