#include <linux/version.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include "aicwf_mem_prealloc.h"

//#define MOD_AUTHOR      "Aicsemi, Ltd"
//#define MOD_DESCRIPTION "Pre-allocated memory for RivieraWaves 11nac driver"
//#define MOD_LICENSE     "Dual BSD/GPL"

#ifdef LESS_SKB
struct aicwf_rx_buff_list aic_rx_buff_list;
EXPORT_SYMBOL(aic_rx_buff_list);

int aic_rxbuff_num_max = 30;
EXPORT_SYMBOL(aic_rxbuff_num_max);
module_param(aic_rxbuff_num_max, int, 0644);
MODULE_PARM_DESC(aic_rxbuff_num_max, "Max length of prealloc rx buff list");

int aic_rxbuff_size = (64 * 512);
EXPORT_SYMBOL(aic_rxbuff_size);
module_param(aic_rxbuff_size, int, 0644);
MODULE_PARM_DESC(aic_rxbuff_size, "Max size of prealloc rx buff");

struct rx_buff *aicwf_prealloc_rxbuff_alloc(spinlock_t *lock) 
{
    unsigned long flags;
    struct rx_buff *rxbuff = NULL;

    spin_lock_irqsave(lock, flags);
    if (list_empty(&aic_rx_buff_list.rxbuff_list)) {
        spin_unlock_irqrestore(lock, flags);
        printk("%s %d, rxbuff list is empty\n", __func__, __LINE__);
        return NULL;
    } else {
		rxbuff = list_first_entry(&aic_rx_buff_list.rxbuff_list,
					   struct rx_buff, queue);
		list_del_init(&rxbuff->queue);
        atomic_dec(&aic_rx_buff_list.rxbuff_list_len);
	}
    spin_unlock_irqrestore(lock, flags);
//    printk("len:%d\n", aic_rx_buff_list.rxbuff_list_len);
    memset(rxbuff->data, 0, aic_rxbuff_size);
    rxbuff->len = 0;
    rxbuff->start = NULL;
    rxbuff->read = NULL;
    rxbuff->end = NULL;

    return rxbuff;
}
EXPORT_SYMBOL(aicwf_prealloc_rxbuff_alloc);

void aicwf_prealloc_rxbuff_free(struct rx_buff *rxbuff, spinlock_t *lock)
{
    unsigned long flags;

    spin_lock_irqsave(lock, flags);
	list_add_tail(&rxbuff->queue, &aic_rx_buff_list.rxbuff_list);
	atomic_inc(&aic_rx_buff_list.rxbuff_list_len);
    spin_unlock_irqrestore(lock, flags);
}
EXPORT_SYMBOL(aicwf_prealloc_rxbuff_free);
#endif

struct sk_buff *tx_aggr_buf;
int aicwf_prealloc_init(void)
{
    printk("%s, enter\n", __func__);

    tx_aggr_buf = dev_alloc_skb(1536*32);
    if(!tx_aggr_buf) {
        printk("pre alloc tx_aggr_buf failed!\n");
        return -1;
    }

#ifdef LESS_SKB
    struct rx_buff *rxbuff;
    int i = 0;

    INIT_LIST_HEAD(&aic_rx_buff_list.rxbuff_list);
    
	for (i = 0 ; i < aic_rxbuff_num_max ; i++) {
        rxbuff = kzalloc(sizeof(struct rx_buff), GFP_KERNEL);
        if (rxbuff) {
            rxbuff->data = kzalloc(aic_rxbuff_size, GFP_KERNEL);
            if (rxbuff->data == NULL) {
                printk("failed to alloc rxbuff data\n");
                kfree(rxbuff);
                continue;
            }
            rxbuff->len = 0;
            rxbuff->start = NULL;
            rxbuff->read = NULL;
            rxbuff->end = NULL;
            list_add_tail(&rxbuff->queue, &aic_rx_buff_list.rxbuff_list);
            atomic_inc(&aic_rx_buff_list.rxbuff_list_len);
        }
    }

	printk("pre alloc rxbuff list len: %d\n", aic_rx_buff_list.rxbuff_list_len);
#endif
    return 0;
}
EXPORT_SYMBOL(aicwf_prealloc_init);

void aicwf_prealloc_exit(void)
{
    printk("%s enter\n", __func__);

    if (tx_aggr_buf)
        dev_kfree_skb(tx_aggr_buf);

#ifdef LESS_SKB
    struct rx_buff *rxbuff;
    struct rx_buff *pos;
    
	printk("free pre alloc rxbuff list %d\n", aic_rx_buff_list.rxbuff_list_len);
    list_for_each_entry_safe(rxbuff, pos, &aic_rx_buff_list.rxbuff_list, queue) {
        list_del_init(&rxbuff->queue);
        kfree(rxbuff->data);
        kfree(rxbuff);
    }
#endif
}
EXPORT_SYMBOL(aicwf_prealloc_exit);

//module_init(aicwf_prealloc_init);
//module_exit(aicwf_prealloc_exit);

//MODULE_AUTHOR(MOD_AUTHOR);
//MODULE_DESCRIPTION(MOD_DESCRIPTION);
//MODULE_LICENSE(MOD_LICENSE);

