
#ifdef __KERNEL__
#include <linux/module.h>
#include <asm/byteorder.h>
#elif defined(__ECOS)
#include <cyg/io/eth/rltk/819x/wrapper/sys_support.h>
#include <cyg/io/eth/rltk/819x/wrapper/skbuff.h>
#include <cyg/io/eth/rltk/819x/wrapper/timer.h>
#include <cyg/io/eth/rltk/819x/wrapper/wrapper.h>
#endif

#include "./8192cd_cfg.h"

#if !defined(__KERNEL__) && !defined(__ECOS)
#include "../sys-support.h"
#endif

#include "./8192cd.h"
#ifdef __KERNEL__
#include "./ieee802_mib.h"
#elif defined(__ECOS)
#include <cyg/io/eth/rltk/819x/wlan/ieee802_mib.h>
#endif

#include "./8192cd_util.h"
#include "./8192cd_headers.h"
#include "./8192cd_debug.h"
#include "./8192cd_11v.h"

#define _8192CD_11V_C_

//extern void qsort (void  *base, int nel, int width, int (*comp)(const void *, const void *));
//extern unsigned int issue_assocreq(struct rtl8192cd_priv *priv);

//++++++++ customized functions 
typedef enum _PREFERENCE_ALGO_ {
	ALGORITHM_0	= 0,
	ALGORITHM_1	= 1
} PREFERENCE_ALGO;

inline unsigned char calculation_method0(bool excluded, unsigned char channel_utilization)
{
	if (excluded)
		return 0;
	return (MAX_PREFERRED_VAL - channel_utilization);
}

unsigned char getPreferredVal(struct rtl8192cd_priv *priv, unsigned char channel_utilization, unsigned char rcpi, bool excluded)
{
	unsigned char retval = 0;

	if (!priv->bssTransPara.FromUser) {
		switch (priv->pmib->wnmEntry.algoType)
		{	
			case ALGORITHM_0:
				retval = calculation_method0(0, channel_utilization);
				break;
			default:
				panic_printk("Undefined Algorithm Type! \n");
				break;
		}
		
		return retval;
	}
}
//--------- customized functions 

/* ++++++++++ customized functions ++++++++++ */
/* band steering */
bool checkBssTransDbBsIsEnable(struct rtl8192cd_priv *priv) {
	return ((priv->pmib->wnmEntry.dot11vDiassocImminent == 0) 
		&& (priv->pmib->wnmEntry.dot11vDriverBasedBsEnable == 1));
}

static void TriggerBssTransDbBs(struct rtl8192cd_priv *priv, struct stat_info *pstat) {
	struct BssTransDbBsBlockNode *entry;
	struct list_head *phead, *plist;
	bool result = true;
	unsigned long flags;

	//add this STA to block list 
	spin_lock_irqsave(&priv->BssTransDbBsBlockNodeLock, flags);

	phead = &priv->BssTransDbBsBlockList;
	if (!list_empty(phead)) {
		plist = phead->next;
		while (plist != phead) {
			entry = list_entry(plist, struct BssTransDbBsBlockNode, list);
			plist = plist->next;

			if (0 == memcmp(entry->mac, pstat->hwaddr, MACADDRLEN)) {
				result = false;
				break;
			}
		}
	}

	if (result) {
		entry = kmalloc(sizeof(*entry), GFP_ATOMIC);
		if (NULL != entry)
		{
			INIT_LIST_HEAD(&entry->list);
			memcpy(entry->mac, pstat->hwaddr, MACADDRLEN);
			entry->counter = DB_BS_BLOCK_TIME;
			
			list_add_tail(&entry->list, &priv->BssTransDbBsBlockList);
			DOT11VDEBUG("%s(%d): add (%02x%02x%02x%02x%02x%02x) into list_head\n", __FUNCTION__, __LINE__,
				entry->mac[0], entry->mac[1], entry->mac[2], entry->mac[3], entry->mac[4], entry->mac[5]);
		}
	}
	
	spin_unlock_irqrestore(&priv->BssTransDbBsBlockNodeLock, flags);

	//deauth this STA
	DOT11VDEBUG("%s(%d): disassoc (%02x%02x%02x%02x%02x%02x) \n", __FUNCTION__, __LINE__, 
		entry->mac[0], entry->mac[1], entry->mac[2], entry->mac[3], entry->mac[4], entry->mac[5]);

	//issue_disassoc(priv, pstat->hwaddr, _RSON_DISASSOC_DUE_BSS_TRANSITION);
	del_station(priv, pstat, 1);
}

void process_TriggerBssTrans(struct rtl8192cd_priv *priv)
{
	struct stat_info *pstat;
	int i, j = 0;
	unsigned long flags;

	SAVE_INT_AND_CLI(flags);
	
	for (i = 0; i < MAX_TRANS_LIST_NUM; i++) {
		if ((priv->transition_list_bitmask[i>>3] & (1<<(i&7))) == 0) {
			j++;
			continue;
		}

		pstat = get_stainfo(priv, priv->transition_list[i].addr);
		if (pstat) {
			if (!pstat->rcvNeighborReport) {
				if (!pstat->bssTransSupport
#ifdef DOT11K
					|| !(pstat->rm.rm_cap[0] | pstat->rm.rm_cap[1] | pstat->rm.rm_cap[2] | pstat->rm.rm_cap[3] | pstat->rm.rm_cap[4])
#endif
					)
				{
					//this STA never receive neighbor report because this STA doesn't support 11k 11v
					if (priv->pmib->wnmEntry.dot11vDriverBasedBsSupportNon11vSta) {
						TriggerBssTransDbBs(priv, pstat);
					}
				} else {
					//this STA never receive neighbor report because this STA is still collecting neighbor info
					TriggerBssTransDbBs(priv, pstat);
				}
			}
		}
	}

	RESTORE_INT(flags);

	if (j == MAX_TRANS_LIST_NUM)
		DOT11VDEBUG("Transition List is empty !!\n");
}

static void resetBssTransReqCount(struct rtl8192cd_priv *priv){
	int idx=0;
	struct stat_info* pstatdTmp = NULL;
	struct stat_info* pstatd = findNextSTA(priv, &idx);
	while (pstatd) {
		pstatd->bssTransReqCount = 0;
		pstatd = findNextSTA(priv, &idx);
	}
}

static bool checkBssTransDbBitMask(struct rtl8192cd_priv *priv,int bitNum) {
	return (priv->pmib->wnmEntry.dot11vDbRedirectMask & bitNum);
}

static bool checkBssTransDbApTxLoad(struct rtl8192cd_priv *priv) {
	return ((priv->ext_stats.tx_avarage >= ((priv->pmib->wnmEntry.dot11vDbApTxLoadThreshold*1000000) >> 3)) && 
			(priv->pmib->wnmEntry.dot11vDbRedirectMask & REDIRECT_AP_TX_LOAD));		
}

static bool checkBssTransDbStaTxLoad(struct stat_info* pstatd,struct rtl8192cd_priv *priv){
	return (!(priv->pmib->wnmEntry.dot11vDbRedirectMask & REDIRECT_AP_TX_LOAD))?
		true:(pstatd->tx_avarage < ((priv->pmib->wnmEntry.dot11vDbStaTxLoadThreshold * 1000000) >> 3));
}

static bool checkBssTransDbApRxLoad(struct rtl8192cd_priv *priv) {
	return ((priv->ext_stats.rx_avarage >= ((priv->pmib->wnmEntry.dot11vDbApRxLoadThreshold*1000000)>>3)) && 
		(priv->pmib->wnmEntry.dot11vDbRedirectMask & REDIRECT_AP_RX_LOAD));
}

static bool checkBssTransDbStaRxLoad(struct stat_info* pstatd,struct rtl8192cd_priv *priv){
	return (!(priv->pmib->wnmEntry.dot11vDbRedirectMask & REDIRECT_AP_RX_LOAD))?
		true:((pstatd->rx_avarage < ((priv->pmib->wnmEntry.dot11vDbStaRxLoadThreshold * 1000000) >> 3)));
}

static void chooseTargerSta(struct rtl8192cd_priv *priv) {

	if (checkBssTransDbApTxLoad(priv) || checkBssTransDbApRxLoad(priv)) {
		char mark = 0;
		int i, idx = 0;
		unsigned int tmpCoun = 0;
		unsigned long flags;
		struct stat_info* pstatdTmp = NULL;
		struct stat_info* pstatd = findNextSTA(priv, &idx);

		while (pstatd) {
			if (checkBssTransDbStaTxLoad(pstatd, priv) && checkBssTransDbStaRxLoad(pstatd, priv))
			{
				if (mark == 0) {
					tmpCoun = pstatd->bssTransReqCount;
					mark = 1;
				}

				if (pstatd->bssTransReqCount <= tmpCoun) {
					tmpCoun = pstatd->bssTransReqCount;
					pstatdTmp = pstatd;
				}
			}
			pstatd = findNextSTA(priv, &idx);
		}

		if (pstatdTmp != NULL) {

			SAVE_INT_AND_CLI(flags);
			for (i = 0; i < MAX_TRANS_LIST_NUM; i++) {
				if((priv->transition_list_bitmask[i>>3] & (1<<(i&7))) == 0) 
					continue;

				if (0 == memcmp(priv->transition_list[i].addr, pstatdTmp->hwaddr, MACADDRLEN)) {
					DOT11VDEBUG("%s(%d): find STA (%02x%02x%02x%02x%02x%02x) (%d)\n", __FUNCTION__, __LINE__,
						pstatdTmp->hwaddr[0], pstatdTmp->hwaddr[1], pstatdTmp->hwaddr[2],
						pstatdTmp->hwaddr[3], pstatdTmp->hwaddr[4], pstatdTmp->hwaddr[5],
						pstatdTmp->bssTransReqCount);
					
					priv->pmib->dot11StationConfigEntry.wnmtest = 1;
					pstatdTmp->bssTransReqCount++;
					break;
				}
			}
			RESTORE_INT(flags);

		} else {
			DOT11VDEBUG("%s(%d): no victim\n", __FUNCTION__, __LINE__);
		}
	} else {
		resetBssTransReqCount(priv);
	}
}

void BssTransDriverBased(struct rtl8192cd_priv *priv) {

	if (priv->pmib->wnmEntry.dot11vDriverBasedEnable) {
		//DOT11VDEBUG("dot11DbCounter= %d\n",priv->dot11DbCounter);
		if (!(priv->dot11DbCounter)) {
			priv->dot11DbCounter = priv->pmib->wnmEntry.dot11vDbCheckInterval;
			chooseTargerSta(priv);
		} else {
			priv->dot11DbCounter--;
		}
	}
}

bool bssTransDbBsCheckRequest(struct rtl8192cd_priv *priv, unsigned char *mac, int frame_type) {
	//receiver packet
	struct BssTransDbBsBlockNode *entry;
	struct list_head *phead, *plist;
	bool result = false;
	unsigned long flags;

	phead = &priv->BssTransDbBsBlockList;
	if (list_empty(phead))
		return false;

	spin_lock_irqsave(&priv->BssTransDbBsBlockNodeLock, flags);

	plist = phead->next;
	while (plist != phead) {
		
		entry = list_entry(plist, struct BssTransDbBsBlockNode, list);
		plist = plist->next;

		if (0 == memcmp(entry->mac, mac, MACADDRLEN)) {
			result = true;
			break;
		}
	}

	if (result) {
		DOT11VDEBUG("%s(%d): reject this packet frame_type=%d\n", __FUNCTION__, __LINE__, frame_type);
	}

	spin_unlock_irqrestore(&priv->BssTransDbBsBlockNodeLock, flags);

	return result;
}

void bssTransDbBsTimer(struct rtl8192cd_priv *priv) {
	//remove note from list and decline counter
	struct list_head *phead, *plist;
	struct BssTransDbBsBlockNode *entry;
	unsigned long flags;

	phead = &priv->BssTransDbBsBlockList;
	if (list_empty(phead))
		return;

	spin_lock_irqsave(&priv->BssTransDbBsBlockNodeLock, flags);

	plist = phead->next;
	while (plist != phead) {
		entry = list_entry(plist, struct BssTransDbBsBlockNode, list);
		plist = plist->next;

		entry->counter--;
		if (0 == entry->counter) {
			DOT11VDEBUG("%s(%d): remove (%02x%02x%02x%02x%02x%02x) from list_head\n", __FUNCTION__, __LINE__, 
				entry->mac[0], entry->mac[1], entry->mac[2], entry->mac[3], entry->mac[4], entry->mac[5]);
			list_del(&entry->list);
			kfree(entry);
		}
	}

	spin_unlock_irqrestore(&priv->BssTransDbBsBlockNodeLock, flags);
}
/* ---------- customized functions ---------- */

void send_bss_trans_event(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char i)
{
	if (priv->pmib->wnmEntry.dot11vDiassocDeadline)
		pstat->expire_to = priv->pmib->wnmEntry.dot11vDiassocDeadline;
	else
		pstat->expire_to = MAX_FTREASSOC_DEADLINE;

#ifdef RTK_SMART_ROAMING
	if (issue_BSS_Trans_Req(priv, priv->bssTransPara.addr, NULL) == SUCCESS ) 
#else
	if (issue_BSS_Trans_Req(priv, priv->transition_list[i].addr, NULL) == SUCCESS)
#endif
	{
		pstat->bssTransExpiredTime = 0;
		pstat->bssTransTriggered = TRUE;
		priv->startCounting = TRUE;
		priv->dot11vDiassocDeadline = priv->pmib->wnmEntry.dot11vDiassocDeadline;

		DOT11VDEBUG("Send BSS Trans Req to STA [SUCCESS]:[%02x][%02x][%02x][%02x][%02x][%02x] \n",
						priv->transition_list[i].addr[0], priv->transition_list[i].addr[1], priv->transition_list[i].addr[2], 
						priv->transition_list[i].addr[3], priv->transition_list[i].addr[4], priv->transition_list[i].addr[5]);
	} else {
		DOT11VDEBUG("Send BSS Trans Req to STA [FAIL]:[%02x][%02x][%02x][%02x][%02x][%02x] \n",
						priv->transition_list[i].addr[0], priv->transition_list[i].addr[1], priv->transition_list[i].addr[2], 
						priv->transition_list[i].addr[3], priv->transition_list[i].addr[4], priv->transition_list[i].addr[5]);
	}
}

void process_BssTransReq(struct rtl8192cd_priv *priv)
{
	struct stat_info *pstat;
	int i, j = 0;
    unsigned long flags;

	SAVE_INT_AND_CLI(flags);

	for (i = 0; i < MAX_TRANS_LIST_NUM; i++) {
		if ((priv->transition_list_bitmask[i>>3] & (1<<(i&7))) == 0) {
			j++;
			continue;
		}
		
#ifdef RTK_SMART_ROAMING
		pstat = get_stainfo(priv, priv->bssTransPara.addr);
#else	
		pstat = get_stainfo(priv, priv->transition_list[i].addr);		
#endif
		if (pstat) {
			if (priv->pmib->wnmEntry.Is11kDaemonOn) { //collect neighbor report by dot11k daemon
				if (pstat->rcvNeighborReport) 
					send_bss_trans_event(priv, pstat, i);
				else
					panic_printk("Target clients may not Ready yet!!\n");
			} else
				send_bss_trans_event(priv, pstat, i);
		} else
			panic_printk("No such station(%d):[%02x][%02x][%02x][%02x][%02x][%02x] \n", i,
							priv->transition_list[i].addr[0], priv->transition_list[i].addr[1], priv->transition_list[i].addr[2], 
							priv->transition_list[i].addr[3], priv->transition_list[i].addr[4], priv->transition_list[i].addr[5]);
		
	}

	RESTORE_INT(flags);

	if (j == MAX_TRANS_LIST_NUM)
		panic_printk("Transition List is empty !!\n");
	
}

void BssTrans_ExpiredTimer(struct rtl8192cd_priv *priv)
{
	int i;
	unsigned long flags;
	struct stat_info *pstat;

	SAVE_INT_AND_CLI(flags);
	for (i = 0; i < MAX_TRANS_LIST_NUM; i++) {
		if((priv->transition_list_bitmask[i>>3] & (1<<(i&7))) == 0) 
			continue;

#ifdef RTK_SMART_ROAMING
		pstat = get_stainfo(priv, priv->bssTransPara.addr);
#else	
		pstat = get_stainfo(priv, priv->transition_list[i].addr);
#endif
		if(pstat) {
			if(pstat->bssTransTriggered) 	// client does not reply bss trans request
				pstat->bssTransExpiredTime++;

			if(pstat->bssTransExpiredTime == EVENT_TIMEOUT)	
				pstat->bssTransStatusCode = _TIMEOUT_STATUS_CODE_;
		}
	}
	RESTORE_INT(flags);
}

void BssTrans_DiassocTimer(struct rtl8192cd_priv *priv)
{
	int i;
	struct stat_info *pstat;
	unsigned long flags;
	
	if (!priv->dot11vDiassocDeadline) 
		priv->startCounting  = FALSE;
	
	if (priv->startCounting == TRUE && priv->dot11vDiassocDeadline) {

		priv->dot11vDiassocDeadline--;

		DOT11VDEBUG("Counting down= %d\n", priv->dot11vDiassocDeadline);
		if (!priv->dot11vDiassocDeadline) {
			SAVE_INT_AND_CLI(flags);
			for (i = 0; i < MAX_TRANS_LIST_NUM; i++) {
				if((priv->transition_list_bitmask[i>>3] & (1<<(i&7))) == 0) 
					continue;

#ifdef RTK_SMART_ROAMING
				pstat = get_stainfo(priv, priv->bssTransPara.addr);
				if(!pstat) {
					panic_printk("Cant find associated STA (%02x%02x%02x%02x%02x%02x)\n",
						priv->bssTransPara.addr[0], priv->bssTransPara.addr[1], priv->bssTransPara.addr[2]
						,priv->bssTransPara.addr[3], priv->bssTransPara.addr[4], priv->bssTransPara.addr[5]);
				} else {
					panic_printk("issue diassoc to trigger bss transition!!\n");
					issue_disassoc(priv, priv->bssTransPara.addr, _RSON_DISASSOC_DUE_BSS_TRANSITION);
					del_station(priv, pstat, 0);		
				}
#else
				pstat = get_stainfo(priv, priv->transition_list[i].addr);
				if (!pstat) {
					panic_printk("Cant find associated STA (%02x%02x%02x%02x%02x%02x)\n",
						priv->transition_list[i].addr[0], priv->transition_list[i].addr[1], priv->transition_list[i].addr[2]
						,priv->transition_list[i].addr[3], priv->transition_list[i].addr[4], priv->transition_list[i].addr[5]);
				} else {
					if (priv->transition_list[i].fromSTA) {
						priv->transition_list[i].fromSTA = FALSE;
					} else {
						panic_printk("issue diassoc to trigger bss transition!!\n");
						issue_disassoc(priv, priv->transition_list[i].addr, _RSON_DISASSOC_DUE_BSS_TRANSITION);
						del_station(priv, pstat, 0);
					}
				}
#endif
				priv->startCounting  = FALSE;
			}   
			RESTORE_INT(flags);
		}
	}
}

void reset_staBssTransStatus(struct stat_info *pstat)
{
	pstat->bssTransRejectionCount = 0;
	pstat->bssTransExpiredTime = 0;
	pstat->rcvNeighborReport = 0;
	pstat->bssTransTriggered = 0;
	pstat->bssTransStatusCode = _DEFAULT_STATUS_CODE_;
}

void set_staBssTransCap(struct stat_info *pstat, unsigned char *pframe, int frameLen, unsigned short ie_offset)
{
	int ie_len = 0;
	unsigned char *ext_cap = NULL;
	unsigned char *p = get_ie(pframe + WLAN_HDR_A3_LEN + ie_offset, _EXTENDED_CAP_IE_, &ie_len,  frameLen);
	unsigned char *sa = GetAddr2Ptr(pframe);

	ext_cap = (unsigned char *)kmalloc(ie_len, GFP_ATOMIC);
	
	if (p != NULL) {
		memcpy(ext_cap, p+2, ie_len);
		if(ext_cap[2] & _WNM_BSS_TRANS_SUPPORT_) {
			pstat->bssTransSupport = TRUE;
		}else {	// when there are 2 extended Capabilities IE (IOT issue with Fujitsu)
			p = p + ie_len + 2;
			if(*p == _EXTENDED_CAP_IE_){
				ie_len = *(p+1);
				memcpy(ext_cap, p+2, ie_len);
				if(ext_cap[2] & _WNM_BSS_TRANS_SUPPORT_)
					pstat->bssTransSupport = TRUE;
			}
		}
	}

	pstat->bssTransStatusCode = _DEFAULT_STATUS_CODE_;
	kfree(ext_cap);
	DOT11VDEBUG(" STA[%02x%02x%02x%02x%02x%02x] Support 11v = %d\n", sa[0], sa[1], sa[2], sa[3], sa[4], sa[5], pstat->bssTransSupport);
}

#ifdef DOT11K
void set_BssTransPara(struct rtl8192cd_priv *priv, unsigned char *tmpbuf)
{
	int i, empty_slot;
	priv->bssTransPara.FromUser = TRUE;

	memcpy(priv->bssTransPara.addr, tmpbuf, MACADDRLEN);

#ifndef RTK_SMART_ROAMING
	priv->bssTransPara.chan_until = tmpbuf[MACADDRLEN];

	for (i = 0, empty_slot = -1; i < MAX_NEIGHBOR_REPORT; i++) {
		if ((priv->rm_neighbor_bitmask[i>>3] & (1<<(i&7))) == 0) {
			if (empty_slot == -1)
				empty_slot = i;
		} else if (0 == memcmp(priv->bssTransPara.addr, priv->rm_neighbor_report[i].bssid, MACADDRLEN)) {
			break;
		}
	}

	if (i == MAX_NEIGHBOR_REPORT && empty_slot != -1)   /*not found, and has empty slot*/
	{
		i = empty_slot;
	}
#endif

   	panic_printk("(%s)line=%d, i = %d, Channel_Untilization = %d\n", __FUNCTION__, __LINE__, i, priv->bssTransPara.chan_until);
	priv->rm_neighbor_report[i].subelemnt.subelement_id = _WNM_BSS_TRANS_CANDIDATE_PREFRENCE_;
	priv->rm_neighbor_report[i].subelemnt.len = 1;
	priv->rm_neighbor_report[i].subelemnt.preference = priv->bssTransPara.chan_until;
#ifdef RTK_SMART_ROAMING
	process_BssTransReq(priv);
#endif
}
#endif // DOT11K

int issue_BSS_Trans_Req(struct rtl8192cd_priv *priv, unsigned char *da, unsigned char dialog_token)
{	
	int ret;
	unsigned char  *pbuf;
    unsigned int frlen = 0;
	int neighbor_size = 0, i =0;
	unsigned char req_mode = priv->pmib->wnmEntry.dot11vReqMode;
	unsigned short diassoc_time = priv->pmib->wnmEntry.dot11vDiassocDeadline;
	struct stat_info *pstat = get_stainfo(priv, da);
	DECLARE_TXINSN(txinsn);

	DOT11VTRACE("Req mode=%x, diassoc_time = %d, %x\n", req_mode, diassoc_time, cpu_to_le16(diassoc_time));
	
	txinsn.q_num = MANAGE_QUE_NUM;
	txinsn.fr_type = _PRE_ALLOCMEM_;
	txinsn.tx_rate = find_rate(priv, NULL, 0, 1);
#ifndef TX_LOWESTRATE	
	txinsn.lowest_tx_rate = txinsn.tx_rate;
#endif
	txinsn.fixed_rate = 1;

#ifdef CONFIG_IEEE80211W	
	 if (pstat)
		 txinsn.isPMF = pstat->isPMF;
	 else
		 txinsn.isPMF = 0;
#endif
	pbuf = txinsn.pframe = get_mgtbuf_from_poll(priv);
	if (pbuf == NULL)
	    goto issue_wnm_bss_trans_fail;

	txinsn.phdr = get_wlanhdr_from_poll(priv);
	if (txinsn.phdr == NULL)
	    goto issue_wnm_bss_trans_fail;

	memset((void *)(txinsn.phdr), 0, sizeof(struct wlan_hdr));

	pbuf[frlen++]= _WNM_CATEGORY_ID_; 
	pbuf[frlen++] = _BSS_TSMREQ_ACTION_ID_;

	if (!(++pstat->dialog_token))	// dialog token set to a non-zero value
       	pstat->dialog_token++;	
	
	//dialog_token(1): require mode field(1): dissoc timer(2): validity interval(1)
	if (req_mode & (_WNM_PREFERRED_CANDIDATE_LIST_|_WNM_ABRIDGED_)) {
		pbuf[frlen++] = pstat->dialog_token;
		pbuf[frlen++] = req_mode; 	
		*(unsigned short *)(pbuf + frlen) = cpu_to_le16(diassoc_time);
		frlen += 2;
		pbuf[frlen++]  = 200;	//validity interval
		pbuf += frlen;
#ifdef DOT11K
		neighbor_size = sizeof(struct dot11k_neighbor_report);
		for(i = 0; i < MAX_NEIGHBOR_REPORT; i++) {
	   		if((priv->rm_neighbor_bitmask[i>>3] & (1<<(i&7))) == 0)
	    			continue;
	    		if(frlen + neighbor_size > MAX_REPORT_FRAME_SIZE)
	    			break;
	    		
			pbuf = construct_neighbor_report_ie(pbuf, &frlen, &priv->rm_neighbor_report[i]);
	    	}
#endif
	} else {
		panic_printk("Type2 : Bss Trans Req with no neighbor report \n"); 	
		pbuf[frlen++] = pstat->dialog_token;			
		pbuf[frlen++]  = 0; 				
		*(unsigned short *)(pbuf + frlen) = cpu_to_le16(0);	
		frlen += 2;
		pbuf[frlen++]  = 1;					
		pbuf += frlen;
	}
	
	txinsn.fr_len = frlen;
	SetFrameSubType((txinsn.phdr), WIFI_WMM_ACTION);
#ifdef CONFIG_IEEE80211W	
	if (txinsn.isPMF)
		*(unsigned char*)(txinsn.phdr+1) |= BIT(6); // enable privacy 
#endif
   	memcpy((void *)GetAddr1Ptr((txinsn.phdr)), da, MACADDRLEN);
    memcpy((void *)GetAddr2Ptr((txinsn.phdr)), GET_MY_HWADDR, MACADDRLEN);
   	memcpy((void *)GetAddr3Ptr((txinsn.phdr)), BSSID, MACADDRLEN);

#if defined(WIFI_WMM)
   	ret = check_dz_mgmt(priv, pstat, &txinsn);
    
    if (ret < 0)
        goto issue_wnm_bss_trans_fail;
    else if (ret==1)
        return SUCCESS;
    else
#endif
	if ((rtl8192cd_firetx(priv, &txinsn)) == SUCCESS) 
		return SUCCESS;
	
issue_wnm_bss_trans_fail:

	if (txinsn.phdr)
		release_wlanhdr_to_poll(priv, txinsn.phdr);
	if (txinsn.pframe)
		release_mgtbuf_to_poll(priv, txinsn.pframe);

	return FAIL;
}

static void process_status_code( struct stat_info *pstat, unsigned char status_code)
{
	pstat->bssTransStatusCode = status_code;
	
	if(status_code)		
		pstat->bssTransRejectionCount++;

	switch(status_code) {
		case WNM_BSS_TM_ACCEPT:
			panic_printk("Accept: WNM_BSS_TM_ACCEPT![%02x][%02x][%02x][%02x][%02x][%02x] \n", 
						pstat->hwaddr[0], pstat->hwaddr[1], pstat->hwaddr[2], pstat->hwaddr[3], pstat->hwaddr[4], pstat->hwaddr[5]); 
			pstat->bssTransRejectionCount = 0;
			break;
		case WNM_BSS_TM_REJECT_UNSPECIFIED:
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_UNSPECIFIED!\n"); 
			break;
		case WNM_BSS_TM_REJECT_INSUFFICIENT_BEACON: 
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_INSUFFICIENT_BEACON!\n"); 
			break;
		case WNM_BSS_TM_REJECT_INSUFFICIENT_CAPABITY:
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_INSUFFICIENT_CAPABITY!\n"); 
			break;
		case WNM_BSS_TM_REJECT_UNDESIRED :
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_UNDESIRED !\n"); 
			break;
		case WNM_BSS_TM_REJECT_DELAY_REQUEST : 
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_DELAY_REQUEST !\n"); 
			break;
		case WNM_BSS_TM_REJECT_STA_CANDIDATE_LIST_PROVIDED :
			panic_printk("Reject: WNM_BSS_TM_REJECT_STA_CANDIDATE_LIST_PROVIDED !\n"); 
			break;
		case WNM_BSS_TM_REJECT_NO_SUITABLE_CANDIDATES: 
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_NO_SUITABLE_CANDIDATES  !\n"); 
			break;
		case WNM_BSS_TM_REJECT_LEAVING_ESS:
			DOT11VDEBUG("Reject: WNM_BSS_TM_REJECT_LEAVING_ESS  !\n"); 
			break;
		default:
			DOT11VDEBUG("unknown type !\n"); 
			break;
	}
}

void OnBSSTransRsp(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char*pframe, int frame_len)
{
	if (frame_len < 3) {		
		panic_printk("Ignore too short BSS Trans Management RSP!\n"); 
		return;
	}

	int frlen = 0;
	unsigned char dialog_token = pframe[2];
	unsigned char status_code = pframe[3];
	unsigned char bss_termination_delay = pframe[4];	//mins
	frlen = 5;

	if((frame_len - frlen) > MAX_LIST_LEN)	
		return;
	
	DOT11VTRACE("dialog_token = %d, bss_termination_delay = %d\n", dialog_token, bss_termination_delay);
	process_status_code(pstat, status_code);
	pstat->bssTransExpiredTime = 0;	
	pstat->bssTransTriggered = 0;

	if (status_code != WNM_BSS_TM_ACCEPT && checkBssTransDbBsIsEnable(priv)) {
		TriggerBssTransDbBs(priv, pstat);
	}

	if ((frame_len - frlen) > 0) {	
		if (status_code == WNM_BSS_TM_ACCEPT) {
			debug_out("Target BSSID: ", &pframe[frlen], MACADDRLEN);
			frlen += MACADDRLEN;
			debug_out("Bss Trans Candidate List: ", &pframe[frlen], frame_len - frlen);
		} else if (status_code == WNM_BSS_TM_REJECT_DELAY_REQUEST) {
			priv->dot11vDiassocDeadline = bss_termination_delay * 60;
		} else
			debug_out("Bss Trans Candidate List: ", &pframe[frlen], frame_len - frlen);
	} else {
		DEBUG_ERR("WNM: no info in bss trans response!\n");
	}
	
	return;
}

void OnBSSTransQuery(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char*pframe, int frame_len)
{
	if (frame_len < 2) {
		DEBUG_ERR("Ignore too short BSS Transition Management Query!\n"); 		
		return;
	}

	int list_len;
	unsigned char dialog_token = pframe[2];
	unsigned char reason  = pframe[3]; 

	DOT11VTRACE("dialog_token = %d, reason = %d\n", dialog_token, reason); 
	
 	if (reason == _WNM_PREFERED_BSS_TRANS_LIST_INCLUDED_) {
		list_len =   frame_len - 4;
		if (list_len > MAX_LIST_LEN)
			return;

		debug_out("Bss List Len: ", &pframe[list_len], frame_len - list_len);
	} else
		panic_printk("WNM_PREFERED BSS TRANS LIST NOT INCLUDED!\n"); 

	issue_BSS_Trans_Req(priv, pstat->hwaddr, dialog_token);
}

void WNM_ActionHandler(struct rtl8192cd_priv *priv, struct stat_info *pstat, unsigned char *pframe, int frame_len)
{
	unsigned char action_field = pframe[1];

	switch (action_field) {
		case _WNM_TSMQUERY_ACTION_ID_: 
			OnBSSTransQuery(priv, pstat, pframe, frame_len);
			break;
		case _BSS_TSMRSP_ACTION_ID_:
			OnBSSTransRsp(priv, pstat, pframe, frame_len);
			break;
#ifdef CONFIG_IEEE80211V_CLI
		case _BSS_TSMREQ_ACTION_ID_:
			OnBSSTransReq(priv, pstat, pframe, frame_len);
			break;
#endif
		default:
			DEBUG_INFO("Other WNM action: %d:\n", action_field);
			break;
	}
}


