/*
 * Copyright (c) 2017 iComm-semi Ltd.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "turismo_common.h"

const u32 padpd_am_addr_table[5][13]=
                   {{ADR_WIFI_PADPD_2G_GAIN_REG0, 
                     ADR_WIFI_PADPD_2G_GAIN_REG1, 
                     ADR_WIFI_PADPD_2G_GAIN_REG2, 
                     ADR_WIFI_PADPD_2G_GAIN_REG3, 
                     ADR_WIFI_PADPD_2G_GAIN_REG4, 
                     ADR_WIFI_PADPD_2G_GAIN_REG5, 
                     ADR_WIFI_PADPD_2G_GAIN_REG6, 
                     ADR_WIFI_PADPD_2G_GAIN_REG7, 
                     ADR_WIFI_PADPD_2G_GAIN_REG8, 
                     ADR_WIFI_PADPD_2G_GAIN_REG9, 
                     ADR_WIFI_PADPD_2G_GAIN_REGA, 
                     ADR_WIFI_PADPD_2G_GAIN_REGB, 
                     ADR_WIFI_PADPD_2G_GAIN_REGC},                        
                    
                    {ADR_WIFI_PADPD_5100_GAIN_REG0, 
                     ADR_WIFI_PADPD_5100_GAIN_REG1, 
                     ADR_WIFI_PADPD_5100_GAIN_REG2, 
                     ADR_WIFI_PADPD_5100_GAIN_REG3, 
                     ADR_WIFI_PADPD_5100_GAIN_REG4, 
                     ADR_WIFI_PADPD_5100_GAIN_REG5, 
                     ADR_WIFI_PADPD_5100_GAIN_REG6, 
                     ADR_WIFI_PADPD_5100_GAIN_REG7, 
                     ADR_WIFI_PADPD_5100_GAIN_REG8, 
                     ADR_WIFI_PADPD_5100_GAIN_REG9, 
                     ADR_WIFI_PADPD_5100_GAIN_REGA, 
                     ADR_WIFI_PADPD_5100_GAIN_REGB, 
                     ADR_WIFI_PADPD_5100_GAIN_REGC},
                   
                   { ADR_WIFI_PADPD_5500_GAIN_REG0, 
                     ADR_WIFI_PADPD_5500_GAIN_REG1, 
                     ADR_WIFI_PADPD_5500_GAIN_REG2, 
                     ADR_WIFI_PADPD_5500_GAIN_REG3, 
                     ADR_WIFI_PADPD_5500_GAIN_REG4, 
                     ADR_WIFI_PADPD_5500_GAIN_REG5, 
                     ADR_WIFI_PADPD_5500_GAIN_REG6, 
                     ADR_WIFI_PADPD_5500_GAIN_REG7, 
                     ADR_WIFI_PADPD_5500_GAIN_REG8, 
                     ADR_WIFI_PADPD_5500_GAIN_REG9, 
                     ADR_WIFI_PADPD_5500_GAIN_REGA, 
                     ADR_WIFI_PADPD_5500_GAIN_REGB, 
                     ADR_WIFI_PADPD_5500_GAIN_REGC},
                   
                   { ADR_WIFI_PADPD_5700_GAIN_REG0, 
                     ADR_WIFI_PADPD_5700_GAIN_REG1, 
                     ADR_WIFI_PADPD_5700_GAIN_REG2, 
                     ADR_WIFI_PADPD_5700_GAIN_REG3, 
                     ADR_WIFI_PADPD_5700_GAIN_REG4, 
                     ADR_WIFI_PADPD_5700_GAIN_REG5, 
                     ADR_WIFI_PADPD_5700_GAIN_REG6, 
                     ADR_WIFI_PADPD_5700_GAIN_REG7, 
                     ADR_WIFI_PADPD_5700_GAIN_REG8, 
                     ADR_WIFI_PADPD_5700_GAIN_REG9, 
                     ADR_WIFI_PADPD_5700_GAIN_REGA, 
                     ADR_WIFI_PADPD_5700_GAIN_REGB, 
                     ADR_WIFI_PADPD_5700_GAIN_REGC},
                   
                   { ADR_WIFI_PADPD_5900_GAIN_REG0, 
                     ADR_WIFI_PADPD_5900_GAIN_REG1, 
                     ADR_WIFI_PADPD_5900_GAIN_REG2, 
                     ADR_WIFI_PADPD_5900_GAIN_REG3, 
                     ADR_WIFI_PADPD_5900_GAIN_REG4, 
                     ADR_WIFI_PADPD_5900_GAIN_REG5, 
                     ADR_WIFI_PADPD_5900_GAIN_REG6, 
                     ADR_WIFI_PADPD_5900_GAIN_REG7, 
                     ADR_WIFI_PADPD_5900_GAIN_REG8, 
                     ADR_WIFI_PADPD_5900_GAIN_REG9, 
                     ADR_WIFI_PADPD_5900_GAIN_REGA, 
                     ADR_WIFI_PADPD_5900_GAIN_REGB, 
                     ADR_WIFI_PADPD_5900_GAIN_REGC}};

const u32 padpd_pm_addr_table[5][13]=
                   {{ADR_WIFI_PADPD_2G_PHASE_REG0 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG1 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG2 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG3 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG4 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG5 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG6 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG7 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG8 ,
                     ADR_WIFI_PADPD_2G_PHASE_REG9 ,
                     ADR_WIFI_PADPD_2G_PHASE_REGA ,
                     ADR_WIFI_PADPD_2G_PHASE_REGB ,
                     ADR_WIFI_PADPD_2G_PHASE_REGC },

                   {ADR_WIFI_PADPD_5100_PHASE_REG0,
                    ADR_WIFI_PADPD_5100_PHASE_REG1,
                    ADR_WIFI_PADPD_5100_PHASE_REG2,
                    ADR_WIFI_PADPD_5100_PHASE_REG3,
                    ADR_WIFI_PADPD_5100_PHASE_REG4,
                    ADR_WIFI_PADPD_5100_PHASE_REG5,
                    ADR_WIFI_PADPD_5100_PHASE_REG6,
                    ADR_WIFI_PADPD_5100_PHASE_REG7,
                    ADR_WIFI_PADPD_5100_PHASE_REG8,
                    ADR_WIFI_PADPD_5100_PHASE_REG9,
                    ADR_WIFI_PADPD_5100_PHASE_REGA,
                    ADR_WIFI_PADPD_5100_PHASE_REGB,
                    ADR_WIFI_PADPD_5100_PHASE_REGC},
                                                  
                   {ADR_WIFI_PADPD_5500_PHASE_REG0,
                    ADR_WIFI_PADPD_5500_PHASE_REG1,
                    ADR_WIFI_PADPD_5500_PHASE_REG2,
                    ADR_WIFI_PADPD_5500_PHASE_REG3,
                    ADR_WIFI_PADPD_5500_PHASE_REG4,
                    ADR_WIFI_PADPD_5500_PHASE_REG5,
                    ADR_WIFI_PADPD_5500_PHASE_REG6,
                    ADR_WIFI_PADPD_5500_PHASE_REG7,
                    ADR_WIFI_PADPD_5500_PHASE_REG8,
                    ADR_WIFI_PADPD_5500_PHASE_REG9,
                    ADR_WIFI_PADPD_5500_PHASE_REGA,
                    ADR_WIFI_PADPD_5500_PHASE_REGB,
                    ADR_WIFI_PADPD_5500_PHASE_REGC},
                                                  
                   {ADR_WIFI_PADPD_5700_PHASE_REG0,
                    ADR_WIFI_PADPD_5700_PHASE_REG1,
                    ADR_WIFI_PADPD_5700_PHASE_REG2,
                    ADR_WIFI_PADPD_5700_PHASE_REG3,
                    ADR_WIFI_PADPD_5700_PHASE_REG4,
                    ADR_WIFI_PADPD_5700_PHASE_REG5,
                    ADR_WIFI_PADPD_5700_PHASE_REG6,
                    ADR_WIFI_PADPD_5700_PHASE_REG7,
                    ADR_WIFI_PADPD_5700_PHASE_REG8,
                    ADR_WIFI_PADPD_5700_PHASE_REG9,
                    ADR_WIFI_PADPD_5700_PHASE_REGA,
                    ADR_WIFI_PADPD_5700_PHASE_REGB,
                    ADR_WIFI_PADPD_5700_PHASE_REGC},
                                                  
                   {ADR_WIFI_PADPD_5900_PHASE_REG0,
                    ADR_WIFI_PADPD_5900_PHASE_REG1,
                    ADR_WIFI_PADPD_5900_PHASE_REG2,
                    ADR_WIFI_PADPD_5900_PHASE_REG3,
                    ADR_WIFI_PADPD_5900_PHASE_REG4,
                    ADR_WIFI_PADPD_5900_PHASE_REG5,
                    ADR_WIFI_PADPD_5900_PHASE_REG6,
                    ADR_WIFI_PADPD_5900_PHASE_REG7,
                    ADR_WIFI_PADPD_5900_PHASE_REG8,
                    ADR_WIFI_PADPD_5900_PHASE_REG9,
                    ADR_WIFI_PADPD_5900_PHASE_REGA,
                    ADR_WIFI_PADPD_5900_PHASE_REGB,
                    ADR_WIFI_PADPD_5900_PHASE_REGC}};

const u8 pkt1614[] ={
         0x4e, 0x06, 0x3a, 0x00, 0x71, 0x00, 0x00, 0x00, 0x50, 0x6a, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
         0x2c, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x40, 0x00, 0xf7, 0x84, 0x00, 0x00, 0x4e, 0x10, 0x11, 0x00,
         0xf6, 0x84, 0x00, 0x00, 0x54, 0x20, 0x00, 0x00, 0xe5, 0x84, 0x08, 0x01, 0x66, 0x20, 0x14, 0x00,
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  
         0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,         
         0x88, 0x01, 0x2c, 0x00, 0xe4, 0xf4, 0xc6, 0x03, 0x5f, 0x49, 0x00, 0xaa, 0xb5, 0xc7, 0xd7, 0xf6, 
         0xf0, 0xde, 0xf1, 0x75, 0x05, 0x9d, 0xc0, 0x26, 0x00, 0x00, 0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00, 
         0x08, 0x00, 0x45, 0x00, 0x05, 0xdc, 0x50, 0x02, 0x40, 0x00, 0x40, 0x06, 0x61, 0xa4, 0xc0, 0xa8, 
         0x01, 0x21, 0xc0, 0xa8, 0x01, 0x04, 0xc3, 0xa1, 0x13, 0x89, 0x1c, 0x24, 0xdb, 0x71, 0x80, 0x8c, 
         0xa5, 0x83, 0x80, 0x10, 0x00, 0xe5, 0x69, 0xdf, 0x00, 0x00, 0x01, 0x01, 0x08, 0x0a, 0x00, 0xd3, 
         0x02, 0xe2, 0x22, 0xc7, 0xbf, 0x14, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 
         0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 
         0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 
         0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 
         0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 
         0x38, 0x39, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x30, 0x31, };        

int ssv6006_get_pa_band(int ch)
{
    int pa_band = 0;
    
    if (ch <= 14) {
        pa_band = BAND_2G;
    } else if (ch < 36) {
        pa_band = BAND_5100;
    } else if ((ch >= 36) && (ch < 100)) {
        pa_band = BAND_5500;
    } else if ((ch >= 100) && (ch < 140)) {
        pa_band = BAND_5700;
    } else if (ch >= 140) {
        pa_band = BAND_5900;        
    }
    return pa_band;
}

