/*
 * Copyright 2002-2004, Instant802 Networks, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef WPA_H
#define WPA_H

#include <linux/skbuff.h>
#include <linux/types.h>
#include "ieee80211_i.h"

ieee80211_tx_result
mac80211_tx_h_xrmac_michael_mic_add(struct ieee80211_tx_data *tx);
ieee80211_rx_result
ieee80211_rx_h_xrmac_michael_mic_verify(struct ieee80211_rx_data *rx);

ieee80211_tx_result
mac80211_crypto_tkip_encrypt(struct ieee80211_tx_data *tx);
ieee80211_rx_result
mac80211_crypto_tkip_decrypt(struct ieee80211_rx_data *rx);

ieee80211_tx_result
mac80211_crypto_ccmp_encrypt(struct ieee80211_tx_data *tx);
ieee80211_rx_result
mac80211_crypto_ccmp_decrypt(struct ieee80211_rx_data *rx);

ieee80211_tx_result
mac80211_crypto_aes_cmac_encrypt(struct ieee80211_tx_data *tx);
ieee80211_rx_result
mac80211_crypto_aes_cmac_decrypt(struct ieee80211_rx_data *rx);

#endif /* WPA_H */
