#ifndef ZV_NET_H
#define ZV_NET_H

#include <linux/interrupt.h>
#include <linux/kthread.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <linux/soc/zte/rpm/rpmsg.h>

//#define ZVNET_DEBUG
#ifdef ZVNET_DEBUG
#define zv_dbg(format, arg...) printk(KERN_DEBUG "[zvnet]<%s>: " format "\n" , \
	__func__ , ## arg)
#define zv_info(format, arg...) printk(KERN_INFO "[zvnet]<%s>: " format "\n" , \
	__func__ , ## arg)
#else
#define zv_dbg(format, arg...) do {} while (0)
#define zv_info(format, arg...) do {} while (0)
#endif

#define zv_err(format, arg...) printk(KERN_ERR "[zvnet]<%s>: " format "\n" , \
	__func__ , ## arg)

#define zv_warn(format, arg...) printk(KERN_WARNING "[zvnet]<%s>: " format "\n" , \
	__func__ , ## arg)

//zvnet豸
#define DDR_ZVNET_DEV_MAX 16
#define ZVNET_IFNAME_PREFIX "zvnet"

#define ICP_CHN_ZVNET1 channel_20
#define ICP_CHN_ZVNET2 channel_21
#define ICP_CHN_ZVNET3 channel_22
#define ICP_CHN_ZVNET4 channel_23

#define	ICP_CHANNEL_SIZE 	(8 * 1024 *2)

#define zvnetCreateChannel zDrvRpMsg_CreateChannel_Cap //zDrvRpMsg_CreateChannel
#define zvnetWrite zDrvRpMsg_Write_Cap //zDrvRpMsg_Write
#define zvnetRead zDrvRpMsg_Read_Cap //zDrvRpMsg_Read

extern int zDrvRpMsg_WriteLockIrq_Cap(const T_ZDrvRpMsg_Msg *pMsg);
#define zvnetWriteLockIrq zDrvRpMsg_WriteLockIrq_Cap

struct zvnet_channel {
    T_ZDrvRpMsg_ActorID core_id;
    T_ZDrvRpMsg_ChID channel_id;
    unsigned int channel_size;
    struct task_struct *rcv_thread;
};

struct zvnet {
    struct net_device  *net;
    struct sk_buff_head rxq;
    struct tasklet_struct bh;
    void *dev_priv;
};

struct zvnet_device {
    struct zvnet *dev;
    struct net_device *net;
    //struct zvnet_channel chn_info;
    unsigned char retran_times;
    //int (*write)(struct sk_buff *,struct v2x_hdr *, unsigned int, struct net_device *);
};

struct zvp_header {
    unsigned int magic_word;
    unsigned short chnid;
    unsigned short tlen;
};

#define ZVP_MAGIC_WORD 0x5A5A5A5A
#define ZVP_HEAD_LEN   sizeof(struct zvp_header)

#endif

