/*
** Copyright (c) 2015-2015 by Silicon Laboratories
**
** $Id: si3218x_registers.h 5475 2016-01-18 16:00:13Z elgeorge $
**
** Distributed by:
** Silicon Laboratories, Inc
**
** This file contains proprietary information.
** No dissemination allowed without prior written permission from
** Silicon Laboratories, Inc.
**/

#ifndef SI3218X_REGS_H
#define SI3218X_REGS_H

/*
** SI3218X SPI Registers
*/
enum SI3218X_REG
{
  SI3218X_REG_ID                       = 0,
  SI3218X_REG_RESET                    = 1,
  SI3218X_REG_MSTREN                   = 2,
  SI3218X_REG_MSTRSTAT                 = 3,
  SI3218X_REG_RAMSTAT                  = 4,
  SI3218X_REG_RAM_ADDR_HI              = 5,
  SI3218X_REG_RAM_DATA_B0              = 6,
  SI3218X_REG_RAM_DATA_B1              = 7,
  SI3218X_REG_RAM_DATA_B2              = 8,
  SI3218X_REG_RAM_DATA_B3              = 9,
  SI3218X_REG_RAM_ADDR_LO              = 10,
  SI3218X_REG_PCMMODE                  = 11,
  SI3218X_REG_PCMTXLO                  = 12,
  SI3218X_REG_PCMTXHI                  = 13,
  SI3218X_REG_PCMRXLO                  = 14,
  SI3218X_REG_PCMRXHI                  = 15,
  SI3218X_REG_IRQ                      = 16,
  SI3218X_REG_IRQ0                     = 17,
  SI3218X_REG_IRQ1                     = 18,
  SI3218X_REG_IRQ2                     = 19,
  SI3218X_REG_IRQ3                     = 20,
  SI3218X_REG_IRQ4                     = 21,
  SI3218X_REG_IRQEN1                   = 22,
  SI3218X_REG_IRQEN2                   = 23,
  SI3218X_REG_IRQEN3                   = 24,
  SI3218X_REG_IRQEN4                   = 25,
  SI3218X_REG_CALR0                    = 26,
  SI3218X_REG_CALR1                    = 27,
  SI3218X_REG_CALR2                    = 28,
  SI3218X_REG_CALR3                    = 29,
  SI3218X_REG_LINEFEED                 = 30,
  SI3218X_REG_POLREV                   = 31,
  SI3218X_REG_SPEEDUP_DIS              = 32,
  SI3218X_REG_SPEEDUP                  = 33,
  SI3218X_REG_LCRRTP                   = 34,
  SI3218X_REG_OFFLOAD                  = 35,
  SI3218X_REG_BATSELMAP                = 36,
  SI3218X_REG_BATSEL                   = 37,
  SI3218X_REG_RINGCON                  = 38,
  SI3218X_REG_RINGTALO                 = 39,
  SI3218X_REG_RINGTAHI                 = 40,
  SI3218X_REG_RINGTILO                 = 41,
  SI3218X_REG_RINGTIHI                 = 42,
  SI3218X_REG_LOOPBACK                 = 43,
  SI3218X_REG_DIGCON                   = 44,
  SI3218X_REG_RA                       = 45,
  SI3218X_REG_ZCAL_EN                  = 46,
  SI3218X_REG_ENHANCE                  = 47,
  SI3218X_REG_OMODE                    = 48,
  SI3218X_REG_OCON                     = 49,
  SI3218X_REG_O1TALO                   = 50,
  SI3218X_REG_O1TAHI                   = 51,
  SI3218X_REG_O1TILO                   = 52,
  SI3218X_REG_O1TIHI                   = 53,
  SI3218X_REG_O2TALO                   = 54,
  SI3218X_REG_O2TAHI                   = 55,
  SI3218X_REG_O2TILO                   = 56,
  SI3218X_REG_O2TIHI                   = 57,
  SI3218X_REG_FSKDAT                   = 58,
  SI3218X_REG_FSKDEPTH                 = 59,
  SI3218X_REG_TONDTMF                  = 60,
  SI3218X_REG_TONDET                   = 61,
  SI3218X_REG_TONEN                    = 62,
  SI3218X_REG_GCI_CI                   = 63,
  SI3218X_REG_GLOBSTAT1                = 64,
  SI3218X_REG_GLOBSTAT2                = 65,
  SI3218X_REG_USERSTAT                 = 66,
  SI3218X_REG_GPIO_CFG1				   = 68,
  SI3218X_REG_DIAG1                    = 71,
  SI3218X_REG_DIAG2                    = 72,
  SI3218X_REG_CM_CLAMP                 = 73,
  SI3218X_REG_DIAG3                    = 74,
  SI3218X_REG_PMCON                    = 75,
  SI3218X_REG_PCLK_FAULT_CNTL          = 76,
  SI3218X_REG_AUTO                     = 80,
  SI3218X_REG_JMPEN                    = 81,
  SI3218X_REG_JMP0LO                   = 82,
  SI3218X_REG_JMP0HI                   = 83,
  SI3218X_REG_JMP1LO                   = 84,
  SI3218X_REG_JMP1HI                   = 85,
  SI3218X_REG_JMP2LO                   = 86,
  SI3218X_REG_JMP2HI                   = 87,
  SI3218X_REG_JMP3LO                   = 88,
  SI3218X_REG_JMP3HI                   = 89,
  SI3218X_REG_JMP4LO                   = 90,
  SI3218X_REG_JMP4HI                   = 91,
  SI3218X_REG_JMP5LO                   = 92,
  SI3218X_REG_JMP5HI                   = 93,
  SI3218X_REG_JMP6LO                   = 94,
  SI3218X_REG_JMP6HI                   = 95,
  SI3218X_REG_JMP7LO                   = 96,
  SI3218X_REG_JMP7HI                   = 97,
  SI3218X_REG_PDN                      = 98,
  SI3218X_REG_PDN_STAT                 = 99,
  SI3218X_REG_PDN2                     = 100,
  SI3218X_REG_PDN2_STAT                = 101,
  SI3218X_REG_M1_OSC_LO                = 112,
  SI3218X_REG_M1_OSC_HI                = 113,
  SI3218X_REG_BITCNT_LO                = 114,
  SI3218X_REG_BITCNT_HI                = 115,
  SI3218X_REG_PCLK_MULT                = 116,
  SI3218X_REG_RAM_DATA_16              = 117,
  SI3218X_REG_BYPASS_ADDR_LO           = 118,
  SI3218X_REG_BYPASS_ADDR_HI           = 119,
  SI3218X_REG_PC_LO                    = 120,
  SI3218X_REG_PC_HI                    = 121,
  SI3218X_REG_PC_SHAD_LO               = 122,
  SI3218X_REG_PC_SHAD_HI               = 123,
  SI3218X_REG_PASS_LO                  = 124,
  SI3218X_REG_PASS_HI                  = 125,
  SI3218X_REG_TEST_CNTL                = 126,
  SI3218X_REG_TEST_MODE                = 127,
};

/*
** SI3218X_RAM
*/
enum SI3218X_RAM
{
  SI3218X_RAM_IRNGNG_SENSE             = 0,
  SI3218X_RAM_MADC_VTIPC               = 1,
  SI3218X_RAM_MADC_VRINGC              = 2,
  SI3218X_RAM_MADC_VBAT                = 3,
  SI3218X_RAM_MADC_VLONG               = 4,
  SI3218X_RAM_UNUSED5                  = 5,
  SI3218X_RAM_MADC_VDC                 = 6,
  SI3218X_RAM_MADC_ILONG               = 7,
  SI3218X_RAM_MADC_ITIP                = 8,
  SI3218X_RAM_MADC_IRING               = 9,
  SI3218X_RAM_MADC_ILOOP               = 10,
  SI3218X_RAM_VDIFF_SENSE              = 11,
  SI3218X_RAM_VTIP                     = 12,
  SI3218X_RAM_VRING                    = 13,
  SI3218X_RAM_P_Q1_D                   = 14,
  SI3218X_RAM_INIT_GUESS               = 15,
  SI3218X_RAM_Y1                       = 16,
  SI3218X_RAM_Y2                       = 17,
  SI3218X_RAM_Y3                       = 18,
  SI3218X_RAM_UNUSED19                 = 19,
  SI3218X_RAM_P_Q1                     = 20,
  SI3218X_RAM_DIAG_EX1                 = 21,
  SI3218X_RAM_DIAG_EX2                 = 22,
  SI3218X_RAM_DIAG_LPF_MADC            = 23,
  SI3218X_RAM_DIAG_DMM_I               = 24,
  SI3218X_RAM_DIAG_DMM_V               = 25,
  SI3218X_RAM_OSC1FREQ                 = 26,
  SI3218X_RAM_OSC1AMP                  = 27,
  SI3218X_RAM_OSC1PHAS                 = 28,
  SI3218X_RAM_OSC2FREQ                 = 29,
  SI3218X_RAM_OSC2AMP                  = 30,
  SI3218X_RAM_OSC2PHAS                 = 31,
  SI3218X_RAM_TESTB0_1                 = 32,
  SI3218X_RAM_TESTB1_1                 = 33,
  SI3218X_RAM_TESTB2_1                 = 34,
  SI3218X_RAM_TESTA1_1                 = 35,
  SI3218X_RAM_TESTA2_1                 = 36,
  SI3218X_RAM_TESTB0_2                 = 37,
  SI3218X_RAM_TESTB1_2                 = 38,
  SI3218X_RAM_TESTB2_2                 = 39,
  SI3218X_RAM_TESTA1_2                 = 40,
  SI3218X_RAM_TESTA2_2                 = 41,
  SI3218X_RAM_TESTB0_3                 = 42,
  SI3218X_RAM_TESTB1_3                 = 43,
  SI3218X_RAM_TESTB2_3                 = 44,
  SI3218X_RAM_TESTA1_3                 = 45,
  SI3218X_RAM_TESTA2_3                 = 46,
  SI3218X_RAM_TESTPKO                  = 47,
  SI3218X_RAM_TESTABO                  = 48,
  SI3218X_RAM_TESTWLN                  = 49,
  SI3218X_RAM_TESTAVBW                 = 50,
  SI3218X_RAM_TESTPKFL                 = 51,
  SI3218X_RAM_TESTAVFL                 = 52,
  SI3218X_RAM_TESTPKTH                 = 53,
  SI3218X_RAM_TESTAVTH                 = 54,
  SI3218X_RAM_DAC_IN_SYNC1             = 55,
  SI3218X_RAM_BYPASS_REG               = 56,
  SI3218X_RAM_LCRMASK_CNT              = 57,
  SI3218X_RAM_DAC_IN_SYNC              = 58,
  SI3218X_RAM_TEMP                     = 59,
  SI3218X_RAM_TEMP_ISR                 = 60,
  SI3218X_RAM_P_Q2                     = 61,
  SI3218X_RAM_P_Q3                     = 62,
  SI3218X_RAM_P_Q4                     = 63,
  SI3218X_RAM_P_Q5                     = 64,
  SI3218X_RAM_P_Q6                     = 65,
  SI3218X_RAM_ILOOP_FILT               = 66,
  SI3218X_RAM_ILONG_FILT               = 67,
  SI3218X_RAM_VBAT_FILT                = 68,
  SI3218X_RAM_VDIFF_FILT               = 69,
  SI3218X_RAM_VCM_FILT                 = 70,
  SI3218X_RAM_VBAT_CNT                 = 71,
  SI3218X_RAM_V_VLIM_SCALED            = 72,
  SI3218X_RAM_V_VLIM_TRACK             = 73,
  SI3218X_RAM_V_VLIM_MODFEED           = 74,
  SI3218X_RAM_DIAG_P_OUT               = 75,
  SI3218X_RAM_DIAG_COUNT               = 76,
  SI3218X_RAM_ROW0_MAG                 = 77,
  SI3218X_RAM_ROW1_MAG                 = 78,
  SI3218X_RAM_ROW2_MAG                 = 79,
  SI3218X_RAM_ROW3_MAG                 = 80,
  SI3218X_RAM_COL0_MAG                 = 81,
  SI3218X_RAM_COL1_MAG                 = 82,
  SI3218X_RAM_COL2_MAG                 = 83,
  SI3218X_RAM_COL3_MAG                 = 84,
  SI3218X_RAM_ROW0_2ND_Y1              = 85,
  SI3218X_RAM_ROW1_2ND_Y1              = 86,
  SI3218X_RAM_ROW2_2ND_Y1              = 87,
  SI3218X_RAM_ROW3_2ND_Y1              = 88,
  SI3218X_RAM_COL0_2ND_Y1              = 89,
  SI3218X_RAM_COL1_2ND_Y1              = 90,
  SI3218X_RAM_COL2_2ND_Y1              = 91,
  SI3218X_RAM_COL3_2ND_Y1              = 92,
  SI3218X_RAM_ROW0_2ND_Y2              = 93,
  SI3218X_RAM_ROW1_2ND_Y2              = 94,
  SI3218X_RAM_ROW2_2ND_Y2              = 95,
  SI3218X_RAM_ROW3_2ND_Y2              = 96,
  SI3218X_RAM_COL0_2ND_Y2              = 97,
  SI3218X_RAM_COL1_2ND_Y2              = 98,
  SI3218X_RAM_COL2_2ND_Y2              = 99,
  SI3218X_RAM_COL3_2ND_Y2              = 100,
  SI3218X_RAM_DTMF_IN                  = 101,
  SI3218X_RAM_DTMFDTF_D2_1             = 102,
  SI3218X_RAM_DTMFDTF_D1_1             = 103,
  SI3218X_RAM_DTMFDTF_OUT_1            = 104,
  SI3218X_RAM_DTMFDTF_D2_2             = 105,
  SI3218X_RAM_DTMFDTF_D1_2             = 106,
  SI3218X_RAM_DTMFDTF_OUT_2            = 107,
  SI3218X_RAM_DTMFDTF_D2_3             = 108,
  SI3218X_RAM_DTMFDTF_D1_3             = 109,
  SI3218X_RAM_DTMFDTF_OUT_3            = 110,
  SI3218X_RAM_DTMFDTF_OUT              = 111,
  SI3218X_RAM_DTMFLPF_D2_1             = 112,
  SI3218X_RAM_DTMFLPF_D1_1             = 113,
  SI3218X_RAM_DTMFLPF_OUT_1            = 114,
  SI3218X_RAM_DTMFLPF_D2_2             = 115,
  SI3218X_RAM_DTMFLPF_D1_2             = 116,
  SI3218X_RAM_DTMFLPF_OUT_2            = 117,
  SI3218X_RAM_DTMF_ROW                 = 118,
  SI3218X_RAM_DTMFHPF_D2_1             = 119,
  SI3218X_RAM_DTMFHPF_D1_1             = 120,
  SI3218X_RAM_DTMFHPF_OUT_1            = 121,
  SI3218X_RAM_DTMFHPF_D2_2             = 122,
  SI3218X_RAM_DTMFHPF_D1_2             = 123,
  SI3218X_RAM_DTMFHPF_OUT_2            = 124,
  SI3218X_RAM_DTMF_COL                 = 125,
  SI3218X_RAM_ROW_POWER                = 126,
  SI3218X_RAM_COL_POWER                = 127,
  SI3218X_RAM_GP_TIMER                 = 128,
  SI3218X_RAM_SPR_INTERP_DIF           = 129,
  SI3218X_RAM_SPR_INTERP_DIF_OUT       = 130,
  SI3218X_RAM_SPR_INTERP_INT           = 131,
  SI3218X_RAM_SPR_CNT                  = 132,
  SI3218X_RAM_ROW0_Y1                  = 133,
  SI3218X_RAM_ROW0_Y2                  = 134,
  SI3218X_RAM_ROW1_Y1                  = 135,
  SI3218X_RAM_ROW1_Y2                  = 136,
  SI3218X_RAM_ROW2_Y1                  = 137,
  SI3218X_RAM_ROW2_Y2                  = 138,
  SI3218X_RAM_ROW3_Y1                  = 139,
  SI3218X_RAM_ROW3_Y2                  = 140,
  SI3218X_RAM_COL0_Y1                  = 141,
  SI3218X_RAM_COL0_Y2                  = 142,
  SI3218X_RAM_COL1_Y1                  = 143,
  SI3218X_RAM_COL1_Y2                  = 144,
  SI3218X_RAM_COL2_Y1                  = 145,
  SI3218X_RAM_COL2_Y2                  = 146,
  SI3218X_RAM_COL3_Y1                  = 147,
  SI3218X_RAM_COL3_Y2                  = 148,
  SI3218X_RAM_ROWMAX_MAG               = 149,
  SI3218X_RAM_COLMAX_MAG               = 150,
  SI3218X_RAM_ROW0_2ND_MAG             = 151,
  SI3218X_RAM_COL0_2ND_MAG             = 152,
  SI3218X_RAM_ROW_THR                  = 153,
  SI3218X_RAM_COL_THR                  = 154,
  SI3218X_RAM_OSC1_Y                   = 155,
  SI3218X_RAM_OSC2_Y                   = 156,
  SI3218X_RAM_OSC1_X                   = 157,
  SI3218X_RAM_OSC1_COEFF               = 158,
  SI3218X_RAM_OSC2_X                   = 159,
  SI3218X_RAM_OSC2_COEFF               = 160,
  SI3218X_RAM_RXACIIR_D2_1             = 161,
  SI3218X_RAM_RXACIIR_OUT_1            = 162,
  SI3218X_RAM_RXACIIR_D2_2             = 163,
  SI3218X_RAM_RXACIIR_D1_2             = 164,
  SI3218X_RAM_RXACIIR_OUT_2            = 165,
  SI3218X_RAM_RXACIIR_D2_3             = 166,
  SI3218X_RAM_RXACIIR_D1_3             = 167,
  SI3218X_RAM_RXACIIR_OUT              = 168,
  SI3218X_RAM_RXACIIR_OUT_3            = 169,
  SI3218X_RAM_TXACCOMB_D1              = 170,
  SI3218X_RAM_TXACCOMB_D2              = 171,
  SI3218X_RAM_TXACCOMB_D3              = 172,
  SI3218X_RAM_TXACSINC_OUT             = 173,
  SI3218X_RAM_TXACHPF_D1_2             = 174,
  SI3218X_RAM_TXACHPF_D2_1             = 175,
  SI3218X_RAM_TXACHPF_D2_2             = 176,
  SI3218X_RAM_TXACHPF_OUT              = 177,
  SI3218X_RAM_TXACHPF_OUT_1            = 178,
  SI3218X_RAM_TXACHPF_OUT_2            = 179,
  SI3218X_RAM_TXACIIR_D2_1             = 180,
  SI3218X_RAM_TXACIIR_OUT_1            = 181,
  SI3218X_RAM_TXACIIR_D2_2             = 182,
  SI3218X_RAM_TXACIIR_D1_2             = 183,
  SI3218X_RAM_TXACIIR_OUT_2            = 184,
  SI3218X_RAM_TXACIIR_D2_3             = 185,
  SI3218X_RAM_TXACIIR_D1_3             = 186,
  SI3218X_RAM_TXACIIR_OUT_3            = 187,
  SI3218X_RAM_TXACIIR_OUT              = 188,
  SI3218X_RAM_ECIIR_D1                 = 189,
  SI3218X_RAM_ECIIR_D2                 = 190,
  SI3218X_RAM_EC_DELAY1                = 191,
  SI3218X_RAM_EC_DELAY2                = 192,
  SI3218X_RAM_EC_DELAY3                = 193,
  SI3218X_RAM_EC_DELAY4                = 194,
  SI3218X_RAM_EC_DELAY5                = 195,
  SI3218X_RAM_EC_DELAY6                = 196,
  SI3218X_RAM_EC_DELAY7                = 197,
  SI3218X_RAM_EC_DELAY8                = 198,
  SI3218X_RAM_EC_DELAY9                = 199,
  SI3218X_RAM_EC_DELAY10               = 200,
  SI3218X_RAM_EC_DELAY11               = 201,
  SI3218X_RAM_ECHO_EST                 = 202,
  SI3218X_RAM_EC_OUT                   = 203,
  SI3218X_RAM_TESTFILT_OUT_1           = 204,
  SI3218X_RAM_TESTFILT_D1_1            = 205,
  SI3218X_RAM_TESTFILT_D2_1            = 206,
  SI3218X_RAM_TESTFILT_OUT_2           = 207,
  SI3218X_RAM_TESTFILT_D1_2            = 208,
  SI3218X_RAM_TESTFILT_D2_2            = 209,
  SI3218X_RAM_TESTFILT_OUT_3           = 210,
  SI3218X_RAM_TESTFILT_D1_3            = 211,
  SI3218X_RAM_TESTFILT_D2_3            = 212,
  SI3218X_RAM_TESTFILT_PEAK            = 213,
  SI3218X_RAM_TESTFILT_ABS             = 214,
  SI3218X_RAM_TESTFILT_MEANACC         = 215,
  SI3218X_RAM_TESTFILT_COUNT           = 216,
  SI3218X_RAM_TESTFILT_NO_OFFSET       = 217,
  SI3218X_RAM_RING_X                   = 218,
  SI3218X_RAM_RING_Y                   = 219,
  SI3218X_RAM_RING_INT                 = 220,
  SI3218X_RAM_RING_Y_D1                = 221,
  SI3218X_RAM_RING_DIFF                = 222,
  SI3218X_RAM_RING_DELTA               = 223,
  SI3218X_RAM_WTCHDOG_CNT              = 224,
  SI3218X_RAM_RING_WAVE                = 225,
  SI3218X_RAM_UNUSED226                = 226,
  SI3218X_RAM_ONEKHZ_COUNT             = 227,
  SI3218X_RAM_TX2100_Y1                = 228,
  SI3218X_RAM_TX2100_Y2                = 229,
  SI3218X_RAM_TX2100_MAG               = 230,
  SI3218X_RAM_RX2100_Y1                = 231,
  SI3218X_RAM_RX2100_Y2                = 232,
  SI3218X_RAM_RX2100_MAG               = 233,
  SI3218X_RAM_TX2100_POWER             = 234,
  SI3218X_RAM_RX2100_POWER             = 235,
  SI3218X_RAM_TX2100_IN                = 236,
  SI3218X_RAM_RX2100_IN                = 237,
  SI3218X_RAM_RINGTRIP_COUNT           = 238,
  SI3218X_RAM_RINGTRIP_DC1             = 239,
  SI3218X_RAM_RINGTRIP_DC2             = 240,
  SI3218X_RAM_RINGTRIP_AC1             = 241,
  SI3218X_RAM_RINGTRIP_AC2             = 242,
  SI3218X_RAM_RINGTRIP_AC_COUNT        = 243,
  SI3218X_RAM_RINGTRIP_DC_COUNT        = 244,
  SI3218X_RAM_RINGTRIP_AC_RESULT       = 245,
  SI3218X_RAM_RINGTRIP_DC_RESULT       = 246,
  SI3218X_RAM_RINGTRIP_ABS             = 247,
  SI3218X_RAM_TXACEQ_OUT               = 248,
  SI3218X_RAM_LCR_DBI_CNT              = 249,
  SI3218X_RAM_BAT_DBI_CNT              = 250,
  SI3218X_RAM_LONG_DBI_CNT             = 251,
  SI3218X_RAM_TXACEQ_DELAY3            = 252,
  SI3218X_RAM_TXACEQ_DELAY2            = 253,
  SI3218X_RAM_TXACEQ_DELAY1            = 254,
  SI3218X_RAM_RXACEQ_DELAY3            = 255,
  SI3218X_RAM_RXACEQ_DELAY2            = 256,
  SI3218X_RAM_RXACEQ_DELAY1            = 257,
  SI3218X_RAM_RXACEQ_IN                = 258,
  SI3218X_RAM_TXDCCOMB_D1              = 259,
  SI3218X_RAM_TXDCCOMB_D2              = 260,
  SI3218X_RAM_TXDCSINC_OUT             = 261,
  SI3218X_RAM_RXACDIFF_D1              = 262,
  SI3218X_RAM_DC_NOTCH_1               = 263,
  SI3218X_RAM_DC_NOTCH_2               = 264,
  SI3218X_RAM_DC_NOTCH_OUT             = 265,
  SI3218X_RAM_DC_NOTCH_SCALED          = 266,
  SI3218X_RAM_V_FEED_IN                = 267,
  SI3218X_RAM_I_TAR                    = 268,
  SI3218X_RAM_CONST_VLIM               = 269,
  SI3218X_RAM_UNITY                    = 270,
  SI3218X_RAM_TXACNOTCH_1              = 271,
  SI3218X_RAM_TXACNOTCH_2              = 272,
  SI3218X_RAM_TXACNOTCH_OUT            = 273,
  SI3218X_RAM_ZSYNTH_1                 = 274,
  SI3218X_RAM_ZSYNTH_2                 = 275,
  SI3218X_RAM_ZSYNTH_OUT_1             = 276,
  SI3218X_RAM_TXACD2_1_0               = 277,
  SI3218X_RAM_TXACD2_1_1               = 278,
  SI3218X_RAM_TXACD2_1_2               = 279,
  SI3218X_RAM_TXACD2_1_3               = 280,
  SI3218X_RAM_TXACD2_1_4               = 281,
  SI3218X_RAM_TXACD2_1_5               = 282,
  SI3218X_RAM_TXACD2_1_OUT             = 283,
  SI3218X_RAM_TXACD2_2_0               = 284,
  SI3218X_RAM_TXACD2_2_1               = 285,
  SI3218X_RAM_TXACD2_2_2               = 286,
  SI3218X_RAM_TXACD2_2_3               = 287,
  SI3218X_RAM_TXACD2_2_4               = 288,
  SI3218X_RAM_TXACD2_2_5               = 289,
  SI3218X_RAM_TXACD2_2_OUT             = 290,
  SI3218X_RAM_TXACD2_3_0               = 291,
  SI3218X_RAM_TXACD2_3_1               = 292,
  SI3218X_RAM_TXACD2_3_2               = 293,
  SI3218X_RAM_TXACD2_3_3               = 294,
  SI3218X_RAM_TXACD2_3_4               = 295,
  SI3218X_RAM_TXACD2_3_5               = 296,
  SI3218X_RAM_TXACD2_3_OUT             = 297,
  SI3218X_RAM_RXACI2_1_1               = 298,
  SI3218X_RAM_RXACI2_1_2               = 299,
  SI3218X_RAM_RXACI2_1_3               = 300,
  SI3218X_RAM_RXACI2_1_4               = 301,
  SI3218X_RAM_RXACI2_1_OUT             = 302,
  SI3218X_RAM_RXACI2_2_1               = 303,
  SI3218X_RAM_RXACI2_2_2               = 304,
  SI3218X_RAM_RXACI2_2_3               = 305,
  SI3218X_RAM_RXACI2_2_4               = 306,
  SI3218X_RAM_RXACI2_2_OUT             = 307,
  SI3218X_RAM_RXACI2_3_1               = 308,
  SI3218X_RAM_RXACI2_3_2               = 309,
  SI3218X_RAM_RXACI2_3_3               = 310,
  SI3218X_RAM_RXACI2_3_4               = 311,
  SI3218X_RAM_RXACI2_3_OUT             = 312,
  SI3218X_RAM_TXACCOMP1                = 313,
  SI3218X_RAM_TXACCOMP_OUT             = 314,
  SI3218X_RAM_RXACCOMP1                = 315,
  SI3218X_RAM_RXACCOMP_OUT             = 316,
  SI3218X_RAM_RXACHPF_D1_2             = 317,
  SI3218X_RAM_RXACHPF_D2_1             = 318,
  SI3218X_RAM_RXACHPF_D2_2             = 319,
  SI3218X_RAM_RXACHPF_OUT              = 320,
  SI3218X_RAM_RXACHPF_OUT_1            = 321,
  SI3218X_RAM_RXACHPF_OUT_2            = 322,
  SI3218X_RAM_RXACEQ_OUT               = 323,
  SI3218X_RAM_METER_I_1                = 324,
  SI3218X_RAM_METER_I_OUT              = 325,
  SI3218X_RAM_METER_LPF_1              = 326,
  SI3218X_RAM_METER_LPF_2              = 327,
  SI3218X_RAM_METER_LPF_OUT            = 328,
  SI3218X_RAM_METER_BP_1               = 329,
  SI3218X_RAM_METER_BP_2               = 330,
  SI3218X_RAM_METER_BP_OUT             = 331,
  SI3218X_RAM_METER_SRC_OUT            = 332,
  SI3218X_RAM_UNUSED333                = 333,
  SI3218X_RAM_UNUSED334                = 334,
  SI3218X_RAM_RING_LPF_1               = 335,
  SI3218X_RAM_RING_LPF_2               = 336,
  SI3218X_RAM_RING_LPF_OUT             = 337,
  SI3218X_RAM_RING_INTERP_DIFF         = 338,
  SI3218X_RAM_RING_INTERP_DIFF_OUT     = 339,
  SI3218X_RAM_RING_INTERP_INT          = 340,
  SI3218X_RAM_RING_INTERP_INT_OUT      = 341,
  SI3218X_RAM_V_ILIM_TRACK             = 342,
  SI3218X_RAM_V_RFEED_TRACK            = 343,
  SI3218X_RAM_LF_SPEEDUP_CNT           = 344,
  SI3218X_RAM_DC_SPEEDUP_CNT           = 345,
  SI3218X_RAM_AC_SPEEDUP_CNT           = 346,
  SI3218X_RAM_LCR_SPEEDUP_CNT          = 347,
  SI3218X_RAM_CM_SPEEDUP_CNT           = 348,
  SI3218X_RAM_DC_SPEEDUP_MASK          = 349,
  SI3218X_RAM_ZSYNTH_IN                = 350,
  SI3218X_RAM_I_TAR_SAVE               = 351,
  SI3218X_RAM_UNUSED352                = 352,
  SI3218X_RAM_UNUSED353                = 353,
  SI3218X_RAM_COUNTER_VTR              = 354,
  SI3218X_RAM_I_RING_AVG               = 355,
  SI3218X_RAM_COUNTER_IRING            = 356,
  SI3218X_RAM_COMP_RATIO               = 357,
  SI3218X_RAM_MADC_VBAT_DIV2           = 358,
  SI3218X_RAM_VDIFF_PK_T               = 359,
  SI3218X_RAM_PEAK_CNT                 = 360,
  SI3218X_RAM_CM_DBI_CNT               = 361,
  SI3218X_RAM_VCM_LAST                 = 362,
  SI3218X_RAM_VBATL_SENSE              = 363,
  SI3218X_RAM_VBATH_SENSE              = 364,
  SI3218X_RAM_VBATR_SENSE              = 365,
  SI3218X_RAM_BAT_SETTLE_CNT           = 366,
  SI3218X_RAM_VBAT_TGT                 = 367,
  SI3218X_RAM_VBAT_REQ                 = 368,
  SI3218X_RAM_VCM_HIRES                = 369,
  SI3218X_RAM_VCM_LORES                = 370,
  SI3218X_RAM_ILOOP1                   = 371,
  SI3218X_RAM_ILONG2                   = 372,
  SI3218X_RAM_ITIP1                    = 373,
  SI3218X_RAM_IRING1                   = 374,
  SI3218X_RAM_CAL_TEMP1                = 375,
  SI3218X_RAM_CAL_TEMP2                = 376,
  SI3218X_RAM_CAL_TEMP3                = 377,
  SI3218X_RAM_CAL_TEMP4                = 378,
  SI3218X_RAM_CAL_TEMP5                = 379,
  SI3218X_RAM_CAL_TEMP6                = 380,
  SI3218X_RAM_CAL_TEMP7                = 381,
  SI3218X_RAM_CMRR_DIVISOR             = 382,
  SI3218X_RAM_CMRR_REMAINDER           = 383,
  SI3218X_RAM_CMRR_Q_PTR               = 384,
  SI3218X_RAM_I_SOURCE1                = 385,
  SI3218X_RAM_I_SOURCE2                = 386,
  SI3218X_RAM_VTR1                     = 387,
  SI3218X_RAM_VTR2                     = 388,
  SI3218X_RAM_STOP_TIMER1              = 389,
  SI3218X_RAM_STOP_TIMER2              = 390,
  SI3218X_RAM_UNUSED391                = 391,
  SI3218X_RAM_UNUSED392                = 392,
  SI3218X_RAM_CAL_ONHK_Z               = 393,
  SI3218X_RAM_CAL_LB_SETTLE            = 394,
  SI3218X_RAM_CAL_DECLPF_V0            = 395,
  SI3218X_RAM_CAL_DECLPF_V1            = 396,
  SI3218X_RAM_CAL_DECLPF_V2            = 397,
  SI3218X_RAM_CAL_GOERTZEL_V0          = 398,
  SI3218X_RAM_CAL_GOERTZEL_V1          = 399,
  SI3218X_RAM_CAL_DECLPF_Y             = 400,
  SI3218X_RAM_CAL_GOERTZEL_Y           = 401,
  SI3218X_RAM_P_HVIC                   = 402,
  SI3218X_RAM_VBATL_MIRROR             = 403,
  SI3218X_RAM_VBATH_MIRROR             = 404,
  SI3218X_RAM_VBATR_MIRROR             = 405,
  SI3218X_RAM_DIAG_EX1_OUT             = 406,
  SI3218X_RAM_DIAG_EX2_OUT             = 407,
  SI3218X_RAM_DIAG_DMM_V_OUT           = 408,
  SI3218X_RAM_DIAG_DMM_I_OUT           = 409,
  SI3218X_RAM_DIAG_P                   = 410,
  SI3218X_RAM_DIAG_LPF_V               = 411,
  SI3218X_RAM_DIAG_LPF_I               = 412,
  SI3218X_RAM_DIAG_TONE_FLAG           = 413,
  SI3218X_RAM_ILOOP1_LAST              = 414,
  SI3218X_RAM_RING_ENTRY_VOC           = 415,
  SI3218X_RAM_UNUSED416                = 416,
  SI3218X_RAM_OSC1_X_SAVE              = 417,
  SI3218X_RAM_EZSYNTH_1                = 418,
  SI3218X_RAM_EZSYNTH_2                = 419,
  SI3218X_RAM_ZSYNTH_OUT               = 420,
  SI3218X_RAM_UNUSED421                = 421,
  SI3218X_RAM_CAL_SUBSTATE             = 422,
  SI3218X_RAM_DIAG_EX1_DC_OUT          = 423,
  SI3218X_RAM_DIAG_EX1_DC              = 424,
  SI3218X_RAM_EZSYNTH_B1               = 425,
  SI3218X_RAM_EZSYNTH_B2               = 426,
  SI3218X_RAM_EZSYNTH_A1               = 427,
  SI3218X_RAM_EZSYNTH_A2               = 428,
  SI3218X_RAM_ILOOP1_FILT              = 429,
  SI3218X_RAM_AC_PU_DELTA1_CNT         = 430,
  SI3218X_RAM_AC_PU_DELTA2_CNT         = 431,
  SI3218X_RAM_UNUSED432                = 432,
  SI3218X_RAM_UNUSED433                = 433,
  SI3218X_RAM_UNUSED434                = 434,
  SI3218X_RAM_AC_DAC_GAIN_SAVE         = 435,
  SI3218X_RAM_RING_FLUSH_CNT           = 436,
  SI3218X_RAM_UNUSED437                = 437,
  SI3218X_RAM_DIAG_VAR_OUT             = 438,
  SI3218X_RAM_I_VBAT                   = 439,
  SI3218X_RAM_UNUSED440                = 440,
  SI3218X_RAM_CALTMP_LOOPCNT           = 441,
  SI3218X_RAM_CALTMP_LOOPINC           = 442,
  SI3218X_RAM_UNUSED443                = 443,
  SI3218X_RAM_CALTMP_CODEINC           = 444,
  SI3218X_RAM_CALTMP_TAUINC            = 445,
  SI3218X_RAM_CALTMP_TAU               = 446,
  SI3218X_RAM_CAL_TEMP8                = 447,
  SI3218X_RAM_PATCHID                  = 448,
  SI3218X_RAM_UNUSED449                = 449,
  SI3218X_RAM_UNUSED450                = 450,
  SI3218X_RAM_UNUSED451                = 451,
  SI3218X_RAM_CAL_LB_OFFSET_FWD        = 452,
  SI3218X_RAM_CAL_LB_OFFSET_RVS        = 453,
  SI3218X_RAM_COUNT_SPEEDUP            = 454,
  SI3218X_RAM_SWEEP_COUNT              = 455,
  SI3218X_RAM_AMP_RAMP                 = 456,
  SI3218X_RAM_DIAG_LPF_MADC_D          = 457,
  SI3218X_RAM_DIAG_HPF_MADC            = 458,
  SI3218X_RAM_UNUSED459                = 459,
  SI3218X_RAM_TXDEC_OUT                = 460,
  SI3218X_RAM_TXDEC_D1                 = 461,
  SI3218X_RAM_TXDEC_D2                 = 462,
  SI3218X_RAM_RXDEC_D1                 = 463,
  SI3218X_RAM_RXDEC_D2                 = 464,
  SI3218X_RAM_OSCINT1_D2_1             = 465,
  SI3218X_RAM_OSCINT1_D1_1             = 466,
  SI3218X_RAM_OSCINT1_OUT_1            = 467,
  SI3218X_RAM_OSCINT1_D2_2             = 468,
  SI3218X_RAM_OSCINT1_D1_2             = 469,
  SI3218X_RAM_OSCINT1_OUT              = 470,
  SI3218X_RAM_OSCINT2_D2_1             = 471,
  SI3218X_RAM_OSCINT2_D1_1             = 472,
  SI3218X_RAM_OSCINT2_OUT_1            = 473,
  SI3218X_RAM_OSCINT2_D2_2             = 474,
  SI3218X_RAM_OSCINT2_D1_2             = 475,
  SI3218X_RAM_OSCINT2_OUT              = 476,
  SI3218X_RAM_OSC1_Y_SAVE              = 477,
  SI3218X_RAM_OSC2_Y_SAVE              = 478,
  SI3218X_RAM_PWRSAVE_CNT              = 479,
  SI3218X_RAM_VBATR_PK                 = 480,
  SI3218X_RAM_SPEEDUP_MASK_CNT         = 481,
  SI3218X_RAM_VCM_RING_FIXED           = 482,
  SI3218X_RAM_DELTA_VCM                = 483,
  SI3218X_RAM_MADC_VTIPC_DIAG_OS       = 484,
  SI3218X_RAM_MADC_VRINGC_DIAG_OS      = 485,
  SI3218X_RAM_MADC_VLONG_DIAG_OS       = 486,
  SI3218X_RAM_UNUSED487                = 487,
  SI3218X_RAM_UNUSED488                = 488,
  SI3218X_RAM_UNUSED489                = 489,
  SI3218X_RAM_UNUSED490                = 490,
  SI3218X_RAM_UNUSED491                = 491,
  SI3218X_RAM_PWRSAVE_DBI_CNT          = 492,
  SI3218X_RAM_COMP_RATIO_SAVE          = 493,
  SI3218X_RAM_CAL_TEMP9                = 494,
  SI3218X_RAM_CAL_TEMP10               = 495,
  SI3218X_RAM_DAC_OFFSET_TEMP          = 496,
  SI3218X_RAM_CAL_DAC_CODE             = 497,
  SI3218X_RAM_DCDAC_OFFSET             = 498,
  SI3218X_RAM_VDIFF_COARSE             = 499,
  SI3218X_RAM_RXACIIR_OUT_4            = 500,
  SI3218X_RAM_CAL_TEMP11               = 501,
  SI3218X_RAM_METER_RAMP               = 502,
  SI3218X_RAM_METER_RAMP_DIR           = 503,
  SI3218X_RAM_METER_ON_T               = 504,
  SI3218X_RAM_METER_PK_DET             = 505,
  SI3218X_RAM_METER_PK_DET_T           = 506,
  SI3218X_RAM_THERM_CNT                = 507,
  SI3218X_RAM_VDIFF_SENSE_DELAY        = 508,
  SI3218X_RAM_RING_INTERP_DIFF_SYNC    = 509,
  SI3218X_RAM_CPUMP_DEB_CNT            = 510,
  SI3218X_RAM_UNUSED511                = 511,
  SI3218X_RAM_MINUS_ONE                = 512,
  SI3218X_RAM_ILOOPLPF                 = 513,
  SI3218X_RAM_ILONGLPF                 = 514,
  SI3218X_RAM_BATLPF                   = 515,
  SI3218X_RAM_VDIFFLPF                 = 516,
  SI3218X_RAM_VCMLPF                   = 517,
  SI3218X_RAM_TXACIIR_B0_1             = 518,
  SI3218X_RAM_TXACIIR_B1_1             = 519,
  SI3218X_RAM_TXACIIR_A1_1             = 520,
  SI3218X_RAM_TXACIIR_B0_2             = 521,
  SI3218X_RAM_TXACIIR_B1_2             = 522,
  SI3218X_RAM_TXACIIR_B2_2             = 523,
  SI3218X_RAM_TXACIIR_A1_2             = 524,
  SI3218X_RAM_TXACIIR_A2_2             = 525,
  SI3218X_RAM_TXACIIR_B0_3             = 526,
  SI3218X_RAM_TXACIIR_B1_3             = 527,
  SI3218X_RAM_TXACIIR_B2_3             = 528,
  SI3218X_RAM_TXACIIR_A1_3             = 529,
  SI3218X_RAM_TXACIIR_A2_3             = 530,
  SI3218X_RAM_TXACHPF_B0_1             = 531,
  SI3218X_RAM_TXACHPF_B1_1             = 532,
  SI3218X_RAM_TXACHPF_A1_1             = 533,
  SI3218X_RAM_TXACHPF_B0_2             = 534,
  SI3218X_RAM_TXACHPF_B1_2             = 535,
  SI3218X_RAM_TXACHPF_B2_2             = 536,
  SI3218X_RAM_TXACHPF_A1_2             = 537,
  SI3218X_RAM_TXACHPF_A2_2             = 538,
  SI3218X_RAM_TXACHPF_GAIN             = 539,
  SI3218X_RAM_TXACEQ_C0                = 540,
  SI3218X_RAM_TXACEQ_C1                = 541,
  SI3218X_RAM_TXACEQ_C2                = 542,
  SI3218X_RAM_TXACEQ_C3                = 543,
  SI3218X_RAM_TXACGAIN                 = 544,
  SI3218X_RAM_RXACGAIN                 = 545,
  SI3218X_RAM_RXACEQ_C0                = 546,
  SI3218X_RAM_RXACEQ_C1                = 547,
  SI3218X_RAM_RXACEQ_C2                = 548,
  SI3218X_RAM_RXACEQ_C3                = 549,
  SI3218X_RAM_RXACIIR_B0_1             = 550,
  SI3218X_RAM_RXACIIR_B1_1             = 551,
  SI3218X_RAM_RXACIIR_A1_1             = 552,
  SI3218X_RAM_RXACIIR_B0_2             = 553,
  SI3218X_RAM_RXACIIR_B1_2             = 554,
  SI3218X_RAM_RXACIIR_B2_2             = 555,
  SI3218X_RAM_RXACIIR_A1_2             = 556,
  SI3218X_RAM_RXACIIR_A2_2             = 557,
  SI3218X_RAM_RXACIIR_B0_3             = 558,
  SI3218X_RAM_RXACIIR_B1_3             = 559,
  SI3218X_RAM_RXACIIR_B2_3             = 560,
  SI3218X_RAM_RXACIIR_A1_3             = 561,
  SI3218X_RAM_RXACIIR_A2_3             = 562,
  SI3218X_RAM_ECFIR_C2                 = 563,
  SI3218X_RAM_ECFIR_C3                 = 564,
  SI3218X_RAM_ECFIR_C4                 = 565,
  SI3218X_RAM_ECFIR_C5                 = 566,
  SI3218X_RAM_ECFIR_C6                 = 567,
  SI3218X_RAM_ECFIR_C7                 = 568,
  SI3218X_RAM_ECFIR_C8                 = 569,
  SI3218X_RAM_ECFIR_C9                 = 570,
  SI3218X_RAM_ECIIR_B0                 = 571,
  SI3218X_RAM_ECIIR_B1                 = 572,
  SI3218X_RAM_ECIIR_A1                 = 573,
  SI3218X_RAM_ECIIR_A2                 = 574,
  SI3218X_RAM_DTMFDTF_B0_1             = 575,
  SI3218X_RAM_DTMFDTF_B1_1             = 576,
  SI3218X_RAM_DTMFDTF_B2_1             = 577,
  SI3218X_RAM_DTMFDTF_A1_1             = 578,
  SI3218X_RAM_DTMFDTF_A2_1             = 579,
  SI3218X_RAM_DTMFDTF_B0_2             = 580,
  SI3218X_RAM_DTMFDTF_B1_2             = 581,
  SI3218X_RAM_DTMFDTF_B2_2             = 582,
  SI3218X_RAM_DTMFDTF_A1_2             = 583,
  SI3218X_RAM_DTMFDTF_A2_2             = 584,
  SI3218X_RAM_DTMFDTF_B0_3             = 585,
  SI3218X_RAM_DTMFDTF_B1_3             = 586,
  SI3218X_RAM_DTMFDTF_B2_3             = 587,
  SI3218X_RAM_DTMFDTF_A1_3             = 588,
  SI3218X_RAM_DTMFDTF_A2_3             = 589,
  SI3218X_RAM_DTMFDTF_GAIN             = 590,
  SI3218X_RAM_DTMFLPF_B0_1             = 591,
  SI3218X_RAM_DTMFLPF_B1_1             = 592,
  SI3218X_RAM_DTMFLPF_B2_1             = 593,
  SI3218X_RAM_DTMFLPF_A1_1             = 594,
  SI3218X_RAM_DTMFLPF_A2_1             = 595,
  SI3218X_RAM_DTMFLPF_B0_2             = 596,
  SI3218X_RAM_DTMFLPF_B1_2             = 597,
  SI3218X_RAM_DTMFLPF_B2_2             = 598,
  SI3218X_RAM_DTMFLPF_A1_2             = 599,
  SI3218X_RAM_DTMFLPF_A2_2             = 600,
  SI3218X_RAM_DTMFLPF_GAIN             = 601,
  SI3218X_RAM_DTMFHPF_B0_1             = 602,
  SI3218X_RAM_DTMFHPF_B1_1             = 603,
  SI3218X_RAM_DTMFHPF_B2_1             = 604,
  SI3218X_RAM_DTMFHPF_A1_1             = 605,
  SI3218X_RAM_DTMFHPF_A2_1             = 606,
  SI3218X_RAM_DTMFHPF_B0_2             = 607,
  SI3218X_RAM_DTMFHPF_B1_2             = 608,
  SI3218X_RAM_DTMFHPF_B2_2             = 609,
  SI3218X_RAM_DTMFHPF_A1_2             = 610,
  SI3218X_RAM_DTMFHPF_A2_2             = 611,
  SI3218X_RAM_DTMFHPF_GAIN             = 612,
  SI3218X_RAM_POWER_GAIN               = 613,
  SI3218X_RAM_GOERTZEL_GAIN            = 614,
  SI3218X_RAM_MODEM_GAIN               = 615,
  SI3218X_RAM_HOTBIT1                  = 616,
  SI3218X_RAM_HOTBIT0                  = 617,
  SI3218X_RAM_ROW0_C1                  = 618,
  SI3218X_RAM_ROW1_C1                  = 619,
  SI3218X_RAM_ROW2_C1                  = 620,
  SI3218X_RAM_ROW3_C1                  = 621,
  SI3218X_RAM_COL0_C1                  = 622,
  SI3218X_RAM_COL1_C1                  = 623,
  SI3218X_RAM_COL2_C1                  = 624,
  SI3218X_RAM_COL3_C1                  = 625,
  SI3218X_RAM_ROW0_C2                  = 626,
  SI3218X_RAM_ROW1_C2                  = 627,
  SI3218X_RAM_ROW2_C2                  = 628,
  SI3218X_RAM_ROW3_C2                  = 629,
  SI3218X_RAM_COL0_C2                  = 630,
  SI3218X_RAM_COL1_C2                  = 631,
  SI3218X_RAM_COL2_C2                  = 632,
  SI3218X_RAM_COL3_C2                  = 633,
  SI3218X_RAM_SLOPE_VLIM               = 634,
  SI3218X_RAM_SLOPE_RFEED              = 635,
  SI3218X_RAM_SLOPE_ILIM               = 636,
  SI3218X_RAM_SLOPE_RING               = 637,
  SI3218X_RAM_SLOPE_DELTA1             = 638,
  SI3218X_RAM_SLOPE_DELTA2             = 639,
  SI3218X_RAM_V_VLIM                   = 640,
  SI3218X_RAM_V_RFEED                  = 641,
  SI3218X_RAM_V_ILIM                   = 642,
  SI3218X_RAM_CONST_RFEED              = 643,
  SI3218X_RAM_CONST_ILIM               = 644,
  SI3218X_RAM_I_VLIM                   = 645,
  SI3218X_RAM_DC_DAC_GAIN              = 646,
  SI3218X_RAM_VDIFF_TH                 = 647,
  SI3218X_RAM_TXDEC_B0                 = 648,
  SI3218X_RAM_TXDEC_B1                 = 649,
  SI3218X_RAM_TXDEC_B2                 = 650,
  SI3218X_RAM_TXDEC_A1                 = 651,
  SI3218X_RAM_TXDEC_A2                 = 652,
  SI3218X_RAM_ZSYNTH_B0                = 653,
  SI3218X_RAM_ZSYNTH_B1                = 654,
  SI3218X_RAM_ZSYNTH_B2                = 655,
  SI3218X_RAM_ZSYNTH_A1                = 656,
  SI3218X_RAM_ZSYNTH_A2                = 657,
  SI3218X_RAM_RXACHPF_B0_1             = 658,
  SI3218X_RAM_RXACHPF_B1_1             = 659,
  SI3218X_RAM_RXACHPF_A1_1             = 660,
  SI3218X_RAM_RXACHPF_B0_2             = 661,
  SI3218X_RAM_RXACHPF_B1_2             = 662,
  SI3218X_RAM_RXACHPF_B2_2             = 663,
  SI3218X_RAM_RXACHPF_A1_2             = 664,
  SI3218X_RAM_RXACHPF_A2_2             = 665,
  SI3218X_RAM_RXACHPF_GAIN             = 666,
  SI3218X_RAM_MASK7LSB                 = 667,
  SI3218X_RAM_RXDEC_B0                 = 668,
  SI3218X_RAM_RXDEC_B1                 = 669,
  SI3218X_RAM_RXDEC_B2                 = 670,
  SI3218X_RAM_RXDEC_A1                 = 671,
  SI3218X_RAM_RXDEC_A2                 = 672,
  SI3218X_RAM_OSCINT1_B0_1             = 673,
  SI3218X_RAM_OSCINT1_B1_1             = 674,
  SI3218X_RAM_OSCINT1_B2_1             = 675,
  SI3218X_RAM_OSCINT1_A1_1             = 676,
  SI3218X_RAM_OSCINT1_A2_1             = 677,
  SI3218X_RAM_OSCINT1_B0_2             = 678,
  SI3218X_RAM_OSCINT1_B1_2             = 679,
  SI3218X_RAM_OSCINT1_B2_2             = 680,
  SI3218X_RAM_OSCINT1_A1_2             = 681,
  SI3218X_RAM_OSCINT1_A2_2             = 682,
  SI3218X_RAM_OSCINT2_B0_1             = 683,
  SI3218X_RAM_OSCINT2_B1_1             = 684,
  SI3218X_RAM_OSCINT2_B2_1             = 685,
  SI3218X_RAM_OSCINT2_A1_1             = 686,
  SI3218X_RAM_OSCINT2_A2_1             = 687,
  SI3218X_RAM_OSCINT2_B0_2             = 688,
  SI3218X_RAM_OSCINT2_B1_2             = 689,
  SI3218X_RAM_OSCINT2_B2_2             = 690,
  SI3218X_RAM_OSCINT2_A1_2             = 691,
  SI3218X_RAM_OSCINT2_A2_2             = 692,
  SI3218X_RAM_UNUSED693                = 693,
  SI3218X_RAM_UNUSED694                = 694,
  SI3218X_RAM_UNUSED695                = 695,
  SI3218X_RAM_RING_LPF_B0              = 696,
  SI3218X_RAM_RING_LPF_B1              = 697,
  SI3218X_RAM_RING_LPF_B2              = 698,
  SI3218X_RAM_RING_LPF_A1              = 699,
  SI3218X_RAM_RING_LPF_A2              = 700,
  SI3218X_RAM_LCRDBI                   = 701,
  SI3218X_RAM_LONGDBI                  = 702,
  SI3218X_RAM_VBAT_TIMER               = 703,
  SI3218X_RAM_LF_SPEEDUP_TIMER         = 704,
  SI3218X_RAM_DC_SPEEDUP_TIMER         = 705,
  SI3218X_RAM_AC_SPEEDUP_TIMER         = 706,
  SI3218X_RAM_LCR_SPEEDUP_TIMER        = 707,
  SI3218X_RAM_CM_SPEEDUP_TIMER         = 708,
  SI3218X_RAM_VCM_TH                   = 709,
  SI3218X_RAM_AC_SPEEDUP_TH            = 710,
  SI3218X_RAM_SPR_SIG_0                = 711,
  SI3218X_RAM_SPR_SIG_1                = 712,
  SI3218X_RAM_SPR_SIG_2                = 713,
  SI3218X_RAM_SPR_SIG_3                = 714,
  SI3218X_RAM_SPR_SIG_4                = 715,
  SI3218X_RAM_SPR_SIG_5                = 716,
  SI3218X_RAM_SPR_SIG_6                = 717,
  SI3218X_RAM_SPR_SIG_7                = 718,
  SI3218X_RAM_SPR_SIG_8                = 719,
  SI3218X_RAM_SPR_SIG_9                = 720,
  SI3218X_RAM_SPR_SIG_10               = 721,
  SI3218X_RAM_SPR_SIG_11               = 722,
  SI3218X_RAM_SPR_SIG_12               = 723,
  SI3218X_RAM_SPR_SIG_13               = 724,
  SI3218X_RAM_SPR_SIG_14               = 725,
  SI3218X_RAM_SPR_SIG_15               = 726,
  SI3218X_RAM_SPR_SIG_16               = 727,
  SI3218X_RAM_SPR_SIG_17               = 728,
  SI3218X_RAM_SPR_SIG_18               = 729,
  SI3218X_RAM_COUNTER_VTR_VAL          = 730,
  SI3218X_RAM_CONST_028                = 731,
  SI3218X_RAM_CONST_032                = 732,
  SI3218X_RAM_CONST_038                = 733,
  SI3218X_RAM_CONST_046                = 734,
  SI3218X_RAM_COUNTER_IRING_VAL        = 735,
  SI3218X_RAM_GAIN_RING                = 736,
  SI3218X_RAM_RING_HYST                = 737,
  SI3218X_RAM_COMP_Z                   = 738,
  SI3218X_RAM_CONST_115                = 739,
  SI3218X_RAM_CONST_110                = 740,
  SI3218X_RAM_CONST_105                = 741,
  SI3218X_RAM_CONST_100                = 742,
  SI3218X_RAM_CONST_095                = 743,
  SI3218X_RAM_CONST_090                = 744,
  SI3218X_RAM_CONST_085                = 745,
  SI3218X_RAM_V_RASUM_IDEAL            = 746,
  SI3218X_RAM_CONST_ONE                = 747,
  SI3218X_RAM_VCM_OH                   = 748,
  SI3218X_RAM_VCM_RING                 = 749,
  SI3218X_RAM_VCM_HYST                 = 750,
  SI3218X_RAM_VOV_GND                  = 751,
  SI3218X_RAM_VOV_BAT                  = 752,
  SI3218X_RAM_VOV_RING_BAT             = 753,
  SI3218X_RAM_CM_DBI                   = 754,
  SI3218X_RAM_RTPER                    = 755,
  SI3218X_RAM_P_TH_HVIC                = 756,
  SI3218X_RAM_UNUSED757                = 757,
  SI3218X_RAM_UNUSED758                = 758,
  SI3218X_RAM_COEF_P_HVIC              = 759,
  SI3218X_RAM_UNUSED760                = 760,
  SI3218X_RAM_UNUSED761                = 761,
  SI3218X_RAM_UNUSED762                = 762,
  SI3218X_RAM_UNUSED763                = 763,
  SI3218X_RAM_BAT_HYST                 = 764,
  SI3218X_RAM_BAT_DBI                  = 765,
  SI3218X_RAM_VBATL_EXPECT             = 766,
  SI3218X_RAM_VBATH_EXPECT             = 767,
  SI3218X_RAM_VBATR_EXPECT             = 768,
  SI3218X_RAM_BAT_SETTLE               = 769,
  SI3218X_RAM_VBAT_IRQ_TH              = 770,
  SI3218X_RAM_MADC_VTIPC_OS            = 771,
  SI3218X_RAM_MADC_VRINGC_OS           = 772,
  SI3218X_RAM_MADC_VBAT_OS             = 773,
  SI3218X_RAM_MADC_VLONG_OS            = 774,
  SI3218X_RAM_UNUSED775                = 775,
  SI3218X_RAM_MADC_VDC_OS              = 776,
  SI3218X_RAM_MADC_ILONG_OS            = 777,
  SI3218X_RAM_UNUSED778                = 778,
  SI3218X_RAM_UNUSED779                = 779,
  SI3218X_RAM_MADC_ILOOP_OS            = 780,
  SI3218X_RAM_MADC_ILOOP_SCALE         = 781,
  SI3218X_RAM_UNUSED782                = 782,
  SI3218X_RAM_UNUSED783                = 783,
  SI3218X_RAM_DC_ADC_OS                = 784,
  SI3218X_RAM_CAL_UNITY                = 785,
  SI3218X_RAM_UNUSED786                = 786,
  SI3218X_RAM_UNUSED787                = 787,
  SI3218X_RAM_ACADC_OFFSET             = 788,
  SI3218X_RAM_ACDAC_OFFSET             = 789,
  SI3218X_RAM_CAL_DCDAC_CODE           = 790,
  SI3218X_RAM_CAL_DCDAC_15MA           = 791,
  SI3218X_RAM_UNUSED792                = 792,
  SI3218X_RAM_UNUSED793                = 793,
  SI3218X_RAM_UNUSED794                = 794,
  SI3218X_RAM_UNUSED795                = 795,
  SI3218X_RAM_UNUSED796                = 796,
  SI3218X_RAM_UNUSED797                = 797,
  SI3218X_RAM_UNUSED798                = 798,
  SI3218X_RAM_UNUSED799                = 799,
  SI3218X_RAM_UNUSED800                = 800,
  SI3218X_RAM_CAL_LB_TSQUELCH          = 801,
  SI3218X_RAM_CAL_LB_TCHARGE           = 802,
  SI3218X_RAM_CAL_LB_TSETTLE0          = 803,
  SI3218X_RAM_CAL_GOERTZEL_DLY         = 804,
  SI3218X_RAM_CAL_GOERTZEL_ALPHA       = 805,
  SI3218X_RAM_CAL_DECLPF_K             = 806,
  SI3218X_RAM_CAL_DECLPF_B1            = 807,
  SI3218X_RAM_CAL_DECLPF_B2            = 808,
  SI3218X_RAM_CAL_DECLPF_A1            = 809,
  SI3218X_RAM_CAL_DECLPF_A2            = 810,
  SI3218X_RAM_CAL_ACADC_THRL           = 811,
  SI3218X_RAM_CAL_ACADC_THRH           = 812,
  SI3218X_RAM_CAL_ACADC_TSETTLE        = 813,
  SI3218X_RAM_DTROW0TH                 = 814,
  SI3218X_RAM_DTROW1TH                 = 815,
  SI3218X_RAM_DTROW2TH                 = 816,
  SI3218X_RAM_DTROW3TH                 = 817,
  SI3218X_RAM_DTCOL0TH                 = 818,
  SI3218X_RAM_DTCOL1TH                 = 819,
  SI3218X_RAM_DTCOL2TH                 = 820,
  SI3218X_RAM_DTCOL3TH                 = 821,
  SI3218X_RAM_DTFTWTH                  = 822,
  SI3218X_RAM_DTRTWTH                  = 823,
  SI3218X_RAM_DTROWRTH                 = 824,
  SI3218X_RAM_DTCOLRTH                 = 825,
  SI3218X_RAM_DTROW2HTH                = 826,
  SI3218X_RAM_DTCOL2HTH                = 827,
  SI3218X_RAM_DTMINPTH                 = 828,
  SI3218X_RAM_DTHOTTH                  = 829,
  SI3218X_RAM_RXPWR                    = 830,
  SI3218X_RAM_TXPWR                    = 831,
  SI3218X_RAM_RXMODPWR                 = 832,
  SI3218X_RAM_TXMODPWR                 = 833,
  SI3218X_RAM_FSKFREQ0                 = 834,
  SI3218X_RAM_FSKFREQ1                 = 835,
  SI3218X_RAM_FSKAMP0                  = 836,
  SI3218X_RAM_FSKAMP1                  = 837,
  SI3218X_RAM_FSK01                    = 838,
  SI3218X_RAM_FSK10                    = 839,
  SI3218X_RAM_VOCDELTA                 = 840,
  SI3218X_RAM_VOCLTH                   = 841,
  SI3218X_RAM_VOCHTH                   = 842,
  SI3218X_RAM_RINGOF                   = 843,
  SI3218X_RAM_RINGFR                   = 844,
  SI3218X_RAM_RINGAMP                  = 845,
  SI3218X_RAM_RINGPHAS                 = 846,
  SI3218X_RAM_RTDCTH                   = 847,
  SI3218X_RAM_RTACTH                   = 848,
  SI3218X_RAM_RTDCDB                   = 849,
  SI3218X_RAM_RTACDB                   = 850,
  SI3218X_RAM_RTCOUNT                  = 851,
  SI3218X_RAM_LCROFFHK                 = 852,
  SI3218X_RAM_LCRONHK                  = 853,
  SI3218X_RAM_LCRMASK                  = 854,
  SI3218X_RAM_LCRMASK_POLREV           = 855,
  SI3218X_RAM_LCRMASK_STATE            = 856,
  SI3218X_RAM_LCRMASK_LINECAP          = 857,
  SI3218X_RAM_LONGHITH                 = 858,
  SI3218X_RAM_LONGLOTH                 = 859,
  SI3218X_RAM_IRING_LIM                = 860,
  SI3218X_RAM_AC_PU_DELTA1             = 861,
  SI3218X_RAM_AC_PU_DELTA2             = 862,
  SI3218X_RAM_DIAG_LPF_8K              = 863,
  SI3218X_RAM_DIAG_LPF_128K            = 864,
  SI3218X_RAM_DIAG_INV_N               = 865,
  SI3218X_RAM_DIAG_GAIN                = 866,
  SI3218X_RAM_DIAG_G_CAL               = 867,
  SI3218X_RAM_DIAG_OS_CAL              = 868,
  SI3218X_RAM_SPR_GAIN_TRIM            = 869,
  SI3218X_RAM_UNUSED870                = 870,
  SI3218X_RAM_AC_DAC_GAIN              = 871,
  SI3218X_RAM_UNUSED872                = 872,
  SI3218X_RAM_UNUSED873                = 873,
  SI3218X_RAM_AC_DAC_GAIN0             = 874,
  SI3218X_RAM_EZSYNTH_B0               = 875,
  SI3218X_RAM_UNUSED876                = 876,
  SI3218X_RAM_UNUSED877                = 877,
  SI3218X_RAM_UNUSED878                = 878,
  SI3218X_RAM_UNUSED879                = 879,
  SI3218X_RAM_AC_ADC_GAIN              = 880,
  SI3218X_RAM_ILOOP1LPF                = 881,
  SI3218X_RAM_RING_FLUSH_TIMER         = 882,
  SI3218X_RAM_ALAW_BIAS                = 883,
  SI3218X_RAM_MADC_VTRC_SCALE          = 884,
  SI3218X_RAM_UNUSED885                = 885,
  SI3218X_RAM_MADC_VBAT_SCALE          = 886,
  SI3218X_RAM_MADC_VLONG_SCALE         = 887,
  SI3218X_RAM_MADC_VLONG_SCALE_RING    = 888,
  SI3218X_RAM_UNUSED889                = 889,
  SI3218X_RAM_MADC_VDC_SCALE           = 890,
  SI3218X_RAM_MADC_ILONG_SCALE         = 891,
  SI3218X_RAM_UNUSED892                = 892,
  SI3218X_RAM_UNUSED893                = 893,
  SI3218X_RAM_VDIFF_SENSE_SCALE        = 894,
  SI3218X_RAM_VDIFF_SENSE_SCALE_RING   = 895,
  SI3218X_RAM_VOV_RING_GND             = 896,
  SI3218X_RAM_DIAG_GAIN_DC             = 897,
  SI3218X_RAM_CAL_LB_OSC1_FREQ         = 898,
  SI3218X_RAM_CAL_DCDAC_9TAU           = 899,
  SI3218X_RAM_CAL_MADC_9TAU            = 900,
  SI3218X_RAM_ADAP_RING_MIN_I          = 901,
  SI3218X_RAM_SWEEP_STEP               = 902,
  SI3218X_RAM_SWEEP_STEP_SAVE          = 903,
  SI3218X_RAM_SWEEP_REF                = 904,
  SI3218X_RAM_AMP_STEP                 = 905,
  SI3218X_RAM_RXACGAIN_SAVE            = 906,
  SI3218X_RAM_AMP_RAMP_INIT            = 907,
  SI3218X_RAM_DIAG_HPF_GAIN            = 908,
  SI3218X_RAM_DIAG_HPF_8K              = 909,
  SI3218X_RAM_DIAG_ADJ_STEP            = 910,
  SI3218X_RAM_UNUSED911                = 911,
  SI3218X_RAM_UNUSED912                = 912,
  SI3218X_RAM_MADC_SCALE_INV           = 913,
  SI3218X_RAM_UNUSED914                = 914,
  SI3218X_RAM_PWRSAVE_TIMER            = 915,
  SI3218X_RAM_OFFHOOK_THRESH           = 916,
  SI3218X_RAM_SPEEDUP_MASK_TIMER       = 917,
  SI3218X_RAM_UNUSED918                = 918,
  SI3218X_RAM_VBAT_TRACK_MIN           = 919,
  SI3218X_RAM_VBAT_TRACK_MIN_RNG       = 920,
  SI3218X_RAM_UNUSED921                = 921,
  SI3218X_RAM_UNUSED922                = 922,
  SI3218X_RAM_UNUSED923                = 923,
  SI3218X_RAM_UNUSED924                = 924,
  SI3218X_RAM_UNUSED925                = 925,
  SI3218X_RAM_UNUSED926                = 926,
  SI3218X_RAM_DC_HOLD_DAC_OS           = 927,
  SI3218X_RAM_UNUSED928                = 928,
  SI3218X_RAM_NOTCH_B0                 = 929,
  SI3218X_RAM_NOTCH_B1                 = 930,
  SI3218X_RAM_NOTCH_B2                 = 931,
  SI3218X_RAM_NOTCH_A1                 = 932,
  SI3218X_RAM_NOTCH_A2                 = 933,
  SI3218X_RAM_METER_LPF_B0             = 934,
  SI3218X_RAM_METER_LPF_B1             = 935,
  SI3218X_RAM_METER_LPF_B2             = 936,
  SI3218X_RAM_METER_LPF_A1             = 937,
  SI3218X_RAM_METER_LPF_A2             = 938,
  SI3218X_RAM_METER_SIG_0              = 939,
  SI3218X_RAM_METER_SIG_1              = 940,
  SI3218X_RAM_METER_SIG_2              = 941,
  SI3218X_RAM_METER_SIG_3              = 942,
  SI3218X_RAM_METER_SIG_4              = 943,
  SI3218X_RAM_METER_SIG_5              = 944,
  SI3218X_RAM_METER_SIG_6              = 945,
  SI3218X_RAM_METER_SIG_7              = 946,
  SI3218X_RAM_METER_SIG_8              = 947,
  SI3218X_RAM_METER_SIG_9              = 948,
  SI3218X_RAM_METER_SIG_10             = 949,
  SI3218X_RAM_METER_SIG_11             = 950,
  SI3218X_RAM_METER_SIG_12             = 951,
  SI3218X_RAM_METER_SIG_13             = 952,
  SI3218X_RAM_METER_SIG_14             = 953,
  SI3218X_RAM_METER_SIG_15             = 954,
  SI3218X_RAM_METER_BP_B0              = 955,
  SI3218X_RAM_METER_BP_B1              = 956,
  SI3218X_RAM_METER_BP_B2              = 957,
  SI3218X_RAM_METER_BP_A1              = 958,
  SI3218X_RAM_METER_BP_A2              = 959,
  SI3218X_RAM_PM_AMP_THRESH            = 960,
  SI3218X_RAM_METER_GAIN               = 961,
  SI3218X_RAM_PWRSAVE_DBI              = 962,
  SI3218X_RAM_DCDC_ANA_SCALE           = 963,
  SI3218X_RAM_VOV_BAT_PWRSAVE_LO       = 964,
  SI3218X_RAM_VOV_BAT_PWRSAVE_HI       = 965,
  SI3218X_RAM_AC_ADC_GAIN0             = 966,
  SI3218X_RAM_SCALE_KAUDIO             = 967,
  SI3218X_RAM_METER_GAIN_TEMP          = 968,
  SI3218X_RAM_METER_RAMP_STEP          = 969,
  SI3218X_RAM_THERM_DBI                = 970,
  SI3218X_RAM_LPR_SCALE                = 971,
  SI3218X_RAM_LPR_CM_OS                = 972,
  SI3218X_RAM_VOV_DCDC_SLOPE           = 973,
  SI3218X_RAM_VOV_DCDC_OS              = 974,
  SI3218X_RAM_VOV_RING_BAT_MAX         = 975,
  SI3218X_RAM_SLOPE_VLIM1              = 976,
  SI3218X_RAM_SLOPE_RFEED1             = 977,
  SI3218X_RAM_SLOPE_ILIM1              = 978,
  SI3218X_RAM_V_VLIM1                  = 979,
  SI3218X_RAM_V_RFEED1                 = 980,
  SI3218X_RAM_V_ILIM1                  = 981,
  SI3218X_RAM_CONST_RFEED1             = 982,
  SI3218X_RAM_CONST_ILIM1              = 983,
  SI3218X_RAM_I_VLIM1                  = 984,
  SI3218X_RAM_SLOPE_VLIM2              = 985,
  SI3218X_RAM_SLOPE_RFEED2             = 986,
  SI3218X_RAM_SLOPE_ILIM2              = 987,
  SI3218X_RAM_V_VLIM2                  = 988,
  SI3218X_RAM_V_RFEED2                 = 989,
  SI3218X_RAM_V_ILIM2                  = 990,
  SI3218X_RAM_CONST_RFEED2             = 991,
  SI3218X_RAM_CONST_ILIM2              = 992,
  SI3218X_RAM_I_VLIM2                  = 993,
  SI3218X_RAM_DIAG_V_TAR               = 994,
  SI3218X_RAM_DIAG_V_TAR2              = 995,
  SI3218X_RAM_STOP_TIMER1_VAL          = 996,
  SI3218X_RAM_STOP_TIMER2_VAL          = 997,
  SI3218X_RAM_DIAG_VCM1_TAR            = 998,
  SI3218X_RAM_DIAG_VCM_STEP            = 999,
  SI3218X_RAM_LKG_DNT_HIRES            = 1000,
  SI3218X_RAM_LKG_DNR_HIRES            = 1001,
  SI3218X_RAM_LINEAR_OS                = 1002,
  SI3218X_RAM_CPUMP_DEB                = 1003,
  SI3218X_RAM_DCDC_VERR                = 1004,
  SI3218X_RAM_DCDC_VERR_HYST           = 1005,
  SI3218X_RAM_DCDC_OITHRESH_LO         = 1006,
  SI3218X_RAM_DCDC_OITHRESH_HI         = 1007,
  SI3218X_RAM_HV_BIAS_ONHK             = 1008,
  SI3218X_RAM_HV_BIAS_OFFHK            = 1009,
  SI3218X_RAM_UNUSED1010               = 1010,
  SI3218X_RAM_UNUSED1011               = 1011,
  SI3218X_RAM_UNUSED1012               = 1012,
  SI3218X_RAM_UNUSED1013               = 1013,
  SI3218X_RAM_ILONG_RT_THRESH          = 1014,
  SI3218X_RAM_VOV_RING_BAT_DCDC        = 1015,
  SI3218X_RAM_UNUSED1016               = 1016,
  SI3218X_RAM_LKG_LB_OFFSET            = 1017,
  SI3218X_RAM_LKG_OFHK_OFFSET          = 1018,
  SI3218X_RAM_SWEEP_FREQ_TH            = 1019,
  SI3218X_RAM_AMP_MOD_G                = 1020,
  SI3218X_RAM_AMP_MOD_OS               = 1021,
  SI3218X_RAM_UNUSED1022               = 1022,
  SI3218X_RAM_UNUSED1023               = 1023,
  SI3218X_RAM_UNUSED_REG256            = 1280,
  SI3218X_RAM_DAC_IN                   = 1281,
  SI3218X_RAM_ADC_OUT                  = 1282,
  SI3218X_RAM_PASS1                    = 1283,
  SI3218X_RAM_TX_AC_INT                = 1284,
  SI3218X_RAM_RX_AC_DIFF               = 1285,
  SI3218X_RAM_INDIRECT_WR              = 1286,
  SI3218X_RAM_INDIRECT_RD              = 1287,
  SI3218X_RAM_BYPASS_OUT               = 1288,
  SI3218X_RAM_ACC                      = 1289,
  SI3218X_RAM_INDIRECT_RAM_A           = 1290,
  SI3218X_RAM_INDIRECT_RAM_B           = 1291,
  SI3218X_RAM_HOT_BIT1                 = 1292,
  SI3218X_RAM_HOT_BIT0                 = 1293,
  SI3218X_RAM_PASS0_ROW_PWR            = 1294,
  SI3218X_RAM_PASS0_COL_PWR            = 1295,
  SI3218X_RAM_PASS0_ROW                = 1296,
  SI3218X_RAM_PASS0_COL                = 1297,
  SI3218X_RAM_PASS0_ROW_REL            = 1298,
  SI3218X_RAM_PASS0_COL_REL            = 1299,
  SI3218X_RAM_PASS0_ROW_2ND            = 1300,
  SI3218X_RAM_PASS0_COL_2ND            = 1301,
  SI3218X_RAM_PASS0_REV_TW             = 1302,
  SI3218X_RAM_PASS0_FWD_TW             = 1303,
  SI3218X_RAM_DAA_ADC_OUT              = 1304,
  SI3218X_RAM_CAL_CM_BAL_TEST          = 1305,
  SI3218X_RAM_UNUSED_REG282            = 1306,
  SI3218X_RAM_TONE1                    = 1307,
  SI3218X_RAM_TONE2                    = 1308,
  SI3218X_RAM_RING_TRIG                = 1309,
  SI3218X_RAM_VCM_DAC                  = 1310,
  SI3218X_RAM_UNUSED_REG287            = 1311,
  SI3218X_RAM_RING_DAC                 = 1312,
  SI3218X_RAM_VRING_CROSSING           = 1313,
  SI3218X_RAM_UNUSED_REG290            = 1314,
  SI3218X_RAM_LINEFEED_SHADOW          = 1315,
  SI3218X_RAM_UNUSED_REG292            = 1316,
  SI3218X_RAM_UNUSED_REG293            = 1317,
  SI3218X_RAM_UNUSED_REG294            = 1318,
  SI3218X_RAM_ROW_DIGIT                = 1319,
  SI3218X_RAM_COL_DIGIT                = 1320,
  SI3218X_RAM_UNUSED_REG297            = 1321,
  SI3218X_RAM_PQ1_IRQ                  = 1322,
  SI3218X_RAM_PQ2_IRQ                  = 1323,
  SI3218X_RAM_PQ3_IRQ                  = 1324,
  SI3218X_RAM_PQ4_IRQ                  = 1325,
  SI3218X_RAM_PQ5_IRQ                  = 1326,
  SI3218X_RAM_PQ6_IRQ                  = 1327,
  SI3218X_RAM_LCR_SET                  = 1328,
  SI3218X_RAM_LCR_CLR                  = 1329,
  SI3218X_RAM_RTP_SET                  = 1330,
  SI3218X_RAM_LONG_SET                 = 1331,
  SI3218X_RAM_LONG_CLR                 = 1332,
  SI3218X_RAM_VDIFF_IRQ                = 1333,
  SI3218X_RAM_MODFEED_SET              = 1334,
  SI3218X_RAM_MODFEED_CLR              = 1335,
  SI3218X_RAM_LF_SPEEDUP_SET           = 1336,
  SI3218X_RAM_LF_SPEEDUP_CLR           = 1337,
  SI3218X_RAM_DC_SPEEDUP_SET           = 1338,
  SI3218X_RAM_DC_SPEEDUP_CLR           = 1339,
  SI3218X_RAM_AC_SPEEDUP_SET           = 1340,
  SI3218X_RAM_AC_SPEEDUP_CLR           = 1341,
  SI3218X_RAM_LCR_SPEEDUP_SET          = 1342,
  SI3218X_RAM_LCR_SPEEDUP_CLR          = 1343,
  SI3218X_RAM_CM_SPEEDUP_SET           = 1344,
  SI3218X_RAM_CM_SPEEDUP_CLR           = 1345,
  SI3218X_RAM_MODEMPASS0               = 1346,
  SI3218X_RAM_RX2100_PASS1_PWR         = 1347,
  SI3218X_RAM_RX2100_PASS1_THR         = 1348,
  SI3218X_RAM_TX2100_PASS1_PWR         = 1349,
  SI3218X_RAM_TX2100_PASS1_THR         = 1350,
  SI3218X_RAM_TXMDM_TRIG               = 1351,
  SI3218X_RAM_RXMDM_TRIG               = 1352,
  SI3218X_RAM_UNUSED_REG329            = 1353,
  SI3218X_RAM_TX_FILT_CLR              = 1354,
  SI3218X_RAM_TX_DC_INT                = 1355,
  SI3218X_RAM_RX_DC_MOD_IN             = 1356,
  SI3218X_RAM_DSP_ACCESS               = 1357,
  SI3218X_RAM_PRAM_ADDR                = 1358,
  SI3218X_RAM_PRAM_DATA                = 1359,
  SI3218X_RAM_IND_RAM_A_BASE           = 1360,
  SI3218X_RAM_IND_RAM_A_ADDR           = 1361,
  SI3218X_RAM_IND_RAM_A_MOD            = 1362,
  SI3218X_RAM_IND_RAM_B_BASE           = 1363,
  SI3218X_RAM_IND_RAM_B_ADDR           = 1364,
  SI3218X_RAM_IND_RAM_B_MOD            = 1365,
  SI3218X_RAM_UNUSED_REG342            = 1366,
  SI3218X_RAM_UNUSED_REG343            = 1367,
  SI3218X_RAM_UNUSED_REG344            = 1368,
  SI3218X_RAM_USER_B0                  = 1369,
  SI3218X_RAM_USER_B1                  = 1370,
  SI3218X_RAM_USER_B2                  = 1371,
  SI3218X_RAM_USER_B3                  = 1372,
  SI3218X_RAM_USER_B4                  = 1373,
  SI3218X_RAM_USER_B5                  = 1374,
  SI3218X_RAM_USER_B6                  = 1375,
  SI3218X_RAM_USER_B7                  = 1376,
  SI3218X_RAM_FLUSH_AUDIO_CLR          = 1377,
  SI3218X_RAM_FLUSH_DC_CLR             = 1378,
  SI3218X_RAM_SPR_CLR                  = 1379,
  SI3218X_RAM_GPI0                     = 1380,
  SI3218X_RAM_GPI1                     = 1381,
  SI3218X_RAM_GPI2                     = 1382,
  SI3218X_RAM_GPI3                     = 1383,
  SI3218X_RAM_GPO0                     = 1384,
  SI3218X_RAM_GPO1                     = 1385,
  SI3218X_RAM_GPO2                     = 1386,
  SI3218X_RAM_GPO3                     = 1387,
  SI3218X_RAM_GPO0_OE                  = 1388,
  SI3218X_RAM_GPO1_OE                  = 1389,
  SI3218X_RAM_GPO2_OE                  = 1390,
  SI3218X_RAM_GPO3_OE                  = 1391,
  SI3218X_RAM_BATSEL_L_SET             = 1392,
  SI3218X_RAM_BATSEL_H_SET             = 1393,
  SI3218X_RAM_BATSEL_R_SET             = 1394,
  SI3218X_RAM_BATSEL_CLR               = 1395,
  SI3218X_RAM_VBAT_IRQ                 = 1396,
  SI3218X_RAM_MADC_VTIPC_RAW           = 1397,
  SI3218X_RAM_MADC_VRINGC_RAW          = 1398,
  SI3218X_RAM_MADC_VBAT_RAW            = 1399,
  SI3218X_RAM_MADC_VLONG_RAW           = 1400,
  SI3218X_RAM_UNUSED_REG377            = 1401,
  SI3218X_RAM_MADC_VDC_RAW             = 1402,
  SI3218X_RAM_MADC_ILONG_RAW           = 1403,
  SI3218X_RAM_UNUSED_REG380            = 1404,
  SI3218X_RAM_UNUSED_REG381            = 1405,
  SI3218X_RAM_MADC_ILOOP_RAW           = 1406,
  SI3218X_RAM_MADC_DIAG_RAW            = 1407,
  SI3218X_RAM_UNUSED_REG384            = 1408,
  SI3218X_RAM_UNUSED_REG385            = 1409,
  SI3218X_RAM_CALR3_DSP                = 1410,
  SI3218X_RAM_PD_MADC                  = 1411,
  SI3218X_RAM_UNUSED_REG388            = 1412,
  SI3218X_RAM_PD_BIAS                  = 1413,
  SI3218X_RAM_PD_DC_ADC                = 1414,
  SI3218X_RAM_PD_DC_DAC                = 1415,
  SI3218X_RAM_PD_DC_SNS                = 1416,
  SI3218X_RAM_PD_DC_COARSE_SNS         = 1417,
  SI3218X_RAM_PD_VBAT_SNS              = 1418,
  SI3218X_RAM_PD_DC_BUF                = 1419,
  SI3218X_RAM_PD_AC_ADC                = 1420,
  SI3218X_RAM_PD_AC_DAC                = 1421,
  SI3218X_RAM_PD_AC_SNS                = 1422,
  SI3218X_RAM_PD_CM_SNS                = 1423,
  SI3218X_RAM_PD_CM                    = 1424,
  SI3218X_RAM_UNUSED_REG401            = 1425,
  SI3218X_RAM_UNUSED_REG402            = 1426,
  SI3218X_RAM_PD_SUM                   = 1427,
  SI3218X_RAM_PD_LKGDAC                = 1428,
  SI3218X_RAM_UNUSED_REG405            = 1429,
  SI3218X_RAM_PD_HVIC                  = 1430,
  SI3218X_RAM_UNUSED_REG407            = 1431,
  SI3218X_RAM_CMDAC_CHEN_B             = 1432,
  SI3218X_RAM_SUM_CHEN_B               = 1433,
  SI3218X_RAM_TRNRD_CHEN_B             = 1434,
  SI3218X_RAM_UNUSED_REG411            = 1435,
  SI3218X_RAM_DC_BUF_CHEN_B            = 1436,
  SI3218X_RAM_AC_SNS_CHEN_B            = 1437,
  SI3218X_RAM_DC_SNS_CHEN_B            = 1438,
  SI3218X_RAM_LB_MUX_CHEN_B            = 1439,
  SI3218X_RAM_UNUSED_REG416            = 1440,
  SI3218X_RAM_CMDAC_EN_B               = 1441,
  SI3218X_RAM_RA_EN_B                  = 1442,
  SI3218X_RAM_RD_EN_B                  = 1443,
  SI3218X_RAM_VCTL                     = 1444,
  SI3218X_RAM_UNUSED_REG421            = 1445,
  SI3218X_RAM_UNUSED_REG422            = 1446,
  SI3218X_RAM_HVIC_STATE               = 1447,
  SI3218X_RAM_HVIC_STATE_OBSERVE       = 1448,
  SI3218X_RAM_HVIC_STATE_MAN           = 1449,
  SI3218X_RAM_HVIC_STATE_READ          = 1450,
  SI3218X_RAM_UNUSED_REG427            = 1451,
  SI3218X_RAM_VCMDAC_SCALE_MAN         = 1452,
  SI3218X_RAM_CAL_ACADC_CNTL           = 1453,
  SI3218X_RAM_CAL_ACDAC_CNTL           = 1454,
  SI3218X_RAM_UNUSED_REG431            = 1455,
  SI3218X_RAM_CAL_DCDAC_CNTL           = 1456,
  SI3218X_RAM_CAL_TRNRD_CNTL           = 1457,
  SI3218X_RAM_CAL_TRNRD_DACT           = 1458,
  SI3218X_RAM_CAL_TRNRD_DACR           = 1459,
  SI3218X_RAM_LKG_UPT_ACTIVE           = 1460,
  SI3218X_RAM_LKG_UPR_ACTIVE           = 1461,
  SI3218X_RAM_LKG_DNT_ACTIVE           = 1462,
  SI3218X_RAM_LKG_DNR_ACTIVE           = 1463,
  SI3218X_RAM_LKG_UPT_OHT              = 1464,
  SI3218X_RAM_LKG_UPR_OHT              = 1465,
  SI3218X_RAM_LKG_DNT_OHT              = 1466,
  SI3218X_RAM_LKG_DNR_OHT              = 1467,
  SI3218X_RAM_CAL_LKG_EN_CNTL          = 1468,
  SI3218X_RAM_CAL_PUPD_CNTL            = 1469,
  SI3218X_RAM_UNUSED_REG446            = 1470,
  SI3218X_RAM_CAL_AC_RCAL              = 1471,
  SI3218X_RAM_CAL_DC_RCAL              = 1472,
  SI3218X_RAM_KAC_MOD                  = 1473,
  SI3218X_RAM_KAC_SEL                  = 1474,
  SI3218X_RAM_SEL_RING                 = 1475,
  SI3218X_RAM_CMDAC_FWD                = 1476,
  SI3218X_RAM_CMDAC_RVS                = 1477,
  SI3218X_RAM_CAL_INC_STATE            = 1478,
  SI3218X_RAM_CAL_DCDAC_COMP           = 1479,
  SI3218X_RAM_BAT_SWITCH               = 1480,
  SI3218X_RAM_CH_IRQ                   = 1481,
  SI3218X_RAM_ILOOP_CROSSING           = 1482,
  SI3218X_RAM_VOC_FAILSAFE             = 1483,
  SI3218X_RAM_UNUSED_REG460            = 1484,
  SI3218X_RAM_UNUSED_REG461            = 1485,
  SI3218X_RAM_GENERIC_0                = 1486,
  SI3218X_RAM_GENERIC_1                = 1487,
  SI3218X_RAM_GENERIC_2                = 1488,
  SI3218X_RAM_GENERIC_3                = 1489,
  SI3218X_RAM_GENERIC_4                = 1490,
  SI3218X_RAM_GENERIC_5                = 1491,
  SI3218X_RAM_GENERIC_6                = 1492,
  SI3218X_RAM_GENERIC_7                = 1493,
  SI3218X_RAM_UNUSED_REG470            = 1494,
  SI3218X_RAM_UNUSED_REG471            = 1495,
  SI3218X_RAM_QHI_SET                  = 1496,
  SI3218X_RAM_QHI_CLR                  = 1497,
  SI3218X_RAM_UNUSED_REG474            = 1498,
  SI3218X_RAM_RDC_SUM                  = 1499,
  SI3218X_RAM_UNUSED_REG476            = 1500,
  SI3218X_RAM_UNUSED_REG477            = 1501,
  SI3218X_RAM_UNUSED_REG478            = 1502,
  SI3218X_RAM_UNUSED_REG479            = 1503,
  SI3218X_RAM_UNUSED_REG480            = 1504,
  SI3218X_RAM_UNUSED_REG481            = 1505,
  SI3218X_RAM_FLUSH_AUDIO_MAN          = 1506,
  SI3218X_RAM_FLUSH_DC_MAN             = 1507,
  SI3218X_RAM_TIP_RING_CNTL            = 1508,
  SI3218X_RAM_SQUELCH_SET              = 1509,
  SI3218X_RAM_SQUELCH_CLR              = 1510,
  SI3218X_RAM_CAL_STATE_MAN            = 1511,
  SI3218X_RAM_UNUSED_REG488            = 1512,
  SI3218X_RAM_UNUSED_REG489            = 1513,
  SI3218X_RAM_RINGING_BW               = 1514,
  SI3218X_RAM_AUDIO_MAN                = 1515,
  SI3218X_RAM_HVIC_STATE_SPARE         = 1516,
  SI3218X_RAM_RINGING_FAST_MAN         = 1517,
  SI3218X_RAM_VCM_DAC_MAN              = 1518,
  SI3218X_RAM_UNUSED_REG495            = 1519,
  SI3218X_RAM_UNUSED_REG496            = 1520,
  SI3218X_RAM_UNUSED_REG497            = 1521,
  SI3218X_RAM_GENERIC_8                = 1522,
  SI3218X_RAM_GENERIC_9                = 1523,
  SI3218X_RAM_GENERIC_10               = 1524,
  SI3218X_RAM_GENERIC_11               = 1525,
  SI3218X_RAM_UNUSED_REG502            = 1526,
  SI3218X_RAM_GENERIC_12               = 1527,
  SI3218X_RAM_GENERIC_13               = 1528,
  SI3218X_RAM_UNUSED_REG505            = 1529,
  SI3218X_RAM_DC_HOLD_DAC              = 1530,
  SI3218X_RAM_OFFHOOK_CMP              = 1531,
  SI3218X_RAM_PWRSAVE_SET              = 1532,
  SI3218X_RAM_PWRSAVE_CLR              = 1533,
  SI3218X_RAM_PD_WKUP                  = 1534,
  SI3218X_RAM_SPEEDUP_MASK_SET         = 1535,
  SI3218X_RAM_SPEEDUP_MASK_CLR         = 1536,
  SI3218X_RAM_UNUSED_REG513            = 1537,
  SI3218X_RAM_PD_DCDC                  = 1538,
  SI3218X_RAM_UNUSED_REG515            = 1539,
  SI3218X_RAM_PD_UVLO                  = 1540,
  SI3218X_RAM_PD_OVLO                  = 1541,
  SI3218X_RAM_PD_OCLO                  = 1542,
  SI3218X_RAM_PD_SWDRV                 = 1543,
  SI3218X_RAM_UNUSED_REG520            = 1544,
  SI3218X_RAM_DCDC_UVHYST              = 1545,
  SI3218X_RAM_DCDC_UVTHRESH            = 1546,
  SI3218X_RAM_DCDC_OVTHRESH            = 1547,
  SI3218X_RAM_DCDC_OITHRESH            = 1548,
  SI3218X_RAM_UNUSED_REG525            = 1549,
  SI3218X_RAM_UNUSED_REG526            = 1550,
  SI3218X_RAM_DCDC_STATUS              = 1551,
  SI3218X_RAM_UNUSED_REG528            = 1552,
  SI3218X_RAM_DCDC_SWDRV_POL           = 1553,
  SI3218X_RAM_DCDC_UVPOL               = 1554,
  SI3218X_RAM_DCDC_CPUMP               = 1555,
  SI3218X_RAM_UNUSED_REG532            = 1556,
  SI3218X_RAM_DCDC_VREF_MAN            = 1557,
  SI3218X_RAM_DCDC_VREF_CTRL           = 1558,
  SI3218X_RAM_UNUSED_REG535            = 1559,
  SI3218X_RAM_DCDC_RNGTYPE             = 1560,
  SI3218X_RAM_DCDC_DIN_FILT            = 1561,
  SI3218X_RAM_UNUSED_REG538            = 1562,
  SI3218X_RAM_DCDC_DOUT                = 1563,
  SI3218X_RAM_UNUSED_REG540            = 1564,
  SI3218X_RAM_DCDC_OIMASK              = 1565,
  SI3218X_RAM_UNUSED_REG542            = 1566,
  SI3218X_RAM_UNUSED_REG543            = 1567,
  SI3218X_RAM_DCDC_SC_SET              = 1568,
  SI3218X_RAM_WAKE_HOLD                = 1569,
  SI3218X_RAM_PD_AC_SQUELCH            = 1570,
  SI3218X_RAM_PD_REF_OSC               = 1571,
  SI3218X_RAM_UNUSED_REG548            = 1572,
  SI3218X_RAM_PWRSAVE_MAN              = 1573,
  SI3218X_RAM_PWRSAVE_SEL              = 1574,
  SI3218X_RAM_PWRSAVE_CTRL_LO          = 1575,
  SI3218X_RAM_PWRSAVE_CTRL_HI          = 1576,
  SI3218X_RAM_PWRSAVE_HVIC_LO          = 1577,
  SI3218X_RAM_PWRSAVE_HVIC_HI          = 1578,
  SI3218X_RAM_DSP_PROM_MISR            = 1579,
  SI3218X_RAM_DSP_CROM_MISR            = 1580,
  SI3218X_RAM_DAA_PROM_MISR            = 1581,
  SI3218X_RAM_DAA_CROM_MISR            = 1582,
  SI3218X_RAM_RAMBIST_ERROR            = 1583,
  SI3218X_RAM_DCDC_ANA_VREF            = 1584,
  SI3218X_RAM_DCDC_ANA_GAIN            = 1585,
  SI3218X_RAM_DCDC_ANA_TOFF            = 1586,
  SI3218X_RAM_DCDC_ANA_TONMIN          = 1587,
  SI3218X_RAM_DCDC_ANA_TONMAX          = 1588,
  SI3218X_RAM_DCDC_ANA_DSHIFT          = 1589,
  SI3218X_RAM_DCDC_ANA_LPOLY           = 1590,
  SI3218X_RAM_DCDC_ANA_PSKIP           = 1591,
  SI3218X_RAM_PD_DCDC_ANA              = 1592,
  SI3218X_RAM_UNUSED_REG569            = 1593,
  SI3218X_RAM_UNUSED_REG570            = 1594,
  SI3218X_RAM_PWRPEND_SET              = 1595,
  SI3218X_RAM_PD_CM_BUF                = 1596,
  SI3218X_RAM_JMP8                     = 1597,
  SI3218X_RAM_JMP9                     = 1598,
  SI3218X_RAM_JMP10                    = 1599,
  SI3218X_RAM_JMP11                    = 1600,
  SI3218X_RAM_JMP12                    = 1601,
  SI3218X_RAM_JMP13                    = 1602,
  SI3218X_RAM_JMP14                    = 1603,
  SI3218X_RAM_JMP15                    = 1604,
  SI3218X_RAM_METER_TRIG               = 1605,
  SI3218X_RAM_PM_ACTIVE                = 1606,
  SI3218X_RAM_PM_INACTIVE              = 1607,
  SI3218X_RAM_HVIC_VERSION             = 1608,
  SI3218X_RAM_THERM_OFF                = 1609,
  SI3218X_RAM_THERM_HI                 = 1610,
  SI3218X_RAM_TEST_LOAD                = 1611,
  SI3218X_RAM_DC_HOLD_MAN              = 1612,
  SI3218X_RAM_DC_HOLD_DAC_MAN          = 1613,
  SI3218X_RAM_UNUSED_REG590            = 1614,
  SI3218X_RAM_DCDC_CPUMP_LP            = 1615,
  SI3218X_RAM_DCDC_CPUMP_LP_MASK       = 1616,
  SI3218X_RAM_DCDC_CPUMP_PULLDOWN      = 1617,
  SI3218X_RAM_BOND_STATUS              = 1618,
  SI3218X_RAM_BOND_MAN                 = 1619,
  SI3218X_RAM_BOND_VAL                 = 1620,
  SI3218X_RAM_REF_DEBOUNCE_PCLK        = 1633,
  SI3218X_RAM_REF_DEBOUNCE_FSYNC       = 1634,
  SI3218X_RAM_DCDC_LIFT_EN             = 1635,
  SI3218X_RAM_DCDC_CPUMP_PGOOD         = 1636,
  SI3218X_RAM_DCDC_CPUMP_PGOOD_WKEN    = 1637,
  SI3218X_RAM_DCDC_CPUMP_PGOOD_FRC     = 1638,
  SI3218X_RAM_DCDC_CPUMP_LP_MASK_SH    = 1639,
  SI3218X_RAM_DCDC_UV_MAN              = 1640,
  SI3218X_RAM_DCDC_UV_DEBOUNCE         = 1641,
  SI3218X_RAM_DCDC_OV_MAN              = 1642,
  SI3218X_RAM_DCDC_OV_DEBOUNCE         = 1643,
  SI3218X_RAM_ANALOG3_TEST_MUX         = 1644,
};

#endif

