/*
 * ZTE ddr driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by tsp
 *
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/io.h>
#include <mach/iomap.h>
#include <linux/dev_info.h>
#include <linux/dmaengine.h>
#include <mach/dma.h>
#include <linux/dma-mapping.h>
#include <asm/outercache.h>
#include <asm/cacheflush.h>
#include <linux/slab.h>
#include <mach/timex.h>
#include <linux/soc/zte/ddr/drv_ddr.h>
#include <linux/syscalls.h>
#include <asm/uaccess.h>
#include <linux/delay.h>

#ifdef CONFIG_DDR_ZX29_MODULE

#define DDR_TEST_SIZE	(0xf000)//32k 

extern int ddr_get_info(struct flash_ddr_info *info);
extern bool zx29_dma_filter_fn(struct dma_chan *chan, void *param);

static volatile  unsigned int zx_noncache_dma_flag=0 ;
static volatile unsigned int zx_cacheable_dma_flag=0 ;
static struct dma_chan * ddrtest_chan = NULL;
static unsigned char * ddrtest_buffer = NULL;
static dma_addr_t ddrtest_phy_addr;
static void * vir_addr=NULL;

struct zx_ddr {
	unsigned int size;
	struct ddr_test_result	*result;
};

#if 0
static void ddr_clean_range(unsigned int addr, unsigned int size)
{
	dmac_map_area(addr, size,DMA_BIDIRECTIONAL);
	outer_clean_range(addr, addr + size);
}

static void ddr_invalide_range(unsigned int addr, unsigned int size)
{
	outer_inv_range(ddrtest_phy_addr+size , ddrtest_phy_addr+size + size);
	dmac_unmap_area(addr, size,DMA_BIDIRECTIONAL);
}
#endif
static void ddr_dma_config(unsigned int src_addr, unsigned int dst_addr, unsigned int size)
{
	dma_channel_def temp_config;

	temp_config.src_addr 	= src_addr;
	temp_config.dest_addr	= dst_addr;	
	temp_config.count		= size;
	temp_config.dma_control.tran_mode 		= TRAN_MEM_TO_MEM;
	temp_config.dma_control.src_burst_size 	= DMA_BURST_SIZE_64BIT;
	temp_config.dma_control.src_burst_len 	= DMA_BURST_LEN_16;
	temp_config.dma_control.dest_burst_size = DMA_BURST_SIZE_64BIT;
	temp_config.dma_control.dest_burst_len 	= DMA_BURST_LEN_16;
	temp_config.dma_control.irq_mode 		= DMA_ALL_IRQ_ENABLE;
	
	temp_config.link_addr 		= 0;

	dmaengine_slave_config(ddrtest_chan,(struct dma_slave_config*)&temp_config);

}

static void ddr_dma_start(struct zx_ddr *ddr ,dma_async_tx_callback callbk)
{
	struct dma_async_tx_descriptor *desc =NULL;

	/* start transfer */
	desc = ddrtest_chan->device->device_prep_interleaved_dma(ddrtest_chan,NULL,0);
	desc->callback = callbk;
	desc->callback_param = ddr;
	dmaengine_submit(desc);
	dma_async_issue_pending(ddrtest_chan);	
}

static int  ddr_noncache_cpu_test(unsigned int  size, struct ddr_test_result *result_info)
{
	unsigned int addr;

	if( NULL==result_info )
		return 1;
	
	vir_addr = dma_alloc_coherent(NULL, size, &ddrtest_phy_addr, GFP_KERNEL);
	if(!vir_addr){
		pr_info("ddr_noncache_cpu_test alloc ddr failed .     \n");
		return 1;
	}
		
	//pr_info("ddr_noncache_cpu_test alloc buffer (0x%x). \n", (unsigned int)vir_addr);

	for(addr=(unsigned int)vir_addr; addr<(unsigned int)vir_addr+size; addr+=4) {
		zx_write_reg(addr, addr);
		if(zx_read_reg(addr) !=addr) {	

			pr_info(KERN_INFO "\n addr 0x%x ddr_noncache_cpu_test failed!    \n  ", addr);
			sprintf(result_info->noncache_cpu, "addr:0x%x ddr_noncache_cpu failed", addr);		
			dma_free_coherent(NULL, size,vir_addr,  ddrtest_phy_addr);
			return 1;
		}
	}
	
	dma_free_coherent(NULL, size,vir_addr,  ddrtest_phy_addr);	

	pr_info("ddr_noncache_cpu_test succeeded .    \n");
	sprintf(result_info->noncache_cpu, "ddr_noncache_cpu_test succeeded");
	return 0;
}


static int  ddr_cacheable_cpu_test(unsigned int  size, struct ddr_test_result *result_info)
{
	unsigned int addr;
	
	if( NULL==result_info )
		return 1;
	
	/* alloc buffer */
	ddrtest_buffer = kzalloc(size, GFP_KERNEL);
	if (!ddrtest_buffer) {
		pr_info("ddr_cacheable_cpu_test alloc ddr failed .     \n");
		return 1;
	}
	//pr_info("ddr_cacheable_cpu_test alloc buffer (0x%x). \n", (unsigned int)ddrtest_buffer);

	memset(ddrtest_buffer, 0, size);

	for(addr=(unsigned int)ddrtest_buffer; addr<(unsigned int)ddrtest_buffer+size; addr+=4 )
		zx_write_reg(addr, addr);

	//addr=(unsigned int)ddrtest_buffer;
	//ddr_clean_range(addr, size);
	//ddr_invalide_range(addr, size);
	dma_sync_single_for_device(NULL,ddrtest_phy_addr , size,DMA_BIDIRECTIONAL);	
	dma_sync_single_for_cpu(NULL,ddrtest_phy_addr, size,DMA_BIDIRECTIONAL);
	
	for(addr=(unsigned int)ddrtest_buffer; addr<(unsigned int)ddrtest_buffer+size; addr+=4 ){
		if(zx_read_reg(addr) !=addr) {
			pr_info(KERN_INFO "\n ddr_cacheable_cpu_test error!    \n  ");
			sprintf(result_info->cacheable_cpu, "addr:0x%x ddr_cacheable_cpu failed", addr);	
			kfree(ddrtest_buffer);	
			return 1;
		}
	}
	kfree(ddrtest_buffer);
		
	pr_info("ddr_cacheable_cpu_test succeeded.     \n");
	sprintf(result_info->cacheable_cpu, "ddr_cacheable_cpu_test succeeded");
	return 0;
}

void noncache_dma_cb(void *data)
{	
	#if 0
	unsigned int addr1,addr2;
	struct zx_ddr *ddr=(struct zx_ddr *)data;
	unsigned int size=ddr->size;
	struct ddr_test_result *result =ddr->result;
	
	for(addr1=(unsigned int)vir_addr,addr2=(unsigned int)vir_addr+size; addr1<(unsigned int)vir_addr+size; addr1+=4,addr2+=4) {
		if(zx_read_reg(addr1) != zx_read_reg(addr2)) {
			
			pr_info("addr:0x%x cacheable_dma failed.    \n", addr1);
			sprintf(result->noncache_dma, "addr:0x%x noncache_dma failed", addr1);				
			zx_noncache_dma_flag=1;
			return ;
		}	
	}	
	
	pr_info("ddr_noncache_dma_test succeeded .     \n");
	sprintf(result->noncache_dma, "ddr_noncache_dma_test succeeded");
	#endif
	zx_noncache_dma_flag=1;
}

static int  ddr_noncache_dma_test(unsigned int  size, struct ddr_test_result *result_info)
{
	dma_cap_mask_t mask;
	unsigned int addr,addr1,addr2;
	struct zx_ddr 	ddr;
	
	if( NULL==result_info )
		return 1;

	zx_noncache_dma_flag=0;
	
	vir_addr = dma_alloc_coherent(NULL, 2*size, &ddrtest_phy_addr, GFP_KERNEL);
	if(!vir_addr){
		pr_info("ddr_noncache_cpu_test alloc ddr failed .     \n");
		return 1;
	}
	//pr_info("ddr_noncache_dma_test alloc vir_addr (0x%x), phy_addr (0x%x) \n", (unsigned int)vir_addr, ddrtest_phy_addr);
	
	for(addr=(unsigned int)vir_addr; addr<(unsigned int)vir_addr+size; addr+=4) {
		zx_write_reg(addr, addr);
	}
	
	//config dma
	dma_cap_zero(mask);
	dma_cap_set(DMA_SLAVE, mask);
	
	ddrtest_chan=dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_MEMORY);	
	if (!ddrtest_chan){
		pr_info("[DMA]test request channel failed \n");
		dma_free_coherent(NULL, 2*size, vir_addr, ddrtest_phy_addr );
		return 1;
	}
	ddr.result =result_info; 

	if(size>=0x10000)
		ddr.size = 0xfffc;	
	else
		ddr.size = size;
	
	ddr_dma_config(ddrtest_phy_addr, ddrtest_phy_addr+size, ddr.size);
	ddr_dma_start(&ddr, noncache_dma_cb);
	
	while(!zx_noncache_dma_flag);
	
	for(addr1=(unsigned int)vir_addr,addr2=(unsigned int)vir_addr+size; addr1<(unsigned int)vir_addr+ddr.size; addr1+=4,addr2+=4) {
		if(zx_read_reg(addr1) != zx_read_reg(addr2)) {
			
			pr_info("addr:0x%x noncache_dma failed.    \n", addr1);
			sprintf(result_info->noncache_dma, "addr:0x%x noncache_dma failed", addr1);

			dma_free_coherent(NULL, 2*size, vir_addr, ddrtest_phy_addr );
			dma_release_channel(ddrtest_chan);	
			return 1;
		}	
	}
	zx_noncache_dma_flag=0;
	
	pr_info("ddr_noncache_dma_test succeeded .     \n");
	sprintf(result_info->noncache_dma, "ddr_noncache_dma_test succeeded");

	dma_free_coherent(NULL, 2*size, vir_addr, ddrtest_phy_addr );
	dma_release_channel(ddrtest_chan);	
	
	return 0;
}

void cacheable_dma_cb(void *data)
{	
	#if 0
	unsigned int addr, addr1 ,addr2;
	struct zx_ddr *ddr=(struct zx_ddr *)data;
	unsigned int size=ddr->size;
	struct ddr_test_result *result =ddr->result;
	
	//addr=(unsigned int)ddrtest_buffer +size;
	//ddr_invalide_range(addr, size);
	dma_sync_single_for_cpu(NULL,ddrtest_phy_addr+size , size,DMA_BIDIRECTIONAL);
	
	for(addr1=(unsigned int)ddrtest_buffer, addr2=(unsigned int)ddrtest_buffer+size; addr1<(unsigned int)ddrtest_buffer+size; addr1+=4, addr2+=4 ){
		if(zx_read_reg(addr1) != zx_read_reg(addr2)) {
			
			pr_info("addr:0x%x cacheable_dma failed. \n", addr1);
			sprintf(result->cacheable_dma, "addr:0x%x cacheable_dma failed", addr1);		
			zx_cacheable_dma_flag=1;
	
			return;
		}	
	}

	pr_info("ddr_cacheable_dma_test succeeded.    \n");
	sprintf(result->cacheable_dma, "ddr_cacheable_dma_test succeeded");
	#endif
	zx_cacheable_dma_flag=1;

}

static int  ddr_cacheable_dma_test(unsigned int  size, struct ddr_test_result *result_info)
{
	unsigned int addr, addr1, addr2;
	dma_cap_mask_t mask;
	volatile unsigned int i=100;
	struct zx_ddr 	ddr;

	if( NULL==result_info )
		return 1;

	zx_cacheable_dma_flag=0;
	
	/* alloc buffer */
	ddrtest_buffer = kzalloc(2*size, GFP_KERNEL);
	if (!ddrtest_buffer) {
		pr_info("ddr_cacheable_dma_test alloc ddr failed.   \n");
		return 1;
	}
	//pr_info("ddr_cacheable_dma_test alloc buffer (0x%x). \n", (unsigned int)ddrtest_buffer);

	memset(ddrtest_buffer, 0, size);
	for(addr=(unsigned int)ddrtest_buffer; addr<(unsigned int)ddrtest_buffer+size; addr+=4 )
		zx_write_reg(addr, addr);

	//addr=(unsigned int)ddrtest_buffer; 
	//ddr_clean_range(addr, size);
	//ddr_invalide_range(addr, size);
	dma_sync_single_for_device(NULL,ddrtest_phy_addr , size,DMA_BIDIRECTIONAL);	
	dma_sync_single_for_cpu(NULL,ddrtest_phy_addr, size,DMA_BIDIRECTIONAL);
	
	/* map dma address */
	ddrtest_phy_addr = dma_map_single(NULL, (void *)ddrtest_buffer, 2*size, DMA_BIDIRECTIONAL);
	if (dma_mapping_error(NULL, ddrtest_phy_addr)) {
		pr_info("dma_mapping_error ddr failed   . \n");	
		kfree(ddrtest_buffer);
		return 1;
	}

	//config dma
	dma_cap_zero(mask);
	dma_cap_set(DMA_SLAVE, mask);
	
	ddrtest_chan=dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_MEMORY);	
	if (!ddrtest_chan){
		pr_info("[DMA]test request channel failed   \n");
		dma_unmap_single(NULL, ddrtest_phy_addr, 2* size, DMA_BIDIRECTIONAL);	
		kfree(ddrtest_buffer);		
		return 1;
	}
	ddr.result =result_info; 

	if(size>=0x10000)
		ddr.size = 0xfffc;	
	else
		ddr.size = size;
	
	ddr_dma_config(ddrtest_phy_addr, ddrtest_phy_addr+size, ddr.size );
	ddr_dma_start(&ddr, cacheable_dma_cb);
		
	while(!zx_cacheable_dma_flag);
	
	dma_sync_single_for_cpu(NULL,ddrtest_phy_addr+size , size,DMA_BIDIRECTIONAL);
	for(addr1=(unsigned int)ddrtest_buffer, addr2=(unsigned int)ddrtest_buffer+size; addr1<(unsigned int)ddrtest_buffer+ddr.size ; addr1+=4, addr2+=4 ){
		if(zx_read_reg(addr1) != zx_read_reg(addr2)) {
			
			pr_info("addr:0x%x cacheable_dma failed. \n", addr1);
			sprintf(result_info->cacheable_dma, "addr:0x%x cacheable_dma failed", addr1);		
			dma_release_channel(ddrtest_chan);	
			dma_unmap_single(NULL, ddrtest_phy_addr, 2* size, DMA_BIDIRECTIONAL);	
			kfree(ddrtest_buffer);
			return 1;
		}	
	}
	zx_cacheable_dma_flag=0;

	pr_info("ddr_cacheable_dma_test succeeded.    \n");
	sprintf(result_info->cacheable_dma, "ddr_cacheable_dma_test succeeded");	
	
	dma_release_channel(ddrtest_chan);	
	dma_unmap_single(NULL, ddrtest_phy_addr, 2* size, DMA_BIDIRECTIONAL);	
	kfree(ddrtest_buffer);
	
	return 0;
}


static void cacheable_speed_cb(void *data)
{	

	#if 0
	unsigned int addr, addr1 ,addr2;
	struct zx_ddr *ddr=(struct zx_ddr *)data;
	unsigned int size=ddr->size;
	struct ddr_test_result *result =ddr->result;
	
	//addr=(unsigned int)ddrtest_buffer +size;
	dma_sync_single_for_cpu(NULL,ddrtest_phy_addr+size , size,DMA_BIDIRECTIONAL);
	
	for(addr1=(unsigned int)ddrtest_buffer, addr2=(unsigned int)ddrtest_buffer+size; addr1<(unsigned int)ddrtest_buffer+size; addr1+=4, addr2+=4 ){
		if(zx_read_reg(addr1) != zx_read_reg(addr2))
		{
			pr_info("cacheable_speed_cb failed failed.    \n");
			sprintf(result->speed, "addr:0x%x speed failed", addr1);	
			zx_cacheable_dma_flag=1;			
			return;
		}	
	}	
	#endif
	
	zx_cacheable_dma_flag=1;

}


static int  ddr_cacheable_speed_test(unsigned int  size, struct ddr_test_result *result_info)
{
	unsigned int cnt=0;
	unsigned int addr;
	dma_cap_mask_t mask;
	unsigned int time1=0;
	unsigned int time2=0;
	unsigned int elapse_time=0;
	unsigned int speed=0;
	struct zx_ddr 	ddr;

	if( NULL==result_info )
		return 1;
	
	/* alloc buffer */
	ddrtest_buffer = kzalloc(2*size, GFP_KERNEL);
	if (!ddrtest_buffer) {
		pr_info("ddr_cacheable_speed_test alloc ddr failed.   \n");
		return 1;
	}
	//pr_info("ddr_cacheable_speed_test alloc buffer (0x%x). \n", (unsigned int)ddrtest_buffer);

	memset(ddrtest_buffer, 0, size);
	for(addr=(unsigned int)ddrtest_buffer; addr<(unsigned int)ddrtest_buffer+size; addr+=4 )
		zx_write_reg(addr, addr);

	//addr=(unsigned int)ddrtest_buffer;
	//ddr_clean_range(addr, size);
	//ddr_invalide_range(addr, size);
	dma_sync_single_for_device(NULL,ddrtest_phy_addr , size,DMA_BIDIRECTIONAL);	
	dma_sync_single_for_cpu(NULL,ddrtest_phy_addr, size,DMA_BIDIRECTIONAL);
	
	/* map dma address */
	ddrtest_phy_addr = dma_map_single(NULL, (void *)ddrtest_buffer, 2*size, DMA_BIDIRECTIONAL);
	if (dma_mapping_error(NULL, ddrtest_phy_addr)) {
		pr_info("dma_mapping_error ddr failed   . \n");
		kfree(ddrtest_buffer);		
		return 1;
	}

	//config dma
	dma_cap_zero(mask);
	dma_cap_set(DMA_SLAVE, mask);
	
	ddrtest_chan=dma_request_channel(mask, zx29_dma_filter_fn, (void*)DMA_CH_MEMORY);	
	if (!ddrtest_chan){
		pr_info("[DMA]test request channel failed   \n");	
		dma_unmap_single(NULL, ddrtest_phy_addr, 2* size, DMA_BIDIRECTIONAL);	
		kfree(ddrtest_buffer);
		return 1;
	}	

	time1= ioread32(CLOCKDELAY_BASE+CUR_VALUE);
	ddr.result =result_info; 

	if(size>=0x10000)
		ddr.size = 0xffff;	
	else
		ddr.size = size;	
	
	for(cnt=0; cnt<1000;cnt++){
		//a to b 
		zx_cacheable_dma_flag=0;
		ddr_dma_config(ddrtest_phy_addr, ddrtest_phy_addr+size, ddr.size);
		ddr_dma_start(&ddr,cacheable_speed_cb);
		while(!zx_cacheable_dma_flag);
		
		//b to a
		zx_cacheable_dma_flag=0;
		ddr_dma_config(ddrtest_phy_addr+size, ddrtest_phy_addr, ddr.size);
		ddr_dma_start(&ddr,cacheable_speed_cb);
		while(!zx_cacheable_dma_flag);
		zx_cacheable_dma_flag=0;
	
	}

	time2 = ioread32(CLOCKDELAY_BASE+CUR_VALUE);

	if(time1>=time2)
		elapse_time=(time1 - time2)/(2*cnt*26);
	else
		elapse_time=(0xffffffff -(time2 - time1))/(2*cnt*26);

	speed = (size/1024 *1000000/elapse_time/1024);

	
	dma_release_channel(ddrtest_chan);	
	dma_unmap_single(NULL, ddrtest_phy_addr, 2* size, DMA_BIDIRECTIONAL);	
	kfree(ddrtest_buffer);	

	pr_info("zx_ddr_cacheable_speed: %d MByte/s .  elapse_time: %d us elapse_time     \n", speed , elapse_time);
	sprintf(result_info->speed, "ddr read_write speed:%d MByte/s", speed);	
	
	return 0;
}

#endif


SYSCALL_DEFINE5(get_ddrtestinfo, char __user *, noncache_cpu, 
										char __user *, cacheable_cpu, 
										char __user *, noncache_dma, 
										char __user *, cacheable_dma,
										char __user *, speed)
{
	int err = 0;
	
#ifdef CONFIG_DDR_ZX29_MODULE
	
	struct ddr_test_result 		result_info ={0};

	//pr_info("\n get_ddrtestinfo  begin \n");


	if (noncache_cpu) {
		err =ddr_noncache_cpu_test(DDR_TEST_SIZE, &result_info);
		if(err)
			return -EINVAL;

		err |= copy_to_user(noncache_cpu, &result_info.noncache_cpu, sizeof(result_info.noncache_cpu));
	}

	if (cacheable_cpu) {
		err =ddr_cacheable_cpu_test(DDR_TEST_SIZE, &result_info);
		if(err)
			return -EINVAL;		
		err |= copy_to_user(cacheable_cpu, &result_info.cacheable_cpu, sizeof(result_info.cacheable_cpu));
	}
	if (noncache_dma) {
		err =ddr_noncache_dma_test(DDR_TEST_SIZE, &result_info);
		if(err)
			return -EINVAL;		
		err |= copy_to_user(noncache_dma, &result_info.noncache_dma, sizeof(result_info.noncache_dma));
	}
	if (cacheable_dma) {
		err =ddr_cacheable_dma_test(DDR_TEST_SIZE, &result_info);
		if(err)
			return -EINVAL;		
		err |= copy_to_user(cacheable_dma, &result_info.cacheable_dma, sizeof(result_info.cacheable_dma));
	}
	if (speed) {
		err =ddr_cacheable_speed_test(DDR_TEST_SIZE, &result_info);
		if(err)
			return -EINVAL;		
		err |= copy_to_user(speed, &result_info.speed, sizeof(result_info.speed));
	}	

	//pr_info("\n get_ddrtestinfo  end \n");
#endif

	
	return err ? -EFAULT : 0;

}
#ifdef CONFIG_DDR_ZX29_MODULE

#define TEST_TIMES 30
void zx_ddr_test(void)
{
	int err = 0;
	int i =TEST_TIMES;
	
	struct ddr_test_result 		result_info ={0};

	pr_info("\n ddr_test  begin \n");

	while(i--)
	{

		pr_info("\n test times =%d\n", TEST_TIMES-i);

		err= ddr_noncache_cpu_test(DDR_TEST_SIZE, &result_info);
		if(err)
			pr_info("ddr_noncache_cpu_test failed!");

		err=ddr_cacheable_cpu_test(DDR_TEST_SIZE, &result_info);
		if(err)
			pr_info("ddr_cacheable_cpu_test failed!");
		
		err=ddr_noncache_dma_test(DDR_TEST_SIZE, &result_info);
		if(err)
			pr_info("ddr_noncache_dma_test failed!");
			
		err=ddr_cacheable_dma_test(DDR_TEST_SIZE, &result_info);
		if(err)
			pr_info("ddr_cacheable_dma_test failed!");

		err =ddr_cacheable_speed_test(DDR_TEST_SIZE, &result_info);
		if(err)
			pr_info("ddr_cacheable_speed_test failed!");
	
		msleep(2);

	}

	//pr_info("\n ddr_test  end \n");
}

EXPORT_SYMBOL(zx_ddr_test);
#endif
