/*
 * ZTE zx297510 dvfs driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by zxp
 *
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/err.h>
#include <linux/clk.h>
#include <linux/io.h>
#include <linux/slab.h>
#include <linux/cpufreq.h>
#include <linux/suspend.h>

#include <linux/soc/zte/rpm/rpmsg.h>
//#include "mach/clock.h"
#include <linux/miscdevice.h>
#include <linux/uaccess.h>
#include <linux/fs.h>
#include "zx-pm.h"
#define ZX_CPUFREQ_IOC_MAGIC     'W'

/*ioctl cmd usd by device*/
#define ZX_CPUFREQ_SET_FREQ         	_IOW(ZX_CPUFREQ_IOC_MAGIC, 1, char *)
#define ZX_CPUFREQ_GET_FREQ           _IOW(ZX_CPUFREQ_IOC_MAGIC, 2, char *)

#define ZX_CPUFREQ_DEV    "/dev/zx_cpufreq"

#define	PM_FREQ_TRACE	1
#if PM_FREQ_TRACE

#define	FREQ_CHANGE_COUNT	20

typedef struct
{
	volatile unsigned int old_index;
	volatile unsigned int new_idex;
	volatile unsigned int time;
}freq_change_view_trace_t;

static freq_change_view_trace_t 	freq_change_view[FREQ_CHANGE_COUNT] ;
static unsigned int				freq_change_index = 0;

void trace_freq_change(unsigned int old_index,unsigned int new_index)
{
	freq_change_view[freq_change_index].old_index = old_index;
	freq_change_view[freq_change_index].new_idex = new_index;
	freq_change_view[freq_change_index].time = ktime_to_us(ktime_get());
	freq_change_index++;
	if(freq_change_index == FREQ_CHANGE_COUNT)
	{
		freq_change_index = 0;
	}
}
#else
void trace_freq_change(unsigned int old_index,unsigned int new_index){}
#endif

unsigned int freq_change_enabled_by_startup = 0;
static struct delayed_work 	pm_freq_work;
#define PM_FREQ_DELAY 		msecs_to_jiffies(25000)

/* for count change time by M0 */
#define DEBUG_CPUFREQ_TIME	1

#ifdef CONFIG_DDR_FREQ
#ifdef CONFIG_ARCH_ZX297520V2
#define	get_cur_ddr()				pm_read_reg_16(AXI_CURRENT_FREQ)
#define	set_target_ddr(f)			pm_write_reg_16(AXI_AP2M0_TARGET, f)
#define	set_ddr_req()				pm_write_reg_16(AXI_AP2M0_FLAG, 1)
#define	clr_ddr_ack()				pm_write_reg_16(AXI_M02AP_ACK, 0)

#define wait_ddr_ack()				while(!pm_read_reg_16(AXI_M02AP_ACK))
#else
static ddr_freq_regs *ddr_regs = (ddr_freq_regs *)IRAM_CHANGE_DDR_BASE;
#define	get_cur_ddr()				(ddr_regs->cur_freq)
#define	set_target_ddr(f)			(ddr_regs->ap_exp_freq = f)
#define	set_ddr_req()				(ddr_regs->ap_req_flag = 1)

#endif
#endif

//#undef CONFIG_AXI_FREQ
#ifdef CONFIG_AXI_FREQ
static DEFINE_MUTEX(axifreq_lock);

static axi_freq_regs *axi_regs = (axi_freq_regs *)IRAM_CHANGE_AXI_BASE;
static vol_dvs_regs *vol_regs = (vol_dvs_regs *)IRAM_CHANGE_DVS_BASE;

#define	get_cur_axi()				(axi_regs->cur_freq)
#define	set_target_axi_sw(f)				(axi_regs->ap_exp_freq = f)
#define	set_axi_req()				(axi_regs->ap_req_flag = 1)

#define get_target_axi_hw(addr)     (pm_read_reg(addr)&(0x7))

#if 1
#define DDR_FREQ_156M_HW             (0x4e)
#define DDR_FREQ_208M_HW             (0x68)
#define DDR_FREQ_312M_HW             (0x9c)
#define DDR_FREQ_400M_HW             (0xc8)

#define set_ddr_freq_hw(addr,f)      (pm_read_reg(addr)&(~0xff)|f)
#define set_ddr_freq_sync(addr,f)    (pm_read_reg(addr)&(~0x1)|f)
#endif

#define	get_cur_vol()				(vol_regs->cur_vol)
#define	set_target_vol(f)				(vol_regs->ap_exp_vol = f)
#define	set_vol_req()				(vol_regs->ap_req_flag = 1)

#if 0
#define	WAIT_AXI_ACK_TIMEOUT		(jiffies + msecs_to_jiffies(2))	/* wait 2 ms, we count max 200us also */
#define wait_axi_ack(timeout)		while(!pm_read_reg_16(AXI_M02AP_ACK) && time_before(jiffies, timeout))
#else
#define	WAIT_AXI_ACK_TIMEOUT		(200)			/* wait 120us, we count max 200us also */
static void wait_axi_ack(unsigned timeout)
{
	ktime_t begin_time = ktime_get();
	
	while(((vol_regs->ap_req_flag) ||(axi_regs->ap_req_flag) )&& (unsigned)ktime_to_us(ktime_sub(ktime_get(), begin_time))<timeout);
}
#endif

#ifdef CONFIG_ZX_PM_DEBUG
static unsigned axi_freq_table[]=
{
#ifdef CONFIG_ARCH_ZX297520V2
    26000,
    39000,
    52000,
    78000,
    104000,
    122880,
    156000,
#else
    6500,
    26000,
    39000,
    52000,
    78000,
    104000,
    124800,
    156000,
#endif
};

static unsigned get_axi_freq(void)
{
#if 1
	return 0;
#else
	void __iomem *regaddr = NULL;
	unsigned int data = 0;
	unsigned int axi_rate = 0;

    regaddr = (ZX29_TOP_VA+0x54);
	data = ioread32(regaddr);
    data &= 0x3;
    switch (data) {
        case 0: axi_rate = 104000000;break;
        case 1: axi_rate = 26000000;break;
        case 2: axi_rate = 122880000;break;
        case 3: axi_rate = 156000000;break;
        default:
            break;      
    }
    
    regaddr = (ZX29_TOP_VA+0x7c);
	data = ioread32(regaddr);
    data &= 0x3;
    return axi_rate/(0x1<<data);
#endif	
}
static void debug_axi_clk_info(void)
{
	pr_info("current_axi_freq:%d[KHz]   request_axi_freq:%d[KHz]\n", axi_freq_table[get_cur_axi()] ,axi_freq_table[axi_regs->ap_exp_freq]);
}
#endif

static int send_msg_to_m0(void)
{
	unsigned int ap_m0_buf = AXI_VOL_CHANGE_ICP_BUF;		/* the icp interface need a buffer */
	T_ZDrvRpMsg_Msg Icp_Msg;
	int				ret;	

	Icp_Msg.actorID = M0_ID;
	Icp_Msg.chID 	= ICP_CHANNEL_PSM;
	Icp_Msg.flag 	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
	Icp_Msg.buf 	= &ap_m0_buf;
	Icp_Msg.len 	= 0x4;	

	ret = zDrvRpMsg_Write(&Icp_Msg);
	if(Icp_Msg.len == ret)
		return 0;
	else
		return ret;
}

static int axi_freq_change_allowed(void)
{
	if(pm_get_mask_info()&PM_NO_AXI_FREQ)
		return false;
	
	return true;
}

/**
 * request to change vol.
 *
 * vol_dvs: input vol enum
 */
int request_vol(zx29_vol vol_dvs)
{
	unsigned int current_vol = get_cur_vol();

	set_target_vol(vol_dvs);
#if DEBUG_CPUFREQ_TIME		
	pm_printk("[CPUFREQ] current_vol(%d)  request_vol(%d)  \n",(u32)current_vol,(u32)vol_dvs);	
#endif
	
	if(vol_dvs != current_vol)
	{
		/* request freq */
		set_vol_req();
	}
	
	return 0;
}

/**
 * input axi freq.
 */
static zx29_vol request_vol_by_axi(zx29_axi_freq axi_freq)
{
	if(axi_freq == AXI_FREQ_156M)
		return VOL_VO_900;
	else
		return VOL_VO_850;
}

/**
 * set vol . 
 *
 * we will do this by M0.
 */
static int set_vol_by_axi(zx29_axi_freq axi_freq)
{
	zx29_vol vol_dvs= request_vol_by_axi(axi_freq);
	
	/* set new vol*/
	return request_vol(vol_dvs);
}


/**
 * request to change axi freq.
 *
 * axi_freq: input freq enum
 */
int request_axi_freq(zx29_axi_freq axi_freq)
{
    unsigned int  current_axi_freq = get_cur_axi();
	unsigned int tmp;
	int		 ret = 0;	
	
#if DEBUG_CPUFREQ_TIME	
	ktime_t begin_time, end_time;
	s64 total_time;
#endif	

	if(!axi_freq_change_allowed())
		return 0;

#ifdef SET_AXI_BY_HW
	tmp = (pm_read_reg(PS_MATRIX_AXI_SEL)&(~0x7))|axi_freq;
	pm_write_reg(PS_MATRIX_AXI_SEL,tmp);
    pm_printk("[CPUFREQ] current_axi_freq(%d)  request_axi_freq(%d)  after_request_axi_freq(%d)  after_request_vol(%d)\n",(u32)current_axi_freq,(u32)axi_freq,get_cur_axi(),get_cur_vol());		
#else
	set_target_axi_sw(axi_freq);

	if(axi_freq != current_axi_freq)
	{
		/* request freq */
		set_axi_req();
		
//		set_vol_by_axi(axi_freq);//set vol

		ret = send_msg_to_m0();	
#if DEBUG_CPUFREQ_TIME	
        begin_time = ktime_get();
#endif
        if(!ret)
        {
            /* wait axi freq changed ok! we will set a timeout for safety~ */
            wait_axi_ack(WAIT_AXI_ACK_TIMEOUT);		
        }
        else
        {
            pm_printk("[CPUFREQ] request_axi_freq(%d) failed: (%d) \n",(u32)axi_freq, ret);
        }

#if DEBUG_CPUFREQ_TIME	
        end_time = ktime_get();
        total_time = ktime_to_us(ktime_sub(end_time, begin_time));
        pm_printk("[CPUFREQ] total axi time: %d us  current_axi_freq(%d)  request_axi_freq(%d)  after_request_axi_freq(%d)  after_request_vol(%d)\n",(u32)total_time,(u32)current_axi_freq,(u32)axi_freq,get_cur_axi(),get_cur_vol());	
	}	
	else
	{
    pm_printk("[CPUFREQ]   current_axi_freq(%d)  request_axi_freq(%d) \n",(u32)current_axi_freq,(u32)axi_freq);	
#endif
	}
#endif

	return 0;
}


/**
 * input cpu freq [KHz].
 */
static zx29_axi_freq request_axi_freq_by_cpu(unsigned int freq)
{
	if(freq >= 600*1000)
		return AXI_FREQ_156M;
	else
		return AXI_FREQ_78M;
}

/**
 * set axi freq . 
 *
 * we will do this by M0.
 */
static int set_axi_frequency_by_cpu(unsigned int freq)
{
	zx29_axi_freq axi_freq = request_axi_freq_by_cpu(freq);
	
	/* set new freq */
	return request_axi_freq(axi_freq);
}
#endif

static int zx29_get_frequency(void);

int zx29_set_frequency(unsigned int old_index,
				     unsigned int new_index);
static int zx29_cpufreq_init(struct zx_dvfs_info *info);

#define CPUFREQ_LEVEL_END	L3

static int max_support_idx = L0;
#ifdef CONFIG_ARCH_ZX297520V2
static int min_support_idx = (CPUFREQ_LEVEL_END - 1);
#else
static int min_support_idx = (CPUFREQ_LEVEL_END - 2);
#endif
static int cpufreq_driver_inited = 0;
static struct clk *cpu_clk;

/* in fact, zx297510 can not adjust core voltage, we reserved it for future if it be... */
static unsigned int zx29_volt_table[CPUFREQ_LEVEL_END] = {
	1250000, 1150000, 1050000, /*975000, 950000,*/
};

static struct cpufreq_frequency_table zx29_freq_table[] = {
#ifdef CONFIG_ARCH_ZX297520V2
	{L0, 624*1000},
	{L1, 312*1000},
	{L2, 208*1000},
	{0, CPUFREQ_TABLE_END},
#else
	{L0, 624*1000},
	{L1, 312*1000},
	//{L2, 156*1000},
	{0, CPUFREQ_TABLE_END},
#endif
};

#ifdef CONFIG_ZX_PM_DEBUG

/* for debug freq */
void debug_cpu_freq_info(void)
{
	printk("[CPUFREQ]  current_cpufreq(%d) ",zx29_get_frequency());
 #ifdef CONFIG_AXI_FREQ
    printk("request_axi_freq(%d) current_axi_freq(%d)\n",axi_regs->ap_exp_freq,get_cur_axi());	
 #endif
}

/* for debug clock state */
static void debug_cpu_clk_info(void)
{
#if 0 //zxp
	unsigned 	cpu_clock;
	char * 		pll_used;
	unsigned 	ufi_clk_div;

	ufi_clk_div = 1 << (pm_read_reg(TOP_UFI_DIV_REG)&0x3);
	pll_used 	= ufi_pll_str[pm_read_reg(TOP_UFI_SEL_REG)&3];
	cpu_clock	= clk_get_rate(cpu_clk) / 1000;

	pr_info("cpu_clock[KHz]   	pll_used       ufi_clk_div\n");	
	pr_info("%d   	          %s           %d\n", cpu_clock, pll_used, ufi_clk_div);	
#endif		
}

static struct zx_dvfs_info test_dvfs_info;
void cpufreq_test(unsigned int old_index, unsigned int new_index)
{
	zx29_cpufreq_init(&test_dvfs_info);

	zx29_set_frequency(old_index, new_index);
}

#else
static void debug_cpu_clk_info(void){}
static void debug_axi_clk_info(void){}
#endif


static void pm_freq_func(struct work_struct *work)
{
	freq_change_enabled_by_startup = 1;
}

static int zx29_get_frequency(void)
{
#ifdef CONFIG_ARCH_ZX297520V2
	int	ret = L2;
	unsigned int	cpufreq;
	cpufreq = pm_read_reg(AP_CORE_SEL_ADDR)&0x7;
	switch(cpufreq)
	{
		case 0:			//624M
			ret = L0;
			break;
		case 3:			//312M
			ret = L1;
			break;
		case 4:			//208M
			ret = L2;
			break;
		default:
			printk("[CPUFREQ] get freq fail cpufreq :0x%x\n",cpufreq);
			break;		
	}
	return ret;	
#else
	int	ret = L1;
	unsigned int	cpufreq;
	cpufreq = pm_read_reg(AP_CORE_SEL_ADDR)&0x3;
	switch(cpufreq)
	{
		case 1:			//624M
			ret = L0;
			break;
		case 2:			//312M
			ret = L1;
			break;
		case 3:			//156M
			ret = L2;
			break;
		default:
			printk("[CPUFREQ] get freq fail cpufreq :0x%x\n",cpufreq);
			break;		
	}
	return ret;	
#endif	
}

int cpufreq_performance(void);
int cpufreq_powersave(void);
int cpufreq_normal(void);

/**
 * set freq according to index of freq_table. 
 * 
 */
int zx29_set_frequency(unsigned int old_index,
				     unsigned int new_index)
{
	int	ret = 0;

#if 0
	if(!freq_change_enabled_by_startup)
		return -1;

	if(old_index == new_index)
		return ret;
	ret = clk_set_rate(cpu_clk, zx29_freq_table[new_index].frequency * 1000);
	if (ret) 
		pm_printk("[CPUFREQ] Failed to set rate %dkHz: ret = %d\n", zx29_freq_table[new_index].frequency, ret);
	
	pm_printk("[CPUFREQ] set cpufreq:old index:%d new index:%d \n", old_index, new_index);
//	printk("[CPUFREQ] set cpufreq:old index:%d new index:%d current_axi_freq(%d)\n", old_index, new_index,get_cur_axi());
	debug_cpu_clk_info();

	trace_freq_change(old_index,new_index);

#ifdef CONFIG_AXI_FREQ
	mutex_lock(&axifreq_lock);
	set_axi_frequency_by_cpu(zx29_freq_table[new_index].frequency);
	mutex_unlock(&axifreq_lock);	
#endif

#endif

	return ret;	
}

int zx29_set_frequency_new(unsigned int old_index,
				     unsigned int new_index)
{
	int	ret = 0;

	if(!freq_change_enabled_by_startup)
		return -1;
/*
	if(old_index == new_index)
		return ret;
*/
	ret = clk_set_rate(cpu_clk, zx29_freq_table[new_index].frequency * 1000);
	if (ret) 
		pm_printk("[CPUFREQ] Failed to set rate %dkHz: ret = %d\n", zx29_freq_table[new_index].frequency, ret);
	
	pm_printk("[CPUFREQ] set cpufreq:old index:%d new index:%d \n", old_index, new_index);
//	printk("[CPUFREQ] set cpufreq:old index:%d new index:%d current_axi_freq(%d)\n", old_index, new_index,get_cur_axi());
	debug_cpu_clk_info();

	trace_freq_change(old_index,new_index);

#ifdef CONFIG_AXI_FREQ
	mutex_lock(&axifreq_lock);
	set_axi_frequency_by_cpu(zx29_freq_table[new_index].frequency);
	mutex_unlock(&axifreq_lock);	
#endif	
		
	return ret;	
}


/**
 * set freq according to index of freq_table. 
 * 
 */
 unsigned int cpu_dfs_is_not_allowed =0; 	/*1: when 3g upa/dpa, the A53 core freq should always be 624M**/
 unsigned int cpufreq_level =0;
 extern struct mutex cpufreq_lock;

int zx_set_frequency(unsigned int  freq)
{
	if(freq==624000000) {
		return cpufreq_performance();
	} else{
		return cpufreq_normal();
	}
}
EXPORT_SYMBOL(zx_set_frequency);

static int zx29_cpufreq_init(struct zx_dvfs_info *info)
{
	if(cpufreq_driver_inited)
		return 0;

	cpu_clk = clk_get(NULL, "cpu_clk");
	if (IS_ERR(cpu_clk))
	{
		pr_info("[CPUFREQ] get cpu_clk error \n");
		return PTR_ERR(cpu_clk);
	}
#ifdef CONFIG_ARCH_ZX297520V2
	info->freq_cur_idx 		= L2;
	info->pll_safe_idx 		= L2;
#else
	info->freq_cur_idx 		= L1;
	info->pll_safe_idx 		= L1;
#endif
	info->max_support_idx 	= max_support_idx;
	info->min_support_idx 	= min_support_idx;
	info->cpu_clk 			= cpu_clk;
	info->volt_table 		= zx29_volt_table;
	info->freq_table 		= zx29_freq_table;
	info->set_freq 			= zx29_set_frequency_new;

	cpufreq_driver_inited = 1;

	INIT_DELAYED_WORK_DEFERRABLE(&pm_freq_work, pm_freq_func);
	schedule_delayed_work(&pm_freq_work, PM_FREQ_DELAY);
	pr_info("[CPUFREQ] zx29_cpufreq_init ok \n");
	return 0;
}

static int __init zx29_freq_register(void)
{
	zx29xx_cpufreq_init = zx29_cpufreq_init;

	return 0;
}
device_initcall(zx29_freq_register);

#ifdef CONFIG_AXI_FREQ
/**
 * zx_axifreq_pm_notifier - acquire axifreq in suspend-resume context
 *			
 * @notifier
 * @pm_event
 * @v
 *
 */

static int zx_axifreq_pm_notifier(struct notifier_block *notifier,
				       unsigned long pm_event, void *v)
{
	mutex_lock(&axifreq_lock);
	
	switch (pm_event) 
	{
	case PM_SUSPEND_PREPARE:
		request_axi_freq(AXI_FREQ_78M);
		break;

	case PM_POST_SUSPEND:
		request_axi_freq(AXI_FREQ_156M);
		break;
	}
	
	mutex_unlock(&axifreq_lock);

	return NOTIFY_OK;
}

static struct notifier_block zx_axifreq_nb = 
{
	.notifier_call = zx_axifreq_pm_notifier,
};

static int __init zx29_axifreq_init(void)
{

	/* pm notify */
	register_pm_notifier(&zx_axifreq_nb);
//	request_vol(VOL_VO_900);
	request_axi_freq(AXI_FREQ_156M);		

	return 0;
}

//late_initcall(zx29_axifreq_init);
#endif	

/*=============================================================================
 *========  zx29 DDR freq ===============================================
 *** ap/phy request --> m0 notify --> jump to iram --> wait completely -->  ***
 *** -->jump to ddr                                                     ***====
 *=============================================================================
 */
#ifdef CONFIG_DDR_FREQ
static DEFINE_MUTEX(ddrfreq_lock);
static int ddr_freq_change_allowed(void)
{
	if(pm_get_mask_info()&PM_NO_DDR_FREQ)
		return false;
	
	return true;
}

static int send_msg_to_ps(void)
{
	unsigned int ap_m0_buf = AXI_VOL_CHANGE_ICP_BUF;		/* the icp interface need a buffer */
	T_ZDrvRpMsg_Msg Icp_Msg;
	int				ret;	
	Icp_Msg.actorID = PS_ID;
	Icp_Msg.chID 	= ICP_CHANNEL_PSM;
	Icp_Msg.flag 	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
	Icp_Msg.buf 	= &ap_m0_buf;
	Icp_Msg.len 	= 0x4;	
	ret = zDrvRpMsg_Write(&Icp_Msg);
	if(Icp_Msg.len == ret)
		return 0;
	else
		return ret;
}

int request_ddr_freq_hw(unsigned int ddr_freq)
{
    if(!ddr_freq_change_allowed())
		return 0;
	pm_write_reg(AP_DDR_FFC_SEL_SYNC,0x0);
	pm_write_reg(AP_DDR_FFC_SEL,ddr_freq);
	pm_write_reg(AP_DDR_FFC_SEL_SYNC,0x1);
	return 0;
}

int request_ddr_freq(zx29_ddr_freq ddr_freq)
{
	int		 ret = 0;
	unsigned current_ddr_freq = get_cur_ddr();
	if(!ddr_freq_change_allowed())
		return 0;

	if(ddr_freq == current_ddr_freq)
		return 0;
	
#ifdef SET_DDR_BY_HW
    //set_ddr_freq_hw(AP_DDR_FFC_SEL, ddr_exp_freq);
    set_ddr_freq_sync(AP_DDR_FFC_SEL_SYNC,0x1);
#else
	set_target_ddr(ddr_freq);
	ret = send_msg_to_ps();
	if(!ret)
	{
		printk("[DDRFREQ] ddr_freq [%d]\n",get_cur_ddr());
	}
	else
	{
		printk("[DDRFREQ] request_ddr_freq failed\n");
	}
#endif
#if 0
    unsigned current_ddr_freq = get_cur_ddr();
	int		 ret = 0;	
	
#if DEBUG_CPUFREQ_TIME	
	ktime_t begin_time, end_time;
	s64 total_time;
#endif	

	if(!ddr_freq_change_allowed())
		return 0;

	set_target_ddr(ddr_freq);

    if(ddr_freq != current_ddr_freq)
    {
		/* request freq */
		clr_ddr_ack();
		set_ddr_req();

#if DEBUG_CPUFREQ_TIME	
		begin_time = ktime_get();
#endif

		ret = send_msg_to_m0();
		if(!ret)
			/* wait axi freq changed ok! we will set a timeout for safety~ */
			wait_ddr_ack();		
		else
			pr_info("[CPUFREQ] request_ddr_freq(%d) failed: (%d) \n",(u32)ddr_freq, ret);

#if DEBUG_CPUFREQ_TIME	
		end_time = ktime_get();
		total_time = ktime_to_us(ktime_sub(end_time, begin_time));
		pr_info("[CPUFREQ] total ddr time: %d us\n",(u32)total_time);		
#endif
    }	
#endif
	return 0;
}

#ifdef CONFIG_ARCH_ZX297520V2
static void ddr_freq_handler(void)
{
	local_irq_disable();
	waiting_ddr_dfs((unsigned long)DDR_DFS_CODE_ADDR);
	local_irq_enable();	
}
#else
static int zx_ddrfreq_pm_notifier(struct notifier_block *notifier,
				       unsigned long pm_event, void *v)
{
	mutex_lock(&ddrfreq_lock);
	switch (pm_event) 
	{
	case PM_SUSPEND_PREPARE:
		request_ddr_freq_hw(0);
		break;
	case PM_POST_SUSPEND:
		request_ddr_freq_hw(0x9c);
		break;
	}
	mutex_unlock(&ddrfreq_lock);
	return NOTIFY_OK;
}
static struct notifier_block zx_ddrfreq_nb = 
{
	.notifier_call = zx_ddrfreq_pm_notifier,
};
#endif

static int __init zx29_ddrfreq_init(void)
{
#ifdef CONFIG_ARCH_ZX297520V2
#else
	register_pm_notifier(&zx_ddrfreq_nb);
#endif
	return 0;
}

#endif

static void pm_m0_handler(void *buf, unsigned int len)
{
	/* deal msg from m0 */
}

static long zx_cpufreq_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	
	int ret = 0;
	unsigned int temp;

	if (arg == NULL)
		return -EFAULT;
	
	switch(cmd)
	{
		case ZX_CPUFREQ_SET_FREQ:
			ret = copy_from_user(&temp, (unsigned int*)arg, sizeof(unsigned int));
			if(ret)
				printk("%s: copy_from_user failed\n",__func__);		
			zx_set_frequency(temp);	
			break;

		case ZX_CPUFREQ_GET_FREQ:
			//cpufreq_level = zx29_get_frequency();
			//printk("%s: cpufreq_level:%d\n",__func__, cpufreq_level);
			temp = zx_getspeed(0)*1000;
			ret = copy_to_user((void *)arg, &temp, sizeof(unsigned int));
			if(ret)
				printk("%s: copy user failed\n",__func__);
			break;

		default:
			return -EPERM;
	}
	
	return ret;
}

static const struct file_operations zx_cpufreq_fops = {
	.owner		= THIS_MODULE,
	.unlocked_ioctl	= zx_cpufreq_ioctl,
};

static struct miscdevice zx_cpufreq_miscdev = {
	.minor		= MISC_DYNAMIC_MINOR,
	.name		= "zx_cpufreq",
	.fops		= &zx_cpufreq_fops,
};
static int __init zx29_intercore_init(void)
{
	int ret = 0;
	
#ifdef CONFIG_ARCH_ZX297520V2
	ret = zDrvRpMsg_CreateChannel(M0_ID, ICP_CHANNEL_PSM, 0x20);
	if(ret)
	{
		pr_info("[CPUFREQ] Failed create psm icp channel, err:%d ! \n", ret);
		return -EPERM;
	}
	pr_info("[CPUFREQ] Success create psm icp channel!!! \n");

	zDrvRpMsg_RegCallBack(M0_ID, ICP_CHANNEL_PSM, pm_m0_handler);

#ifdef CONFIG_AXI_FREQ
	zx29_axifreq_init();
#endif

#ifdef CONFIG_DDR_FREQ
	#if 0
	ret = zDrvRpMsg_CreateChannel(PS_ID, ICP_CHANNEL_PSM, 0x20);
	if(ret)
	{
		printk("[DDRFREQ] Failed create psm icp channel, err:%d ! \n", ret);
		return -EPERM;
	}
	printk("[DDRFREQ] Success create psm icp channel!!! \n");
	#endif
	zx29_ddrfreq_init();
#endif
#endif

	ret = misc_register(&zx_cpufreq_miscdev);
	if (ret) {
		printk(KERN_ERR"%s: cpufreq failed to register miscdev (ret = %d)\n", __FILE__, ret);
		return ret;
	}
	
	return 0;
}
#ifdef CONFIG_ARCH_ZX297520V2
late_initcall(zx29_intercore_init);
#else
late_initcall(zx29_intercore_init);
#endif
