/*
 *  zx297520v2-pm.h - zx297520v2 power management interface.
 *
 *  Written by zxp.
 *
 */

#ifndef _ZX29_PM_H
#define _ZX29_PM_H
#include <mach/iomap.h>

#define pm_reg_sync_write 						zx_reg_sync_write
#define pm_read_reg 							zx_read_reg
#define pm_write_reg							zx_write_reg
#define pm_set_reg								zx_set_reg
#define pm_clr_reg								zx_clr_reg
#define pm_reg_sync_write_16					zx_reg_sync_write_16
#define pm_read_reg_16							zx_read_reg_16
#define pm_write_reg_16							zx_write_reg_16

#define	ZX_A9_PERIPHERAL_PHYS					(ZX29_A9_PERIPHERAL_PHYS)
#define	A9_CRM_PHYS								(ZX_A9_PERIPHERAL_PHYS + 0x3000)
#define	ZX_L2CACHE_CONFIG_PHYS					(ZX29_L2CACHE_CONFIG_PHYS)

#define	INVALID_INT_NUM							(0xFFFF)

#define	__SLEEP_TIME_1s__						((s64)(1000000))
#define	__SLEEP_TIME_1m__						(__SLEEP_TIME_1s__*60)
#define	__SLEEP_TIME_1h__						(__SLEEP_TIME_1m__*60)
#define	__MAX_SLEEP_TIME__						(__SLEEP_TIME_1h__*18)

/* iram1 is for axi_freq and debug, data will not lost when system died */
/*===================================================================
 *==  iram1 address allocation  =====================================
 *===================================================================
 *========= 0x2000 ~~  0x2FFF : AP debug ram      ===================
 *========= 0x3000 ~~  0x37FF : common use        ===================
 *========= 0x30A0 ~~  0x30AF : at command        ===================
 *========= 0x3140 ~~  0x316F : ddr freq area     ===================
 *========= 0x3170 ~~  0x318F : axi freq area     ===================
 *========= 0x3190 ~~  0x31bF : dvs area          ===================
 *===================================================================
 */
#ifdef CONFIG_ARCH_ZX297520V2
#define	IRAM_PM_BASE							(ZX_IRAM1_BASE) 

#define	IRAM_AP_DEBUG_ADDR						(IRAM_PM_BASE + 0x2000)
#define	IRAM_AP_DEBUG_LEN						(0x1000)

#define	IRAM_COMMON_USE_ADDR					(IRAM_PM_BASE + 0x3000)
#define	IRAM_COMMON_USE_LEN						(0x800)

#define	IRAM_PS_SLEEP_FLAG_ADDR					(IRAM_COMMON_USE_ADDR + 0x30)

#define	IRAM_AT_COMMAND_ADDR					(IRAM_COMMON_USE_ADDR + 0xA0)

#define IRAM_CHANGE_DDR_BASE       				(IRAM_COMMON_USE_ADDR + 0x140)
#define IRAM_CHANGE_AXI_BASE       				(IRAM_COMMON_USE_ADDR + 0x180)
#define IRAM_CHANGE_DVS_BASE       				(IRAM_COMMON_USE_ADDR + 0x1a0)  /* TBD */

#define	AP_SUSPEND_FOR_POWEROFF_CNT				(IRAM_COMMON_USE_ADDR + 0x114)
#define AP_SLEEP_TIME_ADDR                      (IRAM_COMMON_USE_ADDR + 0x130)

/*test flag*/
#define IRAM_ADDR_FOR_SLEEP_CNT					(IRAM_AP_DEBUG_ADDR + 0x0)
#define IRAM_ADDR_FOR_WAKE_CNT					(IRAM_AP_DEBUG_ADDR + 0x4)
#define	SLEEP_TIME_ADDR							(SYSTEM_WAKEUP_ADDR + 0x8)
#define	AP_SUSPEND_STATUS_FLAG					(IRAM_AP_DEBUG_ADDR + 0xC)	
#define	AP_SUSPEND_FOR_SLEEP_CNT				(IRAM_AP_DEBUG_ADDR + 0x10)
#define	AP_IDLE_SLEEP_STATUS_FLAG				(IRAM_AP_DEBUG_ADDR + 0x14)
#else

#ifdef CONFIG_ARCH_ZX297520V3_CAP
#define	IRAM_PM_BASE							(ZX_IRAM1_BASE + 0x2000) /*0x00102000*/
#else
#define	IRAM_PM_BASE							(ZX_IRAM1_BASE) /*0x00100000*/
#endif

#define	IRAM_AP_DEBUG_ADDR						(IRAM_PM_BASE + 0x400) /*0x00102400/0x00100400*/

#define	IRAM_AP_DEBUG_LEN						(0x1000)/*4K*/


#define	IRAM_COMMON_USE_ADDR					(ZX_IRAM1_BASE + 0x1000)/*0x00101000 for psm flag*/

//#define	IRAM_COMMON_USE_LEN						(0x800)

#define	IRAM_PS_SLEEP_FLAG_ADDR					(IRAM_COMMON_USE_ADDR + 0x30)
#define	IRAM_AT_COMMAND_ADDR					(IRAM_COMMON_USE_ADDR + 0xA0)
#define IRAM_AP_DRV_FLAG_BASE       			(IRAM_COMMON_USE_ADDR + 0x58)  /* USB FLAG TO PROXY */

#define IRAM_CHANGE_DDR_BASE       				(IRAM_COMMON_USE_ADDR + 0x140)
#define IRAM_CHANGE_AXI_BASE       				(IRAM_COMMON_USE_ADDR + 0x180)
#define IRAM_CHANGE_DVS_BASE       				(IRAM_COMMON_USE_ADDR + 0x1a0)  /* TBD */

#ifdef CONFIG_ARCH_ZX297520V3_CAP
#define AP_SUSPEND_FOR_POWEROFF_CNT			(IRAM_COMMON_USE_ADDR + 0x114)
#define AP_SLEEP_TIME_ADDR                  (IRAM_COMMON_USE_ADDR + 0x134)
#else
#define AP_SUSPEND_FOR_POWEROFF_CNT			(IRAM_COMMON_USE_ADDR + 0x110)
#define AP_SLEEP_TIME_ADDR                  (IRAM_COMMON_USE_ADDR + 0x130)
#endif

/*test flag*/
#define IRAM_ADDR_FOR_SLEEP_CNT					(IRAM_AP_DEBUG_ADDR + 0x0)
#define IRAM_ADDR_FOR_WAKE_CNT					(IRAM_AP_DEBUG_ADDR + 0x4)
#define	SLEEP_TIME_ADDR							(IRAM_AP_DEBUG_ADDR + 0x8)//(SYSTEM_WAKEUP_ADDR + 0x8)
#define	AP_SUSPEND_STATUS_FLAG					(IRAM_AP_DEBUG_ADDR + 0xC)	
#define	AP_SUSPEND_FOR_SLEEP_CNT				(IRAM_AP_DEBUG_ADDR + 0x10)
#define	AP_IDLE_SLEEP_STATUS_FLAG				(IRAM_AP_DEBUG_ADDR + 0x14)



//#define	SUSPEND_START_TIME_ADDR					(IRAM_AP_DEBUG_ADDR + 0x10)	
//#define	SUSPEND_SAVE_TIME_ADDR			        (IRAM_AP_DEBUG_ADDR + 0x14)
//#define	SUSPEND_RESTORE_TIME_ADDR			    (IRAM_AP_DEBUG_ADDR + 0x18)				                        
#endif

/*  
 *	flag   : m0 set 0 when get request,  ap set 1 to request m0
 *  target : ap axi target, defined by zx297510_axi_freq
 *  cur    : current axi freq, defined by zx297510_axi_freq
 *  ack    : m0 set 1 when done request,  ap set 0 before new request
**/
typedef struct
{
    /* 0x00 */ volatile unsigned int ps_req_flag;
    /* 0x04 */ volatile unsigned int ps_exp_freq;

    /* 0x08 */ volatile unsigned int phy_req_flag;
    /* 0x0C */ volatile unsigned int phy_exp_freq;

    /* 0x10 */ volatile unsigned int ap_req_flag;
    /* 0x14 */ volatile unsigned int ap_exp_freq;

    /* 0x18 */ volatile unsigned int cur_freq;

}axi_freq_regs;

typedef struct
{
    /* 0x00 */ volatile unsigned int ps_req_flag;
    /* 0x04 */ volatile unsigned int ps_exp_vol;

    /* 0x08 */ volatile unsigned int phy_req_flag;
    /* 0x0C */ volatile unsigned int phy_exp_vol;

    /* 0x10 */ volatile unsigned int ap_req_flag;
    /* 0x14 */ volatile unsigned int ap_exp_vol;

    /* 0x18 */ volatile unsigned int cur_vol;

}vol_dvs_regs;

typedef struct
{
    /* 0x00 */ volatile unsigned int ps_req_flag;
    /* 0x04 */ volatile unsigned int ps_ack_flag;
    /* 0x08 */ volatile unsigned int ps_exp_freq;
	
    /* 0x0C */ volatile unsigned int phy_req_flag;
    /* 0x10 */ volatile unsigned int phy_ack_flag;
    /* 0x14 */ volatile unsigned int phy_exp_freq;
	
    /* 0x18 */ volatile unsigned int ap_req_flag;
    /* 0x1C */ volatile unsigned int ap_ack_flag;
    /* 0x20 */ volatile unsigned int ap_exp_freq;
	
    /* 0x24 */ volatile unsigned int cur_freq;
    /* 0x28 */ volatile unsigned int status;
}ddr_freq_regs;

/* pm mask flag for test */
#define	AT_COMMAND_READ_FLAG					(0x49435001)
#define	AXI_VOL_CHANGE_ICP_BUF					(0x49435002)

#ifdef CONFIG_ARCH_ZX297520V3_CAP
#define	PM_ALL_NO_SLEEP							(0x1)
#define	PM_NO_SLEEP								(0x1)
#define	PM_IDLE_WFI								(0x1)
#define	PM_SLEEP_FLAG_PRINT						(0x200)
#define	PM_NO_SUSPEND							(0x40000)
#define	PM_SUSPEND_WFI							(0x80000)

#else
#define	PM_ALL_NO_SLEEP							(0x1)
#define	PM_SLEEP_FLAG_PRINT						(0x200)
#define	PM_NO_SLEEP								(0x10000)
#define	PM_IDLE_WFI								(0x20000)
#define	PM_NO_SUSPEND							(0x40000)
#define	PM_SUSPEND_WFI							(0x80000)
#define	PM_NO_CPU_FREQ							(0x100000)
#define	PM_NO_AXI_FREQ							(0x200000)
#define	PM_NO_DDR_FREQ							(0x1000000)
#endif

/*===================================================================
 *==  iram address allocation  ======================================
 *===================================================================
 *========= 0      ~~  0x1FF : wakeup code area   ===================
 *========= 0x200  ~~  0x27F : code area_1        ===================
 *========= 0x280  ~~  0x2ff : code area_2        ===================
 *========= 0x300  ~~  0x33f : debug area         ===================
 *========= 0x340  ~~  999   : reserved[0]        ===================
 *========= 1000   ~~  1003  : code addr[0]       ===================
 *========= 1004   ~~  1023  : reserved[1]        ===================
 *===================================================================
 */
#define ioremap_mem(cookie,size)				__arm_ioremap((cookie), (size), MT_MEMORY)
#ifdef CONFIG_ARCH_ZX297520V2
#define	SYSTEM_WAKEUP_ADDR						(ZX29_IRAM0_PHYS)
#else
#ifdef CONFIG_ARCH_ZX297520V3_CAP
#define	SYSTEM_WAKEUP_ADDR						(ZX29_IRAM1_PHYS + 0x2000)//cap
#else
#define	SYSTEM_WAKEUP_ADDR						(ZX29_IRAM1_PHYS ) //(ZX29_IRAM1_PHYS + 0x2000)//ap
#endif
#endif

#define	WAKEUP_CODE_LENGTH						(0x200)
#define	SLEEP_CODE_LENGTH						(0x80)
#define	DDR_DFS_CODE_LENGTH						(0x80)

typedef struct
{
    /* 0x000 */  unsigned char wakeup_code[WAKEUP_CODE_LENGTH];
    /* 0x200 */  unsigned char sleep_code[SLEEP_CODE_LENGTH];
    /* 0x280 */  unsigned char ddr_dfs_code[DDR_DFS_CODE_LENGTH];
    /* 0x300 */  char padding1[1000-0x300];
    /* 1000 */   unsigned int reset_handler_vaddr;
    /* 1004 */   char padding2[20];
} wakeup_ram_area;

#ifdef CONFIG_ARCH_ZX297520V3_CAP
#define AP_CORE_SEL_ADDR           				(ZX_MATRIX_CRM_BASE + 0x40)
#else
#define AP_CORE_SEL_ADDR           				(ZX_MATRIX_CRM_BASE + 0x20)
#endif
#define CORE_ACS_CLK_SEL_EN           			(1<<8)
#ifdef CONFIG_ARCH_ZX297520V2
#define L2_STOPPED_SEL_EN           			(1<<9) /*a53 not has*/
#else
#define AP_AXI_CLKEN_ADDR           				(ZX_MATRIX_CRM_BASE + 0x44)
#define AP_TODDR_CLKEN_AUTO           			(1<<5)
#define AP_TOMATRIX_CLKEN_AUTO           			(1<<4)

#define PS_MATRIX_AXI_SEL                       (ZX_MATRIX_CRM_BASE + 0x120)
#define AP_MATRIX_AXI_SEL                       (ZX_MATRIX_CRM_BASE + 0x124)
#define AP_DDR_FFC_SEL                          (ZX_DDR_FFC_BASE + 0x220)
#define AP_DDR_FFC_SEL_SYNC                     (ZX_DDR_FFC_BASE + 0x210)




#define AP_CORE_CLK_GATE_ADDR            (AP_CRM_BASE+0xB0)
#define AP_PROBE_GATE_EN           			(1<<8)
#define AP_PMC_GTAE_EN           			(1<<3)
#define AP_PROBE_BYPASS_EN           			(1<<15)
#endif

/* copied from zx29_uart.h */ 
#define ZX29_UART0_VA	   						(ZX_UART0_BASE)
#define ZX29_UART1_VA	   						(ZX_UART1_BASE)

#define ZX29_UART_IBRD							0x24	/* Integer baud rate divisor register. */
#define ZX29_UART_FBRD							0x28	/* Fractional baud rate divisor register. */
#define ZX29_UART_LCRH							0x30	/* Line control register. */
#define ZX29_UART_CR							0x34	/* Control register. */
#define ZX29_UART_IFLS							0x38	/* Interrupt fifo level select. */
#define ZX29_UART_IMSC							0x40	/* Interrupt mask. */
#define ZX29_UART_ICR							0x4c	/* Interrupt clear register. */
#define ZX29_UART_DMACR							0x50	/* DMA control register. */

/*------ uart control reg -----*/
#define UART_CR_CTSEN							(1<<15)	/* CTS hardware flow control */
#define UART_CR_RTSEN							(1<<14)	/* RTS hardware flow control */
#define UART_CR_OUT2							(1<<13)	/* OUT2 */
#define UART_CR_OUT1							(1<<12)	/* OUT1 */
#define UART_CR_RTS								(1<<11)	/* RTS */
#define UART_CR_DTR								(1<<10)	/* DTR */
#define UART_CR_RXE								(1<<9)	/* receive enable */
#define UART_CR_TXE								(1<<8)	/* transmit enable */
#define UART_CR_LBE								(1<<7)	/* loopback enable */
#define UART_CR_SIRLP							(1<<2)	/* SIR low power mode */
#define UART_CR_SIREN							(1<<1)	/* SIR enable */
#define UART_CR_UARTEN							(1<<0)	/* UART enable */

struct zx_uart_context
{
	unsigned int	ibrd;		/*0x24	 Integer baud rate divisor register. */
	unsigned int	fbrd;		/*0x28	 Fractional baud rate divisor register. */
	unsigned int	lcrh;		/*0x30	 Line control register. */
	unsigned int	cr;			/*0x34	 Control register. */
	unsigned int	ifls;		/*0x38	 Interrupt fifo level select. */
	unsigned int	imsc;		/*0x40	 Interrupt mask. */	
	unsigned int	dmacr;		/*0x50	 DMA control register. */		
};

struct zx_timer_context
{
	unsigned int	cfg;		/*0x04	 config register. */
	unsigned int	load;		/*0x08	 load register. */
	unsigned int	start;		/*0x0C	 timer start register. */
	unsigned int	count;		/*0x18	 current counter register. */	
};

/* for device or sw to restore */
struct zx_suspend_context
{
	struct zx_uart_context  uart;
	struct zx_timer_context timer;
};

/*used as pm common interface*/
void pm_set_pcu(void);

extern void zx29_save_crm(u32 *pointer, u32 crm_base);
extern void zx29_restore_crm(u32 *pointer, u32 crm_base);

extern void pm_stop_tick(void);
extern u32 pm_read_tick(void);
extern void pm_restart_tick(u32 cycles);
extern void pm_start_tick(u64 us);	
extern s64 pm_get_remainder_time(void);
extern void setup_timer_wakeup(s64 us);
extern void zx29_set_wake_timer(unsigned long cycles);
extern void zx29_stop_wake_timer(void);
extern u64 read_persistent_us(void);
extern unsigned int pm_dma_used(void);

extern unsigned pm_get_wakeup_int_no(void);
extern char * pm_get_wakeup_int_name(void);
extern void pm_get_wake_cause(void);
extern unsigned int pm_get_wakesource(void);

extern void __iomem *debug_uart_base(void);
extern void debug_uart_suspend(void);
extern void debug_uart_resume(void);

extern void pm_timer_suspend(void); 
extern void pm_timer_resume(void);

extern void zx_pm_pre_suspend(void);
extern void zx_pm_post_suspend(void);

#define zx_set_pcu					pm_set_pcu
#define zx_clear_pcu				pm_clear_pcu 

#define save_crm					zx29_save_crm
#define restore_crm					zx29_restore_crm

#define zx_unmask_wakeup_interrupt()
#define zx_interrupt_mask_restore()

extern void pm_debug_mask_info_init(void);
extern unsigned int pm_get_mask_info(void);

void pm_init_acs(void);

#endif /*_ZX297520V2_PM_H*/
