/**
 * 
 * @file      amt_io.c
 * @brief     
 *            This file is part of FTM.
 *            AMTӦòں˲ͨģ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2018/03/08  1.0      liu.xin        Create file
 * 2019/02/02  1.1      jiang.fenglin  淶ԭ
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include "amt_io.h"
#include <linux/module.h>
#include <linux/cp_types.h>
#include <linux/soc/zte/rpm/rpmsg_sim.h>
#include "amt.h"


extern zx29_rpmsg_ser rpmsg_sim_zx29;
//extern BOOL zAmt_IsAmtMode(VOID);


static UINT32 AmtAgent_SendDataToAmtApp(UINT8 *buf, UINT32 buf_len)
{
    //panic("AmtAgent_SendDataToAmtApp");
    TransdataToAmtApp(9, buf, buf_len);
	return buf_len;
	/*
    if (TransdataToAmtApp(9, buf, buf_len) == 0)
    {
        return buf_len;
    }
	else
	{
    	return 0;
	}
	*/
}


static void AMTchannelOpen(unsigned int chid)
{
#ifdef USE_CPPS_KO
    cpps_callbacks.RegSendDataToAmtAppFunction(AmtAgent_SendDataToAmtApp);
#else
    RegSendDataToAmtAppFunction(AmtAgent_SendDataToAmtApp);
#endif
    return;
}
static void AMTchannelClose(unsigned int chid)
{

}

static void TransdataToAmtagent(unsigned int chid, const void *buffer, unsigned int length)
{
#ifdef USE_CPPS_KO
    cpps_callbacks.AmtAgent_ComposeAndProcess(buffer, length);
#else
    AmtAgent_ComposeAndProcess(buffer, length);
#endif
    return;
}

static int TransdataToAmtApp(unsigned int chid, const void *buffer, unsigned int length)
{
    //zx29_rpmsg_channel *rpmsg_channel = &rpmsg_sim_zx29.rpmsg_channel[chid-1];
    rpmsg_recv_notify(chid, buffer, length);
    return 0;
}


static int __init AMTchannelInit(void)
{
    registerOpsCallback(9, AMTchannelOpen, AMTchannelClose, TransdataToAmtagent);

	return 0;
}

static void __exit AMTchannelExit(void)
{

}

late_initcall(AMTchannelInit);
module_exit(AMTchannelExit);

MODULE_AUTHOR("ZTE");
MODULE_DESCRIPTION("ZTE Amt IO Module");
MODULE_LICENSE("GPL");


