/*
 * ZTE suspend power management driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by zxp
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/suspend.h>
#include <linux/math64.h>

#include <asm/system_misc.h>

#include "zx-pm.h"

/**************************************
 * SW code for suspend
 **************************************/

/*********************************************************************
 * FUNCTION DEFINATIONS
 ********************************************************************/
static int zx_suspend_ops_valid(suspend_state_t state)
{
    return state == PM_SUSPEND_MEM;
}

static int zx_suspend_ops_begin(suspend_state_t state)
{
    pm_ram_log("@@@@@@@@@@ Chip_pm_begin @@@@@@@@@@\n");


	disable_hlt();
    pm_set_wakeup_reason(WR_NONE);

    return 0;
}

static int zx_suspend_ops_prepare(void)
{
    pm_ram_log("@@@@@@@@@@ Chip_pm_prepare @@@@@@@@@@\n");

    return 0;
}

#define	AP_SLEEP_IN_TIMERS		IRAM_ADDR_FOR_WAKE_CNT
#define	AP_SLEEP_OUT_TIMERS		IRAM_ADDR_FOR_SLEEP_CNT

static int zx_suspend_ops_enter(suspend_state_t state)
{
    /* legacy log */
    pm_ram_log("@@@@@@@@@@ Chip_pm_enter @@@@@@@@@@\n");

	pm_write_reg(AP_SLEEP_IN_TIMERS, (unsigned int)read_persistent_us());

#ifdef CONFIG_ZX_PM_DEBUG
	pm_write_reg(AP_SUSPEND_STATUS_FLAG,0x1);
#endif
	/* deal soc/clk/powerdomain/pll out of A9 module
	 *ssuspend debug uartGPIO and other device out of A9 */
	zx_board_suspend();
	/*close clock&powerdomains that PCU does not controls */
	zx_dpm_suspend();

	/*mask all and backup, then unmask wakeup interrupts */
	zx_unmask_wakeup_interrupt();

	zx_pm_pre_suspend();
//	setup_timer_wakeup(__SLEEP_TIME_1s__*20);	//20s
//	setup_timer_wakeup(60);			//61us  each is 30.5us  used ot test abnormal exit from sleep

	if(pm_get_mask_info()&PM_SUSPEND_WFI)
		do_wfi();
	else
	{
		/*cpu enter lowpower mode */
#ifdef CONFIG_ZX_PM_DEBUG
	//	zx_enter_sleep(CPU_SLEEP_TYPE_IDLE_LP2);
		pm_write_reg(AP_SUSPEND_STATUS_FLAG,0x2);
#endif
		zx_enter_sleep(CPU_SLEEP_TYPE_LP1);	
	}
	
	/* get wakeup reason */
	//pm_wake_reason = pm_get_wakeup_reason();
	zx_pm_post_suspend();

#ifdef CONFIG_ZX_PM_DEBUG
	pm_write_reg(AP_SUSPEND_STATUS_FLAG,0x8);
#endif
	/* restore interrupt that masked */ 
	zx_interrupt_mask_restore();

	/*resume clock&powerdomains */
	zx_dpm_resume();
	/* resume debug uartGPIO and other device out of A9 */
	zx_board_resume();

	pm_write_reg(AP_SLEEP_OUT_TIMERS, (unsigned int)read_persistent_us());	
	pm_write_reg(AP_SLEEP_TIME_ADDR,(pm_read_reg(AP_SLEEP_OUT_TIMERS) - pm_read_reg(AP_SLEEP_IN_TIMERS)));

    return 0;
}

static void zx_suspend_ops_finish(void)
{
    pm_ram_log("@@@@@@@@@@ Chip_pm_finish @@@@@@@@@@\n");
}

static void zx_suspend_ops_end(void)
{
    pm_ram_log("@@@@@@@@@@ Chip_pm_end @@@@@@@@@@\n");

	enable_hlt();
}

static struct platform_suspend_ops zx_suspend_ops = {
    .valid      = zx_suspend_ops_valid,
    .begin      = zx_suspend_ops_begin,
    .prepare    = zx_suspend_ops_prepare,
    .enter      = zx_suspend_ops_enter,
    .finish     = zx_suspend_ops_finish,
    .end        = zx_suspend_ops_end,
};

void zx_suspend_init(void)
{
    pr_info("[SLP] Power/SPM_INIT \n");

 	suspend_set_ops(&zx_suspend_ops);

	pm_write_reg(AP_SLEEP_IN_TIMERS, 0);		
	pm_write_reg(AP_SLEEP_OUT_TIMERS, 0);		
}

