/*
 *  zx-pm.h - power management interface.
 *
 *  Written by zxp.
 *
 */

#ifndef _ZX_PM_H
#define _ZX_PM_H

#include <asm/io.h>
#include <asm/mach/map.h>

#include <linux/io.h>
#include <linux/irq.h>
#include <linux/cpuidle.h>

#include <mach/board.h>
#include <mach/iomap.h>
#include <mach/pcu.h>
#include <mach/gpio.h>

#if defined(CONFIG_ARCH_ZX297520V2)
#include "zx29-pm.h"
#elif defined(CONFIG_ARCH_ZX297510)
#include "zx297510-pm.h"
#elif defined(CONFIG_ARCH_ZX297520V3)
#include "zx29-pm.h"
#else
#error wrong architecture for the spm device
#endif
#include "zx-sleep.h"
#include "zx-pm-context.h"
#include "zx-pm-helpers.h"
#include "zx-cpuidle.h"
#include "zx-cpufreq.h"
//extern int request_ddr_freq(zx29_ddr_freq ddr_freq);

#ifdef CONFIG_ZX_PM_DEBUG

#define zte_pm_attr(_name) \
static struct kobj_attribute _name##_attr = 	\
{                           \
	.attr	= 				\
	{                       \
		.name = __stringify(_name),	\
		.mode = 0644,			\
	},					\
	.show	= _name##_show,			\
	.store	= _name##_store,		\
}

/* /sys/zte_pm */
extern struct kobject *pm_debug_kobj;
#endif
#if 1

#define pm_ram_log(fmt, args...)      	\
{	\
	pm_printk("[SLP] " fmt, ##args);	\
}
#else
#define pm_ram_log(fmt, args...)      	\
{	\
	printk(KERN_INFO "[SLP] " fmt, ##args);	\
	pm_printk("[SLP] " fmt, ##args);	\
}

#endif

/* Weak implementations for optional arch specific functions */
#ifdef CONFIG_SYSTEM_RECOVERY
#ifndef USE_CPPS_KO
void __weak psm_ModemDevSleep(void)
{
}
bool __weak psm_ModemSleepCheck(void)
{
	return 0;
}

u32 __weak  psm_ModemSleepTimeGet(void)
{
	return 0;
}

void __weak psm_TimeCompensate(u32 sleepTime)
{
}
void __weak psm_GetModemSleepFlagStatus(void)
{
}
#endif
#else
extern void psm_ModemDevSleep(void);
extern void psm_GetModemSleepFlagStatus(void);
extern bool psm_ModemSleepCheck(void);
extern unsigned int psm_ModemSleepTimeGet(void);
extern void psm_TimeCompensate(unsigned int);
#endif


#endif /*_ZX_PM_H*/
