/*
 * ZTE cpu sleep driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by zxp
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/suspend.h>
#include <linux/cpufreq.h>

#include <asm/suspend.h>

#include "zx-pm.h"

#ifdef CONFIG_HW_BREAKPOINT_MANAGE
#include <linux/hw_breakpoint_manage.h>
#endif 
/* used to return the value, if 0 represent sleeping process ok,
 * if 1 represent reset and restore back. 
 */
volatile int sleep_ret_flag[MAX_CPU_NUM] = {0};

static pm_wake_reason_t pm_wake_reason;

extern struct zx_pm_main_table zx_pm_main_table;

//extern int request_ddr_freq(zx29_ddr_freq ddr_freq);

/**
 * suspend platform device, for example: gpio, uart and so on.
 * 
 */
int zx_board_suspend(void)
{
	//gpio

//	debug_uart_suspend();

	
	return 0;
}

/**
 * resume debug uartGPIO and other device out of A9.
 * 
 */
int zx_board_resume(void)
{
	//gpio
//	debug_uart_resume();	

	//uart
	
	return 0;
}

/**
 * close clocks and power domains that PCU does not controls.
 * 
 */
int zx_dpm_suspend(void)
{
	
	return 0;
}

/**
 * resume debug uartGPIO and other device out of A9.
 * 
 */
int zx_dpm_resume(void)
{
	
	return 0;
}

/**
 * set cpu power state before do wfi.
 * 
 * cpu_context.power_state should filled in before call this function.
 */
static void set_power_state(void)
{
#ifdef CONFIG_ARCH_ZX297520V2
	set_status_a9_scu(zx_pm_main_table.cur_cpu, 
					  zx_pm_main_table.cpu_context[zx_pm_main_table.cur_cpu]->power_state,
					  zx_pm_main_table.scu_address);	
#else
#if 0
	set_status_a53_scu(zx_pm_main_table.cur_cpu, 
					  zx_pm_main_table.cpu_context[zx_pm_main_table.cur_cpu]->power_state,
				  zx_pm_main_table.scu_address);	
#endif	
#endif
}

#ifdef  CONFIG_ZX_PM_DEBUG_TIME
unsigned int suspend_start_time;
unsigned int suspend_enter_time;
unsigned int suspend_exit_time;
unsigned int suspend_finish_time;
unsigned int suspend_cur_time;
unsigned int suspend_save_start_time = 0;
unsigned int suspend_save_end_time = 0;
unsigned int suspend_restore_start_time = 0;
unsigned int suspend_restore_end_time = 0;
unsigned int suspendabort_restore_start_time = 0;
unsigned int suspendabort_restore_end_time = 0;
unsigned int suspendabort_cnt = 0;
unsigned int suspendsuscess_cnt = 0;
unsigned int zx_get_cur_time(void)
{
	return (unsigned int)read_persistent_us();
}
#endif
static void zx_sleep_before_wfi(void)
{
//	pm_switch_clk_to_26m();	
}

static void zx_sleep_after_wfi(void)
{
//	pm_switch_clk_from_26m();	
}


/**
 * when return pointor is stored,
 * cpu will poweroff now.
 */
static int zx_finish_suspend(unsigned long param)
{
	/* deal l1&l2 cache */
	#ifdef CONFIG_ARCH_ZX297520V2 /* 2975V2 A9*/
	disable_clean_inv_dcache_v7_l1();
	clean_disable_pl310(zx_pm_main_table.l2_address);
	#else/* 2975V5 A53/*
       /*disable&clean&inv interface*/
	disable_flush_dcache_L1_flush_cache_L2();
	#endif
	
#ifdef  CONFIG_ZX_PM_DEBUG_TIME
	pm_write_reg(SLEEP_TIME_ADDR, zx_get_cur_time());
#endif

	exit_coherency();

	set_power_state();

	zx_sleep_before_wfi();


#ifdef CONFIG_ZX_PM_DEBUG
	/**/
	pm_write_reg(AP_SUSPEND_STATUS_FLAG,0x5);
#endif
	
	zx_jump_addr(zx_pm_main_table.wakeup_vaddr+WAKEUP_CODE_LENGTH);

	zx_sleep_after_wfi();

	/* when the sleep is abnormal exit, can run here */
	return 1;
}

/**
 * when cpu sleep procedure is abort,
 * then return true.
 */
static inline bool is_cpu_sleep_abort(void)
{
    unsigned int cpu_id;
    struct zx_cpu_context *context;
	
    cpu_id 	= read_cpuid();
	context	= zx_pm_main_table.cpu_context[cpu_id];

	if (context->power_state != CPU_POWER_MODE_RUN)
		return true;

	return false;
}

/**
 * cpu sleep stage may be abort for some interrupt or event pending.
 * This function is used to deal this situation.
 * 
 * if state is CPU_POWER_MODE_RUN, indicated not back from restore,
 * so sleep stage is abort.
 */
static void cpu_check_sleep_abort(void)
{
    if (is_cpu_sleep_abort())
    {
		/*enable l1-cache, l2,
		  then code can run well */
#ifdef CONFIG_ARCH_ZX297520V2 /* 2975V2 A9*/
		set_enabled_pl310(true, zx_pm_main_table.l2_address);		  
#endif
    		enable_cache();
#ifdef  CONFIG_ZX_PM_DEBUG_TIME	
		suspendabort_cnt++;
	    suspendabort_restore_start_time = zx_get_cur_time();
#endif
		zx_pm_restore_abort_context();

#ifdef  CONFIG_ZX_PM_DEBUG_TIME
		suspendabort_restore_end_time = zx_get_cur_time();
#endif
		set_power_state();
		pm_set_wakeup_reason(WR_WAKE_SRC_ABNORMAL);
    }
	else
	{
	}
}


/**
 * cpu enter&resume interface code.
 * 
 * sleep_type -- CPU_SLEEP_TYPE_LP1/CPU_SLEEP_TYPE_IDLE_LP2
 */
u32 ap_susnpend_for_sleep_cnt  =0;
u32 ap_suspeend_for_poweroff_cnt =0;
#ifdef	CONFIG_PM_SLEEP
void zx_enter_sleep(cpu_sleep_type_t sleep_type)
{
#ifdef  CONFIG_ZX_PM_DEBUG_TIME
	pm_write_reg(SUSPEND_START_TIME_ADDR, zx_get_cur_time());
#endif

	zx_set_context_level(sleep_type);

	/* set&enable PCU for interrupt/clock/powerdomain/pll/iram */
	zx_set_pcu();

#ifdef CONFIG_ZX_PM_DEBUG
	pm_write_reg(AP_IDLE_SLEEP_STATUS_FLAG,0xff04);
#endif
	if(CPU_SLEEP_TYPE_LP3 == sleep_type)
	{
#ifdef CONFIG_ZX_PM_DEBUG
	  ap_susnpend_for_sleep_cnt++;
#endif
 		zx_wdt_handle_before_psm();
		do_wfi();

		zx_wdt_handle_after_psm();
		
#ifdef CONFIG_ZX_PM_DEBUG
	pm_write_reg(AP_IDLE_SLEEP_STATUS_FLAG,0xff05);
#endif

		pm_get_wake_cause();

#ifdef CONFIG_ZX_PM_DEBUG
	  pm_write_reg(AP_SUSPEND_FOR_SLEEP_CNT,ap_susnpend_for_sleep_cnt);
#endif
	}
	else
	{
/*=================================================================
 *=== the following code is for dormant or shutdown
 *=================================================================
 */
 		zx_wdt_handle_before_psm();
#ifdef CONFIG_HAVE_HW_BREAKPOINT
		hw_breakpoint_context_save();
#endif
		zx_pm_save_context();

#ifdef CONFIG_ZX_PM_DEBUG
		pm_write_reg(AP_IDLE_SLEEP_STATUS_FLAG,0xff05);
#endif
		if(!cpu_suspend(0, zx_finish_suspend))
		{
			zx_sleep_after_wfi();
			zx_pm_restore_context();
#ifdef CONFIG_ZX_PM_DEBUG
	   ap_suspeend_for_poweroff_cnt++;
	   pm_write_reg(AP_SUSPEND_FOR_POWEROFF_CNT,ap_suspeend_for_poweroff_cnt);
		   pm_write_reg(AP_IDLE_SLEEP_STATUS_FLAG,0xff06);
#endif
		}

		zx_wdt_handle_after_psm();
		
		/*exit from sleep*/
	    join_coherency();
		
	    cpu_check_sleep_abort();
/*=================================================================
 *=== ending with dormant or shutdown
 *=================================================================
 */

	/* get cause of exiting sleep */
	pm_get_wake_cause();
#ifdef CONFIG_HAVE_HW_BREAKPOINT
	hw_breakpoint_restore_context();
#endif //CONFIG_HAVE_HW_BREAKPOINT
	}
#ifdef CONFIG_ZX_PM_DEBUG
	pm_write_reg(AP_IDLE_SLEEP_STATUS_FLAG,0xff07);
#endif
	
	zx_clear_pcu();

#ifdef  CONFIG_ZX_PM_DEBUG_TIME
	suspend_finish_time = zx_get_cur_time();
	suspend_start_time =pm_read_reg(SUSPEND_START_TIME_ADDR);
//	pr_info("[SLP] suspend time: start:%d enter:%d total:%d\n",suspend_start_time, suspend_enter_time, suspend_start_time-suspend_enter_time);
//	pr_info("[SLP] suspend time: exit:%d finish:%d total:%d \n",suspend_exit_time, suspend_finish_time, suspend_exit_time-suspend_finish_time);	
	pm_ram_log("####suspend start = [%u],end = [%u],time=[%u]\n",suspend_start_time,suspend_finish_time,(suspend_finish_time-suspend_start_time));
	pm_ram_log("####sleep time = [%u],sucess_cn=[%u],sucess_abort=[%u]\n",(suspend_exit_time-suspend_enter_time),suspendsuscess_cnt,suspendabort_cnt);
    pm_ram_log("####save time = [%u],restore time = [%u]\n",(pm_read_reg(SUSPEND_SAVE_TIME_ADDR)),(pm_read_reg(SUSPEND_RESTORE_TIME_ADDR)));
#endif	


}
#else
void zx_enter_sleep(cpu_sleep_type_t sleep_type){}
#endif

/**
 * get wakeup reason .
 * 
 * 
 */
pm_wake_reason_t pm_get_wakeup_reason(void)
{
	return pm_wake_reason;
}

/**
 * set wakeup reason .
 * 
 * 
 */
void pm_set_wakeup_reason(pm_wake_reason_t reason)
{
	pm_wake_reason = reason;
}
