/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name: icp_rpmsg.c
 * File Mark:
 * Description:
 * Others:
 * Version:       V0.1
 * Author:        ShiDeYou
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 ******************************************************************************/

/*******************************************************************************
*                                  Include files                               *
*******************************************************************************/
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/spinlock.h>
#include <linux/mutex.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/kfifo.h>
#include <linux/err.h>
#include <linux/notifier.h>
#include <linux/semaphore.h>
#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
#include <linux/device.h>
#include <linux/soc/zte/rpm/rpmsg.h>
#include <linux/module.h>
#include <linux/string.h>
#include <asm/system.h>
#include <linux/reboot.h>
#include <linux/platform_device.h>

#include <linux/wakelock.h>
#include <mach/board.h>

//#define ZX29_ICP_TEST			1
#define	ICP_TEST_SELF_TXRX		//APԲ
#define	ICP_TEST_PS2AP		

#define	CIRCUL_BUFFER_USED		1
/*******************************************************************************
*                                    Macro                                     *
*******************************************************************************/
#define RPMSG_ALIGN 0x4
#if CIRCUL_BUFFER_USED
#else
#define RPMSG_ADDTIONAL_BYTES 0x4
#endif
#define RPMSG_SPACEEND 0x4445         /*ED*/
#define ALIGN_RPMSG(size,align) (((unsigned int)size + align - 1)&(~(align - 1)))
#define RPMSG_MSGHEAD_FLAG 0x5453          /*ST*/
/*******************************************************************************
*                           Global  Variable                                   *
*******************************************************************************/	
typedef struct _T_HalRpoc
{
	T_ZDrvRpMsg_ActorID actorID;
	volatile u64 chID;
}T_HalRpoc;
	
typedef struct _T_RpMsg_struct
{
	T_HalRpoc event;
	struct work_struct rpmsg_work;
}T_RpMsg_struct;

typedef struct _rpmsg_resource
{
	unsigned int *RpMsgRead_Exit;
	struct mutex *rpmsgread_mutex;
	struct mutex *rpmsgwrite_mutex;
	wait_queue_head_t *rpmsgwaitq;
	struct semaphore *RpmsgSema;
	T_ZDrvRpMsg_CallbackFunction *s_RpMsgCallbackList;
	unsigned int *sendPos;
}rpmsg_resource_struct;
	
struct workqueue_struct *rpmsg_workqueue[ACTOR_MAXID];
T_RpMsg_struct rpmsg_struct[ACTOR_MAXID];
struct mutex rpmsgch_mutex[ACTOR_MAXID];

/* some resource for rpmsg */
static unsigned int RpMsgRead_Exit_ps[CHANNEL_AP2PS_MAXID] = {0};
static unsigned int RpMsgRead_Exit_m0[CHANNEL_AP2M0_MAXID] = {0};
static struct mutex rpmsgread_mutex_ps[CHANNEL_AP2PS_MAXID];
static struct mutex rpmsgread_mutex_m0[CHANNEL_AP2M0_MAXID];
static struct mutex rpmsgwrite_mutex_ps[CHANNEL_AP2PS_MAXID];
static struct mutex rpmsgwrite_mutex_m0[CHANNEL_AP2M0_MAXID];
static wait_queue_head_t rpmsgwaitq_ps[CHANNEL_AP2PS_MAXID];
static wait_queue_head_t rpmsgwaitq_m0[CHANNEL_AP2M0_MAXID];
static struct semaphore RpmsgSema_ps[CHANNEL_AP2PS_MAXID];
static struct semaphore RpmsgSema_m0[CHANNEL_AP2M0_MAXID];
static T_ZDrvRpMsg_CallbackFunction s_RpMsgCallbackList_ps[CHANNEL_AP2PS_MAXID];
static T_ZDrvRpMsg_CallbackFunction s_RpMsgCallbackList_m0[CHANNEL_AP2M0_MAXID];
static unsigned int s_SendPos_ps[CHANNEL_AP2PS_MAXID];
static unsigned int s_SendPos_m0[CHANNEL_AP2M0_MAXID];
static DEFINE_SPINLOCK(rpmsg_lock);

static rpmsg_resource_struct rpmsg_resource[] =
{
	[0] = {
		.RpMsgRead_Exit 	= RpMsgRead_Exit_m0,
		.rpmsgread_mutex	= rpmsgread_mutex_m0,
		.rpmsgwrite_mutex	= rpmsgwrite_mutex_m0,
		.rpmsgwaitq			= rpmsgwaitq_m0,
		.RpmsgSema			= RpmsgSema_m0,
		.s_RpMsgCallbackList= s_RpMsgCallbackList_m0,
		.sendPos			= s_SendPos_m0, 
	},
	[1] = {
		.RpMsgRead_Exit 	= RpMsgRead_Exit_ps,
		.rpmsgread_mutex	= rpmsgread_mutex_ps,
		.rpmsgwrite_mutex	= rpmsgwrite_mutex_ps,
		.rpmsgwaitq			= rpmsgwaitq_ps,
		.RpmsgSema			= RpmsgSema_ps,
		.s_RpMsgCallbackList= s_RpMsgCallbackList_ps,
		.sendPos			= s_SendPos_ps, 
	},	
};

static T_HalRpMsg_ChRam	ps_channel_config[CHANNEL_AP2PS_MAXID] = 
{
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,CH_DDR,CH_DDR,	/* 0~~7 */
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,
	
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR,
	CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR, CH_DDR
};

static T_HalRpMsg_ChRam	m0_channel_config[CHANNEL_AP2M0_MAXID] = 
{
    CH_IRAM, CH_IRAM, CH_IRAM, CH_IRAM, CH_IRAM,
    CH_IRAM, CH_IRAM, CH_IRAM, CH_IRAM, CH_IRAM
};

static Icp_rpmsg_drv rpmsg_ps_info = {
	.name	= "icp_ps",	
	.Channel_config =
		{
			.ChConfig = ps_channel_config,
		},
};

static Icp_rpmsg_drv rpmsg_m0_info = {
	.name	= "icp_m0",
	.Channel_config =
		{
			.ChConfig = m0_channel_config,
		},
};

static Icp_rpmsg_drv *Icp_rpmsg_drvs[] = { &rpmsg_m0_info, &rpmsg_ps_info, NULL };
static const icp_operations *icp_ops;
	
static struct wake_lock icp_wake_lock;
extern void at_local_wakelock_timeout(long timeout);

/**************************************************************************************
 *                        macro
 **************************************************************************************/
#define	icp_rpmsg_get_buffer_type(actor_id, ch_id) \
	(Icp_rpmsg_drvs[actor_id]->Channel_config.ChConfig[ch_id])

#define	icp_rpmsg_get_channel_send(actor_id, ch_id) \
	(Icp_rpmsg_drvs[actor_id]->Channel_config.ChInfo_Send_Base + ch_id)

#define	icp_rpmsg_get_channel_recv(actor_id, ch_id) \
	(Icp_rpmsg_drvs[actor_id]->Channel_config.ChInfo_Recv_Base + ch_id)

#define	icp_rpmsg_get_max_channel(actor_id) \
	(Icp_rpmsg_drvs[actor_id]->channel_cnt)

wait_queue_head_t *icp_rpmsg_get_waitq(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	return &(rpmsg_resource[actorID].rpmsgwaitq[chID]);
}
/*******************************************************************************
* Function:    icp_rpmsg_get_sendbase_offset/icp_rpmsg_get_recvbase_offset 	
* Description: helper functions, for get offset of channel base address
* Parameters:
*   Input:
*        actor_id:
*        ch_id:
*   Output:
*        offset:    
* Others:
********************************************************************************/
unsigned int ddr_base_offset = 0;
static unsigned int iram_base_offset = (ZX_IRAM0_BASE-ZX29_IRAM0_PHYS);


static unsigned long icp_rpmsg_pa2va(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned long pa)
{
	if (icp_rpmsg_get_buffer_type(actorID, chID) == CH_IRAM)
		return (pa+iram_base_offset);
	else
#ifdef _USE_VEHICLE_DC
		return (pa + ddr_base_offset);
#else		
		return (pa-ZX_RPMSG_DDR_BASE+ddr_base_offset);
#endif
}

#if CIRCUL_BUFFER_USED	
/*******************************************************************************
* Function: icp_rpmsg_read
* Description: helper functions for copydata from msg_ram
* Parameters:
*   Input:
*         channel_info:channel used
*         __dest:
*         __src_base:the offset of src buffer, when used, should +recvPos
*         __n:  
*   Output:None
*
* Others:
********************************************************************************/
static void	icp_rpmsg_read(T_HalRpMsg_ChInfo *channel_info, 
							void *__dest, 
							__const void *__src_base, 
							size_t __n)
{
	u32 free_cnt = 0;

	free_cnt = channel_info->size - channel_info->RecvPos;

	/* |+++sp-----rp+++| */
	if(free_cnt >= __n)
	{
		memcpy(__dest, __src_base+channel_info->RecvPos, __n);
		channel_info->RecvPos += (__n+__n%2);

		if(channel_info->RecvPos == channel_info->size)
			channel_info->RecvPos = 0;	
	}
	else
	{
		memcpy(__dest, __src_base+channel_info->RecvPos, free_cnt);
		memcpy(__dest+free_cnt, __src_base, __n-free_cnt);
		
		channel_info->RecvPos = __n-free_cnt+__n%2;
	}
}

/*******************************************************************************
* Function: icp_rpmsg_adjust
* Description: helper functions for adjust buffer pointer after reading data
*              when there is n bytes in buffer, but user only read m bytes,
*              then the recvPos is not correct, so we move it to next buffer 
*              header   
* Parameters:
*   Input:
*         channel_info:channel used
*         __dest:
*         __src_base:the offset of src buffer, when used, should +recvPos
*         __n:  
*   Output:None
*
* Others:
********************************************************************************/
static void	icp_rpmsg_move_recv_pos(T_HalRpMsg_ChInfo *channel_info, 
									size_t __n)
{
	u32 free_cnt = 0;

	free_cnt = channel_info->size - channel_info->RecvPos;

	/* |+++sp-----rp+++| */
	if(free_cnt >= __n)
	{
		channel_info->RecvPos += (__n+__n%2);

		if(channel_info->RecvPos == channel_info->size)
			channel_info->RecvPos = 0;	
	}
	else
	{
		channel_info->RecvPos = __n-free_cnt+__n%2;
	}
}


/*******************************************************************************
* Function: icp_rpmsg_write
* Description: helper functions for copydata to msg_ram
* Parameters:
*   Input:
*         channel_info:channel used
*         __dest_base:the offset of dest buffer, when used, should +sendPos
*         __src:
*         __n:  
*   Output:None
*
* Others:
********************************************************************************/
static void	icp_rpmsg_write(T_HalRpMsg_ChInfo *channel_info, 
							void *__dest_base, 
							__const void *__src, 
							size_t __n,
							T_ZDrvRpMsg_ActorID actorID, 
							T_ZDrvRpMsg_ChID chID)
{
	u32 free_cnt = 0;

	free_cnt = channel_info->size - rpmsg_resource[actorID].sendPos[chID];//channel_info->SendPos;

	/* |---sp+++++rp---| */	
	/* |+++rp-----sp+++| */
	if(free_cnt >= __n)
	{
		memcpy(__dest_base+rpmsg_resource[actorID].sendPos[chID], __src, __n);
		rpmsg_resource[actorID].sendPos[chID] += (__n+__n%2);

		if(rpmsg_resource[actorID].sendPos[chID] == channel_info->size)
			rpmsg_resource[actorID].sendPos[chID] = 0;
	}
	else
	{
		memcpy(__dest_base+rpmsg_resource[actorID].sendPos[chID], __src, free_cnt);
		memcpy(__dest_base, __src+free_cnt, __n-free_cnt);			
		rpmsg_resource[actorID].sendPos[chID] = (__n-free_cnt+__n%2);
	}
}
#endif

/*******************************************************************************
* Function: halRpMsg_IsRecvChEmpty
* Description: This function is used for checking the channel used to receive message is empty or not;
* Parameters:
*   Input:
*        channel_send:channel message will be send to
*        channel_recv:channel message will be received from
*   Output:None
*
* Returns:
*        TRUE: the Recch is empty .
*        FALSE: the Recch is not empty .
*
* Others:
********************************************************************************/
//static 
bool halRpMsg_IsRecvChEmpty(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	unsigned int RecvBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_recv = icp_rpmsg_get_channel_recv(actorID, chID);
	
	if(!(channel_recv->flag & CHANNEL_FLAG)){
		return TRUE;
	}
	
//	RecvBase_remap = channel_recv->Base_Addr + icp_rpmsg_get_recvbase_offset(actorID, chID);
	RecvBase_remap = icp_rpmsg_pa2va(actorID, chID, channel_recv->Base_Addr);	
	
	if (channel_recv->SendPos == channel_recv->RecvPos){
		return TRUE;
	}
	else{
#if CIRCUL_BUFFER_USED
#else
		if (((T_HalRpMsg_RpMsg *)(channel_recv->RecvPos + RecvBase_remap))->MsgHeader.flag == RPMSG_SPACEEND){
			channel_recv->RecvPos = 0x0;/*\u017eĶ\u017e*/
		}
		if (channel_recv->SendPos == channel_recv->RecvPos){
			return TRUE;
		}
#endif		
		return FALSE;
	}
}

/*******************************************************************************
* Function: zDrvRpMsg_Read
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   DRV_ERROR
*
* Others:
********************************************************************************/
#ifdef CONFIG_ARCH_ZX297520V3_CAP
int zDrvRpMsg_Read(const T_ZDrvRpMsg_Msg *pMsg)
#else
int zDrvRpMsg_Read_Cap(const T_ZDrvRpMsg_Msg *pMsg)
#endif
{
	unsigned int RecvBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = NULL;
	T_HalRpMsg_ChInfo *channel_recv = NULL;
#if CIRCUL_BUFFER_USED			
	T_HalRpMsg_MsgHeader tmpMsgHeader;
#else
	unsigned int size=0;
	T_HalRpMsg_RpMsg *RpMsg = NULL;
#endif	
	unsigned int result_len = 0;

	if ((pMsg == NULL)|| (pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= icp_rpmsg_get_max_channel(pMsg->actorID))){
	    return RPMSG_INVALID_PARAMETER;
	}

	channel_send = icp_rpmsg_get_channel_send(pMsg->actorID, pMsg->chID);
	channel_recv = icp_rpmsg_get_channel_recv(pMsg->actorID, pMsg->chID);

	if (!(channel_send->flag & CHANNEL_FLAG)){
	    return RPMSG_CHANNEL_INEXISTANCE;
	}
	
	if ((pMsg->flag & RPMSG_READ_POLL) &&(halRpMsg_IsRecvChEmpty(pMsg->actorID, pMsg->chID) == TRUE)){
	    return RPMSG_NO_MSG;
	}
	
	rpmsg_resource[pMsg->actorID].RpMsgRead_Exit[pMsg->chID] = 0;

	mutex_lock(&(rpmsg_resource[pMsg->actorID].rpmsgread_mutex[pMsg->chID]));
	/*check the read buf is empty,if empty wait semaphore*/
	while (halRpMsg_IsRecvChEmpty(pMsg->actorID, pMsg->chID) == TRUE)/*ȷûźѻ*/
	{
		if(down_interruptible(&(rpmsg_resource[pMsg->actorID].RpmsgSema[pMsg->chID]))){
			mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgread_mutex[pMsg->chID]));
			return -ERESTARTSYS;
		}
		if(rpmsg_resource[pMsg->actorID].RpMsgRead_Exit[pMsg->chID] == 1){
			mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgread_mutex[pMsg->chID]));
			return 0;
		}
	}

//	RecvBase_remap = channel_recv->Base_Addr + icp_rpmsg_get_recvbase_offset(pMsg->actorID, pMsg->chID);
	RecvBase_remap = icp_rpmsg_pa2va(pMsg->actorID, pMsg->chID, channel_recv->Base_Addr);

#if CIRCUL_BUFFER_USED
	/* get msg header */
	icp_rpmsg_read(channel_recv, 
				   (unsigned char *)&tmpMsgHeader,
				   (unsigned char *)RecvBase_remap,
				   sizeof(T_HalRpMsg_MsgHeader));

	if (tmpMsgHeader.flag != RPMSG_MSGHEAD_FLAG){
		mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgread_mutex[pMsg->chID]));
		return RPMSG_CHANNEL_MSG_ERR;
	}

	result_len = min(pMsg->len, (unsigned int)(tmpMsgHeader.len));
	icp_rpmsg_read(channel_recv, 
				   (unsigned char *)pMsg->buf,
				   (unsigned char *)RecvBase_remap,
				   result_len);
	if((unsigned int)(tmpMsgHeader.len) > result_len)
		icp_rpmsg_move_recv_pos(channel_recv, (unsigned int)(tmpMsgHeader.len) - result_len - result_len%2);	
#else
	RpMsg = (T_HalRpMsg_RpMsg *)(channel_recv->RecvPos + RecvBase_remap);
	if (RpMsg->MsgHeader.flag != RPMSG_MSGHEAD_FLAG){
		mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgread_mutex[pMsg->chID]));
		return RPMSG_CHANNEL_MSG_ERR;
	}

	result_len = min(pMsg->len, (unsigned int)(RpMsg->MsgHeader.len));
	size = RpMsg->MsgHeader.len + sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size, RPMSG_ALIGN);
	memcpy((unsigned int *)pMsg->buf, &(RpMsg->data), result_len);
	channel_recv->RecvPos += size;
#endif	
	mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgread_mutex[pMsg->chID]));
	
	return result_len;
}
//EXPORT_SYMBOL(zDrvRpMsg_Read);

/*******************************************************************************
* Function: zDrvRpMsg_ReadLockIrq
* Description: This function is used for reading message and lock irq;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   DRV_ERROR
*
* Others:
********************************************************************************/
int zDrvRpMsg_ReadLockIrq(const T_ZDrvRpMsg_Msg *pMsg)
{
	unsigned int RecvBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = NULL;
	T_HalRpMsg_ChInfo *channel_recv = NULL;
#if CIRCUL_BUFFER_USED			
	T_HalRpMsg_MsgHeader tmpMsgHeader;
#else
	unsigned int size=0;
	T_HalRpMsg_RpMsg *RpMsg = NULL;
#endif	
	unsigned int result_len = 0;
	unsigned long flags;

	if ((pMsg == NULL) || !(pMsg->flag & RPMSG_READ_POLL) ||(pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= icp_rpmsg_get_max_channel(pMsg->actorID))){
	    return RPMSG_INVALID_PARAMETER;
	}

	channel_send = icp_rpmsg_get_channel_send(pMsg->actorID, pMsg->chID);
	channel_recv = icp_rpmsg_get_channel_recv(pMsg->actorID, pMsg->chID);

	if (!(channel_send->flag & CHANNEL_FLAG) || !(channel_recv->flag & CHANNEL_FLAG)){
	    return RPMSG_CHANNEL_INEXISTANCE;
	}
	
	local_irq_save(flags);
	/*check the read buf is empty,if empty wait semaphore*/
	if(halRpMsg_IsRecvChEmpty(pMsg->actorID, pMsg->chID) == TRUE){
		local_irq_restore(flags);
		return RPMSG_NO_MSG;
	}
	
//	RecvBase_remap = channel_recv->Base_Addr + icp_rpmsg_get_recvbase_offset(pMsg->actorID, pMsg->chID);;
	RecvBase_remap = icp_rpmsg_pa2va(pMsg->actorID, pMsg->chID, channel_recv->Base_Addr);

#if CIRCUL_BUFFER_USED
	/* get msg header */
	icp_rpmsg_read(channel_recv, 
				   (unsigned char *)&tmpMsgHeader,
				   (unsigned char *)RecvBase_remap,
				   sizeof(T_HalRpMsg_MsgHeader));

	if (tmpMsgHeader.flag != RPMSG_MSGHEAD_FLAG){
		local_irq_restore(flags);
		return RPMSG_CHANNEL_MSG_ERR;
	}

	result_len = min(pMsg->len, (unsigned int)(tmpMsgHeader.len));
	icp_rpmsg_read(channel_recv, 
				   (unsigned char *)pMsg->buf,
				   (unsigned char *)RecvBase_remap,
				   result_len);
	if((unsigned int)(tmpMsgHeader.len) > result_len)
		icp_rpmsg_move_recv_pos(channel_recv, (unsigned int)(tmpMsgHeader.len) - result_len - result_len%2);	
#else
	RpMsg = (T_HalRpMsg_RpMsg *)(channel_recv->RecvPos + RecvBase_remap);
	if (RpMsg->MsgHeader.flag != RPMSG_MSGHEAD_FLAG){
		local_irq_restore(flags);
		return RPMSG_CHANNEL_MSG_ERR;
	}

	result_len = min(pMsg->len, (unsigned int)(RpMsg->MsgHeader.len));
	size = RpMsg->MsgHeader.len + sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size, RPMSG_ALIGN);
	memcpy((unsigned int *)pMsg->buf, &(RpMsg->data), result_len);
	channel_recv->RecvPos += size;
#endif	
	local_irq_restore(flags);
	
	return result_len;
}
//EXPORT_SYMBOL(zDrvRpMsg_ReadLockIrq);

/*******************************************************************************
* Function: halRpMsg_IsChFreeSpace
* Description: This function is used for checking channel free buffer;
* Parameters:
*   Input:
*         channel_send:channel used for sending message
*         channel_recv:channel used for receiving message
*         size:size of message
*   Output:None
*
* Returns:
*        TRUE: the channel has free buffer .
*        FALSE: the channel no free buffer .
*
* Others:
********************************************************************************/
static bool halRpMsg_IsChFreeSpace(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID,  unsigned int size)
{
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_send(actorID, chID);

//	SendBase_remap = channel_send->Base_Addr + icp_rpmsg_get_sendbase_offset(actorID, chID);
	SendBase_remap = icp_rpmsg_pa2va(actorID, chID, channel_send->Base_Addr);		

	/* |---sp+++++rp---| */
	if (channel_send->SendPos < channel_send->RecvPos){
#if CIRCUL_BUFFER_USED
    	if ((channel_send->RecvPos - channel_send->SendPos) > size){
#else
    	if ((channel_send->RecvPos - channel_send->SendPos - RPMSG_ADDTIONAL_BYTES) >= size){
#endif				
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
	else{
#if CIRCUL_BUFFER_USED
		/* |+++rp-----sp+++| */
		if ((channel_send->size - channel_send->SendPos + channel_send->RecvPos ) > size){
#else		
		/* |---rp-----sp+++| */
		if ((channel_send->size - channel_send->SendPos - RPMSG_ADDTIONAL_BYTES) >= size){
			return TRUE;
		}
		/* |+++rp-----sp---| */
		else if ((size + RPMSG_ADDTIONAL_BYTES) <= channel_send->RecvPos){
			*(unsigned short *)(SendBase_remap + channel_send->SendPos) = RPMSG_SPACEEND;
			channel_send->EndAddr = channel_send->SendPos;
			channel_send->SendPos = 0x0;
#endif
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
}

/*******************************************************************************
* Function: zDrvRpMsg_Write
* Description: This function is used for writing message;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   DRV_ERROR
*
* Others:
********************************************************************************/
#ifdef CONFIG_ARCH_ZX297520V3_CAP
int zDrvRpMsg_Write(const T_ZDrvRpMsg_Msg *pMsg)
#else
int zDrvRpMsg_Write_Cap(const T_ZDrvRpMsg_Msg *pMsg)
#endif
{
	unsigned int size=0;
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = NULL;
#if CIRCUL_BUFFER_USED			
	T_HalRpMsg_MsgHeader tmpMsgHeader;
#else
	T_HalRpMsg_RpMsg *RpMsg = NULL;
#endif	

	if ((pMsg == NULL)||(pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= icp_rpmsg_get_max_channel(pMsg->actorID))){
		return RPMSG_INVALID_PARAMETER;
	}

	channel_send = icp_rpmsg_get_channel_send(pMsg->actorID, pMsg->chID);
	
	if (!(channel_send->flag & CHANNEL_FLAG)){
		return RPMSG_CHANNEL_INEXISTANCE;
	}
	size = pMsg->len+ sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	
//	SendBase_remap = channel_send->Base_Addr + icp_rpmsg_get_sendbase_offset(pMsg->actorID, pMsg->chID);
	SendBase_remap = icp_rpmsg_pa2va(pMsg->actorID, pMsg->chID, channel_send->Base_Addr);	

	mutex_lock(&(rpmsg_resource[pMsg->actorID].rpmsgwrite_mutex[pMsg->chID]));
	if (halRpMsg_IsChFreeSpace(pMsg->actorID, pMsg->chID, size) == TRUE){

#if CIRCUL_BUFFER_USED
		tmpMsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		tmpMsgHeader.len = (unsigned short)(pMsg->len);	

		rpmsg_resource[pMsg->actorID].sendPos[pMsg->chID] = channel_send->SendPos;

		icp_rpmsg_write(channel_send,
						(unsigned char *)SendBase_remap,
						(unsigned char *)&tmpMsgHeader, 
						sizeof(T_HalRpMsg_MsgHeader),
						pMsg->actorID,
						pMsg->chID);
	
		icp_rpmsg_write(channel_send,
						(unsigned char *)SendBase_remap, 
						pMsg->buf, 
						pMsg->len,
						pMsg->actorID,
						pMsg->chID);

		 dsb();
		 channel_send->SendPos = rpmsg_resource[pMsg->actorID].sendPos[pMsg->chID];
#else
		RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->SendPos + SendBase_remap);
		RpMsg->MsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		RpMsg->MsgHeader.len = (unsigned short)(pMsg->len);
		
		memcpy(&(RpMsg->data), pMsg->buf, pMsg->len);
		channel_send->SendPos += size;
#endif
	}
	else{
		mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgwrite_mutex[pMsg->chID]));
		return RPMSG_SPACE_NOT_ENOUGH;
	}
	if (icp_ops->Icp_GetIntState(pMsg->actorID,  pMsg->chID) == FALSE){
		if (pMsg->flag & RPMSG_WRITE_INT){
			icp_ops->Icp_SetInt(pMsg->actorID,  pMsg->chID);
		}
	}
	mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgwrite_mutex[pMsg->chID]));
	
	return (pMsg->len);
}

//EXPORT_SYMBOL(zDrvRpMsg_Write);

/*******************************************************************************
* Function: zDrvRpMsg_WriteIrqLock
* Description: This function is used for writing message;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   DRV_ERROR
*
* Others:
********************************************************************************/
#ifdef CONFIG_ARCH_ZX297520V3_CAP
int zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg)
#else
int zDrvRpMsg_WriteLockIrq_Cap(const T_ZDrvRpMsg_Msg *pMsg)
#endif
{
	unsigned int size=0;
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = NULL;
#if CIRCUL_BUFFER_USED			
	T_HalRpMsg_MsgHeader tmpMsgHeader;
#else
	T_HalRpMsg_RpMsg *RpMsg = NULL;
#endif	
	unsigned long flags;

	if ((pMsg == NULL)||(pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= icp_rpmsg_get_max_channel(pMsg->actorID))){
		return RPMSG_INVALID_PARAMETER;
	}

	channel_send = icp_rpmsg_get_channel_send(pMsg->actorID, pMsg->chID);
	
	if (!(channel_send->flag & CHANNEL_FLAG)){
		return RPMSG_CHANNEL_INEXISTANCE;
	}
	size = pMsg->len+ sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	
//	SendBase_remap = channel_send->Base_Addr + icp_rpmsg_get_sendbase_offset(pMsg->actorID, pMsg->chID);
	SendBase_remap = icp_rpmsg_pa2va(pMsg->actorID, pMsg->chID, channel_send->Base_Addr);	

	local_irq_save(flags);
	if (halRpMsg_IsChFreeSpace(pMsg->actorID, pMsg->chID, size) == TRUE){
#if CIRCUL_BUFFER_USED		
		tmpMsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		tmpMsgHeader.len = (unsigned short)(pMsg->len);	

		rpmsg_resource[pMsg->actorID].sendPos[pMsg->chID] = channel_send->SendPos;
		icp_rpmsg_write(channel_send,
						(unsigned char *)SendBase_remap,
						(unsigned char *)&tmpMsgHeader, 
						sizeof(T_HalRpMsg_MsgHeader),
						pMsg->actorID,
						pMsg->chID);
	
		icp_rpmsg_write(channel_send,
						(unsigned char *)SendBase_remap, 
						pMsg->buf, 
						pMsg->len,
						pMsg->actorID,
						pMsg->chID);
		dsb();
		channel_send->SendPos = rpmsg_resource[pMsg->actorID].sendPos[pMsg->chID];						
#else
		RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->SendPos + SendBase_remap);
		RpMsg->MsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		RpMsg->MsgHeader.len = (unsigned short)(pMsg->len);
		memcpy(&(RpMsg->data), pMsg->buf, pMsg->len);
		channel_send->SendPos += size;
#endif		

	}
	else{
		local_irq_restore(flags);
		return RPMSG_SPACE_NOT_ENOUGH;
	}
	if (icp_ops->Icp_GetIntState(pMsg->actorID,  pMsg->chID) == FALSE){
		if (pMsg->flag & RPMSG_WRITE_INT){
			icp_ops->Icp_SetInt(pMsg->actorID,  pMsg->chID);
		}
	}
	local_irq_restore(flags);
	
	return (pMsg->len);
}

//EXPORT_SYMBOL(zDrvRpMsg_WriteLockIrq);

/*******************************************************************************
* Function: zDrvRpMsg_CreateChannel
* Description: This function is used for creating channel to send message;
* Parameters:
*   Input:
*       actorID:remote cpu
*       chID: ID of channel
*       size: size of channel
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully .
*   DRV_ERROR: fail .
*
* Others:  
********************************************************************************/
#ifdef CONFIG_ARCH_ZX297520V3_CAP
int zDrvRpMsg_CreateChannel(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size)
#else
int zDrvRpMsg_CreateChannel_Cap(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size)
#endif
{	
	T_HalRpMsg_ChInfo *channel_send = NULL;

#ifndef CONFIG_ARCH_ZX297520V3_CAP
	if (actorID != CAP_ID)
		return RPMSG_INVALID_PARAMETER;
#endif

	if ((actorID>=ACTOR_MAXID) || (chID>=icp_rpmsg_get_max_channel(actorID))){
		return RPMSG_INVALID_PARAMETER;
	}

	channel_send = icp_rpmsg_get_channel_send(actorID, chID);

	if (channel_send->flag & CHANNEL_FLAG){
		return RPMSG_CHANNEL_ALREADY_EXIST;
	}

	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	mutex_lock(&rpmsgch_mutex[actorID]);
	if (icp_rpmsg_get_buffer_type(actorID, chID) == CH_IRAM)
	{
		if (size > Icp_rpmsg_drvs[actorID]->Channel_config.CurIramSpace_Size){
			mutex_unlock(&rpmsgch_mutex[actorID]);
			return RPMSG_SPACE_NOT_ENOUGH;
		}

		channel_send->Base_Addr =  Icp_rpmsg_drvs[actorID]->Channel_config.CurIramAddr;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurIramAddr += size;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurIramSpace_Size -=size;
	}
	else if (icp_rpmsg_get_buffer_type(actorID, chID) == CH_DDR)
	{
		if (size > Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrSpace_Size){
			mutex_unlock(&rpmsgch_mutex[actorID]);
			return RPMSG_SPACE_NOT_ENOUGH;
		}

		channel_send->Base_Addr =  Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrAddr;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrAddr += size;
		Icp_rpmsg_drvs[actorID]->Channel_config.CurDdrSpace_Size -=size;
	}
	else{
		mutex_unlock(&rpmsgch_mutex[actorID]);
		return RPMSG_INVALID_PARAMETER;
	}	
	
	mutex_unlock(&rpmsgch_mutex[actorID]);
	channel_send->size = size;

	init_waitqueue_head(&(rpmsg_resource[actorID].rpmsgwaitq[chID]));
	sema_init(&(rpmsg_resource[actorID].RpmsgSema[chID]), 0);	
	mutex_init(&(rpmsg_resource[actorID].rpmsgread_mutex[chID]));
	mutex_init(&(rpmsg_resource[actorID].rpmsgwrite_mutex[chID]));
 	channel_send->flag |= CHANNEL_FLAG;
	icp_ops->Icp_UnMask(actorID, chID);
 
	return RPMSG_SUCCESS;
	
}

//EXPORT_SYMBOL(zDrvRpMsg_CreateChannel);
/*******************************************************************************
* Function: zDrvRpMsg_GetDataSize
* Description: This function is used for dispatching icp interrupt of m0 and arm0 ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int zDrvRpMsg_RecvCh_GetDataSize(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	T_HalRpMsg_ChInfo *channel_recv = icp_rpmsg_get_channel_recv(actorID, chID);

	if(channel_recv->RecvPos <= channel_recv->SendPos){
		return (channel_recv->SendPos - channel_recv->RecvPos);
	}
	else{
#if CIRCUL_BUFFER_USED
		return (channel_recv->size - channel_recv->RecvPos + channel_recv->SendPos);
#else
		return (channel_recv->EndAddr - channel_recv->RecvPos + channel_recv->SendPos);
#endif
	}
}

//EXPORT_SYMBOL(zDrvRpMsg_RecvCh_GetDataSize);
/*******************************************************************************
* Function: RpMsg_Dispatch
* Description: This function is used for dispatching icp interrupt of m0 and arm0 ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
#if CIRCUL_BUFFER_USED
#define	RPMSG_BUFFER_LEN		512
static unsigned char rpmsg_cache_buffer[RPMSG_BUFFER_LEN];
#endif
#ifdef _USE_VEHICLE_DC
struct trace_rpmsg {
	T_HalRpMsg_ChInfo		channel_record;
	T_HalRpMsg_MsgHeader	msg_header;
	unsigned int 			remap;
	T_ZDrvRpMsg_ChID 		chID;
};
#define	TRACE_RPMSG_COUNT	1000
static struct trace_rpmsg trace_rpmsg_info[TRACE_RPMSG_COUNT+2];
volatile unsigned int 	 trace_rpmsg_index = 0;

#define	rpmsg_trace_index_inc()	\
do{ \
	trace_rpmsg_index++;\
	if(trace_rpmsg_index>=TRACE_RPMSG_COUNT)\
	   trace_rpmsg_index=0;\
}while(0)

static void dma_trace_record(T_ZDrvRpMsg_ChID chID, T_HalRpMsg_ChInfo *chan,
						T_HalRpMsg_MsgHeader *header, unsigned int remap)
{
	if (chan)
		trace_rpmsg_info[trace_rpmsg_index].channel_record = *chan;

	if (header)
		trace_rpmsg_info[trace_rpmsg_index].msg_header = *header;

	trace_rpmsg_info[trace_rpmsg_index].remap = remap;
	trace_rpmsg_info[trace_rpmsg_index].chID = chID;

	rpmsg_trace_index_inc();
}
#else
static void dma_trace_record(T_ZDrvRpMsg_ChID chID, T_HalRpMsg_ChInfo *chan, T_HalRpMsg_MsgHeader *header, unsigned int remap){}
#endif
int RpMsg_Dispatch(struct work_struct *work)
{
	unsigned int RecvBase_remap = 0;
	T_ZDrvRpMsg_CallbackFunction callback;
	T_RpMsg_struct *rpmsg_struct;
	T_ZDrvRpMsg_ActorID actorID;
	T_ZDrvRpMsg_ChID chID;
	volatile u64 *chIDs;
	u32 max_channel = 0;
	unsigned long flags;
	T_HalRpMsg_ChInfo *channel_recv = NULL;
#if CIRCUL_BUFFER_USED
	T_HalRpMsg_MsgHeader tmpMsgHeader;
#else
	unsigned int size=0;
	T_HalRpMsg_RpMsg *RpMsg = NULL;
	void *buf = NULL;
	unsigned short len = 0;	
#endif		

	rpmsg_struct = container_of(work, T_RpMsg_struct, rpmsg_work);
	actorID = rpmsg_struct->event.actorID;
	chIDs = &(rpmsg_struct->event.chID);

	max_channel = icp_rpmsg_get_max_channel(actorID);

	for(chID = 0; (chID < max_channel)&&(*chIDs != (u64)0); chID++ )
	{
		if (*chIDs&((u64)0x1<<chID))
		{
			raw_spin_lock_irqsave(&rpmsg_lock, flags);
			*chIDs &= ~((u64)0x1<<chID);
			raw_spin_unlock_irqrestore(&rpmsg_lock, flags);
			
			channel_recv = icp_rpmsg_get_channel_recv(actorID, chID);
			
			if (!(channel_recv->flag & CHANNEL_FLAG))
			{
		//      return RPMSG_CHANNEL_INEXISTANCE;
				printk("RpMsg_Dispatch: RPMSG_CHANNEL_INEXISTANCE actorID = %d chID = %d\n", actorID, chID);
				continue;
			}

			/* actorchIDs_RpMsgCallbackListȡص\u017e */
			callback = rpmsg_resource[actorID].s_RpMsgCallbackList[chID];
			if (callback == NULL){
		//		return RPMSG_ERROR;
				printk("RpMsg_Dispatch: callback = NULL actorID = %d chID = %d\n", actorID, chID);
				continue;
			}	

		//	RecvBase_remap = channel_recv->Base_Addr + icp_rpmsg_get_recvbase_offset(actorID, chID);
			RecvBase_remap = icp_rpmsg_pa2va(actorID, chID, channel_recv->Base_Addr);
			
			while( halRpMsg_IsRecvChEmpty(actorID, chID) != TRUE)
			{
#if CIRCUL_BUFFER_USED
				/* get msg header */
				icp_rpmsg_read(channel_recv, 
							   (unsigned char *)&tmpMsgHeader,
							   (unsigned char *)RecvBase_remap,
							   sizeof(T_HalRpMsg_MsgHeader));

				dma_trace_record(chID, channel_recv, &tmpMsgHeader, RecvBase_remap);

				if (tmpMsgHeader.flag != RPMSG_MSGHEAD_FLAG) {
		//			return RPMSG_CHANNEL_MSG_ERR;
					BUG();
				}

				if(RPMSG_BUFFER_LEN < tmpMsgHeader.len)
					BUG();
				
				icp_rpmsg_read(channel_recv, 
							   rpmsg_cache_buffer,
							   (unsigned char *)RecvBase_remap,
							   tmpMsgHeader.len);

				dma_trace_record(chID, channel_recv, &tmpMsgHeader, RecvBase_remap);

				(*callback)(rpmsg_cache_buffer, tmpMsgHeader.len);
#else	
				RpMsg = (T_HalRpMsg_RpMsg *)(channel_recv->RecvPos + RecvBase_remap);
				if (RpMsg->MsgHeader.flag != RPMSG_MSGHEAD_FLAG){
					return RPMSG_CHANNEL_MSG_ERR;
				}
				len = RpMsg->MsgHeader.len;
				size = ALIGN_RPMSG(len, RPMSG_ALIGN) + sizeof(T_HalRpMsg_MsgHeader);
				buf = &(RpMsg->data);


				/* pMsgΪûص\u017d\u0160\u017d?*/
				(*callback)(buf, len);
				channel_recv->RecvPos += size;
#endif	
		    }
		}
	}
	return RPMSG_SUCCESS;
}

/*******************************************************************************
* Function: zDrvIcp_interrupt
* Description: This function is used for dispatching icp interrupt of m0 and arm0 ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
extern void zx_wdt_icp_wake(void);
static irqreturn_t icp_rpmsg_interrupt(int intline, void *p)
{
	unsigned int i;
	Icp_rpmsg_drv *Icp_rpmsg_driver= p;
	T_HalIcp_Dword chIDs;
	unsigned long flags;
	
	chIDs = icp_ops->Icp_GetInt(Icp_rpmsg_driver->actorID);

	for(i=0; i<icp_rpmsg_get_max_channel(Icp_rpmsg_driver->actorID); i++)
    {
    	#ifdef CONFIG_ARCH_ZX297520V3_CAP
        	if((M0_ID==Icp_rpmsg_driver->actorID) &&( channel_2== i) ) //from m0 wdt
				zx_wdt_icp_wake();
		#endif		
		if((((i<32)&&((chIDs.low_word>>i) & 0x1))||((i>=32)&&((chIDs.high_word>>(i-32)) & 0x1))) && \
			((Icp_rpmsg_drvs[Icp_rpmsg_driver->actorID]->Channel_config.ChInfo_Recv_Base + i)->flag & CHANNEL_FLAG) && \
			((Icp_rpmsg_drvs[Icp_rpmsg_driver->actorID]->Channel_config.ChInfo_Send_Base + i)->flag & CHANNEL_FLAG))
		{
			if(rpmsg_resource[Icp_rpmsg_driver->actorID].s_RpMsgCallbackList[i] != NULL)
			{
				raw_spin_lock_irqsave(&rpmsg_lock, flags);
				rpmsg_struct[Icp_rpmsg_driver->actorID].event.actorID = Icp_rpmsg_driver->actorID;
				rpmsg_struct[Icp_rpmsg_driver->actorID].event.chID |= (u64)0x1<<i;
				raw_spin_unlock_irqrestore(&rpmsg_lock, flags);
				queue_work(rpmsg_workqueue[Icp_rpmsg_driver->actorID], &(rpmsg_struct[Icp_rpmsg_driver->actorID].rpmsg_work));
			}
			else
			{
				//if (RpmsgChnStatus[rpmsg_drve->actorID][i])
				up(&(rpmsg_resource[Icp_rpmsg_driver->actorID].RpmsgSema[i]));
			}
			icp_ops->Icp_ClearInt(Icp_rpmsg_driver->actorID, i);
			wake_up(&(rpmsg_resource[Icp_rpmsg_driver->actorID].rpmsgwaitq[i]));

#ifdef CONFIG_ZX_SUSPEND_OPTIMIZE
			/* at channel */
			if(i == channel_9)
				at_local_wakelock_timeout(msecs_to_jiffies(1*1000));
#endif			
      	  }
   	 } 

#ifdef CONFIG_ZX_SUSPEND_OPTIMIZE
	wake_lock_timeout(&icp_wake_lock, msecs_to_jiffies(1*1000)); 
#else
	wake_lock_timeout(&icp_wake_lock, msecs_to_jiffies(1*1000)); 
#endif
	
	return IRQ_HANDLED;	
}
/*******************************************************************************
* Function: HalRpMsg_SenInt
* Description: This function is used for generating icp interrupt to inform remote cpu;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns:None
*
*
* Others:
********************************************************************************/
int zDrvIcp_SetInt(T_ZDrvRpMsg_ActorID actorID, unsigned int chID)
{
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_send(actorID, chID);

	if (!(channel_send->flag & CHANNEL_FLAG))
		return RPMSG_CHANNEL_INEXISTANCE;
		
	if(actorID >= ACTOR_MAXID ||chID >= icp_rpmsg_get_max_channel(actorID)){
		return RPMSG_INVALID_PARAMETER;
	}
	icp_ops->Icp_SetInt(actorID, chID);
	
   	return 0;
}

/*******************************************************************************
* Function: zDrvRpMsg_RegCallBack
* Description: This function is used for register callback fuction of icp interrupt;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns:None
*
*
* Others:
********************************************************************************/
#ifdef CONFIG_ARCH_ZX297520V3_CAP
int zDrvRpMsg_RegCallBack(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback)
#else
int zDrvRpMsg_RegCallBack_Cap(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback)
#endif
{
	unsigned long flags;
	
	if(actorID >= ACTOR_MAXID ||chID >= icp_rpmsg_get_max_channel(actorID))
		return RPMSG_INVALID_PARAMETER;

	rpmsg_resource[actorID].s_RpMsgCallbackList[chID] = callback;
	if(callback!=NULL)
	{
		printk("rpmsg: actorID = %d chID = %d register callback success!\n", actorID, chID);
		
		raw_spin_lock_irqsave(&rpmsg_lock, flags);
		rpmsg_struct[actorID].event.actorID = actorID;
		rpmsg_struct[actorID].event.chID |= (u64)0x1<<chID;
		raw_spin_unlock_irqrestore(&rpmsg_lock, flags);
		
		queue_work(rpmsg_workqueue[actorID], &(rpmsg_struct[actorID].rpmsg_work));		
	}
	return 0;
}

//EXPORT_SYMBOL(zDrvRpMsg_RegCallBack);

#ifdef CONFIG_ARCH_ZX297520V3_CAP
void zDrvRpMsg_ReadExit(T_ZDrvRpMsg_ActorID actor, T_ZDrvRpMsg_ChID chID)
#else
void zDrvRpMsg_ReadExit_Cap(T_ZDrvRpMsg_ActorID actor, T_ZDrvRpMsg_ChID chID)
#endif
{
	rpmsg_resource[actor].RpMsgRead_Exit[chID] = 1;

	if(rpmsg_resource[actor].RpmsgSema[chID].count)
	{
		up(&(rpmsg_resource[actor].RpmsgSema[chID]));
	}
}
//EXPORT_SYMBOL(zDrvRpMsg_ReadExit);

/**********************************************************************************
*                           used by devices
**********************************************************************************/
void rpmsg_set_ops(const icp_operations *ops)
{
	icp_ops = ops;
}

static int icp_rpmsg_init_resource(struct platform_device *pdev, Icp_rpmsg_drv *icp_rpmsg_drv)
{
	struct zx29_rpmsg_platform_data *pdata = pdev->dev.platform_data;

  	if (!pdata) {
  		dev_err(&pdev->dev, "[RPMSG]no platform data\n");
  		return -EINVAL;
  	    }

	icp_rpmsg_drv->actorID 	   = pdev->id;
	icp_rpmsg_drv->channel_cnt = pdata->max_channel_cnt;	

#ifdef _USE_VEHICLE_DC
	if(icp_rpmsg_drv->actorID == CAP_ID) {
		ddr_base_offset = ZX_DDR_CAPBUF_BASE - ZX29_DDR_CAPBUF_PHYS;

		icp_rpmsg_drv->Channel_config.ChInfo_Send_Base	= (T_HalRpMsg_ChInfo *)(pdata->ddr_send_base + ddr_base_offset);
		icp_rpmsg_drv->Channel_config.ChInfo_Recv_Base	= (T_HalRpMsg_ChInfo *)(pdata->ddr_recv_base + ddr_base_offset);
		icp_rpmsg_drv->Channel_config.CurDdrAddr		= (unsigned int)(pdata->ddr_send_base + icp_rpmsg_drv->channel_cnt * sizeof(T_HalRpMsg_ChInfo));
		icp_rpmsg_drv->Channel_config.CurDdrSpace_Size	= pdata->ddr_send_size - icp_rpmsg_drv->channel_cnt * sizeof(T_HalRpMsg_ChInfo);
	} else {		
#endif
	icp_rpmsg_drv->Channel_config.ChInfo_Send_Base	= (T_HalRpMsg_ChInfo *)(pdata->iram_send_base);
	icp_rpmsg_drv->Channel_config.ChInfo_Recv_Base	= (T_HalRpMsg_ChInfo *)(pdata->iram_recv_base);
	icp_rpmsg_drv->Channel_config.CurIramAddr 		= (unsigned int)(pdata->iram_send_base + icp_rpmsg_drv->channel_cnt * sizeof(T_HalRpMsg_ChInfo) - iram_base_offset);
	icp_rpmsg_drv->Channel_config.CurIramSpace_Size = pdata->iram_send_size - icp_rpmsg_drv->channel_cnt * sizeof(T_HalRpMsg_ChInfo);
	icp_rpmsg_drv->Channel_config.CurDdrAddr 		= (unsigned int)(pdata->ddr_send_base);
	icp_rpmsg_drv->Channel_config.CurDdrSpace_Size 	= pdata->ddr_send_size;
#ifdef _USE_VEHICLE_DC
	}
#endif

	memset((u8 *)icp_rpmsg_drv->Channel_config.ChInfo_Send_Base, 
			0, 
			icp_rpmsg_drv->channel_cnt*sizeof(T_HalRpMsg_ChInfo));
	
	return 0;
}

int icp_rpmsg_register(struct platform_device *pdev, void *hw_data)
{
	int ret;
	char s[30];
	Icp_rpmsg_drv *list;
	struct zx29_icp_hwdata *icp_hwdata = (struct zx29_icp_hwdata *)hw_data;	

	list = Icp_rpmsg_drvs[pdev->id];
	icp_rpmsg_init_resource(pdev, list);
		
	sprintf(s, "rpmsg_work%d", (unsigned int)(list->actorID));
	rpmsg_workqueue[list->actorID] = create_workqueue(s);
	INIT_WORK(&(rpmsg_struct[list->actorID].rpmsg_work), (void *)RpMsg_Dispatch);/*process regcallback function*/
	mutex_init(&rpmsgch_mutex[list->actorID]);

	ret = request_irq(icp_hwdata->int_line, icp_rpmsg_interrupt, 0, list->name, list);
	if (ret)
	{
		printk("rpmsg_zx29 request_irq failed! ret = %d \n",ret);
		return ret;	
	}

#ifdef CONFIG_ARCH_ZX297520V3_CAP
	if(list->actorID == AP_ID)
#else
	if(list->actorID == CAP_ID)
#endif
	{
		list->dev.id = list->actorID;
		ret = icp_rpmsg_device_register(list);
		if(ret < 0)
			printk("rpmsg_zx29 register failed! \n");

#ifndef _USE_VEHICLE_DC
		ddr_base_offset =  (unsigned int)ioremap(ZX_RPMSG_DDR_BASE, ICP_DDR_APPS_SIZE+ICP_DDR_PSAP_SIZE);
#endif

		wake_lock_init(&icp_wake_lock, WAKE_LOCK_SUSPEND, "icp_msg");
		printk("[zxp] icp_wake_lock inited! \n");		
	}
	
	return 0;
		
}

unsigned int icp_rpmsg_getchflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID)
{
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_send(actorID, chID);
	
	return channel_send->flag;
}

int icp_rpmsg_setchIntflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag)
{
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_send(actorID, chID);

	if(flag == 1)
		channel_send->flag |= CHANNEL_INT_FLAG;
	else if(flag == 0)
		channel_send->flag &= ~CHANNEL_INT_FLAG;
	else
		return RPMSG_ERROR;
	
	return RPMSG_SUCCESS;
}

int icp_rpmsg_setchpollflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag)
{
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_send(actorID, chID);

	if(flag == 1)
		channel_send->flag |= CHANENL_POLL_FLAG;
	else if(flag == 0)
		channel_send->flag &= ~CHANENL_POLL_FLAG;
	else
		return RPMSG_ERROR;
	
	return RPMSG_SUCCESS;
}

int icp_rpmsg_unregister(struct platform_device *pdev)
{
	return 0;
}

#if 0
/**********************************************************************************
*                           ps can reset machine
**********************************************************************************/
static void modem_reset(void *buf, unsigned int len)
{
	/*zx297510_restart(NULL, "mmi_key reboot");*/
	//zx297520v2_restart(NULL, NULL);
	kernel_restart(NULL);	
}

static int __init modem_reset_init(void)
{
	zDrvRpMsg_CreateChannel(PS_ID, ICP_CHANNEL_DRIVER, 0x20);
	zDrvRpMsg_RegCallBack(PS_ID, ICP_CHANNEL_DRIVER, modem_reset);

    pr_info("[ICP] modem_reset_init END \n");

    return 0;
}

//device_initcall(modem_reset_init);
#endif
/**********************************************************************************
*                           test icp function
**********************************************************************************/
#if ZX29_ICP_TEST  
#ifndef ICP_TEST_SELF_TXRX
const unsigned char test_ps_data[29]={1,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
unsigned char test_rcv_buf[50] = {0};
unsigned int  test_rcv_cnt = 0;
unsigned int  test_send_cnt = 0;
const unsigned char test_ap_data[38]={1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19};
#endif

#ifdef ICP_TEST_PS2AP
#ifdef _USE_VEHICLE_DC
static T_ZDrvRpMsg_ActorID test_actorID = CAP_ID;		/* test ps-->ap*/
#else
static T_ZDrvRpMsg_ActorID test_actorID = PS_ID;		/* test ps-->ap*/
#endif
static T_ZDrvRpMsg_ChID test_chID = ICP_CHANNEL_PSM;
#else
static T_ZDrvRpMsg_ActorID test_actorID = M0_ID;		/* test M0-->ap*/
static T_ZDrvRpMsg_ChID test_chID = ICP_CHANNEL_PSM;
#endif
#ifdef _USE_VEHICLE_DC
#define ZX297520V2_ICP_PSAP_REG 			(ZX_ICP_BASE + 0xf8)	/* ap-->ps */
#else
#define ZX297520V2_ICP_PSAP_REG 			(ZX_ICP_BASE + 0xc8)
#endif
static unsigned int icp_test_cnt = 0;

static unsigned long rand = 0x97537636;

static inline unsigned char random(void)
{
	/* See "Numerical Recipes in C", second edition, p. 284 */
	rand = rand * 1664525L + 1013904223L;
	return (unsigned char) (rand >> 24)&0xff;
}


static void icp_test_cb(void *buf, unsigned int len)
{
	u8 *tmp_buf = buf;
	
#ifdef ICP_TEST_SELF_TXRX
	icp_test_cnt ++;

	{
	    T_ZDrvRpMsg_Msg Icp_Msg;
		int				ret;	

	    Icp_Msg.actorID = test_actorID;
	    Icp_Msg.chID 	= test_chID;
	    Icp_Msg.flag 	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
	    Icp_Msg.buf 	= tmp_buf;
	    Icp_Msg.len 	= len;	
#ifdef _USE_VEHICLE_DC
		ret = zDrvRpMsg_Write_Cap(&Icp_Msg);
#else
		ret = zDrvRpMsg_Write(&Icp_Msg);
#endif
		if(Icp_Msg.len != ret)
			pr_info("[ICP_TEST] msg send error:(%d)", ret);
	}
	
	pr_info("[ICP_TEST] recv buffer[%d] is:%x %x %x %x \n", len, *tmp_buf, *(tmp_buf+1), *(tmp_buf+2), *(tmp_buf+3));
#else

#ifdef ICP_TEST_PS2AP

	memset(test_rcv_buf, '\0', 50);
	memcpy(test_rcv_buf, tmp_buf, len);
	pr_info("[ICP_TEST] recv buffer[%d] is:%x %x %x %x \n", len, *tmp_buf, *(tmp_buf+1), *(tmp_buf+2), *(tmp_buf+3));


/*	if(memcmp(test_ps_data, tmp_buf, len))
	{
		pr_info("[ICP_TEST] msg cmp error len:[%d]\n", len);
		BUG();
	}
	else
	{
		test_rcv_cnt ++;
		pr_info("[ICP_TEST] recv buffer[%d] is:%x %x %x %x \n", len, *tmp_buf, *(tmp_buf+1), *(tmp_buf+2), *(tmp_buf+3));
	}*/

{
	T_ZDrvRpMsg_Msg Icp_Msg;
	int 			ret;	

	Icp_Msg.actorID = test_actorID;
	Icp_Msg.chID	= test_chID;
	Icp_Msg.flag	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
	Icp_Msg.buf 	= test_rcv_buf;
	Icp_Msg.len 	= len;	

#ifdef _USE_VEHICLE_DC
		ret = zDrvRpMsg_Write_Cap(&Icp_Msg);
#else
		ret = zDrvRpMsg_Write(&Icp_Msg);
#endif
	if(Icp_Msg.len != ret)
	{
		pr_info("[ICP_TEST] msg send error:(%d)", ret);
		BUG();
	}

	test_send_cnt ++;
	pr_info("[ICP_TEST] msg send ok count:[%d]\n", test_send_cnt);
}
#else

	memset(test_rcv_buf, '\0', 50);
	memcpy(test_rcv_buf, tmp_buf, len);
	pr_info("[ICP_TEST] recv buffer[%d] is:%x \n", len, *tmp_buf);

	{
		T_ZDrvRpMsg_Msg Icp_Msg;
		int 			ret;	

		Icp_Msg.actorID = test_actorID;
		Icp_Msg.chID	= test_chID;
		Icp_Msg.flag	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
		Icp_Msg.buf 	= test_rcv_buf;
		Icp_Msg.len 	= len;	

#ifdef _USE_VEHICLE_DC
		ret = zDrvRpMsg_Write_Cap(&Icp_Msg);
#else
		ret = zDrvRpMsg_Write(&Icp_Msg);
#endif
		if(Icp_Msg.len != ret)
		{
			pr_info("[ICP_TEST] msg send error:(%d)", ret);
			BUG();
		}

		test_send_cnt ++;
		pr_info("[ICP_TEST] msg send ok count:[%d]\n", test_send_cnt);
	}



#endif
#endif
}

static void ps_create_channel(void)
{
#ifdef ICP_TEST_SELF_TXRX
	T_HalRpMsg_ChInfo *channel = icp_rpmsg_get_channel_recv(test_actorID, test_chID);

#ifdef _USE_VEHICLE_DC
	channel->Base_Addr =  Icp_rpmsg_drvs[test_actorID]->Channel_config.CurDdrAddr - ICP_DDR_APPS_SIZE;//(u32)(Icp_rpmsg_drvs[test_actorID]->Channel_config.ChInfo_Recv_Base) + Icp_rpmsg_drvs[test_actorID]->channel_cnt*sizeof(T_HalRpMsg_ChInfo);
#else
	channel->Base_Addr =  Icp_rpmsg_drvs[test_actorID]->Channel_config.CurDdrAddr + ICP_DDR_APPS_SIZE;//(u32)(Icp_rpmsg_drvs[test_actorID]->Channel_config.ChInfo_Recv_Base) + Icp_rpmsg_drvs[test_actorID]->channel_cnt*sizeof(T_HalRpMsg_ChInfo);
#endif
	channel->size = 0x20;
 	channel->flag |= CHANNEL_FLAG;

	channel->SendPos = 0;
	channel->RecvPos = 0;
	channel->EndAddr = 0;
#endif	
}

static bool halRpMsg_IsPsChFreeSpace(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID,  unsigned int size)
{
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_recv(actorID, chID);

//	SendBase_remap = channel_send->Base_Addr + icp_rpmsg_get_sendbase_offset(actorID, chID);
	SendBase_remap = icp_rpmsg_pa2va(actorID, chID, channel_send->Base_Addr);	

	/* |---sp+++++rp---| */
	if (channel_send->SendPos < channel_send->RecvPos){
#if CIRCUL_BUFFER_USED
    	if ((channel_send->RecvPos - channel_send->SendPos) > size){
#else
    	if ((channel_send->RecvPos - channel_send->SendPos - RPMSG_ADDTIONAL_BYTES) >= size){
#endif				
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
	else{
#if CIRCUL_BUFFER_USED
		/* |+++rp-----sp+++| */
		if ((channel_send->size - channel_send->SendPos + channel_send->RecvPos ) > size){
#else		
		/* |---rp-----sp+++| */
		if ((channel_send->size - channel_send->SendPos - RPMSG_ADDTIONAL_BYTES) >= size){
			return TRUE;
		}
		/* |+++rp-----sp---| */
		else if ((size + RPMSG_ADDTIONAL_BYTES) <= channel_send->RecvPos){
			*(unsigned short *)(SendBase_remap + channel_send->SendPos) = RPMSG_SPACEEND;
			channel_send->EndAddr = channel_send->SendPos;
			channel_send->SendPos = 0x0;
#endif
			return TRUE;
		}
		else{
			return FALSE;
		}
	}
}

static int zDrvRpMsg_PsWrite(const T_ZDrvRpMsg_Msg *pMsg)
{
	unsigned int size=0;
	unsigned int SendBase_remap = 0;
	T_HalRpMsg_ChInfo *channel_send = icp_rpmsg_get_channel_recv(pMsg->actorID, pMsg->chID);
#if CIRCUL_BUFFER_USED			
	T_HalRpMsg_MsgHeader tmpMsgHeader;
#else
	T_HalRpMsg_RpMsg *RpMsg = NULL;
#endif	

	if ((pMsg == NULL)||(pMsg->actorID >= ACTOR_MAXID) || (pMsg->chID >= icp_rpmsg_get_max_channel(pMsg->actorID))){
		return RPMSG_INVALID_PARAMETER;
	}
	if (!(channel_send->flag & CHANNEL_FLAG)){
		return RPMSG_CHANNEL_INEXISTANCE;
	}
	size = pMsg->len+ sizeof(T_HalRpMsg_MsgHeader);
	size = ALIGN_RPMSG(size,RPMSG_ALIGN);
	
//	SendBase_remap = channel_send->Base_Addr + icp_rpmsg_get_sendbase_offset(pMsg->actorID, pMsg->chID);
	SendBase_remap = icp_rpmsg_pa2va(pMsg->actorID, pMsg->chID, channel_send->Base_Addr);	

//	mutex_lock(&(rpmsg_resource[pMsg->actorID].rpmsgwrite_mutex[pMsg->chID]));
	if (halRpMsg_IsPsChFreeSpace(pMsg->actorID, pMsg->chID, size) == TRUE){

#if CIRCUL_BUFFER_USED
		rpmsg_resource[pMsg->actorID].sendPos[pMsg->chID] = channel_send->SendPos;
		tmpMsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		tmpMsgHeader.len = (unsigned short)(pMsg->len);	

		icp_rpmsg_write(channel_send,
						(unsigned char *)SendBase_remap,
						(unsigned char *)&tmpMsgHeader, 
						sizeof(T_HalRpMsg_MsgHeader),
						pMsg->actorID,
						pMsg->chID);
	
		icp_rpmsg_write(channel_send,
						(unsigned char *)SendBase_remap, 
						pMsg->buf, 
						pMsg->len,
						pMsg->actorID,
						pMsg->chID);
		dsb();
		channel_send->SendPos = rpmsg_resource[pMsg->actorID].sendPos[pMsg->chID];						
#else
		RpMsg = (T_HalRpMsg_RpMsg *)(channel_send->SendPos + SendBase_remap);
		RpMsg->MsgHeader.flag = (unsigned short)RPMSG_MSGHEAD_FLAG;
		RpMsg->MsgHeader.len = (unsigned short)(pMsg->len);
		
		memcpy(&(RpMsg->data), pMsg->buf, pMsg->len);
		channel_send->SendPos += size;
#endif
	}
	else{
//		mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgwrite_mutex[pMsg->chID]));
		return RPMSG_SPACE_NOT_ENOUGH;
	}
/*	
	if (icp_ops->Icp_GetIntState(pMsg->actorID,  pMsg->chID) == FALSE){
		if (pMsg->flag & RPMSG_WRITE_INT){
			icp_ops->Icp_SetInt(pMsg->actorID,  pMsg->chID);
		}
	}
*/			
//	mutex_unlock(&(rpmsg_resource[pMsg->actorID].rpmsgwrite_mutex[pMsg->chID]));
	
	return (pMsg->len);
}


static void ps_send_msg(void)
{
#ifdef ICP_TEST_SELF_TXRX
	char ps_buf[5] = {'t','e','s','t','x'};
    T_ZDrvRpMsg_Msg Icp_Msg;

	ps_buf[4]		= '0' + icp_test_cnt;

    Icp_Msg.actorID = test_actorID;
    Icp_Msg.chID 	= test_chID;
    Icp_Msg.flag 	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
    Icp_Msg.buf 	= ps_buf;
    Icp_Msg.len 	= 0x5;	

	zDrvRpMsg_PsWrite(&Icp_Msg);
	
	/* trigger icp */
	iowrite32(2, (void __iomem *)ZX297520V2_ICP_PSAP_REG+0);	//channel_2
#endif	
}

#ifdef ICP_TEST_PS2AP   
static void icp_test(void)		/* test ps-->ap*/
{
	if(icp_test_cnt == 0)
	{
		/* create channel */
#ifdef _USE_VEHICLE_DC
		if(zDrvRpMsg_CreateChannel_Cap(test_actorID, test_chID, 0x30))
#else
		if(zDrvRpMsg_CreateChannel(test_actorID, test_chID, 0x30))
#endif
		{
			pr_info("[ICP_TEST] Failed create psm icp channel ! \n");
			BUG();
		}
		pr_info("[ICP_TEST] Success create psm icp channel!!! \n");	

#ifdef _USE_VEHICLE_DC
		zDrvRpMsg_RegCallBack_Cap(test_actorID, test_chID, icp_test_cb);
#else
		zDrvRpMsg_RegCallBack(test_actorID, test_chID, icp_test_cb);
#endif

		/* create ps channel*/
		ps_create_channel();
	}
	/* ps_send_msg */
	ps_send_msg();
}
#else
static void icp_test(void)		/* test M0-->ap*/
{
	if(icp_test_cnt == 0)
	{
		/* create channel */
		if(zDrvRpMsg_CreateChannel(test_actorID, test_chID, 0x20))
		{
			pr_info("[ICP_TEST] Failed create psm icp channel ! \n");
			BUG();
		}
		pr_info("[ICP_TEST] Success create psm icp channel!!! \n");	

		zDrvRpMsg_RegCallBack(test_actorID, test_chID, icp_test_cb);
	}

}
#endif

static ssize_t icp_test_show(struct device *dev,
		struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "[ICP_TEST]icp_test_cnt:%d\n", icp_test_cnt);
}

static ssize_t icp_test_store(struct device *dev, struct device_attribute *attr, 
		const char *buf, size_t count)
{
	icp_test();
	
	return (count);
}

static DEVICE_ATTR(icp_test,0600,icp_test_show,icp_test_store);
static struct attribute *zx29_icp_attributes[] = {
	&dev_attr_icp_test.attr,
	NULL,
};

static const struct attribute_group zx29_icp_attribute_group = {
	.attrs = (struct attribute **) zx29_icp_attributes,
};
#endif

/**
 *  "/sys/zte/test/icp_test" 
 */
int __init zx_icp_test_init(void)
{
	int ret;

#if ZX29_ICP_TEST 
    ret = sysfs_create_group(zx_test_kobj, &zx29_icp_attribute_group);

    pr_info("[DEBUG] create test icp sysfs interface OK.\n");
#endif

	return 0;
}

#if 0
#ifdef CONFIG_ARCH_ZX297520V3_CAP
static T_ZDrvRpMsg_ActorID test_actorID = AP_ID;
#else
static T_ZDrvRpMsg_ActorID test_actorID = CAP_ID;
#endif

//const 
unsigned char test_ps_data[29]={0};//{1,2,3,4,5,6,7,8,9,10,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
unsigned char test_rcv_buf[50] = {0};
unsigned int  test_rcv_cnt = 0;
unsigned int  test_send_cnt = 0;

static unsigned long rand = 0x97537636;

static inline unsigned char random(void)
{
	/* See "Numerical Recipes in C", second edition, p. 284 */
	rand = rand * 1664525L + 1013904223L;
	return (unsigned char) (rand >> 24)&0xff;
}

static void icp_test_cb(void *buf, unsigned int len)
{
	u8 *tmp_buf = buf;
	int ret = 0;

	memset(test_rcv_buf, '\0', 50);
	memcpy(test_rcv_buf, tmp_buf, len);

#ifndef CONFIG_ARCH_ZX297520V3_CAP	
	ret = strncmp(test_rcv_buf,test_ps_data,len);
	if (ret)
	{
		pr_info("[ICP_TEST] msg recevice error:(%d)", ret);
		BUG();
	}
	
	int i;
	for (i = 0; i < len; i++)
		test_ps_data[i] = random();
#endif

	pr_info("[ICP_TEST] recv buffer[%d] is:%x %x %x %x \n", len, *tmp_buf, *(tmp_buf+1), *(tmp_buf+2), *(tmp_buf+3));

	T_ZDrvRpMsg_Msg Icp_Msg = {0};
	Icp_Msg.actorID = test_actorID;
	Icp_Msg.chID	= channel_60;
	Icp_Msg.flag	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
#ifndef CONFIG_ARCH_ZX297520V3_CAP	
	Icp_Msg.buf 	= test_ps_data;
#else
	Icp_Msg.buf 	= test_rcv_buf;
#endif
	Icp_Msg.len 	= len;	
	
#ifdef CONFIG_ARCH_ZX297520V3_CAP
	ret = zDrvRpMsg_Write(&Icp_Msg);
#else
	msleep(1000);
	ret = zDrvRpMsg_Write_Cap(&Icp_Msg);
#endif
	if(Icp_Msg.len != ret)
	{
		pr_info("[ICP_TEST] msg send error:(%d)", ret);
		BUG();
	}

	test_send_cnt ++;
	pr_info("[ICP_TEST] msg send ok count:[%d]\n", test_send_cnt);
}

static int __init zx_rpmsg_init(void)
{
	int ret = 0;

#ifndef CONFIG_ARCH_ZX297520V3_CAP
	zDrvRpMsg_CreateChannel_Cap(CAP_ID, channel_60, 0x20);
	zDrvRpMsg_RegCallBack_Cap(CAP_ID, channel_60, icp_test_cb);
#else
	zDrvRpMsg_CreateChannel(AP_ID, channel_60, 0x20);
	zDrvRpMsg_RegCallBack(AP_ID, channel_60, icp_test_cb);
#endif

#ifndef CONFIG_ARCH_ZX297520V3_CAP
	T_ZDrvRpMsg_Msg Icp_Msg = {0};
	Icp_Msg.actorID = test_actorID;
	Icp_Msg.chID	= channel_60;
	Icp_Msg.flag	= RPMSG_WRITE_INT;		/* 1- means send an icp interrupt> */
	Icp_Msg.buf 	= test_ps_data;
	Icp_Msg.len 	= 21;	

	ret = zDrvRpMsg_Write_Cap(&Icp_Msg);
	if(Icp_Msg.len != ret)
	{
		pr_info("[ICP_TEST] msg send error:(%d)", ret);
		BUG();
	}
#endif	
    return 0;
}

late_initcall(zx_rpmsg_init);
#endif

