/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name: icp.c
 * File Mark:
 * Description:
 * Others:
 * Version:       V0.1
 * Author:        ShiDeYou
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 ******************************************************************************/
#include <linux/init.h>
#include <linux/module.h>
#include <crypto/internal/skcipher.h>
#include <linux/cpumask.h>
#include <linux/err.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
	 
	 
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/io.h>
#include <asm/system.h>
	 
#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
	 
//#include "rpmsg.h"
#include <linux/soc/zte/rpm/rpmsg_sim.h>

#include <linux/sched.h>
#include <linux/poll.h>	 
 //unsigned int channel_size[2][2] = {{0x100,0x100},{0x100,0x100}}; 
unsigned int debug_print_flag = 0;
module_param(debug_print_flag, uint, 0644);
#define debug_print(fmt, args...) \
	do \
	{ \
		if (debug_print_flag) \
		{ \
			printk(fmt,## args); \
		} \
	}while(0);
		
static int zx29_rpmsg_open(struct inode *inode, struct file *filp)
{
	dev_t device = inode->i_rdev;
	T_ZDrvRpMsg_ChID chID;
	zx29_rpmsg_ser *rpmsg_drv;
	if(filp->private_data)
		return -1;
	rpmsg_drv = container_of (inode->i_cdev, zx29_rpmsg_ser, cdev);
	rpmsg_drv->count++;
	chID = (T_ZDrvRpMsg_ChID)(MINOR(device) - rpmsg_drv->minor_start);
	if(chID>=CHANNEL_NUM)
		return -1;
	if(rpmsg_drv->rpmsg_channel[chID].initflag != 1)
		return -1;
	filp->private_data = &(rpmsg_drv->rpmsg_channel[chID]);
	rpmsg_drv->rpmsg_channel[chID].channelOpen(chID);
	rpmsg_drv->rpmsg_channel[chID].initflag = 2;
	
	debug_print("zx29_rpmsg_open channel :%d \n",chID);
	return 0;
}	
#if 0
static long zx29_rpmsg_ioctl(struct file *filp, unsigned int cmd, unsigned long arg)
{
	int ret;
	T_ZDrvRpMsg_Msg rpmsg;

	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;
	rpmsg.actorID = rpmsg_channel->actorID;
	rpmsg.chID = rpmsg_channel->chID;
 
	switch(cmd)
	{
		case RPMSG_CREATE_CHANNEL:
			ret = zDrvRpMsg_CreateChannel (rpmsg.actorID, rpmsg.chID, arg);
			if(ret != RPMSG_SUCCESS)
			{
	 			rpmsg_log("CreateChannel(actID=%d)(chId=%d) failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, ret);			
				return -ENXIO;
			}
			break;  
		case RPMSG_GET_DATASIZE:
			ret = zDrvRpMsg_RecvCh_GetDataSize(rpmsg.actorID, rpmsg.chID);
			*(unsigned int *)arg = ret;
			break;
		case RPMSG_SET_INT:
			zDrvIcp_SetInt(rpmsg.actorID, rpmsg.chID);
			break;
		case RPMSG_SET_INT_FLAG:
			icp_rpmsg_setchIntflag(rpmsg.actorID, rpmsg.chID, 1);
			break;
		case RPMSG_CLEAR_INT_FLAG:
			icp_rpmsg_setchIntflag(rpmsg.actorID, rpmsg.chID, 0);
			break;
		case RPMSG_SET_POLL_FLAG:
			icp_rpmsg_setchpollflag(rpmsg.actorID, rpmsg.chID, 1);
			break;
		case RPMSG_CLEAR_POLL_FLAG:
			icp_rpmsg_setchpollflag(rpmsg.actorID, rpmsg.chID, 0);
			break;
			 
		default:
			return -EPERM;
		}
	
	return 0;
}
#endif
static ssize_t zx29_rpmsg_write(struct file *filp, const char __user *ubuf,
						   size_t len, loff_t *ppos) 
{
	int ret;
	unsigned int flag;
	//T_ZDrvRpMsg_Msg rpmsg;
	struct RpMsg_packet packet;// = kmalloc(sizeof(struct RpMsg_packet), GFP_KERNEL);
	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;  
	if(rpmsg_channel->initflag != 2)
		return -1;
	packet.chID = rpmsg_channel->chID;
	packet.len = len;	 
	packet.buf = kmalloc(len, GFP_KERNEL);
	if(packet.buf == NULL)
	{
		rpmsg_log("zx29_rpmsg_write1 kmalloc failed\n");
		return 0;
	}
	
	ret = copy_from_user(packet.buf, ubuf, len);
 
	if (ret<0)
	{
	 	//rpmsg_log("zx29_rpmsg_write1(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);
		kfree(packet.buf);
		return -EFAULT;
	}
	#if 0
	flag = icp_rpmsg_getchflag(rpmsg.actorID, rpmsg.chID);
	if(flag&CHANNEL_INT_FLAG)
		rpmsg.flag |= RPMSG_WRITE_INT;
	 
	ret = zDrvRpMsg_Write(&rpmsg);  
	#endif 
	//ret = writeATdatatoPS();//TODO
	//TransdataToPS(rpmsg_channel->chID, packet.buf, packet.len);
	debug_print("zx29_rpmsg_write channel :%d \n",rpmsg_channel->chID);
	rpmsg_channel->transdataOut(rpmsg_channel->chID, packet.buf, packet.len);
	kfree(packet.buf);
	#if 0	  
	if(ret<0)
	{
//	 	rpmsg_log("zx29_rpmsg_write2(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);	
		return 0;
	}
	#endif 
	return len;	 
}

static ssize_t zx29_rpmsg_read(struct file *filp, char __user *ubuf,
						 size_t len, loff_t *offp)
{
	unsigned int size = 0;
	int ret = 0;
	unsigned int flag;
	//T_ZDrvRpMsg_Msg rpmsg;
	struct RpMsg_packet* packet = NULL;
	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;
	if(rpmsg_channel->initflag != 2)
		return -1;
	//	rpmsg.actorID = rpmsg_channel->actorID;
	//rpmsg.chID = rpmsg_channel->chID;
	//rpmsg.len = len;
	//rpmsg.flag = 0;

	//rpmsg.buf = kmalloc(len, GFP_KERNEL);
#if 0	  	
	flag = icp_rpmsg_getchflag(rpmsg.actorID, rpmsg.chID);
	if(flag&CHANENL_POLL_FLAG)
		rpmsg.flag |= RPMSG_READ_POLL;
	 
	ret = zDrvRpMsg_Read(&rpmsg);
#endif 
	//down_interruptible(&rpmsg_channel->channelSema);
	ret = wait_event_interruptible(rpmsg_channel->channelwaitq, !isRecvChannelEmpty(rpmsg_channel->chID));
	if(ret < 0)
	{
		debug_print("zx29_rpmsg_read wait_event_interruptible:%d \n",ret);
		return ret;
	}
	debug_print("zx29_rpmsg_read :%d \n",rpmsg_channel->chID);
	if(!isRecvChannelEmpty(rpmsg_channel->chID)) 
	{
		packet = rpmsg_dequeue(&rpmsg_channel->RpMsg_packet_queue);
		
		//if(packet && packet->msg)			
		//{
		//	size = len?(len<packet->msg->len):(packet->msg->len);
		//	ret = copy_to_user(ubuf, packet->msg->buf, size);
		//}		
		if(packet)	
		{
			size = (len < packet->len)?len:(packet->len);
			ret = copy_to_user(ubuf, packet->buf, size);
			kfree(packet->buf);
			kfree(packet);
		}
	}
	else
	{
		return 0;
	}
	
	if (ret<0) 
	{
//		rpmsg_log("zx29_rpmsg_read2(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);	 
		return -EFAULT;
	}

	return size;
}
static unsigned int zx29_rpmsg_poll(struct file *file,
				    struct poll_table_struct *wait)
{
	
	zx29_rpmsg_channel *rpmsg_channel = file->private_data;
	if( !isRecvChannelEmpty(rpmsg_channel->chID))
		return POLLIN | POLLRDNORM;
	else 
		poll_wait(file, &rpmsg_channel->channelwaitq, wait);
	debug_print("zx29_rpmsg_poll done :%d \n",rpmsg_channel->chID);
	if( !isRecvChannelEmpty(rpmsg_channel->chID))
		return POLLIN | POLLRDNORM;

	return 0;
}
 
static int zx29_rpmsg_release(struct inode *inode, struct file *filp)
{	 
	zx29_rpmsg_ser *rpmsg_drv;
	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;
	rpmsg_drv = container_of (inode->i_cdev, zx29_rpmsg_ser, cdev);	
	if(rpmsg_channel->initflag != 2)
		return -1;
	filp->private_data = NULL;
	rpmsg_drv->count--;
	rpmsg_channel->initflag = 1;
	rpmsg_channel->channelClose(rpmsg_channel->chID);
	debug_print("zx29_rpmsg_release channel :%d \n",rpmsg_channel->chID);
	return 0;
}
 
static const struct file_operations	rpmsg_zx29_ops = {
	.owner 		= THIS_MODULE,
	.open 		= zx29_rpmsg_open,
	.release 	= zx29_rpmsg_release,
	.write 		= zx29_rpmsg_write,
	.read 		= zx29_rpmsg_read,
	//.unlocked_ioctl = zx29_rpmsg_ioctl,
	.poll=zx29_rpmsg_poll,
};
   
struct class *rpmsg_sim_classes;

zx29_rpmsg_ser rpmsg_sim_zx29 = {
	.owner   		= THIS_MODULE,
	.driver_name 	= "armps_rpmsg",
	.name	   		= "rpm",	//ps_rpmsgch
	.major   		= 0,
	.minor_start 	= 30,
	.num 			= CHANNEL_NUM,
};
void rpmsg_enqueue(struct RpMsg_queue *packetqueue, struct list_head* plist)
{
	u32 spin_flag = 0;
	spin_lock_irqsave(&packetqueue->lock, spin_flag);
    list_add_tail(plist, &packetqueue->queue);
    packetqueue->qlen++;
    spin_unlock_irqrestore(&packetqueue->lock, spin_flag);   
}
struct RpMsg_packet* rpmsg_dequeue(struct RpMsg_queue *packetqueue)
{
	u32 spin_flag = 0;
	struct list_head* curr;
	struct RpMsg_packet* packet;
	spin_lock_irqsave(&packetqueue->lock, spin_flag);
	if(packetqueue->qlen <= 0)
	{
	
    	spin_unlock_irqrestore(&packetqueue->lock, spin_flag);   
		return NULL;
	}
	curr = packetqueue->queue.next;
    //packet = list_first_entry(curr, struct RpMsg_packet, list);
    list_del(curr);
    packetqueue->qlen--;
    spin_unlock_irqrestore(&packetqueue->lock, spin_flag);   
	return curr;
}
int isRecvChannelEmpty(T_ZDrvRpMsg_ChID chID)
{
	zx29_rpmsg_channel *rpmsg_channel = &rpmsg_sim_zx29.rpmsg_channel[chID];
	return rpmsg_channel->RpMsg_packet_queue.qlen?0:1;
}
void rpmsg_recv_notify(unsigned int chID, const void *buffer, unsigned int length)//(T_ZDrvRpMsg_Msg rpmsg)
{
	//u32 spin_flag = 0;
	//T_ZDrvRpMsg_Msg* rpmsg;
	 
	zx29_rpmsg_channel *rpmsg_channel = NULL;
	if(chID >= CHANNEL_NUM)
		return;
	rpmsg_channel = &rpmsg_sim_zx29.rpmsg_channel[chID];
	struct RpMsg_packet* packet = kmalloc(sizeof(struct RpMsg_packet), GFP_KERNEL);
	if(NULL == packet){
		debug_print("rpmsg_recv_notify kmalloc failed!\n");
		return;
	}
	memset(packet, 0x00, sizeof(struct RpMsg_packet));
	char * data = kmalloc(length+1, GFP_KERNEL);
	if(NULL == data){
		kfree(packet);
		debug_print("rpmsg_recv_notify kmalloc failed!!\n");
		return;
	}	
	memset(data, 0x00, length+1);
	memcpy(data, buffer, length);
	//rpmsg = kmalloc(sizeof(T_ZDrvRpMsg_Msg), GFP_KERNEL);
	//rpmsg->buf = buffer;
	//rpmsg->len = length;
	//up(&rpmsg_channel->channelSema);
	debug_print("rpmsg_recv_notify :%d \n",rpmsg_channel->chID);
	packet->chID = chID;
	packet->buf = data;
	packet->len = length;
	rpmsg_enqueue(&rpmsg_channel->RpMsg_packet_queue, &packet->list);  

	wake_up_interruptible(&rpmsg_channel->channelwaitq);

}
EXPORT_SYMBOL(rpmsg_recv_notify);
//int registerOpsCallback(unsigned int chID, functpye1* funcOpen, functpye1* funcClose, /*functpye2* funcIn,*/ functpye2* funcOut)
int registerOpsCallback(unsigned int chID, functpye1* funcOpen, functpye1* funcClose, functpye2* funcOut)
{
	int nRet = -1;
	zx29_rpmsg_channel *rpmsg_channel = &rpmsg_sim_zx29.rpmsg_channel[chID];
	if(funcOpen && funcClose && funcOut)
	{
		rpmsg_channel->channelOpen = funcOpen;
		rpmsg_channel->channelClose = funcClose;
		//rpmsg_channel->transdatatoRpmsg = funcIn;
		rpmsg_channel->transdataOut = funcOut;
		rpmsg_channel->initflag = 1;
		nRet = 0;
	}
	debug_print("registerOpsCallback :%d \n",rpmsg_channel->chID);
	return nRet;
}
EXPORT_SYMBOL(registerOpsCallback);

static struct device_attribute rpmsg_zx29_dev_attrs[] = {
	__ATTR_NULL,
};

struct bus_type icp_rpmsg_sim_bus = {
	.name = "rpmsg_zx29",
	.dev_attrs	= rpmsg_zx29_dev_attrs,
};

struct device *zx29_rpmsg_sim_register_device(struct class *rpmsg_class, zx29_rpmsg_ser *driver, unsigned index,
				struct device *device)
{
	char name[64];
	dev_t dev = MKDEV(driver->major, driver->minor_start) + index;

	if (index >= driver->num) {
		return ERR_PTR(-EINVAL);
	}
 
	sprintf(name, "%s%d", driver->name, index);
	return device_create(rpmsg_class, device, dev, NULL, name);
}
void zx29_rpmsg_sim_unregister_device(struct class *rpmsg_class, zx29_rpmsg_ser *driver, unsigned index)
{
	dev_t dev = MKDEV(driver->major, driver->minor_start) + index;

	device_destroy(rpmsg_class, dev);
}

static int zx29_rpmsg_sim_init(void)
{
	int error;
	int i;
	dev_t dev;
	zx29_rpmsg_ser *rpmsg_ser ;
	
	rpmsg_ser = &rpmsg_sim_zx29;
	rpmsg_ser->num =CHANNEL_NUM;
	rpmsg_ser->ops = &rpmsg_zx29_ops;
	rpmsg_ser->count = 0;
//	rpmsg_ser->rpmsg_channel.actorID = rpdev->id;
	error = alloc_chrdev_region(&dev, rpmsg_ser->minor_start,
					rpmsg_ser->num, rpmsg_ser->name);
	if (!error) {
		rpmsg_ser->major = MAJOR(dev);
		rpmsg_ser->minor_start = MINOR(dev);
	}

	cdev_init(&rpmsg_ser->cdev, &rpmsg_zx29_ops);
	rpmsg_ser->cdev.owner = rpmsg_ser->owner;

	error = cdev_add(&rpmsg_ser->cdev, dev, rpmsg_ser->num);
	if (error) {
		unregister_chrdev_region(dev, rpmsg_ser->num);
		return error;
	}
	rpmsg_sim_classes = class_create(THIS_MODULE, rpmsg_sim_zx29.name);
	int result = 0;
	for (i = 0; i < rpmsg_ser->num; i++) {
//		rpmsg_ser->rpmsg_channel[i].actorID = rpdev->id;
		rpmsg_ser->rpmsg_channel[i].chID = channel_0 + i; 
		//sema_init(&(rpmsg_ser->rpmsg_channel[i].channelSema), 0);
		init_waitqueue_head(&rpmsg_ser->rpmsg_channel[i].channelwaitq);
		INIT_LIST_HEAD(&(rpmsg_ser->rpmsg_channel[i].RpMsg_packet_queue.queue));
		spin_lock_init(&(rpmsg_ser->rpmsg_channel[i].RpMsg_packet_queue.lock));
		rpmsg_ser->rpmsg_channel[i].RpMsg_packet_queue.qlen = 0;
		result = zx29_rpmsg_sim_register_device(rpmsg_sim_classes, rpmsg_ser, i, NULL);		
	}

	return 0;
}
static void __exit zx29_rpmsg_sim_exit(void)
{
	int i;
	zx29_rpmsg_ser *rpmsg_ser;
	rpmsg_ser = &rpmsg_sim_zx29;
	
	for (i = 0; i < rpmsg_ser->num; i++) {
		zx29_rpmsg_sim_unregister_device(rpmsg_sim_classes, rpmsg_ser, i);
	}
	
	class_destroy(rpmsg_sim_classes);
}

module_init(zx29_rpmsg_sim_init);
module_exit(zx29_rpmsg_sim_exit);

MODULE_AUTHOR("zte");
MODULE_DESCRIPTION("zte rpmsg driver");
MODULE_LICENSE("GPL");
MODULE_ALIAS("platform: rpmsg");
 
