/*
 * zx297510_uart.h -- sanchips zx297510 UART driver defines.
 */

#ifndef	__ZX297510_UART_H
#define	__ZX297510_UART_H

/*uart0 base address*/
#define ZX29_UART0_VA	   (ZX297510_UART0_BASE - ZX297510_A1_BASE + ZX29_A1_VA)

/*offset address*/
#define zx297510_UART_DR		0x04	/* Data read or written from the interface. */
#define zx297510_UART_SC        0x08    /* Set special character to generate a interrupt*/
#define zx297510_UART_RSR		0x10	/* Receive status register (Read). */
#define zx297510_UART_ECR		0x10	/* Error clear register (Write). */
#define zx297510_UART_FR		0x14	/* Flag register (Read only). */

#define zx297510_UART_ILPR		0x20	/* IrDA low power counter register. */
#define zx297510_UART_IBRD		0x24	/* Integer baud rate divisor register. */
#define zx297510_UART_FBRD		0x28	/* Fractional baud rate divisor register. */
#define zx297510_UART_LCRH		0x30	/* Line control register. */
#define zx297510_UART_CR		0x34	/* Control register. */
#define zx297510_UART_IFLS		0x38	/* Interrupt fifo level select. */
#define zx297510_UART_IMSC		0x40	/* Interrupt mask. */
#define zx297510_UART_RIS		0x44	/* Raw interrupt status. */
#define zx297510_UART_MIS		0x48	/* Masked interrupt status. */
#define zx297510_UART_ICR		0x4c	/* Interrupt clear register. */
#define zx297510_UART_DMACR		0x50	/* DMA control register. */


/*------ uart flag reg -----*/
#define UART_FR_RXBUSY		(1<<9)
#define UART_FR_TXBUSY		(1<<8)
#define UART_FR_TXFE		(1<<7)
#define UART_FR_RXFF		(1<<6)
#define UART_FR_TXFF		(1<<5)
#define UART_FR_RXFE		(1<<4)
#define UART_FR_DSR 		(1<<3)
#define UART_FR_DCD 		(1<<2)
#define UART_FR_CTS 		(1<<1)
#define UART_FR_RI			(1<<0)

/*------ uart control reg -----*/
#define UART_CR_CTSEN		(1<<15)	/* CTS hardware flow control */
#define UART_CR_RTSEN		(1<<14)	/* RTS hardware flow control */
#define UART_CR_OUT2		(1<<13)	/* OUT2 */
#define UART_CR_OUT1		(1<<12)	/* OUT1 */
#define UART_CR_RTS			(1<<11)	/* RTS */
#define UART_CR_DTR			(1<<10)	/* DTR */
#define UART_CR_RXE			(1<<9)	/* receive enable */
#define UART_CR_TXE			(1<<8)	/* transmit enable */
#define UART_CR_LBE			(1<<7)	/* loopback enable */
#define UART_CR_SIRLP		(1<<2)	/* SIR low power mode */
#define UART_CR_SIREN		(1<<1)	/* SIR enable */
#define UART_CR_UARTEN		(1<<0)	/* UART enable */

/*------ uart line control reg -----*/
#define UART_LCRH_SPS		(1<<7)
#define UART_LCRH_WLEN_8	(3<<5)
#define UART_LCRH_WLEN_7	(2<<5)
#define UART_LCRH_WLEN_6	(1<<5)
#define UART_LCRH_WLEN_5	(0<<5)
#define UART_LCRH_FEN		(1<<4)
#define UART_LCRH_STP2		(1<<3)
#define UART_LCRH_EPS		(1<<2)
#define UART_LCRH_PEN		(1<<1)
#define UART_LCRH_BRK		(1<<0)

/*------ uart fifo level select reg -----*/
#define UART_IFLS_RX1_8	(0 << 3)
#define UART_IFLS_RX2_8	(1 << 3)
#define UART_IFLS_RX4_8	(2 << 3)
#define UART_IFLS_RX6_8	(3 << 3)
#define UART_IFLS_RX7_8	(4 << 3)
#define UART_IFLS_TX1_8	(0 << 0)
#define UART_IFLS_TX2_8	(1 << 0)
#define UART_IFLS_TX4_8	(2 << 0)
#define UART_IFLS_TX6_8	(3 << 0)
#define UART_IFLS_TX7_8	(4 << 0)

/*------ uart interrupt mask reg -----*/
#define UART_OEIM		(1 << 10)	/* overrun error interrupt mask */
#define UART_BEIM		(1 << 9)	/* break error interrupt mask */
#define UART_PEIM		(1 << 8)	/* parity error interrupt mask */
#define UART_FEIM		(1 << 7)	/* framing error interrupt mask */
#define UART_RTIM		(1 << 6)	/* receive timeout interrupt mask */
#define UART_TXIM		(1 << 5)	/* transmit interrupt mask */
#define UART_RXIM		(1 << 4)	/* receive interrupt mask */
#define UART_DSRMIM		(1 << 3)	/* DSR interrupt mask */
#define UART_DCDMIM		(1 << 2)	/* DCD interrupt mask */
#define UART_CTSMIM		(1 << 1)	/* CTS interrupt mask */
#define UART_RIMIM		(1 << 0)	/* RI interrupt mask */

/*------ uart raw interrupt status reg -----*/
#define UART_OEIS		(1 << 10)	/* overrun error interrupt status */
#define UART_BEIS		(1 << 9)	/* break error interrupt status */
#define UART_PEIS		(1 << 8)	/* parity error interrupt status */
#define UART_FEIS		(1 << 7)	/* framing error interrupt status */
#define UART_RTIS		(1 << 6)	/* receive timeout interrupt status */
#define UART_TXIS		(1 << 5)	/* transmit interrupt status */
#define UART_RXIS		(1 << 4)	/* receive interrupt status */
#define UART_DSRMIS		(1 << 3)	/* DSR interrupt status */
#define UART_DCDMIS		(1 << 2)	/* DCD interrupt status */
#define UART_CTSMIS		(1 << 1)	/* CTS interrupt status */
#define UART_RIMIS		(1 << 0)	/* RI interrupt status */

/*------ uart interrupt clear reg -----*/
#define UART_SCIC		(1 << 11)	/* special character interrupt clear */
#define UART_OEIC		(1 << 10)	/* overrun error interrupt clear */
#define UART_BEIC		(1 << 9)	/* break error interrupt clear */
#define UART_PEIC		(1 << 8)	/* parity error interrupt clear */
#define UART_FEIC		(1 << 7)	/* framing error interrupt clear */
#define UART_RTIC		(1 << 6)	/* receive timeout interrupt clear */
#define UART_TXIC		(1 << 5)	/* transmit interrupt clear */
#define UART_RXIC		(1 << 4)	/* receive interrupt clear */
#define UART_DSRMIC		(1 << 3)	/* DSR interrupt clear */
#define UART_DCDMIC		(1 << 2)	/* DCD interrupt clear */
#define UART_CTSMIC		(1 << 1)	/* CTS interrupt clear */
#define UART_RIMIC		(1 << 0)	/* RI interrupt clear */

/*------ uart DMA control reg -----*/
#define UART_DMAONERR	(1 << 2)	/* disable dma on error */
#define UART_TXDMAE		(1 << 1)	/* enable transmit dma */
#define UART_RXDMAE		(1 << 0)	/* enable receive dma */

/*------ uart receive data  error indicator in data reg -----*/
#define UART_DR_OE		(1 << 11)
#define UART_DR_BE		(1 << 10)
#define UART_DR_PE		(1 << 9)
#define UART_DR_FE		(1 << 8)

/*------ uart RSR reg -----*/
#define UART_RSR_OE 		0x08
#define UART_RSR_BE 		0x04
#define UART_RSR_PE 		0x02
#define UART_RSR_FE 		0x01

#define UART_DR_ERROR		(UART_DR_OE|UART_DR_BE|UART_DR_PE|UART_DR_FE)
#define UART_DUMMY_DR_RX	(1 << 16)

#define UART_RSR_ANY		(UART_RSR_OE|UART_RSR_BE|UART_RSR_PE|UART_RSR_FE)
#define UART_FR_MODEM_ANY	(UART_FR_DCD|UART_FR_DSR|UART_FR_CTS)

#define UART_TXFIFO_SIZE 16

#define UART_PIN_NUM_BASE 48  /*the first uart pin number*/

#endif /* __ZX297502_UART_H */
