/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Date:          2020-12-30
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/



#define    MBIM_OPEN_MSG              0x00000001
#define    MBIM_CLOSE_MSG             0x00000002
#define    MBIM_COMMAND_MSG           0x00000003
#define    MBIM_HOST_ERROR_MSG        0x00000004
#define    MBIM_OPEN_DONE             0x80000001
#define    MBIM_CLOSE_DONE            0x80000002
#define    MBIM_COMMAND_DONE          0x80000003
#define    MBIM_FUNCTION_ERROR_MSG    0x80000004
#define    MBIM_INDICATE_STATUS_MSG   0x80000007


#define    MBIM_CID_DEVICE_CAPS  	1
#define    MBIM_CID_SUBSCRIBER_READY_STATUS  	2
#define    MBIM_CID_RADIO_STATE 	3
#define    MBIM_CID_PIN	4
#define    MBIM_CID_PIN_LIST  	5
#define    MBIM_CID_HOME_PROVIDER  	6
#define    MBIM_CID_PREFERRED_PROVIDERS  	7
#define    MBIM_CID_VISIBLE_PROVIDERS  	8
#define    MBIM_CID_REGISTER_STATE 	9
#define    MBIM_CID_PACKET_SERVICE  	10
#define    MBIM_CID_SIGNAL_STATE  	11
#define    MBIM_CID_CONNECT  	12
#define    MBIM_CID_PROVISIONED_CONTEXTS 	13
#define    MBIM_CID_SERVICE_ACTIVATION  	14
#define    MBIM_CID_IP_CONFIGURATION 	15
#define    MBIM_CID_DEVICE_SERVICES  	16
#define    MBIM_CID_DEVICE_SERVICE_SUBSCRIBE_LIST  	19
#define    MBIM_CID_PACKET_STATISTICS  	20
#define    MBIM_CID_NETWORK_IDLE_HINT  	21
#define    MBIM_CID_EMERGENCY_MODE  	22
#define    MBIM_CID_IP_PACKET_FILTERS  	23
#define    MBIM_CID_MULTICARRIER_PROVIDERS  	24
#define    MBIM_CID_SMS_CONFIGURATION  	1
#define    MBIM_CID_SMS_READ  2
#define    MBIM_CID_SMS_SEND  	3
#define    MBIM_CID_SMS_DELETE  	4
#define    MBIM_CID_SMS_MESSAGE_STORE_STATUS	5
#define    MBIM_CID_USSD  	1
#define    MBIM_CID_PHONEBOOK_CONFIGURATION  	1
#define    MBIM_CID_PHONEBOOK_READ  	2
#define    MBIM_CID_PHONEBOOK_DELETE  	3
#define    MBIM_CID_PHONEBOOK_WRITE  	4
#define    MBIM_CID_STK_PAC  	1
#define    MBIM_CID_STK_TERMINAL_RESPONSE  	2
#define    MBIM_CID_STK_ENVELOPE  3
#define    MBIM_CID_AKA_AUTH 	1
#define    MBIM_CID_AKAP_AUTH 	2
#define    MBIM_CID_SIM_AUTH 	3
#define    MBIM_CID_DSS_CONNECT 	1


#define MBIM_UUID_LEN  16

typedef struct mbim_indicate_status_msg_type
{
	u32	MessageType;
	u32	MessageLength;
	u32	TransactionId;
	u32	TotalFragments;
	u32	CurrentFragment;
	u8	DeviceServiceId[MBIM_UUID_LEN];
	u32	CID;
	u32	InformationBufferLength;
	u32	InformationBuffer;
} mbim_indicate_status_msg_type;

typedef struct mbim_open_msg_type
{
	__le32	MessageType;
	__le32	MessageLength;
	__le32	TransactionId;
	__le32	MaxControlTransfer;
} mbim_open_msg_type;


typedef struct mbim_close_msg_type
{
	__le32	MessageType;
	__le32	MessageLength;
	__le32	TransactionId;
} mbim_close_msg_type;


typedef struct mbim_command_msg_type
{
	u32	MessageType;
	u32	MessageLength;
	u32	TransactionId;
	u32	TotalFragments;
	u32	CurrentFragment;
	u8	DeviceServiceId[MBIM_UUID_LEN];
	u32	CID;
	u32	Commandtype;
	u32	InformationBufferLength;
	u32	InformationBuffer;
} mbim_command_msg_type;




struct mbim_ncm_info{
    uint16_t  nth_block_len ; 
    //uint16_t  ndp_head_len ; 
    uint16_t  ndp_datagram_off ; 
    uint16_t  ndp_datagram_len ; 

};

struct mbim_ntb_aligned_info 
{

	uint16_t	wNdpInDivisor;
	uint16_t	wNdpInPayloadRemainder;
	uint16_t	wNdpInAlignment;
	uint16_t	wNdpOutDivisor;
	uint16_t	wNdpOutPayloadRemainder;
	uint16_t	wNdpOutAlignment;
} ;

int  mbim_register(void (*resp_avail)(void *v), void *v);
int mbim_get_nth16_and_ndp16_size(void);
int mbim_ncm16_and_ndp16_init(char * buf ,int len);
int mbim_fill_ncm16_vary_head_info(char *buf ,struct mbim_ncm_info *info);
int mbim_get_first_ndp16_offset(struct            usb_request *req);
int mbim_get_next_datagram_fragment(struct           usb_request *req ,int prev_ndp_off, int* cur_first_datagram ,int *next_ndp);
int mbim_get_reverse_head_size() ;
int mbim_get_trans_buffer_size(void);













