

#include "poll_usb_desc.h"


#define	USB_VID             0x19D2//0x2008//
#define	USB_PID             0x0197
#define 	PRODUCT_RELEASE_NUMBER	(0x0100)	// 2ֽ




const poll_device_descriptor_t  poll_device_desc =
{
	sizeof(poll_device_descriptor_t),
	DEVICE_DESCRIPTOR,
	0x0200, 			// usb 2.0   //usb 1.1
	0x00,
	0x00,
	0x00,
	CONTROL_64,			// 64ֽ
	USB_VID,
	USB_PID,
	PRODUCT_RELEASE_NUMBER,
	0x01,               // manufacturer description
	0x02,               // product description
	0x03,               // serial number description
	0x01                // 
};


const trap_config_all_t  poll_config_desc =
{
//T_CONFIG_DESCRIPTOR
{
	sizeof(poll_config_descriptor_t),				//bLength
	CONFIG_DESCRIPTOR,							//bDescriptorType
	sizeof(trap_config_all_t),
	2,											//bNumInterfaces
	1,											//bConfigurationValue
	0,											//iConfigurationַ
	ATTR_D7 |ATTR_SELF_POWERED ,	//bmAttributes
	POWER_MA(500),											//
},


//T_INTERFACE_DESCRIPTOR
{
	sizeof(poll_interface_descriptor_t),		//bLength
	INTERFACE_DESCRIPTOR,				//bDescriptorType
	0,									//bInterfaceNumber
	0,									//bAlternateSetting
	0x02,								//bNumEndpoints
	VERDOR_SPECIFIC,					//bInterfaceClass
	0xff,								//bInterfaceSubClass
	0xff,								//bInterfaceProtocol
	0x04,								//iInterfaceַ
},

{
	sizeof(poll_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	EP_ADDRESS_DIRECTION_IN	|0x1, 	//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	BULK_512, 		   //wMaxPacketSize
	0,								//bInterval
},
{
	sizeof(poll_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	0x1, 							//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	BULK_512, 				 //wMaxPacketSize
	0,							//bInterval
},
//T_INTERFACE_DESCRIPTOR
{
    sizeof(poll_interface_descriptor_t),		//bLength
    INTERFACE_DESCRIPTOR,				//bDescriptorType
    1,									//bInterfaceNumber
    0,									//bAlternateSetting
    0x02,						//bNumEndpoints
    VERDOR_SPECIFIC,					//bInterfaceClass
    0xff,								//bInterfaceSubClass
    0xff,								//bInterfaceProtocol
    0x05,									//iInterfaceַ
},

{
	sizeof(poll_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	EP_ADDRESS_DIRECTION_IN	|0x2, 	//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	BULK_512, 	      //wMaxPacketSize
	0,								//bInterval
},

{
	sizeof(poll_ep_descriptor_t), 		//bLength
	ENDPOINT_DESCRIPTOR, 			//bDescriptorType
	0x2, 							//bEndpointAddress
	EP_ATTR_TRANSFER_TYPE_BULK, 	//bmAttributes
	BULK_512, 	     //wMaxPacketSize
	0,							//bInterval
},
};

const poll_dev_qual_descriptor_t  dev_qual_desc =
{
	sizeof(poll_dev_qual_descriptor_t),
	0x06,
	0x0200,                      // usb 2.0
	VERDOR_SPECIFIC,
	0x00,
	0x00,
	CONTROL_64,
	0x01,                      // 
	0x0
};


const poll_langid_descriptor_t    tLanguage=
{
        STRING_DESCRIPTOR_SIZE(1),
        STRING_DESCRIPTOR,
        LANGID_US_ENGLISH
};

const poll_string_descriptor_t    tManufacture=
{
        STRING_DESCRIPTOR_SIZE(11),
        STRING_DESCRIPTOR,
        UNICODE('Z'), UNICODE('T'), UNICODE('E'), UNICODE(' '), UNICODE('C'),
        UNICODE('o'), UNICODE(','), UNICODE('L'), UNICODE('t'), UNICODE('d'),
        UNICODE('.')
};

const poll_string_descriptor_t    tProduct=
{
        STRING_DESCRIPTOR_SIZE(14),
        STRING_DESCRIPTOR,
        UNICODE('Z'), UNICODE('T'), UNICODE('E'), UNICODE(' '), UNICODE('T'),
        UNICODE('r'), UNICODE('a'), UNICODE('p'),
};

const poll_string_descriptor_t    tSN=
{
        STRING_DESCRIPTOR_SIZE(16),
        STRING_DESCRIPTOR,
        UNICODE('z'), UNICODE('t'), UNICODE('e'), UNICODE('&'), UNICODE('u'),
        UNICODE('s'), UNICODE('b'), UNICODE('T'), UNICODE('r'), UNICODE('a'),
        UNICODE('p'),
};

const poll_string_descriptor_t	tIfc0Name=
    {
        STRING_DESCRIPTOR_SIZE(9),
        STRING_DESCRIPTOR,
        UNICODE('T'), UNICODE('r'), UNICODE('a'), UNICODE('p')
    };

const poll_string_descriptor_t	tIfc1Name=
    {
        STRING_DESCRIPTOR_SIZE(6),
        STRING_DESCRIPTOR,
        UNICODE('S'), UNICODE('e'), UNICODE('r'), UNICODE('i'), UNICODE('a'),
        UNICODE('l')
    };

const poll_string_descriptor_t *  const pollStrDescIdx[]=
{
	(poll_string_descriptor_t *)(&tLanguage),
	(poll_string_descriptor_t *)&tManufacture,
	(poll_string_descriptor_t *)&tProduct,
	(poll_string_descriptor_t *)&tSN,
	(poll_string_descriptor_t *)&tIfc0Name,
	(poll_string_descriptor_t *)&tIfc1Name,
};













