/*
|| sanchips corp add:20130819@zhouqiansheng  for usb proxy
     Refer to the scheme of usb division flow,
     we are supposed to add a new usb proxy module instead of adb driver.
*/
#include <mach/icp.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/slab.h>
#include <linux/io.h>

#include "usb_proxy_icp.h"

#define USBPROXY_SHAREMEM_BASE 0x239AB800/* dma space */
#define USBPROXY_SHAREMEM_SIZE 0x2800

#define USBPROXY_SHAREMEM_READADDR  USBPROXY_SHAREMEM_BASE
#define USBPROXY_SHAREMEM_WRITEADDR   USBPROXY_SHAREMEM_BASE+0x1400

#define RPMSG_CHANNEL_ID USB_ADB
#define RPMSG_CHANNEL_SIZE 32

static UsbProxy_Sharemem sharemem;
static int usbproxy_sharemem_icpmsg_send(Usbproxy_sharemem_icpmsg *msg);

/*******************************************************************************
 * Function: usbproxy_sharemem_get
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
void *usbproxy_sharemem_get(Usbproxy_Sharemem_Type memtype)
{
    if( memtype == USBPROXY_TYPE_READ )
    {
        if(sharemem.read_busy )
            return NULL;
        else
        {
            sharemem.read_busy = 1;
            return sharemem.mem_read;
        }
    }
    
    if( memtype == USBPROXY_TYPE_WRITE )
    {
        if(sharemem.write_busy )
            return NULL;
        else
        {
            sharemem.write_busy = 1;
            return sharemem.mem_write;
        }
    }

    return NULL;
}

EXPORT_SYMBOL(usbproxy_sharemem_get);
/*******************************************************************************
 * Function: usbproxy_sharemem_write
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
int usbproxy_sharemem_write(void* destbuf, void* srcbuf,  unsigned int len)
{
    Usbproxy_sharemem_icpmsg icpmsg;
    int ret = 0;

    memset( &icpmsg, 0, sizeof(icpmsg) );

    icpmsg.msgtype = USBPROXY_TYPE_WRITE;
    icpmsg.addr = destbuf;
    icpmsg.len = len;
    icpmsg.packet_end = 1;

    memcpy(destbuf, srcbuf, len);

    ret = usbproxy_sharemem_icpmsg_send( &icpmsg );

    if( ret != 0 )
    {
        return ret;
    }

    ret = wait_for_completion_interruptible(&sharemem.write_done);
	//ret = wait_event_interruptible(sharemem.write_wq, sharemem.write_complete);
	if (ret < 0) {
		PROXY_ERR("[usbproxy] %s error wait event!\n", __FUNCTION__);
        return -1;
	}

    PROXY_INFO("[usbproxy] write data have read by remote!\n");

    if( len != sharemem.len_write )
    {
        PROXY_ERR("[usbproxy] write error !want [%d] actual [%d]\n", 
                                    len, sharemem.len_write);
        len = sharemem.len_write;
    }

    sharemem.len_write = 0;
//    sharemem.write_complete = 0;
    
    return len;
}
EXPORT_SYMBOL(usbproxy_sharemem_write);
/*******************************************************************************
 * Function: usbproxy_sharemem_read
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
int usbproxy_sharemem_read(void* destbuf, void* srcbuf,  unsigned int len)
{
    Usbproxy_sharemem_icpmsg icpmsg;
    int ret = 0;
    
	PROXY_INFO("[usbproxy] %s \n", __FUNCTION__);

    ret = wait_for_completion_interruptible(&sharemem.read_done);
//	ret = wait_event_interruptible(sharemem.read_wq, sharemem.read_complete);
	if (ret < 0) {
		PROXY_ERR("[usbproxy] %s error wait event!\n", __FUNCTION__);
        return -1;
	}

	PROXY_INFO("[usbproxy] %s wait event!\n", __FUNCTION__);
    
    if( sharemem.len_read <= len )
        len = sharemem.len_read;
    else
        PROXY_ERR("[usbproxy] readdata lost! want [%d] actual [%d]\n", 
                            len, sharemem.len_read );

    memcpy(destbuf, srcbuf, len);

    memset( &icpmsg, 0, sizeof(icpmsg) );

    icpmsg.msgtype = USBPROXY_TYPE_READ;
    icpmsg.addr = srcbuf;
    icpmsg.len = len;
    icpmsg.packet_end = 1;
    
    sharemem.len_read = 0;

    ret = usbproxy_sharemem_icpmsg_send( &icpmsg );

	PROXY_INFO("[usbproxy] %s send msg [%d]!\n", __FUNCTION__, ret);

    if( ret != 0 )
    {
        return ret;
    }
   
    //sharemem.read_complete = 0;
    
    return len;
    
}
EXPORT_SYMBOL(usbproxy_sharemem_read);
/*******************************************************************************
 * Function: usbproxy_sharemem_put
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
void usbproxy_sharemem_put(void * buf)
{
    if( buf == sharemem.mem_read )
    {
        sharemem.read_busy = 0;
    }
    
    if( buf == sharemem.mem_write)
    {
        sharemem.write_busy = 0;
    }
}
EXPORT_SYMBOL(usbproxy_sharemem_put);
/*******************************************************************************
 * Function: usbproxy_sharemem_init
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
void usbproxy_sharemem_init(void)
{
//	init_waitqueue_head(&sharemem.read_wq);
//	init_waitqueue_head(&sharemem.write_wq);

    sharemem.read_busy = 0;

    sharemem.write_busy = 0;

    sharemem.mem_read = ioremap( USBPROXY_SHAREMEM_READADDR , 5*1024);/* 5K */

    if(sharemem.mem_read == NULL)
    {
        PROXY_ERR("[usbproxy] fatal error map read\n");

        return ;
    }

    sharemem.len_read = 0;

    sharemem.mem_write = ioremap( USBPROXY_SHAREMEM_WRITEADDR , 5*1024);/* 5K */

    if(sharemem.mem_write == NULL)
    {
        PROXY_ERR("[usbproxy] fatal error map write\n");

        return ;
    }

    sharemem.len_write = 0;

 //   sharemem.read_complete = 0;
    init_completion(&sharemem.read_done);

 //   sharemem.write_complete = 0;
    init_completion(&sharemem.write_done);
 
    usbproxy_sharemem_icpmsg_init();
    
}
EXPORT_SYMBOL(usbproxy_sharemem_init);
/*******************************************************************************
 * Function: usbproxy_sharemem_icpmsg_send
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
static int usbproxy_sharemem_icpmsg_send(Usbproxy_sharemem_icpmsg *msg)
{
    T_ZDrvRpMsg_Msg rpmsg = {0};
    int ret;

    rpmsg.actorID = PS_ID;
    rpmsg.chID = RPMSG_CHANNEL_ID;
    rpmsg.flag = 1;
    rpmsg.buf = msg;
    rpmsg.len = sizeof(*msg);

    ret = zDrvRpMsg_Write(&rpmsg);

    if( ret != rpmsg.len)
    {
        PROXY_ERR("[usbproxy] icpmsg send fail[%d]!\n", ret);
        return -1;
    }

    return 0;
}
/*******************************************************************************
 * Function: usbproxy_sharemem_icpmsg_receive
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
static void usbproxy_sharemem_icpmsg_receive(Usbproxy_sharemem_icpmsg *msg)
{
    PROXY_INFO("[usbproxy] icpmsg receive msgtype [%s]!\n", 
                msg ->msgtype==USBPROXY_TYPE_READ ?"read":"write");

    if( msg ->msgtype == USBPROXY_TYPE_READ )
    {   /* Զ˵readʾݱȡߣͷű˵write */
        sharemem.len_write = msg ->len;
        //sharemem.write_complete = 1;
        //wake_up_interruptible( &sharemem.write_wq );
        complete(& sharemem.write_done);

        return;
    }

    if( msg ->msgtype == USBPROXY_TYPE_WRITE )
    {   /* Զ˵writeʾԶд룬ͷű˵read */
        sharemem.len_read = msg ->len;
        //sharemem.read_complete = 1;
        //wake_up_interruptible(&sharemem.read_wq );
        complete(&sharemem.read_done);

        return;
    }
}

/*******************************************************************************
 * Function: usbproxy_sharemem_icpmsg_callback
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
static void usbproxy_sharemem_icpmsg_callback(void *buf, unsigned int Len)
{
    Usbproxy_sharemem_icpmsg msg = {0};
    
    if( Len != sizeof(Usbproxy_sharemem_icpmsg) )
    {
        PROXY_ERR("[usbproxy] icpmsg error!\n");
        return;
    }
    PROXY_INFO("[usbproxy] icpmsg callback!\n");
    memcpy(&msg, buf, sizeof(Usbproxy_sharemem_icpmsg));

    usbproxy_sharemem_icpmsg_receive(&msg);
}
/*******************************************************************************
 * Function: usbproxy_sharemem_icpmsg_init
 * Description:
 * Parameters:
 * Input:None
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
void usbproxy_sharemem_icpmsg_init(void)
{
    int ret = 0;
    
    ret = zDrvRpMsg_CreateChannel(PS_ID, RPMSG_CHANNEL_ID, 4+3*(sizeof(Usbproxy_sharemem_icpmsg)+4));

    if( ret != RPMSG_SUCCESS )
    {
        PROXY_ERR("[usbproxy] %s createchannel %d\n", __FUNCTION__, ret);
    }

    ret =  zDrvRpMsg_RegCallBack(PS_ID, RPMSG_CHANNEL_ID, usbproxy_sharemem_icpmsg_callback);
    if( ret != RPMSG_SUCCESS )
    {
        PROXY_ERR("[usbproxy] %s reg call back %d\n", __FUNCTION__, ret);
        /*ͷͨ*/
    }
}
EXPORT_SYMBOL(usbproxy_sharemem_icpmsg_init);

