/*
 * zx234290.h  --  ZTE ZX234290
 *
 * Copyright 2016 ZTE Corporation.
 *
 * Author: yuxiang
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under  the terms of the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 */

#ifndef __LINUX_MFD_ZX234290_H
#define __LINUX_MFD_ZX234290_H

#include <linux/mutex.h>
#include <mach/gpio.h>

#define zx234290_rails(_name) "zx234290_"#_name

#define u8 unsigned char

/* LDOs */
#define ZX234290_REG_LDO1	0
#define ZX234290_REG_LDO2	1
#define ZX234290_REG_LDO3	2
#define ZX234290_REG_LDO4	3
#define ZX234290_REG_LDO5	4
#define ZX234290_REG_LDO6	5
#define ZX234290_REG_LDO7	6
#define ZX234290_REG_LDO8	7

#define ZX234290_REG_LDO9	8
#define ZX234290_REG_LDO10	9
#define ZX234290_REG_LDO11	10

/* DCDC's */
#define ZX234290_REG_DCDC0	11
#define ZX234290_REG_DCDC1	12
#define ZX234290_REG_DCDC2	13
#define ZX234290_REG_DCDC3	14
#define ZX234290_REG_DCDC4	15

/* ZX regulator type list */
#ifndef ZX234290_PWR_FAUL_PROCESS
#define ZX234290_PWR_FAUL_PROCESS
#define 	ZX234290_INT_LDO_FAUL		0
#define 	ZX234290_INT_BUCK_FAUL		1
#endif

#define	ZX234290_INT_EOADC			2			/* xxxx x100	*/
#define	ZX234290_INT_PWRON_SHORT	3
#define	ZX234290_INT_PWRON_LONG		4
#define	ZX234290_INT_PWRON			5

#define	ZX234290_INT_RTC_ALRM		8
#define	ZX234290_INT_BATT_DET		10
#define	ZX234290_INT_RTC_MIN		11
#define	ZX234290_INT_RTC_HOUR		12

#define ZX234290_NUM_IRQ			13

#ifdef ZX234290_PWR_FAUL_PROCESS
int zx234290_register_client(struct notifier_block *nb);
int zx234290_unregister_client(struct notifier_block *nb);
int zx234290_notifier_call_chain(unsigned long val, void *v);
#endif

#if 0
/* External controls requests */
enum zx234290_ext_control {
	PWR_REQ_INPUT_NONE	= 0x00000000,
	PWR_REQ_INPUT_PREQ1	= 0x00000001,
	PWR_REQ_INPUT_PREQ2	= 0x00000002,
	PWR_REQ_INPUT_PREQ3	= 0x00000004,
	PWR_OFF_ON_SLEEP	= 0x00000008,
	PWR_ON_ON_SLEEP		= 0x00000010,
};
#endif

#if 0
typedef enum
{
	RESET_TO_NORMAL,                 /*reset to idle*/
	RESET_TO_CHARGER,                /*reset to charger*/
	RESET_TO_ALRAM,               /*reset to alarm*/
	RESET_TO_EXCEPTRESET,
	MAX_RESET_TYPE,
} T_ZDrvSys_RESET_TYPE;
#endif

typedef enum _T_ZDrvPmic_Enable{
    PM_DISABLE = 0,
    PM_ENABLE,
    PM_ENABLE_NOT_SUPPORT = -100,
    PM_ENABLE_MAX_STATUS = -255
} T_ZDrvPmic_Enable;

typedef enum _T_ZDrvPmic_NrmMode{
    PM_NRMMODE_AUTO = 0,
    PM_NRMMODE_PFM,
    PM_NRMMODE_PWM,
    PM_NRMMODE_NOT_SUPPORT = -100,
    PM_NRMMODE_MAX_STATUS = -255
}T_ZDrvPmic_NrmMode;

typedef enum _T_ZDrvPmic_SlpMode{
    PM_SLPMODE_AUTO_NORMAL = 0,    //auto in dcdc, normal in ldo
    PM_SLPMODE_ECO_NRMV,           //normal voltage
    PM_SLPMODE_ECO_SLPV,           //sleep voltage
    PM_SLPMODE_OFF,                //OFF
    PM_SLPMODE_NOT_SUPPORT = -100,
    PM_SLPMODE_MAX_STATUS = -255
}T_ZDrvPmic_SlpMode;

//consumer
typedef enum _T_ZDrvPmic_Regulator{
    VCORE0 = 0,
    VCORE1,
    VDDR,
    VMMC,
    VSD0,
    VSD1,
    VIO_LO,
    VIO_HI,
    VUSB_0V9,
    VUSB_3V3,
    VPLL_LO,
    VPLL_HI,
    VSIM1,
    VSIM2,
    VRF_LO,
    VRF_HI,
    VRF_SW,
    VPA,
    VCTCXO1,
    VCTCXO2,
    VSSBUF,
    VRTC,
} T_ZDrvPmic_Regulator;

typedef enum _T_ZDrvPmic_Vcore{
    PM_VOLT_0_6750 = 0,
    PM_VOLT_0_6875 ,
    PM_VOLT_0_7000 ,
    PM_VOLT_0_7125 ,
    PM_VOLT_0_7250 = 0x04,
    PM_VOLT_0_7375 ,
    PM_VOLT_0_7500 ,
    PM_VOLT_0_7625 ,
    PM_VOLT_0_7750 = 0x08 ,
    PM_VOLT_0_7875 ,
    PM_VOLT_0_8000 ,
    PM_VOLT_0_8125 ,
    PM_VOLT_0_8250 = 0x0c,
    PM_VOLT_0_8375 ,
    PM_VOLT_0_8500 ,
    PM_VOLT_0_8625 ,
    PM_VOLT_0_8750 = 0x10 ,
    PM_VOLT_0_8875 ,
    PM_VOLT_0_9000 ,
    PM_VOLT_0_9125 ,
    PM_VOLT_0_9250 = 0x14,
    PM_VOLT_0_9375 ,
    PM_VOLT_0_9500 ,
    PM_VOLT_0_9625 ,
    PM_VOLT_0_9750 = 0x18 ,
    PM_VOLT_0_9875 ,
    PM_VOLT_1_0000 ,
    PM_VOLT_1_0125 ,
    PM_VOLT_1_0250 = 0x1c,
    PM_VOLT_1_0375 ,
    PM_VOLT_1_0500 ,
    PM_VOLT_1_0625 ,
    PM_VOLT_1_0750 = 0x20 ,
    PM_VOLT_1_0875 ,
    PM_VOLT_1_1000 ,
    PM_VOLT_1_1125 ,
    PM_VOLT_1_1250 = 0x24,
    PM_VOLT_1_1375 ,
    PM_VOLT_1_1500 ,
    PM_VOLT_1_1625 ,
    PM_VOLT_1_1750 = 0x28 ,
    PM_VOLT_1_1875 ,
    PM_VOLT_1_2000 ,
    PM_VOLT_1_2125 ,
    PM_VOLT_1_2250 = 0x2c,
    PM_VOLT_1_2375 ,
    PM_VOLT_1_2500  = 0x2e,
    PM_VOLT_1_2625 ,
    PM_VOLT_1_2750 = 0x30 ,
    PM_VOLT_1_2875 ,
    PM_VOLT_1_3000 ,
    PM_VOLT_1_3125 ,
    PM_VOLT_1_3250 = 0x34,
    PM_VOLT_1_3375 ,
    PM_VOLT_1_3500  ,
    PM_VOLT_1_3625 ,
    PM_VOLT_1_3750 = 0x38 ,
    PM_VOLT_1_3875 ,
    PM_VOLT_1_4000 ,
    PM_VOLT_1_4125 ,
    PM_VOLT_1_4250 = 0x3c,
    PM_VOLT_1_4375 ,
    PM_VOLT_1_4500  ,
    PM_VOLT_1_4625 ,
    PM_VOLT_1_4750 = 0x40 ,
    PM_VOLT_1_4875 ,
    PM_VOLT_1_5000 ,
    PM_VOLT_1_5125 ,
    PM_VOLT_1_5250 = 0x44,
    PM_VOLT_1_5375 ,
    PM_VOLT_1_5500  ,
    PM_VOLT_1_5625 ,
    PM_VOLT_1_5750 = 0x48,
    PM_VOLT_1_5875 ,
    PM_VOLT_1_6000 ,
    PM_VOLT_1_6125 ,
    PM_VOLT_1_6250 = 0x4c,
    PM_VOLT_1_6375 ,
    PM_VOLT_1_6500  ,
    PM_VOLT_1_6625 ,
    PM_VOLT_1_6750 = 0x50,
    PM_VOLT_1_6875 ,
    PM_VOLT_1_7000 ,
    PM_VOLT_1_7125 ,
    PM_VOLT_1_7250 = 0x54,
    PM_VOLT_1_7375 ,
    PM_VOLT_1_7500  ,
    PM_VOLT_1_7625 ,
    PM_VOLT_1_7750 = 0x58,
    PM_VOLT_1_7875 ,
    PM_VOLT_1_8000 ,
    PM_VOLT_1_8125 ,
    PM_VOLT_1_8250 = 0x5c,
    PM_VOLT_1_8375 ,
    PM_VOLT_1_8500  ,
    PM_VOLT_1_8625 ,
    PM_VOLT_1_8750 = 0x60 ,
    PM_VOLT_1_8875 ,
    PM_VOLT_1_9000 ,
    PM_VOLT_1_9125 ,
    PM_VOLT_1_9250 = 0x64,
    PM_VOLT_1_9375 ,
    PM_VOLT_1_9500  ,
    PM_VOLT_1_9625 ,
    PM_VOLT_1_9750 = 0x68,
    PM_VOLT_1_9875 ,
    PM_VOLT_2_0000 ,
    PM_VOLT_2_0125 ,
    PM_VOLT_2_0250 = 0x6c,
    PM_VOLT_2_0375 ,
    PM_VOLT_2_0500  ,
    PM_VOLT_2_0625 ,
    PM_VOLT_2_0750 = 0x70,
    PM_VOLT_2_0875 ,
    PM_VOLT_2_1000 ,
    PM_VOLT_2_1125 ,
    PM_VOLT_2_1250 = 0x74,
    PM_VOLT_2_1375 ,
    PM_VOLT_2_1500  ,
    PM_VOLT_2_1625 ,
    PM_VOLT_2_1750 = 0x78 ,
    PM_VOLT_2_1875 ,
    PM_VOLT_2_2000 ,
    PM_VOLT_2_2125 ,
    PM_VOLT_2_2250 = 0x7c,
    PM_VOLT_2_2375 ,
    PM_VOLT_2_2500  ,
    PM_VOLT_2_2625 ,
    PM_VOLT_2_2750 = 0x80,
    PM_VOLT_2_2875 ,
    PM_VOLT_2_3000 ,
    PM_VOLT_2_3125 ,
    PM_VOLT_2_3250 = 0x84,
    PM_VOLT_2_3375 ,
    PM_VOLT_2_3500  ,
    PM_VOLT_2_3625 ,
    PM_VOLT_2_3750 = 0x88 ,
    PM_VOLT_2_3875 ,
    PM_VOLT_2_4000 ,
    PM_VOLT_2_4125 ,
    PM_VOLT_2_4250 = 0x8c,
    PM_VOLT_2_4375 ,
    PM_VOLT_2_4500  ,
    PM_VOLT_2_4625 ,
    PM_VOLT_2_4750 = 0x90,
    PM_VOLT_2_4875 ,
    PM_VOLT_2_5000 ,
    PM_VOLT_2_5125 ,
    PM_VOLT_2_5250 = 0x94,
    PM_VOLT_2_5375 ,
    PM_VOLT_2_5500  ,
    PM_VOLT_2_5625 ,
    PM_VOLT_2_5750 = 0x98 ,
    PM_VOLT_2_5875 ,
    PM_VOLT_2_6000 ,
    PM_VOLT_2_6125 ,
    PM_VOLT_2_6250 = 0x9c,
    PM_VOLT_2_6375 ,
    PM_VOLT_2_6500  ,
    PM_VOLT_2_6625 ,
    PM_VOLT_2_6750 = 0xa0,
    PM_VOLT_2_6875 ,
    PM_VOLT_2_7000 ,
    PM_VOLT_2_7125 ,
    PM_VOLT_2_7250 = 0xa4,
    PM_VOLT_2_7375 ,
    PM_VOLT_2_7500  ,
    PM_VOLT_2_7625 ,
    PM_VOLT_2_7750 = 0xa8,
    PM_VOLT_2_7875 ,
    PM_VOLT_2_8000 ,
    PM_VOLT_2_8125 ,
    PM_VOLT_2_8250 = 0xac,
    PM_VOLT_2_8375 ,
    PM_VOLT_2_8500  ,
    PM_VOLT_2_8625 ,
    PM_VOLT_2_8750 = 0xb0,
    PM_VOLT_2_8875 ,
    PM_VOLT_2_9000 ,
    PM_VOLT_2_9125 ,
    PM_VOLT_2_9250 = 0xb4,
    PM_VOLT_2_9375 ,
    PM_VOLT_2_9500  ,
    PM_VOLT_2_9625 ,
    PM_VOLT_2_9750 = 0xb8,
    PM_VOLT_2_9875 ,
    PM_VOLT_3_0000 ,
    PM_VOLT_3_0125 ,
    PM_VOLT_3_0250 = 0xbc,
    PM_VOLT_3_0375 ,
    PM_VOLT_3_0500  ,
    PM_VOLT_3_0625 ,
    PM_VOLT_3_0750 = 0xc0 ,
    PM_VOLT_3_0875 ,
    PM_VOLT_3_1000 ,
    PM_VOLT_3_1125 ,
    PM_VOLT_3_1250 = 0xc4,
    PM_VOLT_3_1375 ,
    PM_VOLT_3_1500  ,
    PM_VOLT_3_1625 ,
    PM_VOLT_3_1750 = 0xc8 ,
    PM_VOLT_3_1875 ,
    PM_VOLT_3_2000 ,
    PM_VOLT_3_2125 ,
    PM_VOLT_3_2250 = 0xcc,
    PM_VOLT_3_2375 ,
    PM_VOLT_3_2500  ,
    PM_VOLT_3_2625 ,
    PM_VOLT_3_2750 = 0xd0 ,
    PM_VOLT_3_2875 ,
    PM_VOLT_3_3000 ,
    PM_VOLT_3_3125 ,
    PM_VOLT_3_3250 = 0xd4,
    PM_VOLT_3_3375 ,
    PM_VOLT_3_3500  ,
    PM_VOLT_3_3625 ,
    PM_VOLT_3_3750 = 0xd8 ,
    PM_VOLT_3_3875 ,

    PM_VOLT_NOT_SUPPORT = -100,
    PM_VOLT_MAX_STATUS = -255,
 } T_ZDrvPmic_Voltage;



/**
 * struct zx234290_board
 * Board platform dat may be used to initialize regulators.
 */
struct zx234290_board {
	unsigned int irq_gpio_num;
    gpio_func_id irq_gpio_func;
    unsigned int pshold_gpio_num;
    gpio_func_id pshold_gpio_func;
    int irq_base;
	//struct zx234290_platform_data **regulator_pdata;
	//struct regulator_init_data *zx234290_pmic_init_data;
	//int num_regulator_pdata;
};

/**
 * struct zx234290 - zx234290 sub-driver chip access routines
 */

struct zx234290 {
	struct device *dev;
	/* for read/write acces */
	struct mutex io_mutex;

	/* For device IO interfaces: I2C or SPI */
	void *control_data;

	int (*read)(struct zx234290 *zx234290, u8 reg, int size, void *dest);
	int (*write)(struct zx234290 *zx234290, u8 reg, int size, void *src);

	/* Client devices */
	struct zx234290_regulator *regulator;

	/* GPIO Handling */

	/* IRQ Handling */
	struct mutex irq_lock;
	int chip_irq;
	int irq_base;
	int irq_num;
	unsigned int irq_mask;
};
#if 0
struct zx234290_platform_data {
	int irq;
	int irq_base;
    #if 0
	struct regulator_init_data *reg_init_data;
	int regulator_id;
	int init_uV;
	unsigned init_enable:1;
	unsigned init_apply:1;
	unsigned int ext_ctrl_flag;
	unsigned int flags;
	int delay_us;
	unsigned int tolerance_uv;
    #endif
};
#endif
int zx234290_i2c_read_simple(u8 reg, void *dest);
int zx234290_i2c_write_simple(u8 reg, void *src);
int zx234290_i2c_read_simple_PSM(u8 reg, void *dest);
int zx234290_i2c_write_simple_PSM(u8 reg, void *src);

int zx234290_set_bits(struct zx234290 *zx234290, u8 reg, u8 mask);
int zx234290_clear_bits(struct zx234290 *zx234290, u8 reg, u8 mask);
int zx234290_reg_read(struct zx234290 *zx234290, u8 reg);
int zx234290_reg_write(struct zx234290 *zx234290, u8 reg, u8 val);
int zx234290_device_init(struct zx234290 *zx234290);
void zx234290_device_exit(struct zx234290 *zx234290);
int zx234290_irq_init(struct zx234290 *zx234290, int irq, struct zx234290_board *pdata);


/*regulator defines*/
#if 1
/*
 * List of registers for ZX234290
*/

/////////////////////////////////////////////////
/*slave address 0x12*/
/////////////////////////////////////////////////
#define ZX234290_I2C_SLAVE_ADDR0   			(0x12)

    /*  interrupt and mask */
#define ZX234290_REG_ADDR_INTA         		0x00    /* INTERRUPT */
#define ZX234290_REG_ADDR_INTB          	0x01
#define ZX234290_REG_ADDR_INTA_MASK    		0x02
#define ZX234290_REG_ADDR_INTB_MASK   		0x03

    /* interrupt status */
#define ZX234290_REG_ADDR_STSA        		0x04
#define ZX234290_REG_ADDR_STSB       		0x05
#define ZX234290_REG_ADDR_STS_STARTUP  		0x06

    /* adc & softon select  */
#define ZX234290_REG_ADDR_SYS_CTRL        	0x07  /*0x8 0x9*/

    /* bucks normal voltage and sleep voltage   */
#define ZX234290_REG_ADDR_BUCK1_VOL        	0x0A  /*[00xx xxxx]0xB 0xC */
#define ZX234290_REG_ADDR_BUCK1_SLPVOL    	0x0D

    /* bucks mode   */
#define ZX234290_REG_ADDR_BUCK1_MODE       0x0E  	/* [xx] NRM [xx] SLP [00 00]*/
#define ZX234290_REG_ADDR_BUCK23_MODE       0x0F    /*[xx]BUCK3 NRM [xx]BUCK3 SLP [xx]BUCK2 NRM [xx]BUCK2 SLP*/
#define ZX234290_REG_ADDR_BUCK4_MODE       	0x11	/* [00 00] [xx] NRM [xx] SLP   0X10	*/

    /* ldo normal voltage   */
#define ZX234290_REG_ADDR_LDO12_VOL         0x12	/* [xxxx xxxx] */
#define ZX234290_REG_ADDR_LDO34_VOL         0x13
#define ZX234290_REG_ADDR_LDO56_VOL       	0x14
#define ZX234290_REG_ADDR_LDO78_VOL         0x15
#define ZX234290_REG_ADDR_LDO9_VOL          0x16    /* [xxxx 0000] */
#define ZX234290_REG_ADDR_LDO10_RTCLDO_VOL  0x17	/* [00 xx]VORTC [xx xx]LDO10*/


#define ZX234290_REG_ADDR_BUCK2_VOL        	0x1A	/* BUCK2 VLOT	*/

    /* ldo sleep voltage    */
#define ZX234290_REG_ADDR_LDO12_SLPVOL     	0x18	/* [xx xx]ldo2  [xx xx]ldo1*/
#define ZX234290_REG_ADDR_LDO3_SLPVOL       0x19	/* [00 00] [xx xx] */
#define ZX234290_REG_ADDR_LDO78_SLPVOL     	0x1B    /* [xx xx]ldo8  [xx xx]ldo7*/
#define ZX234290_REG_ADDR_LDO9_SLPVOL       0x1C    /* [xx xx] [00 00] */
#define ZX234290_REG_ADDR_LDO10_SLPVOL      0x1D    /* [00 00] [xx xx] */

    /* ldo mode */
#define ZX234290_REG_ADDR_LDO1234_MODE   	0x1E    /* [xx][xx][xx][xx]*/
#define ZX234290_REG_ADDR_LDO5678_MODE      0x1F
#define ZX234290_REG_ADDR_LDO910_MODE       0x20	/* [00] [xx] [xx] [00] */

    /* ldo enable   */
#define ZX234290_REG_ADDR_LDO_EN1			0x21	/* LDO8-1 */
#define ZX234290_REG_ADDR_LDO_EN2			0x22	/* [xx xx]BUCK4-1, [0xx0]LDO10-9*/

    /* adc code */
#define ZX234290_REG_ADDR_VBATADC_MSB		0x23    /*[xxxx xxxx]*/
#define ZX234290_REG_ADDR_VBATADC_LSB		0x24    /*[xxxx 0000]*/
#define ZX234290_REG_ADDR_ADC1_MSB			0x25
#define ZX234290_REG_ADDR_ADC1_LSB			0x26
#define ZX234290_REG_ADDR_ADC2_MSB			0x27
#define ZX234290_REG_ADDR_ADC2_LSB			0x28

    /* sink control */
#define ZX234297_REG_ADDR_SINK_CONTROL		0x29

    /* rtc */
#define ZX234290_REG_ADDR_RTC_CTRL1			0x30
#define ZX234290_REG_ADDR_RTC_CTRL2			0x31

    /* date and time */
#define ZX234290_REG_ADDR_SECONDS         	0x32
#define ZX234290_REG_ADDR_MINUTES         	0x33
#define ZX234290_REG_ADDR_HOURS           	0x34
#define ZX234290_REG_ADDR_DAY             	0x35
#define ZX234290_REG_ADDR_WEEK            	0x36
#define ZX234290_REG_ADDR_MONTH           	0x37
#define ZX234290_REG_ADDR_YEAR            	0x38

    /* alarm */
#define ZX234290_REG_ADDR_ALARM_MINUTE      0x39
#define ZX234290_REG_ADDR_ALARM_HOUR  		0x3A
#define ZX234290_REG_ADDR_ALARM_DAY        	0x3B
#define ZX234290_REG_ADDR_ALARM_WEEK      	0x3C
#define ZX234290_REG_ADDR_ALARM_SECOND     	0x3D

#define ZX234290_REG_ADDR_TIMER_CTRL		0x3E
#define ZX234290_REG_ADDR_TIMER_CNT			0x3F

    /* enable ldo output discharge resistance */
#define ZX234290_REG_ADDR_EN_DISCH1			0x40
#define ZX234290_REG_ADDR_EN_DISCH2			0x41

    /* power key control */
#define ZX234290_REG_ADDR_PWRKEY_CONTROL1	0x42
#define ZX234290_REG_ADDR_PWRKEY_CONTROL2   0x43

#define ZX234290_REG_ADDR_VERSION           0x44

    /*fault status*/
#define ZX234290_REG_ADDR_BUCK_FAULT_STATUS 0x45
#define ZX234290_REG_ADDR_LDO_FAULT_STATUS  0x46

#define ZX234290_REG_ADDR_BUCK_INT_MASK     0x47
#define ZX234290_REG_ADDR_LDO_INT_MASK      0x48

#define ZX234290_REG_ADDR_USER_RESERVED     0x50
#define ZX234290_REG_ADDR_GMT_TESTING       0xf1

#define ZX234290_MAX_REGISTER		        0x51 //yuxiang ?

/*0x04 status A*/
#define ZX234290_STATUSA_POWERON_LSH           	(5)
#define ZX234290_STATUSA_POWERON_WID            (1)
#define ZX234290_STATUSA_EOCADC_LSH           	(2)
#define ZX234290_STATUSA_EOCADC_WID             (1)

/* 0x06  STATUS REG -- STARTUP */
#define ZX234290_SYSPOR_STATUS_PWRON_STARTUP        (0x1 << 0)  /* PWR ON button */
#define ZX234290_SYSPOR_STATUS_RTC_ALARM_STARTUP 	(0x1 << 1)
#define ZX234290_SYSPOR_STATUS_PSHOLD_STARTUP       (0x1 << 2)
#define ZX234290_SYSPOR_STATUS_PWRONLLP_STARTUP  	(0x1 << 3)

/* discharger	*/
#define ZX234290_DISCHG1_LSB_LSH           	(0)
#define ZX234290_DISCHG1_LSB_WID            (4)

#define ZX234290_DISCHG1_MSB_LSH           	(5)
#define ZX234290_DISCHG1_MSB_WID            (2)

#define ZX234290_DISCHG2_LSH           	    (0)
#define ZX234290_DISCHG2_WID                (8)


/* BUCK VOLTAGE */
#define ZX234290_BUCK01_VSEL_LSH           	(0)
#define ZX234290_BUCK01_VSEL_WID            (6)

/* BUCK SLEEP VOLTAGE */
#define ZX234290_BUCK01_SLEEP_VSEL_LSH      (0)
#define ZX234290_BUCK01_SLEEP_VSEL_WID      (6)

/* BUCKS MODE CTROL	*/
#define ZX234290_REGULATOR_MODE_WID         (2)

#define ZX234290_BUCK0_SLPMODE_LSH          (0)
#define ZX234290_BUCK0_NRMMODE_LSH          (2)
#define ZX234290_BUCK1_SLPMODE_LSH          (4)
#define ZX234290_BUCK1_NRMMODE_LSH          (6)	/*[7:6]*/
#define ZX234290_BUCK2_SLPMODE_LSH          (0)
#define ZX234290_BUCK2_NRMMODE_LSH          (2)
#define ZX234290_BUCK3_SLPMODE_LSH          (4)
#define ZX234290_BUCK3_NRMMODE_LSH          (6)
#define ZX234290_BUCK4_SLPMODE_LSH          (0)
#define ZX234290_BUCK4_NRMMODE_LSH          (2)

/* LDO MODE, ONLY SLEEP MODE	 */
#define ZX234290_LDO1_SLPMODE_LSH          	(0)
#define ZX234290_LDO2_SLPMODE_LSH          	(2)
#define ZX234290_LDO3_SLPMODE_LSH          	(4)
#define ZX234290_LDO4_SLPMODE_LSH          	(6)
#define ZX234290_LDO5_SLPMODE_LSH          	(0)
#define ZX234290_LDO6_SLPMODE_LSH          	(2)
#define ZX234290_LDO7_SLPMODE_LSH          	(4)
#define ZX234290_LDO8_SLPMODE_LSH          	(6)
#define ZX234290_LDO9_SLPMODE_LSH          	(2)
#define ZX234290_LDO10_SLPMODE_LSH         	(4)
//#define ZX234290_LDO11_SLPMODE_LSH         	(6)

/* LDO VOLTAGE SELECT */
#define ZX234290_LDO_VSEL_WID               (4)

#define ZX234290_LDO1_VSEL_LSH           	(0)	/* [3:0]	*/
#define ZX234290_LDO2_VSEL_LSH              (4)	/* [7:4]	*/
#define ZX234290_LDO3_VSEL_LSH              (0)
#define ZX234290_LDO4_VSEL_LSH              (4)
#define ZX234290_LDO5_VSEL_LSH              (0)
#define ZX234290_LDO6_VSEL_LSH              (4)
#define ZX234290_LDO7_VSEL_LSH              (0)
#define ZX234290_LDO8_VSEL_LSH              (4)
#define ZX234290_LDO9_VSEL_LSH              (4)
#define ZX234290_LDO10_VSEL_LSH             (0)
#define ZX234290_LDO11_VSEL_LSH             (0)	/* [3:0]	*/

#define ZX234290_VORTC_VSEL_WID             (2)
#define ZX234290_VORTC_VSEL_LSH             (4)	/* [5][4]	*/
#define ZX234290_LDO5_VSEL_WID              (2) /* [1][0]*/


/* LDO SLEEP VOLTAGE	*/
#define ZX234290_BUCK2_VSEL_WID             (5)

#define ZX234290_BUCK2_VSEL_LSH         	(0)

#define ZX234290_LDO1_SLP_VSEL_LSH   		(0)	/* [3:0]	*/
#define ZX234290_LDO2_SLP_VSEL_LSH          (4)	/* [7:4]	*/
#define ZX234290_LDO3_SLP_VSEL_LSH          (0)
#define ZX234290_LDO7_SLP_VSEL_LSH          (0)
#define ZX234290_LDO8_SLP_VSEL_LSH          (0)
#define ZX234290_LDO11_SLP_VSEL_LSH         (0)	/* [3:0]	*/

/* ENABLE 0x21-0x22 */
#define ZX234290_LDOS_ON_WID                (1)

#define ZX234290_LDO1_ON_LSH               	(0)
#define ZX234290_LDO2_ON_LSH                (1)
#define ZX234290_LDO3_ON_LSH                (2)
#define ZX234290_LDO4_ON_LSH                (3)
#define ZX234290_LDO5_ON_LSH                (4)
#define ZX234290_LDO6_ON_LSH                (5)
#define ZX234290_LDO7_ON_LSH                (6)
#define ZX234290_LDO8_ON_LSH                (7)

#define ZX234290_LDO9_ON_LSH                (1)
#define ZX234297_LDO9_ON_LSH                (0)
#define ZX234290_LDO10_ON_LSH               (2)
#define ZX234297_LDO10_ON_LSH               (1)
#define ZX234290_BUCK1_ON_LSH               (4)
#define ZX234290_BUCK2_ON_LSH               (5)
#define ZX234290_BUCK3_ON_LSH               (6)
#define ZX234290_BUCK4_ON_LSH               (7)

/* LONG PRESSED TIME	*/
#define ZX234290_PWRON_TIME_LSH				(0)
#define ZX234290_PWRON_TIME_WID				(2)
#define ZX234290_PWRON_LONGPRESS_EN_LSH		(2)
#define ZX234290_PWRON_LONGPRESS_EN_WID		(1)
#define ZX234290_PWRON_LLP_TODO_LSH			(3)	/* LLP long long pressed */
#define ZX234290_PWRON_LLP_TODO_WID			(1)

/* sys ctrol 0x07	*/
#define ZX234290_SINK1_EN_LSH				(0)
#define ZX234290_SINK1_EN_WID				(1)
#define ZX234290_SINK2_EN_LSH				(1)
#define ZX234290_SINK2_EN_WID				(1)
#define ZX234290_ADC1_EN_LSH				(4)
#define ZX234290_ADC1_EN_WID				(1)
#define ZX234290_ADC2_EN_LSH				(3)
#define ZX234290_ADC2_EN_WID				(1)
#define ZX234290_ADC_START_LSH				(5)
#define ZX234290_ADC_START_WID				(1)
#define ZX234290_SOFTON_LSH					(7)

/* 0x08	*/
#define ZX234290_SINK2_CURSEL_LSH           (0)
#define ZX234290_SINK2_CURSEL_WID           (4)
/* 0x09 */
#define ZX234290_SINK1_CURSEL_LSH           (0)
#define ZX234290_SINK1_CURSEL_WID           (4)

/* 0x20	*/
#define ZX234297_SINK1_SLP_MODE_LSH			(6)
#define ZX234297_SINK2_SLP_MODE_LSH			(7)
#define ZX234297_SINK_SLP_MODE_WID			(1)
/* 0x22 */
#define ZX234297_SINK1_ON_LSH				(2)
#define ZX234297_SINK2_ON_LSH				(3)
#define ZX234297_SINK_ON_WID				(1)
/* 0x29 */
#define ZX234297_SINK1_CURRENT_LSH			(0)
#define ZX234297_SINK2_CURRENT_LSH			(4)
#define ZX234297_SINK_CURRENT_WID			(4)

#define ZX234290_LDO_RSTERR_LSH		(0)
#define ZX234290_LDO_RSTERR_WID		(1)

#endif  /* end of ZX234290 */

#define ZX234290_BITFVAL(var, lsh)   ( (var) << (lsh) )
#define ZX234290_BITFMASK(wid, lsh)  ( ((1U << (wid)) - 1) << (lsh) )
#define ZX234290_BITFEXT(var, wid, lsh)   ((var & ZX234290_BITFMASK(wid, lsh)) >> (lsh))

/* VBA - BUCK1 	6bit */
typedef enum _T_ZDrvZx234290_VbuckA
{
	VBUCKA_0_675 = 0x00,
	VBUCKA_0_700 = 0x02,
	VBUCKA_0_750 = 0x06,
	VBUCKA_0_800 = 0x0a,
	VBUCKA_0_850 = 0x0e,
	VBUCKA_0_900 = 0x12,/*default*/
	VBUCKA_0_950 = 0x16,
    VBUCKA_1_000 = 0x1a,
    VBUCKA_1_050 = 0x1e,
    VBUCKA_1_100 = 0x22,
    VBUCKA_1_150 = 0x26,
    VBUCKA_1_200 = 0x2a,
    VBUCKA_1_250 = 0x2e,

    VBUCKA_MAX

}T_ZDrvZx234290_VbuckA;

/* VBC - BUCK2 */
typedef enum _T_ZDrvZx234290_VbuckC
{
    VBUCKC_0_850 = 0x00,
	VBUCKC_0_900 = 0x02,
	VBUCKC_0_950 = 0x04,
	VBUCKC_1_000 = 0x06,
	VBUCKC_1_050 = 0x08,
	VBUCKC_1_100 = 0x0a,
	VBUCKC_1_150 = 0x0c,
    VBUCKC_1_200 = 0x0e,/*default*/
    VBUCKC_1_250 = 0x10,
    VBUCKC_1_300 = 0x12,
    VBUCKC_1_350 = 0x14,
    VBUCKC_1_400 = 0x16,
    VBUCKC_1_450 = 0x18,
    VBUCKC_1_500 = 0x1a,
    VBUCKC_1_550 = 0x1c,
    VBUCKC_1_600 = 0x1e,

    VBUCKC_MAX

}T_ZDrvZx234290_VbuckC;

/* VLA - ldo1/9/10	*/
typedef enum _T_ZDrvZx234290_VldoA
{
	VLDOA_0_725 = 0,
	VLDOA_0_750 = 1,
	VLDOA_0_775 = 2,
	VLDOA_0_800 = 3,
	VLDOA_0_825 = 4,
	VLDOA_0_850 = 5,
	VLDOA_0_875 = 6,
    VLDOA_0_900 = 7,
    VLDOA_0_925 = 8,
    VLDOA_0_950 = 9,
    VLDOA_0_975 = 10,
    VLDOA_1_000 = 11,
    VLDOA_1_025 = 12,
    VLDOA_1_050 = 13,
    VLDOA_1_075 = 14,
    VLDOA_1_100 = 15,

    VLDOA_MAX

}T_ZDrvZx234290_VldoA;

/* VLB - ldo5 2bit	*/
typedef enum _T_ZDrvZx234290_VldoB
{
    VLDOB_3_300 = 0,
    VLDOB_3_150 = 1,
    VLDOB_3_000 = 2,
    VLDOB_1_800 = 3,	/* 11	*/

    VLDOB_MAX

}T_ZDrvZx234290_VldoB;

/* VLC - ldo2/ldo3	*/
typedef enum _T_ZDrvZx234290_VldoC
{
	VLDOC_0_750 = 0,
	VLDOC_0_800 = 1,
	VLDOC_0_850 = 2,
	VLDOC_0_900 = 3,
    VLDOC_0_950 = 4,
    VLDOC_1_000 = 5,
    VLDOC_1_050 = 6,
    VLDOC_1_100 = 7,
    VLDOC_1_200 = 8,
    VLDOC_1_500 = 9,
    VLDOC_1_800 = 10,
    VLDOC_2_000 = 11,
    VLDOC_2_500 = 12,
    VLDOC_2_800 = 13,
    VLDOC_3_000 = 14,
    VLDOC_3_300 = 15,

    VLDOC_MAX

}T_ZDrvZx234290_VldoC;

/* VLD - ldo4/6/7/8	*/
typedef enum _T_ZDrvZx234290_VldoD
{
    VLDOD_1_400 = 0,
	VLDOD_1_500 = 1,
	VLDOD_1_600 = 2,
	VLDOD_1_800 = 3,
	VLDOD_1_850 = 4,
	VLDOD_2_000 = 5,
	VLDOD_2_050 = 6,
    VLDOD_2_500 = 7,
    VLDOD_2_550 = 8,
    VLDOD_2_700 = 9,
    VLDOD_2_750 = 10,
    VLDOD_2_800 = 11,
    VLDOD_2_850 = 12,
    VLDOD_2_900 = 13,
    VLDOD_2_950 = 14,
    VLDOD_3_000 = 15,

    VLDOD_MAX

}T_ZDrvZx234290_VldoD;

/*  VORTC 2bit	*/
typedef enum _T_ZDrvZx234290_VldoE
{
    VLDOE_1_800 = 0,
    VLDOE_2_500 = 1,
    VLDOE_3_000 = 2,
    VLDOE_3_300 = 3,	/* 11	*/

    VLDOE_MAX

}T_ZDrvZx234290_VldoE;

/* VLF - ldo10	*/
typedef enum _T_ZDrvZx234297_VldoF
{
    VLDOF_0_800 = 0,
	VLDOF_0_850 = 1,
	VLDOF_0_900 = 2,
	VLDOF_0_950 = 3,

	VLDOF_1_000 = 4,
	VLDOF_1_050 = 5,
	VLDOF_1_100 = 6,
    VLDOF_1_200 = 7,

    VLDOF_1_300 = 8,
    VLDOF_1_400 = 9,
    VLDOF_1_500 = 10,
    VLDOF_1_800 = 11,

    VLDOF_2_500 = 12,
    VLDOF_2_800 = 13,
    VLDOF_3_000 = 14,
    VLDOF_3_300 = 15,

    VLDOF_MAX

}T_ZDrvZx234297_VldoF;

/* BUCK3/4 EXTERNAL ADJUSTABLE	*/

typedef enum _T_ZDrvZx234290_LDO_ENABLE
{
    LDO_ENABLE_OFF  = 0,   /* 00 */
    LDO_ENABLE_ON   = 1,   /* 10 */

    LDO_AVTICE_MAX
}T_ZDrvZx234290_LDO_ENABLE;

typedef enum _T_ZDrvZx234290_LLP_ENABLE
{
    LLP_DISBALE  = 0,   /* 00 */
    LLP_ENABLE    = 1,   /* 10 */

    LLP_ENABLE_MAX
}T_ZDrvZx234290_LLP_ENABLE;

typedef enum _T_ZDrvZx234290_LLP_TODO
{
    LLP_SHUTDOWN  = 0,   /* 00 */
    LLP_RESTART   = 1,   /* 10 */

    LLP_TODO_MAX
}T_ZDrvZx234290_LLP_TODO;

typedef enum _T_ZDrvZx234290_LP_TIME
{
    LP_TIME_1S  = 0,
    LP_TIME_2S  ,
    LP_TIME_3S  ,
    LP_TIME_4S  ,

    LP_TIME_MAX
}T_ZDrvZx234290_LP_TIME;
typedef enum _T_ZDrvZx234290_TIME_IT
{
    LLP_DLY_128MS  = 0,
    LLP_DLY_500MS  ,
    LLP_DLY_1000MS  ,
    LLP_DLY_1500MS  ,

    LLP_DLY_MAX
}T_ZDrvZx234290_TIME_IT;

typedef enum _T_ZDrvZx234290_LLP_TIME
{
    LLP_TIME_6S  = 0,
    LLP_TIME_7S  ,
    LLP_TIME_8S  ,
    LLP_TIME_10S  ,

    LLP_TIME_MAX
}T_ZDrvZx234290_LLP_TIME;


/*
     BUCKSģʽΪģʽ˯ģʽ ģʽֻעPFM/PWMעء
    ˯ģʽעPFM/PWM/ECO/OFF/NRMӦýΪ ˯ģʽ״̬עPWM/PFM
    ҹע򿪹رգOFFڿŵµģʽĬϿ
    NRMMODEѹ˯ߵѹ
    LDOS˯ģʽһģʽɡҲNRM/ECO/OFF⼸״̬
*/

/* BUCK1/2/3/4 NORMAL MODE */
typedef enum _T_ZDrvZx234290_BUCK_NRMMODE
{
    BUCK_NRM_AUTO_WITH_ECO   	= 0,	/* 00/01 AUTO PWM/PSM ECO */
    BUCK_NRM_FORCE_PWM 	= 2,	/* 10 FORCE PWM	*/
    BUCK_NRM_AUTO_WITHOUT_ECO   = 3,  /* 00/01 AUTO PWM/PSM ECO */
    BUCK_NRMMODE_MAX
}T_ZDrvZx234290_BUCK_NRMMODE;

/* BUCK1 SLPMODE */
typedef enum _T_ZDrvZx234290_BUCK1_SLPMODE
{
    BUCK1_SLP_AUTO_WITHOUT_ECO   			= 0,	/* 00/11 AUTO PWM/PFM */
    BUCK1_SLP_AUTO_ECO    = 1,	/*BUCK1_SLP_AUTO_ECO_VOLT output voltage configred by FBDC1[5:0]*/
    BUCK1_SLP_AUTO_ECO_SLP    = 2,  /* output voltage configred by FBDC1_SLP[5:0]*/
    BUCK1_SLP_SHUTDOWN				= 3,	/* 11 OFF */
    BUCK1_SLPMODE_MAX
}T_ZDrvZx234290_BUCK1_SLPMODE;

/* BUCK2/3/4 SLPMODE */
typedef enum _T_ZDrvZx234290_BUCK234_SLPMODE
{
    BUCK234_SLP_AUTO_WITHOUT_ECO   			= 0,	/* 00 AUTO PWM/PFM without eco*/
    BUCK234_SLP_ECO_WITH_ECO    			= 1,	/* 0110 ECO */
    BUCK234_SLP_SHUTDOWN				= 3,	/* 11 OFF */

    BUCK234_SLPMODE_MAX
}T_ZDrvZx234290_BUCK234_SLPMODE;

/* LDO1/2/3/7/8/9/10 SLPMODE */
typedef enum _T_ZDrvZx234290_LDOA_SLPMODE
{
    LDOA_SLP_NRM_MODE   		= 0,	/* VOLDOx[3:0]  */
    LDOA_SLP_ECO_VOLT    		= 1,	/* VOLDOx[3:0]	*/
    LDOA_SLP_ECO_VOLT_SLP 		= 2,	/* VOLDOx_SLP[3:0]	*/
    LDOA_SLP_SHUTDOWN			= 3,	/* 11 OFF */
    LDOA_SLPMODE_MAX
}T_ZDrvZx234290_LDOA_SLPMODE;

/* LDO4/5/6/ SLPMODE	*/
typedef enum _T_ZDrvZx234290_LDOB_SLPMODE
{
    LDOB_SLP_NRM_MODE   			= 0,	/* VOLDOx[3:0]  */
    LDOB_SLP_ECO_VOLT    			= 1,	/* VOLDOx[3:0] 	*/
    LDOB_SLP_NRM_MODE_VOLT			= 2,	/* VOLDOx[3:0]	*/
    LDOB_SLP_SHUTDOWN				= 3,	/* 11 OFF */
    LDOB_SLPMODE_MAX
}T_ZDrvZx234290_LDOB_SLPMODE;

typedef enum _T_ZDrvZx234290_LdoDischarger
{
    DISCHARGER_LDO_9  = 0,
    DISCHARGER_LDO_10,
    DISCHARGER_LDO_X,   /*not support*/
    DISCHARGER_BUCK_4,
    DISCHARGER_BUCK_3,
    DISCHARGER_BUCK_2,
    DISCHARGER_BUCK_1,
    DISCHARGER_BUCK_X,  /*not support*/

    DISCHARGER_LDO_1,
    DISCHARGER_LDO_2,
    DISCHARGER_LDO_3,
    DISCHARGER_LDO_4,
    DISCHARGER_LDO_5,
    DISCHARGER_LDO_6,
    DISCHARGER_LDO_7,
    DISCHARGER_LDO_8,

    DISCHARGER_MAX
}T_ZDrvZx234290_LdoDischarger;

typedef enum _T_ZDrvZx234290_DISCHARGER_ENABLE
{
    DISCHARGER_DISBALE  = 0,   /* 00 */
    DISCHARGER_ENABLE    = 1,   /* 10 */

    DISCHARGER_ENABLE_MAX
}T_ZDrvZx234290_DISCHARGER_ENABLE;

typedef enum _T_ZDrvZx234290_LdoList
{
    LDOLIST_BUCK_1  = 0,
    LDOLIST_BUCK_2,
    LDOLIST_BUCK_3,
    LDOLIST_BUCK_4,
    LDOLIST_LDO_1,
    LDOLIST_LDO_2,
    LDOLIST_LDO_3,

    LDOLIST_LDO_4,
    LDOLIST_LDO_5,
    LDOLIST_LDO_6,//default off
    LDOLIST_LDO_7,
    LDOLIST_LDO_8,
    LDOLIST_LDO_9,//default off
    LDOLIST_LDO_10,
    LDOLIST_LDO_RTC,

    LDOLIST_MAX
}T_ZDrvZx234290_LdoList;

typedef enum _T_ZDrvZx234297_SINK
{
    ZX234297_SINK1 = 0,   /* 00 */
    ZX234297_SINK2 = 1,   /* 10 */

    ZX234297_SINK_MAX
}T_ZDrvZx234297_SINK;

typedef enum _T_ZDrvZx234297_SINK_SLPMODE
{
    SLPMODE_NORMAL = 0,   /* 00 */
    SLPMODE_SHUTDOWN = 1,   /* 10 */

    SLPMODE_MAX
}T_ZDrvZx234297_SINK_SLPMODE;

typedef enum _T_ZDrvZx234297_SINK_CURRENT
{
	SINK_CURRENT_5MA,
	SINK_CURRENT_10MA,
	SINK_CURRENT_15MA,
	SINK_CURRENT_20MA,
	SINK_CURRENT_30MA,
	SINK_CURRENT_40MA,
	SINK_CURRENT_50MA,
	SINK_CURRENT_60MA,
	SINK_CURRENT_70MA,
	SINK_CURRENT_80MA,
	SINK_CURRENT_90MA,
	SINK_CURRENT_100MA,
	SINK_CURRENT_110MA,
	SINK_CURRENT_120MA,

    SINK_CURRENT_MAX
}T_ZDrvZx234297_SINK_CURRENT;

typedef enum _T_ZDrvZx234290_ResetType
{
#if 0
	ZX234290_USER_RST_UNDEFINE	= 0,
	ZX234290_USER_RST_TO_NORMAL = 1,
	ZX234290_USER_RST_TO_CHARGER = 2,
	ZX234290_USER_RST_TO_ALARM = 3,
#else
	ZX234290_USER_RST_UNDEFINE	= 3,
	ZX234290_USER_RST_TO_NORMAL = 0,
	ZX234290_USER_RST_TO_CHARGER = 1,
	ZX234290_USER_RST_TO_ALARM = 2,
#endif
	ZX234290_USER_RST_TO_EXCEPT = 4,

	ZX234290_USER_RST_MAX
}T_ZDrvZx234290_ResetType;


int zx234290_get_chip_version(void);

int zx234290_set_buck1_onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_buck1_onoff(void);
int zx234290_set_buck1_active_mode(T_ZDrvZx234290_BUCK_NRMMODE status);
T_ZDrvZx234290_BUCK_NRMMODE zx234290_get_buck1_active_mode(void);
int zx234290_set_buck1_voltage(T_ZDrvZx234290_VbuckA vol);
T_ZDrvZx234290_VbuckA zx234290_get_buck1_voltage(void);
int zx234290_set_buck1_sleep_mode(T_ZDrvZx234290_BUCK1_SLPMODE status);
T_ZDrvZx234290_BUCK1_SLPMODE zx234290_get_buck1_sleep_mode(void);
int zx234290_set_buck1_sleep_voltage(T_ZDrvZx234290_VbuckA vol);

int zx234290_set_buck2_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_buck2_active_mode(T_ZDrvZx234290_BUCK_NRMMODE status);
int zx234290_set_buck2_sleep_mode(T_ZDrvZx234290_BUCK234_SLPMODE status);

int zx234290_set_buck3_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_buck3_active_mode(T_ZDrvZx234290_BUCK_NRMMODE status);
int zx234290_set_buck3_sleep_mode(T_ZDrvZx234290_BUCK234_SLPMODE status);


int zx234290_set_buck4_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_buck4_active_mode(T_ZDrvZx234290_BUCK_NRMMODE status);
int zx234290_set_buck4_sleep_mode(T_ZDrvZx234290_BUCK234_SLPMODE status);



int zx234290_set_ldo1_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo1_onoff_PSM(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_ldo1_onoff(void);
int zx234290_set_ldo1_voltage(T_ZDrvZx234290_VldoA vol);
T_ZDrvZx234290_VldoA zx234290_get_ldo1_voltage(void);
int zx234290_set_ldo1_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE zx234290_get_ldo1_sleep_mode(void);


int zx234290_set_ldo2_onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_ldo2_onoff(void);
int zx234290_set_ldo2_voltage(T_ZDrvZx234290_VldoC vol);
T_ZDrvZx234290_VldoC zx234290_get_ldo2_voltage(void);
int zx234290_set_ldo2_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE zx234290_get_ldo2_sleep_mode(void);

int zx234290_set_ldo3_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo3_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);

int zx234290_set_ldo4_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo4_sleep_mode(T_ZDrvZx234290_LDOB_SLPMODE status);


int zx234290_set_ldo5_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo5_onoff_PSM(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_ldo5_onoff(void);
int zx234290_set_ldo5_voltage(T_ZDrvZx234290_VldoB vol);
T_ZDrvZx234290_VldoB zx234290_get_ldo5_voltage(void);
int zx234290_set_ldo5_sleep_mode(T_ZDrvZx234290_LDOB_SLPMODE status);
T_ZDrvZx234290_LDOB_SLPMODE zx234290_get_ldo5_sleep_mode(void);

int zx234290_set_ldo6_onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_ldo6_onoff(void);
int zx234290_set_ldo6_voltage(T_ZDrvZx234290_VldoD vol);
T_ZDrvZx234290_VldoD zx234290_get_ldo6_voltage(void);
int zx234290_set_ldo6_sleep_mode(T_ZDrvZx234290_LDOB_SLPMODE status);
T_ZDrvZx234290_LDOB_SLPMODE zx234290_get_ldo6_sleep_mode(void);

int zx234290_set_ldo7_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo7_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);

int zx234290_set_ldo8_onoff(T_ZDrvZx234290_LDO_ENABLE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_ldo8_onoff(void);
int zx234290_set_ldo8_voltage(T_ZDrvZx234290_VldoD vol);
T_ZDrvZx234290_VldoD zx234290_get_ldo8_voltage(void);
int zx234290_set_ldo8_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDOA_SLPMODE zx234290_get_ldo8_sleep_mode(void);
int zx234290_set_ldo9_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo9_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);

int zx234290_set_ldo10_onoff(T_ZDrvZx234290_LDO_ENABLE status);
int zx234290_set_ldo10_sleep_mode(T_ZDrvZx234290_LDOA_SLPMODE status);
T_ZDrvZx234290_LDO_ENABLE zx234290_get_ldo10_onoff(void);
T_ZDrvZx234297_VldoF zx234290_get_ldo10_voltageF(void);
T_ZDrvZx234290_LDOA_SLPMODE zx234290_get_ldo10_sleep_mode(void);
int zx234297_set_ldo10_voltageF(T_ZDrvZx234297_VldoF vol);

int zDrvPmic_SetNormal_Onoff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable);
int zDrvPmic_SetNormal_Onoff_PSM(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable enable);
int zDrvPmic_SetNormal_Voltage(T_ZDrvPmic_Regulator regulator, int voltage);
int zDrvPmic_SetSleep_Voltage(T_ZDrvPmic_Regulator regulator, int voltage);
int zDrvPmic_GetNormal_Onoff(T_ZDrvPmic_Regulator regulator, T_ZDrvPmic_Enable* enable);
int zDrvPmic_GetNormal_Voltage(T_ZDrvPmic_Regulator regulator, int* voltage);
int zx234290_SetTllpToDo(T_ZDrvZx234290_LLP_TODO enable);
int zx234290_SetLlpEnable(T_ZDrvZx234290_LLP_ENABLE enable);
int z234290_SetLpTime(T_ZDrvZx234290_LP_TIME time);
int zx234290_SetRestartDly(T_ZDrvZx234290_TIME_IT time);
int zx234290_SetLlpTime(T_ZDrvZx234290_LLP_TIME time);
int zx234290_SetDischarger(T_ZDrvZx234290_LdoDischarger ldo, T_ZDrvZx234290_DISCHARGER_ENABLE enable);
int zDrvZx234290_LdoRstErr(void);
int Zx234290_SetUserReg_PSM(unsigned char data);

int zx234290_setSoftOn(bool SoftOn);
int zx234290_setSoftOn_PSM(bool SoftOn);
int zx234290_getPoweronStatus(void);
int zx234290_getPoweronStatus_PSM(void);

int zDrvZx234290_NormalSleepConfig(void);
int zDrvZx234290_ChgOnSleepConfig(void);
int zDrvZx234290_LdoInit(void);


/*adc fun*/
uint get_battery_voltage(void);
uint get_adc1_voltage(void);
uint get_adc2_voltage(void);

/* sink current control functions */
int zx234297_set_sink(T_ZDrvZx234297_SINK sink_num, int is_on, T_ZDrvZx234297_SINK_CURRENT sink_current);
int zx234297_set_sink_slpmode(T_ZDrvZx234297_SINK sink_num, T_ZDrvZx234297_SINK_SLPMODE mode);
#endif /*  __LINUX_MFD_TPS65912_H */
