/*
 * Platform data for the TI zx234502 battery charger driver.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _AW3215_CHARGER_H_
#define _AW3215_CHARGER_H_

#include <linux/bitops.h>
#include <mach/gpio.h>

typedef void                VOID;


struct zx234502_bat_calibration{
	short voltage; /* in mV - specify -1 for end of list */
	short level; /*in percent(0..100%)*/
};

struct aw3215_platform_data {
	unsigned int	gpio_chgen;	
	gpio_func_id 	gpio_chgen_gpio_sel;
	unsigned int	gpio_chgin;	
	gpio_func_id 	gpio_chgin_fun_sel;
	gpio_func_id 	gpio_chgin_gpio_sel;
	unsigned int	gpio_chgctrl;	
	gpio_func_id 	gpio_chgctrl_gpio_sel;
	unsigned int	gpio_chgstate;	
	gpio_func_id 	gpio_chgstate_fun_sel;	
	gpio_func_id 	gpio_chgstate_gpio_sel;	
	bool	ts_flag;
};
typedef signed int SINT32;
typedef unsigned int UINT32;

typedef enum _T_plug_in
{
	NOTHING,
	COMPUTER,
	CHARGER
}plug_in;

typedef enum _T_UsbHal_ConnectMessage
{
    CONNECTED_TO_HOST = 0x10,  /**< Host connect detected */
    DISCONNECTED_FROM_HOST,   /**< Host disconnect detected */
    CONNECTED_TO_DEVICE,  /**< Function connect detected */
    DISCONNECTED_FROM_DEVICE,  /**< Function disconnect detected */
    CHECK_CONNECT_MODE,
    CHECK_CONNECT_QUICK_POWER_ON,
    RECONNECT_TO_HOST
}T_UsbHal_ConnectMessage;

VOID USBRef_Detect(VOID *buf, UINT32 len);


#endif
