/*
 * Platform data for the TI zx234502 battery charger driver.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _ZX234502_CHARGER_H_
#define _ZX234502_CHARGER_H_

#include <linux/bitops.h>
#include <mach/gpio.h>

typedef void                VOID;

#define	ZX234502_MANUFACTURER	"ZTE"

#define ZX234502_BOOST_WORKDELAY		60000
#define ZX234502_BOOST_DET_TIMMER	60000/*1 minutes*/
#define ZX234502_BOOST_V_LIMIT			10/*mV 100mA*/

#define ZX234502_REG_MS					0x00 /* Main Setting */
#define ZX234502_REG_MS_CHGRST_MASK		BIT(7)
#define ZX234502_REG_MS_CHGRST_SHIFT		7
#define ZX234502_REG_MS_PMUON_MASK		BIT(5)
#define ZX234502_REG_MS_PMUON_SHIFT		5

#define ZX234502_REG_MS_ENSHIP_MASK		BIT(4)
#define ZX234502_REG_MS_ENSHIP_SHIFT		4
#define ZX234502_REG_MS_ENOTG_MASK		BIT(3)
#define ZX234502_REG_MS_ENOTG_SHIFT		3
#define ZX234502_REG_MS_ENCHG_MASK		BIT(2)
#define ZX234502_REG_MS_ENCHG_SHIFT		2
#define ZX234502_REG_MS_PWRBNK_MASK		BIT(1)
#define ZX234502_REG_MS_PWRBNK_SHIFT		1
#define ZX234502_REG_MS_INSUS_MASK		BIT(0)
#define ZX234502_REG_MS_INSUS_SHIFT		0

#define ZX234502_REG_ISC						0x01 /* Input Setting control */

#define ZX234502_REG_ISC_VINDPM_MASK			(BIT(6) | BIT(5) | BIT(4)| BIT(3))
#define ZX234502_REG_ISC_VINDPM_SHIFT	    	3
#define ZX234502_REG_ISC_ISETDCIN_MASK		(BIT(2) | BIT(1) | BIT(0))
#define ZX234502_REG_ISC_ISETDCIN__SHIFT		0


#define ZX234502_REG_ISC_ISET_DCIN_MASK		(BIT(2) | BIT(1) | BIT(0))
#define ZX234502_REG_ISC_ISET_DCIN_SHIFT		0

#define ZX234502_REG_VSC        					0x02 /*V SYS Control*/
#define ZX234502_REG_VSC_VSYS_MIN_MASK		(BIT(7) | BIT(6) | BIT(5))
#define ZX234502_REG_VSC_VSYS_MIN_SHIFT		5

#define ZX234502_REG_CCC						0x03 /* Charge Current Control */
#define ZX234502_REG_CCC_ISETA_MASK			(BIT(7) | BIT(6) | BIT(5) | BIT(4) | BIT(3) | BIT(2))
#define ZX234502_REG_CCC_ISETA_SHIFT			2
#define ZX234502_REG_CCC_ICHG_50PCT_MASK	BIT(1)
#define ZX234502_REG_CCC_ICHG_50PCT_SHIFT	1

#define ZX234502_REG_CVC		0x04 /* Charge Voltage Control */
#define ZX234502_REG_CVC_IPRECHG_MASK		(BIT(7) | BIT(6)| BIT(5)| BIT(4))
#define ZX234502_REG_CVC_IPRECHG_SHIFT		 4
#define ZX234502_REG_CVC_VBAT_MASK			 (BIT(3) | BIT(2)| BIT(1))
#define ZX234502_REG_CVC_VBAT_SHIFT		  	1
#define ZX234502_REG_CVC_VBATFC_MASK		 	BIT(0)
#define ZX234502_REG_CVC_VBATFC_SHIFT		0


#define ZX234502_REG_CTC	0x05 /* Charge Term/Timer Control */
#define ZX234502_REG_CTC_EN_TIMER_MASK		BIT(7)
#define ZX234502_REG_CTC_EN_TIMER_SHIFT		7
#define ZX234502_REG_CTC_EN_2XTIMER_MASK	BIT(4)
#define ZX234502_REG_CTC_EN_2XTIMER_SHIFT	4
#define ZX234502_REG_CTC_CVCOMP_MASK			(BIT(2) | BIT(1) | BIT(0))
#define ZX234502_REG_CTC_CVCOMP_SHIFT 		0



#define ZX234502_REG_OTGC						0x06 /* OTG Control */
#define ZX234502_REG_OTGC_OTGV_MASK			( BIT(7) | BIT(6) | BIT(5) |BIT(4))
#define ZX234502_REG_OTGC_OTGV_SHIFT	    		 4
#define ZX234502_REG_OTGC_OTGI_LIM_MASK		BIT(3)
#define ZX234502_REG_OTGC_OTGI_LIM_SHIFT		3
#define ZX234502_REG_OTGC_ENTS_OTG_MASK		BIT(2)
#define ZX234502_REG_OTGC_ENTS_OTG_SHIFT	2

#define ZX234502_REG_THR						0x07 /* Thermal Control / Detect*/
#define ZX234502_REG_THR_EN_THERM_MASK		BIT(7)
#define ZX234502_REG_THR_EN_THERM_SHIFT		7
#define ZX234502_REG_THR_THERM_THLD_MASK	(BIT(6) |BIT(5))
#define ZX234502_REG_THR_THERM_THLD_SHIFT	5
#define ZX234502_REG_THR_EN_2DET_MASK		BIT(4)
#define ZX234502_REG_THR_EN_2DET_SHIFT		4
#define ZX234502_REG_THR_EN_1DET_MASK		BIT(3)
#define ZX234502_REG_THR_EN_1DET_SHIFT		3
#define ZX234502_REG_THR_EN_ILIMITDJ_MASK	BIT(2)
#define ZX234502_REG_THR_EN_ILIMITDJ_SHIFT	2
#define ZX234502_REG_THR_EN_JEITA_MASK		BIT(1)
#define ZX234502_REG_THR_EN_JEITA_SHIFT		1

//#define ZX234502_REG_THR_NTC_DETECT_MASK	BIT(3)
//#define ZX234502_REG_THR_NTC_DETECT_SHIFT	3
//#define ZX234502_REG_THR_TS_SEL_MASK	BIT(2)
//#define ZX234502_REG_THR_TS_SEL_SHIFT	2
//#define ZX234502_REG_THR_TS_HOT_MASK	( BIT(1) | BIT(0) )
//#define ZX234502_REG_THR_TS_HOT_SHIFT	0

#define ZX234502_REG_TS					0x08 /* Charge Detect Control */
#define ZX234502_REG_TS_COLD_MASK		( BIT(7) | BIT(6) )
#define ZX234502_REG_TS_COLD_SHIFT		6
#define ZX234502_REG_TS_COOL_MASK		( BIT(5) | BIT(4) )
#define ZX234502_REG_TS_COOL_SHIFT		4
#define ZX234502_REG_TS_WARM_MASK		( BIT(3) | BIT(2) )
#define ZX234502_REG_TS_WARM_SHIFT		2
#define ZX234502_REG_TS_HOT_MASK			( BIT(1) | BIT(0) )
#define ZX234502_REG_TS_HOT_SHIFT			0

#define ZX234502_REG_PTS					0x09 /* Press Time Setting */
#define ZX234502_REG_PTS_NTCDET_MASK		BIT(7)
#define ZX234502_REG_PTS_NTCDET_SHIFT	7
#define ZX234502_REG_PTS_TSSEL_MASK		BIT(6)
#define ZX234502_REG_PTS_TSSEL_SHIFT		6



#define ZX234502_REG_CIIS					0x0A /* Charge/Input Int Status */
#define ZX234502_REG_CIIS_ALL_MASK 		(BIT(7)|BIT(6)|BIT(5)|BIT(4)|BIT(3)|BIT(2)|BIT(1)|BIT(0))
#define ZX234502_REG_CIIS_ALL_SHIFT   		0
#define ZX234502_REG_CIIS_INT_MASK		BIT(7)
#define ZX234502_REG_CIIS_INT_SHIFT		7
#define ZX234502_REG_CIIS_CHGRUN_MASK	BIT(6)
#define ZX234502_REG_CIIS_CHGRUN_SHIFT	6
#define ZX234502_REG_CIIS_INLIMIT_MASK	BIT(5)
#define ZX234502_REG_CIIS_INLIMIT_SHIFT	5
#define ZX234502_REG_CIIS_THERM_MASK		BIT(4)
#define ZX234502_REG_CIIS_THERM_SHIFT		4
#define ZX234502_REG_CIIS_TS_METER_MASK	( BIT(3) | BIT(2) | BIT(1) )
/*define for TS*/
#define ZX234502_REG_CISS_TS_COLD    		0x6
#define ZX234502_REG_CISS_TS_COOL			0x4
#define ZX234502_REG_CISS_TS_NORMAL		0x0
#define ZX234502_REG_CISS_TS_WARM		0x1
#define ZX234502_REG_CISS_TS_HOT			0x3
#define ZX234502_REG_CISS_TS_NONTC		0x2
#define ZX234502_REG_CISS_TS_NOBAT		0x7


#define ZX234502_REG_CIIS_TS_METER_SHIFT    		 1
#define ZX234502_REG_CIIS_DCDET_MASK   	  		 BIT(0)
#define ZX234502_REG_CIIS_DCDET_SHIFT       			 0

#define ZX234502_REG_CIIM							0x0B /*Charge/Input Int Mask */
#define ZX234502_REG_CIIM_MASK_CHGRUN_MASK		BIT(6)
#define ZX234502_REG_CIIM_MASK_CHGRUN_SHIFT		6
#define ZX234502_REG_CIIM_MASK_INLIMIT_MASK		BIT(5)
#define ZX234502_REG_CIIM_MASK_INLIMIT_SHIFT		5
#define ZX234502_REG_CIIM_MASK_THR_MASK			BIT(4)
#define ZX234502_REG_CIIM_MASK_THR_SHIFT			4
#define ZX234502_REG_CIIM_MASK_TS_MASK   	    		BIT(3)
#define ZX234502_REG_CIIM_MASK_TS_SHIFT          	3
#define ZX234502_REG_CIIM_MASK_DCDET_MASK      	BIT(0)
#define ZX234502_REG_CIIM_MASK_DCDET_SHIFT		0

#define ZX234502_REG_CBIS							0x0C/*Charg /Battery Int Status*/
#define ZX234502_REG_CBIS_ALL_MASK				(BIT(7)|BIT(6)|BIT(5)|BIT(4)|BIT(3)|BIT(2)|BIT(1)|BIT(0))
#define ZX234502_REG_CBIS_ALL_SHIFT				0
#define ZX234502_REG_CBIS_DCIN_PG_MASK			BIT(7)
#define ZX234502_REG_CBIS_DCIN_PG_SHIFT			7
#define ZX234502_REG_CBIS_BAT_FAULT_MASK		(BIT(6) |BIT(5))
#define ZX234502_REG_CBIS_BAT_FAULT_SHIFT		5
#define ZX234502_REG_CBIS_BATLOW_MASK			BIT(6)
#define ZX234502_REG_CBIS_BATLOW_SHIFT			6
#define ZX234502_REG_CBIS_NOBAT_MASK				BIT(5)
#define ZX234502_REG_CBIS_NOBAT_SHIFT			5
#define ZX234502_REG_CBIS_CHGSTAT_MASK			(BIT(4) | BIT(3))
#define ZX234502_REG_CBIS_CHGSTAT_SHIFT			3
#define ZX234502_REG_CBIS_EOC_MASK				BIT(4)
#define ZX234502_REG_CBIS_EOC_SHIFT				4
#define ZX234502_REG_CBIS_CHGDONE_MASK			BIT(3)
#define ZX234502_REG_CBIS_CHGDONE_SHIFT			3
#define ZX234502_REG_CBIS_SAFE_TIMER_MASK		BIT(2)
#define ZX234502_REG_CBIS_SAFE_TIMER_SHIFT		2
#define ZX234502_REG_CBIS_OTG_FAULT_MASK		BIT(1)
#define ZX234502_REG_CBIS_OTG_FAULT_SHIFT		1


#define ZX234502_REG_CBIM 							0x0D/*Charg /Battery Int Mask*/
#define ZX234502_REG_CBIM_MASK_DCIN_PG_MASK	BIT(7)
#define ZX234502_REG_CBIM_MASK_DCIN_PG_SHIFT	7
#define ZX234502_REG_CBIM_MASK_BATLOW_MASK		BIT(6)
#define ZX234502_REG_CBIM_MASK_BATLOW_SHIFT	6
#define ZX234502_REG_CBIM_MASK_NOBAT_MASK      	BIT(5)
#define ZX234502_REG_CBIM_MASK_NOBAT_SHIFT      	5
#define ZX234502_REG_CBIM_MASK_EOC_MASK			BIT(4)
#define ZX234502_REG_CBIM_MASK_EOC_SHIFT		4
#define ZX234502_REG_CBIM_MASK_CHGDONE_MASK	BIT(3)
#define ZX234502_REG_CBIM_MASK_CHGDONE_SHIFT	3
#define ZX234502_REG_CBIM_MASK_SAFE_TIMER_MASK      		BIT(2)
#define ZX234502_REG_CBIM_MASK_SAFE_TIMER_SHIFT    		 2
#define ZX234502_REG_CBIM_MASK_OTG_FAULT_MASK			 BIT(1)
#define ZX234502_REG_CBIM_MASK_OTG_FAULT_SHIFT			1

#define ZX234502_REG_PIS									0x0E  /*PowerOn int status*/
#define ZX234502_REG_PIS_ALL_MASK     						(BIT(7)|BIT(6)|BIT(5)|BIT(4)|BIT(3)|BIT(2)|BIT(1)|BIT(0))
#define ZX234502_REG_PIS_ALL_SHIFT						0
//#define ZX234502_REG_PIS_POWERON_LPOFF_MASK      BIT(7)
//#define ZX234502_REG_PIS_POWERON_LPOFF_SHIFT     7
#define ZX234502_REG_PIS_POWERON_IT_MASK				BIT(6)
#define ZX234502_REG_PIS_POWERON_IT_SHIFT				 6
#define ZX234502_REG_PIS_POWERON_LP_MASK				BIT(5)
#define ZX234502_REG_PIS_POWERON_LP_SHIFT				5

#define ZX234502_REG_PIM									0x0F  /*PowerOn int Mask*/
//#define ZX234502_REG_PIM_MASK_POWERON_LPOFF_MASK      BIT(7)
//#define ZX234502_REG_PIM_MASK_POWERON_LPOFF_SHIFT     7
#define ZX234502_REG_PIM_MASK_POWERON_IT_MASK			BIT(6)
#define ZX234502_REG_PIM_MASK_POWERON_IT_SHIFT			6
#define ZX234502_REG_PIM_MASK_POWERON_LP_MASK			BIT(5)
#define ZX234502_REG_PIM_MASK_POWERON_LP_SHIFT			5


#define ZX234502_REG_CFIS									0x10  /*ChargIn/Fault Int Status*/
#define ZX234502_REG_CFIS_ALL_MASK						(BIT(7)|BIT(6)|BIT(5)|BIT(4)|BIT(3)|BIT(2)|BIT(1)|BIT(0))
#define ZX234502_REG_CFIS_ALL_SHIFT						0
#define ZX234502_REG_CFIS_CHGTYPIN_MASK					(BIT(7)|BIT(6)|BIT(5))
#define ZX234502_REG_CFIS_CHGTYPIN_SHIFT					5
/*charger type define*/
#define ZX234502_CHGTYPIN_SDP			0x0
#define ZX234502_CHGTYPIN_SONY1		0x1
#define ZX234502_CHGTYPIN_SONY2		0x2
#define ZX234502_CHGTYPIN_APPLE1		0x3
#define ZX234502_CHGTYPIN_APPLE2		0x4
#define ZX234502_CHGTYPIN_NIKON		0x5
#define ZX234502_CHGTYPIN_CDP			0x6
#define ZX234502_CHGTYPIN_DCP			0x7
/*end define charger type*/
#define ZX234502_REG_CFIS_DPM_MASK			BIT(4)
#define ZX234502_REG_CFIS_DPM_SHIFT			4
#define ZX234502_REG_CFIS_INCC_MASK			BIT(3)
#define ZX234502_REG_CFIS_INCC_SHIFT			3
#define ZX234502_REG_CFIS_DPPM_MASK			BIT(2)
#define ZX234502_REG_CFIS_DPPM_SHIFT         	2
#define ZX234502_REG_CFIS_THSD_MASK			BIT(1)
#define ZX234502_REG_CFIS_THSD_SHIFT			1
#define ZX234502_REG_CFIS_NTC100K_MASK		BIT(0)
#define ZX234502_REG_CFIS_NTC100K_SHIFT		0

#define ZX234502_REG_VER						0x11  /*record the version info*/
#define ZX234502_REG_VER_INFO_MASK			(BIT(5)|BIT(4)|BIT(3)|BIT(2)|BIT(1)|BIT(0))
#define ZX234502_REG_VER_INFO_SHIFT			0
#define ZX234502_REG_VERS						0x03

#define ZX234502_REG_MAX						0x12 //yuxiang ?

struct zx234502_bat_calibration{
	short voltage; /* in mV - specify -1 for end of list */
	short level; /*in percent(0..100%)*/
};

struct zx234502_platform_data {
	unsigned int	gpio_int;	/* GPIO pin that's connected to INT# */
	gpio_func_id 	gpio_int_fun_sel;
	
	//unsigned int capacity; /* total capacity in uAh */
	struct zx234502_bat_calibration *charging;
	int charging_size;
	struct zx234502_bat_calibration  *discharging;
	int	discharging_size;
	bool	ts_flag;
	bool	boost_flag;
	unsigned int	boost_cur_gpio1;
	gpio_func_id	boost_gpio1_fun_sel;
	
	unsigned int	boost_cur_gpio2;
	gpio_func_id	boost_gpio2_fun_sel;
	
	unsigned int	boost_cur_gpio3;
	gpio_func_id	boost_gpio3_fun_sel;
	
	unsigned int	boost_loadswitch_gpio;
	gpio_func_id	boost_loadswitch_fun_sel;
};

typedef signed int SINT32;
typedef unsigned int UINT32;

typedef enum _T_plug_in
{
	NOTHING,
	COMPUTER,
	CHARGER
}plug_in;

typedef enum _T_UsbHal_ConnectMessage
{
    CONNECTED_TO_HOST = 0x10,  /**< Host connect detected */
    DISCONNECTED_FROM_HOST,   /**< Host disconnect detected */
    CONNECTED_TO_DEVICE,  /**< Function connect detected */
    DISCONNECTED_FROM_DEVICE,  /**< Function disconnect detected */
    CHECK_CONNECT_MODE,
    CHECK_CONNECT_QUICK_POWER_ON,
    RECONNECT_TO_HOST
}T_UsbHal_ConnectMessage;

VOID USBRef_Detect(VOID *buf, UINT32 len);


#endif
