
#ifndef RPMSG_H
#define RPMSG_H

#include <mach/iomap.h>
#include "icp.h"
#include <linux/device.h>

/***********************************************************************************
 ***   we have 4 cores at most,  AP/M0/PS/PHY    ***********************************
 ***********************************************************************************
 */

#define TRUE 								1
#define FALSE 								0

#define CHANNEL_FLAG 						(0x1)
#define CHANNEL_INT_FLAG 					(0x1<<16)
#define CHANENL_POLL_FLAG 					(0x1<<17)

/* 24=sizeof(T_HalRpMsg_ChInfo) */
/* iram */
#define ICP_IRAM_M0AP_BASEADDR				(ICP_IRAM_AP_BASE)
#define ICP_IRAM_M0AP_SIZE					(0x40 + CHANNEL_AP2M0_MAXID *24)
#define ICP_IRAM_APM0_BASEADDR 				(ICP_IRAM_AP_BASE + ICP_IRAM_M0AP_SIZE)
#define ICP_IRAM_APM0_SIZE					(0x40 + CHANNEL_AP2M0_MAXID *24)

#define ICP_IRAM_PSAP_BASEADDR				(ICP_IRAM_APM0_BASEADDR + ICP_IRAM_APM0_SIZE)
#define ICP_IRAM_PSAP_SIZE					(0xC0 + CHANNEL_AP2PS_MAXID *24)
#define ICP_IRAM_APPS_BASEADDR 				(ICP_IRAM_PSAP_BASEADDR + ICP_IRAM_PSAP_SIZE)
#define ICP_IRAM_APPS_SIZE					(0xC0 + CHANNEL_AP2PS_MAXID *24)

/* ddr */
#define ICP_DDR_APM0_BASEADDR 				(ZX_RPMSG_DDR_BASE)
#define ICP_DDR_APM0_SIZE 					0
#define ICP_DDR_M0AP_BASEADDR 				(ZX_RPMSG_DDR_BASE)
#define ICP_DDR_M0AP_SIZE 					0
	
#define ICP_DDR_APPS_BASEADDR 				(ZX_RPMSG_DDR_BASE)
#define ICP_DDR_APPS_SIZE 					(ICP_MEM_SIZE>>1)
#define ICP_DDR_PSAP_BASEADDR 				(ICP_DDR_APPS_BASEADDR + ICP_DDR_APPS_SIZE)
#define ICP_DDR_PSAP_SIZE 					(ICP_MEM_SIZE>>1)

#define RPMSG_WRITE_INT 					(0x1)
#define RPMSG_READ_POLL 					(0x1<<1)

#ifdef _USE_CAP_SYS
#define RPMSG_DDR_APPS0_BASEADDR			(DDR_BASE_CAPBUF_ADDR_PA)
#define RPMSG_DDR_APPS0_SIZE				(ICP_MEM_SIZE >> 1)
#define RPMSG_DDR_PS0AP_BASEADDR			(RPMSG_DDR_APPS0_BASEADDR + RPMSG_DDR_APPS0_SIZE)
#define RPMSG_DDR_PS0AP_SIZE				(ICP_MEM_SIZE >> 1)
#endif

/*channels or devices definition */
#define ICP_CHANNEL_DRIVER         	channel_0
#define ICP_CHANNEL_PSM            	channel_1     //AP<->PSAP<->M0
#define ICP_CHANNEL_USB_ADB     	channel_2

#define ICP_CHANNEL_WAN1        	channel_3
#define ICP_CHANNEL_WAN2            channel_4    //device name
#define ICP_CHANNEL_WAN3           	channel_5    //device name
#define ICP_CHANNEL_WAN4           	channel_6    //device name

#define ICP_CHANNEL_DTMF  			channel_7
#define ICP_CHANNEL_DEV_BUFFREE    	channel_8

#define ICP_CHANNEL_AMT             channel_9
#define ICP_CHANNEL_RAMDUMP         channel_10

#define ICP_CHANNEL_VSIM            channel_11
#define ICP_CHANNEL_ISMS           	channel_12

#define ICP_CHANNEL_IPSEC1			channel_13
#define ICP_CHANNEL_IPSEC2			channel_14
#define ICP_CHANNEL_IPSEC3			channel_15
#define ICP_CHANNEL_IPSEC4			channel_16



typedef enum _T_ZDrvRpMsg_ChID
{
    CHANNEL_BASEID,

    channel_0 = CHANNEL_BASEID,    	//driver     just for AP<->PS
    channel_1,             		   	//PSM
    channel_2,					  	//USB_DETCT
    channel_3,					  	//USB_ADB
    channel_4,					 	//WAN
    
    channel_5,					 	//LAN1
    channel_6,					 	//LAN2
    channel_7,						//DEV_BUFMALLOC
    channel_8,						//DEV_BUFFREE
    channel_9,						//AT

    CHANNEL_AP2M0_MAXID,
    
    channel_10 = CHANNEL_AP2M0_MAXID,	//AMT
    channel_11,				    	//LOG
    channel_12,                     //FOTA
    channel_13,
    channel_14,
    
    channel_15,
    channel_16,
    channel_17,
    channel_18,
    channel_19,
    
    channel_20,
    channel_21,
    channel_22,
    channel_23,
    channel_24,

    channel_25,
    channel_26,
    channel_27,
    channel_28,
    channel_29,
    
    channel_30,
    channel_31,
    channel_32,
    channel_33,
    channel_34,
    
    channel_35,
    channel_36,
    channel_37,
    channel_38,
    channel_39,

    channel_40,
    channel_41,
    channel_42,
    channel_43,
    channel_44,

    channel_45,
    channel_46,
    channel_47,
    channel_48,
    channel_49,

    channel_50,
    channel_51,
    channel_52,
    channel_53,
    channel_54,

    channel_55,
    channel_56,
    channel_57,
    channel_58,
    channel_59,

    channel_60,
    channel_61,
    channel_62,
    channel_63,	
      
    CHANNEL_AP2PS_MAXID
}T_ZDrvRpMsg_ChID;


struct zx29_rpmsg_platform_data 
{
  	unsigned int iram_send_base;
  	unsigned int iram_send_size;
  	unsigned int iram_recv_base;
  	unsigned int iram_recv_size;
  	unsigned int ddr_send_base;
  	unsigned int ddr_send_size;
  	unsigned int ddr_recv_base;
  	unsigned int ddr_recv_size;	
  	unsigned int max_channel_cnt;
};

typedef struct _T_HalRpMsg_MsgHeader
{
    unsigned short flag;
    unsigned short len;
}T_HalRpMsg_MsgHeader;

typedef struct _T_HalRpMsg_RpMsg
{
    T_HalRpMsg_MsgHeader MsgHeader;
    void *data;
} T_HalRpMsg_RpMsg;

typedef struct _T_HalRpMsg_ChInfo
{
    unsigned int Base_Addr;
    unsigned int SendPos;
    unsigned int RecvPos;
    unsigned int size;
    unsigned int flag;
    unsigned int EndAddr;
}T_HalRpMsg_ChInfo;

typedef enum _T_HalRpMsg_ChRam
{
	CH_IRAM,
	CH_DDR
}T_HalRpMsg_ChRam;

typedef struct _T_HalRpMsg_ChConfig
{
  	T_HalRpMsg_ChInfo 	*ChInfo_Send_Base;
  	T_HalRpMsg_ChInfo 	*ChInfo_Recv_Base;
	unsigned int 		CurIramAddr;
	unsigned int 		CurIramSpace_Size;
	unsigned int 		CurDdrAddr;
	unsigned int 		CurDdrSpace_Size;
	T_HalRpMsg_ChRam 	*ChConfig;
}T_HalRpMsg_ChConfig;

typedef struct _icp_operations{
	void (*Icp_SetInt)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	void (*Icp_ClearInt)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	T_HalIcp_Dword (*Icp_GetInt)(T_ZDrvRpMsg_ActorID actorID);
	int (*Icp_GetIntState)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	void (*Icp_Mask)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
	void (*Icp_UnMask)(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
}icp_operations;

typedef struct _Icp_rpmsg_drv {
	char				*name;
	T_ZDrvRpMsg_ActorID actorID;	
	unsigned int		channel_cnt;
	struct device		dev;
	
  	T_HalRpMsg_ChConfig Channel_config;
}Icp_rpmsg_drv;

typedef struct _T_ZDrvRpMsg_Msg
{
    T_ZDrvRpMsg_ActorID actorID;
    T_ZDrvRpMsg_ChID    chID;
    unsigned int 		flag;
    void  				*buf;
    unsigned int 		len;
} T_ZDrvRpMsg_Msg;

typedef enum _T_ZDrvRpMsg_ErrCode
{
    RPMSG_SUCCESS = 0,
    RPMSG_INT_NOCLEAR = 2,
    RPMSG_ERROR = -1,
    RPMSG_INVALID_PARAMETER = -101,
    RPMSG_SPACE_NOT_ENOUGH = -102,
    RPMSG_CHANNEL_ALREADY_EXIST = -103,
    RPMSG_CHANNEL_INEXISTANCE = -104,
    RPMSG_CHANNEL_MSG_ERR = -105,
    RPMSG_CHANNEL_ERROR = -107,
    RPMSG_NO_MSG = -108,
}T_ZDrvRpMsg_ErrCode;

void rpmsg_set_ops(const icp_operations *ops);
int icp_rpmsg_register(struct platform_device *pdev, void *hw_data);
int icp_rpmsg_unregister(struct platform_device *pdev);
int icp_rpmsg_device_register(Icp_rpmsg_drv *icp_rpmsg);

int icp_rpmsg_setchIntflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag);
int icp_rpmsg_setchpollflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int flag);
unsigned int icp_rpmsg_getchflag(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);

void rpmsg_sram_init(void);
void rpmsg_printk(const char *fmt, ...);

typedef void (*T_ZDrvRpMsg_CallbackFunction)(void *buf, unsigned int len);

#define rpmsg_log(fmt, args...)      	\
{	\
	rpmsg_printk("[RPMSG] " fmt, ##args);	\
}

/*******************************************************************************
* Function: zDrvRpMsg_CreateChannel
* Description: This function is used for creating channel to send message;
* Parameters:
*   Input:
*       actorID:remote cpu
*       chID: ID of channel
*       size: size of channel
*   Output:None
*
* Returns:
*   RPMSG_SUCCESS: successfully.
*   RPMSG_INVALID_PARAMETER:parameter is invalid.
*   RPMSG_CHANNEL_ALREADY_EXIST: channel already exist.
*   RPMSG_SPACE_NOT_ENOUGH: space of iram is not enough.
*   RPMSG_ERROR:error
*
* Others:  
********************************************************************************/
#ifdef CONFIG_SYSTEM_RECOVERY
static int zDrvRpMsg_CreateChannel (T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size){return 0;}
#else
extern int zDrvRpMsg_CreateChannel (T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size);
int zDrvRpMsg_CreateChannel_Cap (T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID, unsigned int size);
#endif

/*******************************************************************************
* Function: zDrvRpMsg_Write
* Description: This function is used for writing message;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_SPACE_NOT_ENOUGH: There is no enough space
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
#ifdef CONFIG_SYSTEM_RECOVERY
static int zDrvRpMsg_Write(const T_ZDrvRpMsg_Msg *pMsg){return 0;}
#else
extern int zDrvRpMsg_Write(const T_ZDrvRpMsg_Msg *pMsg);
int zDrvRpMsg_Write_Cap(const T_ZDrvRpMsg_Msg *pMsg);
#endif

/*******************************************************************************
* Function: zDrvRpMsg_WriteLockIrq
* Description: This function is used for writing message and disable irq;
* Parameters:
*   Input:
*       pMsg:message which will be writed      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be written
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_SPACE_NOT_ENOUGH: There is no enough space
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_Read
* Description: This function is used for reading message;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_NO_MSG: There is no message
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_Read(const T_ZDrvRpMsg_Msg *pMsg);
int zDrvRpMsg_Read_Cap(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_ReadLockIrq
* Description: This function is used for reading message and disable irq;
* Parameters:
*   Input:
*       pMsg:message which will be read      
*   Output:
*       pMsg
*
* Returns:
*   size:the length of data to be read
*   RPMSG_ERROR:error
*   RPMSG_INVALID_PARAMETER:parameter is invalid
*   RPMSG_CHANNEL_INEXISTANCE:channel not exist
*   RPMSG_NO_MSG: There is no message
*   RPMSG_CHANNEL_ERROR:channel is error
*
* Others:
********************************************************************************/
extern int zDrvRpMsg_ReadLockIrq(const T_ZDrvRpMsg_Msg *pMsg);

/*******************************************************************************
* Function: zDrvRpMsg_RegCallBack
* Description: This function is used for register callback fuction of icp interrupt;
* Parameters:
*   Input:
           actorID: id of remote cpu
           chID: id of channel
*   Output:None
*
* Returns:
*      RPMSG_INVALID_PARAMETER:parameter is invalid
*	   RPMSG_SUCCESS:success
*
* Others:
********************************************************************************/
#ifdef CONFIG_SYSTEM_RECOVERY
static int zDrvRpMsg_RegCallBack(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback){return 0;}
#else
extern int zDrvRpMsg_RegCallBack(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback);
int zDrvRpMsg_RegCallBack_Cap(T_ZDrvRpMsg_ActorID actorID, unsigned int chID, T_ZDrvRpMsg_CallbackFunction callback);
#endif

/*******************************************************************************
* Function: zDrvRpMsg_GetDataSize
* Description: This function is used to get datasize of channel ;
* Parameters:
*   Input:     
*   Output:
*
* Returns:
*     RPMSG_INVALID_PARAMETER:parameter is invalid
*     RPMSG_ERROR:error
*     size: size of data
*
* Others:
********************************************************************************/
int zDrvRpMsg_RecvCh_GetDataSize(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);

#endif


