
#ifndef RPMSG_H
#define RPMSG_H

#include <linux/device.h>
#include <linux/mm.h>
#include <linux/types.h>
#include <linux/major.h>
#include <linux/uaccess.h>
#include <linux/device.h>
	 
#include <linux/cdev.h>
#include <linux/workqueue.h>
	 
#include <linux/fs.h>
#include <mach/debug.h>
#include <linux/platform_device.h>

/***********************************************************************************
 ***   we have 4 cores at most,  AP/M0/PS/PHY    ***********************************
 ***********************************************************************************
 */

#define TRUE 								1
#define FALSE 								0

#define CHANNEL_NUM 		10//CHANNEL_MAXID		//37 from voLte 

typedef void (*RpMsg_CallbackFunction)(void *buf, unsigned int len);

typedef enum _T_ZDrvRpMsg_ChID
{
    CHANNEL_BASEID,

    channel_0 = CHANNEL_BASEID,    	//driver     just for AP<->PS
    channel_1,             		   	//PSM
    channel_2,					  	//USB_DETCT
    channel_3,					  	//USB_ADB
    channel_4,					 	//WAN
    
    channel_5,					 	//LAN1
    channel_6,					 	//LAN2
    channel_7,						//DEV_BUFMALLOC
    channel_8,						//DEV_BUFFREE
    channel_9,						//AT

    CHANNEL_AP2M0_MAXID,
    
    channel_10 = CHANNEL_AP2M0_MAXID,	//AMT
    channel_11,				    	//LOG
    channel_12,                     //FOTA
    channel_13,
    channel_14,
    
    channel_15,
    channel_16,
    channel_17,
    channel_18,
    channel_19,
    
    channel_20,
    channel_21,
    channel_22,
    channel_23,
    channel_24,

    channel_25,
    channel_26,
    channel_27,
    channel_28,
    channel_29,
    
    channel_30,
    channel_31,
    channel_32,
    channel_33,
    channel_34,
    
    channel_35,
    channel_36,
    channel_37,
    channel_38,
    channel_39,

    channel_40,
    channel_41,
    channel_42,
    channel_43,
    channel_44,

    channel_45,
    channel_46,
    channel_47,
    channel_48,
    channel_49,

    channel_50,
    channel_51,
    channel_52,
    channel_53,
    channel_54,

    channel_55,
    channel_56,
    channel_57,
    channel_58,
    channel_59,

    channel_60,
    channel_61,
    channel_62,
    channel_63,	
      
    CHANNEL_AP2PS_MAXID
}T_ZDrvRpMsg_ChID;
#if 0
typedef struct _T_ZDrvRpMsg_Msg
{
    T_ZDrvRpMsg_ChID    chID;
    //unsigned int 		flag;
    void  				*buf;
    unsigned int 		len;
} T_ZDrvRpMsg_Msg;
#endif 
typedef enum _T_ZDrvRpMsg_ErrCode
{
    RPMSG_SUCCESS = 0,
    RPMSG_INT_NOCLEAR = 2,
    RPMSG_ERROR = -1,
    RPMSG_INVALID_PARAMETER = -101,
    RPMSG_SPACE_NOT_ENOUGH = -102,
    RPMSG_CHANNEL_ALREADY_EXIST = -103,
    RPMSG_CHANNEL_INEXISTANCE = -104,
    RPMSG_CHANNEL_MSG_ERR = -105,
    RPMSG_CHANNEL_ERROR = -107,
    RPMSG_NO_MSG = -108,
}T_ZDrvRpMsg_ErrCode;

struct RpMsg_packet {
	struct list_head list;
	T_ZDrvRpMsg_ChID    chID;
    void  				*buf;
    unsigned int 		len;
	//T_ZDrvRpMsg_Msg *msg;
};
struct RpMsg_queue {
    struct list_head queue;
    int qlen;
    struct spinlock lock;
};
typedef int (*functpye1)(unsigned int);
typedef int (*functpye2)(unsigned int, void*, unsigned int);
typedef struct _zx29_rpmsg_channel 
{
	//T_ZDrvRpMsg_ActorID actorID;
	T_ZDrvRpMsg_ChID 	chID;
	//void *				buf;
	unsigned int 		initflag;
	//struct semaphore 	channelSema;
	wait_queue_head_t 	channelwaitq;
	struct RpMsg_queue RpMsg_packet_queue;
	void (*channelOpen)(unsigned int chid);
	void (*channelClose)(unsigned int chid);
	//int (*transdatatoRpmsg)(unsigned int channel, void* buff, unsigned int length);
	int (*transdataOut)(unsigned int channel, void* buff, unsigned int length);
}zx29_rpmsg_channel;
 
typedef struct _zx29_rpmsg_ser 
{
	struct kref 	kref;   /* Reference management */
	struct cdev 	cdev;
	struct module 	*owner;
	const char  	*driver_name;
	const char  	*name;
	int name_base;  
	int major;	  
	int minor_start;    
	int num; 		   
	int flags;	   
	int	index;
	int count;
	zx29_rpmsg_channel rpmsg_channel[CHANNEL_NUM];

	const struct file_operations *ops;
}zx29_rpmsg_ser; 

void rpmsg_sram_init(void);
void rpmsg_printk(const char *fmt, ...);

//typedef void (*T_ZDrvRpMsg_CallbackFunction)(void *buf, unsigned int len);

#define rpmsg_log(fmt, args...)      	\
{	\
	rpmsg_printk("[RPMSG] " fmt, ##args);	\
}
void rpmsg_recv_notify(unsigned int chID, const void *buffer, unsigned int length);
//int registerOpsCallback(unsigned int chID, functpye1* funcOpen, functpye1* funcClose, functpye2* funcIn, functpye2* funcOut);
int registerOpsCallback(unsigned int chID, functpye1* funcOpen, functpye1* funcClose, functpye2* funcOut);
int isRecvChannelEmpty(T_ZDrvRpMsg_ChID chID);
void rpmsg_enqueue(struct RpMsg_queue *packetqueue, struct list_head* plist);
struct RpMsg_packet* rpmsg_dequeue(struct RpMsg_queue *packetqueue);


#endif


