/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    uicc_agt_server.h
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       V1.0
 * Author:        yanhaijian
 * Date:          2016-8-25
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
********************************************************************************/
#ifndef _UICC_AGT_SERVER_H
#define _UICC_AGT_SERVER_H
/****************************************************************************
*                                              Include files
****************************************************************************/

/****************************************************************************
* 	                                           server Macros
****************************************************************************/
#define RPMSG_READ_POLL		(0x1<<1)
#define RPMSG_WRITE_INT		(0x1)      
#define bufLen				300
#define	UICC_APDU_LEN		256
#define	UICC_ATR_LEN		32
#define NETLINK_TEST 		30  
#define MAX_MSG_LEN 		1024  
#define RP_MSG_UICC_VSIMAGT_CHANNEL		0  //vsim ͨ
/****************************************************************************
* 	                                           server Types
****************************************************************************/
struct vsimmsg{  
    unsigned short type;               /* Ϣ */  
    unsigned short len;                /* Ϣȣͷ */  
    unsigned char msg[MAX_MSG_LEN];  /* Ϣ */  
}; 

enum{
	MSG_CMD_USIM_DETECT = 0,
	MSG_CMD_USIM_RESET,
	MSG_CMD_USIM_GETATR,
	MSG_CMD_USIM_APDU,
	MSG_CMD_USIM_CLOSE,
	MSG_CMD_SETPID, 	
	MSG_CMD_MAX,     
};

typedef enum
{
	VSIM_REMOVE,
	VSIM_INSERT
} T_UICC_DETECT;

typedef enum {
	VSIM_PRIMARY_CARD,
	VSIM_SECONDARY_CARD_1,
	VSIM_SECONDARY_CARD_2
} T_VSIM_CARD_SELECTOR;

typedef enum
{
	DRV_VSIM_CMD_CASE_1,    
	DRV_VSIM_CMD_CASE_2,     
	DRV_VSIM_CMD_CASE_3,    
	DRV_VSIM_CMD_CASE_4     
} T_VSIM_COMMANDCASE;

typedef struct
{
	unsigned char  cla;  /*!< Command CLAss.       */
	unsigned char  ins;  /*!< Command INStruction. */
	unsigned char  p1;   /*!< Command Parameter.   */
	unsigned char  p2;   /*!< Command Parameter.   */
	unsigned short lc;   /*!< Tx-size. */
	unsigned short le;   /*!< Rx-Size. */
} t_uicc_apduheader;

typedef struct
{
	unsigned short luicc; /*!< Actual Rx-size recived. */
	unsigned char  sw1;   /*!< Received Status Word SW1. */
	unsigned char  sw2;   /*!< Received Status Word SW2. */
} t_uicc_apdufooter;

/**
 * \enum T_ZDrvUicc_ResetResult
 * Response cause for function \ref UICC_reset.
 */
 
typedef enum
{
	DRV_VSIM_ACTIVATION_SUCCEEDED,
	DRV_VSIM_ACTIVATION_FAILED,
	DRV_VSIM_REJECT_CARD
} T_VSIM_RESETRESULT;

typedef enum
{
	DRV_VSIM_DEACTIVATION_SUCCEEDED,
	DRV_VSIM_DEACTIVATION_FAILED,
	DRV_VSIM_ALREADY_DEACTIVATED
} T_VSIM_CLOSERESULT;

typedef enum
{
  DRV_VSIM_TRANSFER_SUCCEEDED,
  DRV_VSIM_TRANSFER_FAILED
} T_VSIM_APDURESELT;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char    card_selector;
	/**T_ZDrvUicc_CommandCase**/unsigned char  command_case;
	unsigned char                    extended_length;
	t_uicc_apduheader   c_apdu;
	unsigned char                   data_req[UICC_APDU_LEN];
} T_UICC_TRANSPORT_APDU_REQ_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char    card_selector;
	/**T_ZDrvUicc_ApduReselt**/unsigned char		func_resp;
	t_uicc_apdufooter   r_apdu_ptr;
	unsigned char                   data_rsp[UICC_APDU_LEN];
} T_UICC_TRANSPORT_APDU_RSP_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char    card_selector;
} T_UICC_RESET_REQ_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char    card_selector;
	/**T_ZDrvUicc_ResetResult**/unsigned char  	func_resp;
} T_UICC_RESET_RSP_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char    card_selector;
} T_UICC_ATR_REQ_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned short   card_selector;
	unsigned char					func_resp;
	char                   atr_data[UICC_ATR_LEN];
} T_UICC_ATR_RSP_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char    card_selector;
} T_UICC_CLOSE_REQ_MSG;

typedef struct{
	/**T_UICC_CARD_SELECTOR**/unsigned char   card_selector;
	/**T_ZDrvUicc_CloseResult	**/unsigned char	func_resp;
} T_UICC_CLOSE_RSP_MSG;

typedef struct {
    unsigned short usMsgCmd;               /* Ϣ */  
    unsigned short usDataLen;                /* Ϣȣͷ */  
    unsigned char aucDataBuf[MAX_MSG_LEN];  /* Ϣ */  
} VSIM_MSG_BUF;

/****************************************************************************
* 	                                           Global Types
****************************************************************************/

/****************************************************************************
* 	                                           Function
****************************************************************************/
T_VSIM_APDURESELT Vsim_TransportApdu(T_VSIM_CARD_SELECTOR card_selector,
                      T_VSIM_COMMANDCASE command_case,
                      int                 extended_length,
                      t_uicc_apduheader    c_apdu,
                      t_uicc_apdufooter     *r_apdu_ptr,
                      unsigned char             *apdu_data_ptr);

T_VSIM_RESETRESULT Vsim_ResetCard(T_VSIM_CARD_SELECTOR card_selector);
T_VSIM_CLOSERESULT Vsim_Close(T_VSIM_CARD_SELECTOR card_selector);
unsigned char Vsim_GetAtr(T_VSIM_CARD_SELECTOR card_selector, unsigned char *atr);
void vsim_Hisr(int arg);

#endif

