#ifndef _NET_OTHER_H_
#define _NET_OTHER_H_

/*DHCP option*/
#define DHCP_PADDING            0x00
#define DHCP_MSG_TYPE           0x35
#define DHCP_END                0xff

/*DHCP˿*/
#define DHCP_SERVER_PORT   67
#define DHCP_CLIENT_PORT   68

/*ڼָ͵İ*/
enum skb_queue_type
{
    /*ping*/
    PKT_TYPE_PING_BIT = 0,
    PKT_TYPE_PING = (1 << PKT_TYPE_PING_BIT),

    /*DHCP*/
    PKT_TYPE_DHCP_BIT = 1,
    PKT_TYPE_DHCP = (1 << PKT_TYPE_DHCP_BIT),

    /*ARP*/
    PKT_TYPE_ARP_BIT = 2,
    PKT_TYPE_ARP = (1 << PKT_TYPE_ARP_BIT),
};

static char *proto_str[] = 
{
    "ping",
    "dhcp",
    "arp"
};

/*ָЭ*/
enum
{
    PROTO_TYPE_PING = 0,
    PROTO_TYPE_DHCP,
    PROTO_TYPE_ARP,
    PROTO_TYPE_END,
};

struct pkt_info
{
    unsigned short proto_type;   /*Э*/
    unsigned short msg_type;     /*ЭӦϢ*/
    unsigned long  time;         
};

#define MAX_PKT_NUM   10
struct check_pkt_info
{
    int pkt_num;
    struct pkt_info info[MAX_PKT_NUM];
};


#define MAX_IPADDR_LEN          16
#define MAX_MACADDR_LEN 		14
struct neigh_info
{
    unsigned int ip_len;          //IPַȣV4V6
    unsigned char ip_addr[MAX_IPADDR_LEN];
    unsigned char mac_addr[MAX_MACADDR_LEN];
};

#define MAX_NEIGH_NUM           20
struct dev_neigh_info
{
    unsigned int num;
    struct neigh_info neigh_nod[MAX_NEIGH_NUM];
};

enum dev_layer{
	L3_DEV=0,    //3豸
	BR_DEV,  //ŵL3豸
	L2_DEV,     //L2豸
};

enum IFMAC_ERR{
	ZERO_ADDRERR=1,   
	MULTICAST_ADDRERR,     
    BROADCAST_ADDRERR,
};

/*ڵĵַھбշͳƵϢ*/
struct dev_and_neigh
{
	char name[20];
	unsigned char  dev_layer;   //ָʾñڵЭ㣬μֵL3_DEV
    /*MACַ,IPv4ַ*/
	unsigned char		mac_addr[20];  //ڵַ
	unsigned int		ipv4_addr;        //IPַ
	struct dev_neigh_info  dev_neigh;  //ñЯԶھӵַϢ
	int mac_errtype;
};
#define MAX_DEV_NUM   30
/*صϢ*/
struct devlist_info
{
	unsigned int num;        //Чڵĸ
	struct dev_and_neigh info[MAX_DEV_NUM];  //ЧڵľϢ
};

extern struct list_head ptype_base[] ;
extern struct list_head ptype_all;	/* Taps */
extern int addr_check;

extern unsigned long skb_max_panic ; //skbޣᵼpanic
extern int skb_num_limit ;  //skbޣᵼpanic
extern char netioctl_cmpstr[] ;
extern unsigned int netioctl_cmplen ;

extern unsigned long check_pkt;              /*ڼָ͵İͣοcheck_pkt_type*/
extern int set_print_pkt;      /*ӡݿ*/

extern struct check_pkt_info skb_insert_info;
extern struct check_pkt_info skb_unlink_info;

extern void print_check_pkt_info(struct check_pkt_info *pkt_info, int num);

extern int check_packet_type(struct sk_buff *skb, struct pkt_info *pkt_info);

extern void net_print_packet(unsigned char *data, unsigned int len, int flag);  /*flagڱsendrecv, 0:recv, 1:send*/


extern void check_macaddr_only(unsigned char *ha, unsigned char ha_len);
extern void dump_net_stack(struct sk_buff *skb, unsigned int offset);
extern void tcpdumpin_sq(struct sk_buff *skb);
extern void tcpdumpout_sq(struct sk_buff *skb);
extern int get_devlist_info(unsigned long arg);
extern struct net_device *getbrport_bydst(struct net_device *dev,unsigned char *dest);
extern void skb_alloc_track(struct sk_buff *skb);
extern void skb_free_track(struct sk_buff *skb);
extern void skbdata_alloc_track(struct sk_buff *skb);
extern void skbdata_free_track(struct sk_buff *skb);
extern void fromext_alloc_track(struct sk_buff *skb);
extern void fromext_free_track(struct sk_buff *skb);
extern void toext_alloc_track(struct sk_buff *skb);
extern void toext_free_track(struct sk_buff *skb);

#endif


