/**
 * @file voice_api.c
 * @brief Implementation of the public APIs of libvoice.
 *
 * Copyright (C) 2023 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. ѡGPLv2 Licence
 *
 */



#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <stdint.h>
//#include "volte_drv.h"
#include <linux/volte_drv.h>

#include <sys/ioctl.h>
#include <fcntl.h>
#include <tinyalsa/audio_mixer_ctrl.h>
#include "voice_lib.h"

#define VOCIE_SND_CARD_NUM 0


extern int mix_set_voice_vol(struct mixer *mixer, int volume);
extern int mix_get_voice_vol(struct mixer *mixer, int *volume);
extern int mix_set_tx_voice_vol(struct mixer *mixer, int volume);
extern int mix_get_tx_voice_vol(struct mixer *mixer, int *volume);
extern int mix_set_voice_mute(struct mixer *mixer, bool enable);
extern int mix_get_voice_mute(struct mixer *mixer, int *enable);
extern int mix_set_rx_voice_mute(struct mixer *mixer, bool enable);
extern int mix_get_rx_voice_mute(struct mixer *mixer, int *enable);
extern int mix_set_voice_path(struct mixer *mixer, int path);
extern int mix_set_vp_path(struct mixer *mixer, char path);
extern int mix_get_vp_path(struct mixer *mixer, int *path);
extern int mix_get_voice_path(struct mixer *mixer, int *path);
extern int mix_set_vploop(struct mixer *mixer, int path);
extern int mix_get_vploop(struct mixer *mixer, int *state);
extern int mix_set_voice_vol_gain(struct mixer *mixer, int vol_gain);
extern int mix_get_voice_vol_gain(struct mixer *mixer, int *vol_gain);
extern int mix_set_tx_voice_vol_gain(struct mixer *mixer, int vol_gain);
extern int mix_get_tx_voice_vol_gain(struct mixer *mixer, int *vol_gain);

	
#define VOCIE_SND_CARD_NUM 0
	
	
	
//设置voice音频设备模式 dev_mode：handset,speaker,headset	0 表示成功?其它表示有错?
int set_voice_device_mode(int dev_mode)
{

	struct mixer *voice_mixer = NULL;
	printf("%s: start dev_mode=%d!\n",__func__, dev_mode);

	if ((dev_mode < T_OUTPUT_HANDSET ) ||(dev_mode >= T_OUTPUT_MAX)){
		printf("%s: dev_mode not support, dev_mode=%d!\n",__func__, dev_mode);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_voice_path(voice_mixer, dev_mode);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;
	
	
}



int sc_audio_set_voice_device_mode(int dev_mode)
{

	struct mixer *voice_mixer = NULL;
	printf("%s: start dev_mode=%d!\n",__func__, dev_mode);

	if ((dev_mode < T_OUTPUT_HANDSET ) ||(dev_mode >= T_OUTPUT_MAX)){
		printf("%s: dev_mode not support, dev_mode=%d!\n",__func__, dev_mode);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}
#ifdef _ALSA_CODEC_IN_CAP
	mix_set_vp_path(voice_mixer,dev_mode);

#else
	//config mixer dev
	mix_set_voice_path(voice_mixer, dev_mode);
#endif


	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;
	
	
}


int sc_audio_get_voice_device_mode(int *p_dev_mode)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;
	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_vp_path(voice_mixer, p_dev_mode);

	
	if((*p_dev_mode < T_OUTPUT_HANDSET ) ||(*p_dev_mode >= T_OUTPUT_MAX)){
		printf("%s: dev_mode not support, *p_dev_mode=%d!\n",__func__, *p_dev_mode);
		ret = -1;
	}
	printf("%s: start *p_dev_mode=%d!\n",__func__, *p_dev_mode);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;

	return ret;
	
}


int sc_audio_set_rx_voice_vol(int vol)
{
	struct mixer *voice_mixer = NULL;
	printf("%s: start vol=%d!\n",__func__, vol);

	if ((vol < 0 ) ||(vol > 11)){
		printf("%s: vol not support, vol=%d!\n",__func__, vol);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_voice_vol(voice_mixer, vol);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;


	
	
}



int sc_audio_get_rx_voice_vol(int     * p_vol)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;

	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_voice_vol(voice_mixer, p_vol);
	

	if ((*p_vol < 0 ) ||(*p_vol > 11)){
		printf("%s: vol not support, *p_vol=%d!\n",__func__, *p_vol);
		ret = -1;
	}
	printf("%s:  *p_vol=%d!\n",__func__, *p_vol);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return ret;

	
	
}

int sc_audio_set_rx_voice_vol_gain(int gain)
{
	struct mixer *voice_mixer = NULL;
	printf("%s: start vol=%d!\n",__func__, gain);

	if ((gain < -15 ) ||(gain > 24)){
		printf("%s: gain not support, gain=%d!\n",__func__, gain);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_voice_vol_gain(voice_mixer, gain);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;


	
	
}

int sc_audio_get_rx_voice_vol_gain(int     * p_gain)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;

	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_voice_vol_gain(voice_mixer, p_gain);
	

	if ((*p_gain < -15 ) ||(*p_gain > 24)){
		printf("%s: gain not support, *p_gain=%d!\n",__func__, *p_gain);
		ret = -1;
	}
	printf("%s:  *p_gain=%d!\n",__func__, *p_gain);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return ret;

	
	
}

int sc_audio_set_tx_voice_vol_gain(int gain)
{
	struct mixer *voice_mixer = NULL;
	printf("%s: start vol=%d!\n",__func__, gain);

	if ((gain < -15 ) ||(gain > 24)){
		printf("%s: gain not support, gain=%d!\n",__func__, gain);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_tx_voice_vol_gain(voice_mixer, gain);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;


	
	
}

int sc_audio_get_tx_voice_vol_gain(int     * p_gain)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;

	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_tx_voice_vol_gain(voice_mixer, p_gain);
	

	if ((*p_gain < -15 ) ||(*p_gain > 24)){
		printf("%s: gain not support, *p_gain=%d!\n",__func__, *p_gain);
		ret = -1;
	}
	printf("%s:  *p_gain=%d!\n",__func__, *p_gain);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return ret;

	
	
}

int sc_audio_set_tx_voice_vol(int vol)
{
	struct mixer *voice_mixer = NULL;
	printf("%s: start vol=%d!\n",__func__, vol);

	if ((vol < 0 ) ||(vol > 11)){
		printf("%s: vol not support, vol=%d!\n",__func__, vol);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_tx_voice_vol(voice_mixer, vol);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;


	return 0;
	
	
}



int sc_audio_get_tx_voice_vol(int  *p_vol)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;
	printf("%s: start!\n",__func__);


	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_tx_voice_vol(voice_mixer, p_vol);
	

	if((*p_vol < 0 ) ||(*p_vol > 5)){
		printf("%s: vol not support, *p_vol=%d!\n",__func__, *p_vol);
		ret = -1;
	}
	printf("%s:  *p_vol=%d!\n",__func__, *p_vol);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;	
    return ret;	
}



int sc_audio_set_tx_voice_mute_state(int mute         )
{
	struct mixer *voice_mixer = NULL;
	printf("%s: start mute=%d!\n",__func__, mute);

	if((mute != 0 ) &&(mute != 1)) {
		printf("%s: mute not support, mute=%d!\n",__func__, mute);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_voice_mute(voice_mixer, mute);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;
    return 0;	
	
}

int sc_audio_get_tx_voice_mute_state(int *p_mute)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;

	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_voice_mute(voice_mixer, p_mute);
	

	if((*p_mute != 0 ) &&(*p_mute != 1)) {
		printf("%s: *p_mute not support, *p_mute=%d!\n",__func__, *p_mute);
			
		ret = -1;
	}
	printf("%s:  *p_mute=%d!\n",__func__, *p_mute);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;	

    return ret;
}







int sc_audio_set_rx_voice_mute_state(int mute) 
{
	struct mixer *voice_mixer = NULL;
	printf("%s: start mute=%d!\n",__func__, mute);

	if((mute != 0 ) &&(mute != 1)) {
		printf("%s: mute not support, mute=%d!\n",__func__, mute);
		return -1;
	}

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_set_rx_voice_mute(voice_mixer, mute);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;
    return 0;	
	
}


int sc_audio_get_rx_voice_mute_state(int *p_mute)
{
    int ret = 0;
	struct mixer *voice_mixer = NULL;

	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	mix_get_rx_voice_mute(voice_mixer, p_mute);
	
	if((*p_mute != 0 ) &&(*p_mute != 1)) {

		printf("%s: *p_mute not support, *p_mute=%d!\n",__func__, *p_mute);
		ret = -1;
	}
	printf("%s:  *p_mute=%d!\n",__func__, *p_mute);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;	

    return ret;

}

int sc_audio_set_loopback_enable_state(int enable)
{
    return 0;
}

int sc_audio_get_loopback_enable_state(int *p_enable)
{
    return 0;
}

int ap_audio_set_loopback_enable(int dev_mode,int enable)
{

	struct mixer *voice_mixer = NULL;
    int ret = 0;
    struct pcm_config config_voice = {0};

	
	printf("%s: start dev_mode=%d,enable=%d!\n",__func__, dev_mode,enable);

	if ((dev_mode < T_OUTPUT_HANDSET ) ||(dev_mode >= T_OUTPUT_MAX)){
		printf("%s: dev_mode not support, dev_mode=%d!\n",__func__, dev_mode);
		return -1;
	}
	if ((enable != 0 )&&(enable != 1)){
		printf("%s: enable val not support, enable=%d!\n",__func__, enable);
		return -1;
	}
	if(enable == 1){

		//open mixer dev for  control
		voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
		if (!voice_mixer) {
			printf("voice_mixer open failed!\n");
			return -1;
		}

		//config mixer dev
		ret = mix_set_voice_path(voice_mixer, dev_mode);
		printf("mix_set_voice_path ret=%d!\n",ret);
		
		ret = mix_set_vploop(voice_mixer, dev_mode);
		printf("mix_set_vploop ret=%d!\n",ret);

		//close mixer
		mixer_close(voice_mixer);
		voice_mixer = NULL;

		



		
	}
	else{

		//open mixer dev for  control
		voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
		if (!voice_mixer) {
			printf("voice_mixer open failed!\n");
			return -1;
		}


	    ret = mix_set_vploop(voice_mixer, VP_PATH_OFF);
		//close mixer
		mixer_close(voice_mixer);
		voice_mixer = NULL;

		
		printf("mix_set_vploop off end ret=%d!\n",ret);
		
		
	


	}
 
	//return 0;

	printf("%s: end enable=%d!\n",__func__, enable);

	return ret;
	
	
}



int ap_audio_get_loopback_enable(int *p_enable)
{
	struct mixer *voice_mixer = NULL;
	int ret = 0;
	printf("%s: start!\n",__func__);

	//open mixer dev for  control
	voice_mixer = mixer_open(VOCIE_SND_CARD_NUM);
	if (!voice_mixer) {
		printf("voice_mixer open failed!\n");
		return -1;
	}

	//config mixer dev
	ret = mix_get_vploop(voice_mixer, p_enable);
	if((*p_enable != 0 ) &&(*p_enable != 1)){
		printf("%s: p_enable not support, *p_enable=%d!\n",__func__, *p_enable);
		ret = -1;
	}
	printf("%s: end *p_enable=%d!\n",__func__, *p_enable);

	//close mixer
	mixer_close(voice_mixer);
	voice_mixer = NULL;

	return ret;
	
}


