/**
* @file netotherapi.h
* @brief Public APIs of Sanechips , linux network external interface
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author  Linxu Gebin
* @defgroup si_id Sanechips
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*************************************************************************
*/

#ifndef __NETOTHERAPI_H__
#define __NETOTHERAPI_H__
#include "zxic_list.h"

#ifndef DOXYGEN_SHOULD_SKIP_THIS

/*******************************************************************************
 *                             Macro definitions                               *
******************************************************************************/

#define WAKE_LOCK_PATH                  "/sys/power/wake_lock"
#define WAKE_UNLOCK_PATH                "/sys/power/wake_unlock"



#define PROC_IF_STATISTIC	"/proc/net/dev"
#define TXBYTE		0       //
#define TXPACKET	1
#define RXBYTE		2       //
#define RXPACKET	3
#define TXERR		4
#define TXDROP		5
#define RXERR		6
#define RXDROP		7

#define  PC_MAX_NUM  100
#define     DEV_NAME_LEN 50
#define TIMER_GETHOSTBYNAME_ID  62

#define safe_free(x) do { if(x) {free(x); x=NULL;} } while(0)

/* Used to retry syscalls that can return EINTR. */
#ifndef TEMP_FAILURE_RETRY
#define TEMP_FAILURE_RETRY(exp) ({           \
	typeof (exp) _rc;                        \
	do{                                      \
		_rc = (exp);                         \
	}while((_rc == -1) && (errno == EINTR)); \
	_rc; })
#endif

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

struct pc_info {
	unsigned char mac_addr[6];
	char  dev_name[DEV_NAME_LEN];
};
struct pc_node {
	unsigned int num;
	struct pc_info info[PC_MAX_NUM];
};


/**
* @brief Ϣ
* @param mac mac ַ
* @param ip ip ַ
* @param hostname 
* @param dev_name 豸
* @param time_remain ǰʱ䵽һ¸豸Ϣʱ
* @param time_last  һθʱ
* @note 
*/
typedef struct LAN_INFO {
	unsigned char mac[6];
	unsigned long ip;
	char host_name[32];
	char dev_name[32];
	unsigned long time_remain;
	unsigned long time_last;
} LAN_INFO_t;

/**
* @brief Ϣ
* @param list_head ͷڵ
* @param lan_info lϢ
* @note 
*/
typedef struct LAN_INFO_LIST {
	struct list_head  list;
	LAN_INFO_t  lan_info;
} LAN_INFO_LIST_t;

/**
* @brief dhcp server洢leaseļṹ
* @param expires expires
* @param ip ip ַ
* @param mac mac ַ
* @param host_name
* @param pad
*/
typedef struct _DHCPOFFERADDRNET {
	unsigned long expires;
	unsigned long ip;
	unsigned char mac[6];
	unsigned char host_name[20];
	unsigned char pad[2];
} DHCPOFFERADDRNET;

/**
* @brief dhcp Ϣ
* @param list ͷڵ
* @param dhcp_info dhcp Ϣ
*/
typedef struct _DHCPOFFERADDR_LIST {
	struct list_head  list;
	DHCPOFFERADDRNET  dhcp_info;
} DHCPOFFERADDR_LIST_t;
/**
* @brief dhcp gethostbynameϢ
* @param time ʱʱ䣬λΪ
* @param к
*/
struct gethostbyname_info{
	int time;
	char name[HOSTNAME_LEN];
	int msg_id;
};


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/

/**
* @brief dhcpd.leasesļлȡdhcpϢ
* @param dhcp_list_info dhcp Ϣ
* @return ɹ  0, ʧܷ-1
*/
int  zte_get_mac_list_from_lease(struct list_head *dhcp_list_info);

/**
* @brief 豸Ϣ
* @param mypc_node  豸Ϣ
* @param info	information
* @return ɹ  0, ʧܷ-1
*/
int get_dev_list(struct pc_node* mypc_node);

/**
* @brief Ϣļ
* @param filename ļ
* @param info ҪϢ
* @return 
*/
void save_file(char *filename, char* info);

/**
* @brief дϢļ
* @param filename ļ
* @param info ҪдϢ
* @return 
*/
void file_write(char *filename, char *info);

/**
* @brief  ͷdhcpϢ
* @param dhcp_info_list	dhcpͷ
* @return 
*/
void  free_dhcp_list(struct list_head * dhcp_info_list);

/**
* @brief  ͷϢ
* @param dhcp_info_list	Ϣͷ
* @return 
*/
void  free_laninfo_list(struct list_head * dhcp_info_list);

/**
* @brief ȡ豸Ϣ
* @param interface 豸
* @param type	
* @return  ɹ0ʧܷŻ-1
*/
int getIfStatistic(char *interface, int type, unsigned long long *result_data);

/**
 * @brief  ȡwakelock
 * @param lockId wakelockID
 * @return ɹ0ʧܷ-1
 */
int set_wake_lock(const char *lockId);

/**
 * @brief  ȡwakelockʱ
 * @param lockId wakelockID
 * @param interval ʱʱ䣬λ: 
 * @return ɹ0ʧܷ-1
 */
int set_wake_lock_timeout(const char *lockId, unsigned long interval);

/**
 * @brief  ͷwakelock
 * @param lockId wakelockID
 * @return ɹ0ʧܷ-1
 */
int set_wake_unlock(const char *lockId);


int get_lan_info_list(struct list_head *file_list_info);

/**
 * @brief  ڴ
 * @param size ڴС
 * @param is_assertʧǷassert
 * @return ɹڴַʧܷNULL
 */
void *safe_malloc(int size, BOOL is_assert);

unsigned long time_sec();


/**
* @brief  ȡָ߳pid
* @param pidNameΪ
* @return  ɹؽ̺pid_tָ
* @note øúȡֵʹúһҪͷŸڴռ
*/
pid_t* find_pid_by_name(char *pidName);

/**
* @brief гʱgethostbyname
* @param name url
* @param time ʱʱ,λ:, 0Ǳ׼gethostbyname
* @return hostϢ
* @Note: ͬһͬʱֻܵһθýӿ
*/
struct hostent *gethostbyname_t(const char *name, int time);

/**
* @ؼȡdnsӿڣ·ɣֵΪu32ipַ
*/
unsigned long gethostbyname_l(char *hostname,char* dev_name);

int gethostbyname6_l(char *hostname,char* dev_name, struct in6_addr* ip6);

#endif

#endif /* __NETOTHERAPI_H__ */
