/**
* @File: codec_res_main_ctrl.h
* @Brief: Implementation of Device Manager in Sanechips
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @Author: sun.quan@zte.com.cn
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
* */
#ifndef _AUDIO_RES_CTRL_
#define _AUDIO_RES_CTRL_
/*******************************************************************************
 *						    ͷļ   	          					       *
 ******************************************************************************/
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

/*******************************************************************************
 *                             궨                                         *
 ******************************************************************************/
//#define  MODULE_ID_CODEC 0 

/*******************************************************************************
 *                             Ͷ                                    *
 ******************************************************************************/

enum audio_type {
	VOICE_23G = 0,    
	VOICE_VOLTE,       
	POC,
	ZCORE,
};

enum  audio_msg_type {
	USE_AUDIO_REQ = 0,  //ҵģʹȨ
	USE_AUDIO_RSP,      //Ϣһָʾɹʧܣڶָʾǰʹõҵ
	REL_AUDIO_REQ,      //ĳҵģͷڽеAUDIOʹȨ
	REL_AUDIO_IND,      //ĳҵģͷaudioĽӦʧܣԣ֮ɹ
	IDLE_AUDIO_INFO,     //֪ͨAUDIOԴҵģ飬֪ǰУԽҵģ鴦ڹ̬֮ǰǿͷŵҵģ飬MP3ֲŵȣ
	EXIT_AUDIO_IND, //֪ͨأҵģ˳ƵԴ
	EXIT_AUDIO_REQ, //ҵģ˳ƵԴ
	EXIT_AUDIO_RSP, //Ӧҵģ˳ƵԴ
};


typedef struct {
	int	type;          //ָʾľҵ
	int moduleId;     //ģ
	int tempModuleId; 
} T_audio_UseReq;

typedef struct {
	int	result;       //ָʾĽ0ʾɹ1ʾʧ
	int	type;         //ָʾľҵ
	int	using_type;   //ָʾǰʹõҵͣʧʱҵģѯʹ
} T_audio_UseRsp;

typedef struct {
	int	using_type;  //ָʾǰĸȼҵģԴ
	int mouleId;     //ģid
} T_audio_RelReq;

typedef struct {
	int	result;      //ָʾĽ0ʾɹ1ʾʧ
	int	type;        //ָʾͷſȨҵ
	int moduleId;    //ͷſȨģid
} T_audio_RelInd;


/* ӦcodecԴ */
typedef struct audioResRequest
{
    int moduleId;           /* ҵģ */
    int tempMouduleId;       /* ԴĽϢʱId */
    int audioType;          /* ҵ */
}T_audio_Res_Request;

typedef struct {
	int	type;
	int moduleId;
} T_audio_ExitInd;


/**
 *˵ʹcodecԴȴcodecػظ         
 *@param :  ӦĲ
 *
 */
BOOL audio_resource_request(struct audioResRequest *param,  T_audio_UseRsp *RspData);
#endif
