/**
 * @file poc_msg.h
 * @brief POC̨MMIϢӿ
 *
 * Copyright (C) 2019 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
 
#ifndef __POC_MSG_H
#define __POC_MSG_H
/*******************************************************************************
*                           Include header files                              *
******************************************************************************/
/* Include "app/include/message.h". */
#include "message.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define POC_SVR_PRINT 0
#define SVRPOC "[PTT]"
#define POC_PRINT "[PTT]"
#if POC_SVR_PRINT
#define POC_SVR_LOG(format, ...) \
    do {  \
        slog(POC_PRINT,SLOG_NORMAL,format,##__VA_ARGS__ );\
    } while(0)

#define POC_SVR_LOG_ERR(format, ...) \
    do {  \
        slog(POC_PRINT,SLOG_ERR,format,##__VA_ARGS__ );\
    } while(0)
#else
#define POC_SVR_LOG(format, ...) \
	do { \
		printf(format,##__VA_ARGS__); \
	} while(0)

#define POC_SVR_LOG_ERR(format, ...) \
	do { \
		printf(format,##__VA_ARGS__); \
	} while(0)
#endif

/*Ƴ*/
#define SVRPOC_NAME_LENTH_MAX 32 
/*Ŀ*/
#define SVRPOC_GROUP_NUMBER_MAX 32 
/*ԱĿ*/
#define SVRPOC_MEMBERS_NUMBER_MAX 32 

/*ıϢ󳤶*/
#define SVRPOC_TEXT_INFO_MAX 256 

/*Ϣ*/
#define SVRPOC_BASE MSG_CMD_POCSVR_BASE

#define SVRPOC_INIT_CHECK_REQ  (SVRPOC_BASE + 1)
#define SVRPOC_INIT_CHECK_RSP  (SVRPOC_BASE + 2)

#define SVRPOC_USER_LOGIN_REQ  (SVRPOC_BASE + 3)
#define SVRPOC_USER_LOGIN_RSP  (SVRPOC_BASE + 4)

#define SVRPOC_USER_LOGOUT_REQ  (SVRPOC_BASE + 5)
#define SVRPOC_USER_LOGOUT_RSP  (SVRPOC_BASE + 6)

#define SVRPOC_GET_GROUPLIST_REQ  (SVRPOC_BASE + 7)
#define SVRPOC_GET_GROUPLIST_RSP  (SVRPOC_BASE + 8)

#define SVRPOC_GET_MEMBERS_REQ  (SVRPOC_BASE + 9)
#define SVRPOC_GET_MEMBERS_RSP  (SVRPOC_BASE + 10)

#define SVRPOC_SEARCH_MEMBERS_REQ  (SVRPOC_BASE + 11)
#define SVRPOC_SEARCH_MEMBERS_RSP  (SVRPOC_BASE + 12)

#define SVRPOC_GET_FRIENDS_REQ  (SVRPOC_BASE + 13)
#define SVRPOC_GET_FRIENDS_RSP  (SVRPOC_BASE + 14)

#define SVRPOC_SEARCH_FRIENDS_REQ  (SVRPOC_BASE + 15)
#define SVRPOC_SEARCH_FRIENDS_RSP  (SVRPOC_BASE + 16)


#define SVRPOC_GET_USERINFO_REQ  (SVRPOC_BASE + 17)
#define SVRPOC_GET_USERINFO_RSP  (SVRPOC_BASE + 18)

#define SVRPOC_GET_LOCATION_INFO_REQ  (SVRPOC_BASE + 19)
#define SVRPOC_GET_LOCATION_INFO_RSP  (SVRPOC_BASE + 20)

#define SVRPOC_GET_ACCOUNT_INFO_REQ  (SVRPOC_BASE + 21)
#define SVRPOC_GET_ACCOUNT_INFO_RSP  (SVRPOC_BASE + 22)

#define SVRPOC_HARDWARE_UPGRADE_REQ  (SVRPOC_BASE + 23)
#define SVRPOC_HARDWARE_UPGRADE_RSP  (SVRPOC_BASE + 24)

#define SVRPOC_JOIN_GROUP_REQ  (SVRPOC_BASE + 25)
#define SVRPOC_JOIN_GROUP_RSP  (SVRPOC_BASE + 26)

#define SVRPOC_JOIN_TEMPORARY_GROUP_REQ  (SVRPOC_BASE + 27)
#define SVRPOC_JOIN_TEMPORARY_GROUP_RSP  (SVRPOC_BASE + 28)

#define SVRPOC_GET_MIC_REQ  (SVRPOC_BASE + 29)
#define SVRPOC_GET_MIC_RSP  (SVRPOC_BASE + 30)

#define SVRPOC_RELEASE_MIC_REQ  (SVRPOC_BASE + 31)
#define SVRPOC_RELEASE_MIC_RSP  (SVRPOC_BASE + 32)

#define SVRPOC_USER_ACTIVITY_REQ  (SVRPOC_BASE + 33)
#define SVRPOC_USER_ACTIVITY_RSP  (SVRPOC_BASE + 34)

#define SVRPOC_GET_ONLINE_MEMBERS_REQ  (SVRPOC_BASE + 35)
#define SVRPOC_GET_ONLINE_MEMBERS_RSP  (SVRPOC_BASE + 36)

#define SVRPOC_PTT_PUSH_REQ  (SVRPOC_BASE + 37)
#define SVRPOC_PTT_PUSH_RSP  (SVRPOC_BASE + 38)

#define SVRPOC_PTT_RELEASE_REQ  (SVRPOC_BASE + 39)
#define SVRPOC_PTT_RELEASE_RSP  (SVRPOC_BASE + 40)

#define SVRPOC_PTT_IS_MEMBER_LOST_REQ  (SVRPOC_BASE + 41)
#define SVRPOC_PTT_IS_MEMBER_LOST_RSP  (SVRPOC_BASE + 42)

#define SVRPOC_SCAN_MEMBER_STATE_REQ  (SVRPOC_BASE + 43)
#define SVRPOC_SCAN_MEMBER_STATE_RSP  (SVRPOC_BASE + 44)

#define SVRPOC_USER_LIFE_INIT_REQ  (SVRPOC_BASE + 45)
#define SVRPOC_USER_LIFE_INIT_RSP  (SVRPOC_BASE + 46)

#define SVRPOC_ENTER_SELECT_GROUP_REQ  (SVRPOC_BASE + 47)
#define SVRPOC_ENTER_SELECT_GROUP_RSP  (SVRPOC_BASE + 48)

#define SVRPOC_ENTER_SELECT_MEMBER_REQ  (SVRPOC_BASE + 49)
#define SVRPOC_ENTER_SELECT_MEMBER_RSP  (SVRPOC_BASE + 50)

#define SVRPOC_ENTER_SELECT_PLAY_GROUP_REQ  (SVRPOC_BASE + 51)
#define SVRPOC_ENTER_SELECT_PLAY_GROUP_RSP  (SVRPOC_BASE + 52)

#define SVRPOC_SELECT_MEMBER_UP_REQ  (SVRPOC_BASE + 53)
#define SVRPOC_SELECT_MEMBER_UP_RSP  (SVRPOC_BASE + 54)

#define SVRPOC_SELECT_MEMBER_DOWN_REQ  (SVRPOC_BASE + 55)
#define SVRPOC_SELECT_MEMBER_DOWN_RSP  (SVRPOC_BASE + 56)

#define SVRPOC_EXIT_SELECT_MEMBER_REQ  (SVRPOC_BASE + 57)
#define SVRPOC_EXIT_SELECT_MEMBER_RSP  (SVRPOC_BASE + 58)

#define SVRPOC_EXIT_SELECT_GROUP_REQ  (SVRPOC_BASE + 59)
#define SVRPOC_EXIT_SELECT_GROUP_RSP  (SVRPOC_BASE + 60)

#define SVRPOC_ENTER_SELECT_GROUP_UP_REQ  (SVRPOC_BASE + 61)
#define SVRPOC_ENTER_SELECT_GROUP_UP_RSP  (SVRPOC_BASE + 62)

#define SVRPOC_ENTER_SELECT_GROUP_DOWN_REQ  (SVRPOC_BASE + 63)
#define SVRPOC_ENTER_SELECT_GROUP_DOWN_RSP  (SVRPOC_BASE + 64)

#define SVRPOC_ENTER_TTS_PLAY_USER_NAME_REQ  (SVRPOC_BASE + 65)
#define SVRPOC_ENTER_TTS_PLAY_USER_NAMEP_RSP  (SVRPOC_BASE + 66)

#define SVRPOC_USER_TEMP_CALL_WITH_NO_GID_REQ  (SVRPOC_BASE + 67)
#define SVRPOC_USER_TEMP_CALL_WITH_NO_GID_RSP  (SVRPOC_BASE + 68)


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*ͨӦ*/
struct svr_poc_comm_result{
	int result;/*0ɹ0ʧ*/
};

/*ûϢ*/
struct svr_poc_user_info{
	char userName[SVRPOC_NAME_LENTH_MAX];/*û*/
	unsigned int uid ;/*ûid*/	
	unsigned int currentGid;/*ǰid*/
	char groupName[SVRPOC_NAME_LENTH_MAX];/*ǰ*/
	unsigned char isOnline;/*Ƿ*/
};

/*ȺϢ*/
struct svr_poc_group{
	unsigned int gid;/*id*/
	char name[SVRPOC_NAME_LENTH_MAX];/**/
	unsigned int n_members;/*ԱĿ*/
	unsigned char has_type;/*Ƿ*/
	unsigned int type; /*0д,1̨õ,ʱ*/
};

/*
 *ѯȺӦ
 */
struct svr_poc_group_ack{
	int result;/*0ɹ0ʧ*/
	unsigned int n_groups;/*ظ˺ڵȺϢ*/
	struct svr_poc_group groups[SVRPOC_GROUP_NUMBER_MAX];	
};

struct svr_poc_member{
		/*
	   *User ID,ϱûϢ
	   */
	  unsigned int uid;
	  /*
	   *˺
	   */
	  char name[SVRPOC_NAME_LENTH_MAX];
	  /*
	   *Ƿ
	   */
	  unsigned char has_online;
};

/*ԱϢ*/
struct svr_poc_group_members{
	unsigned int gid;/*id*/
	/*
	*иȺûIDϢ
	*/
	unsigned int n_ingroups;
	unsigned int ingroups[SVRPOC_MEMBERS_NUMBER_MAX];
	/*
	*иȺûIDϢ
	*/
	unsigned int n_outgroups;
	unsigned int outgroups[SVRPOC_MEMBERS_NUMBER_MAX];
	/*
	*ȺûϢ
	*/
	unsigned int n_members;/*ԱĿ*/
	struct svr_poc_member members[SVRPOC_MEMBERS_NUMBER_MAX];
};

/*
 *ѯȺûϢӦ
 */
struct svr_poc_group_members_ack{
	int result;/*0ɹ0ʧ*/
	unsigned int n_members;/*ԱĿ*/
	struct svr_poc_group_members members;
};

struct svr_poc_search_member_ack {
	int result;/*0ɹ0ʧ*/
	struct svr_poc_member member;
};

struct svr_poc_get_location_ack {
	int result;/*0ɹ0ʧ*/
	char location[SVRPOC_TEXT_INFO_MAX];
};

struct svr_poc_get_account_info_ack {
	int result;/*0ɹ0ʧ*/
	char ip[SVRPOC_NAME_LENTH_MAX];
	char dns[SVRPOC_NAME_LENTH_MAX];
	char username[SVRPOC_NAME_LENTH_MAX];
};

#endif /*__POC_MSG_H*/
