#define _GNU_SOURCE /**/

#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <syslog.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/sysctl.h>
#include <net/if.h>
#include <poll.h>
#include <stddef.h>
#include <linux/if_packet.h>
#include <netinet/ether.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>
#include <pthread.h>
#include <zte_mdl.h>

#define	PROC_CMDLINE_NO_CONSOLE (0)
#define	PROC_CMDLINE_CONSOLE    (1)
#define	STDOUT_BUFFER_SIZE      (256)
#define	STDOUT_PATH_DEVNULL     "/dev/null"

void nvserver_entry(void)
{
	nvserver_main(0,NULL);
	return;
}

void at_ctl_entry(char *arg)
{
	//printf("at_ctl_entry boot:%s\n", arg);
	char *argv[2];
	argv[0] = NULL;
	argv[1] = arg;

	at_ctl_main(2, argv);
	return;
}

void rtc_service_entry(char *arg)
{
	rtc_service_main(0,NULL);
	return;
}

void zte_mainctrl_entry(char *arg)
{
	zte_mainctrl_main(0,NULL);
	return;
}

void zte_hotplug_entry(char *arg)
{
	zte_hotplug_main(0,NULL);
	return;
}

void zte_audio_res_ctrl_entry(char *arg)
{
	zte_audio_res_ctrl_main(0,NULL);
	return;
}

void zte_drv_serial_ctrl_entry(char *arg)
{
	zte_drv_serial_ctrl_main();
	return;
}

void zte_drv_usb_ctrl_entry(char *arg)
{
	zte_drv_usb_ctrl_main(0,NULL);
	return;
}

void sntp_entry(char *arg)
{
	sntp_main(0,NULL);
	return;
}
void wlan_entry(char *arg)
{
#if (defined _USE_VEHICLE_DC_REF) //jb.qi add for wifi config on 20240301
	if (system("cat /sys/class/lynq_nv_cfg/cdev_lynq_nv_cfg/wifi_enable | grep 1") == 0) {
		wlan_main(0,NULL);
	}
	else{
		printf("not need to start wifi\n");
	}
#endif
	return;
}
void fota_dm_entry(char *arg)
{
	fota_dm_main(0,NULL);
	//return; //kw 3
}

void rediect_stdout(void) 
{
	int     fd      = 0;
	FILE    *file   = NULL;
	int     console = PROC_CMDLINE_NO_CONSOLE;
	char    buffer[STDOUT_BUFFER_SIZE] = {0};

	file = fopen("/proc/cmdline", "r");
	if (file == NULL) {
		printf("rediect_stdout: cmdline file read error\n");
		return;
	}

	while (fgets(buffer, sizeof(buffer), file) != NULL) 
	{
		if(strstr(buffer, "console"))
		{
			console = PROC_CMDLINE_CONSOLE;
			break;
		}
	}

	if((console == PROC_CMDLINE_NO_CONSOLE)
		&& ((fd = open(STDOUT_PATH_DEVNULL, O_RDWR, 0)) > 0))
	{
		(void)dup2(fd, STDIN_FILENO);
		(void)dup2(fd, STDOUT_FILENO);
		(void)dup2(fd, STDERR_FILENO);
	
		setvbuf(stdout, NULL, _IOLBF, 0);
		if (fd > STDERR_FILENO)
			(void)close(fd);
	}
	fclose(file);
}

int main(int argc, char *argv[])
{
	/* nvserver */
	pthread_t nvserver_thread_tid;

	rediect_stdout();
	pthread_create(&nvserver_thread_tid, NULL, (void *)nvserver_entry, NULL);

	/* zte_drv_serial_ctrl */
	pthread_t zte_drv_serial_ctrl_thread_tid;
	pthread_create(&zte_drv_serial_ctrl_thread_tid, NULL, (void *)zte_drv_serial_ctrl_entry, NULL);
	/* zte_drv_usb_ctrl */
	pthread_t zte_drv_usb_ctrl_thread_tid;
	pthread_create(&zte_drv_usb_ctrl_thread_tid, NULL, (void *)zte_drv_usb_ctrl_entry, NULL);

	if (0 != strcmp(argv[2], "amt")) { //ģʽ
		/* zte_hotplug */
		pthread_t zte_hotplug_thread_tid;
		pthread_create(&zte_hotplug_thread_tid, NULL, (void *)zte_hotplug_entry, NULL);
	
#if(PRODUCT_TYPE != PRODUCT_TH)
		/* at_ctl */
		pthread_t at_ctl_thread_tid;
		pthread_create(&at_ctl_thread_tid, NULL, (void *)at_ctl_entry, argv[1]);
		/* rtc_service */
		pthread_t rtc_service_thread_tid;
		pthread_create(&rtc_service_thread_tid, NULL, (void *)rtc_service_entry, NULL);
		/* zte_mainctrl */
		pthread_t zte_mainctrl_thread_tid;
		pthread_create(&zte_mainctrl_thread_tid, NULL, (void *)zte_mainctrl_entry, NULL);
#endif		

#ifdef _USE_VEHICLE_DC_REF
		/* wifi_manager */
		pthread_t wlan_thread_tid;
		pthread_create(&wlan_thread_tid, NULL, (void *)wlan_entry, NULL);
#endif

		/* zte_audio_res_ctrl */
		pthread_t zte_audio_res_ctrl_thread_tid;
		pthread_create(&zte_audio_res_ctrl_thread_tid, NULL, (void *)zte_audio_res_ctrl_entry, NULL);
		
				/* sntp */
				//pthread_t sntp_thread_tid;
				//pthread_create(&sntp_thread_tid, NULL, (void *)sntp_entry, NULL);
		/* zte_fota */
		pthread_t fota_dm_thread_tid;
		pthread_create(&fota_dm_thread_tid, NULL, (void *)fota_dm_entry, NULL);

	}
	while(1)
	{
		sleep(20);
		//printf("app test -1 \n");
	}

	return 0;
}

