#!/bin/bash

WORKDIR=$PWD
export PATH=$WORKDIR/bin:$PATH

UBIFS_ARGS="-m 4096 -e 253952 -c 702 -x zlib -F"
UBI_ARGS="-m 0x1000 -p 0x40000 -s 0x1000 -Q 1024"

if [ $# -lt 3 ]; then
  echo "[error] $0 parameter to less"
  echo "$0 outfile dir_name mtd_name"
  exit -1
fi
outfile=$1
dir_name=$2
vol_name=vol_$3
cfg_file_name=${outfile}.cfg

echo "outfile:$outfile"
echo "dir_name:$dir_name"
echo "vol_name:$vol_name"
echo "UBIFS_ARGS:$UBIFS_ARGS"
echo "UBI_ARGS:$UBI_ARGS"

rm -fr ${outfile} ${outfile}.ubifs ${outfile}.cfg

mkfs.ubifs -r $dir_name $UBIFS_ARGS -o ${outfile}.ubifs
if [ $? -ne 0 ]; then
  echo "mkfs.ubifs error"
  exit -1
else
  echo "mkfs.ubifs ok"
fi

filesize="$(stat -c%s ${outfile}.ubifs)"

echo "[ubifs]"                   > $cfg_file_name
echo "mode=ubi"                 >> $cfg_file_name
echo "image=${outfile}.ubifs"   >> $cfg_file_name
echo "vol_id=0"                 >> $cfg_file_name
echo "vol_size=${filesize}"     >> $cfg_file_name
echo "vol_type=dynamic"         >> $cfg_file_name
echo "vol_name=${vol_name}"     >> $cfg_file_name
echo "vol_flags=autoresize"     >> $cfg_file_name

#cat $cfg_file_name

./ubinize-cfg.sh  $outfile $cfg_file_name  "$UBI_ARGS"
