/**
 * 
 * @file      monitor.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agentusb/tf/net¼
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.3
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/01/25  1.2      jiang.fenglin  APUSBģʽtty·ù
 * 2019/02/02  1.3      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/prctl.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <errno.h>
#include <unistd.h>
#include "../include/message.h"
#include "cfg_api.h"
#include "log_agent.h"

#define BUFFER_SIZE     2048
#define TIME_WAIT       30   /*쳣ָʱ*/

pthread_t monitor_hotplug_thread = 0;

#define ZCAT_DETECT_USB_HOTREMOVE  "offline@/devices/platform/zx29_hsotg.0/gadget/tty/ttyGS2"
#define ZCAT_DETECT_USB_HOTADD      "online@/devices/platform/zx29_hsotg.0/gadget/tty/ttyGS2"
#define ZCAT_DETECT_USB_HOTREMOVE1 "offline@/devices/platform/zx29_hsotg.0/gadget/tty/ttyGS1"
#define ZCAT_DETECT_USB_HOTADD1     "online@/devices/platform/zx29_hsotg.0/gadget/tty/ttyGS1"
#define ZCAT_DETECT_HOTPLUG               "@/devices/platform/zx29_hsotg.0/gadget/tty/"

extern void get_usblog_tty_path();
extern int close_usblog();
extern int open_usblog();

extern BOOL g_cp_trap_flag;
extern int hb_flag;
extern char g_zcat_usblog[8];

static int g_hotplug_sock = -1;

/**
 * @brief ʼȲμ¼.
 * @param[in] void
 * @return ļ
 * @note
 * @see 
 */
static int init_hotplug_sock()
{
    const int buffersize = BUFFER_SIZE;
    int ret;

    struct sockaddr_nl snl;
    bzero(&snl, sizeof(struct sockaddr_nl));
    snl.nl_family = AF_NETLINK;
    snl.nl_pid = getpid();
    snl.nl_groups = 1;

    int s = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);
    if (s == -1)
    {
        perror("socket");
        return -1;
    }
    ret = setsockopt(s, SOL_SOCKET, SO_RCVBUF, &buffersize, sizeof(buffersize));
	if(ret != 0)
	{
	    perror("setsockopt");
	}

    ret = bind(s, (struct sockaddr *)&snl, sizeof(struct sockaddr_nl));
    if (ret < 0)
    {
        perror("bind");
        close(s);
        return -1;
    }

    return s;
}

/**
 * @brief Ȳμ̺߳.
 * @param[in] args ̺߳
 * @return void
 * @note
 * @see 
 */
static void *monitor_hotplug(void* args)
{
    char buf[BUFFER_SIZE] = { 0 };
    int ret = 0;

    prctl(PR_SET_NAME, "monitor_hotplug");
    
    while(1)
    {
        memset(buf, 0, sizeof(buf));
        
        get_usblog_tty_path();
        
        ret = recv(g_hotplug_sock, &buf, sizeof(buf) - 1, 0);
        printf("[zcat] hotplug msg, ret = %d, msg = %s\n", ret, buf);
        
        if (strstr(buf, ZCAT_DETECT_HOTPLUG))
        {
            if(strstr(buf, g_zcat_usblog))
            {
                if(strstr(buf, "offline"))
                {
                    hb_flag = 0;
                    close_usblog();
                    continue;
                }

                if(strstr(buf, "online"))
                {
                    if(open_usblog() < 0)
                    {
                        printf("[zcat] open_usblog error!\n");
                        continue;
                        //return -1;
                    }
                }
            }
        }
    }
	return NULL;
}

/**
 * @brief ʼȲμ߳.
 * @param[in] void
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int init_monitor_hotplug()
{
    int ret = -1;
    
	g_hotplug_sock = init_hotplug_sock();  
    printf("[zcat] init_hotplug_sock %d\n", g_hotplug_sock);
    if(g_hotplug_sock < 0)
        return -1;
    
    ret = pthread_create(&monitor_hotplug_thread, NULL, monitor_hotplug, NULL);
    if(ret != 0)
    {   
        printf("[zcat] create monitor_hotplug_thread error\n");
        return -1;
    }
    return ret;
}
