#include "lib_tele.h"
#ifndef __LYNQ_NETWORK__
#define __LYNQ_NETWORK__
#ifdef __cplusplus
extern "C" {
#endif
typedef struct{
    lynqBase base;
    char *OperatorFN;    //It is long alpha ONS or EONS
    char *OperatorSH;    //It is short alpha ONS or EONS
    char *MccMnc;        //It is 5 or 6 digit numeric code (MCC + MNC)
}operatorInfo;
typedef struct{
    lynqBase base;
    char *OperatorFN;
    char *OperatorSH;
    char *MccMnc;
    char * NetStatus;   //a string value of the status: "unknown","available","current","forbidden"
}availableNetwork;

typedef struct{
    lynqBase base;
    int mode;
}networkSelecttionMode;
typedef struct{
    lynqBase base;
    int     regState;               //registration state
    int     imsRegState;
    char *  LAC;                    //location area code, it is LAC if registered or NULL id not
    char *  CID;                    //cell identifier, if registered or NULL id not.
    RIL_RadioTechnology netType;    //network type
    RIL_RadioTechnologyFamily radioTechFam;//RIL_RadioTechnologyFamily
}registrationStateInfo;

typedef struct{
    lynqBase base;
    RIL_RadioTechnology radioTech;
}radioTechnology;

typedef struct{
    lynqBase base;
    int pnt; //preffered network type.
}prefferredNetworkType;
typedef struct{
    lynqBase base;
    char *cid;
    int rssi;
}neighboringCellIDs;
typedef struct{
    lynqBase base;
    int bandmode[20];
}availableBandMode;
typedef struct{
    lynqBase base;
    RIL_CellInfo cellinfo;
}cellInfoList;
typedef struct{
    lynqBase base;
    RIL_SignalStrength_v14 signalStrength;
}solicitedSignalStrength;

/*T800 platform support gsm,wcdma lte,nr */
typedef struct{
    int gw_sig_valid; /*1 valid,1 invalid*/
    int rssi;         /* Valid values are (0-31, 99) as defined in TS 27.007 8.5 */
    int wcdma_sig_valid;/*1 valid,0 invalid*/
    int rscp;        /* The Received Signal Code Power in dBm multipled by -1.
                      * Range : 25 to 120
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 25.123, section 9.1.1.1 */
    int ecno;        /* Valid values are positive integers.  This value is the actual Ec/Io multiplied
                      * by -10.  Example: If the actual Ec/Io is -12.5 dB, then this response value
                      * will be 125.*/
    int lte_sig_valid;/*1 valid,0 invalid*/
    int rsrp;        /* The current Reference Signal Receive Power in dBm multipled by -1.
                      * Range: 44 to 140 dBm
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.133 9.1.4 */
    int rsrq;        /* The current Reference Signal Receive Quality in dB multiplied by -1.
                      * Range: 20 to 3 dB.
                      * INT_MAX: 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.133 9.1.7 */
    int rssnr;       /* The current reference signal signal-to-noise ratio in 0.1 dB units.
                      * Range: -200 to +300 (-200 = -20.0 dB, +300 = 30dB).
                      * INT_MAX : 0x7FFFFFFF denotes invalid value.
                      * Reference: 3GPP TS 36.101 8.1.1 */
    int nr_sig_valid;/*1 valid,0 invalid*/
    int ssRsrp;      /* SS(Synchronization Signal) reference signal received power, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [44, 140], INT_MAX means invalid/unreported.*/
    int ssRsrq;      /* SS reference signal received quality, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [3, 20], INT_MAX means invalid/unreported.*/
    int ssSinr;      /* SS signal-to-noise and interference ratio.
                      * Reference: 3GPP TS 38.215 section 5.1.*, 3GPP TS 38.133 section 10.1.16.1.
                      * Range [-23, 40], INT_MAX means invalid/unreported.*/
    int csiRsrp;     /* CSI reference signal received power, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [44, 140], INT_MAX means invalid/unreported.*/
    int csiRsrq;     /* CSI reference signal received quality, multipled by -1.
                      * Reference: 3GPP TS 38.215.
                      * Range [3, 20], INT_MAX means invalid/unreported.*/
    int csiSinr;     /* CSI signal-to-noise and interference ratio.
                      * Reference: 3GPP TS 138.215 section 5.1.*, 3GPP TS 38.133 section 10.1.16.1.
                      * Range [-23, 40], INT_MAX means invalid/unreported.*/
}signalStrength_t;
typedef void (*lynq_signal_strength_change_ind)(int slot,signalStrength_t signalStrength);
typedef void (*lynq_voice_network_state_change_ind)(int slot);
int lynq_signal_strength_change_cb(lynq_signal_strength_change_ind signalStrength_cb);
int lynq_voice_network_state_change_cb(lynq_voice_network_state_change_ind voiceChange_cb);
int lynq_query_operater(operatorInfo * currentOperator);
int lynq_query_network_selection_mode(networkSelecttionMode *netselMode);
int lynq_set_network_selection_mode(const char *mode,const char* mccmnc,lynqBase * base);
int lynq_query_available_network(availableNetwork *availNet);
int lynq_query_registration_state(const char *type,registrationStateInfo *regStateInfo);
int lynq_query_prefferred_networktype(prefferredNetworkType * preNetType);
int lynq_set_prefferred_networktype(const int preffertype,lynqBase * base);
int lynq_query_cell_info(cellInfoList * * cellinfo, int listNum, int * realNum);
int lynq_set_unsol_cell_info_listrate(const int rate,lynqBase * base);
int lynq_query_neighboring_cellids(neighboringCellIDs **neiCeIDs,const int listNum,int *realNum);
int lynq_set_band_mode(const int bandmode,lynqBase *base);
int lynq_query_available_bandmode(availableBandMode*availBanMode);
int lynq_radio_on(const int data,lynqBase *base);
int lynq_query_radio_tech(radioTechnology *radioTech);
int lynq_solicited_signal_strength(solicitedSignalStrength *solSigStren);
int lynq_modem_on(const int data,lynqBase *base);

#ifdef __cplusplus
}
#endif

#endif



