/*============================================================================= 
#     FileName: lynq_sim.cpp
#     Desc: about SIMAPI
#     Author: mobiletek 
#     Version: V1.0
#     LastChange: 2020-07-29 
#     History: 
# If you need to use any API under lynq_sim, you must first call the init_sim() function to initialize these functions.
=============================================================================*/
#ifndef __LYNQ_SIM__
#define __LYNQ_SIM__
#include <sys/types.h>
#include "lib_tele.h"
#define MAX_BUF 20
#define MAX_NUM 80
#ifdef __cplusplus
extern "C" {
#endif
typedef struct
{
    lynqBase base;
    RIL_CardState card_status;
    RIL_AppType  card_type;
    RIL_PinState pin_state;
}simStatus;

typedef struct
{
    lynqBase base;
    char imsi[MAX_BUF];
    //char *imsi;
}simImsi;

typedef struct
{
    lynqBase base;
    char iccid[MAX_BUF];
}simIccid;

typedef struct 
{
    lynqBase base;
    int state[MAX_BUF];
    char buf[MAX_BUF];
}simOperate;

typedef struct 
{
    lynqBase base;
    char number[MAX_NUM];
}simNumber;

typedef struct 
{
    lynqBase base;
    char MCCMNC[MAX_BUF];
    char buf[MAX_BUF];
}simOperator;

int init_sim();
int lynq_get_sim_status(int *card_status);
int lynq_get_imsi(char buf[]);

/*add by lei*/
int lynq_sim_init(void);
int lynq_sim_deinit(void);
int lynq_enable_pin(char *pin);
int lynq_disable_pin(char *pin);
int lynq_query_operator(char buf[]);
int lynq_get_iccid(char buf[]);
int lynq_query_pin_lock(char *pin,char buf[]);
int lynq_verify_pin(char *pin);
int lynq_change_pin(char *old_pin, char *new_pin);
int lynq_unlock_pin(char *puk, char *pin);
int lynq_query_phone_number(char buf[]);
/*add by lei*/

#ifdef __cplusplus
}
#endif

#endif

