#include "zxic_at_func_wrapper.h"
#include <string.h>
#include <stdio.h>
#include "lynq_atsvc_controller.h"
#include "liblog/lynq_deflog.h"

extern "C"
{
    typedef void (*ZXIC_AT_CALLBACK_FUNC_PTR) (unsigned char *, unsigned char *);

    extern int reg_at_serv_func(char *at_cmd_prefix, ZXIC_AT_CALLBACK_FUNC_PTR cb);
    extern int unreg_at_serv_func(char *at_cmd_prefix);
}

struct callback_entry
{
    char at_prefix[64];
    ZXIC_AT_CALLBACK_FUNC_PTR callback_func;
    plugin_msg_t *plugin_entry;
};

const int entry_count = 256;
static volatile int g_zxic_at_plugin_env_flag = 0;
static struct callback_entry *g_all_reg_entry[entry_count] = {0};
static int g_curr_reg_index = 0;

plugin_msg_t plugin_msg_array[PLUGINE_MAX_COUNT] = {0};

template <int n>
void zxic_at_callback(unsigned char * input, unsigned char * output)
{
    char *org_cmd = NULL;
    if (input == NULL || output == NULL)
    {
        ALOGE("zxic_at_callback invalid params %p-%p \n", input, output);
        return;
    }
    strcpy((char*)output, "\r\n");
    struct callback_entry *pEntry = g_all_reg_entry[n];
	org_cmd = new char [strlen(input) + 32];
	if (org_cmd == NULL)
	{
		strcat(output, "+CME ERROR: 100\r\n");
	}
	org_cmd[0] = '\0';
    strcat(org_cmd, pEntry->at_prefix);
    strcat(org_cmd, (char *)input);
    pEntry->plugin_entry->output_buffer = (char*)output;
    ALOGD("zxic_at_callback org_cmd -- %s \n", org_cmd);
    pEntry->plugin_entry->atsvc_incb(org_cmd, strlen(org_cmd));
    pEntry->plugin_entry->output_buffer = NULL;
    ALOGD("zxic_at_callback output -- %s \n", output);
	delete [] org_cmd;
    //return 0;
}

template <int n>
void reg_callback_function()
{
    g_all_reg_entry[n] = new struct callback_entry;
    g_all_reg_entry[n]->callback_func = &zxic_at_callback<n>;
    reg_callback_function<n-1>();
}

template <>
void reg_callback_function<0>()
{
    g_all_reg_entry[0] = new struct callback_entry;
    g_all_reg_entry[0]->callback_func = &zxic_at_callback<0>;
}

template <int n>
void lynq_atsvc_outcb_entity(char *output,int out_size,int type)
{
    ALOGD("lynq_atsvc_outcb_entity%d called\n",n);
    if (plugin_msg_array[n].output_buffer == NULL)
    {
        ALOGE("no output buffer");
        return;
    }
    if(NULL == output)
    {
        ALOGE("output is null");
    }
    int length = 0;
    length = strlen(output);
    if(length != out_size)
    {
        ALOGW("strlen length != output");
    }
    ALOGD("ouput:%s,len:%d",output,out_size);

	//not first line add \r\n
    if (plugin_msg_array[n].output_buffer[0] != '\0')
    {
        strcat(plugin_msg_array[n].output_buffer, "\r\n");
    }

    strcat(plugin_msg_array[n].output_buffer, output);
}

template <int n>
void reg_lynq_atsvc_outcb_entity()
{
    plugin_msg_array[n].plugin_cb = &lynq_atsvc_outcb_entity<n>;
    plugin_msg_array[n].output_buffer = NULL;
    reg_lynq_atsvc_outcb_entity<n-1>();
}

template <>
void reg_lynq_atsvc_outcb_entity<0>()
{
    plugin_msg_array[0].plugin_cb = &lynq_atsvc_outcb_entity<0>;
    plugin_msg_array[0].output_buffer = NULL;
}

static int lynq_split(char * str, int len, char delimiter, char * results[]) {
    int ret = 0;
    char * end = str + len - 1;
    results[ret++] = str;
    while(str < end)
    {
        if (*str == delimiter)
    {
            *str++ = '\0';
            results[ret++] = str;
            continue;
        }
        str++;
    }
    if (*str == delimiter)
    {
        *str = '\0';
    }

    results[ret] = NULL;

    return ret;
}

static int local_reg_at_serv_func(char *at_cmd_prefix, ZXIC_AT_CALLBACK_FUNC_PTR cb) //@todo to check if registered
{
    int ret;
    ret = reg_at_serv_func(at_cmd_prefix, cb);
    ALOGD("reg_at_serv_func return:%d", ret);
    if (ret == 0)
    {
        return 0;
    }
    unreg_at_serv_func(at_cmd_prefix);
    return reg_at_serv_func(at_cmd_prefix, cb);
}

static int local_reg_one_at_cmd(const char* reg_fmt, char*reg_word, char * at_cmd, plugin_msg_t *plugin_entry)
{
    struct callback_entry *entry;
    char reg_cmd[32] = {0};
    entry = g_all_reg_entry[g_curr_reg_index];
    snprintf(reg_cmd, sizeof (reg_cmd), reg_fmt, reg_word);
    snprintf(entry->at_prefix, sizeof (entry->at_prefix), reg_fmt, at_cmd);
    if (local_reg_at_serv_func(reg_cmd, g_all_reg_entry[g_curr_reg_index]->callback_func) == 0)
    {
        entry->plugin_entry = plugin_entry;
        g_curr_reg_index++;
        ALOGI("reg_at_serv_func [%s] success\n", reg_cmd);
    }
    else
    {
        ALOGE("reg_at_serv_func [%s] fail\n", reg_cmd);
    }

    return 0;
}

static int reg_at_cmd(char * at_cmd, plugin_msg_t *plugin_entry)
{
    int words_count;
    char *split_words[64] = {0};
    char cmd[32] = {0};

    strcpy(cmd, at_cmd);
    words_count = lynq_split(cmd, strlen(cmd), '+', split_words);
    if (words_count != 2 || strlen(split_words[1]) == 0)
    {
        ALOGE("bad format command [%s]", cmd);
        return -1;
    }

    ALOGD("reg_at_cmd [%s] begin", at_cmd);
    local_reg_one_at_cmd("%s", split_words[1], at_cmd, plugin_entry);
    local_reg_one_at_cmd("%s?", split_words[1], at_cmd, plugin_entry);
    local_reg_one_at_cmd("%s=", split_words[1], at_cmd, plugin_entry);
    local_reg_one_at_cmd("%s=?", split_words[1], at_cmd, plugin_entry);
    ALOGD("reg_at_cmd [%s] end", at_cmd);

    return 0;
}

static int reg_at_cmds_of_plugin(plugin_msg_t *plugin_entry)
{
    int cmds_count, i;
    char *split_cmds[64] = {0};
    char *cmd_buffer = new char[strlen(plugin_entry->atcmd)+1];
    strcpy(cmd_buffer, plugin_entry->atcmd);

    cmds_count = lynq_split(cmd_buffer, strlen(plugin_entry->atcmd), ';', split_cmds);

    ALOGD("reg_at_cmds_of_plugin cmd count %d ,%s", cmds_count, cmd_buffer);
    for(i=0;i<cmds_count;i++)
    {
        reg_at_cmd(split_cmds[i], plugin_entry) ;
    }
    delete [] cmd_buffer;
    return 0;
}

int init_zxic_at_plugin_env()
{
    if (g_zxic_at_plugin_env_flag != 0)
        return -1;
    memset(plugin_msg_array,0,sizeof(plugin_msg_array));
    reg_callback_function<entry_count-1>();
    reg_lynq_atsvc_outcb_entity<PLUGINE_MAX_COUNT-1>();
    g_zxic_at_plugin_env_flag = 1;

    lynq_atsvc_init(0,NULL);

    for(int i = 0;i < PLUGINE_MAX_COUNT; i++)
    {
        if(NULL != plugin_msg_array[i].atcmd)
        {
            ALOGD("atcmd:%s",plugin_msg_array[i].atcmd);
            reg_at_cmds_of_plugin(&plugin_msg_array[i]);
        }
    }

    return 0;
}

