//SPDX-License-Identifier: MediaTekProprietary
/*
**
** Copyright 2006, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/
#define LYNQ_RIL_SUPPROT 0
#include<sys/types.h>
#include<sys/socket.h>
#include<unistd.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<netdb.h>
#include<signal.h>
#include <log/log.h>
#if LYNQ_RIL_SUPPROT
    #include <hardware_legacy/power.h>
#endif //LYNQ_RIL_SUPPROT
#include <vendor-ril/telephony/ril.h>
#include <telephony/ril_cdma_sms.h>
#include <cutils/jstring.h>
#include <telephony/record_stream.h>
#include <utils/SystemClock.h>
#include <pthread.h>
#include <binder/Parcel.h>
#include <cutils/jstring.h>
#include <sys/types.h>
#include <limits.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <assert.h>
#include <ctype.h>
#include <alloca.h>
#include <sys/un.h>
#include <assert.h>
#include <netinet/in.h>
#include <atomic>

#include "utils/String8.h"
#include "ss.h"
#include "sim.h"
#include "common.h"
#include "cc.h"
#include "network.h"
#include "stk.h"
#include "utils.h"

#include "atci/ATCI.h"
#include "data/data.h"
#include "data/data_gdbus.h"
#include "ecall/eCall.h"
#include "em/em.h"
#include "sms/sms.h"
#include "sms/cdma/sms_pdu_cdma.h"
#include "stateManager/stateManager.h"
#include "Phone_utils.h"
#include "utils.h"
#include "Radio_capability_switch_util.h"
/*Warren add for t800 RIL service 2021_12_10 start*/
#include <sys/epoll.h>
#include "lynq_interface.h"
#include "lynq_common.h"
#include "lynq_sms_manager.h"
/*lei add*/
#include <stdbool.h>
#include "lynq_at.h"
#include "lynq_user.h"
#include "lynq_rndis.h"
#include "lynq_factory.h"
#include <sys/stat.h>
/*lei add*/
/*rita add start*/
#include "lynq_at_temp.h"
/*rita add end*/
/*lt add start*/
/*lt add end*/
/*Warren add for t800 RIL service 2021_12_10 end*/
#ifdef LED_SUPPORT
#include "led.h"
#include "libled/lynq_led.h"
#include <include/lynq_uci.h>
#endif
#include "lynq_shm.h"
#include "call_rtp.h"

#define LOG_TAG "DEMO_RIL"
#define WAIT_TIME_FOR_SIM_SWITCH 30
#ifdef LED_SUPPORT
#define LED_ON 4
#define LYNQ_UCI_SECTION "lynq_led"
#define LYNQ_UCI_NETLED_KEY "lynq_netled_on"
#endif

extern void ARspRequest (int request, RIL_SOCKET_ID socket_id);
extern void responseDispatch();

namespace android {
extern "C" void
RIL_onRequestComplete(RIL_Token t, RIL_Errno e, void *response, size_t responselen);

#define SERVER_PORT 8000
#define BUFFER_SIZE 8192
#define MAX_ARGS 101
#define BLOCK_LOCK() pthread_mutex_lock(&s_BlockMutex)
#define BLOCK_UNLOCK() pthread_mutex_unlock(&s_BlockMutex)
#define BLOCK_WAIT(a) pthread_cond_timedwait(&s_BlockCond, &s_BlockMutex,(a))
#define BLOCK_WAKEUP() pthread_cond_broadcast(&s_BlockCond)
#define SPECIA_BLOCK_LOCK() pthread_mutex_lock(&s_SpecialBlock)
#define SPECIA_BLOCK_UNLOCK() pthread_mutex_unlock(&s_SpecialBlock)
#define SPECIA_BLOCK_WAIT(a) pthread_cond_timedwait(&s_SpeciaBlockCond, &s_SpecialBlock,(a))
#define SPECIA_BLOCK_WAKEUP() pthread_cond_signal(&s_SpeciaBlockCond)

static int s_started = 0;
static int s_responseDispatch = 0;
static int s_isConnected[2] = {0,0}; //connect to modem;
static pthread_mutex_t s_InitMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_InitCond = PTHREAD_COND_INITIALIZER;

static pthread_mutex_t s_BlockMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_BlockCond = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t s_SpecialBlock = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_SpeciaBlockCond = PTHREAD_COND_INITIALIZER;

int requestOneByOne = 0;
int server_socket_fd;
int enable_syslog = 1;
int enable_bt_resp = 0;
int wakeup_token = -1;
struct sockaddr_in client_addr;

#define ANDROID_WAKE_LOCK_NAME "radio-interface"

// Basically: memset buffers that the client library
// shouldn't be using anymore in an attempt to find
// memory usage issues sooner.
#define MEMSET_FREED 1

#define NUM_ELEMS(a)     (sizeof (a) / sizeof (a)[0])

#define MIN(a,b) ((a)<(b) ? (a) : (b))

/* Constants for response types */
#define RESPONSE_SOLICITED 0
#define RESPONSE_UNSOLICITED 1

/* Negative values for private RIL errno's */
#define RIL_ERRNO_INVALID_RESPONSE -1

// request, response, and unsolicited msg print macro
#define PRINTBUF_SIZE 8096

// Enable verbose logging
#define VDBG 0

// Enable RILC log
#define RILC_LOG 1
/*Warren add for t800 RIL service 2021_12_10 start*/
#define LYNQ_RIL_FWK_IP "127.0.0.1"
#define LYNQ_SOCKET_ENVNT_FD_MAX 100
#define LYNQ_SERVICE_PORT 8088
#define LYNQ_AT_SERVICE_PORT 8087
#define LYNQ_BRODCAST_PORT 8086
/*Interfaces lo net addr 127.0.0.1,mask 255.0.0.0,so lo broadcast addr is 127.255.255.255*/
#define LYNQ_RIL_FWK_BROADCAST_IP "127.255.255.255" /*hong.liu change broadcast addr on 2024.2.18*/
#define LYNQ_SOCKET_BUFFER (1024*8+sizeof(int)*3+10)
/*lei add*/
#define DSET_IP_ADDRESS  "127.0.0.1"
#define LYNQ_AT_SOCKET_BUFFER 1024
#define MAX_AT_CMD 50
/*lei add*/
//int LYNQ_RIL_respSocket(Parcel &p,RIL_Token t);
//int LYNQ_RIL_urcBroadcast(Parcel &p);

/*hq add for urc broadcast opti 2023/01/06 */
#define SHM_BUFFER_INDEX_OFFSET 1
#define SHM_BUFFER_SIZE_OFFSET 16
#define urc_broadcase_shm_size_limit 20

int lynq_urc_socket_fd = 0;
struct sockaddr_in urc_broadcast_addr;
/*Warren add for t800 RIL service 2021_12_10 end*/


/*lei add*/
char buffer_at[LYNQ_AT_SOCKET_BUFFER] = {0};
/*For at extension to receive at buffer*/
char *at_buf_ext[MAX_AT_CMD];
int sockfd = 0;
int imei_cnt = 0;
bool sdk_ready = true;
/*lei add*/
#if RILC_LOG
    static char printBuf[PRINTBUF_SIZE];
    static char tempPrintBuf[PRINTBUF_SIZE];
    #define startRequest           sprintf(printBuf, "(")
    #define closeRequest           snprintf(tempPrintBuf, PRINTBUF_SIZE, "%s)", printBuf); \
                                   snprintf(printBuf, PRINTBUF_SIZE, "%s", tempPrintBuf)
    #define printRequest(token, req) if(enable_syslog) {         \
        RLOGI("[%x]> %s %s", token, requestToString(req), printBuf);} else {\
        printf("[%x]> %s %s\n", token, requestToString(req), printBuf);}

    #define startResponse           sprintf(printBuf, "%s {", printBuf)
    #define closeResponse           snprintf(tempPrintBuf, PRINTBUF_SIZE, "%s}", printBuf); \
                                    snprintf(printBuf, PRINTBUF_SIZE, "%s", tempPrintBuf)
    #define printResponse            if(enable_syslog) { \
                                    RLOGI("%s", printBuf); } else { \
                                    printf("%s\n", printBuf);}

    #define clearPrintBuf           printBuf[0] = 0
    #define removeLastChar          printBuf[strlen(printBuf)-1] = 0
    #define appendPrintBuf(x...)    snprintf(tempPrintBuf, PRINTBUF_SIZE, x); \
                                    snprintf(printBuf, PRINTBUF_SIZE, "%s", tempPrintBuf)
#endif

enum WakeType {DONT_WAKE, WAKE_PARTIAL};

#if 0
typedef struct {
    int requestNumber;
    void (*dispatchFunction) (Parcel &p, struct RequestInfo *pRI);
    int(*responseFunction) (Parcel &p, void *response, size_t responselen);
} CommandInfo;
#endif

typedef struct {
    int requestNumber;
    int (*responseFunction) (Parcel &p, void *response, size_t responselen);
    WakeType wakeType;
} UnsolResponseInfo;

#if 0
typedef struct RequestInfo {
    int32_t token;      //this is not RIL_Token
    CommandInfo *pCI;
    struct RequestInfo *p_next;
    char cancelled;
    char local;         // responses to local commands do not go back to command process
    RIL_SOCKET_ID socket_id;
} RequestInfo;

typedef struct UserCallbackInfo {
    RIL_TimedCallback p_callback;
    void *userParam;
    struct ril_event event;
    struct UserCallbackInfo *p_next;
} UserCallbackInfo;
#endif

const char *requestToString(int request);
const char * failCauseToString(RIL_Errno);
const char * callStateToString(RIL_CallState);

RIL_RadioFunctions s_callbacks = {0, NULL, NULL, NULL, NULL, NULL};
int s_registerCalled = 0;

static pthread_t s_tid_dispatch;

static const struct timeval TIMEVAL_WAKE_TIMEOUT = {1,0};

#if EM_MODE_SUPPORT
netwokInfoNotify networkCb = NULL;
atCmdResponse atResponseCb = NULL;
#endif

static pthread_mutex_t s_startupMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_startupCond = PTHREAD_COND_INITIALIZER;
static void *s_lastNITZTimeData = NULL;
static size_t s_lastNITZTimeDataSize;

/*******************************************************************/
static int sendResponse (Parcel &p, RIL_SOCKET_ID socket_id);

static void dispatchVoid (Parcel& p, RequestInfo *pRI);
static void dispatchString (Parcel& p, RequestInfo *pRI);
static void dispatchStrings (Parcel& p, RequestInfo *pRI);
static void dispatchInts (Parcel& p, RequestInfo *pRI);
static void dispatchDial (Parcel& p, RequestInfo *pRI);
static void dispatchSIM_IO (Parcel& p, RequestInfo *pRI);
static void dispatchSIM_APDU (Parcel& p, RequestInfo *pRI);
static void dispatchCallForward(Parcel& p, RequestInfo *pRI);
static void dispatchRaw(Parcel& p, RequestInfo *pRI);
static void dispatchSmsWrite (Parcel &p, RequestInfo *pRI);
static void dispatchDataCall (Parcel& p, RequestInfo *pRI);
static void dispatchSetInitialAttachApn (Parcel& p, RequestInfo *pRI);;
static void dispatchCdmaSms(Parcel &p, RequestInfo *pRI);
static void dispatchImsSms(Parcel &p, RequestInfo *pRI);
static void dispatchImsCdmaSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef);
static void dispatchImsGsmSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef);
static void dispatchCdmaSmsAck(Parcel &p, RequestInfo *pRI);
static void dispatchGsmBrSmsCnf(Parcel &p, RequestInfo *pRI);
static void dispatchCdmaBrSmsCnf(Parcel &p, RequestInfo *pRI);
static void dispatchRilCdmaSmsWriteArgs(Parcel &p, RequestInfo *pRI);
static void dispatchNVReadItem(Parcel &p, RequestInfo *pRI);
static void dispatchNVWriteItem(Parcel &p, RequestInfo *pRI);
static void dispatchUiccSubscripton(Parcel &p, RequestInfo *pRI);
static void dispatchSimAuthentication(Parcel &p, RequestInfo *pRI);
static void dispatchDataProfile(Parcel &p, RequestInfo *pRI);
static void dispatchRadioCapability(Parcel &p, RequestInfo *pRI);
static int responseInts(Parcel &p, void *response, size_t responselen);
static int responseFailCause(Parcel &p, void *response, size_t responselen);
static int responseStrings(Parcel &p, void *response, size_t responselen);
static int responseString(Parcel &p, void *response, size_t responselen);
static int responseVoid(Parcel &p, void *response, size_t responselen);
static int responseCallList(Parcel &p, void *response, size_t responselen);
static int responseSMS(Parcel &p, void *response, size_t responselen);
static int responseSIM_IO(Parcel &p, void *response, size_t responselen);
static int responseCallForwards(Parcel &p, void *response, size_t responselen);
static int responseDataCallList(Parcel &p, void *response, size_t responselen);
//LYNQ_MODIFY_ZXW_TASK794_CR2024120449D612E5_XF.Li_20241221_START
#ifdef MOBILETEK_TARGET_PLATFORM_T106
static int responseApnList(Parcel &p, void *response, size_t responselen);
#endif
//LYNQ_MODIFY_ZXW_TASK794_CR2024120449D612E5_XF.Li_20241221_END
static int responseSetupDataCall(Parcel &p, void *response, size_t responselen);
static int responseRaw(Parcel &p, void *response, size_t responselen);
static int responseSsn(Parcel &p, void *response, size_t responselen);
static int responseSimStatus(Parcel &p, void *response, size_t responselen);
static int responseGsmBrSmsCnf(Parcel &p, void *response, size_t responselen);
static int responseCdmaBrSmsCnf(Parcel &p, void *response, size_t responselen);
static int responseCdmaSms(Parcel &p, void *response, size_t responselen);
static int responseCellList(Parcel &p, void *response, size_t responselen);
static int responseCdmaInformationRecords(Parcel &p,void *response, size_t responselen);
static int responseRilSignalStrength(Parcel &p,void *response, size_t responselen);
static int responseCallRing(Parcel &p, void *response, size_t responselen);
static int responseCdmaSignalInfoRecord(Parcel &p,void *response, size_t responselen);
static int responseCdmaCallWaiting(Parcel &p,void *response, size_t responselen);
static int responseSimRefresh(Parcel &p, void *response, size_t responselen);
static int responseCellInfoList(Parcel &p, void *response, size_t responselen);
static int responseHardwareConfig(Parcel &p, void *response, size_t responselen);
static int responseDcRtInfo(Parcel &p, void *response, size_t responselen);
static int responseRadioCapability(Parcel &p, void *response, size_t responselen);
static int responseSSData(Parcel &p, void *response, size_t responselen);
static int responseLceStatus(Parcel &p, void *response, size_t responselen);
static int responseLceData(Parcel &p, void *response, size_t responselen);
static int responseActivityData(Parcel &p, void *response, size_t responselen);
static int responseSmsSimMemStatus(Parcel &p, void *response, size_t responselen);
#ifdef ECALL_SUPPORT
static void dispatchFastEcall (Parcel& p, RequestInfo *pRI);
static int responseEcallStatus(Parcel &p, void *response, size_t responselen);
static void dispatchSetMsd (Parcel &p, RequestInfo *pRI);
static void dispatchEcallRecord (Parcel &p, RequestInfo *pRI);
#endif /*ECALL_SUPPORT*/
#ifdef KEEP_ALIVE
static void dispatchStartKeepalivePro(Parcel &p, RequestInfo *pRI);
#endif /*KEEP_ALIVE*/
static int decodeVoiceRadioTechnology (RIL_RadioState radioState);
static int decodeCdmaSubscriptionSource (RIL_RadioState radioState);
static RIL_RadioState processRadioState(RIL_RadioState newRadioState);

static bool isServiceTypeCfQuery(RIL_SsServiceType serType, RIL_SsRequestType reqType);

static int onSupports (int requestCode);
static UnsolResponseInfo* find_mtk_unsol_command(int request);
static int com_quit(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
static int enableSyslog(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
static int enableBTResponse(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
static void updateIccCardState(RIL_SOCKET_ID soc_id);
static void initCoditions();

static int SendRespToClient(const void *data, size_t dataSize);
static void speciaRequest_wakeup();
static void speciaRequest_wait();
void processUnsolicited (Parcel &p, int type);
void processSolicited (Parcel &p, int type);

void printInputArgs(int argc, char** argv) ;
void initRequestInfo(RequestInfo *pRI, int  request, int mode, RIL_SOCKET_ID soc_id);
const int waitResponse(int token);
void sendRequestToMd(int request, int id);


#ifdef RIL_SHLIB
#if defined(ANDROID_MULTI_SIM)
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen, RIL_SOCKET_ID socket_id);
#else
extern "C" void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen);
#endif
#endif

#if defined(ANDROID_MULTI_SIM)
#define RIL_UNSOL_RESPONSE(a, b, c, d) RIL_onUnsolicitedResponse((a), (b), (c), (d))
#define CALL_ONREQUEST(a, b, c, d, e) s_callbacks.onRequest((a), (b), (c), (d), (e))
#define CALL_ONSTATEREQUEST(a) s_callbacks.onStateRequest(a)
#else
#define RIL_UNSOL_RESPONSE(a, b, c, d) RIL_onUnsolicitedResponse((a), (b), (c))
#define CALL_ONREQUEST(a, b, c, d, e) s_callbacks.onRequest((a), (b), (c), (d))
#define CALL_ONSTATEREQUEST(a) s_callbacks.onStateRequest()
#endif


/** Index == requestNumber */
static CommandInfo s_commands[] = {
#include "ril_commands.h"
};

static UnsolResponseInfo s_unsolResponses[] = {
#include "ril_unsol_commands.h"
};

COMMAND commands[] = {
#include "commands.h"
};

static CommandInfo mtk_s_command[] = {
#include "mtk_ril_commands.h"
};

static UnsolResponseInfo s_mtk_unsolResponses[] = {
#include "mtk_ril_unsol_commands.h"
};

char respStr[PRINTBUF_SIZE]={0};

/* For older RILs that do not support new commands RIL_REQUEST_VOICE_RADIO_TECH and
   RIL_UNSOL_VOICE_RADIO_TECH_CHANGED messages, decode the voice radio tech from
   radio state message and store it. Every time there is a change in Radio State
   check to see if voice radio tech changes and notify telephony
 */
int voiceRadioTech = -1;

/* For older RILs that do not support new commands RIL_REQUEST_GET_CDMA_SUBSCRIPTION_SOURCE
   and RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED messages, decode the subscription
   source from radio state and store it. Every time there is a change in Radio State
   check to see if subscription source changed and notify telephony
 */
int cdmaSubscriptionSource = -1;

/* For older RILs that do not send RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED, decode the
   SIM/RUIM state from radio state and store it. Every time there is a change in Radio State,
   check to see if SIM/RUIM status changed and notify telephony
 */
int simRuimStatus = -1;


static char *
strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);

    return strndup16to8(s16, stringlen);
}

static status_t
readStringFromParcelInplace(Parcel &p, char *str, size_t maxLen) {
    size_t s16Len;
    const char16_t *s16;

    s16 = p.readString16Inplace(&s16Len);
    if (s16 == NULL) {
        return NO_MEMORY;
    }
    size_t strLen = strnlen16to8(s16, s16Len);
    if ((strLen + 1) > maxLen) {
        return NO_MEMORY;
    }
    if (strncpy16to8(str, s16, strLen) == NULL) {
        return NO_MEMORY;
    } else {
        return NO_ERROR;
    }
}

/*static*/ void writeStringToParcel(Parcel &p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p.writeString16(s16, s16_len);
    free(s16);
}


static void
memsetString (char *s) {
    if (s != NULL) {
        memset (s, 0, strlen(s));
    }
}


static void
invalidCommandBlock (RequestInfo *pRI) {
    RLOGE("invalid command block for token %d request %s",
                pRI->token, requestToString(pRI->pCI->requestNumber));
}

/** Callee expects NULL */
static void
dispatchVoid (Parcel& p, RequestInfo *pRI) {
    clearPrintBuf;
    printRequest(pRI->token, pRI->pCI->requestNumber);
    CALL_ONREQUEST(pRI->pCI->requestNumber, NULL, 0, pRI, pRI->socket_id);
}

/** Callee expects const char * */
static void
dispatchString (Parcel& p, RequestInfo *pRI) {
    status_t status;
    size_t datalen;
    size_t stringlen;
    char *string8 = NULL;

    string8 = strdupReadString(p);

    startRequest;
    appendPrintBuf("%s%s", printBuf, string8);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, string8,
                       sizeof(char *), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(string8);
#endif

    free(string8);
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/** Callee expects const char ** */
static void
dispatchStrings (Parcel &p, RequestInfo *pRI) {
    int32_t countStrings;
    status_t status;
    size_t datalen;
    char **pStrings;

    status = p.readInt32 (&countStrings);

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    if (countStrings == 0) {
        // just some non-null pointer
        pStrings = (char **)alloca(sizeof(char *));
        datalen = 0;
    } else if (((int)countStrings) == -1) {
        pStrings = NULL;
        datalen = 0;
    } else {
        datalen = sizeof(char *) * countStrings;

        pStrings = (char **)alloca(datalen);

        for (int i = 0 ; i < countStrings ; i++) {
            pStrings[i] = strdupReadString(p);
            appendPrintBuf("%s%s,", printBuf, pStrings[i]);
        }
    }
    removeLastChar;
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, pStrings, datalen, pRI, pRI->socket_id);

    if (pStrings != NULL) {
        for (int i = 0 ; i < countStrings ; i++) {
#ifdef MEMSET_FREED
            memsetString (pStrings[i]);
#endif
            free(pStrings[i]);
        }

#ifdef MEMSET_FREED
        memset(pStrings, 0, datalen);
#endif
    }

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/** Callee expects const int * */
static void
dispatchInts (Parcel &p, RequestInfo *pRI) {
    int32_t count;
    status_t status;
    size_t datalen;
    int *pInts;

    status = p.readInt32 (&count);

    if (status != NO_ERROR || count == 0) {
        goto invalid;
    }

    datalen = sizeof(int) * count;
    pInts = (int *)alloca(datalen);

    startRequest;
    for (int i = 0 ; i < count ; i++) {
        int32_t t = 0;

        status = p.readInt32(&t);
        pInts[i] = (int)t;
        appendPrintBuf("%s%d,", printBuf, t);

        if (status != NO_ERROR) {
            goto invalid;
        }
   }
   removeLastChar;
   closeRequest;
   printRequest(pRI->token, pRI->pCI->requestNumber);

   CALL_ONREQUEST(pRI->pCI->requestNumber, const_cast<int *>(pInts),
                       datalen, pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(pInts, 0, datalen);
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}


/**
 * Callee expects const RIL_SMS_WriteArgs *
 * Payload is:
 *   int32_t status
 *   String pdu
 */
static void
dispatchSmsWrite (Parcel &p, RequestInfo *pRI) {
    RIL_SMS_WriteArgs args;
    int32_t t = -1;
    status_t status;

    RLOGD("dispatchSmsWrite");
    memset (&args, 0, sizeof(args));

    status = p.readInt32(&t);
    args.status = (int)t;

    args.pdu = strdupReadString(p);

    if (status != NO_ERROR || args.pdu == NULL) {
        goto invalid;
    }

    args.smsc = strdupReadString(p);

    startRequest;
    appendPrintBuf("%s%d,%s,smsc=%s", printBuf, args.status,
        (char*)args.pdu,  (char*)args.smsc);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString (args.pdu);
#endif

    free (args.pdu);
    free (args.smsc);
#ifdef MEMSET_FREED
    memset(&args, 0, sizeof(args));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_Dial *
 * Payload is:
 *   String address
 *   int32_t clir
 */
static void
dispatchDial (Parcel &p, RequestInfo *pRI) {
    RIL_Dial dial;
    RIL_UUS_Info uusInfo;
    int32_t sizeOfDial;
    int32_t t = -1;
    int32_t uusPresent;
    status_t status;

    RLOGD("dispatchDial");
    memset (&dial, 0, sizeof(dial));

    dial.address = strdupReadString(p);

    status = p.readInt32(&t);
    dial.clir = (int)t;

    if (status != NO_ERROR || dial.address == NULL) {
        goto invalid;
    }

    if (s_callbacks.version < 3) { // Remove when partners upgrade to version 3
        uusPresent = 0;
        sizeOfDial = sizeof(dial) - sizeof(RIL_UUS_Info *);
    } else {
        status = p.readInt32(&uusPresent);

        if (status != NO_ERROR) {
            goto invalid;
        }

        if (uusPresent == 0) {
            dial.uusInfo = NULL;
        } else {
            int32_t len;

            memset(&uusInfo, 0, sizeof(RIL_UUS_Info));

            status = p.readInt32(&t);
            uusInfo.uusType = (RIL_UUS_Type) t;

            status = p.readInt32(&t);
            uusInfo.uusDcs = (RIL_UUS_DCS) t;

            status = p.readInt32(&len);
            if (status != NO_ERROR) {
                goto invalid;
            }

            // The java code writes -1 for null arrays
            if (((int) len) == -1) {
                uusInfo.uusData = NULL;
                len = 0;
            } else {
                uusInfo.uusData = (char*) p.readInplace(len);
            }

            uusInfo.uusLength = len;
            dial.uusInfo = &uusInfo;
        }
        sizeOfDial = sizeof(dial);
    }

    startRequest;
    appendPrintBuf("%snum=%s,clir=%d", printBuf, dial.address, dial.clir);
    if (uusPresent) {
        appendPrintBuf("%s,uusType=%d,uusDcs=%d,uusLen=%d", printBuf,
                dial.uusInfo->uusType, dial.uusInfo->uusDcs,
                dial.uusInfo->uusLength);
    }

    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &dial, sizeOfDial, pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString (dial.address);
#endif

    free (dial.address);

#ifdef MEMSET_FREED
    memset(&uusInfo, 0, sizeof(RIL_UUS_Info));
    memset(&dial, 0, sizeof(dial));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_SIM_IO *
 * Payload is:
 *   int32_t command
 *   int32_t fileid
 *   String path
 *   int32_t p1, p2, p3
 *   String data
 *   String pin2
 *   String aidPtr
 */
static void
dispatchSIM_IO (Parcel &p, RequestInfo *pRI) {
    union RIL_SIM_IO {
        RIL_SIM_IO_v6 v6;
        RIL_SIM_IO_v5 v5;
    } simIO;

    int32_t t = -1;
    int size;
    status_t status;

#if VDBG
    RLOGD("dispatchSIM_IO");
#endif
    memset (&simIO, 0, sizeof(simIO));

    // note we only check status at the end

    status = p.readInt32(&t);
    simIO.v6.command = (int)t;

    status = p.readInt32(&t);
    simIO.v6.fileid = (int)t;

    simIO.v6.path = strdupReadString(p);

    status = p.readInt32(&t);
    simIO.v6.p1 = (int)t;

    status = p.readInt32(&t);
    simIO.v6.p2 = (int)t;

    status = p.readInt32(&t);
    simIO.v6.p3 = (int)t;

    simIO.v6.data = strdupReadString(p);
    simIO.v6.pin2 = strdupReadString(p);
    simIO.v6.aidPtr = strdupReadString(p);

    startRequest;
    appendPrintBuf("%scmd=0x%X,efid=0x%X,path=%s,%d,%d,%d,%s,pin2=%s,aid=%s", printBuf,
        simIO.v6.command, simIO.v6.fileid, (char*)simIO.v6.path,
        simIO.v6.p1, simIO.v6.p2, simIO.v6.p3,
        (char*)simIO.v6.data,  (char*)simIO.v6.pin2, simIO.v6.aidPtr);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    size = (s_callbacks.version < 6) ? sizeof(simIO.v5) : sizeof(simIO.v6);
    CALL_ONREQUEST(pRI->pCI->requestNumber, &simIO, size, pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString (simIO.v6.path);
    memsetString (simIO.v6.data);
    memsetString (simIO.v6.pin2);
    memsetString (simIO.v6.aidPtr);
#endif

    free (simIO.v6.path);
    free (simIO.v6.data);
    free (simIO.v6.pin2);
    free (simIO.v6.aidPtr);

#ifdef MEMSET_FREED
    memset(&simIO, 0, sizeof(simIO));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_SIM_APDU *
 * Payload is:
 *   int32_t sessionid
 *   int32_t cla
 *   int32_t instruction
 *   int32_t p1, p2, p3
 *   String data
 */
static void
dispatchSIM_APDU (Parcel &p, RequestInfo *pRI) {
    int32_t t = -1;
    status_t status;
    RIL_SIM_APDU apdu;

#if VDBG
    RLOGD("dispatchSIM_APDU");
#endif
    memset (&apdu, 0, sizeof(RIL_SIM_APDU));

    // Note we only check status at the end. Any single failure leads to
    // subsequent reads filing.
    status = p.readInt32(&t);
    apdu.sessionid = (int)t;

    status = p.readInt32(&t);
    apdu.cla = (int)t;

    status = p.readInt32(&t);
    apdu.instruction = (int)t;

    status = p.readInt32(&t);
    apdu.p1 = (int)t;

    status = p.readInt32(&t);
    apdu.p2 = (int)t;

    status = p.readInt32(&t);
    apdu.p3 = (int)t;

    apdu.data = strdupReadString(p);

    startRequest;
    appendPrintBuf("%ssessionid=%d,cla=%d,ins=%d,p1=%d,p2=%d,p3=%d,data=%s",
        printBuf, apdu.sessionid, apdu.cla, apdu.instruction, apdu.p1, apdu.p2,
        apdu.p3, (char*)apdu.data);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &apdu, sizeof(RIL_SIM_APDU), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(apdu.data);
#endif
    free(apdu.data);

#ifdef MEMSET_FREED
    memset(&apdu, 0, sizeof(RIL_SIM_APDU));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}


/**
 * Callee expects const RIL_CallForwardInfo *
 * Payload is:
 *  int32_t status/action
 *  int32_t reason
 *  int32_t serviceCode
 *  int32_t toa
 *  String number  (0 length -> null)
 *  int32_t timeSeconds
 */
static void
dispatchCallForward(Parcel &p, RequestInfo *pRI) {
    RIL_CallForwardInfo cff;
    int32_t t = -1;
    status_t status;

    RLOGD("dispatchCallForward");
    memset (&cff, 0, sizeof(cff));

    // note we only check status at the end

    status = p.readInt32(&t);
    cff.status = (int)t;

    status = p.readInt32(&t);
    cff.reason = (int)t;

    status = p.readInt32(&t);
    cff.serviceClass = (int)t;

    status = p.readInt32(&t);
    cff.toa = (int)t;

    cff.number = strdupReadString(p);

    status = p.readInt32(&t);
    cff.timeSeconds = (int)t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    // special case: number 0-length fields is null

    if (cff.number != NULL && strlen (cff.number) == 0) {
        cff.number = NULL;
    }

    startRequest;
    appendPrintBuf("%sstat=%d,reason=%d,serv=%d,toa=%d,%s,tout=%d", printBuf,
        cff.status, cff.reason, cff.serviceClass, cff.toa,
        (char*)cff.number, cff.timeSeconds);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &cff, sizeof(cff), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(cff.number);
#endif

    free (cff.number);

#ifdef MEMSET_FREED
    memset(&cff, 0, sizeof(cff));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}


static void
dispatchRaw(Parcel &p, RequestInfo *pRI) {
    int32_t len;
    status_t status;
    const void *data;

    status = p.readInt32(&len);

    if (status != NO_ERROR) {
        goto invalid;
    }

    // The java code writes -1 for null arrays
    if (((int)len) == -1) {
        data = NULL;
        len = 0;
    }

    data = p.readInplace(len);

    startRequest;
    appendPrintBuf("%sraw_size=%d", printBuf, len);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, const_cast<void *>(data), len, pRI, pRI->socket_id);

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static status_t
constructCdmaSms(Parcel &p, RequestInfo *pRI, RIL_CDMA_SMS_Message& rcsm) {
    int32_t  t = -1;
    uint8_t ut;
    status_t status;
    int32_t digitCount;
    int digitLimit;

    memset(&rcsm, 0, sizeof(rcsm));

    status = p.readInt32(&t);
    rcsm.uTeleserviceID = (int) t;

    status = p.read(&ut,sizeof(ut));
    rcsm.bIsServicePresent = (uint8_t) ut;

    status = p.readInt32(&t);
    rcsm.uServicecategory = (int) t;

    status = p.readInt32(&t);
    rcsm.sAddress.digit_mode = (RIL_CDMA_SMS_DigitMode) t;

    status = p.readInt32(&t);
    rcsm.sAddress.number_mode = (RIL_CDMA_SMS_NumberMode) t;

    status = p.readInt32(&t);
    rcsm.sAddress.number_type = (RIL_CDMA_SMS_NumberType) t;

    status = p.readInt32(&t);
    rcsm.sAddress.number_plan = (RIL_CDMA_SMS_NumberPlan) t;

    status = p.read(&ut,sizeof(ut));
    rcsm.sAddress.number_of_digits= (uint8_t) ut;

    digitLimit= MIN((rcsm.sAddress.number_of_digits), RIL_CDMA_SMS_ADDRESS_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&ut,sizeof(ut));
        rcsm.sAddress.digits[digitCount] = (uint8_t) ut;
    }

    status = p.readInt32(&t);
    rcsm.sSubAddress.subaddressType = (RIL_CDMA_SMS_SubaddressType) t;

    status = p.read(&ut,sizeof(ut));
    rcsm.sSubAddress.odd = (uint8_t) ut;

    status = p.read(&ut,sizeof(ut));
    rcsm.sSubAddress.number_of_digits = (uint8_t) ut;

    digitLimit= MIN((rcsm.sSubAddress.number_of_digits), RIL_CDMA_SMS_SUBADDRESS_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&ut,sizeof(ut));
        rcsm.sSubAddress.digits[digitCount] = (uint8_t) ut;
    }

    status = p.readInt32(&t);
    rcsm.uBearerDataLen = (int) t;

    digitLimit= MIN((rcsm.uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&ut, sizeof(ut));
        rcsm.aBearerData[digitCount] = (uint8_t) ut;
    }

    if (status != NO_ERROR) {
        return status;
    }

    startRequest;
    appendPrintBuf("%suTeleserviceID=%d, bIsServicePresent=%d, uServicecategory=%d, \
            sAddress.digit_mode=%d, sAddress.Number_mode=%d, sAddress.number_type=%d, ",
            printBuf, rcsm.uTeleserviceID,rcsm.bIsServicePresent,rcsm.uServicecategory,
            rcsm.sAddress.digit_mode, rcsm.sAddress.number_mode,rcsm.sAddress.number_type);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    return status;
}

static void
dispatchCdmaSms(Parcel &p, RequestInfo *pRI) {
    RIL_CDMA_SMS_Message rcsm;

    RLOGD("dispatchCdmaSms");
    if (NO_ERROR != constructCdmaSms(p, pRI, rcsm)) {
        goto invalid;
    }

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rcsm, sizeof(rcsm),pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(&rcsm, 0, sizeof(rcsm));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchImsCdmaSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef) {
    RIL_IMS_SMS_Message rism;
    RIL_CDMA_SMS_Message rcsm;

    RLOGD("dispatchImsCdmaSms: retry=%d, messageRef=%d", retry, messageRef);

    if (NO_ERROR != constructCdmaSms(p, pRI, rcsm)) {
        goto invalid;
    }
    memset(&rism, 0, sizeof(rism));
    rism.tech = RADIO_TECH_3GPP2;
    rism.retry = retry;
    rism.messageRef = messageRef;
    rism.message.cdmaMessage = &rcsm;

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rism,
            sizeof(RIL_RadioTechnologyFamily)+sizeof(uint8_t)+sizeof(int32_t)
            +sizeof(rcsm),pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(&rcsm, 0, sizeof(rcsm));
    memset(&rism, 0, sizeof(rism));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchImsGsmSms(Parcel &p, RequestInfo *pRI, uint8_t retry, int32_t messageRef) {
    RIL_IMS_SMS_Message rism;
    int32_t countStrings;
    status_t status;
    size_t datalen;
    char **pStrings;
    RLOGD("dispatchImsGsmSms: retry=%d, messageRef=%d", retry, messageRef);

    status = p.readInt32 (&countStrings);

    if (status != NO_ERROR) {
        goto invalid;
    }

    memset(&rism, 0, sizeof(rism));
    rism.tech = RADIO_TECH_3GPP;
    rism.retry = retry;
    rism.messageRef = messageRef;

    startRequest;
    appendPrintBuf("%stech=%d, retry=%d, messageRef=%d, ", printBuf,
                    (int)rism.tech, (int)rism.retry, rism.messageRef);
    if (countStrings == 0) {
        // just some non-null pointer
        pStrings = (char **)alloca(sizeof(char *));
        datalen = 0;
    } else if (((int)countStrings) == -1) {
        pStrings = NULL;
        datalen = 0;
    } else {
        datalen = sizeof(char *) * countStrings;

        pStrings = (char **)alloca(datalen);

        for (int i = 0 ; i < countStrings ; i++) {
            pStrings[i] = strdupReadString(p);
            appendPrintBuf("%s%s,", printBuf, pStrings[i]);
        }
    }
    removeLastChar;
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    rism.message.gsmMessage = pStrings;
    CALL_ONREQUEST(pRI->pCI->requestNumber, &rism,
            sizeof(RIL_RadioTechnologyFamily)+sizeof(uint8_t)+sizeof(int32_t)
            +datalen, pRI, pRI->socket_id);

    if (pStrings != NULL) {
        for (int i = 0 ; i < countStrings ; i++) {
#ifdef MEMSET_FREED
            memsetString (pStrings[i]);
#endif
            free(pStrings[i]);
        }

#ifdef MEMSET_FREED
        memset(pStrings, 0, datalen);
#endif
    }

#ifdef MEMSET_FREED
    memset(&rism, 0, sizeof(rism));
#endif
    return;
invalid:
    ALOGE("dispatchImsGsmSms invalid block");
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchImsSms(Parcel &p, RequestInfo *pRI) {
    int32_t  t;
    status_t status = p.readInt32(&t);
    RIL_RadioTechnologyFamily format;
    uint8_t retry;
    int32_t messageRef;

    RLOGD("dispatchImsSms");
    if (status != NO_ERROR) {
        goto invalid;
    }
    format = (RIL_RadioTechnologyFamily) t;

    // read retry field
    status = p.read(&retry,sizeof(retry));
    if (status != NO_ERROR) {
        goto invalid;
    }
    // read messageRef field
    status = p.read(&messageRef,sizeof(messageRef));
    if (status != NO_ERROR) {
        goto invalid;
    }

    if (RADIO_TECH_3GPP == format) {
        dispatchImsGsmSms(p, pRI, retry, messageRef);
    } else if (RADIO_TECH_3GPP2 == format) {
        dispatchImsCdmaSms(p, pRI, retry, messageRef);
    } else {
        ALOGE("requestImsSendSMS invalid format value =%d", format);
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchCdmaSmsAck(Parcel &p, RequestInfo *pRI) {
    RIL_CDMA_SMS_Ack rcsa;
    int32_t  t = -1;
    status_t status;
    int32_t digitCount;

    RLOGD("dispatchCdmaSmsAck");
    memset(&rcsa, 0, sizeof(rcsa));

    status = p.readInt32(&t);
    rcsa.uErrorClass = (RIL_CDMA_SMS_ErrorClass) t;

    status = p.readInt32(&t);
    rcsa.uSMSCauseCode = (int) t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%suErrorClass=%d, uTLStatus=%d, ",
            printBuf, rcsa.uErrorClass, rcsa.uSMSCauseCode);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rcsa, sizeof(rcsa),pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(&rcsa, 0, sizeof(rcsa));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchGsmBrSmsCnf(Parcel &p, RequestInfo *pRI) {
    int32_t t;
    status_t status;
    int32_t num;

    status = p.readInt32(&num);
    if (status != NO_ERROR) {
        goto invalid;
    }

    {
        RIL_GSM_BroadcastSmsConfigInfo gsmBci[num];
        RIL_GSM_BroadcastSmsConfigInfo *gsmBciPtrs[num];

        startRequest;
        for (int i = 0 ; i < num ; i++ ) {
            gsmBciPtrs[i] = &gsmBci[i];

            status = p.readInt32(&t);
            gsmBci[i].fromServiceId = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].toServiceId = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].fromCodeScheme = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].toCodeScheme = (int) t;

            status = p.readInt32(&t);
            gsmBci[i].selected = (uint8_t) t;

            appendPrintBuf("%s [%d: fromServiceId=%d, toServiceId =%d, \
                  fromCodeScheme=%d, toCodeScheme=%d, selected =%d]", printBuf, i,
                  gsmBci[i].fromServiceId, gsmBci[i].toServiceId,
                  gsmBci[i].fromCodeScheme, gsmBci[i].toCodeScheme,
                  gsmBci[i].selected);
        }
        closeRequest;

        if (status != NO_ERROR) {
            goto invalid;
        }

        printRequest(pRI->token, pRI->pCI->requestNumber);

        CALL_ONREQUEST(pRI->pCI->requestNumber,
                              gsmBciPtrs,
                              num * sizeof(RIL_GSM_BroadcastSmsConfigInfo *),
                              pRI, pRI->socket_id);

#ifdef MEMSET_FREED
        memset(gsmBci, 0, num * sizeof(RIL_GSM_BroadcastSmsConfigInfo));
        memset(gsmBciPtrs, 0, num * sizeof(RIL_GSM_BroadcastSmsConfigInfo *));
#endif
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void
dispatchCdmaBrSmsCnf(Parcel &p, RequestInfo *pRI) {
    int32_t t;
    status_t status;
    int32_t num;

    status = p.readInt32(&num);
    if (status != NO_ERROR) {
        goto invalid;
    }

    {
        RIL_CDMA_BroadcastSmsConfigInfo cdmaBci[num];
        RIL_CDMA_BroadcastSmsConfigInfo *cdmaBciPtrs[num];

        startRequest;
        for (int i = 0 ; i < num ; i++ ) {
            cdmaBciPtrs[i] = &cdmaBci[i];

            status = p.readInt32(&t);
            cdmaBci[i].service_category = (int) t;

            status = p.readInt32(&t);
            cdmaBci[i].language = (int) t;

            status = p.readInt32(&t);
            cdmaBci[i].selected = (uint8_t) t;

            appendPrintBuf("%s [%d: service_category=%d, language =%d, \
                  entries.bSelected =%d]", printBuf, i, cdmaBci[i].service_category,
                  cdmaBci[i].language, cdmaBci[i].selected);
        }
        closeRequest;

        if (status != NO_ERROR) {
            goto invalid;
        }
        printRequest(pRI->token, pRI->pCI->requestNumber);
        CALL_ONREQUEST(pRI->pCI->requestNumber,
                              cdmaBciPtrs,
                              num * sizeof(RIL_CDMA_BroadcastSmsConfigInfo *),
                              pRI, pRI->socket_id);

#ifdef MEMSET_FREED
        memset(cdmaBci, 0, num * sizeof(RIL_CDMA_BroadcastSmsConfigInfo));
        memset(cdmaBciPtrs, 0, num * sizeof(RIL_CDMA_BroadcastSmsConfigInfo *));
#endif
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchRilCdmaSmsWriteArgs(Parcel &p, RequestInfo *pRI) {
    RIL_CDMA_SMS_WriteArgs rcsw;
    int32_t  t = -1;
    uint32_t ut;
    uint8_t  uct = 0;
    status_t status;
    int32_t  digitCount;
    int32_t  digitLimit;

    memset(&rcsw, 0, sizeof(rcsw));

    status = p.readInt32(&t);
    rcsw.status = t;

    status = p.readInt32(&t);
    rcsw.message.uTeleserviceID = (int) t;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.bIsServicePresent = (uint8_t) uct;

    status = p.readInt32(&t);
    rcsw.message.uServicecategory = (int) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.digit_mode = (RIL_CDMA_SMS_DigitMode) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.number_mode = (RIL_CDMA_SMS_NumberMode) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.number_type = (RIL_CDMA_SMS_NumberType) t;

    status = p.readInt32(&t);
    rcsw.message.sAddress.number_plan = (RIL_CDMA_SMS_NumberPlan) t;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.sAddress.number_of_digits = (uint8_t) uct;

    digitLimit = MIN((rcsw.message.sAddress.number_of_digits), RIL_CDMA_SMS_ADDRESS_MAX);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct,sizeof(uct));
        rcsw.message.sAddress.digits[digitCount] = (uint8_t) uct;
    }

    status = p.readInt32(&t);
    rcsw.message.sSubAddress.subaddressType = (RIL_CDMA_SMS_SubaddressType) t;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.sSubAddress.odd = (uint8_t) uct;

    status = p.read(&uct,sizeof(uct));
    rcsw.message.sSubAddress.number_of_digits = (uint8_t) uct;

    digitLimit = MIN((rcsw.message.sSubAddress.number_of_digits), RIL_CDMA_SMS_SUBADDRESS_MAX);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct,sizeof(uct));
        rcsw.message.sSubAddress.digits[digitCount] = (uint8_t) uct;
    }

    status = p.readInt32(&t);
    rcsw.message.uBearerDataLen = (int) t;

    digitLimit = MIN((rcsw.message.uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct, sizeof(uct));
        rcsw.message.aBearerData[digitCount] = (uint8_t) uct;
    }

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%sstatus=%d, message.uTeleserviceID=%d, message.bIsServicePresent=%d, \
            message.uServicecategory=%d, message.sAddress.digit_mode=%d, \
            message.sAddress.number_mode=%d, \
            message.sAddress.number_type=%d, ",
            printBuf, rcsw.status, rcsw.message.uTeleserviceID, rcsw.message.bIsServicePresent,
            rcsw.message.uServicecategory, rcsw.message.sAddress.digit_mode,
            rcsw.message.sAddress.number_mode,
            rcsw.message.sAddress.number_type);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &rcsw, sizeof(rcsw),pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(&rcsw, 0, sizeof(rcsw));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;

}

// For backwards compatibility in RIL_REQUEST_SETUP_DATA_CALL.
// Version 4 of the RIL interface adds a new PDP type parameter to support
// IPv6 and dual-stack PDP contexts. When dealing with a previous version of
// RIL, remove the parameter from the request.
static void dispatchDataCall(Parcel& p, RequestInfo *pRI) {
    // In RIL v3, REQUEST_SETUP_DATA_CALL takes 6 parameters.
    const int numParamsRilV3 = 6;

    // The first bytes of the RIL parcel contain the request number and the
    // serial number - see processCommandBuffer(). Copy them over too.
    int pos = p.dataPosition();

    int numParams = p.readInt32();
    if (s_callbacks.version < 4 && numParams > numParamsRilV3) {
/*      Parcel p2;
      p2.appendFrom(&p, 0, pos);
      p2.writeInt32(numParamsRilV3);
      for(int i = 0; i < numParamsRilV3; i++) {
        p2.writeString16(p.readString16());
      }
      p2.setDataPosition(pos);
      dispatchStrings(p2, pRI);*/
    } else {
      p.setDataPosition(pos);
      dispatchStrings(p, pRI);
    }
}

static void dispatchSetInitialAttachApn(Parcel &p, RequestInfo *pRI)
{
    RIL_InitialAttachApn pf;
    int32_t  t = -1;
    status_t status;

    memset(&pf, 0, sizeof(pf));

    pf.apn = strdupReadString(p);
    pf.protocol = strdupReadString(p);

    status = p.readInt32(&t);
    pf.authtype = (int) t;

    pf.username = strdupReadString(p);
    pf.password = strdupReadString(p);

    startRequest;
    appendPrintBuf("%sapn=%s, protocol=%s, authtype=%d, username=%s, password=%s",
            printBuf, pf.apn, pf.protocol, pf.authtype, pf.username, pf.password);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }
    CALL_ONREQUEST(pRI->pCI->requestNumber, &pf, sizeof(pf), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(pf.apn);
    memsetString(pf.protocol);
    memsetString(pf.username);
    memsetString(pf.password);
#endif

    free(pf.apn);
    free(pf.protocol);
    free(pf.username);
    free(pf.password);

#ifdef MEMSET_FREED
    memset(&pf, 0, sizeof(pf));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchNVReadItem(Parcel &p, RequestInfo *pRI) {
    RIL_NV_ReadItem nvri;
    int32_t  t = -1;
    status_t status;

    memset(&nvri, 0, sizeof(nvri));

    status = p.readInt32(&t);
    nvri.itemID = (RIL_NV_Item) t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%snvri.itemID=%d, ", printBuf, nvri.itemID);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &nvri, sizeof(nvri), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(&nvri, 0, sizeof(nvri));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchNVWriteItem(Parcel &p, RequestInfo *pRI) {
    RIL_NV_WriteItem nvwi;
    int32_t  t = -1;
    status_t status;

    memset(&nvwi, 0, sizeof(nvwi));

    status = p.readInt32(&t);
    nvwi.itemID = (RIL_NV_Item) t;

    nvwi.value = strdupReadString(p);

    if (status != NO_ERROR || nvwi.value == NULL) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%snvwi.itemID=%d, value=%s, ", printBuf, nvwi.itemID,
            nvwi.value);
    closeRequest;

    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &nvwi, sizeof(nvwi), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(nvwi.value);
#endif

    free(nvwi.value);

#ifdef MEMSET_FREED
    memset(&nvwi, 0, sizeof(nvwi));
#endif

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}


static void dispatchUiccSubscripton(Parcel &p, RequestInfo *pRI) {
    RIL_SelectUiccSub uicc_sub;
    status_t status;
    int32_t  t;
    memset(&uicc_sub, 0, sizeof(uicc_sub));

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.slot = (int) t;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.app_index = (int) t;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.sub_type = (RIL_SubscriptionType) t;

    status = p.readInt32(&t);
    if (status != NO_ERROR) {
        goto invalid;
    }
    uicc_sub.act_status = (RIL_UiccSubActStatus) t;

    startRequest;
    appendPrintBuf("slot=%d, app_index=%d, act_status = %d", uicc_sub.slot, uicc_sub.app_index,
            uicc_sub.act_status);
    RLOGD("dispatchUiccSubscription, slot=%d, app_index=%d, act_status = %d", uicc_sub.slot,
            uicc_sub.app_index, uicc_sub.act_status);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &uicc_sub, sizeof(uicc_sub), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(&uicc_sub, 0, sizeof(uicc_sub));
#endif
    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchSimAuthentication(Parcel &p, RequestInfo *pRI)
{
    RIL_SimAuthentication pf;
    int32_t  t = -1;
    status_t status;

    memset(&pf, 0, sizeof(pf));

    status = p.readInt32(&t);
    pf.authContext = (int) t;
    pf.authData = strdupReadString(p);
    pf.aid = strdupReadString(p);

    startRequest;
    appendPrintBuf("authContext=%s, authData=%s, aid=%s", pf.authContext, pf.authData, pf.aid);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }
    CALL_ONREQUEST(pRI->pCI->requestNumber, &pf, sizeof(pf), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(pf.authData);
    memsetString(pf.aid);
#endif

    free(pf.authData);
    free(pf.aid);

#ifdef MEMSET_FREED
    memset(&pf, 0, sizeof(pf));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchDataProfile(Parcel &p, RequestInfo *pRI) {
    int32_t t;
    status_t status;
    int32_t num;

    status = p.readInt32(&num);
    if (status != NO_ERROR) {
        goto invalid;
    }

    {
        RIL_DataProfileInfo dataProfiles[num];
        RIL_DataProfileInfo *dataProfilePtrs[num];

        startRequest;
        for (int i = 0 ; i < num ; i++ ) {
            dataProfilePtrs[i] = &dataProfiles[i];

            status = p.readInt32(&t);
            dataProfiles[i].profileId = (int) t;

            dataProfiles[i].apn = strdupReadString(p);
            dataProfiles[i].protocol = strdupReadString(p);
            status = p.readInt32(&t);
            dataProfiles[i].authType = (int) t;

            dataProfiles[i].user = strdupReadString(p);
            dataProfiles[i].password = strdupReadString(p);

            status = p.readInt32(&t);
            dataProfiles[i].type = (int) t;

            status = p.readInt32(&t);
            dataProfiles[i].maxConnsTime = (int) t;
            status = p.readInt32(&t);
            dataProfiles[i].maxConns = (int) t;
            status = p.readInt32(&t);
            dataProfiles[i].waitTime = (int) t;

            status = p.readInt32(&t);
            dataProfiles[i].enabled = (int) t;

            appendPrintBuf("%s [%d: profileId=%d, apn =%s, protocol =%s, authType =%d, \
                  user =%s, password =%s, type =%d, maxConnsTime =%d, maxConns =%d, \
                  waitTime =%d, enabled =%d]", printBuf, i, dataProfiles[i].profileId,
                  dataProfiles[i].apn, dataProfiles[i].protocol, dataProfiles[i].authType,
                  dataProfiles[i].user, dataProfiles[i].password, dataProfiles[i].type,
                  dataProfiles[i].maxConnsTime, dataProfiles[i].maxConns,
                  dataProfiles[i].waitTime, dataProfiles[i].enabled);
            RLOGD("[%d: profileId=%d, apn =%s, protocol =%s, authType =%d, \
user =%s, password =%s, type =%d, maxConnsTime =%d, maxConns =%d, \
waitTime =%d, enabled =%d]", i, dataProfiles[i].profileId,
                  dataProfiles[i].apn, dataProfiles[i].protocol, dataProfiles[i].authType,
                  dataProfiles[i].user, dataProfiles[i].password, dataProfiles[i].type,
                  dataProfiles[i].maxConnsTime, dataProfiles[i].maxConns,
                  dataProfiles[i].waitTime, dataProfiles[i].enabled);
        }
        closeRequest;
        printRequest(pRI->token, pRI->pCI->requestNumber);

        if (status != NO_ERROR) {
            goto invalid;
        }
        CALL_ONREQUEST(pRI->pCI->requestNumber,
                              dataProfilePtrs,
                              num * sizeof(RIL_DataProfileInfo *),
                              pRI, pRI->socket_id);
        for(int i = 0; i< num; i++) {
            free(dataProfiles[i].apn);
            free(dataProfiles[i].protocol);
            free(dataProfiles[i].user);
            free(dataProfiles[i].password);
        }
#ifdef MEMSET_FREED
        memset(dataProfiles, 0, num * sizeof(RIL_DataProfileInfo));
        memset(dataProfilePtrs, 0, num * sizeof(RIL_DataProfileInfo *));
#endif
    }

    return;

invalid:
    invalidCommandBlock(pRI);
    return;
}

static void dispatchRadioCapability(Parcel &p, RequestInfo *pRI){
    RIL_RadioCapability rc;
    int32_t t = -1;
    status_t status;

    memset (&rc, 0, sizeof(RIL_RadioCapability));

    status = p.readInt32(&t);
    rc.version = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.session= (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.phase= (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.rat = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = readStringFromParcelInplace(p, rc.logicalModemUuid, sizeof(rc.logicalModemUuid));
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    rc.status = (int)t;

    if (status != NO_ERROR) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%s [version:%d, session:%d, phase:%d, rat:%d, logicalModemUuid:%s, status:%d",
            printBuf, rc.version, rc.session, rc.phase, rc.rat, rc.logicalModemUuid, rc.status);

    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber,
                &rc,
                sizeof(RIL_RadioCapability),
                pRI, pRI->socket_id);
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

#if 0
static int
blockingWrite(int fd, const void *buffer, size_t len) {
    size_t writeOffset = 0;
    const uint8_t *toWrite;

    toWrite = (const uint8_t *)buffer;

    while (writeOffset < len) {
        ssize_t written;
        do {
            written = write (fd, toWrite + writeOffset,
                                len - writeOffset);
        } while (written < 0 && ((errno == EINTR) || (errno == EAGAIN)));

        if (written >= 0) {
            writeOffset += written;
        } else {   // written < 0
            RLOGE ("RIL Response: unexpected error on write errno:%d", errno);
            close(fd);
            return -1;
        }
    }
#if VDBG
    RLOGE("RIL Response bytes written:%d", writeOffset);
#endif
    return 0;
}

static int
sendResponseRaw (const void *data, size_t dataSize, RIL_SOCKET_ID socket_id) {
    int fd = s_ril_param_socket.fdCommand;
    int ret;
    uint32_t header;
    pthread_mutex_t * writeMutexHook = &s_writeMutex;

#if VDBG
    RLOGE("Send Response to %s", rilSocketIdToString(socket_id));
#endif

#if (SIM_COUNT >= 2)
    if (socket_id == RIL_SOCKET_2) {
        fd = s_ril_param_socket2.fdCommand;
        writeMutexHook = &s_writeMutex_socket2;
    }
#if (SIM_COUNT >= 3)
    else if (socket_id == RIL_SOCKET_3) {
        fd = s_ril_param_socket3.fdCommand;
        writeMutexHook = &s_writeMutex_socket3;
    }
#endif
#if (SIM_COUNT >= 4)
    else if (socket_id == RIL_SOCKET_4) {
        fd = s_ril_param_socket4.fdCommand;
        writeMutexHook = &s_writeMutex_socket4;
    }
#endif
#endif
    if (fd < 0) {
        return -1;
    }

    if (dataSize > MAX_COMMAND_BYTES) {
        RLOGE("RIL: packet larger than %u (%u)",
                MAX_COMMAND_BYTES, (unsigned int )dataSize);

        return -1;
    }

    pthread_mutex_lock(writeMutexHook);

    header = htonl(dataSize);

    ret = blockingWrite(fd, (void *)&header, sizeof(header));

    if (ret < 0) {
        pthread_mutex_unlock(writeMutexHook);
        return ret;
    }

    ret = blockingWrite(fd, data, dataSize);

    if (ret < 0) {
        pthread_mutex_unlock(writeMutexHook);
        return ret;
    }

    pthread_mutex_unlock(writeMutexHook);

    return 0;
}

static int
sendResponse (Parcel &p, RIL_SOCKET_ID socket_id) {
    printResponse;
    return sendResponseRaw(p.data(), p.dataSize(), socket_id);
}
#endif

/** response is an int* pointing to an array of ints */

static int
responseInts(Parcel &p, void *response, size_t responselen) {
    int numInts;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen % sizeof(int) != 0) {
        RLOGE("responseInts: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof(int));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int *p_int = (int *) response;

    numInts = responselen / sizeof(int);
    p.writeInt32 (numInts);

    /* each int*/
    startResponse;
    for (int i = 0 ; i < numInts ; i++) {
        appendPrintBuf("%s%d,", printBuf, p_int[i]);
        p.writeInt32(p_int[i]);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

// Response is an int or RIL_LastCallFailCauseInfo.
// Currently, only Shamu plans to use RIL_LastCallFailCauseInfo.
// TODO(yjl): Let all implementations use RIL_LastCallFailCauseInfo.
static int responseFailCause(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen == sizeof(int)) {
      startResponse;
      int *p_int = (int *) response;
      appendPrintBuf("%s%d,", printBuf, p_int[0]);
      p.writeInt32(p_int[0]);
      removeLastChar;
      closeResponse;
    } else if (responselen == sizeof(RIL_LastCallFailCauseInfo)) {
      startResponse;
      RIL_LastCallFailCauseInfo *p_fail_cause_info = (RIL_LastCallFailCauseInfo *) response;
      appendPrintBuf("%s[cause_code=%d,vendor_cause=%s]", printBuf, p_fail_cause_info->cause_code,
                     p_fail_cause_info->vendor_cause);
      p.writeInt32(p_fail_cause_info->cause_code);
      writeStringToParcel(p, p_fail_cause_info->vendor_cause);
      removeLastChar;
      closeResponse;
    } else {
      RLOGE("responseFailCause: invalid response length %d expected an int or "
            "RIL_LastCallFailCauseInfo", (int)responselen);
      return RIL_ERRNO_INVALID_RESPONSE;
    }

    return 0;
}

/** response is a char **, pointing to an array of char *'s
    The parcel will begin with the version */
static int responseStringsWithVersion(int version, Parcel &p, void *response, size_t responselen) {
    p.writeInt32(version);
    return responseStrings(p, response, responselen);
}

/** response is a char **, pointing to an array of char *'s */
static int responseStrings(Parcel &p, void *response, size_t responselen) {
    int numStrings;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }
    if (responselen % sizeof(char *) != 0) {
        RLOGE("responseStrings: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof(char *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (response == NULL) {
        p.writeInt32 (0);
    } else {
        char **p_cur = (char **) response;

        numStrings = responselen / sizeof(char *);
        p.writeInt32 (numStrings);

        /* each string*/
        startResponse;
        for (int i = 0 ; i < numStrings ; i++) {
            appendPrintBuf("%s%s,", printBuf, (char*)p_cur[i]);
            writeStringToParcel (p, p_cur[i]);
        }
        removeLastChar;
        closeResponse;
    }
    return 0;
}


/**
 * NULL strings are accepted
 * FIXME currently ignores responselen
 */
static int responseString(Parcel &p, void *response, size_t responselen) {
    /* one string only */
    startResponse;
    appendPrintBuf("%s%s", printBuf, (char*)response);
    closeResponse;

    writeStringToParcel(p, (const char *)response);
    return 0;
}

static int responseVoid(Parcel &p, void *response, size_t responselen) {
    startResponse;
    removeLastChar;
    return 0;
}

static int responseCallList(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof (RIL_Call *) != 0) {
        RLOGE("responseCallList: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_Call *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    /* number of call info's */
    num = responselen / sizeof(RIL_Call *);
    p.writeInt32(num);
    for (int i = 0 ; i < num ; i++) {
        RIL_Call *p_cur = ((RIL_Call **) response)[i];
        /* each call info */
        p.writeInt32(p_cur->state);
        p.writeInt32(p_cur->index);
        p.writeInt32(p_cur->toa);
        p.writeInt32(p_cur->isMpty);
        p.writeInt32(p_cur->isMT);
        p.writeInt32(p_cur->als);
        p.writeInt32(p_cur->isVoice);
        p.writeInt32(p_cur->isVoicePrivacy);
        /*add by hq for t106 emergency ecall begin*/
        if(p_cur->number!=NULL)
        {
            writeStringToParcel(p, p_cur->number);
        }
        else
        {
            writeStringToParcel(p, "");
        }   
        /*add by hq for t106 emergency ecall end*/
		
        p.writeInt32(p_cur->numberPresentation);
        
        /*add by hq for t106 emergency ecall begin*/
        if(p_cur->name!=NULL)
        {
            writeStringToParcel(p, p_cur->name);
        }
        else
        {
            writeStringToParcel(p, "");
        }
        /*add by hq for t106 emergency ecall end*/
        
        p.writeInt32(p_cur->namePresentation);
        // Remove when partners upgrade to version 3
        if ((s_callbacks.version < 3) || (p_cur->uusInfo == NULL || p_cur->uusInfo->uusData == NULL)) {
            p.writeInt32(0); /* UUS Information is absent */
        } else {
            RIL_UUS_Info *uusInfo = p_cur->uusInfo;
            p.writeInt32(1); /* UUS Information is present */
            p.writeInt32(uusInfo->uusType);
            p.writeInt32(uusInfo->uusDcs);
            p.writeInt32(uusInfo->uusLength);
            p.write(uusInfo->uusData, uusInfo->uusLength);
        }
        appendPrintBuf("%s[id=%d,%s,toa=%d,",
            printBuf,
            p_cur->index,
            callStateToString(p_cur->state),
            p_cur->toa);
        appendPrintBuf("%s%s,%s,als=%d,%s,%s,",
            printBuf,
            (p_cur->isMpty)?"conf":"norm",
            (p_cur->isMT)?"mt":"mo",
            p_cur->als,
            (p_cur->isVoice)?"voc":"nonvoc",
            (p_cur->isVoicePrivacy)?"evp":"noevp");
        appendPrintBuf("%s%s,cli=%d,name='%s',%d]",
            printBuf,
            p_cur->number,
            p_cur->numberPresentation,
            p_cur->name,
            p_cur->namePresentation);
        if(p_cur->isMT) {
            printf("[EVENT][MT_CALL] phone number is %s\n",p_cur->number);
        }
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseSMS(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_SMS_Response) ) {
        RLOGE("invalid response length %d expected %d",
                (int)responselen, (int)sizeof (RIL_SMS_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SMS_Response *p_cur = (RIL_SMS_Response *) response;

    p.writeInt32(p_cur->messageRef);
    writeStringToParcel(p, p_cur->ackPDU);
    p.writeInt32(p_cur->errorCode);

    startResponse;
    appendPrintBuf("%s%d,%s,%d", printBuf, p_cur->messageRef,
        (char*)p_cur->ackPDU, p_cur->errorCode);
    closeResponse;
    bool ifResend;
    if(isGostEcall())
    {
        if(p_cur->errorCode == 0)
        {
            //delete MSD
            gostDelSaveSmsData();
            //no resend
            ifResend = false;
        }
        else
        {
            //resend MSD
            ifResend = true;
        }
        gostEcallResendMsd(ifResend);
    }
    return 0;
}

static int responseDataCallListV4(Parcel &p, void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Data_Call_Response_v4) != 0) {
        RLOGE("responseDataCallListV4: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Data_Call_Response_v4));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(4);

    int num = responselen / sizeof(RIL_Data_Call_Response_v4);
    p.writeInt32(num);

    RIL_Data_Call_Response_v4 *p_cur = (RIL_Data_Call_Response_v4 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        // apn is not used, so don't send.
        writeStringToParcel(p, p_cur[i].address);
        appendPrintBuf("%s[cid=%d,%s,%s,%s],", printBuf,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].address);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseDataCallListV6(Parcel &p, void *response, size_t responselen)
{
//xf.il@20230610 modify for T106 data start
    RLOGD("RIL.CPP: in responseDataCallListV6\n");
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Data_Call_Response_v6) != 0) {
        RLOGE("responseDataCallListV6: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Data_Call_Response_v6));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(6);

    int num = responselen / sizeof(RIL_Data_Call_Response_v6);
    p.writeInt32(num);

    RIL_Data_Call_Response_v6 *p_cur = (RIL_Data_Call_Response_v6 *) response;
    startResponse;
    int i;

    for (i = 0; i < num; i++) {

        RLOGD("LYNQ_READ_PCUR: [status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s],",
            p_cur[i].status,
            p_cur[i].suggestedRetryTime,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].ifname,
            (char*)p_cur[i].addresses,
            (char*)p_cur[i].dnses,
            (char*)p_cur[i].gateways);
//xf.il@20230610 modify for T106 data end
        p.writeInt32((int)p_cur[i].status);
        p.writeInt32(p_cur[i].suggestedRetryTime);
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        writeStringToParcel(p, p_cur[i].ifname);
        writeStringToParcel(p, p_cur[i].addresses);
        writeStringToParcel(p, p_cur[i].dnses);
        writeStringToParcel(p, p_cur[i].gateways);

        appendPrintBuf("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s],", printBuf,
            p_cur[i].status,
            p_cur[i].suggestedRetryTime,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].ifname,
            (char*)p_cur[i].addresses,
            (char*)p_cur[i].dnses,
            (char*)p_cur[i].gateways);
    }
    removeLastChar;
    closeResponse;
    return 0;
}

static int responseDataCallListV9(Parcel &p, void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Data_Call_Response_v9) != 0) {
        RLOGE("responseDataCallListV9: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Data_Call_Response_v9));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(10);

    int num = responselen / sizeof(RIL_Data_Call_Response_v9);
    p.writeInt32(num);

    RIL_Data_Call_Response_v9 *p_cur = (RIL_Data_Call_Response_v9 *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur[i].status);
        p.writeInt32(p_cur[i].suggestedRetryTime);
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        writeStringToParcel(p, p_cur[i].ifname);
        writeStringToParcel(p, p_cur[i].addresses);
        writeStringToParcel(p, p_cur[i].dnses);
        writeStringToParcel(p, p_cur[i].gateways);
        writeStringToParcel(p, p_cur[i].pcscf);
        appendPrintBuf("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s,%s],", printBuf,
            p_cur[i].status,
            p_cur[i].suggestedRetryTime,
            p_cur[i].cid,
            (p_cur[i].active==0)?"down":"up",
            (char*)p_cur[i].type,
            (char*)p_cur[i].ifname,
            (char*)p_cur[i].addresses,
            (char*)p_cur[i].dnses,
            (char*)p_cur[i].gateways,
            (char*)p_cur[i].pcscf);
    }
    removeLastChar;
    closeResponse;

    return 0;
}
//LYNQ_MODIFY_ZXW_TASK794_CR2024120449D612E5_XF.Li_20241221_START
#ifdef MOBILETEK_TARGET_PLATFORM_T106
static int responseApnList(Parcel &p, void *response, size_t responselen)
{
    RLOGD("responseApnList: responselen = %d, sizeof(RIL_Apn_List_Response) = %d\n", responselen, sizeof(RIL_Apn_List_Response));
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_Apn_List_Response) != 0) {
        RLOGE("invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_Apn_List_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int num = responselen / sizeof(RIL_Apn_List_Response);
    p.writeInt32(num);
    RIL_Apn_List_Response *p_cur = (RIL_Apn_List_Response *) response;

    startResponse;
    int i;
    for(i = 0; i < num; i++)
    {
        if(p_cur[i].pdp_type == NULL || p_cur[i].apn == NULL || p_cur[i].pdp_addr == NULL)
        {
            RLOGE("invalid response: NULL");
            return RIL_ERRNO_INVALID_RESPONSE;
        }
        RLOGI("LYNQ:[cid=%d,%s,%s,%s,%d,%d,%d,%d,%d,%d]",
        p_cur[i].cid,
        (char*)p_cur[i].pdp_type,
        (char*)p_cur[i].apn,
        (char*)p_cur[i].pdp_addr,
        p_cur[i].d_comp,
        p_cur[i].h_comp,
        p_cur[i].IPv4AddrAlloc,
        p_cur[i].Emergency_Indication,
        p_cur[i].P_CSCF_discovery,
        p_cur[i].IM_CN_Signalling_Flag_Ind);

        p.writeInt32(p_cur[i].cid);
        writeStringToParcel(p, p_cur[i].pdp_type);
        writeStringToParcel(p, p_cur[i].apn);
        writeStringToParcel(p, p_cur[i].pdp_addr);
        p.writeInt32(p_cur[i].d_comp);
        p.writeInt32(p_cur[i].h_comp);
        p.writeInt32(p_cur[i].IPv4AddrAlloc);
        p.writeInt32(p_cur[i].Emergency_Indication);
        p.writeInt32(p_cur[i].P_CSCF_discovery);
        p.writeInt32(p_cur[i].IM_CN_Signalling_Flag_Ind);
    }
    removeLastChar;
    closeResponse;
    return 0;
}
#endif
//LYNQ_MODIFY_ZXW_TASK794_CR2024120449D612E5_XF.Li_20241221_END
static int responseDataCallList(Parcel &p, void *response, size_t responselen)
{
//xf.il@20230610 modify for T106 data start
    RLOGD("responseDataCallList: s_callbacks.version = %d, responselen = %d, sizeof(RIL_Data_Call_Response_v6) = %d\n", 
        s_callbacks.version, responselen, sizeof(RIL_Data_Call_Response_v6));
    if (s_callbacks.version < 5) {
        RLOGD("responseDataCallList: v4");
        return responseDataCallListV4(p, response, responselen);
    } else if (responselen % sizeof(RIL_Data_Call_Response_v6) == 0) {
        return responseDataCallListV6(p, response, responselen);
    } else if (responselen % sizeof(RIL_Data_Call_Response_v9) == 0) {
        return responseDataCallListV9(p, response, responselen);
    } else {
        if (response == NULL && responselen != 0) {
            RLOGE("invalid response: NULL");
            return RIL_ERRNO_INVALID_RESPONSE;
        }

        if (responselen % sizeof(RIL_Data_Call_Response_v11) != 0) {
            RLOGE("invalid response length %d expected multiple of %d",
                    (int)responselen, (int)sizeof(RIL_Data_Call_Response_v11));
            return RIL_ERRNO_INVALID_RESPONSE;
        }

        // Write version
        p.writeInt32(11);

        int num = responselen / sizeof(RIL_Data_Call_Response_v11);
        p.writeInt32(num);

        RIL_Data_Call_Response_v11 *p_cur = (RIL_Data_Call_Response_v11 *) response;
               
        startResponse;
        int i;
        for (i = 0; i < num; i++) {

        RLOGD("LYNQ:[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s,%s,mtu=%d],",
                p_cur[i].status,
                p_cur[i].suggestedRetryTime,
                p_cur[i].cid,
                (p_cur[i].active==0)?"down":"up",
                (char*)p_cur[i].type,
                (char*)p_cur[i].ifname,
                (char*)p_cur[i].addresses,
                (char*)p_cur[i].dnses,
                (char*)p_cur[i].gateways,
                (char*)p_cur[i].pcscf,
                p_cur[i].mtu);
//xf.li@20230531 modify for T106 data start end 

            p.writeInt32((int)p_cur[i].status);
            p.writeInt32(p_cur[i].suggestedRetryTime);
            p.writeInt32(p_cur[i].cid);
            p.writeInt32(p_cur[i].active);
            writeStringToParcel(p, p_cur[i].type);
            writeStringToParcel(p, p_cur[i].ifname);
            writeStringToParcel(p, p_cur[i].addresses);
            writeStringToParcel(p, p_cur[i].dnses);
            writeStringToParcel(p, p_cur[i].gateways);
            writeStringToParcel(p, p_cur[i].pcscf);
            p.writeInt32(p_cur[i].mtu);
            appendPrintBuf("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s,%s,mtu=%d],", printBuf,
                p_cur[i].status,
                p_cur[i].suggestedRetryTime,
                p_cur[i].cid,
                (p_cur[i].active==0)?"down":"up",
                (char*)p_cur[i].type,
                (char*)p_cur[i].ifname,
                (char*)p_cur[i].addresses,
                (char*)p_cur[i].dnses,
                (char*)p_cur[i].gateways,
                (char*)p_cur[i].pcscf,
                p_cur[i].mtu);
        }
        removeLastChar;
        closeResponse;
    }
    return 0;
}

static int responseSetupDataCall(Parcel &p, void *response, size_t responselen)
{
    if (s_callbacks.version < 5) {
        return responseStringsWithVersion(s_callbacks.version, p, response, responselen);
    } else {
        return responseDataCallList(p, response, responselen);
    }
}

static int responseRaw(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL with responselen != 0");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // The java code reads -1 size as null byte array
    if (response == NULL) {
        p.writeInt32(-1);
    } else {
        p.writeInt32(responselen);
        p.write(response, responselen);
    }

    startResponse;
    appendPrintBuf("%slen=%d,%s", printBuf, responselen, (char*)response);
    closeResponse;
    return 0;
}


static int responseSIM_IO(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_SIM_IO_Response) ) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SIM_IO_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SIM_IO_Response *p_cur = (RIL_SIM_IO_Response *) response;
    p.writeInt32(p_cur->sw1);
    p.writeInt32(p_cur->sw2);
    writeStringToParcel(p, p_cur->simResponse);

    startResponse;
    appendPrintBuf("%ssw1=0x%X,sw2=0x%X,%s", printBuf, p_cur->sw1, p_cur->sw2,
        (char*)p_cur->simResponse);
    closeResponse;


    return 0;
}

static int responseCallForwards(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_CallForwardInfo *) != 0) {
        RLOGE("responseCallForwards: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_CallForwardInfo *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    /* number of call info's */
    num = responselen / sizeof(RIL_CallForwardInfo *);
    p.writeInt32(num);

    startResponse;
    for (int i = 0 ; i < num ; i++) {
        RIL_CallForwardInfo *p_cur = ((RIL_CallForwardInfo **) response)[i];

        p.writeInt32(p_cur->status);
        p.writeInt32(p_cur->reason);
        p.writeInt32(p_cur->serviceClass);
        p.writeInt32(p_cur->toa);
        writeStringToParcel(p, p_cur->number);
        p.writeInt32(p_cur->timeSeconds);
        appendPrintBuf("%s[%s,reason=%d,cls=%d,toa=%d,%s,tout=%d],", printBuf,
            (p_cur->status==1)?"enable":"disable",
            p_cur->reason, p_cur->serviceClass, p_cur->toa,
            (char*)p_cur->number,
            p_cur->timeSeconds);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseSsn(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_SuppSvcNotification)) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SuppSvcNotification));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SuppSvcNotification *p_cur = (RIL_SuppSvcNotification *) response;
    p.writeInt32(p_cur->notificationType);
    p.writeInt32(p_cur->code);
    p.writeInt32(p_cur->index);
    p.writeInt32(p_cur->type);
    writeStringToParcel(p, p_cur->number);

    startResponse;
    appendPrintBuf("%s%s,code=%d,id=%d,type=%d,%s", printBuf,
        (p_cur->notificationType==0)?"mo":"mt",
         p_cur->code, p_cur->index, p_cur->type,
        (char*)p_cur->number);
    closeResponse;

    return 0;
}

static int responseCellList(Parcel &p, void *response, size_t responselen) {
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof (RIL_NeighboringCell *) != 0) {
        RLOGE("responseCellList: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_NeighboringCell *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    /* number of records */
    num = responselen / sizeof(RIL_NeighboringCell *);
    p.writeInt32(num);

    for (int i = 0 ; i < num ; i++) {
        RIL_NeighboringCell *p_cur = ((RIL_NeighboringCell **) response)[i];

        p.writeInt32(p_cur->rssi);
        writeStringToParcel (p, p_cur->cid);

        appendPrintBuf("%s[cid=%s,rssi=%d],", printBuf,
            p_cur->cid, p_cur->rssi);
    }
    removeLastChar;
    closeResponse;

    return 0;
}

/**
 * Marshall the signalInfoRecord into the parcel if it exists.
 */
static void marshallSignalInfoRecord(Parcel &p,
            RIL_CDMA_SignalInfoRecord &p_signalInfoRecord) {
    p.writeInt32(p_signalInfoRecord.isPresent);
    p.writeInt32(p_signalInfoRecord.signalType);
    p.writeInt32(p_signalInfoRecord.alertPitch);
    p.writeInt32(p_signalInfoRecord.signal);
}

static int responseCdmaInformationRecords(Parcel &p,
            void *response, size_t responselen) {
    int num;
    char* string8 = NULL;
    int buffer_lenght;
    RIL_CDMA_InformationRecord *infoRec;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_CDMA_InformationRecords)) {
        RLOGE("responseCdmaInformationRecords: invalid response length %d expected multiple of %d\n",
            (int)responselen, (int)sizeof (RIL_CDMA_InformationRecords *));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_CDMA_InformationRecords *p_cur =
                             (RIL_CDMA_InformationRecords *) response;
    num = MIN(p_cur->numberOfInfoRecs, RIL_CDMA_MAX_NUMBER_OF_INFO_RECS);

    startResponse;
    p.writeInt32(num);

    for (int i = 0 ; i < num ; i++) {
        infoRec = &p_cur->infoRec[i];
        p.writeInt32(infoRec->name);
        switch (infoRec->name) {
            case RIL_CDMA_DISPLAY_INFO_REC:
            case RIL_CDMA_EXTENDED_DISPLAY_INFO_REC:
                if (infoRec->rec.display.alpha_len >
                                         CDMA_ALPHA_INFO_BUFFER_LENGTH) {
                    RLOGE("invalid display info response length %d \
                          expected not more than %d\n",
                         (int)infoRec->rec.display.alpha_len,
                         CDMA_ALPHA_INFO_BUFFER_LENGTH);
                    return RIL_ERRNO_INVALID_RESPONSE;
                }
                string8 = (char*) malloc((infoRec->rec.display.alpha_len + 1)
                                                             * sizeof(char) );
                for (int i = 0 ; i < infoRec->rec.display.alpha_len ; i++) {
                    string8[i] = infoRec->rec.display.alpha_buf[i];
                }
                string8[(int)infoRec->rec.display.alpha_len] = '\0';
                writeStringToParcel(p, (const char*)string8);
                free(string8);
                string8 = NULL;
                break;
            case RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC:
            case RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC:
            case RIL_CDMA_CONNECTED_NUMBER_INFO_REC:
                if (infoRec->rec.number.len > CDMA_NUMBER_INFO_BUFFER_LENGTH) {
                    RLOGE("invalid display info response length %d \
                          expected not more than %d\n",
                         (int)infoRec->rec.number.len,
                         CDMA_NUMBER_INFO_BUFFER_LENGTH);
                    return RIL_ERRNO_INVALID_RESPONSE;
                }
                string8 = (char*) malloc((infoRec->rec.number.len + 1)
                                                             * sizeof(char) );
                for (int i = 0 ; i < infoRec->rec.number.len; i++) {
                    string8[i] = infoRec->rec.number.buf[i];
                }
                string8[(int)infoRec->rec.number.len] = '\0';
                writeStringToParcel(p, (const char*)string8);
                free(string8);
                string8 = NULL;
                p.writeInt32(infoRec->rec.number.number_type);
                p.writeInt32(infoRec->rec.number.number_plan);
                p.writeInt32(infoRec->rec.number.pi);
                p.writeInt32(infoRec->rec.number.si);
                break;
            case RIL_CDMA_SIGNAL_INFO_REC:
                p.writeInt32(infoRec->rec.signal.isPresent);
                p.writeInt32(infoRec->rec.signal.signalType);
                p.writeInt32(infoRec->rec.signal.alertPitch);
                p.writeInt32(infoRec->rec.signal.signal);

                appendPrintBuf("%sisPresent=%X, signalType=%X, \
                                alertPitch=%X, signal=%X, ",
                   printBuf, (int)infoRec->rec.signal.isPresent,
                   (int)infoRec->rec.signal.signalType,
                   (int)infoRec->rec.signal.alertPitch,
                   (int)infoRec->rec.signal.signal);
                removeLastChar;
                break;
            case RIL_CDMA_REDIRECTING_NUMBER_INFO_REC:
                if (infoRec->rec.redir.redirectingNumber.len >
                                              CDMA_NUMBER_INFO_BUFFER_LENGTH) {
                    RLOGE("invalid display info response length %d \
                          expected not more than %d\n",
                         (int)infoRec->rec.redir.redirectingNumber.len,
                         CDMA_NUMBER_INFO_BUFFER_LENGTH);
                    return RIL_ERRNO_INVALID_RESPONSE;
                }
                string8 = (char*) malloc((infoRec->rec.redir.redirectingNumber
                                          .len + 1) * sizeof(char) );
                for (int i = 0;
                         i < infoRec->rec.redir.redirectingNumber.len;
                         i++) {
                    string8[i] = infoRec->rec.redir.redirectingNumber.buf[i];
                }
                string8[(int)infoRec->rec.redir.redirectingNumber.len] = '\0';
                writeStringToParcel(p, (const char*)string8);
                free(string8);
                string8 = NULL;
                p.writeInt32(infoRec->rec.redir.redirectingNumber.number_type);
                p.writeInt32(infoRec->rec.redir.redirectingNumber.number_plan);
                p.writeInt32(infoRec->rec.redir.redirectingNumber.pi);
                p.writeInt32(infoRec->rec.redir.redirectingNumber.si);
                p.writeInt32(infoRec->rec.redir.redirectingReason);
                break;
            case RIL_CDMA_LINE_CONTROL_INFO_REC:
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlPolarityIncluded);
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlToggle);
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlReverse);
                p.writeInt32(infoRec->rec.lineCtrl.lineCtrlPowerDenial);

                appendPrintBuf("%slineCtrlPolarityIncluded=%d, \
                                lineCtrlToggle=%d, lineCtrlReverse=%d, \
                                lineCtrlPowerDenial=%d, ", printBuf,
                       (int)infoRec->rec.lineCtrl.lineCtrlPolarityIncluded,
                       (int)infoRec->rec.lineCtrl.lineCtrlToggle,
                       (int)infoRec->rec.lineCtrl.lineCtrlReverse,
                       (int)infoRec->rec.lineCtrl.lineCtrlPowerDenial);
                removeLastChar;
                break;
            case RIL_CDMA_T53_CLIR_INFO_REC:
                p.writeInt32((int)(infoRec->rec.clir.cause));

                appendPrintBuf("%scause%d", printBuf, infoRec->rec.clir.cause);
                removeLastChar;
                break;
            case RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC:
                p.writeInt32(infoRec->rec.audioCtrl.upLink);
                p.writeInt32(infoRec->rec.audioCtrl.downLink);

                appendPrintBuf("%supLink=%d, downLink=%d, ", printBuf,
                        infoRec->rec.audioCtrl.upLink,
                        infoRec->rec.audioCtrl.downLink);
                removeLastChar;
                break;
            case RIL_CDMA_T53_RELEASE_INFO_REC:
                // TODO(Moto): See David Krause, he has the answer:)
                RLOGE("RIL_CDMA_T53_RELEASE_INFO_REC: return INVALID_RESPONSE");
                return RIL_ERRNO_INVALID_RESPONSE;
            default:
                RLOGE("Incorrect name value");
                return RIL_ERRNO_INVALID_RESPONSE;
        }
    }
    closeResponse;

    return 0;
}

static int responseRilSignalStrength(Parcel &p,
                    void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen >= sizeof (RIL_SignalStrength_v5)) {
#ifdef TELEMATIC_5G_SUPPORT
        RIL_SignalStrength_v14 *p_cur = ((RIL_SignalStrength_v14 *) response);
#else
        RIL_SignalStrength_v10 *p_cur = ((RIL_SignalStrength_v10 *) response);
#endif
        p.writeInt32(p_cur->GW_SignalStrength.signalStrength);
        p.writeInt32(p_cur->GW_SignalStrength.bitErrorRate);
        p.writeInt32(p_cur->GW_SignalStrength.timingAdvance);
        p.writeInt32(p_cur->CDMA_SignalStrength.dbm);
        p.writeInt32(p_cur->CDMA_SignalStrength.ecio);
        p.writeInt32(p_cur->EVDO_SignalStrength.dbm);
        p.writeInt32(p_cur->EVDO_SignalStrength.ecio);
        p.writeInt32(p_cur->EVDO_SignalStrength.signalNoiseRatio);
        p.writeInt32(p_cur->LTE_SignalStrength.signalStrength);
        p.writeInt32(p_cur->LTE_SignalStrength.rsrp);
        p.writeInt32(p_cur->LTE_SignalStrength.rsrq);
        p.writeInt32(p_cur->LTE_SignalStrength.rssnr);
        p.writeInt32(p_cur->LTE_SignalStrength.cqi);
        p.writeInt32(p_cur->LTE_SignalStrength.timingAdvance);
        p.writeInt32(p_cur->TD_SCDMA_SignalStrength.signalStrength);
        p.writeInt32(p_cur->TD_SCDMA_SignalStrength.bitErrorRate);
        p.writeInt32(p_cur->TD_SCDMA_SignalStrength.rscp);
        p.writeInt32(p_cur->WCDMA_SignalStrength.signalStrength);
        p.writeInt32(p_cur->WCDMA_SignalStrength.bitErrorRate);
        p.writeInt32(p_cur->WCDMA_SignalStrength.rscp);
        p.writeInt32(p_cur->WCDMA_SignalStrength.ecno);
#ifdef TELEMATIC_5G_SUPPORT
        if(responselen >= sizeof (RIL_SignalStrength_v14))
        {
            p.writeInt32(p_cur->NR_SignalStrength.ssRsrp);
            p.writeInt32(p_cur->NR_SignalStrength.ssRsrq);
            p.writeInt32(p_cur->NR_SignalStrength.ssSinr);
            p.writeInt32(p_cur->NR_SignalStrength.csiRsrp);
            p.writeInt32(p_cur->NR_SignalStrength.csiRsrq);
            p.writeInt32(p_cur->NR_SignalStrength.csiSinr);
        }
        else
        {
            memset(&(p_cur->NR_SignalStrength), 0, sizeof(p_cur->NR_SignalStrength));
        }
#endif
        startResponse;

#ifdef TELEMATIC_5G_SUPPORT
        appendPrintBuf("%s[GW.rssi=%d,GW.bER=%d,GW.tA=%d,"
                "W.rssi=%d,W.bER=%d,W.rscp=%d,W.ecno=%d,"                
                "LTE.rssi=%d,LTE.rsrp=%d,LTE.rsrq=%d,LTE.rssnr=%d,LTE.cqi=%d,LTE.tA=%d,"                
                "NR.ssRsrp=%d,NR.ssRsrq=%d,NR.ssSinr=%d,"
                "NR.csiRsrp=%d,NR.csiRsrq=%d,NR.csiSinr=%d,"
                "CD.dbm=%d,CD.ecio=%d,"
                "EV.dbm=%d,EV.ecio=%d,EV.SNR=%d,"
                "TD.rssi=%d,TD.bER=%d,TD.rscp=%d]",                
                printBuf,
                p_cur->GW_SignalStrength.signalStrength,
                p_cur->GW_SignalStrength.bitErrorRate,
                p_cur->GW_SignalStrength.timingAdvance,
                p_cur->WCDMA_SignalStrength.signalStrength,
                p_cur->WCDMA_SignalStrength.bitErrorRate,
                p_cur->WCDMA_SignalStrength.rscp,
                p_cur->WCDMA_SignalStrength.ecno,               
                p_cur->LTE_SignalStrength.signalStrength,
                p_cur->LTE_SignalStrength.rsrp,
                p_cur->LTE_SignalStrength.rsrq,
                p_cur->LTE_SignalStrength.rssnr,
                p_cur->LTE_SignalStrength.cqi,
                p_cur->LTE_SignalStrength.timingAdvance,             
                p_cur->NR_SignalStrength.ssRsrp,
                p_cur->NR_SignalStrength.ssRsrq,
                p_cur->NR_SignalStrength.ssSinr,
                p_cur->NR_SignalStrength.csiRsrp,
                p_cur->NR_SignalStrength.csiRsrq,
                p_cur->NR_SignalStrength.csiSinr,
                p_cur->CDMA_SignalStrength.dbm,
                p_cur->CDMA_SignalStrength.ecio,
                p_cur->EVDO_SignalStrength.dbm,
                p_cur->EVDO_SignalStrength.ecio,
                p_cur->EVDO_SignalStrength.signalNoiseRatio,
                p_cur->TD_SCDMA_SignalStrength.signalStrength,
                p_cur->TD_SCDMA_SignalStrength.bitErrorRate,
                p_cur->TD_SCDMA_SignalStrength.rscp);
#else
       appendPrintBuf("%s[GW.rssi=%d,GW.bER=%d,GW.tA=%d,"
                "W.rssi=%d,W.bER=%d,W.rscp=%d,W.ecno=%d,"                
                "LTE.rssi=%d,LTE.rsrp=%d,LTE.rsrq=%d,LTE.rssnr=%d,LTE.cqi=%d,LTE.tA=%d,"                
                "CD.dbm=%d,CD.ecio=%d,"
                "EV.dbm=%d,EV.ecio=%d,EV.SNR=%d,"
                "TD.rssi=%d,TD.bER=%d,TD.rscp=%d]",              
                printBuf,
                p_cur->GW_SignalStrength.signalStrength,
                p_cur->GW_SignalStrength.bitErrorRate,
                p_cur->GW_SignalStrength.timingAdvance,
                p_cur->WCDMA_SignalStrength.signalStrength,
                p_cur->WCDMA_SignalStrength.bitErrorRate,
                p_cur->WCDMA_SignalStrength.rscp,
                p_cur->WCDMA_SignalStrength.ecno,               
                p_cur->LTE_SignalStrength.signalStrength,
                p_cur->LTE_SignalStrength.rsrp,
                p_cur->LTE_SignalStrength.rsrq,
                p_cur->LTE_SignalStrength.rssnr,
                p_cur->LTE_SignalStrength.cqi,
                p_cur->LTE_SignalStrength.timingAdvance,                          
                p_cur->CDMA_SignalStrength.dbm,
                p_cur->CDMA_SignalStrength.ecio,
                p_cur->EVDO_SignalStrength.dbm,
                p_cur->EVDO_SignalStrength.ecio,
                p_cur->EVDO_SignalStrength.signalNoiseRatio,
                p_cur->TD_SCDMA_SignalStrength.signalStrength,
                p_cur->TD_SCDMA_SignalStrength.bitErrorRate,
                p_cur->TD_SCDMA_SignalStrength.rscp);
#endif
        closeResponse;

        if (signal_strength_printf != 0) {
            printf(
                    "\n\n[QUERY][SIGNAL]\nsignalStrength=%d,\nbitErrorRate=%d,\nLTE_SS.signalStrength=%d,\n"
                            "LTE_SS.rsrp=%d,\nLTE_SS.rsrq=%d,\nLTE_SS.rssnr=%d,\nLTE_SS.cqi=%d\n\n",
                    p_cur->GW_SignalStrength.signalStrength,
                    p_cur->GW_SignalStrength.bitErrorRate,
                    p_cur->LTE_SignalStrength.signalStrength,
                    p_cur->LTE_SignalStrength.rsrp,
                    p_cur->LTE_SignalStrength.rsrq,
                    p_cur->LTE_SignalStrength.rssnr,
                    p_cur->LTE_SignalStrength.cqi);
        }
    } else {
        RLOGE("invalid response length");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    return 0;
}

static int responseCallRing(Parcel &p, void *response, size_t responselen) {
    if ((response == NULL) || (responselen == 0)) {
        return responseVoid(p, response, responselen);
    } else {
        return responseCdmaSignalInfoRecord(p, response, responselen);
    }
}

static int responseCdmaSignalInfoRecord(Parcel &p, void *response, size_t responselen) {
    if (response == NULL || responselen == 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_CDMA_SignalInfoRecord)) {
        RLOGE("invalid response length %d expected sizeof (RIL_CDMA_SignalInfoRecord) of %d\n",
            (int)responselen, (int)sizeof (RIL_CDMA_SignalInfoRecord));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;

    RIL_CDMA_SignalInfoRecord *p_cur = ((RIL_CDMA_SignalInfoRecord *) response);
    marshallSignalInfoRecord(p, *p_cur);

    appendPrintBuf("%s[isPresent=%d,signalType=%d,alertPitch=%d\
              signal=%d]",
              printBuf,
              p_cur->isPresent,
              p_cur->signalType,
              p_cur->alertPitch,
              p_cur->signal);

    closeResponse;
    return 0;
}

static int responseCdmaCallWaiting(Parcel &p, void *response,
            size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen < sizeof(RIL_CDMA_CallWaiting_v6)) {
        RLOGW("Upgrade to ril version %d\n", RIL_VERSION);
    }

    RIL_CDMA_CallWaiting_v6 *p_cur = ((RIL_CDMA_CallWaiting_v6 *) response);

    writeStringToParcel(p, p_cur->number);
    p.writeInt32(p_cur->numberPresentation);
    writeStringToParcel(p, p_cur->name);
    marshallSignalInfoRecord(p, p_cur->signalInfoRecord);

    if (responselen >= sizeof(RIL_CDMA_CallWaiting_v6)) {
        p.writeInt32(p_cur->number_type);
        p.writeInt32(p_cur->number_plan);
    } else {
        p.writeInt32(0);
        p.writeInt32(0);
    }

    printf("[EVENT][MT_CALL] phone number is %s\n",p_cur->number);
    startResponse;
    appendPrintBuf("%snumber=%s,numberPresentation=%d, name=%s,\
            signalInfoRecord[isPresent=%d,signalType=%d,alertPitch=%d\
            signal=%d,number_type=%d,number_plan=%d]",
            printBuf,
            p_cur->number,
            p_cur->numberPresentation,
            p_cur->name,
            p_cur->signalInfoRecord.isPresent,
            p_cur->signalInfoRecord.signalType,
            p_cur->signalInfoRecord.alertPitch,
            p_cur->signalInfoRecord.signal,
            p_cur->number_type,
            p_cur->number_plan);
    closeResponse;

    return 0;
}

static int responseSimRefresh(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
        RLOGE("responseSimRefresh: invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    if (s_callbacks.version == 7) {
        RIL_SimRefreshResponse_v7 *p_cur = ((RIL_SimRefreshResponse_v7 *) response);
        p.writeInt32(p_cur->result);
        p.writeInt32(p_cur->ef_id);
        writeStringToParcel(p, p_cur->aid);

        appendPrintBuf("%sresult=%d, ef_id=%d, aid=%s",
                printBuf,
                p_cur->result,
                p_cur->ef_id,
                p_cur->aid);
    } else {
        int *p_cur = ((int *) response);
        p.writeInt32(p_cur[0]);
        p.writeInt32(p_cur[1]);
        writeStringToParcel(p, NULL);

        appendPrintBuf("%sresult=%d, ef_id=%d",
                printBuf,
                p_cur[0],
                p_cur[1]);
    }
    closeResponse;

    return 0;
}

static int responseCellInfoList(Parcel &p, void *response, size_t responselen)
{
    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(RIL_CellInfo) != 0) {
        RLOGE("responseCellInfoList: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_CellInfo));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    int num = responselen / sizeof(RIL_CellInfo);
    p.writeInt32(num);

    RIL_CellInfo *p_cur = (RIL_CellInfo *) response;
    startResponse;
    int i;
    for (i = 0; i < num; i++) {
        appendPrintBuf("%s[%d: type=%d,registered=%d,timeStampType=%d,timeStamp=%lld", printBuf, i,
            p_cur->cellInfoType, p_cur->registered, p_cur->timeStampType, p_cur->timeStamp);
        p.writeInt32((int)p_cur->cellInfoType);
        p.writeInt32(p_cur->registered);
        p.writeInt32(p_cur->timeStampType);
        p.writeInt64(p_cur->timeStamp);
        switch(p_cur->cellInfoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                appendPrintBuf("%s GSM id: mcc=%d,mnc=%d,lac=%d,cid=%d,", printBuf,
                    p_cur->CellInfo.gsm.cellIdentityGsm.mcc,
                    p_cur->CellInfo.gsm.cellIdentityGsm.mnc,
                    p_cur->CellInfo.gsm.cellIdentityGsm.lac,
                    p_cur->CellInfo.gsm.cellIdentityGsm.cid);
                appendPrintBuf("%s gsmSS: ss=%d,ber=%d],", printBuf,
                    p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength,
                    p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);

                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mcc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mnc);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.lac);
                p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.cid);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength);
                p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                appendPrintBuf("%s WCDMA id: mcc=%d,mnc=%d,lac=%d,cid=%d,psc=%d,", printBuf,
                    p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc,
                    p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc,
                    p_cur->CellInfo.wcdma.cellIdentityWcdma.lac,
                    p_cur->CellInfo.wcdma.cellIdentityWcdma.cid,
                    p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);
                appendPrintBuf("%s wcdmaSS: ss=%d,ber=%d],", printBuf,
                    p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength,
                    p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);

                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.lac);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.cid);
                p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength);
                p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                appendPrintBuf("%s CDMA id: nId=%d,sId=%d,bsId=%d,long=%d,lat=%d", printBuf,
                    p_cur->CellInfo.cdma.cellIdentityCdma.networkId,
                    p_cur->CellInfo.cdma.cellIdentityCdma.systemId,
                    p_cur->CellInfo.cdma.cellIdentityCdma.basestationId,
                    p_cur->CellInfo.cdma.cellIdentityCdma.longitude,
                    p_cur->CellInfo.cdma.cellIdentityCdma.latitude);

                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.networkId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.systemId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.basestationId);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.longitude);
                p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.latitude);

                appendPrintBuf("%s cdmaSS: dbm=%d ecio=%d evdoSS: dbm=%d,ecio=%d,snr=%d", printBuf,
                    p_cur->CellInfo.cdma.signalStrengthCdma.dbm,
                    p_cur->CellInfo.cdma.signalStrengthCdma.ecio,
                    p_cur->CellInfo.cdma.signalStrengthEvdo.dbm,
                    p_cur->CellInfo.cdma.signalStrengthEvdo.ecio,
                    p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);

                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.dbm);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.ecio);
                p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {
                /*Typethree add for T800 earfcn 2022/06/09 start*/
                appendPrintBuf("%s LTE id: mcc=%d,mnc=%d,ci=%d,pci=%d,tac=%d,earfcn=%d", printBuf,
                    p_cur->CellInfo.lte.cellIdentityLte.mcc,
                    p_cur->CellInfo.lte.cellIdentityLte.mnc,
                    p_cur->CellInfo.lte.cellIdentityLte.ci,
                    p_cur->CellInfo.lte.cellIdentityLte.pci,
                    p_cur->CellInfo.lte.cellIdentityLte.tac,
                    p_cur->CellInfo.lte.cellIdentityLte.earfcn);

                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mcc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mnc);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.ci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.pci);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.tac);
                p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.earfcn);
                /*Typethree add for T800 earfcn 2022/06/09 end*/
                appendPrintBuf("%s lteSS: ss=%d,rsrp=%d,rsrq=%d,rssnr=%d,cqi=%d,ta=%d", printBuf,
                    p_cur->CellInfo.lte.signalStrengthLte.signalStrength,
                    p_cur->CellInfo.lte.signalStrengthLte.rsrp,
                    p_cur->CellInfo.lte.signalStrengthLte.rsrq,
                    p_cur->CellInfo.lte.signalStrengthLte.rssnr,
                    p_cur->CellInfo.lte.signalStrengthLte.cqi,
                    p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.signalStrength);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrp);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrq);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rssnr);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.cqi);
                p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                appendPrintBuf("%s TDSCDMA id: mcc=%d,mnc=%d,lac=%d,cid=%d,cpid=%d,", printBuf,
                    p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc,
                    p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc,
                    p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac,
                    p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid,
                    p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                appendPrintBuf("%s tdscdmaSS: rscp=%d],", printBuf,
                    p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);

                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid);
                p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                p.writeInt32(p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);
                break;
            }
#ifdef TELEMATIC_5G_SUPPORT
            case RIL_CELL_INFO_TYPE_NR: {
                /*Typethree add for T800 5G cid 2022/06/09 start*/
                appendPrintBuf("%s NR id: mcc=%d,mnc=%d,nci=%llu,pci=%d,tac=%d", printBuf,
                    p_cur->CellInfo.nr.cellidentity.mcc,
                    p_cur->CellInfo.nr.cellidentity.mnc,
                    p_cur->CellInfo.nr.cellidentity.nci,
                    p_cur->CellInfo.nr.cellidentity.pci,
                    p_cur->CellInfo.nr.cellidentity.tac,
                    p_cur->CellInfo.nr.cellidentity.nrarfcn);

                p.writeInt32(p_cur->CellInfo.nr.cellidentity.mcc);
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.mnc);
                p.writeUint64(p_cur->CellInfo.nr.cellidentity.nci);
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.pci);
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.tac);
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.nrarfcn);
                /*Typethree add for T800 5G cid 2022/06/09 end*/
                appendPrintBuf("%s NRSS: ssRsrp=%d,ssRsrq=%d,ssSinr=%d,csiRsrp=%d,csiRsrq=%d,csiSinr=%d", printBuf,
                    p_cur->CellInfo.nr.signalStrength.ssRsrp,
                    p_cur->CellInfo.nr.signalStrength.ssRsrq,
                    p_cur->CellInfo.nr.signalStrength.ssSinr,
                    p_cur->CellInfo.nr.signalStrength.csiRsrp,
                    p_cur->CellInfo.nr.signalStrength.csiRsrq,
                    p_cur->CellInfo.nr.signalStrength.csiSinr);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.ssRsrp);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.ssRsrq);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.ssSinr);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.csiRsrp);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.csiRsrq);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.csiSinr);
                break;
            }
#endif
        }
        p_cur += 1;
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static int responseHardwareConfig(Parcel &p, void *response, size_t responselen)
{
   if (response == NULL && responselen != 0) {
       RLOGE("invalid response: NULL");
       return RIL_ERRNO_INVALID_RESPONSE;
   }

   if (responselen % sizeof(RIL_HardwareConfig) != 0) {
       RLOGE("responseHardwareConfig: invalid response length %d expected multiple of %d",
          (int)responselen, (int)sizeof(RIL_HardwareConfig));
       return RIL_ERRNO_INVALID_RESPONSE;
   }

   int num = responselen / sizeof(RIL_HardwareConfig);
   int i;
   RIL_HardwareConfig *p_cur = (RIL_HardwareConfig *) response;

   p.writeInt32(num);

   startResponse;
   for (i = 0; i < num; i++) {
      switch (p_cur[i].type) {
         case RIL_HARDWARE_CONFIG_MODEM: {
            writeStringToParcel(p, p_cur[i].uuid);
            p.writeInt32((int)p_cur[i].state);
            p.writeInt32(p_cur[i].cfg.modem.rat);
            p.writeInt32(p_cur[i].cfg.modem.maxVoice);
            p.writeInt32(p_cur[i].cfg.modem.maxData);
            p.writeInt32(p_cur[i].cfg.modem.maxStandby);

            appendPrintBuf("%s modem: uuid=%s,state=%d,rat=%08x,maxV=%d,maxD=%d,maxS=%d", printBuf,
               p_cur[i].uuid, (int)p_cur[i].state, p_cur[i].cfg.modem.rat,
               p_cur[i].cfg.modem.maxVoice, p_cur[i].cfg.modem.maxData, p_cur[i].cfg.modem.maxStandby);
            break;
         }
         case RIL_HARDWARE_CONFIG_SIM: {
            writeStringToParcel(p, p_cur[i].uuid);
            p.writeInt32((int)p_cur[i].state);
            writeStringToParcel(p, p_cur[i].cfg.sim.modemUuid);

            appendPrintBuf("%s sim: uuid=%s,state=%d,modem-uuid=%s", printBuf,
               p_cur[i].uuid, (int)p_cur[i].state, p_cur[i].cfg.sim.modemUuid);
            break;
         }
      }
   }
   removeLastChar;
   closeResponse;
   return 0;
}

static int responseRadioCapability(Parcel &p, void *response, size_t responselen) {
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_RadioCapability) ) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SIM_IO_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_RadioCapability *p_cur = (RIL_RadioCapability *) response;
    p.writeInt32(p_cur->version);
    p.writeInt32(p_cur->session);
    p.writeInt32(p_cur->phase);
    p.writeInt32(p_cur->rat);
    writeStringToParcel(p, p_cur->logicalModemUuid);
    p.writeInt32(p_cur->status);

    startResponse;
    appendPrintBuf("%s[version=%d,session=%d,phase=%d,\
            rat=%d,logicalModemUuid=%s,status=%d]",
            printBuf,
            p_cur->version,
            p_cur->session,
            p_cur->phase,
            p_cur->rat,
            p_cur->logicalModemUuid,
            p_cur->status);
    closeResponse;
    return 0;
}

static int responseSSData(Parcel &p, void *response, size_t responselen) {
    RLOGD("In responseSSData");
    int num;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof (RIL_SIM_IO_Response));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_StkCcUnsolSsResponse)) {
        RLOGE("invalid response length %d, expected %d",
               (int)responselen, (int)sizeof(RIL_StkCcUnsolSsResponse));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_StkCcUnsolSsResponse *p_cur = (RIL_StkCcUnsolSsResponse *) response;
    p.writeInt32(p_cur->serviceType);
    p.writeInt32(p_cur->requestType);
    p.writeInt32(p_cur->teleserviceType);
    p.writeInt32(p_cur->serviceClass);
    p.writeInt32(p_cur->result);

    if (isServiceTypeCfQuery(p_cur->serviceType, p_cur->requestType)) {
        RLOGD("responseSSData CF type, num of Cf elements %d", p_cur->cfData.numValidIndexes);
        if (p_cur->cfData.numValidIndexes > NUM_SERVICE_CLASSES) {
            RLOGE("numValidIndexes is greater than max value %d, "
                  "truncating it to max value", NUM_SERVICE_CLASSES);
            p_cur->cfData.numValidIndexes = NUM_SERVICE_CLASSES;
        }
        /* number of call info's */
        p.writeInt32(p_cur->cfData.numValidIndexes);

        for (int i = 0; i < p_cur->cfData.numValidIndexes; i++) {
             RIL_CallForwardInfo cf = p_cur->cfData.cfInfo[i];

             p.writeInt32(cf.status);
             p.writeInt32(cf.reason);
             p.writeInt32(cf.serviceClass);
             p.writeInt32(cf.toa);
             writeStringToParcel(p, cf.number);
             p.writeInt32(cf.timeSeconds);
             appendPrintBuf("%s[%s,reason=%d,cls=%d,toa=%d,%s,tout=%d],", printBuf,
                 (cf.status==1)?"enable":"disable", cf.reason, cf.serviceClass, cf.toa,
                  (char*)cf.number, cf.timeSeconds);
             RLOGD("Data: %d,reason=%d,cls=%d,toa=%d,num=%s,tout=%d],", cf.status,
                  cf.reason, cf.serviceClass, cf.toa, (char*)cf.number, cf.timeSeconds);
        }
    } else {
        p.writeInt32 (SS_INFO_MAX);

        /* each int*/
        for (int i = 0; i < SS_INFO_MAX; i++) {
             appendPrintBuf("%s%d,", printBuf, p_cur->ssInfo[i]);
             RLOGD("Data: %d",p_cur->ssInfo[i]);
             p.writeInt32(p_cur->ssInfo[i]);
        }
    }
    removeLastChar;
    closeResponse;

    return 0;
}

static bool isServiceTypeCfQuery(RIL_SsServiceType serType, RIL_SsRequestType reqType) {
    if ((reqType == SS_INTERROGATION) &&
        (serType == SS_CFU ||
         serType == SS_CF_BUSY ||
         serType == SS_CF_NO_REPLY ||
         serType == SS_CF_NOT_REACHABLE ||
         serType == SS_CF_ALL ||
         serType == SS_CF_ALL_CONDITIONAL)) {
        return true;
    }
    return false;
}

static void sendSimStatusAppInfo(Parcel &p, int num_apps, RIL_AppStatus appStatus[]) {
        p.writeInt32(num_apps);
        startResponse;
        for (int i = 0; i < num_apps; i++) {
            p.writeInt32(appStatus[i].app_type);
            p.writeInt32(appStatus[i].app_state);
            p.writeInt32(appStatus[i].perso_substate);
            writeStringToParcel(p, (const char*)(appStatus[i].aid_ptr));
            writeStringToParcel(p, (const char*)
                                          (appStatus[i].app_label_ptr));
            p.writeInt32(appStatus[i].pin1_replaced);
            p.writeInt32(appStatus[i].pin1);
            p.writeInt32(appStatus[i].pin2);
            appendPrintBuf("%s[app_type=%d,app_state=%d,perso_substate=%d,\
                    aid_ptr=%s,app_label_ptr=%s,pin1_replaced=%d,pin1=%d,pin2=%d],",
                    printBuf,
                    appStatus[i].app_type,
                    appStatus[i].app_state,
                    appStatus[i].perso_substate,
                    appStatus[i].aid_ptr,
                    appStatus[i].app_label_ptr,
                    appStatus[i].pin1_replaced,
                    appStatus[i].pin1,
                    appStatus[i].pin2);
        }
        closeResponse;
}

static int responseSimStatus(Parcel &p, void *response, size_t responselen) {
    int i;

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RLOGD("responselen: %d, v6: %d, v5: %d", responselen, sizeof (RIL_CardStatus_v6),sizeof (RIL_CardStatus_v5));
    if (responselen == sizeof (RIL_CardStatus_v6)) {
        RIL_CardStatus_v6 *p_cur = ((RIL_CardStatus_v6 *) response);
        p.writeInt32(p_cur->card_state);
        p.writeInt32(p_cur->universal_pin_state);
        p.writeInt32(p_cur->gsm_umts_subscription_app_index);
        p.writeInt32(p_cur->cdma_subscription_app_index);
        p.writeInt32(p_cur->ims_subscription_app_index);

        sendSimStatusAppInfo(p, p_cur->num_applications, p_cur->applications);
    } else if (responselen == sizeof (RIL_CardStatus_v5)) {
        RIL_CardStatus_v5 *p_cur = ((RIL_CardStatus_v5 *) response);

        p.writeInt32(p_cur->card_state);
        p.writeInt32(p_cur->universal_pin_state);
        p.writeInt32(p_cur->gsm_umts_subscription_app_index);
        p.writeInt32(p_cur->cdma_subscription_app_index);
        p.writeInt32(-1);

        sendSimStatusAppInfo(p, p_cur->num_applications, p_cur->applications);
    } else {
        RLOGE("responseSimStatus: A RilCardStatus_v6 or _v5 expected\n");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    return 0;
}

static int responseGsmBrSmsCnf(Parcel &p, void *response, size_t responselen) {
    int num = responselen / sizeof(RIL_GSM_BroadcastSmsConfigInfo *);
    p.writeInt32(num);

    startResponse;
    RIL_GSM_BroadcastSmsConfigInfo **p_cur =
                (RIL_GSM_BroadcastSmsConfigInfo **) response;
    for (int i = 0; i < num; i++) {
        p.writeInt32(p_cur[i]->fromServiceId);
        p.writeInt32(p_cur[i]->toServiceId);
        p.writeInt32(p_cur[i]->fromCodeScheme);
        p.writeInt32(p_cur[i]->toCodeScheme);
        p.writeInt32(p_cur[i]->selected);

        appendPrintBuf("%s [%d: fromServiceId=%d, toServiceId=%d, \
                fromCodeScheme=%d, toCodeScheme=%d, selected =%d]",
                printBuf, i, p_cur[i]->fromServiceId, p_cur[i]->toServiceId,
                p_cur[i]->fromCodeScheme, p_cur[i]->toCodeScheme,
                p_cur[i]->selected);
    }
    closeResponse;

    return 0;
}

static int responseCdmaBrSmsCnf(Parcel &p, void *response, size_t responselen) {
    RIL_CDMA_BroadcastSmsConfigInfo **p_cur =
               (RIL_CDMA_BroadcastSmsConfigInfo **) response;

    int num = responselen / sizeof (RIL_CDMA_BroadcastSmsConfigInfo *);
    p.writeInt32(num);

    startResponse;
    for (int i = 0 ; i < num ; i++ ) {
        p.writeInt32(p_cur[i]->service_category);
        p.writeInt32(p_cur[i]->language);
        p.writeInt32(p_cur[i]->selected);

        appendPrintBuf("%s [%d: srvice_category=%d, language =%d, \
              selected =%d], ",
              printBuf, i, p_cur[i]->service_category, p_cur[i]->language,
              p_cur[i]->selected);
    }
    closeResponse;

    return 0;
}

static int responseCdmaSms(Parcel &p, void *response, size_t responselen) {
    int num;
    int digitCount;
    int digitLimit;
    uint8_t uct;
    void* dest;

    RLOGD("Inside responseCdmaSms");

    if (response == NULL && responselen != 0) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof(RIL_CDMA_SMS_Message)) {
        RLOGE("invalid response length was %d expected %d",
                (int)responselen, (int)sizeof(RIL_CDMA_SMS_Message));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_CDMA_SMS_Message *p_cur = (RIL_CDMA_SMS_Message *) response;
    p.writeInt32(p_cur->uTeleserviceID);
    p.write(&(p_cur->bIsServicePresent),sizeof(uct));
    p.writeInt32(p_cur->uServicecategory);
    p.writeInt32(p_cur->sAddress.digit_mode);
    p.writeInt32(p_cur->sAddress.number_mode);
    p.writeInt32(p_cur->sAddress.number_type);
    p.writeInt32(p_cur->sAddress.number_plan);
    RLOGD("MT CDMA SMS: sAddress.number_plan = %d", p_cur->sAddress.number_plan);
    p.write(&(p_cur->sAddress.number_of_digits), sizeof(uct));
    RLOGD("MT CDMA SMS: sAddress.number_of_digits = %d", p_cur->sAddress.number_of_digits);
    digitLimit= MIN((p_cur->sAddress.number_of_digits), RIL_CDMA_SMS_ADDRESS_MAX);
    String8 str(""), temp;
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        p.write(&(p_cur->sAddress.digits[digitCount]),sizeof(uct));
        temp = String8::format("%d,", p_cur->sAddress.digits[digitCount]);
        str.append(temp);
    }
    RLOGD("MT CDMA SMS: sAddress.digits: {%s}", str.isEmpty()? "" : str.string());

    p.writeInt32(p_cur->sSubAddress.subaddressType);
    RLOGD("MT CDMA SMS: sSubAddress.subaddressType = %d", p_cur->sSubAddress.subaddressType);
    p.write(&(p_cur->sSubAddress.odd),sizeof(uct));
    RLOGD("MT CDMA SMS: sSubAddress.odd = %d", p_cur->sSubAddress.odd);
    p.write(&(p_cur->sSubAddress.number_of_digits),sizeof(uct));
    RLOGD("MT CDMA SMS: sSubAddress.number_of_digits = %d", p_cur->sSubAddress.number_of_digits);
    digitLimit= MIN((p_cur->sSubAddress.number_of_digits), RIL_CDMA_SMS_SUBADDRESS_MAX);
    str.clear();
    temp.clear();
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
        p.write(&(p_cur->sSubAddress.digits[digitCount]),sizeof(uct));
        temp = String8::format("%d,", p_cur->sSubAddress.digits[digitCount]);
        str.append(temp);
    }
    RLOGD("MT CDMA SMS: sSubAddress.digits: {%s}", str.isEmpty() ? "" : str.string());

    digitLimit= MIN((p_cur->uBearerDataLen), RIL_CDMA_SMS_BEARER_DATA_MAX);
    RLOGD("MT CDMA SMS: uBearerDataLen = %d", p_cur->uBearerDataLen);
    p.writeInt32(p_cur->uBearerDataLen);
    str.clear();
    temp.clear();
    for(digitCount =0 ; digitCount < digitLimit; digitCount ++) {
       p.write(&(p_cur->aBearerData[digitCount]), sizeof(uct));
       temp = String8::format("%d,", p_cur->aBearerData[digitCount]);
       str.append(temp);
    }
    RLOGD("MT CDMA SMS: aBearerData: {%s}", str.isEmpty() ? "" : str.string());

    startResponse;
    appendPrintBuf("%suTeleserviceID=%d, bIsServicePresent=%d, uServicecategory=%d, \
            sAddress.digit_mode=%d, sAddress.number_mode=%d, sAddress.number_type=%d, ",
            printBuf, p_cur->uTeleserviceID,p_cur->bIsServicePresent,p_cur->uServicecategory,
            p_cur->sAddress.digit_mode, p_cur->sAddress.number_mode,p_cur->sAddress.number_type);
    closeResponse;
    resposeCdmaSms(p_cur);
    return 0;
}

static int responseDcRtInfo(Parcel &p, void *response, size_t responselen)
{
    int num = responselen / sizeof(RIL_DcRtInfo);
    if ((responselen % sizeof(RIL_DcRtInfo) != 0) || (num != 1)) {
        RLOGE("responseDcRtInfo: invalid response length %d expected multiple of %d",
                (int)responselen, (int)sizeof(RIL_DcRtInfo));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    startResponse;
    RIL_DcRtInfo *pDcRtInfo = (RIL_DcRtInfo *)response;
    p.writeInt64(pDcRtInfo->time);
    p.writeInt32(pDcRtInfo->powerState);
    appendPrintBuf("%s[time=%d,powerState=%d]", printBuf,
        pDcRtInfo->time,
        pDcRtInfo->powerState);
    closeResponse;

    return 0;
}

static int responseLceStatus(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_LceStatusInfo)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseLceStatus: invalid response length %d expecting len: %d",
            sizeof(RIL_LceStatusInfo), responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_LceStatusInfo *p_cur = (RIL_LceStatusInfo *)response;
  p.write((void *)p_cur, 1);  // p_cur->lce_status takes one byte.
  p.writeInt32(p_cur->actual_interval_ms);

  startResponse;
  appendPrintBuf("LCE Status: %d, actual_interval_ms: %d",
                 p_cur->lce_status, p_cur->actual_interval_ms);
  closeResponse;

  return 0;
}

static int responseLceData(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_LceDataInfo)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseLceData: invalid response length %d expecting len: %d",
            sizeof(RIL_LceDataInfo), responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_LceDataInfo *p_cur = (RIL_LceDataInfo *)response;
  p.writeInt32(p_cur->last_hop_capacity_kbps);

  /* p_cur->confidence_level and p_cur->lce_suspended take 1 byte each.*/
  p.write((void *)&(p_cur->confidence_level), 1);
  p.write((void *)&(p_cur->lce_suspended), 1);

  startResponse;
  appendPrintBuf("LCE info received: capacity %d confidence level %d and suspended %d",
                  p_cur->last_hop_capacity_kbps, p_cur->confidence_level,
                  p_cur->lce_suspended);
  closeResponse;

  return 0;
}

static int responseActivityData(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_ActivityStatsInfo)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseActivityData: invalid response length %d expecting len: %d",
            sizeof(RIL_ActivityStatsInfo), responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_ActivityStatsInfo *p_cur = (RIL_ActivityStatsInfo *)response;
  p.writeInt32(p_cur->sleep_mode_time_ms);
  p.writeInt32(p_cur->idle_mode_time_ms);
  for(int i = 0; i < RIL_NUM_TX_POWER_LEVELS; i++) {
    p.writeInt32(p_cur->tx_mode_time_ms[i]);
  }
  p.writeInt32(p_cur->rx_mode_time_ms);

  startResponse;
  appendPrintBuf("Modem activity info received: sleep_mode_time_ms %d idle_mode_time_ms %d tx_mode_time_ms %d %d %d %d %d and rx_mode_time_ms %d",
                  p_cur->sleep_mode_time_ms, p_cur->idle_mode_time_ms, p_cur->tx_mode_time_ms[0],
                  p_cur->tx_mode_time_ms[1], p_cur->tx_mode_time_ms[2], p_cur->tx_mode_time_ms[3],
                  p_cur->tx_mode_time_ms[4], p_cur->rx_mode_time_ms);
   closeResponse;

  return 0;
}

static int responseSmsSimMemStatus(Parcel &p, void *response, size_t responselen) {
    printf("=============%s\n", __FUNCTION__);
    if (response == NULL) {
        RLOGE("invalid response: NULL");
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen != sizeof (RIL_SMS_Memory_Status) ) {
        RLOGE("invalid response length %d expected %d",
                (int)responselen, (int)sizeof (RIL_SMS_Memory_Status));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    RIL_SMS_Memory_Status *p_cur = (RIL_SMS_Memory_Status *) response;

    p.writeInt32(p_cur->used);
    p.writeInt32(p_cur->total);

    startResponse;
    appendPrintBuf("%s%d,%d", printBuf, p_cur->used, p_cur->total);
    closeResponse;

    printf("%s%d,%d\n", printBuf, p_cur->used, p_cur->total);
    RLOGE("===========================%s%d,%d", printBuf, p_cur->used, p_cur->total);
    return 0;
}

void RIL_startEventLoop(void);
extern "C" void
RIL_register (const RIL_RadioFunctions *callbacks) {
    if (callbacks == NULL) {
        RLOGE("RIL_register: RIL_RadioFunctions * null");
        return;
    }
#if 0
    if (callbacks->version < RIL_VERSION_MIN) {
        RLOGE("RIL_register: version %d is to old, min version is %d",
             callbacks->version, RIL_VERSION_MIN);
        return;
    }
    if (callbacks->version > RIL_VERSION) {
        RLOGE("RIL_register: version %d is too new, max version is %d",
             callbacks->version, RIL_VERSION);
        return;
    }
#endif
    RLOGE("RIL_register: RIL version %d", callbacks->version);

    if (s_registerCalled > 0) {
        RLOGE("RIL_register has been called more than once. "
                "Subsequent call ignored");
        return;
    }

    memcpy(&s_callbacks, callbacks, sizeof (RIL_RadioFunctions));

    s_registerCalled = 1;

    sendRequestToMd(RIL_REQUEST_RADIO_POWER, get_default_sim_all_except_data());
     initCoditions();

    pthread_mutex_lock(&s_InitMutex);
    if(utils::is_support_dsds()) {
        while (s_isConnected[0] == 0 || s_isConnected[1] == 0) {
          pthread_cond_wait(&s_InitCond, &s_InitMutex);
        }
    } else {
        while (s_isConnected[0] == 0 && s_isConnected[1] == 0) {
          pthread_cond_wait(&s_InitCond, &s_InitMutex);
        }
    }
    pthread_mutex_unlock(&s_InitMutex);
    //initCoditions();
    // New rild impl calls RIL_startEventLoop() first
    // old standalone impl wants it here.

    if (s_started == 0) {
        RIL_startEventLoop();
    }

}

#if 0
static int
checkAndDequeueRequestInfo(struct RequestInfo *pRI) {
    int ret = 0;
    /* Hook for current context
       pendingRequestsMutextHook refer to &s_pendingRequestsMutex */
    pthread_mutex_t* pendingRequestsMutexHook = &s_pendingRequestsMutex;
    /* pendingRequestsHook refer to &s_pendingRequests */
    RequestInfo ** pendingRequestsHook = &s_pendingRequests;

    if (pRI == NULL) {
        return 0;
    }

#if (SIM_COUNT >= 2)
    if (pRI->socket_id == RIL_SOCKET_2) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket2;
        pendingRequestsHook = &s_pendingRequests_socket2;
    }
#if (SIM_COUNT >= 3)
        if (pRI->socket_id == RIL_SOCKET_3) {
            pendingRequestsMutexHook = &s_pendingRequestsMutex_socket3;
            pendingRequestsHook = &s_pendingRequests_socket3;
        }
#endif
#if (SIM_COUNT >= 4)
    if (pRI->socket_id == RIL_SOCKET_4) {
        pendingRequestsMutexHook = &s_pendingRequestsMutex_socket4;
        pendingRequestsHook = &s_pendingRequests_socket4;
    }
#endif
#endif
    pthread_mutex_lock(pendingRequestsMutexHook);

    for(RequestInfo **ppCur = pendingRequestsHook
        ; *ppCur != NULL
        ; ppCur = &((*ppCur)->p_next)
    ) {
        if (pRI == *ppCur) {
            ret = 1;

            *ppCur = (*ppCur)->p_next;
            break;
        }
    }

    pthread_mutex_unlock(pendingRequestsMutexHook);

    return ret;
}

#endif

static void parse_version_buf(char *buf){
    char *p = buf;
    int flag = 0;
    int recv = 0;
    int tmp = -1;
    while (*p != '\0')
    {   
        recv++;
        if(*p == '"'){
            tmp = recv;        
        }
        if(tmp >= 0){
            buf[flag++] = buf[tmp++];
            if(buf[flag-1] == '\"'){
                buf[flag-1] = '\0';
            }
        }
        *p++;
    }
    return;
}

static int lynq_get_version(){
    FILE *fp;
    char buf[128] = {0};
    char cgmr[128] = {0};
    sprintf(buf, "uci get lynq_uci_ro.lynq_version.LYNQ_SW_VERSION 2>&1");
    fp=popen(buf, "r");
    int n;
    while(fgets(buf, sizeof(buf), fp) != NULL)
    {
    }
    //parse_version_buf(buf);
    sprintf(cgmr, "%s %s", "+CGMR:", buf);
    n = write(ttyGS3_fd,cgmr,strlen(cgmr));
    if(n<0)
    {
        perror("lynq resp write:");
    }
    pclose(fp);
    return 0;
}

static int lynq_get_inside_version(){
    FILE *fp;
    char buf[128] = {0};
    char cgmr[128] = {0};
    sprintf(buf, "uci get lynq_uci_ro.lynq_version.LYNQ_SW_INSIDE_VERSION 2>&1");
    fp=popen(buf, "r");
    int n;
    while(fgets(buf, sizeof(buf), fp) != NULL)
    {
    }
    //parse_version_buf(buf);
    sprintf(cgmr, "%s %s", "+CGIR:", buf);
    n = write(ttyGS3_fd,cgmr,strlen(cgmr));
    if(n<0)
    {
        perror("lynq resp write:");
    }
    pclose(fp);
    return 0;
}

/**
 * @brief cgmr ---> cgir
 * 
 * @param response 
 */
static void parse_inside_version(void *response)
{
    char *p = (char *)response;
    while (*p != 0)
    {
        if(*p == 'M')
        {
            *p = 'I';
            break;
        }
        else
        {
            *p ++;
        }
    }
    return;
}

/**
 * @brief To handle comma-separated strings, take the character before the first comma  eg:123456,78 ->123456
 * 
 * @param buf Type:[IN]
 */
static void parse_imei(char buf[])
{
    if(NULL == buf)
    {
        return;
    }
    const char s[2] = ",";
    char *token;
    token = strtok(buf, s);
    return;
}

static char * lynqStrdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

static void lynq_get_mccmnc(Parcel &p, char *mccmnc)
{
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        int resp_type;
        int token;
        int request;
        int slot_id;
        int error1;
        int num;
        char *resp[128];
        p.readInt32(&resp_type);
        p.readInt32(&token);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        if(!error1)
        {
            p.readInt32(&num);
            if(num == 0 || num > 128)
            {
                LYERRLOG("no paramters or num %d too great",num);
            }
            else
            {
                int i;
                for(i = 0; i<num;i++)
                {
                    resp[i] = lynqStrdupReadString(p);
                }
                if(NULL != resp[2])
                {
                    strcpy(mccmnc,resp[2]);
                    printf("mcc mnc %s\n", mccmnc);
                }
                for(i = 0; i<num;i++)
                {
                    if(resp[i]!=NULL)
                    {
                        free(resp[i]);
                    }  
                }
            }
        }
        else
        {
            LYERRLOG("lynq_get_mccmnc error");
        }
    }
}

static void lynq_sdk_ready(Parcel &p)
{
    int resp_type;
    int token;
    int request;
    int slot_id;
    int error1;
    int num;
    char imei[32] = {0};
    if(sdk_ready == true)
    {
        p.setDataPosition(0);
        if(p.dataAvail() > 0)
        {
            p.readInt32(&resp_type);
            p.readInt32(&token);
            p.readInt32(&request);
            p.readInt32(&slot_id);
            p.readInt32(&error1);
            if(!error1)
            {
                system("uci set lynq_uci.sdk_ready=0");
            }
            else
            {
                system("uci set lynq_uci.sdk_ready=2");
            }
        }
        sdk_ready = false;
    }
}

static void lynq_get_sim_state(RIL_CardStatus_v6 *card_status)
{
    g_lynq_sim_state = card_status->card_state;
}

extern "C" void
RIL_onRequestComplete(RIL_Token t, RIL_Errno e, void *response, size_t responselen) {
    RequestInfo *pRI;
    int ret;
    //int fd = s_ril_param_socket.fdCommand;
    size_t errorOffset;
    RIL_SOCKET_ID socket_id = RIL_SOCKET_1;

    pRI = (RequestInfo *)t;
#if 0
    if (!checkAndDequeueRequestInfo(pRI)) {
        RLOGE ("RIL_onRequestComplete: invalid RIL_Token");
        return;
    }
#endif

#if defined(ANDROID_MULTI_SIM) 

    socket_id = pRI->socket_id;
#endif

#if 0
#if (SIM_COUNT >= 2)
    if (socket_id == RIL_SOCKET_2) {
        fd = s_ril_param_socket2.fdCommand;
    }
#if (SIM_COUNT >= 3)
        if (socket_id == RIL_SOCKET_3) {
            fd = s_ril_param_socket3.fdCommand;
        }
#endif
#if (SIM_COUNT >= 4)
    if (socket_id == RIL_SOCKET_4) {
        fd = s_ril_param_socket4.fdCommand;
    }
#endif
#endif
#endif
#if VDBG
    RLOGD("RequestComplete, %s", rilSocketIdToString(socket_id));
#endif

    if (pRI->local > 0) {
        // Locally issued command...void only!
        // response does not go back up the command socket
        RLOGD("C[locl]< %s", requestToString(pRI->pCI->requestNumber));

        goto done;
    }

    appendPrintBuf("[%x][SIM%d]< %s", pRI->token,socket_id,requestToString(pRI->pCI->requestNumber));

    if (pRI->cancelled == 0) {
        Parcel p;

        p.writeInt32 (RESPONSE_SOLICITED);
        p.writeInt32 (pRI->uToken);
        p.writeInt32 (pRI->pCI->requestNumber);
        /*warren add for t800 ril servie 2021/12/15 start*/
        p.writeInt32(socket_id);
        /*warren add for t800 ril servie 2021/12/15 end*/
        errorOffset = p.dataPosition();

        p.writeInt32 (e);
        #ifdef MOBILETEK_TARGET_PLATFORM_T106
        if(pRI->pCI->requestNumber == RIL_REQUEST_DEACTIVATE_DATA_CALL)
        {
            if(e == 0)
            {
                RLOGD("[DATA]: deactive datacall success\n");
            }
            else
            {
                RLOGD("[DATA]: deactive datacall fail\n");
            }
            for(int j = 0; j < LYNQ_APN_CHANNEL_MAX; j++)
            {
                RLOGD("lynq_apn_cid_table[j].uToken =%d, pRI->uToken = %d", lynq_apn_cid_table[j].deactive_utoken, pRI->uToken);
                if(lynq_apn_cid_table[j].used == 1 && lynq_apn_cid_table[j].deactive_utoken == pRI->uToken)
                {
                    RLOGD("[DATA]delete cid is %d", lynq_apn_cid_table[j].cid);
                    //delete
                    bzero(lynq_apn_cid_table[j].apn,LYNQ_APN_LEN_MAX);
                    bzero(lynq_apn_cid_table[j].apntype,LYNQ_APNTPYE_LEN_MAX);
                    bzero(lynq_apn_cid_table[j].ifaceName,LYNQ_IFNAME_LEN_MAX);
                    bzero(lynq_apn_cid_table[j].address,LYNQ_ADDRESS_LEN_MAX);
                    lynq_apn_cid_table[j].cid = -1;
                    lynq_apn_cid_table[j].used = -1;
                    lynq_apn_cid_table[j].status = -1;
                    lynq_apn_cid_table[j].dialing = -1;
                    lynq_apn_cid_table[j].uToken = -1;
                    lynq_apn_cid_table[j].deactive_utoken = -1;
                    break;
                }
            }
        }
        //xf.li@20231102 add for t106 data start
        if(pRI->pCI->requestNumber == RIL_REQUEST_SETUP_DATA_CALL)
        {
            if(response == NULL)
            {
                for(int j = 0; j < LYNQ_APN_CHANNEL_MAX; j++)
                {
                    if(lynq_apn_cid_table[j].used == 1 && lynq_apn_cid_table[j].dialing == 1 && lynq_apn_cid_table[j].uToken == pRI->uToken)
                    {
                        RLOGD("[DATA]delete apntype is %s",lynq_apn_cid_table[j].apntype);
                        writeStringToParcel(p,lynq_apn_cid_table[j].apntype);
                        //delete
                        bzero(lynq_apn_cid_table[j].apn,LYNQ_APN_LEN_MAX);
                        bzero(lynq_apn_cid_table[j].apntype,LYNQ_APNTPYE_LEN_MAX);
                        bzero(lynq_apn_cid_table[j].ifaceName,LYNQ_IFNAME_LEN_MAX);
                        bzero(lynq_apn_cid_table[j].address,LYNQ_ADDRESS_LEN_MAX);
                        lynq_apn_cid_table[j].cid = -1;
                        lynq_apn_cid_table[j].used = -1;
                        lynq_apn_cid_table[j].status = -1;
                        lynq_apn_cid_table[j].dialing = -1;
                        lynq_apn_cid_table[j].uToken = -1;
                        break;
                    }
                }
            }
            else 
            {
                for(int j = 0; j < LYNQ_APN_CHANNEL_MAX; j++)
                {
                    if(lynq_apn_cid_table[j].used == 1 && lynq_apn_cid_table[j].dialing == 1 && lynq_apn_cid_table[j].uToken == pRI->uToken)
                    {
                        //set apn type
                        RLOGD("[DATA]response apntype is %s",lynq_apn_cid_table[j].apntype);
                        writeStringToParcel(p,lynq_apn_cid_table[j].apntype);
                        break;
                    }
                }
            }
        }
        //xf.li@20231102 add for t106 data start
        #endif
        if (response != NULL) {
            // there is a response payload, no matter success or not.
            ret = pRI->pCI->responseFunction(p, response, responselen);

            /* if an error occurred, rewind and mark it */
            if (ret != 0) {
                RLOGE ("responseFunction error, ret %d", ret);
                p.setDataPosition(errorOffset);
                p.writeInt32 (ret);
            }
            switch (pRI->pCI->requestNumber) {
               case RIL_REQUEST_QUERY_FACILITY_LOCK:
               {
                   int numInts = responselen / sizeof(int);
                   if(numInts > 0) {
                       int *p_int = (int *) response;
                       RLOGD("RIL_REQUEST_QUERY_FACILITY_LOCK: %s", (p_int[0] != 0 ? "PIN enable" : "PIN1 disable"));
                   } else {
                       RLOGD("RIL_REQUEST_QUERY_FACILITY_LOCK response numInts: %d", numInts);
                   }
                   break;
               }
               case RIL_REQUEST_IMS_REGISTRATION_STATE:
               {
                   int numInts = responselen / sizeof(int);
                   if(numInts > 0) {
                       int *p_int = (int *) response;
                       printf("[SIM%d][QUERY][REG_STATUS] IMS is %s\n", socket_id, (p_int[0] == 0 ? "Not registered" : "Registered"));
                   } else {
                       RLOGD("RIL_REQUEST_IMS_REGISTRATION_STATE response numInts: %d", numInts);
                   }
                   break;
               }
               case RIL_REQUEST_VOICE_REGISTRATION_STATE:
               {
                   char **p_cur = (char **) response;
                   int numStrings = responselen / sizeof(char *);
                   update_reg_voice_service_state(RIL_REQUEST_VOICE_REGISTRATION_STATE, (char *)p_cur[0], socket_id, pRI->token);
                   int tempVal=0;
                   memset(respStr,0,sizeof(respStr));
                   tempVal = atoi((char *)p_cur[0]);
                   if(tempVal == 1 || tempVal==5){
                       sprintf(respStr,"[SIM%d]%s register is in service!",socket_id +1, respStr);
                   }else{
                       sprintf(respStr,"[SIM%d]%s register is not in service!",socket_id +1, respStr);
                   }
                   if(numStrings >=4 && p_cur[3] != NULL)
                   {
                       update_reg_voice_radio_tech(RIL_REQUEST_VOICE_REGISTRATION_STATE, atoi((char *)p_cur[3]), socket_id, pRI->token);
                       tempVal = atoi((char *)p_cur[3]);
                       if(tempVal == RADIO_TECH_LTE){//4G
                           sprintf(respStr,"%s radioTech is 4G!",respStr);
                       } else if( tempVal == RADIO_TECH_GSM ||
                                  tempVal == RADIO_TECH_GPRS ||
                                  tempVal == RADIO_TECH_EDGE ||
                                  tempVal == RADIO_TECH_IS95A ||
                                  tempVal == RADIO_TECH_IS95B ||
                                  tempVal == RADIO_TECH_1xRTT) { //2G
                           sprintf(respStr,"%s radioTech is 2G!",respStr);
                       } else if( tempVal == RADIO_TECH_UMTS ||
                                  tempVal == RADIO_TECH_HSDPA ||
                                  tempVal == RADIO_TECH_HSUPA ||
                                  tempVal == RADIO_TECH_HSPA ||
                                  tempVal == RADIO_TECH_EHRPD ||
                                  tempVal == RADIO_TECH_HSPAP ||
                                  tempVal == RADIO_TECH_TD_SCDMA ||
                                  tempVal == RADIO_TECH_EVDO_0 ||
                                  tempVal == RADIO_TECH_EVDO_A ||
                                  tempVal == RADIO_TECH_EVDO_B) { //3G
                           sprintf(respStr,"%s radioTech is 3G!",respStr);
#ifdef TELEMATIC_5G_SUPPORT
                       } else if(tempVal == RADIO_TECH_NR) { //5G
                           sprintf(respStr,"%s radioTech is 5G!",respStr);
#endif
                       } else { //unknown
                           sprintf(respStr,"%s radioTech is unkown!",respStr);
                       }
                   }
                   sprintf(respStr,"%s\n",respStr);
                   break;
               }
               case RIL_REQUEST_DATA_REGISTRATION_STATE:
               {
                   char **p_cur = (char **) response;
                   int numStrings = responselen / sizeof(char *);
                   update_reg_data_service_state(RIL_REQUEST_DATA_REGISTRATION_STATE, (char *)p_cur[0], socket_id, pRI->token);
                   if(numStrings >=4 && p_cur[3] != NULL)
                   {
                       update_reg_data_radio_tech(RIL_REQUEST_DATA_REGISTRATION_STATE, atoi((char *)p_cur[3]), socket_id, pRI->token);
                   }
                   /*Warren add for SZZT 2021/11/14 start*/
                   lynqAtRespWatingEvent();
                   /*Warren add for SZZT 2021/11/14 end*/
                   break;
               }
               case RIL_REQUEST_GET_CURRENT_CALLS:
               {
                   update_call_state(response,responselen, socket_id);
                   int num = responselen / sizeof(RIL_Call *);
#ifdef LED_SUPPORT
                           char netled_on[LED_ON] = "";
                           lynq_get_value(LYNQ_UCI_FILE, LYNQ_UCI_SECTION, LYNQ_UCI_NETLED_KEY, netled_on);
                           if(1 == atoi(netled_on))
                           {
                                if(num > 0)
                                    mbtk_netled_state_update(GPIO_NETLED_CS_CALLING);
                                else
                                    mbtk_netled_state_update(GPIO_NETLED_CS_CALLEND);
                           }
#endif
                   speechonoff(num);
                   printf("%s\n", printBuf);
                   break;
               }
               case RIL_REQUEST_SETUP_DATA_CALL:
               {
                   //xf.il@20230610 modify for T106 data start
                   #ifdef MOBILETEK_TARGET_PLATFORM_T106
                   int num = responselen / sizeof(RIL_Data_Call_Response_v11);
                   RLOGD("the num of RIL_REQUEST_SETUP_DATA_CALL is %d", num);
                   RIL_Data_Call_Response_v11 *p_cur = (RIL_Data_Call_Response_v11 *) response;
                   updateRILDataCallResponsev11(num,p_cur,pRI->uToken);
                   #else
                   int num = responselen / sizeof(RIL_Data_Call_Response_v6);
                   RIL_Data_Call_Response_v6 *p_cur = (RIL_Data_Call_Response_v6 *) response;
                   updateRILDataCallResponsev6(num,p_cur);
                   #endif
                   //xf.il@20230610 modify for T106 data end
                   break;
               }
               case RIL_REQUEST_ANSWER:
               {
                   if(e==RIL_E_SUCCESS)
                   {
                       resetMute();
                   }                   
                   break;
               }
               case RIL_REQUEST_GET_SIM_STATUS:
               {
                   if (responselen == sizeof (RIL_CardStatus_v6)) {
                       RIL_CardStatus_v6 *p_cur = ((RIL_CardStatus_v6 *) response);
                       updateCardStatusV6(p_cur, socket_id);
                       lynq_get_sim_state(p_cur);
                   }
                   lynq_send_result_already();
                   break;
               }
               case RIL_REQUEST_VOICE_RADIO_TECH:
               {
                   update_voice_radio_tech(((int *) response)[0], socket_id);
                   break;
               }
               case RIL_REQUEST_GET_RADIO_CAPABILITY:
               {
                   update_radio_capa((RIL_RadioCapability *) response, socket_id);
                   break;
               }
               case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE:
               {
                   update_preferred_network_type(((int *) response)[0], socket_id);
                   break;
               }
               case RIL_REQUEST_DELETE_SMS_ON_SIM:
               {
                   setSimSmsStorageFullFlag(false);
                   break;
               }
               case RIL_REQUEST_SEND_SMS:
               case RIL_REQUEST_SEND_SMS_EXPECT_MORE:
               case RIL_REQUEST_IMS_SEND_SMS:
               {
                   //for auto save sms to sim
                   sendStatusWriteSmsToSim(socket_id);
                   break;
               }
               case RIL_REQUEST_ECALL_SET_REGISTRATION_STATE:
               {
                   int numInts = responselen / sizeof(int);
                   if(numInts > 0) {
                       int *p_int = (int *) response;
                       RLOGD("RIL_REQUEST_ECALL_SET_REGISTRATION_STATE: %d", p_int[0]);
                       if(p_int[0] == ECALL_DEREGISTRATION)
                       {
                            gostSetInNeedRegister(true);
                       }

                   } else {
                       RLOGD("RIL_REQUEST_ECALL_SET_REGISTRATION_STATE response numInts: %d", numInts);
                   }
                   break;
               }
               /*lei add for sdk ready 2022/8/17*/
                case RIL_REQUEST_DEVICE_IDENTITY:
                {
                    lynq_sdk_ready(p);
                    break;
                }
                /*lei add for sdk ready 2022/8/17*/
                case RIL_REQUEST_OPERATOR:
                {
                    lynq_get_mccmnc(p, mccmnc);
                    lynq_send_result_already();
                    break;
                }
               default:
                   break;
               }
        }
        if (e != RIL_E_SUCCESS) {
            appendPrintBuf("%s fails by %s", printBuf, failCauseToString(e));
        }
#if 0
        if ((pRI->token & RIL_TOKEN_MARK) == RIL_TOKEN_MARK) {
            printf("%s\n", printBuf ? printBuf : "unkonwn");
        } else if (((pRI->pCI->requestNumber == RIL_REQUEST_DEVICE_IDENTITY)
                || (pRI->pCI->requestNumber == RIL_REQUEST_OEM_HOOK_RAW))
                && (pRI->token & INIT_TOKEN_MARK) == INIT_TOKEN_MARK) {
            printf("%s\n", printBuf ? printBuf : "unkonwn");
            if (pRI->pCI->requestNumber == RIL_REQUEST_DEVICE_IDENTITY) {
                if (e != RIL_E_SUCCESS) {
                    printf(
                            "*******************************************\n*** NOTICE: IMEI don't wirite in slot%d ***\n*******************************************\n",
                            socket_id);
                }
            }
        }


        if (fd < 0) {
            RLOGD ("RIL onRequestComplete: Command channel closed");
        }
#endif
        LYNQ_RIL_respSocket(p,t);
        sendResponse(p, socket_id);
    }
#if ATCI_ENABLE_RESPONSE
    if((pRI->token & ATCI_TOKEN_MARK) == ATCI_TOKEN_MARK)  //ATCI_Rsp
    {
        int error;
        memset(Respose_buf, 0, sizeof(Respose_buf));
        if(e != RIL_E_SUCCESS)
            error = 1;  //fail
        else
            error = 0;  //ok
        ATCIResponse(pRI->token,error,Respose_buf, pRI->pCI->requestNumber);
    }
#endif
    if(pRI->pCI->requestNumber == RIL_REQUEST_VOICE_REGISTRATION_STATE && (pRI->token & RIL_TOKEN_MARK) == RIL_TOKEN_MARK){
        int len_s = sendto(server_socket_fd,respStr,strlen(respStr),0,(struct sockaddr *)&client_addr,sizeof(client_addr));
    }
    RLOGW("RIL_onRequestComplete %s end!",requestToString(pRI->pCI->requestNumber));
    if((pRI->token&BLOCK_MARK) == BLOCK_MARK) {
       //need wakeup dispatch function
        BLOCK_LOCK();
        wakeup_token = pRI->token;
        RLOGW("RIL_onRequestComplete wakeup, token is %x!",wakeup_token);
        BLOCK_WAKEUP();
        BLOCK_UNLOCK();
    }
    switch (pRI->pCI->requestNumber) {
        case RIL_REQUEST_RADIO_POWER:
            speciaRequest_wakeup();
            break;
        case RIL_REQUEST_SET_RADIO_CAPABILITY:
        {
            if(utils::is_support_dsds()) {
                for (int id = 0; id < SIM_COUNT; id++) {
                    ARspRequest(RIL_REQUEST_ALLOW_DATA, (RIL_SOCKET_ID)id);
                }
            }
            break;
        }
        case RIL_REQUEST_ALLOW_DATA:
        {
            if(utils::is_support_dsds() && isNeedConnect() && get_default_sim_data() == socket_id) {
                RLOGD("wait and recreate PDN with sim switch");
                resetConnect();
                sleep(WAIT_TIME_FOR_SIM_SWITCH);
                setupDataCall(0, NULL, (RIL_SOCKET_ID)0, NULL);
            }
            break;
        }
#ifdef KEEP_ALIVE
        case RIL_REQUEST_START_KEEPALIVE_PRO:
        case RIL_REQUEST_STOP_KEEPALIVE_PRO:
        {
            handleKeepAliveResponse(pRI->pCI->requestNumber, response, responselen, socket_id, (e != RIL_E_SUCCESS));
            break;
        }
#endif /*KEEP_ALIVE*/
        case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC:
        {
            if(e == RIL_E_SUCCESS)
            {
                 gostSetInNeedRegister(false);
                 gostFastEcallFlgSet(false);
            }
            else
            {
                 gostNetworkSelectionSet(socket_id);
            }
            break;
        }
    default:
        break;
    }
done:
    free(pRI);
}


static void
grabPartialWakeLock() {
#ifdef LYNQ_MAY_SUPPORT
    acquire_wake_lock(PARTIAL_WAKE_LOCK, ANDROID_WAKE_LOCK_NAME);
#endif //LYNQ_MAY_SUPPORT
}

static void
releaseWakeLock() {
#ifdef LYNQ_MAY_SUPPORT
    release_wake_lock(ANDROID_WAKE_LOCK_NAME);
#endif //LYNQ_MAY_SUPPORT
}


static int
decodeVoiceRadioTechnology (RIL_RadioState radioState) {
    switch (radioState) {
        case RADIO_STATE_SIM_NOT_READY:
        case RADIO_STATE_SIM_LOCKED_OR_ABSENT:
        case RADIO_STATE_SIM_READY:
            return RADIO_TECH_UMTS;

        case RADIO_STATE_RUIM_NOT_READY:
        case RADIO_STATE_RUIM_READY:
        case RADIO_STATE_RUIM_LOCKED_OR_ABSENT:
        case RADIO_STATE_NV_NOT_READY:
        case RADIO_STATE_NV_READY:
            return RADIO_TECH_1xRTT;

        default:
            RLOGD("decodeVoiceRadioTechnology: Invoked with incorrect RadioState");
            return -1;
    }
}

static int
decodeCdmaSubscriptionSource (RIL_RadioState radioState) {
    switch (radioState) {
        case RADIO_STATE_SIM_NOT_READY:
        case RADIO_STATE_SIM_LOCKED_OR_ABSENT:
        case RADIO_STATE_SIM_READY:
        case RADIO_STATE_RUIM_NOT_READY:
        case RADIO_STATE_RUIM_READY:
        case RADIO_STATE_RUIM_LOCKED_OR_ABSENT:
            return CDMA_SUBSCRIPTION_SOURCE_RUIM_SIM;

        case RADIO_STATE_NV_NOT_READY:
        case RADIO_STATE_NV_READY:
            return CDMA_SUBSCRIPTION_SOURCE_NV;

        default:
            RLOGD("decodeCdmaSubscriptionSource: Invoked with incorrect RadioState");
            return -1;
    }
}

static int
decodeSimStatus (RIL_RadioState radioState) {
   switch (radioState) {
       case RADIO_STATE_SIM_NOT_READY:
       case RADIO_STATE_RUIM_NOT_READY:
       case RADIO_STATE_NV_NOT_READY:
       case RADIO_STATE_NV_READY:
           return -1;
       case RADIO_STATE_SIM_LOCKED_OR_ABSENT:
       case RADIO_STATE_SIM_READY:
       case RADIO_STATE_RUIM_READY:
       case RADIO_STATE_RUIM_LOCKED_OR_ABSENT:
           return radioState;
       default:
           RLOGD("decodeSimStatus: Invoked with incorrect RadioState");
           return -1;
   }
}

static bool is3gpp2(int radioTech) {
    switch (radioTech) {
        case RADIO_TECH_IS95A:
        case RADIO_TECH_IS95B:
        case RADIO_TECH_1xRTT:
        case RADIO_TECH_EVDO_0:
        case RADIO_TECH_EVDO_A:
        case RADIO_TECH_EVDO_B:
        case RADIO_TECH_EHRPD:
            return true;
        default:
            return false;
    }
}

/* If RIL sends SIM states or RUIM states, store the voice radio
 * technology and subscription source information so that they can be
 * returned when telephony framework requests them
 */
static RIL_RadioState
processRadioState(RIL_RadioState newRadioState, RIL_SOCKET_ID socket_id) {

    if((newRadioState > RADIO_STATE_UNAVAILABLE) && (newRadioState < RADIO_STATE_ON)) {
        int newVoiceRadioTech;
        int newCdmaSubscriptionSource;
        int newSimStatus;

        /* This is old RIL. Decode Subscription source and Voice Radio Technology
           from Radio State and send change notifications if there has been a change */
        newVoiceRadioTech = decodeVoiceRadioTechnology(newRadioState);
        if(newVoiceRadioTech != voiceRadioTech) {
            voiceRadioTech = newVoiceRadioTech;
            RIL_UNSOL_RESPONSE(RIL_UNSOL_VOICE_RADIO_TECH_CHANGED,
                        &voiceRadioTech, sizeof(voiceRadioTech), socket_id);
        }
        if(is3gpp2(newVoiceRadioTech)) {
            newCdmaSubscriptionSource = decodeCdmaSubscriptionSource(newRadioState);
            if(newCdmaSubscriptionSource != cdmaSubscriptionSource) {
                cdmaSubscriptionSource = newCdmaSubscriptionSource;
                RIL_UNSOL_RESPONSE(RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED,
                        &cdmaSubscriptionSource, sizeof(cdmaSubscriptionSource), socket_id);
            }
        }
        newSimStatus = decodeSimStatus(newRadioState);
        if(newSimStatus != simRuimStatus) {
            simRuimStatus = newSimStatus;
            RIL_UNSOL_RESPONSE(RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED, NULL, 0, socket_id);
        }

        /* Send RADIO_ON to telephony */
        newRadioState = RADIO_STATE_ON;
    }

    return newRadioState;
}


#if defined(ANDROID_MULTI_SIM)
extern "C"
void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen, RIL_SOCKET_ID socket_id)
#else
extern "C"
void RIL_onUnsolicitedResponse(int unsolResponse, const void *data,
                                size_t datalen)
#endif
{
    int unsolResponseIndex;
    int ret;
    int64_t timeReceived = 0;
    bool shouldScheduleTimeout = false;
    RIL_RadioState newState;
    int temp = 0;
    char *tempChar=NULL;
    RIL_SOCKET_ID soc_id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();

#if defined(ANDROID_MULTI_SIM)
    soc_id = socket_id;
#endif

    handle_wakeup_reason(unsolResponse);

    if (s_registerCalled == 0) {
        // Ignore RIL_onUnsolicitedResponse before RIL_register
        RLOGW("RIL_onUnsolicitedResponse called before RIL_register");
        return;
    }
    if(onSupports(unsolResponse) == 0)
    {
        RLOGE("unsupported unsolicited response code %d", unsolResponse);
        return;
    }

#ifdef TARGET_PLATFORM_MT2635
    //Reset modem, exit DemoApp.
    if(unsolResponse==RIL_UNSOL_MAL_RESTART ) {
        RLOGD("Modem Reset, Exit DemoApp!");
        printf("Modem Reset, Exit DemoApp!\n");
        speechonoff(0);
        mixer_reset_set(1);
        com_quit(0,NULL,soc_id,NULL);
    }
#endif
    if (unsolResponse < RIL_UNSOL_VENDOR_BASE) {
        unsolResponseIndex = unsolResponse - RIL_UNSOL_RESPONSE_BASE;
    }
#if 0
    WakeType wakeType;
    if (unsolResponse >= RIL_UNSOL_VENDOR_BASE) {
        //unsolResponseIndex = unsolResponse - RIL_UNSOL_VENDOR_BASE;
        wakeType = WAKE_PARTIAL;
    } else {
        unsolResponseIndex = unsolResponse - RIL_UNSOL_RESPONSE_BASE;
        wakeType = s_unsolResponses[unsolResponseIndex].wakeType;
    }

    // Grab a wake lock if needed for this reponse,
    // as we exit we'll either release it immediately
    // or set a timer to release it later.
    switch (wakeType) {
        case WAKE_PARTIAL:
            grabPartialWakeLock();
            shouldScheduleTimeout = false;
        break;

        case DONT_WAKE:
        default:
            // No wake lock is grabed so don't set timeout
            shouldScheduleTimeout = false;
            break;
    }

    // Mark the time this was received, doing this
    // after grabing the wakelock incase getting
    // the elapsedRealTime might cause us to goto
    // sleep.
    if (unsolResponse == RIL_UNSOL_NITZ_TIME_RECEIVED) {
        timeReceived = elapsedRealtime();
    }
#endif
    appendPrintBuf("[UNSL][SIM%d]< %s", soc_id, requestToString(unsolResponse));

    Parcel p;
    p.writeInt32 (RESPONSE_UNSOLICITED);
    p.writeInt32 (unsolResponse);
    /*Warren add for t800 ril service 2021/12/16 start*/
    p.writeInt32 (soc_id);
    /*Warren add for t800 ril service 2021/12/16 end*/
    if (unsolResponse >= RIL_UNSOL_VENDOR_BASE) {
        UnsolResponseInfo* unsolRspInof = find_mtk_unsol_command(unsolResponse);
        if(unsolRspInof == NULL){
            RLOGE("no unsolicited response function -- %d", unsolResponse);
            return;
        } else {
            ret = unsolRspInof->responseFunction(p,const_cast<void*>(data),datalen);
        }
    } else {
        ret = s_unsolResponses[unsolResponseIndex].responseFunction(p, const_cast<void*>(data), datalen);
    }
    if (ret != 0) {
        // Problem with the response. Don't continue;
        goto error_exit;
    }

    // some things get more payload
    switch(unsolResponse) {
        case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED:
            newState = CALL_ONSTATEREQUEST(soc_id);
            p.writeInt32(newState);
            appendPrintBuf("%s {%s}", printBuf,
                radioStateToString(CALL_ONSTATEREQUEST(soc_id)));
        break;

#if 0
        case RIL_UNSOL_NITZ_TIME_RECEIVED:
            // Store the time that this was received so the
            // handler of this message can account for
            // the time it takes to arrive and process. In
            // particular the system has been known to sleep
            // before this message can be processed.
            p.writeInt64(timeReceived);
        break;
#endif
    }

#if VDBG
    RLOGI("%s UNSOLICITED: %s length:%d", rilSocketIdToString(soc_id), requestToString(unsolResponse), p.dataSize());
#endif
    //ret = sendResponse(p, soc_id);

//unsol trigger other things.
    switch(unsolResponse) {
     case RIL_UNSOL_SIM_STATUS_COMMAND:
     {
        RIL_CardStatus_v6 *p_cur = ((RIL_CardStatus_v6 *) data);
        updateCardStatusV6(p_cur, soc_id);
        break;
     }
#ifdef LED_SUPPORT
    case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED:   //add this for API-720
        ARspRequest(RIL_REQUEST_GET_CURRENT_CALLS, soc_id);
        break;
#endif
    case RIL_UNSOL_CALL_RING:
        callRing(soc_id);
        break;
    case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED:
        updateIccCardState(soc_id);
        break;
    case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        ARspRequest(RIL_REQUEST_VOICE_REGISTRATION_STATE,soc_id);
        break;
    case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        ARspRequest(RIL_REQUEST_DATA_REGISTRATION_STATE,soc_id);
        break;
    case RIL_UNSOL_RESPONSE_NEW_SMS:
        responseNewSMS((const char*)data, datalen,soc_id,unsolResponse,p);
        unreadStatusWriteSMSToSim((const char*)data, datalen, soc_id);
        sendSMSACK(soc_id);
        break;
    case RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS:
    {
        RLOGD("Receive RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS data: %s, length: %d", (char*)data, datalen);
        break;
    }
    case RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT:
        sendSMSACK(soc_id);
        break;
    case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED:
        updateRadioStatus(newState,soc_id);
        break;
    case RIL_UNSOL_RESPONSE_CDMA_NEW_SMS:
    {
        ARspRequest(RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE, soc_id);
        break;
    }
    case RIL_UNSOL_STK_PROACTIVE_COMMAND:
    {
          RLOGD("STk proactive command raw date: %s, length: %d", (char*)data, datalen);
          handleStkCommand((char*)data, datalen,soc_id);
          break;
    }
    case RIL_UNSOL_RIL_CONNECTED:
    {
          RLOGD("vendor-ril socket(%d) connect start", soc_id);
          pthread_mutex_lock(&s_InitMutex);
          s_isConnected[soc_id] = 1;
          if(utils::is_support_dsds()) {
              if (s_isConnected[0] == 1 && s_isConnected[1] == 1) {
                  pthread_cond_broadcast(&s_InitCond);
              }
          } else {
              if (s_isConnected[0] == 1 || s_isConnected[1] == 1) {
                  pthread_cond_broadcast(&s_InitCond);
              }
          }
          pthread_mutex_unlock(&s_InitMutex);
          RLOGD("vendor-ril socket(%d) connect end", soc_id);
          break;
    }
    case RIL_UNSOL_TX_POWER: {
        int *p_int = (int *) data;
        int numInts = datalen / sizeof(int);
        #ifdef LYNQ_MAY_SUPPORT
        if (numInts > 1)  {
            m_RfDesense->emOemHookRaw(p_int[1],soc_id);
        } else {
            m_RfDesense->emOemHookRaw(0, soc_id);
        }
        #endif //LYNQ_MAY_SUPPORT
        break;
    }
    case RIL_UNSOL_NETWORK_INFO: {
        if(networkCb){
            //TBD
            char **p_cur = (char **) data;
            char *ctype = (char*)p_cur[0];
            int type = atoi(ctype);
            char *data = (char*)p_cur[1];
            RLOGD("ctype %s type %d data %s\n",ctype,type,data);
            networkCb(type,data);
        }
        break;
    }
    case RIL_UNSOL_DATA_CALL_LIST_CHANGED:
    {
//xf.il@20230610 modify for T106 data start
#ifdef MOBILETEK_TARGET_PLATFORM_T106
        RLOGD("URC is RIL_UNSOL_DATA_CALL_LIST_CHANGED, datalen = %d\n", datalen);
        int num = datalen / sizeof(RIL_Data_Call_Response_v11);
        RIL_Data_Call_Response_v11 *p_cur = (RIL_Data_Call_Response_v11 *) data;
#else
        int num = datalen / sizeof(RIL_Data_Call_Response_v6);
        RIL_Data_Call_Response_v6 *p_cur = (RIL_Data_Call_Response_v6 *) data;
#endif
        handleUnsolDataCalllistChange(num,p_cur);
//xf.il@20230610 modify for T106 data end
        break;
    }
    case RIL_UNSOL_VOICE_RADIO_TECH_CHANGED:
    {
        update_voice_radio_tech(((int *) data)[0], soc_id);
        break;
    }
    case RIL_UNSOL_RADIO_CAPABILITY:
    {
        update_radio_capa((RIL_RadioCapability *) data, soc_id);
        //Proxy_controller::getInstance()->handle_message_notify((RIL_RadioCapability *) data, soc_id);
        break;
    }
    case RIL_UNSOL_CDMA_CALL_WAITING:
    {
        autoAnswerForCdma(soc_id);
        break;
    }
    case RIL_UNSOL_NITZ_TIME_RECEIVED:
    {
        updateSystemTime(data, datalen);
        break;
    }
    case RIL_UNSOL_ECALL_INDICATIONS:
    {
        handleEcallIndication(data, datalen, soc_id);
        break;
    }
#ifdef KEEP_ALIVE
    case RIL_UNSOL_KEEPALIVE_STATUS_PRO:
    {
        handleKeepAliveResponse(unsolResponse, data, datalen, soc_id, false);
        break;
    }
#endif /*KEEP_ALIVE*/
    case RIL_UNSOL_SIM_SMS_STORAGE_FULL:
    {
        setSimSmsStorageFullFlag(true);
        break;
    }
    case RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR:
    {
        handleUnsolSipCallProgressInd(data, datalen);
        break;
    }
    case RIL_UNSOL_ECC_NUM:
    {
        handleECCNumResponse(data, datalen,soc_id);
        break;
    }
    case RIL_UNSOL_CALL_INFO_INDICATION:
    {
        handleUnsolCallInfoInd(data, datalen, soc_id);
        break;
    }
    case RIL_UNSOL_RINGBACK_TONE:
    {
        handleRingbackTone(data, datalen, soc_id);
        break;
    }
#ifdef MOBILETEK_TARGET_PLATFORM_T106 
    case RIL_UNSOL_AUDIO_DEV_SAMPLERATE:
    {
        handleAudioDevSampleRate(data, datalen, soc_id);
        break;
    }
#endif
    default:
        break;
    }
    /*Warren add for t800 ril service 2021/12/16 start*/
    ret = LYNQ_RIL_urcBroadcast(p,unsolResponse);
    /*Warren add for t800 ril service 2021/12/16 end*/
#if 0
    if (ret != 0 && unsolResponse == RIL_UNSOL_NITZ_TIME_RECEIVED) {

        // Unfortunately, NITZ time is not poll/update like everything
        // else in the system. So, if the upstream client isn't connected,
        // keep a copy of the last NITZ response (with receive time noted
        // above) around so we can deliver it when it is connected

        if (s_lastNITZTimeData != NULL) {
            free (s_lastNITZTimeData);
            s_lastNITZTimeData = NULL;
        }

        s_lastNITZTimeData = malloc(p.dataSize());
        s_lastNITZTimeDataSize = p.dataSize();
        memcpy(s_lastNITZTimeData, p.data(), p.dataSize());
    }

#endif
    // Normal exit
    return;

error_exit:
    RLOGD("unsol handle fail");
#if 0
    if (shouldScheduleTimeout) {
        releaseWakeLock();
    }
#endif
}

extern "C" void
RIL_requestTimedCallback (RIL_TimedCallback callback, void *param,
                                const struct timeval *relativeTime) {
}

const char *
failCauseToString(RIL_Errno e) {
    switch(e) {
        case RIL_E_SUCCESS: return "E_SUCCESS";
        case RIL_E_RADIO_NOT_AVAILABLE: return "E_RADIO_NOT_AVAILABLE";
        case RIL_E_GENERIC_FAILURE: return "E_GENERIC_FAILURE";
        case RIL_E_PASSWORD_INCORRECT: return "E_PASSWORD_INCORRECT";
        case RIL_E_SIM_PIN2: return "E_SIM_PIN2";
        case RIL_E_SIM_PUK2: return "E_SIM_PUK2";
        case RIL_E_REQUEST_NOT_SUPPORTED: return "E_REQUEST_NOT_SUPPORTED";
        case RIL_E_CANCELLED: return "E_CANCELLED";
        case RIL_E_OP_NOT_ALLOWED_DURING_VOICE_CALL: return "E_OP_NOT_ALLOWED_DURING_VOICE_CALL";
        case RIL_E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW: return "E_OP_NOT_ALLOWED_BEFORE_REG_TO_NW";
        case RIL_E_SMS_SEND_FAIL_RETRY: return "E_SMS_SEND_FAIL_RETRY";
        case RIL_E_SIM_ABSENT:return "E_SIM_ABSENT";
        case RIL_E_ILLEGAL_SIM_OR_ME:return "E_ILLEGAL_SIM_OR_ME";
#ifdef FEATURE_MULTIMODE_ANDROID
        case RIL_E_SUBSCRIPTION_NOT_AVAILABLE:return "E_SUBSCRIPTION_NOT_AVAILABLE";
        case RIL_E_MODE_NOT_SUPPORTED:return "E_MODE_NOT_SUPPORTED";
#endif
        case RIL_E_SIM_MEM_FULL: return "E_SIM_MEM_FULL";
        default: return "<unknown error>";
    }
}

const char *
callStateToString(RIL_CallState s) {
    switch(s) {
        case RIL_CALL_ACTIVE : return "ACTIVE";
        case RIL_CALL_HOLDING: return "HOLDING";
        case RIL_CALL_DIALING: return "DIALING";
        case RIL_CALL_ALERTING: return "ALERTING";
        case RIL_CALL_INCOMING: return "INCOMING";
        case RIL_CALL_WAITING: return "WAITING";
        default: return "<unknown state>";
    }
}
const char *lynq_requset_to_string(int request)
{
    switch(request) {
        case RIL_REQUEST_GET_SIM_STATUS: return "RIL_REQUEST_GET_SIM_STATUS";
        case RIL_REQUEST_ENTER_SIM_PIN: return "RIL_REQUEST_ENTER_SIM_PIN";
        case RIL_REQUEST_ENTER_SIM_PUK: return "RIL_REQUEST_ENTER_SIM_PUK";
        case RIL_REQUEST_ENTER_SIM_PIN2: return "RIL_REQUEST_ENTER_SIM_PIN2";
        case RIL_REQUEST_ENTER_SIM_PUK2: return "RIL_REQUEST_ENTER_SIM_PUK2";
        case RIL_REQUEST_CHANGE_SIM_PIN: return "RIL_REQUEST_CHANGE_SIM_PIN";
        case RIL_REQUEST_CHANGE_SIM_PIN2: return "RIL_REQUEST_CHANGE_SIM_PIN2";
        case RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION: return "RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION";
        case RIL_REQUEST_GET_CURRENT_CALLS: return "RIL_REQUEST_GET_CURRENT_CALLS";
        case RIL_REQUEST_DIAL: return "RIL_REQUEST_DIAL";
        case RIL_REQUEST_GET_IMSI: return "RIL_REQUEST_GET_IMSI";
        case RIL_REQUEST_HANGUP: return "RIL_REQUEST_HANGUP";
        case RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND: return "RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND";
        case RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND: return "RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND";
        case RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE: return "RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
        case RIL_REQUEST_CONFERENCE: return "RIL_REQUEST_CONFERENCE";
        case RIL_REQUEST_UDUB: return "RIL_REQUEST_UDUB";
        case RIL_REQUEST_LAST_CALL_FAIL_CAUSE: return "RIL_REQUEST_LAST_CALL_FAIL_CAUSE";
        case RIL_REQUEST_SIGNAL_STRENGTH: return "RIL_REQUEST_SIGNAL_STRENGTH";
        case RIL_REQUEST_VOICE_REGISTRATION_STATE: return "RIL_REQUEST_VOICE_REGISTRATION_STATE";
        case RIL_REQUEST_DATA_REGISTRATION_STATE: return "RIL_REQUEST_DATA_REGISTRATION_STATE";
        case RIL_REQUEST_OPERATOR: return "RIL_REQUEST_OPERATOR";
        case RIL_REQUEST_RADIO_POWER: return "RIL_REQUEST_RADIO_POWER";
        case RIL_REQUEST_DTMF: return "RIL_REQUEST_DTMF";
        case RIL_REQUEST_SEND_SMS: return "RIL_REQUEST_SEND_SMS";
        case RIL_REQUEST_SEND_SMS_EXPECT_MORE: return "RIL_REQUEST_SEND_SMS_EXPECT_MORE";
        case RIL_REQUEST_SETUP_DATA_CALL: return "RIL_REQUEST_SETUP_DATA_CALL";
        case RIL_REQUEST_SIM_IO: return "RIL_REQUEST_SIM_IO";
        case RIL_REQUEST_SEND_USSD: return "RIL_REQUEST_SEND_USSD";
        case RIL_REQUEST_CANCEL_USSD: return "RIL_REQUEST_CANCEL_USSD";
        case RIL_REQUEST_GET_CLIR: return "RIL_REQUEST_GET_CLIR";
        case RIL_REQUEST_SET_CLIR: return "RIL_REQUEST_SET_CLIR";
        case RIL_REQUEST_QUERY_CALL_FORWARD_STATUS: return "RIL_REQUEST_QUERY_CALL_FORWARD_STATUS";
        case RIL_REQUEST_SET_CALL_FORWARD: return "RIL_REQUEST_SET_CALL_FORWARD";
        case RIL_REQUEST_QUERY_CALL_WAITING: return "RIL_REQUEST_QUERY_CALL_WAITING";
        case RIL_REQUEST_SET_CALL_WAITING: return "RIL_REQUEST_SET_CALL_WAITING";
        case RIL_REQUEST_SMS_ACKNOWLEDGE: return "RIL_REQUEST_SMS_ACKNOWLEDGE";
        case RIL_REQUEST_GET_IMEI: return "RIL_REQUEST_GET_IMEI";
        case RIL_REQUEST_GET_IMEISV: return "RIL_REQUEST_GET_IMEISV";
        case RIL_REQUEST_ANSWER: return "RIL_REQUEST_ANSWER";
        case RIL_REQUEST_DEACTIVATE_DATA_CALL: return "RIL_REQUEST_DEACTIVATE_DATA_CALL";
        case RIL_REQUEST_QUERY_FACILITY_LOCK: return "RIL_REQUEST_QUERY_FACILITY_LOCK";
        case RIL_REQUEST_SET_FACILITY_LOCK: return "RIL_REQUEST_SET_FACILITY_LOCK";
        case RIL_REQUEST_CHANGE_BARRING_PASSWORD: return "RIL_REQUEST_CHANGE_BARRING_PASSWORD";
        case RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE: return "RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE";
        case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC: return "RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC";
        case RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL: return "RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL";
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS : return "RIL_REQUEST_QUERY_AVAILABLE_NETWORKS";
        case RIL_REQUEST_DTMF_START: return "RIL_REQUEST_DTMF_START";
        case RIL_REQUEST_DTMF_STOP: return "RIL_REQUEST_DTMF_STOP";
        case RIL_REQUEST_BASEBAND_VERSION: return "RIL_REQUEST_BASEBAND_VERSION";
        case RIL_REQUEST_SEPARATE_CONNECTION: return "RIL_REQUEST_SEPARATE_CONNECTION";
        case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE: return "RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE";
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE: return "RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE";
        case RIL_REQUEST_GET_NEIGHBORING_CELL_IDS: return "RIL_REQUEST_GET_NEIGHBORING_CELL_IDS";
        case RIL_REQUEST_SET_MUTE: return "RIL_REQUEST_SET_MUTE";
        case RIL_REQUEST_GET_MUTE: return "RIL_REQUEST_GET_MUTE";
        case RIL_REQUEST_QUERY_CLIP: return "RIL_REQUEST_QUERY_CLIP";
        case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE: return "RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE";
        case RIL_REQUEST_DATA_CALL_LIST: return "RIL_REQUEST_DATA_CALL_LIST";
        #ifdef MOBILETEK_TARGET_PLATFORM_T106
        case RIL_REQUEST_APN_LIST: return "RIL_REQUEST_APN_LIST";//LYNQ_MODIFY_ZXW_TASK794_CR2024120449D612E5_XF.Li_20241221
        #endif
        case RIL_REQUEST_RESET_RADIO: return "RIL_REQUEST_RESET_RADIO";
        case RIL_REQUEST_OEM_HOOK_RAW: return "RIL_REQUEST_OEM_HOOK_RAW";
        case RIL_REQUEST_OEM_HOOK_STRINGS: return "RIL_REQUEST_OEM_HOOK_STRINGS";
        case RIL_REQUEST_SET_BAND_MODE: return "RIL_REQUEST_SET_BAND_MODE";
        case RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE: return "RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE";
        case RIL_REQUEST_STK_GET_PROFILE: return "RIL_REQUEST_STK_GET_PROFILE";
        case RIL_REQUEST_STK_SET_PROFILE: return "RIL_REQUEST_STK_SET_PROFILE";
        case RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND: return "RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND";
        case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE: return "RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE";
        case RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM: return "RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
        case RIL_REQUEST_SCREEN_STATE: return "RIL_REQUEST_SCREEN_STATE";
        case RIL_REQUEST_EXPLICIT_CALL_TRANSFER: return "RIL_REQUEST_EXPLICIT_CALL_TRANSFER";
        case RIL_REQUEST_SET_LOCATION_UPDATES: return "RIL_REQUEST_SET_LOCATION_UPDATES";
        case RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE:return"RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE";
        case RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE:return"RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE";
        case RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE:return"RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE";
        case RIL_REQUEST_SET_TTY_MODE:return"RIL_REQUEST_SET_TTY_MODE";
        case RIL_REQUEST_QUERY_TTY_MODE:return"RIL_REQUEST_QUERY_TTY_MODE";
        case RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE:return"RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
        case RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE:return"RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
        case RIL_REQUEST_CDMA_FLASH:return"RIL_REQUEST_CDMA_FLASH";
        case RIL_REQUEST_CDMA_BURST_DTMF:return"RIL_REQUEST_CDMA_BURST_DTMF";
        case RIL_REQUEST_CDMA_SEND_SMS:return"RIL_REQUEST_CDMA_SEND_SMS";
        case RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE:return"RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE";
        case RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG:return"RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG:return"RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION:return "RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION";
        case RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG:return "RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG:return "RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION:return "RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION";
        case RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY: return"RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY";
        case RIL_REQUEST_CDMA_SUBSCRIPTION: return"RIL_REQUEST_CDMA_SUBSCRIPTION";
        case RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM: return "RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM";
        case RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM: return "RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM";
        case RIL_REQUEST_DEVICE_IDENTITY: return "RIL_REQUEST_DEVICE_IDENTITY";
        case RIL_REQUEST_EXIT_EMERGENCY_CALLBACK_MODE: return "RIL_REQUEST_EXIT_EMERGENCY_CALLBACK_MODE";
        case RIL_REQUEST_GET_SMSC_ADDRESS: return "RIL_REQUEST_GET_SMSC_ADDRESS";
        case RIL_REQUEST_SET_SMSC_ADDRESS: return "RIL_REQUEST_SET_SMSC_ADDRESS";
        case RIL_REQUEST_REPORT_SMS_MEMORY_STATUS: return "RIL_REQUEST_REPORT_SMS_MEMORY_STATUS";
        case RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING: return "RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING";
        case RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE: return "RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE";
        case RIL_REQUEST_ISIM_AUTHENTICATION: return "RIL_REQUEST_ISIM_AUTHENTICATION";
        case RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU: return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
        case RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS: return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
        case RIL_REQUEST_VOICE_RADIO_TECH: return "RIL_REQUEST_VOICE_RADIO_TECH";
        case RIL_REQUEST_GET_CELL_INFO_LIST: return"RIL_REQUEST_GET_CELL_INFO_LIST";
        case RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE: return"RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE";
        case RIL_REQUEST_SET_INITIAL_ATTACH_APN: return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
        case RIL_REQUEST_IMS_REGISTRATION_STATE: return "RIL_REQUEST_IMS_REGISTRATION_STATE";
        case RIL_REQUEST_IMS_SEND_SMS: return "RIL_REQUEST_IMS_SEND_SMS";
        case RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC: return "RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC";
        case RIL_REQUEST_SIM_OPEN_CHANNEL: return "RIL_REQUEST_SIM_OPEN_CHANNEL";
        case RIL_REQUEST_SIM_CLOSE_CHANNEL: return "RIL_REQUEST_SIM_CLOSE_CHANNEL";
        case RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL: return "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL";
        case RIL_REQUEST_GET_RADIO_CAPABILITY: return "RIL_REQUEST_GET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_RADIO_CAPABILITY: return "RIL_REQUEST_SET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_UICC_SUBSCRIPTION: return "RIL_REQUEST_SET_UICC_SUBSCRIPTION";
        case RIL_REQUEST_ALLOW_DATA: return "RIL_REQUEST_ALLOW_DATA";
        case RIL_REQUEST_GET_HARDWARE_CONFIG: return "RIL_REQUEST_GET_HARDWARE_CONFIG";
        case RIL_REQUEST_SIM_AUTHENTICATION: return "RIL_REQUEST_SIM_AUTHENTICATION";
        case RIL_REQUEST_GET_DC_RT_INFO: return "RIL_REQUEST_GET_DC_RT_INFO";
        case RIL_REQUEST_SET_DC_RT_INFO_RATE: return "RIL_REQUEST_SET_DC_RT_INFO_RATE";
        case RIL_REQUEST_SET_DATA_PROFILE: return "RIL_REQUEST_SET_DATA_PROFILE";
        case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED: return "RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED: return "RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED: return "RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_NEW_SMS: return "RIL_UNSOL_RESPONSE_NEW_SMS";
        case RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT: return "RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
        case RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM: return "RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM";
        case RIL_UNSOL_ON_USSD: return "RIL_UNSOL_ON_USSD";
        case RIL_UNSOL_ON_USSD_REQUEST: return "RIL_UNSOL_ON_USSD_REQUEST";
        case RIL_UNSOL_NITZ_TIME_RECEIVED: return "RIL_UNSOL_NITZ_TIME_RECEIVED";
        case RIL_UNSOL_SIGNAL_STRENGTH: return "RIL_UNSOL_SIGNAL_STRENGTH";
        case RIL_UNSOL_STK_SESSION_END: return "RIL_UNSOL_STK_SESSION_END";
        case RIL_UNSOL_STK_PROACTIVE_COMMAND: return "RIL_UNSOL_STK_PROACTIVE_COMMAND";
        case RIL_UNSOL_STK_EVENT_NOTIFY: return "RIL_UNSOL_STK_EVENT_NOTIFY";
        case RIL_UNSOL_STK_CALL_SETUP: return "RIL_UNSOL_STK_CALL_SETUP";
        case RIL_UNSOL_SIM_SMS_STORAGE_FULL: return "RIL_UNSOL_SIM_SMS_STORAGE_FULL";
        case RIL_UNSOL_SIM_REFRESH: return "RIL_UNSOL_SIM_REFRESH";
        case RIL_UNSOL_DATA_CALL_LIST_CHANGED: return "RIL_UNSOL_DATA_CALL_LIST_CHANGED";
        case RIL_UNSOL_CALL_RING: return "RIL_UNSOL_CALL_RING";
        case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED: return "RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED";
        case RIL_UNSOL_RESPONSE_CDMA_NEW_SMS: return "RIL_UNSOL_RESPONSE_CDMA_NEW_SMS";
        case RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS: return "RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS";
        case RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL: return "RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
        case RIL_UNSOL_RESTRICTED_STATE_CHANGED: return "RIL_UNSOL_RESTRICTED_STATE_CHANGED";
        case RIL_UNSOL_ENTER_EMERGENCY_CALLBACK_MODE: return "RIL_UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
        case RIL_UNSOL_CDMA_CALL_WAITING: return "RIL_UNSOL_CDMA_CALL_WAITING";
        case RIL_UNSOL_CDMA_OTA_PROVISION_STATUS: return "RIL_UNSOL_CDMA_OTA_PROVISION_STATUS";
        case RIL_UNSOL_CDMA_INFO_REC: return "RIL_UNSOL_CDMA_INFO_REC";
        case RIL_UNSOL_OEM_HOOK_RAW: return "RIL_UNSOL_OEM_HOOK_RAW";
        case RIL_UNSOL_RINGBACK_TONE: return "RIL_UNSOL_RINGBACK_TONE";
        case RIL_UNSOL_RESEND_INCALL_MUTE: return "RIL_UNSOL_RESEND_INCALL_MUTE";
        case RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED: return "RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED";
        case RIL_UNSOL_CDMA_PRL_CHANGED: return "RIL_UNSOL_CDMA_PRL_CHANGED";
        case RIL_UNSOL_EXIT_EMERGENCY_CALLBACK_MODE: return "RIL_UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
        case RIL_UNSOL_RIL_CONNECTED: return "RIL_UNSOL_RIL_CONNECTED";
        case RIL_UNSOL_VOICE_RADIO_TECH_CHANGED: return "RIL_UNSOL_VOICE_RADIO_TECH_CHANGED";
        case RIL_UNSOL_CELL_INFO_LIST: return "RIL_UNSOL_CELL_INFO_LIST";
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED: return "RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED: return "RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
        case RIL_UNSOL_SRVCC_STATE_NOTIFY: return "RIL_UNSOL_SRVCC_STATE_NOTIFY";
        case RIL_UNSOL_HARDWARE_CONFIG_CHANGED: return "RIL_UNSOL_HARDWARE_CONFIG_CHANGED";
        case RIL_UNSOL_DC_RT_INFO_CHANGED: return "RIL_UNSOL_DC_RT_INFO_CHANGED";
        case RIL_REQUEST_SHUTDOWN: return "RIL_REQUEST_SHUTDOWN";
        case RIL_UNSOL_RADIO_CAPABILITY: return "RIL_UNSOL_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_TRM: return "RIL_REQUEST_SET_TRM";
        case RIL_REQUEST_SET_IMS_ENABLE:return "RIL_REQUEST_SET_IMS_ENABLE";
        case RIL_REQUEST_SET_AUDIO_PATH: return "RIL_REQUEST_SET_AUDIO_PATH";
        case RIL_REQUEST_HANGUP_ALL: return "RIL_REQUEST_HANGUP_ALL";
        case RIL_REQUEST_FORCE_RELEASE_CALL: return "RIL_REQUEST_FORCE_RELEASE_CALL";
        case RIL_REQUEST_EMERGENCY_DIAL: return "RIL_REQUEST_EMERGENCY_DIAL";
        case RIL_REQUEST_SET_ECC_SERVICE_CATEGORY: return "RIL_REQUEST_SET_ECC_SERVICE_CATEGORY";
        case RIL_REQUEST_SET_ECC_LIST: return "RIL_REQUEST_SET_ECC_LIST";
        case RIL_REQUEST_AT_COMMAND_WITH_PROXY: return "RIL_REQUEST_AT_COMMAND_WITH_PROXY";
        case RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION: return "RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION";
        case RIL_REQUEST_SET_CLIP: return "RIL_REQUEST_SET_CLIP";
        case RIL_REQUEST_GET_COLP: return "RIL_REQUEST_GET_COLP";
        case RIL_REQUEST_SET_COLP: return "RIL_REQUEST_SET_COLP";
        case RIL_REQUEST_GET_COLR: return "RIL_REQUEST_GET_COLR";
        case RIL_REQUEST_ADD_IMS_CONFERENCE_CALL_MEMBER: return "RIL_REQUEST_ADD_IMS_CONFERENCE_CALL_MEMBER";
        case RIL_REQUEST_REMOVE_IMS_CONFERENCE_CALL_MEMBER: return "RIL_REQUEST_REMOVE_IMS_CONFERENCE_CALL_MEMBER";
        case RIL_REQUEST_CONFERENCE_DIAL: return "RIL_REQUEST_CONFERENCE_DIAL";
        case RIL_REQUEST_DIAL_WITH_SIP_URI: return "RIL_REQUEST_DIAL_WITH_SIP_URI";
        case RIL_REQUEST_HOLD_CALL: return "RIL_REQUEST_HOLD_CALL";
        case RIL_REQUEST_RESUME_CALL: return "RIL_REQUEST_RESUME_CALL";
        case RIL_UNSOL_ECONF_SRVCC_INDICATION : return "RIL_UNSOL_ECONF_SRVCC_INDICATION";
        case RIL_UNSOL_ECONF_RESULT_INDICATION : return "RIL_UNSOL_ECONF_RESULT_INDICATION";
        case RIL_UNSOL_MAL_AT_INFO : return "RIL_UNSOL_MAL_AT_INFO";
        case RIL_REQUEST_MODEM_POWEROFF: return "RIL_REQUEST_MODEM_POWEROFF";
        case RIL_REQUEST_MODEM_POWERON: return "RIL_REQUEST_MODEM_POWERON";
        case RIL_REQUEST_WRITE_SMS_TO_SIM: return "RIL_REQUEST_WRITE_SMS_TO_SIM";
        case RIL_REQUEST_QUERY_ICCID: return "RIL_REQUEST_QUERY_ICCID";
        case RIL_UNSOL_TX_POWER: return "RIL_UNSOL_TX_POWER";
        case RIL_UNSOL_NETWORK_INFO: return "RIL_UNSOL_NETWORK_INFO";
        case RIL_REQUEST_DELETE_SMS_ON_SIM: return "RIL_REQUEST_DELETE_SMS_ON_SIM";
        case RIL_REQUEST_SET_IMSCFG: return "RIL_REQUEST_SET_IMSCFG";
#ifdef ECALL_SUPPORT
        case RIL_REQUEST_ECALL_FAST_MAKE_ECALL: return "RIL_REQUEST_ECALL_FAST_MAKE_ECALL";
        case RIL_REQUEST_ECALL_SET_IVS: return "RIL_REQUEST_ECALL_SET_IVS";
        case RIL_REQUEST_ECALL_SET_PSAP: return "RIL_REQUEST_ECALL_SET_PSAP";
        case RIL_REQUEST_ECALL_MAKE_ECALL: return "RIL_REQUEST_ECALL_MAKE_ECALL";
        case RIL_REQUEST_ECALL_IVS_PUSH_MSD: return "RIL_REQUEST_ECALL_IVS_PUSH_MSD";
        case RIL_REQUEST_ECALL_PSAP_PULL_MSD: return "RIL_REQUEST_ECALL_PSAP_PULL_MSD";
        case RIL_UNSOL_ECALL_MSDHACK : return "RIL_UNSOL_ECALL_MSDHACK";
        case RIL_REQUEST_ECALL_SET_MSD: return "RIL_REQUEST_ECALL_SET_MSD";
        case RIL_REQUEST_ECALL_CTRL_SEQUENCE: return "RIL_REQUEST_ECALL_CTRL_SEQUENCE";
        case RIL_UNSOL_ECALL_INDICATIONS : return "RIL_UNSOL_ECALL_INDICATIONS";
        case RIL_REQUEST_ECALL_RESET_IVS: return "RIL_REQUEST_ECALL_RESET_IVS";
        case RIL_REQUEST_ECALL_SET_PRI: return "RIL_REQUEST_ECALL_SET_PRI";
        case RIL_REQUEST_ECALL_SET_TEST_NUM: return "RIL_REQUEST_ECALL_SET_TEST_NUM";
        case RIL_REQUEST_ECALL_SET_RECONF_NUM: return "RIL_REQUEST_ECALL_SET_RECONF_NUM";
        case RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD: return "RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD";
        case RIL_REQUEST_ECALL_SET_NAD_DEREGISTRATION_TIME: return "RIL_REQUEST_ECALL_SET_NAD_DEREGISTRATION_TIME";
        case RIL_REQUEST_ECALL_SET_REGISTRATION_STATE: return "RIL_REQUEST_ECALL_SET_REGISTRATION_STATE";
#endif /*ECALL_SUPPORT*/
#ifdef KEEP_ALIVE
        case RIL_REQUEST_START_KEEPALIVE_PRO: return "RIL_REQUEST_START_KEEPALIVE_PRO";
        case RIL_REQUEST_STOP_KEEPALIVE_PRO: return "RIL_REQUEST_STOP_KEEPALIVE_PRO";
        case RIL_UNSOL_KEEPALIVE_STATUS_PRO: return "RIL_UNSOL_KEEPALIVE_STATUS_PRO";
#endif /*KEEP_ALIVE*/
        case RIL_REQUEST_SEND_USSI: return "RIL_REQUEST_SEND_USSI";
        case RIL_REQUEST_CANCEL_USSI: return "RIL_REQUEST_CANCEL_USSI";
        case RIL_REQUEST_GET_SMS_SIM_MEM_STATUS: return "RIL_REQUEST_GET_SMS_SIM_MEM_STATUS";
        case RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR: return "RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR";
        case RIL_REQUEST_REPORT_AIRPLANE_MODE: return "RIL_REQUEST_REPORT_AIRPLANE_MODE";
        case RIL_REQUEST_SET_ECC_NUM: return "RIL_REQUEST_SET_ECC_NUM";
        case RIL_REQUEST_GET_ECC_NUM: return "RIL_REQUEST_GET_ECC_NUM";
        case RIL_UNSOL_ECC_NUM: return "RIL_UNSOL_ECC_NUM";
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT: return "RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT";
        case RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE: return "RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE";
        case RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE: return "RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE";
        case RIL_UNSOL_CALL_INFO_INDICATION: return "RIL_UNSOL_CALL_INFO_INDICATION";
/*Typethree add for t800 RIL Service 2022/04/14 start*/
//#ifdef TARGET_PLATFORM_MT2731
        case RIL_REQUEST_MODIFY_APN: return "RIL_REQUEST_MODIFY_APN";
        case RIL_REQUEST_RESET_APN: return "RIL_REQUEST_RESET_APN";
//#endif
/*Typethree add for t800 RIL Service 2022/04/14 end*/
        case RIL_REQUEST_QUERY_SIM_RETRY_COUNT: return "RIL_REQUEST_QUERY_SIM_RETRY_COUNT";
        case RIL_REQUEST_QUERY_EID: return "RIL_REQUEST_QUERY_EID";
        /*LYNQ CMD*/
        case LYNQ_AUTO_ANSWER_CALL: return "LYNQ_AUTO_ANSWER_CALL";
        case LYNQ_REQUEST_SET_DTMF_VOLUME: return "RIL_REQUEST_SET_DTMF_VOLUME";
        case LYNQ_REQUEST_SET_SPEECH_VOLUME: return "RIL_REQUEST_SET_SPEECH_VOLUME";
        case LYNQ_REQUEST_GET_SPEECH_VOLUME: return "RIL_REQUEST_GET_SPEECH_VOLUME";
        case LYNQ_REQUEST_RECORD: return "RIL_REQUEST_RECORD";       
        case LYNQ_REQUEST_WRITE_SMS_TO_MEMORY: return "LYNQ_REQUEST_WRITE_SMS_TO_MEMORY";
        case LYNQ_REQUEST_READ_SMS_FROM_MEMORY: return "LYNQ_REQUEST_READ_SMS_FROM_MEMORY";
        case LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY: return "LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY";
        case LYNQ_REQUEST_LIST_SMS_FROM_MEMORY: return "LYNQ_REQUEST_LIST_SMS_FROM_MEMORY";
        case LYNQ_REQUEST_SET_DEFAULT_SIM_ALL:return "SET_DEFAULT_SIM_ALL";
        case LYNQ_REQUEST_CHANGE_SCREEN_STATE:return "LYNQ_REQUEST_CHANGE_SCREEN_STATE";/*jb.qi add for two sim sleep 2022/9/19*/
        case LYNQ_REQUEST_CHANGE_RADIO:return "LYNQ_REQUEST_CHANGE_RADIO";/*lei add for factory test of sleep 2022/9/19*/
        case LYNQ_REQUEST_SET_VOICE_AUDIO_MODE:return "LYNQ_REQUEST_SET_VOICE_AUDIO_MODE";
        case LYNQ_REQUEST_GET_VOICE_AUDIO_MODE:return "LYNQ_REQUEST_GET_VOICE_AUDIO_MODE";
        case RIL_REQUEST_GET_MSISDN:return "RIL_REQUEST_GET_MSISDN";
        case RIL_REQUEST_RESET_SIMCARD:return "RIL_REQUEST_RESET_SIMCARD";
        case LYNQ_REQUEST_CHANGE_SLEEP_STATE: return "LYNQ_REQUEST_CHANGE_SLEEP_STATE";/*jb.qi change for suspend 2024/2/23 */
        case LYNQ_REQUEST_GET_SMSDATABASE_STATE: return "LYNQ_REQUEST_GET_SMSDATABASE_STATE";
        /*warren add for t800 ril service 2022/1/22 end*/
        default: return "<unknown request>";
    }
}

const char *
requestToString(int request) {
/*
 cat libs/telephony/ril_commands.h \
 | egrep "^ *{RIL_" \
 | sed -re 's/\{RIL_([^,]+),[^,]+,([^}]+).+/case RIL_\1: return "\1";/'


 cat libs/telephony/ril_unsol_commands.h \
 | egrep "^ *{RIL_" \
 | sed -re 's/\{RIL_([^,]+),([^}]+).+/case RIL_\1: return "\1";/'

*/
    switch(request) {
        case RIL_REQUEST_GET_SIM_STATUS: return "GET_SIM_STATUS";
        case RIL_REQUEST_ENTER_SIM_PIN: return "ENTER_SIM_PIN";
        case RIL_REQUEST_ENTER_SIM_PUK: return "ENTER_SIM_PUK";
        case RIL_REQUEST_ENTER_SIM_PIN2: return "ENTER_SIM_PIN2";
        case RIL_REQUEST_ENTER_SIM_PUK2: return "ENTER_SIM_PUK2";
        case RIL_REQUEST_CHANGE_SIM_PIN: return "CHANGE_SIM_PIN";
        case RIL_REQUEST_CHANGE_SIM_PIN2: return "CHANGE_SIM_PIN2";
        case RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION: return "ENTER_NETWORK_DEPERSONALIZATION";
        case RIL_REQUEST_GET_CURRENT_CALLS: return "GET_CURRENT_CALLS";
        case RIL_REQUEST_DIAL: return "DIAL";
        case RIL_REQUEST_GET_IMSI: return "GET_IMSI";
        case RIL_REQUEST_HANGUP: return "HANGUP";
        case RIL_REQUEST_HANGUP_WAITING_OR_BACKGROUND: return "HANGUP_WAITING_OR_BACKGROUND";
        case RIL_REQUEST_HANGUP_FOREGROUND_RESUME_BACKGROUND: return "HANGUP_FOREGROUND_RESUME_BACKGROUND";
        case RIL_REQUEST_SWITCH_WAITING_OR_HOLDING_AND_ACTIVE: return "SWITCH_WAITING_OR_HOLDING_AND_ACTIVE";
        case RIL_REQUEST_CONFERENCE: return "CONFERENCE";
        case RIL_REQUEST_UDUB: return "UDUB";
        case RIL_REQUEST_LAST_CALL_FAIL_CAUSE: return "LAST_CALL_FAIL_CAUSE";
        case RIL_REQUEST_SIGNAL_STRENGTH: return "SIGNAL_STRENGTH";
        case RIL_REQUEST_VOICE_REGISTRATION_STATE: return "VOICE_REGISTRATION_STATE";
        case RIL_REQUEST_DATA_REGISTRATION_STATE: return "DATA_REGISTRATION_STATE";
        case RIL_REQUEST_OPERATOR: return "OPERATOR";
        case RIL_REQUEST_RADIO_POWER: return "RADIO_POWER";
        case RIL_REQUEST_DTMF: return "DTMF";
        case RIL_REQUEST_SEND_SMS: return "SEND_SMS";
        case RIL_REQUEST_SEND_SMS_EXPECT_MORE: return "SEND_SMS_EXPECT_MORE";
        case RIL_REQUEST_SETUP_DATA_CALL: return "SETUP_DATA_CALL";
        case RIL_REQUEST_SIM_IO: return "SIM_IO";
        case RIL_REQUEST_SEND_USSD: return "SEND_USSD";
        case RIL_REQUEST_CANCEL_USSD: return "CANCEL_USSD";
        case RIL_REQUEST_GET_CLIR: return "GET_CLIR";
        case RIL_REQUEST_SET_CLIR: return "SET_CLIR";
        case RIL_REQUEST_QUERY_CALL_FORWARD_STATUS: return "QUERY_CALL_FORWARD_STATUS";
        case RIL_REQUEST_SET_CALL_FORWARD: return "SET_CALL_FORWARD";
        case RIL_REQUEST_QUERY_CALL_WAITING: return "QUERY_CALL_WAITING";
        case RIL_REQUEST_SET_CALL_WAITING: return "SET_CALL_WAITING";
        case RIL_REQUEST_SMS_ACKNOWLEDGE: return "SMS_ACKNOWLEDGE";
        case RIL_REQUEST_GET_IMEI: return "GET_IMEI";
        case RIL_REQUEST_GET_IMEISV: return "GET_IMEISV";
        case RIL_REQUEST_ANSWER: return "ANSWER";
        case RIL_REQUEST_DEACTIVATE_DATA_CALL: return "DEACTIVATE_DATA_CALL";
        case RIL_REQUEST_QUERY_FACILITY_LOCK: return "QUERY_FACILITY_LOCK";
        case RIL_REQUEST_SET_FACILITY_LOCK: return "SET_FACILITY_LOCK";
        case RIL_REQUEST_CHANGE_BARRING_PASSWORD: return "CHANGE_BARRING_PASSWORD";
        case RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE: return "QUERY_NETWORK_SELECTION_MODE";
        case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC: return "SET_NETWORK_SELECTION_AUTOMATIC";
        case RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL: return "SET_NETWORK_SELECTION_MANUAL";
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS : return "QUERY_AVAILABLE_NETWORKS ";
        case RIL_REQUEST_DTMF_START: return "DTMF_START";
        case RIL_REQUEST_DTMF_STOP: return "DTMF_STOP";
        case RIL_REQUEST_BASEBAND_VERSION: return "BASEBAND_VERSION";
        case RIL_REQUEST_SEPARATE_CONNECTION: return "SEPARATE_CONNECTION";
        case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE: return "SET_PREFERRED_NETWORK_TYPE";
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE: return "GET_PREFERRED_NETWORK_TYPE";
        case RIL_REQUEST_GET_NEIGHBORING_CELL_IDS: return "GET_NEIGHBORING_CELL_IDS";
        case RIL_REQUEST_SET_MUTE: return "SET_MUTE";
        case RIL_REQUEST_GET_MUTE: return "GET_MUTE";
        case RIL_REQUEST_QUERY_CLIP: return "QUERY_CLIP";
        case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE: return "LAST_DATA_CALL_FAIL_CAUSE";
        case RIL_REQUEST_DATA_CALL_LIST: return "DATA_CALL_LIST";
        case RIL_REQUEST_RESET_RADIO: return "RESET_RADIO";
        case RIL_REQUEST_OEM_HOOK_RAW: return "OEM_HOOK_RAW";
        case RIL_REQUEST_OEM_HOOK_STRINGS: return "OEM_HOOK_STRINGS";
        case RIL_REQUEST_SET_BAND_MODE: return "SET_BAND_MODE";
        case RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE: return "QUERY_AVAILABLE_BAND_MODE";
        case RIL_REQUEST_STK_GET_PROFILE: return "STK_GET_PROFILE";
        case RIL_REQUEST_STK_SET_PROFILE: return "STK_SET_PROFILE";
        case RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND: return "STK_SEND_ENVELOPE_COMMAND";
        case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE: return "STK_SEND_TERMINAL_RESPONSE";
        case RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM: return "STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM";
        case RIL_REQUEST_SCREEN_STATE: return "SCREEN_STATE";
        case RIL_REQUEST_EXPLICIT_CALL_TRANSFER: return "EXPLICIT_CALL_TRANSFER";
        case RIL_REQUEST_SET_LOCATION_UPDATES: return "SET_LOCATION_UPDATES";
        case RIL_REQUEST_CDMA_SET_SUBSCRIPTION_SOURCE:return"CDMA_SET_SUBSCRIPTION_SOURCE";
        case RIL_REQUEST_CDMA_SET_ROAMING_PREFERENCE:return"CDMA_SET_ROAMING_PREFERENCE";
        case RIL_REQUEST_CDMA_QUERY_ROAMING_PREFERENCE:return"CDMA_QUERY_ROAMING_PREFERENCE";
        case RIL_REQUEST_SET_TTY_MODE:return"SET_TTY_MODE";
        case RIL_REQUEST_QUERY_TTY_MODE:return"QUERY_TTY_MODE";
        case RIL_REQUEST_CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE:return"CDMA_SET_PREFERRED_VOICE_PRIVACY_MODE";
        case RIL_REQUEST_CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE:return"CDMA_QUERY_PREFERRED_VOICE_PRIVACY_MODE";
        case RIL_REQUEST_CDMA_FLASH:return"CDMA_FLASH";
        case RIL_REQUEST_CDMA_BURST_DTMF:return"CDMA_BURST_DTMF";
        case RIL_REQUEST_CDMA_SEND_SMS:return"CDMA_SEND_SMS";
        case RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE:return"CDMA_SMS_ACKNOWLEDGE";
        case RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG:return"GSM_GET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG:return"GSM_SET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION:return "GSM_SMS_BROADCAST_ACTIVATION";
        case RIL_REQUEST_CDMA_GET_BROADCAST_SMS_CONFIG:return "CDMA_GET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_SET_BROADCAST_SMS_CONFIG:return "CDMA_SET_BROADCAST_SMS_CONFIG";
        case RIL_REQUEST_CDMA_SMS_BROADCAST_ACTIVATION:return "CDMA_SMS_BROADCAST_ACTIVATION";
        case RIL_REQUEST_CDMA_VALIDATE_AND_WRITE_AKEY: return"CDMA_VALIDATE_AND_WRITE_AKEY";
        case RIL_REQUEST_CDMA_SUBSCRIPTION: return"CDMA_SUBSCRIPTION";
        case RIL_REQUEST_CDMA_WRITE_SMS_TO_RUIM: return "CDMA_WRITE_SMS_TO_RUIM";
        case RIL_REQUEST_CDMA_DELETE_SMS_ON_RUIM: return "CDMA_DELETE_SMS_ON_RUIM";
        case RIL_REQUEST_DEVICE_IDENTITY: return "DEVICE_IDENTITY";
        case RIL_REQUEST_EXIT_EMERGENCY_CALLBACK_MODE: return "EXIT_EMERGENCY_CALLBACK_MODE";
        case RIL_REQUEST_GET_SMSC_ADDRESS: return "GET_SMSC_ADDRESS";
        case RIL_REQUEST_SET_SMSC_ADDRESS: return "SET_SMSC_ADDRESS";
        case RIL_REQUEST_REPORT_SMS_MEMORY_STATUS: return "REPORT_SMS_MEMORY_STATUS";
        case RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING: return "REPORT_STK_SERVICE_IS_RUNNING";
        case RIL_REQUEST_CDMA_GET_SUBSCRIPTION_SOURCE: return "CDMA_GET_SUBSCRIPTION_SOURCE";
        case RIL_REQUEST_ISIM_AUTHENTICATION: return "ISIM_AUTHENTICATION";
        case RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU: return "RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU";
        case RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS: return "RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS";
        case RIL_REQUEST_VOICE_RADIO_TECH: return "VOICE_RADIO_TECH";
        case RIL_REQUEST_GET_CELL_INFO_LIST: return"GET_CELL_INFO_LIST";
        case RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE: return"SET_UNSOL_CELL_INFO_LIST_RATE";
        case RIL_REQUEST_SET_INITIAL_ATTACH_APN: return "RIL_REQUEST_SET_INITIAL_ATTACH_APN";
        case RIL_REQUEST_IMS_REGISTRATION_STATE: return "IMS_REGISTRATION_STATE";
        case RIL_REQUEST_IMS_SEND_SMS: return "IMS_SEND_SMS";
        case RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC: return "SIM_TRANSMIT_APDU_BASIC";
        case RIL_REQUEST_SIM_OPEN_CHANNEL: return "SIM_OPEN_CHANNEL";
        case RIL_REQUEST_SIM_CLOSE_CHANNEL: return "SIM_CLOSE_CHANNEL";
        case RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL: return "SIM_TRANSMIT_APDU_CHANNEL";
        case RIL_REQUEST_GET_RADIO_CAPABILITY: return "RIL_REQUEST_GET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_RADIO_CAPABILITY: return "RIL_REQUEST_SET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_UICC_SUBSCRIPTION: return "SET_UICC_SUBSCRIPTION";
        case RIL_REQUEST_ALLOW_DATA: return "ALLOW_DATA";
        case RIL_REQUEST_GET_HARDWARE_CONFIG: return "GET_HARDWARE_CONFIG";
        case RIL_REQUEST_SIM_AUTHENTICATION: return "SIM_AUTHENTICATION";
        case RIL_REQUEST_GET_DC_RT_INFO: return "GET_DC_RT_INFO";
        case RIL_REQUEST_SET_DC_RT_INFO_RATE: return "SET_DC_RT_INFO_RATE";
        case RIL_REQUEST_SET_DATA_PROFILE: return "SET_DATA_PROFILE";
        case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED: return "UNSOL_RESPONSE_RADIO_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED: return "UNSOL_RESPONSE_CALL_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED: return "UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED: return "UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_NEW_SMS: return "UNSOL_RESPONSE_NEW_SMS";
        case RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT: return "UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT";
        case RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM: return "UNSOL_RESPONSE_NEW_SMS_ON_SIM";
        case RIL_UNSOL_ON_USSD: return "UNSOL_ON_USSD";
        case RIL_UNSOL_ON_USSD_REQUEST: return "UNSOL_ON_USSD_REQUEST(obsolete)";
        case RIL_UNSOL_NITZ_TIME_RECEIVED: return "UNSOL_NITZ_TIME_RECEIVED";
        case RIL_UNSOL_SIGNAL_STRENGTH: return "UNSOL_SIGNAL_STRENGTH";
        case RIL_UNSOL_STK_SESSION_END: return "UNSOL_STK_SESSION_END";
        case RIL_UNSOL_STK_PROACTIVE_COMMAND: return "UNSOL_STK_PROACTIVE_COMMAND";
        case RIL_UNSOL_STK_EVENT_NOTIFY: return "UNSOL_STK_EVENT_NOTIFY";
        case RIL_UNSOL_STK_CALL_SETUP: return "UNSOL_STK_CALL_SETUP";
        case RIL_UNSOL_SIM_SMS_STORAGE_FULL: return "UNSOL_SIM_SMS_STORAGE_FUL";
        case RIL_UNSOL_SIM_REFRESH: return "UNSOL_SIM_REFRESH";
        case RIL_UNSOL_DATA_CALL_LIST_CHANGED: return "UNSOL_DATA_CALL_LIST_CHANGED";
        case RIL_UNSOL_CALL_RING: return "UNSOL_CALL_RING";
        case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED: return "UNSOL_RESPONSE_SIM_STATUS_CHANGED";
        case RIL_UNSOL_RESPONSE_CDMA_NEW_SMS: return "UNSOL_NEW_CDMA_SMS";
        case RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS: return "UNSOL_NEW_BROADCAST_SMS";
        case RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL: return "UNSOL_CDMA_RUIM_SMS_STORAGE_FULL";
        case RIL_UNSOL_RESTRICTED_STATE_CHANGED: return "UNSOL_RESTRICTED_STATE_CHANGED";
        case RIL_UNSOL_ENTER_EMERGENCY_CALLBACK_MODE: return "UNSOL_ENTER_EMERGENCY_CALLBACK_MODE";
        case RIL_UNSOL_CDMA_CALL_WAITING: return "UNSOL_CDMA_CALL_WAITING";
        case RIL_UNSOL_CDMA_OTA_PROVISION_STATUS: return "UNSOL_CDMA_OTA_PROVISION_STATUS";
        case RIL_UNSOL_CDMA_INFO_REC: return "UNSOL_CDMA_INFO_REC";
        case RIL_UNSOL_OEM_HOOK_RAW: return "UNSOL_OEM_HOOK_RAW";
        case RIL_UNSOL_RINGBACK_TONE: return "UNSOL_RINGBACK_TONE";
        case RIL_UNSOL_RESEND_INCALL_MUTE: return "UNSOL_RESEND_INCALL_MUTE";
        case RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED: return "UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED";
        case RIL_UNSOL_CDMA_PRL_CHANGED: return "UNSOL_CDMA_PRL_CHANGED";
        case RIL_UNSOL_EXIT_EMERGENCY_CALLBACK_MODE: return "UNSOL_EXIT_EMERGENCY_CALLBACK_MODE";
        case RIL_UNSOL_RIL_CONNECTED: return "UNSOL_RIL_CONNECTED";
        case RIL_UNSOL_VOICE_RADIO_TECH_CHANGED: return "UNSOL_VOICE_RADIO_TECH_CHANGED";
        case RIL_UNSOL_CELL_INFO_LIST: return "UNSOL_CELL_INFO_LIST";
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED: return "RESPONSE_IMS_NETWORK_STATE_CHANGED";
        case RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED: return "UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
        case RIL_UNSOL_SRVCC_STATE_NOTIFY: return "UNSOL_SRVCC_STATE_NOTIFY";
        case RIL_UNSOL_HARDWARE_CONFIG_CHANGED: return "HARDWARE_CONFIG_CHANGED";
        case RIL_UNSOL_DC_RT_INFO_CHANGED: return "UNSOL_DC_RT_INFO_CHANGED";
        case RIL_REQUEST_SHUTDOWN: return "SHUTDOWN";
        case RIL_UNSOL_RADIO_CAPABILITY: return "RIL_UNSOL_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_TRM: return "RIL_REQUEST_SET_TRM";
        case RIL_REQUEST_SET_IMS_ENABLE:return "RIL_REQUEST_SET_IMS_ENABLE";
        case RIL_REQUEST_SET_AUDIO_PATH: return "SET_AUDIO_PATH";
        case RIL_REQUEST_HANGUP_ALL: return "HANGUP_ALL";
        case RIL_REQUEST_FORCE_RELEASE_CALL: return "FORCE_RELEASE_CALL";
        case RIL_REQUEST_EMERGENCY_DIAL: return "RIL_REQUEST_EMERGENCY_DIAL";
        case RIL_REQUEST_SET_ECC_SERVICE_CATEGORY: return "RIL_REQUEST_SET_ECC_SERVICE_CATEGORY";
        case RIL_REQUEST_SET_ECC_LIST: return "RIL_REQUEST_SET_ECC_LIST";
        case RIL_REQUEST_AT_COMMAND_WITH_PROXY: return "AT_COMMAND_WITH_PROXY";
        case RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION: return "RIL_REQUEST_SET_SUPP_SVC_NOTIFICATION";
        case RIL_REQUEST_SET_CLIP: return "RIL_REQUEST_SET_CLIP";
        case RIL_REQUEST_GET_COLP: return "RIL_REQUEST_GET_COLP";
        case RIL_REQUEST_SET_COLP: return "RIL_REQUEST_SET_COLP";
        case RIL_REQUEST_GET_COLR: return "RIL_REQUEST_GET_COLR";
        case RIL_REQUEST_ADD_IMS_CONFERENCE_CALL_MEMBER: return "ADD_IMS_CONFERENCE_CALL_MEMBER";
        case RIL_REQUEST_REMOVE_IMS_CONFERENCE_CALL_MEMBER: return "REMOVE_IMS_CONFERENCE_CALL_MEMBER";
        case RIL_REQUEST_CONFERENCE_DIAL: return "CONFERENCE_DIAL";
        case RIL_REQUEST_DIAL_WITH_SIP_URI: return "DIAL_WITH_SIP_URI";
        case RIL_REQUEST_HOLD_CALL: return "HOLD_CALL";
        case RIL_REQUEST_RESUME_CALL: return "RESUME_CALL";
        case RIL_UNSOL_ECONF_SRVCC_INDICATION : return "ECONF_SRVCC_INDICATION";
        case RIL_UNSOL_ECONF_RESULT_INDICATION : return "ECONF_RESULT_INDICATION";
        case RIL_UNSOL_MAL_AT_INFO : return "UNSOL_MAL_AT_INFO";
        case RIL_REQUEST_MODEM_POWEROFF: return "MODEM_POWEROFF";
        case RIL_REQUEST_MODEM_POWERON: return "MODEM_POWERON";
        case RIL_REQUEST_WRITE_SMS_TO_SIM: return "WRITE_SMS_TO_SIM";
        case RIL_REQUEST_QUERY_ICCID: return "RIL_REQUEST_QUERY_ICCID";
        case RIL_UNSOL_TX_POWER: return "RIL_UNSOL_TX_POWER";
        case RIL_UNSOL_NETWORK_INFO: return "RIL_UNSOL_NETWORK_INFO";
        case RIL_REQUEST_DELETE_SMS_ON_SIM: return "DELETE_SMS_ON_SIM";
        case RIL_REQUEST_SET_IMSCFG: return "RIL_REQUEST_SET_IMSCFG";
#ifdef ECALL_SUPPORT
        case RIL_REQUEST_ECALL_FAST_MAKE_ECALL: return "ECALL_FAST_MAKE_ECALL";
        case RIL_REQUEST_ECALL_SET_IVS: return "RIL_REQUEST_ECALL_SET_IVS";
        case RIL_REQUEST_ECALL_SET_PSAP: return "RIL_REQUEST_ECALL_SET_PSAP";
        case RIL_REQUEST_ECALL_MAKE_ECALL: return "RIL_REQUEST_ECALL_MAKE_ECALL";
        case RIL_REQUEST_ECALL_IVS_PUSH_MSD: return "RIL_REQUEST_ECALL_IVS_PUSH_MSD";
        case RIL_REQUEST_ECALL_PSAP_PULL_MSD: return "RIL_REQUEST_ECALL_PSAP_PULL_MSD";
        case RIL_UNSOL_ECALL_MSDHACK : return "ECALL_MSDHACK";
        case RIL_REQUEST_ECALL_SET_MSD: return "RIL_REQUEST_ECALL_SET_MSD";
        case RIL_REQUEST_ECALL_CTRL_SEQUENCE: return "ECALL_SET_CTRL_SEQUENCE";
        case RIL_UNSOL_ECALL_INDICATIONS : return "ECALL_INDICATIONS";
        case RIL_REQUEST_ECALL_RESET_IVS: return "RIL_REQUEST_ECALL_RESET_IVS";
        case RIL_REQUEST_ECALL_SET_PRI: return "RIL_REQUEST_ECALL_SET_PRI";
        case RIL_REQUEST_ECALL_SET_TEST_NUM: return "RIL_REQUEST_ECALL_SET_TEST_NUM";
        case RIL_REQUEST_ECALL_SET_RECONF_NUM: return "RIL_REQUEST_ECALL_SET_RECONF_NUM";
        case RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD: return "RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD";
        case RIL_REQUEST_ECALL_SET_NAD_DEREGISTRATION_TIME: return "RIL_REQUEST_ECALL_SET_NAD_DEREGISTRATION_TIME";
        case RIL_REQUEST_ECALL_SET_REGISTRATION_STATE: return "RIL_REQUEST_ECALL_SET_REGISTRATION_STATE";
#endif /*ECALL_SUPPORT*/
#ifdef KEEP_ALIVE
        case RIL_REQUEST_START_KEEPALIVE_PRO: return "RIL_REQUEST_START_KEEPALIVE_PRO";
        case RIL_REQUEST_STOP_KEEPALIVE_PRO: return "RIL_REQUEST_STOP_KEEPALIVE_PRO";
        case RIL_UNSOL_KEEPALIVE_STATUS_PRO: return "RIL_UNSOL_KEEPALIVE_STATUS_PRO";
#endif /*KEEP_ALIVE*/
        case RIL_REQUEST_SEND_USSI: return "SEND_USSI";
        case RIL_REQUEST_CANCEL_USSI: return "CANCEL_USSI";
        case RIL_REQUEST_GET_SMS_SIM_MEM_STATUS: return "GET_SMS_SIM_MEM_STATUS";
        case RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR: return "RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR";
        case RIL_REQUEST_REPORT_AIRPLANE_MODE: return "RIL_REQUEST_REPORT_AIRPLANE_MODE";
        case RIL_REQUEST_SET_ECC_NUM: return "RIL_REQUEST_SET_ECC_NUM";
        case RIL_REQUEST_GET_ECC_NUM: return "RIL_REQUEST_GET_ECC_NUM";
        case RIL_UNSOL_ECC_NUM: return "RIL_UNSOL_ECC_NUM";
        case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT: return "RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT";
        case RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE: return "RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE";
        case RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE: return "RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE";
        case RIL_UNSOL_CALL_INFO_INDICATION: return "RIL_UNSOL_CALL_INFO_INDICATION";
        case RIL_REQUEST_MODIFY_APN: return "RIL_REQUEST_MODIFY_APN";
        case RIL_REQUEST_RESET_APN: return "RIL_REQUEST_RESET_APN";
        case RIL_REQUEST_QUERY_SIM_RETRY_COUNT: return "RIL_REQUEST_QUERY_SIM_RETRY_COUNT";
        case RIL_REQUEST_QUERY_EID: return "RIL_REQUEST_QUERY_EID";
        case LYNQ_REQUEST_SET_DTMF_VOLUME: return "RIL_REQUEST_SET_DTMF_VOLUME";
        case LYNQ_REQUEST_SET_SPEECH_VOLUME: return "RIL_REQUEST_SET_SPEECH_VOLUME";
        case LYNQ_REQUEST_GET_SPEECH_VOLUME: return "RIL_REQUEST_GET_SPEECH_VOLUME";
        case LYNQ_REQUEST_RECORD: return "RIL_REQUEST_RECORD";
        /*warren add for t800 ril service 2022/1/22 start*/
        case LYNQ_REQUEST_WRITE_SMS_TO_MEMORY: return "LYNQ_REQUEST_WRITE_SMS_TO_MEMORY";
        case LYNQ_REQUEST_READ_SMS_FROM_MEMORY: return "LYNQ_REQUEST_READ_SMS_FROM_MEMORY";
        case LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY: return "LYNQ_REQUEST_DELETE_SMS_FROM_MEMORY";
        case LYNQ_REQUEST_LIST_SMS_FROM_MEMORY: return "LYNQ_REQUEST_LIST_SMS_FROM_MEMORY";
        case LYNQ_REQUEST_SET_DEFAULT_SIM_ALL:return "SET_DEFAULT_SIM_ALL";
        case LYNQ_REQUEST_CHANGE_SCREEN_STATE:return "LYNQ_REQUEST_CHANGE_SCREEN_STATE";/*jb.qi add for two sim sleep 2022/9/19*/
        case LYNQ_REQUEST_CHANGE_RADIO:return "LYNQ_REQUEST_CHANGE_RADIO";/*lei add for factory test of sleep 2022/9/19*/
        case LYNQ_REQUEST_CHANGE_SLEEP_STATE:return "LYNQ_REQUEST_CHANGE_SLEEP_STATE";/*jb.qi add for two sim sleep 2022/9/19*/
        case LYNQ_REQUEST_GET_SMSDATABASE_STATE: return "LYNQ_REQUEST_GET_SMSDATABASE_STATE";
        case RIL_REQUEST_GET_MSISDN: return "GET MSISDN";
        case RIL_REQUEST_RESET_SIMCARD: return "RESET SIMCARD";
#ifdef MOBILETEK_TARGET_PLATFORM_T106 
        case RIL_UNSOL_AUDIO_DEV_SAMPLERATE: return "UNSOL_AUDIO_DEV_SAMPLERATE";
        case RIL_REQUEST_APN_LIST: return "APN_LIST";//LYNQ_MODIFY_ZXW_TASK794_CR2024120449D612E5_XF.Li_20241221
#endif
        /*warren add for t800 ril service 2022/1/22 end*/
        default: return "<unknown request>";
    }
}

static int sendResponse (Parcel &p, RIL_SOCKET_ID socket_id) {
    printResponse;
    int type;
    if(enable_bt_resp){
        SendRespToClient(p.data(), p.dataSize());
    }
    p.setDataPosition(0);
    p.readInt32(&type);
    if(type == RESPONSE_UNSOLICITED){
        processUnsolicited(p,type);
    }else if (type == RESPONSE_SOLICITED){
        processSolicited(p,type);
    }
    return 0;
}

static void speciaRequest_wait()
{
    struct timeval now;
    struct timespec timeout;

    gettimeofday(&now,NULL);
    timeout.tv_sec = now.tv_sec+1200; //timeout is 2omin. maybe radio on/off need 10s to complete.
    timeout.tv_nsec = now.tv_usec*1000;

    SPECIA_BLOCK_LOCK();
    while(!(requestOneByOne == 0)) {
        int ret = SPECIA_BLOCK_WAIT(&timeout);
        if(ret == ETIMEDOUT){
            RLOGD("special request wait timeout");
            break;
        }
    }
    requestOneByOne = 1;
    SPECIA_BLOCK_UNLOCK();
}

static void speciaRequest_wakeup()
{
    SPECIA_BLOCK_LOCK();
    requestOneByOne = 0;
    SPECIA_BLOCK_WAKEUP();
    SPECIA_BLOCK_UNLOCK();
}

static void updateIccCardState(RIL_SOCKET_ID soc_id)
{
    ARspRequest(RIL_REQUEST_GET_SIM_STATUS, soc_id);
}

void sendRequestToMd(int request, int id) {
    RequestInfo* info = creatRILInfoAndInit(request, INIT, (RIL_SOCKET_ID) ((id)));
    switch(request){
        case RIL_REQUEST_DEVICE_IDENTITY:
        {
            getDeviceIdentity(1, NULL, (RIL_SOCKET_ID) ((id)), info);
            break;
        }
        case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE:
        {
            getPreferredNetworkType(1, NULL, (RIL_SOCKET_ID) ((id)), info);
            break;
        }
        case RIL_REQUEST_GET_SIM_STATUS:
        {
            getIccCardStatus(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_DATA_REGISTRATION_STATE:
        {
            getDataRegistrationState(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        {
            getVoiceRegistrationState(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_VOICE_RADIO_TECH:
        {
            getVoiceRadioTechnology(1, NULL, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_OEM_HOOK_RAW:
        {
            char* tmp[2] = {"RIL_REQUEST_OEM_HOOK_RAW", "AT+ECAL"};
            sendATCMD(2, tmp, (RIL_SOCKET_ID) (id), info);
            break;
        }
        case RIL_REQUEST_GET_RADIO_CAPABILITY:
        {
            getRadioCapability(1, NULL, (RIL_SOCKET_ID) ((id)), info);
            break;
        }
        case RIL_REQUEST_RADIO_POWER:
        {        
            char* tmp[2] = {"RIL_REQUEST_RADIO_POWER", "1"};
            setRadioPower(2,tmp, (RIL_SOCKET_ID) (id), info);
            break;
        }
        default:
            RLOGE("don't support  %d in init", id);
            if(info) {
                free(info);
            }
    }
}

/**@brief pass the change screen state request to the executing function
*@param   request  type: [IN] requestID
*@param   slot_id  type: [IN] simID
*@param   argv  type: [IN] getScreenState's argv 
*@author  jb.qi
*@date    2022/09/19
*/
void lynq_sendRequestToMd(int request, int slot_id, char **argv, struct sockaddr_in lynqClient_addr, int utoken)
{
    RequestInfo* info = creatRILInfoAndInit(request, UDP, (RIL_SOCKET_ID) ((slot_id)));
    info->uToken = utoken;
    info->lynqEvent = 2;
    info->uClient_addr.sin_family = lynqClient_addr.sin_family;
    info->uClient_addr.sin_addr.s_addr = lynqClient_addr.sin_addr.s_addr;
    info->uClient_addr.sin_port = lynqClient_addr.sin_port;
    switch(request){
        case RIL_REQUEST_SCREEN_STATE:
        {
            int waittoken = info->token;
            RLOGD("getScreenState\n");
            getScreenState(2, argv, (RIL_SOCKET_ID) ((slot_id)), info);
            waitResponse(waittoken);
            break;
        }
        case RIL_REQUEST_RADIO_POWER:
        {
            int waittoken = info->token;
            RLOGD("LYNQ_REQUEST_CHANGE_RADIO\n");
            setRadioPower(2, argv, (RIL_SOCKET_ID) ((slot_id)), info);
            waitResponse(waittoken);
            break;
        }
        default:
            RLOGD("dont support %d in init", slot_id);
            if(info)
            {
                free(info);
            }
    }
}

static void init(int id) {
    int waittoken;
    RIL_RadioState radioState = CALL_ONSTATEREQUEST((RIL_SOCKET_ID )id);
    while (radioState == RADIO_STATE_UNAVAILABLE) {
        sleep(1);
        radioState = CALL_ONSTATEREQUEST((RIL_SOCKET_ID )id);
        RLOGD("init socket id: %d, %s", id, radioStateToString(radioState));
    }
    RLOGD("init socket id: %d, %s", id, radioStateToString(radioState));
    updataDataConnectState(id, false);
    sendRequestToMd(RIL_REQUEST_GET_SIM_STATUS, id);

#if 0
    if (radioState != RADIO_STATE_ON) {
        RequestInfo* radio = creatRILInfoAndInit(RIL_REQUEST_RADIO_POWER, INIT, (RIL_SOCKET_ID) (id));
        waittoken = radio->token;
        RLOGD("[%s-%d]:token is %x", __FUNCTION__, __LINE__, radio->token);
        char* tmp[2] = { "RIL_REQUEST_RADIO_POWER", "1" };
        setRadioPower(2, tmp, (RIL_SOCKET_ID) (id), radio);
        waitResponse(waittoken);
        sleep(2);
        radioState = CALL_ONSTATEREQUEST((RIL_SOCKET_ID )id);
        RLOGD("NOW radio status %s", radioStateToString(radioState));
    }
# endif
    sendRequestToMd(RIL_REQUEST_DATA_REGISTRATION_STATE, id);
    sendRequestToMd(RIL_REQUEST_VOICE_REGISTRATION_STATE, id);
    sendRequestToMd(RIL_REQUEST_VOICE_RADIO_TECH, id);
    sendRequestToMd(RIL_REQUEST_DEVICE_IDENTITY,id);
    sendRequestToMd(RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE, id);
    sendRequestToMd(RIL_REQUEST_OEM_HOOK_RAW, id);
    sendRequestToMd(RIL_REQUEST_GET_RADIO_CAPABILITY,id);
}

static void initCoditions()
{
#ifdef LED_SUPPORT
    mbtk_netled_init();
#endif
    mixer_init();
    lynq_init_rtp();

    if(utils::is_support_dsds()) {
        for(int i = 0; i < 2 ; i++) {
            init(i);
        }
    }

    if(utils::is_suppport_dsss()) {
        int id = Phone_utils::get_enable_sim_for_dsss();
        init(id);
    }    
}


//For UDP sokcet send response to client
static int SendRespToClient(const void *data, size_t dataSize)
{
    const uint8_t *toWrite;
    size_t writeOffset = 0;

    toWrite = (const uint8_t *)data;

    if (toWrite == NULL) {
    //buf is invaild
        return -1;
    }

    while (writeOffset < dataSize) {
        ssize_t written;
        do {
            //written = write (fd, toWrite + writeOffset,dataSize - writeOffset);
            written = sendto(server_socket_fd, toWrite + writeOffset, dataSize - writeOffset,
                                     0, (struct sockaddr *)&client_addr, sizeof(client_addr));
        } while (written < 0 && ((errno == EINTR) || (errno == EAGAIN)));

        if (written >= 0) {
            writeOffset += written;
        } else {   // written < 0
            RLOGE ("RIL Response: unexpected error on write errno:%d", errno);
            return -1;
        }
    }

    return 0;
}

static UnsolResponseInfo* find_mtk_unsol_command(int request)
{
    int i;
    for (i = 0; i < (int32_t)NUM_ELEMS(s_mtk_unsolResponses); i++)
        if (s_mtk_unsolResponses[i].requestNumber == request)
            return (&s_mtk_unsolResponses[i]);
    return ((UnsolResponseInfo *)NULL);
}

static int
onSupports (int requestCode)
{
    switch(requestCode)
    {
        case RIL_UNSOL_SIM_STATUS_COMMAND: return 1;
        case RIL_UNSOL_RESPONSE_RADIO_STATE_CHANGED: return 1;
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED: return 1;
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED: return 1;
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED: return 1;
        case RIL_UNSOL_RESPONSE_NEW_SMS: return 1;
        case RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT: return 1;
        case RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM: return 1;
        case RIL_UNSOL_ON_USSD: return 1;
        case RIL_UNSOL_ON_USSD_REQUEST: return 1;
        case RIL_UNSOL_NITZ_TIME_RECEIVED: return 1;
        case RIL_UNSOL_SIGNAL_STRENGTH: return 1;
        case RIL_UNSOL_DATA_CALL_LIST_CHANGED: return 1;
        case RIL_UNSOL_SUPP_SVC_NOTIFICATION: return 1;
        case RIL_UNSOL_STK_SESSION_END: return 1;
        case RIL_UNSOL_STK_PROACTIVE_COMMAND: return 1;
        case RIL_UNSOL_STK_EVENT_NOTIFY: return 1;
        case RIL_UNSOL_STK_CALL_SETUP: return 1;
        case RIL_UNSOL_SIM_SMS_STORAGE_FULL: return 1;
        case RIL_UNSOL_SIM_REFRESH: return 1;
        case RIL_UNSOL_CALL_RING: return 1;
        case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED: return 1;
        case RIL_UNSOL_RESPONSE_CDMA_NEW_SMS: return 1;
        case RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS: return 1;
        case RIL_UNSOL_CDMA_RUIM_SMS_STORAGE_FULL: return 0;
        case RIL_UNSOL_RESTRICTED_STATE_CHANGED: return 1;
        case RIL_UNSOL_ENTER_EMERGENCY_CALLBACK_MODE: return 1;
        case RIL_UNSOL_CDMA_CALL_WAITING: return 1;
        case RIL_UNSOL_CDMA_OTA_PROVISION_STATUS: return 0;
        case RIL_UNSOL_CDMA_INFO_REC: return 0;
        case RIL_UNSOL_OEM_HOOK_RAW: return 1;
        case RIL_UNSOL_RINGBACK_TONE: return 1;
        case RIL_UNSOL_RESEND_INCALL_MUTE: return 0;
        case RIL_UNSOL_CDMA_SUBSCRIPTION_SOURCE_CHANGED: return 0;
        case RIL_UNSOL_CDMA_PRL_CHANGED: return 0;
        case RIL_UNSOL_EXIT_EMERGENCY_CALLBACK_MODE: return 1;
        case RIL_UNSOL_RIL_CONNECTED: return 1;
        case RIL_UNSOL_VOICE_RADIO_TECH_CHANGED: return 1;
        case RIL_UNSOL_CELL_INFO_LIST: return 1;
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED: return 1;
        case RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED: return 1;
        case RIL_UNSOL_SRVCC_STATE_NOTIFY: return 1;
        case RIL_UNSOL_HARDWARE_CONFIG_CHANGED: return 0;
        case RIL_UNSOL_DC_RT_INFO_CHANGED: return 0;
        case RIL_UNSOL_RADIO_CAPABILITY : return 1;
        case RIL_UNSOL_MAL_RESTART : return 1;
        case RIL_UNSOL_CALL_INFO_INDICATION : return 1;
        case RIL_UNSOL_CRSS_NOTIFICATION : return 0;
        case RIL_UNSOL_ECONF_SRVCC_INDICATION : return 1;
        case RIL_UNSOL_ECONF_RESULT_INDICATION : return 1;
        case RIL_UNSOL_STK_BIP_PROACTIVE_COMMAND : return 0;
        case RIL_UNSOL_MAL_AT_INFO: return 1;
        case RIL_UNSOL_ECALL_MSDHACK: return 1;
        case RIL_UNSOL_TX_POWER: return 1;
        case RIL_UNSOL_NETWORK_INFO: return 1;
#ifdef ECALL_SUPPORT
        case RIL_UNSOL_ECALL_INDICATIONS: return 1;
#endif /*ECALL_SUPPORT*/
#ifdef KEEP_ALIVE
        case RIL_UNSOL_KEEPALIVE_STATUS_PRO: return 1;
#endif /*KEEP_ALIVE*/
        case RIL_UNSOL_ON_USSI: return 1;
        case RIL_UNSOL_ECC_NUM: return 1;
        case RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR: return 1;
#ifdef MOBILETEK_TARGET_PLATFORM_T106 
        case RIL_UNSOL_AUDIO_DEV_SAMPLERATE: return 1;
#endif
        default: return 0;
    }
}

int parse_param(char *cmd, char *argv[], int max_args)
{
    char *pos, *pos2;
    int argc = 0;
    printf("warren test cmd=%s\n",cmd);
    pos = cmd;
    while (1) {
        // Trim the space characters.
        while (*pos == ' ') {
            pos++;
        }

        if (*pos == '\0') {
            break;
        }

        // One token may start with '"' or other characters.
        if (*pos == '"' && (pos2 = strrchr(pos+1, '"'))) {
            argv[argc++] = pos + 1;
            *pos2 = '\0';
            pos = pos2 + 1;
            if(*pos == '\n'){
                *pos = '\0';
                pos = pos + 1;
            }

        } else {
            argv[argc++] = pos;
            while (*pos != '\0' && *pos != ' '&& *pos != '\n') {
                pos++;
            }
            *pos++ = '\0';

            if(argc == 1) {
              char* at_cmd = strstr(argv[0], "RIL_REQUEST_OEM_HOOK_RAW");
              if(at_cmd != NULL) {
                while (*pos == ' ') {
                    pos++;
                }
                argv[argc++] = pos;
                while (*pos != '\0' && *pos != '\n') {
                    pos++;
                }
                *pos++ = '\0';
                break;
              }
            }

        }

        // Check if the maximum of arguments is reached.
        if (argc == max_args) {
            break;
        }
    }

    return argc;
}

/* Look up NAME as the name of a command, and return a pointer to that
   command.  Return a NULL pointer if NAME isn't a command name. */
COMMAND* find_command (char *name)
{
  register int i;

  for (i = 0; commands[i].name; i++)
    if (strcmp (name, commands[i].name) == 0)
      return (&commands[i]);

  return ((COMMAND *)NULL);
}

CommandInfo* find_mtk_command (int request)
{
    int i;
    for (i = 0; i < (int32_t)NUM_ELEMS(mtk_s_command); i++)
        if (mtk_s_command[i].requestNumber == request)
            return (&mtk_s_command[i]);
    return ((CommandInfo *)NULL);
}

/* The user wishes to quit using this program.  Just set DONE non-zero. */
static int com_quit (int argc, char *argv[], RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    exit(EXIT_SUCCESS);
    return (0);
}

static int enableSyslog(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc < 2)
    {
        RLOGE("[Error] enable syslog paramter is error\n");
        free(pRI);
        return -1;
    }
    enable_syslog = atoi(argv[1]);
    RLOGE("%s syslog\n",enable_syslog ? "enable" :"disable");
    free(pRI);
    return 0;
}

static int enableBTResponse(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI)
{
    if(argc < 2)
    {
        RLOGE("[Error] enable BT response paramter is error\n");
        free(pRI);
        return -1;
    }
    enable_bt_resp = atoi(argv[1]);
    RLOGE("%s bt response!\n",enable_bt_resp ? "enable" :"disable");
    free(pRI);
    return 0;

}

char Time_buf[24];
void GetTimeString(char * buf)
{
    time_t timep;
    struct tm p;

    if(buf == NULL){
        RLOGE("[Error] GetTimeString: buf is Null\n");
        return;
    }
    //memset(buf,0,sizeof(buf));
    time(&timep);
    localtime_r(&timep,&p);
    sprintf(buf,"%d_%d_%d %d:%d:%d",(1900+p.tm_year),(1+p.tm_mon),p.tm_mday,
                                      (p.tm_hour),p.tm_min,p.tm_sec);
//    printf("data is %s\n",buf);

    return;
}
/*Warren add for t800 RIL Service 2021/12/10 start*/
int lynqAssemblyParcelheader(Parcel &p,int slot,int utoken, int request,int respType,int error)
{
   p.writeInt32 (respType);
   p.writeInt32 (utoken);
   p.writeInt32 (request);
   /*warren add for t800 ril servie 2021/12/15 start*/
   p.writeInt32(slot);
   /*warren add for t800 ril servie 2021/12/15 end*/
   p.writeInt32 (error);
   return 0;
}
void LYNQ_RIL_urcClientInit()
{
    int len = 0;
    int on=1;
    int ret = 0;
    lynq_urc_socket_fd = socket(AF_INET,SOCK_DGRAM,0);
    if(lynq_urc_socket_fd < 0)
    {
        perror("creaet socket for udp fail");
        return;
    }
    /* 设置socket允许重复使用地址与端口，SO_REUSEADDR值为2 */
    //setsockopt(socket_fd,SOL_SOCKET,SO_REUSEADDR,&on,sizeof on);
    /* 使能广播功能，SO_BROADCAST值为6 */
    ret= setsockopt(lynq_urc_socket_fd,SOL_SOCKET,SO_BROADCAST,&on,sizeof(on));
    if(ret<0)
    {
        RLOGD("set broadcast fail!!!\n");
        exit(1);
    }

    struct sockaddr_in ril_lynq_urcCLient_socket;
    bzero(&ril_lynq_urcCLient_socket, sizeof(ril_lynq_urcCLient_socket));

    ril_lynq_urcCLient_socket.sin_family = AF_INET;
    ril_lynq_urcCLient_socket.sin_addr.s_addr = inet_addr(LYNQ_RIL_FWK_IP);
    ret = bind(lynq_urc_socket_fd, (struct sockaddr *)&ril_lynq_urcCLient_socket, sizeof(ril_lynq_urcCLient_socket));
    if (-1 == ret)
    {
        LYERRLOG("ril_lynq_urcCLient_socket bind fail,errno:%d",errno);
        exit(EXIT_FAILURE);
    }
    
    urc_broadcast_addr.sin_family = AF_INET;        //IPv4
    urc_broadcast_addr.sin_port = htons(LYNQ_BRODCAST_PORT);
    urc_broadcast_addr.sin_addr.s_addr = inet_addr(LYNQ_RIL_FWK_BROADCAST_IP);/*hong.liu change broadcast addr on 2024.2.18*/
    RLOGE("LYNQ_RIL_urcClientInit success!!!");
    return;
}

//add by hq for bug 760 2023/02/09
static int setnonblocking(int sockfd) {
    int flag = fcntl(sockfd, F_GETFL, 0);  //get current flag
    if (flag < 0) {
        RLOGE("fcntl F_GETFL fail");
        return -1;
    }
    if (fcntl(sockfd, F_SETFL, flag | O_NONBLOCK) < 0) {  //add O_NONBLOCK
        RLOGE("fcntl F_SETFL fail");
        return -1;
    }
    return 0;
}

void LYNQ_RIL_RecSocket()
{
    RLOGD("LYNQ_RIL_RecSocket start\n");
    char *argv[MAX_ARGS];
    int argc = 0;
    int ep_fd = 0;
    int en_fd = 0;
    struct epoll_event lynq_ev;
    struct epoll_event lynq_events[LYNQ_SOCKET_ENVNT_FD_MAX];
    //prctl(PR_SET_NAME,(unsigned long)"UDP_Thr");

    /*listen UPD SOCKET port */
    struct sockaddr_in server_addr;
    struct sockaddr_in lynqClient_addr;
    bzero(&server_addr, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);
    server_addr.sin_port = htons(LYNQ_SERVICE_PORT);
    /* create socket */
    //int server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if(server_socket_fd == -1)
    {
        RLOGE("Create Socket Failed:");
        exit(1);
    }

    /* bind socket port*/
    if(-1 == (bind(server_socket_fd,(struct sockaddr*)&server_addr,sizeof(server_addr))))
    {
         RLOGE("Server Bind Failed:");
         exit(1);
    }

    if(setnonblocking(server_socket_fd)!=0)
    {
        RLOGE("setnonblocking Failed");
        exit(1);
    }
    
    /* create epoll fd，add socket to epoll */
    ep_fd = epoll_create(LYNQ_SOCKET_ENVNT_FD_MAX);
    //int len = sizeof(struct sockaddr_in);
    lynq_ev.events = EPOLLIN | EPOLLET;
    lynq_ev.data.fd = server_socket_fd;
    if(epoll_ctl(ep_fd, EPOLL_CTL_ADD, server_socket_fd, &lynq_ev) < 0) 
    {
        fprintf(stderr, "epoll set insertion error: fd=%d\n", server_socket_fd);
        return;
    }
    else
    {
        printf("monitor socket add epoll success!!!\n");
    }
    char buffer[LYNQ_SOCKET_BUFFER];
    lynq_client_t *client_tmp = NULL;
    /* tranlate data */
    while(true)
    {
        if(!s_registerCalled)
        {
            sleep(1);
            continue;
        }
        en_fd = epoll_wait(ep_fd, lynq_events, 10000, -1);//###Check  valid
        if(en_fd <=0 )
        {
            continue;
        }
        for (int n = 0; n < en_fd; ++n)
        {
            if (lynq_events[n].data.fd == server_socket_fd)
            {
                /* define address to catch the client addreess*/
                //struct sockaddr_in client_addr;
                socklen_t client_addr_length = sizeof(lynqClient_addr);
                /* receive the data */
                bzero(buffer, LYNQ_SOCKET_BUFFER);
                while(recvfrom(server_socket_fd, buffer, LYNQ_SOCKET_BUFFER,0,(struct sockaddr*)&lynqClient_addr, &client_addr_length) != -1)//add while by hq for bug 760 2023/02/09
                {
                    client_tmp = (lynq_client_t*)buffer;
                    RLOGI("[LYNQ socketId] utoken=%d,request=%d,len=%d,param=%s",client_tmp->uToken,client_tmp->request,client_tmp->paramLen,client_tmp->param);
                    //char test[36] = {};
                    //sprintf(test,"test okay len = %d",client_tmp->paramLen);
                    //sendto(server_socket_fd,test,strlen(test),0,(struct sockaddr*)&client_addr,client_addr_length);
                    argv[0] = (char *)lynq_requset_to_string(client_tmp->request);
                    argc = 0;
                    if(client_tmp->paramLen > 0)
                    {
                        /*transfer struct*/
                        argc = parse_param(client_tmp->param, argv+1, MAX_ARGS);
                        if(argc < 1)
                        {
                            RLOGE("%s: error input.", buffer);
                            continue;
                        }
                    }
                    argc = argc+1;
                    for(int t = 0;t<argc;t++)
                    {
                        RLOGI("warren test argv[%d]=%s\n",t,argv[t]);
                    }
                    COMMAND *command = find_command(argv[0]);
                    if(!command)
                    {
                        RLOGE("%s: No such command for DemoApp", argv[0]);
                        continue;
                    }
                    int32_t request;
                    request = command->request;
                    RIL_SOCKET_ID id = RIL_SOCKET_1;
                    if(utils::is_support_dsds()) {
                        id = (RIL_SOCKET_ID)get_default_sim_all_except_data();
                    } else if(utils::is_suppport_dsss()) {
                        id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
                    }
                    if(request == -1)
                    {
                        (*(command->func)) (argc, argv, id, NULL);
                        continue;
                    }
                    if (request < 1 || (request >= (int32_t)NUM_ELEMS(s_commands) && request < RIL_REQUEST_VENDOR_BASE)) {
                        RLOGW("unsupported request code %d token %d", request);
                        // FIXME this should perhaps return a response
                        continue;
                    }
                    /*jb.qi add for two sim suspend 2022/9/19 start  lei modify for factory test of sleep*/
                    if(request == LYNQ_REQUEST_CHANGE_SCREEN_STATE || request == LYNQ_REQUEST_CHANGE_RADIO)
                    {
                        int i;
                        RLOGD("lynq_request_change_screen_state");
                        if(request == LYNQ_REQUEST_CHANGE_SCREEN_STATE)
                        {
                            for(i=0;i<2;i++) //suspend sim0 and sim1
                            {
                                lynq_sendRequestToMd(RIL_REQUEST_SCREEN_STATE, i, argv, lynqClient_addr, client_tmp->uToken);
                            }
                        }
                        /*lei modify for factory test of sleep*/
                        if(request == LYNQ_REQUEST_CHANGE_RADIO)
                        {
                            for(i=0;i<2;i++) //both radio on/off
                            {
                                lynq_sendRequestToMd(RIL_REQUEST_RADIO_POWER, i, argv, lynqClient_addr, client_tmp->uToken);
                            }
                        }
                        continue;
                    }
                    /*jb.qi add for two sim suspend 2022/9/19 end*/
                    RLOGD("REQUEST: %s ParamterNum:%d", requestToString(request), argc);
                    RequestInfo *pRI  = creatRILInfoAndInit(request, UDP, (RIL_SOCKET_ID)(id));
                    pRI->uToken = client_tmp->uToken;
                    pRI->lynqEvent = 2;
                    pRI->uClient_addr.sin_family = lynqClient_addr.sin_family;
                    pRI->uClient_addr.sin_addr.s_addr = lynqClient_addr.sin_addr.s_addr;
                    pRI->uClient_addr.sin_port = lynqClient_addr.sin_port;
                    //sendto(server_socket_fd,test,strlen(test),0,(struct sockaddr*)&pRI->uClient_addr,client_addr_length);
                    //pRI->uClient_addr.sa_family = (struct sockaddr)client_addr.sa_family;
                    //memcpy(pRI->uClient_addr.sa_data,&client_addr
                    //Radio on/off only allow one thread operate.
                    if(request == RIL_REQUEST_RADIO_POWER)
                    {
                        speciaRequest_wait();
                    }
    #ifdef ECALL_SUPPORT
                    else if(request == RIL_REQUEST_ECALL_FAST_MAKE_ECALL)
                    {
                        init_redial_flag();
                    }
    #endif
                    memset(Time_buf,0,sizeof(Time_buf));
                    GetTimeString(Time_buf);
                    //FUNCTION_CALLED(Time_buf,requestToString(request));
                    int waittoken = pRI->token;
                    (*(command->func)) (argc, argv, pRI->socket_id, pRI);
                    FUNCTION_CALLED(Time_buf,requestToString(request));
                    waitResponse(waittoken);
                    memset(Time_buf,0,sizeof(Time_buf));
                    GetTimeString(Time_buf);
                    FUNCTION_RETURN(Time_buf,requestToString(request));
                    bzero(buffer, LYNQ_SOCKET_BUFFER);

                }
                RLOGE("process Receive Data end");
             //   continue;                
            }
        }
     }
     RLOGD("close socket fd");
     close(server_socket_fd);
#ifdef LED_SUPPORT
     mbtk_netled_deinit();
#endif
     return ;
}
int LYNQ_RIL_respSocket(Parcel &p,RIL_Token t)
{
    ssize_t sent = 0;
    RequestInfo *pRI = (RequestInfo *)t;
    RLOGI("LYNQ_RIL_respSocket token [%x] event %d app_token %d",pRI->token,pRI->lynqEvent,pRI->uToken);
    if(pRI->lynqEvent!=2)
    {
        return -1;
    }
    int dataSize = p.dataSize();
    const uint8_t* data = p.data();  
    sent = sendto(server_socket_fd, data, dataSize, 0, (struct sockaddr *)&pRI->uClient_addr, sizeof(pRI->uClient_addr));
    if( sent < 0 )
    {
        RLOGE("lynqSocketSend send datalen fail (sent=%d, sendFD=%d, dataSize=%d)",
                sent,server_socket_fd, dataSize);
        return -1;
    }
    return 0;
}
int LYNQ_RIL_respSocket_sp(Parcel &p,RequestInfo *pRI)
{
    ssize_t sent = 0;   
    RLOGI("LYNQ_RIL_respSocket token [%x] event %d app_token %d",pRI->token,pRI->lynqEvent,pRI->uToken);    
    int dataSize = p.dataSize();
    const uint8_t* data = p.data();
    if(pRI->lynqEvent!=2)
    {
        return -1;
    }

    sent = sendto(server_socket_fd, data, dataSize, 0, (struct sockaddr *)&pRI->uClient_addr, sizeof(pRI->uClient_addr));
    if( sent < 0 )
    {
        RLOGE("lynqSocketSend send datalen fail (sent=%d, sendFD=%d, dataSize=%d)",
                sent,server_socket_fd, dataSize);
        return -1;
    }
    return 0;
}

bool is_need_use_shm(int dataSize, int urc_id)
{
    switch(urc_id)
    {
        /*network*/
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_SIGNAL_STRENGTH:
        /*sms*/
        case RIL_UNSOL_RESPONSE_NEW_SMS:
        /*sim*/
        //case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED:   Not supported at present
        /*call*/
        case RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED:
        case RIL_UNSOL_CALL_RING:
        case RIL_UNSOL_RINGBACK_TONE:
        case RIL_UNSOL_CALL_INFO_INDICATION:
#ifdef ECALL_SUPPORT
        case RIL_UNSOL_ECALL_INDICATIONS://9502        
#endif       
       /*Data*/
        case LYNQ_URC_DATA_CALL_STATUS_IND: 
        case LYNQ_URC_MODIFY_APNDB:
        case LYNQ_URC_RESET_APNDB:
            break;
        default:
            return false;
    }
    if(dataSize>urc_broadcase_shm_size_limit && dataSize <= get_max_shem_buffer_size())
    {
        return true;
    }
    return false;
}

int LYNQ_RIL_urcBroadcast(Parcel &p, int urc_id)
{
    printResponse;
    RLOGD("LYNQ_RIL_urcBroadcast send start");
    int ret =0;   
    ssize_t sent = 0;   
    p.setDataPosition(0);    
    int dataSize = p.dataSize();
    const uint8_t* data = p.data();
    RLOGD("LYNQ_RIL_urcBroadcast urc_id is %d, dataSize=%d, msg is %s", urc_id, dataSize, requestToString(urc_id));
    if(is_need_use_shm(dataSize,urc_id))
    {
        int index,level;
        if(get_cur_shem_buffer_index(dataSize,&level,&index))
        {
            char* p_shm_buffer=get_shem_buffer(level,index);
            memcpy(p_shm_buffer,data,dataSize);
            uint32_t* pFirstInt = (uint32_t*) const_cast<uint8_t*> (data);
               *pFirstInt=*pFirstInt+((index+1)<<SHM_BUFFER_INDEX_OFFSET)+((dataSize)<<SHM_BUFFER_SIZE_OFFSET);          
            dataSize=sizeof(int32_t)*2;
            RLOGD("LYNQ_RIL_urcBroadcast use share mem level is %d, index is %d,pointer is %p",level,index,p_shm_buffer);
        }        
    }
    sent = sendto(lynq_urc_socket_fd, data, dataSize, 0, (struct sockaddr *)&urc_broadcast_addr, sizeof(urc_broadcast_addr));
    if( sent < 0 )
    {
        RLOGE("LYNQ_RIL_urcBroadcast send datalen fail (sent=%d, sendFD=%d, dataSize=%d)",
                sent,lynq_urc_socket_fd, dataSize);
        return -1;
    }
    
    return 0;
}
/*Warren add for t800 RIL Service 2021/12/10 end*/

void
RIL_StartRevSocket()
{
    RLOGD("RIL_StartRevSocket start\n");
    char *argv[MAX_ARGS] = {0};
    int  argc = 0;

    prctl(PR_SET_NAME,(unsigned long)"UDP_Thr");

    /*listen UPD SOCKET port */
    struct sockaddr_in server_addr;
    bzero(&server_addr, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr(LYNQ_RIL_FWK_IP);
    server_addr.sin_port = htons(SERVER_PORT);
    /* create socket */
    //int server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    server_socket_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if(server_socket_fd == -1)
    {
     RLOGE("Create Socket Failed:");
     exit(1);
    }

    /* bind socket port*/
    if(-1 == (bind(server_socket_fd,(struct sockaddr*)&server_addr,sizeof(server_addr))))
    {
     RLOGE("Server Bind Failed:");
     exit(1);
    }

    /* tranlate data */
    while(true)
    {
        if(!s_registerCalled)
        {
            sleep(1);
            continue;
        }
         /* define address to catch the client addreess*/
        //struct sockaddr_in client_addr;
        socklen_t client_addr_length = sizeof(client_addr);

        /* receive the data */
        char buffer[BUFFER_SIZE];
        bzero(buffer, BUFFER_SIZE);
        if(recvfrom(server_socket_fd, buffer, BUFFER_SIZE,0,(struct sockaddr*)&client_addr, &client_addr_length) == -1)
        {
            RLOGE("Receive Data Failed:");
            continue;
        }
        RLOGD("DemoAPP:%s, receve: %s", inet_ntoa(client_addr.sin_addr), buffer);
        if(mtkItTest(buffer)) {
            RLOGD("mtkItTest() handle.");
            continue;
        }
        int argc = parse_param(buffer, argv, MAX_ARGS);
        if(argc < 1)
        {
            RLOGE("%s: error input.", buffer);
            continue;
        }
        COMMAND *command = find_command(argv[0]);
        if(!command)
        {
            RLOGE("%s: No such command for DemoApp", argv[0]);
            continue;
        }

        int32_t request;

        request = command->request;

        RIL_SOCKET_ID id = RIL_SOCKET_1;
        if(utils::is_support_dsds()) {
            id = (RIL_SOCKET_ID)get_default_sim_all_except_data();
        } else if(utils::is_suppport_dsss()) {
            id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
        }
        if(request == -1)
        {
            (*(command->func)) (argc, argv, id, NULL);
            continue;
        }

        if (request < 1 || (request >= (int32_t)NUM_ELEMS(s_commands) && request < RIL_REQUEST_VENDOR_BASE)) {
            RLOGW("unsupported request code %d token %d", request);
            // FIXME this should perhaps return a response
            continue;
        }

        RLOGD("REQUEST: %s ParamterNum:%d", requestToString(request), argc);


        RequestInfo *pRI  = creatRILInfoAndInit(request, UDP, (RIL_SOCKET_ID)(id));
        //Radio on/off only allow one thread operate.
        if(request == RIL_REQUEST_RADIO_POWER)
        {
            speciaRequest_wait();
        }
        memset(Time_buf,0,sizeof(Time_buf));
        GetTimeString(Time_buf);
        //FUNCTION_CALLED(Time_buf,requestToString(request));
        int waittoken = pRI->token;
        (*(command->func)) (argc, argv, pRI->socket_id, pRI);
        FUNCTION_CALLED(Time_buf,requestToString(request));
        waitResponse(waittoken);
        memset(Time_buf,0,sizeof(Time_buf));
        GetTimeString(Time_buf);
        FUNCTION_RETURN(Time_buf,requestToString(request));
     }

     RLOGD("close socket fd");
     close(server_socket_fd);
     return ;
}

const int waitResponse(int token)
{
    int waitToken = token;
    struct timeval now;
    struct timespec timeout;
    if((token&BLOCK_MARK) != BLOCK_MARK){
        RLOGD("No need wait!,token is %x!",token);
        return 0;
    }

    gettimeofday(&now,NULL);
    timeout.tv_sec = now.tv_sec+60; //timeout is 1min
    timeout.tv_nsec = now.tv_usec*1000;

    RLOGD("Block Request, wait token is %x,",waitToken);
    BLOCK_LOCK();
    if(waitToken == wakeup_token)
        RLOGD("response early than return, wait token is %x, wakeup token is %x",waitToken, wakeup_token);
    while(!(waitToken == wakeup_token)) {
        RLOGD("Wait Response, wait token is %x, wakeup token is %x",waitToken, wakeup_token);
        int ret = BLOCK_WAIT(&timeout);
        if(ret == ETIMEDOUT){
            RLOGD("Wait Response timeout, wait token is %x, wakeup token is %x",waitToken, wakeup_token);
            goto out;
        }
    }
    RLOGD("Response wakeup,token is %x!",wakeup_token);
    wakeup_token = -1;
out:
    BLOCK_UNLOCK();
    return 0;
}

/**
 * @brief check at input in at_buffer
 * @param buf type:in at port input
 * @return int 
 */
static int lynq_inside_at_buffer(char *buf)
{
    for(int i = 0; i < MAX_AT_CMD; i++)
    {
        if(at_buf_ext[i] == NULL)
        {
            break;
        }
        else
        {
            if(strstr(buf, at_buf_ext[i]))
            {
                return 1;
            }
        }
    }
    return 0;
}

/**
 * @brief send input to client
 * @param buffer type:in buffer from at port
 * @param len_buf type:in strlen(buffer)
 * @param client type:in sockaddr client
 * @return int 
 */
static int lynq_send_info(char *buffer, int len_buf, struct sockaddr* client)
{
    socklen_t len = sizeof(*client);
    int sent = sendto(sockfd,buffer,len_buf,0,client,len);
    if( sent < 0 )
    {
        RLOGE("lynq_send_info send fail (sent=%d, sendFD=%d, dataSize=%d)",
                sent,sockfd, len);
        return sent;
    }
    return 0;
}

/**
 * @brief Fetch data from a one-dimensional array into a two-dimensional array
 * 
 * @param cmd type:in buffer from client
 * @param argv type:in two-dimensional array
 * @param cnt type:in Two dimensional array subscript
 * @return int 
 */
static int lynq_parse_at_cmd(char *cmd, char *argv[], int cnt)
{
    if(NULL == cmd || NULL == argv)
    {
        return -1;
    }
    if(cnt > MAX_AT_CMD)
    {
        return -1;
    }
    const char s[2] = ";";
    char *token;
    int argc = cnt;
    token = strtok(cmd, s);
    while( token != NULL ) {
        argv[argc++] = token;
        token = strtok(NULL, s);
    }
    return 0;
}

/**
 * @brief count at cmd amount
 * 
 * @param type:in buffer 
 * @return int 
 */
static int lynq_count_at(char *buffer)
{
    char *p = buffer;
    int count = 0;
    while(*p != '\0')
    {
        if(*p == ';')
        {
            count++;
        }
        *p++;
    }
    return count+1;
}

/**
 * @brief receive registion and display on at port
 * @param parm type:in
 * @return void* 
 */
void *receive_at(void *parm)
{
    RLOGE("receive_at thread start\n");
    struct sockaddr* cli = (struct sockaddr*)parm;
    socklen_t len;
    int recv = 0;
    char display[1024] = {0};
    /*For at extension to receive at buffer*/
    bool flag = false;
    int count_at_cmd = 0;
    len = sizeof(*cli);
    while(1)
    {
        if(!flag)
        {
            RLOGE("receive third at cmd\n");
            recv = recvfrom(sockfd, buffer_at, LYNQ_AT_SOCKET_BUFFER, 0, cli, &len);
            if(recv < 0)
            {
                RLOGE("recv fail\n");
                continue;
            }
            RLOGE("recvfrom from client\n");
            /*parse buffer for at command*/
            count_at_cmd = lynq_count_at(buffer_at);
            if(count_at_cmd > MAX_AT_CMD)
            {
                RLOGE("too many at cmd\n");
                continue;;
            }
            lynq_parse_at_cmd(buffer_at, at_buf_ext, 0);
            flag = true;
        }
        else
        {
            RLOGE("display output on at port\n");
            bzero(display, 1024);
            recv = recvfrom(sockfd, display, LYNQ_AT_SOCKET_BUFFER, 0, cli, &len);
            if(recv < 0)
            {
                RLOGE("recv fail\n");
                continue;
            }
            /*display on at port*/
            else
            {
                strcat(display, "\n");
                int n = write(ttyGS3_fd,display,strlen(display));
                if(n<0)
                {
                    RLOGE("lynq resp write error");
                }
            }
        }
    }
    return NULL;
}

static void wait_reset_mipc_response(void)
{
    int outfd = open("/data/tp",O_RDONLY);
    if(outfd == -1){
        RLOGD("open error");
        return;
    }
    char rst[1024];
    char response[2048];
    int s;
    s = read(outfd,rst,sizeof(rst));
    if (s>0)
    {
        RLOGD("lei buf: %s \n", rst);
        /*respone ok or error*/
        if(rst[0] = '0')
        {
            sprintf(response,"%s%s","+LRSTMD:",rst);
            /*check fd can or can't write*/
            write(ttyGS3_fd,response,strlen(response));
            write(ttyGS3_fd,"\nOK\n",4);
        }
        else
        {
            sprintf(response,"%s%s","+CME ERROR:",rst);
            /*check fd can or can't write*/
            write(ttyGS3_fd,response,strlen(response));
        }
    }
    else
    {
        RLOGD("wait_reset_mipc_response unknow error\n");
    }
    usleep(1);
    close(outfd);
    return;
}

void startUsbLoop(void)
{
    /*lei add*/
    //Create a network communication object
    struct sockaddr_in addr_serv;
    struct sockaddr_in addr_clie;
    //Creating a Socket object
    sockfd=socket(AF_INET,SOCK_DGRAM,0);
    memset(&addr_serv, 0, sizeof(addr_serv));
    addr_serv.sin_family =AF_INET;
    addr_serv.sin_port =htons(LYNQ_AT_SERVICE_PORT);
    addr_serv.sin_addr.s_addr=htonl(INADDR_ANY);
    bind(sockfd,(struct sockaddr*)&addr_serv,sizeof(addr_serv));
    //receive registion and display on at port
    pthread_t thid;
    if(pthread_create(&thid, NULL, receive_at, (struct sockaddr*)&addr_clie) != 0) {
        RLOGE("thread creation failed\n");
        exit(1);
    }
    RLOGE("thread creation\n");
    /*lei add*/
    int nread=-1;
    int n = -1;
    int routeId = -1;
    char buffer[1024]={};
    char tempbuf[1024]={};
    char buf_parser[64] = {};
    int argc = 0;
    char *argv[MAX_ARGS];//argv[0]:at name,argv[1]:raw data,argv[2]:at type,argv[3]:paramter1,argv[4]:paramter2 ....
    char eBuf[1024];
    if(ttyGS3_fd > 0)
    {
        close(ttyGS3_fd);
        RLOGE("reopen need close");
    }
    ttyGS3_fd = open("/dev/ttyGS3",O_RDWR);
    if(ttyGS3_fd==-1)
    {
        RLOGE("open ttyGS3 failure!!!");
        printf("open ttyGS3 failure!!!\n");
        //printf("%s\n",strerr(errno));
        perror("--test--");
        //kill(0, SIGKILL);
    }
    RLOGD("[%s]open %s successfully ttyGS3_d %d!!!\n",__FUNCTION__,ttyname(ttyGS3_fd), ttyGS3_fd);
    while(1)
    {
        bzero(buffer, 1024);
        bzero(tempbuf, 1024);
        bzero(buf_parser, 64);
        if((nread=read(ttyGS3_fd,buffer,1024))>0)
        {
            if(nread<2)
            {
                //RLOGD("input is space!!!");
                continue;
            }
            buffer[nread-1] = '\0';
            //printf("buffer is %s\n",buffer);
            for(int i = 0 ; i < nread ; i++)
            {
                if(buffer[i]=='=')
                {
                    break;
                }
                if(buffer[i]>='a'&&buffer[i]<='z')
                {
                    buffer[i] = buffer[i]-32;
                }
            }
            RLOGD("buffer is %s\n",buffer);
            /*lei add*/
            /*check third cmd in buffer*/
            if(lynq_inside_at_buffer(buffer))
            {
                lynq_send_info(buffer, nread, (struct sockaddr*)&addr_clie);
            }
            /*lei add*/
            else
            {
                argc = lynqParseUsbCommand(buffer,argv,tempbuf,buf_parser,MAX_ARGS);
                if(argc<0)
                {  
                bzero(eBuf, 1024);
                sprintf(eBuf,"LYNQ:%s not support!!!\n",buffer);
                int n = write(ttyGS3_fd,eBuf,strlen(eBuf));
                if(n<0)
                {
                    perror("lynq resp write:");
                }
                RLOGD("n = %d\n",n);
                continue;
                }
                usb_at_transfer_t *atCmd = lynqFindId(argv[0]);
                if(atCmd==NULL)
                {
                    RLOGD("LYNQ send ATCMD:%s!!!",argv[1]);
                    lynqSendAt(argc,argv,1010);
                    usleep(50*1000);
                    if(!strcmp(buffer, "AT+LRSTMD"))
                    {
                        wait_reset_mipc_response();
                    }
                    continue;
                }
                if(!((1<<atoi(argv[2])) & (atCmd->support)))
                {
                    RLOGD("LYNQ %s not support!!!",atCmd->cmdName);
                    int n = write(ttyGS3_fd,"\n+CME ERROR: 100\n",strlen("\n+CME ERROR: 100\n"));
                    if(n<0)
                    {
                        perror("lynq resp write:");
                    }
                    continue;
                }
                routeId = routeCmd(atCmd->cmdId);
                //routeId = routeCmd(atcmd->cmdId);
                //routeId = LYNQ_GOTO_AT;
                switch(routeId)
                {
                    case LYNQ_GOTO_AT:
                    {
                        lynqSendAt(argc,argv,1010);
                        break;
                    }
                    case LYNQ_GOTO_TELE_REQ:
                    {
                        usb_cmd_t *atCmdEvn = lynqFindUsbEvent(argv[0]);
                        if(!atCmdEvn)
                        {
                            RLOGD("can not find at cmd event!!!");
                            continue;
                        }
                        atCmdEvn->fun(argc,argv,atCmdEvn->rilRequest,1011);
                        break;
                    }
                    case LYNQ_GOTO_USER_REQ:
                    {
                        usb_cmd_t *atCmdEvn = lynqFindUsbEvent(argv[0]);
                        if(!atCmdEvn)
                        {
                            RLOGD("can not find at cmd event!!!");
                            continue;
                        }
                        atCmdEvn->ufun(argc,argv,1012);
                        break;
                    }
                    case LYNQ_GOTO_LINFO_REQ:
                    {
                        lynqInfo(argv);
                        break;
                    }
                    // case LYNQ_GOTO_PLAT_REQ:
                    // {
                    //     lynq_deal_with_log_at(&argv[3]);
                    //     break;
                    // }
                    case LYNQ_GOTO_RNDIS_REQ:
                    {
                        lynq_get_rndis_data(buffer);
                        break;
                    }
                    case LYNQ_GOTO_FACTORY:
                    {
                        lynq_get_factory_data(argc,argv);
                        break;
                    }
                    /*rita add start*/
                    case LYNQ_GOTO_TEMP:
                    {
                        //write(ttyGS3_fd,"\n+CME ERROR: 1\n",strlen("\n+CME ERROR: 1\n"));
                        lynq_at_get_temp(argc, argv);
                        break;
                     }                    
                    default:
                        break;
                }
            }
            
        }
    }
    close(ttyGS3_fd);
    return;
}

void *
eventLoop(void *param) {
    pthread_mutex_lock(&s_startupMutex);
    s_started = 1;
    pthread_cond_broadcast(&s_startupCond);
    pthread_mutex_unlock(&s_startupMutex);
    #ifdef ECALL_SUPPORT
    init_ecall_timer_all();
    #endif /**/ECALL_SUPPORT
    /*warren add for t800 ril service 2021/12/13 start*/
    //RIL_StartRevSocket();
    LYNQ_RIL_urcClientInit();
    LYNQ_RIL_RecSocket();
    /*warren add for t800 ril service 2021/12/13 end*/
    RLOGD("error in event_loop_base errno:%d", errno);
    // kill self to restart on error
    kill(0, SIGKILL);

    return NULL;
}


void *
eventLoop_at(void *param) {
    pthread_mutex_lock(&s_startupMutex);
    s_started = 1;
    pthread_cond_broadcast(&s_startupCond);
    pthread_mutex_unlock(&s_startupMutex);
    //RIL_StartRevSocket();
    startUsbLoop();
    //startUsbLoop_test();
    RLOGD("error in event_loop_base errno:%d", errno);
    // kill self to restart on error
    kill(0, SIGKILL);

    return NULL;
}



const int RspDispFunction(int request,char* arg, RIL_SOCKET_ID socket_id)
{
    int waittoken;
    RequestInfo *pRI = creatRILInfoAndInit(request, RSPD, socket_id);
    if(pRI == NULL)
        return 0;
    waittoken = pRI->token;
    switch (request) {
    case RIL_REQUEST_GET_CURRENT_CALLS:
    {
        RLOGD("request Current list start!");
        Parcel p;
        pRI->pCI->dispatchFunction(p, pRI);
        waitResponse(waittoken);
        RLOGD("request Current list end!");
    }
        break;

    case RIL_REQUEST_ANSWER:
    {
        RLOGD("request Answer a MT call start!");
        Parcel p;
        pRI->pCI->dispatchFunction(p, pRI);
        waitResponse(waittoken);
        RLOGD("request Answer a MT call end!");
    }
        break;

    case RIL_REQUEST_GET_SIM_STATUS:
    {
        int ret=getIccCardStatus(1, NULL, socket_id, pRI);
        if(ret == 0)
            waitResponse(waittoken);
    }
        break;

    case RIL_REQUEST_DATA_REGISTRATION_STATE:
    {
        int ret=getDataRegistrationState(1, NULL, socket_id,pRI);
        if(ret == 0)
            waitResponse(waittoken);
    }
        break;

    case RIL_REQUEST_VOICE_REGISTRATION_STATE:
    {
        int ret=getVoiceRegistrationState(1, NULL, socket_id,pRI);
        if(ret == 0)
            waitResponse(waittoken);
    }
        break;
    case RIL_REQUEST_SMS_ACKNOWLEDGE:
    {
        char* tmp[3] = {"RIL_REQUEST_SMS_ACKNOWLEDGE", "1", "0"};
        acknowledgeIncomingGsmSmsWithPdu(3,tmp,socket_id,pRI);
        waitResponse(waittoken);
        RLOGD("acknowledge last Incoming Gsm Sms : RIL_REQUEST_SMS_ACKNOWLEDGE end!");
    }
        break;
    case RIL_REQUEST_OEM_HOOK_RAW:
    {
        if(arg != NULL)
        {
            RLOGD("request OEM HOOK RAW start!");
            pRI->token = pRI->token|BLOCK_MARK;
            int waittokenOEM = pRI->token;
            Parcel p;

            size_t pos = p.dataPosition();
            int len = strlen(arg);
            p.writeInt32(len);
            p.write((const void*)arg,len);

            p.setDataPosition(pos);
            RLOGD("emSendATCommand: %s %d\n",arg,strlen(arg));
            pRI->pCI->dispatchFunction(p, pRI);
            waitResponse(waittokenOEM);
        } else {
            if(pRI){
                free(pRI);
            }
            RLOGE("at command shouldn't null");
        }
    break;
    }
    case RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM:
    {
          char* tmp[2] = {"RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM", "no"};
          handleCallSetupRequestFromSim(2, tmp, socket_id,pRI);
          waitResponse(waittoken);
          RLOGD("timeout 1 minutes, response no by RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM");
          break;
    }
    case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE:
    {
        char* tmp[2] ={"RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE", arg};
        RLOGD("tmp[0]=%s, tmp[1]=%s, arg=%s", tmp[0], tmp[1], arg);
        sendTerminalResponse(2, tmp, socket_id, pRI);
        waitResponse(waittoken);
        break;
    }
    case RIL_REQUEST_CDMA_SMS_ACKNOWLEDGE:
    {
      acknowledgeLastIncomingCdmaSms(1, NULL,socket_id,pRI);
      waitResponse(waittoken);
      break;
    }
    case RIL_REQUEST_RADIO_POWER:
    {
        RLOGD("response loop, RIL_REQUEST_RADIO_POWER: %s", (arg == NULL ? "nul": arg));
        if(arg != NULL) {
            char* tmp[2] = {"RIL_REQUEST_RADIO_POWER", arg};
            setRadioPower(2,tmp,socket_id,pRI);
            waitResponse(waittoken);
        } else {
            if(pRI){
                free(pRI);
            }
            RLOGE("response loop, RIL_REQUEST_RADIO_POWER fail");
        }
        break;
    }
    case RIL_REQUEST_ALLOW_DATA:
    {
        int default_id = get_default_sim_data();
        RLOGD("RspDispFunction: socket_id=%d switch_id=%d", socket_id, default_id);
        char* argv[2] = {"RIL_REQUEST_ALLOW_DATA","0"};
        if(socket_id == default_id) {
            utils::mtk_property_set(PROP_DEFAULT_DATA_SIM, std::to_string(socket_id + 1).c_str());
            argv[1] = "1";
        }
        while(!isRadioAvailable(socket_id)) {
            sleep(1);
            RLOGD("[SIM%d]RspDispFunction(RIL_REQUEST_ALLOW_DATA): wait radio available", socket_id);
        }
        setDataAllowed(2, argv, socket_id, pRI);
        waitResponse(waittoken);
        break;
    }
    case RIL_REQUEST_CDMA_FLASH:
    {
        sendCDMAFeatureCode(1, NULL, socket_id, pRI);
        waitResponse(waittoken);
        break;
    }
    default:
        if(pRI) {
            free(pRI);
            pRI = NULL;
        }
        break;
    }
    return 0;
}

void * responseLoop(void *param) {
    pthread_mutex_lock(&s_startupMutex);
    s_responseDispatch= 1;
    pthread_cond_broadcast(&s_startupCond);
    pthread_mutex_unlock(&s_startupMutex);
    responseDispatch();
    RLOGD("error in response_loop_base errno:%d", errno);
    // kill self to restart on error
    kill(0, SIGKILL);

    return NULL;
}

void ATCIRequest(int request,char* reqString, void* t,int argc,char**argv)
{
    if(t == NULL) {
        RLOGE("ATCIRequest t is null");
        return;
    }
    RequestInfo *pRI = (RequestInfo *)t;
    int waittoken;
    if (request < RIL_REQUEST_VENDOR_BASE) {
        pRI->pCI = &(s_commands[request]);
    } else {
        pRI->pCI = find_mtk_command(request);
    }
    /*lei modify for Some requests that are not in the ril_commands.h and mtk_ril_commands.h but in commands.h*/
    COMMAND *command = find_command(reqString);
    if(pRI->pCI == NULL){
        if(command == NULL)
        {
            RLOGE("pCI command & command not found!");
            if(pRI) {
                free(pRI);
            }
            return;
        }
    }
    /*lei modify for Some requests that are not in the ril_commands.h and mtk_ril_commands.h but in commands.h*/

    if(utils::is_suppport_dsss()){
        pRI->socket_id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
    }

    if(utils::is_support_dsds() && (request != RIL_REQUEST_RADIO_POWER)){
        pRI->socket_id = (RIL_SOCKET_ID)get_atci_sim();
    }
    pRI->p_next = NULL;

    
    RLOGD("function %s line %d reqString %s", __FUNCTION__, __LINE__, reqString);
    if(command == NULL) {
        RLOGE("ATCI request command find error!");
        if(pRI) {
            free(pRI);
        }
        return;
    } else {
        RLOGE("ATCI request name is %s!",command->name);
    }

    pRI->token = GenerateToken(ATCI, request);
    waittoken = pRI->token;
    if(request == RIL_REQUEST_RADIO_POWER) {
        speciaRequest_wait();
    }
    (*(command->func)) (argc, argv, pRI->socket_id, pRI);
    //need wait Ril_onRequestComplete return.
     waitResponse(waittoken);
    return;
}

void startWakupLoop(void)
{
    pthread_t WakeupReasonThread;

    RLOGD("startWakupLoop()");
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&WakeupReasonThread, &attr, wakeup_reason_loop, NULL);
    if (result != 0) {
        RLOGW("Failed to create wakeup reason thread: %s", strerror(result));
        goto done;
    }

done:
    pthread_mutex_unlock(&s_startupMutex);
}
/*Warren add for  FAW 2021/09/23 start
** use ttyGS0 port
*/
int lynqSendToRil(int argc,char *argv[],int uToken)
{
    if(argc < 1)
    {
        RLOGE("lynqSendToRil error input.");
        return 1;
    }
    for(int i =0;i<argc;i++)
    {
        printf("argv[%d]=%s\n",i,argv[i]);
    }
    COMMAND *command = find_command(argv[0]);
    if(!command)
    {
        RLOGE("%s: No such command for DemoApp", argv[0]);
        return 1;
    }

    int32_t request;

    request = command->request;

    RIL_SOCKET_ID id = RIL_SOCKET_1;
    if(utils::is_support_dsds()) {
        id = (RIL_SOCKET_ID)get_default_sim_all_except_data();
    } else if(utils::is_suppport_dsss()) {
        id = (RIL_SOCKET_ID)Phone_utils::get_enable_sim_for_dsss();
    }

    if(request == -1)
    {
        (*(command->func)) (argc, argv, id, NULL);
        return 1;
    }

    if (request < 1 || (request >= (int32_t)NUM_ELEMS(s_commands) && request < RIL_REQUEST_VENDOR_BASE)) {
        RLOGW("unsupported request code %d token %d", request);
        // FIXME this should perhaps return a response
        return 1;
    }

    RLOGD("REQUEST: %s ParamterNum:%d", requestToString(request), argc);


    RequestInfo *pRI  = creatRILInfoAndInit(request, UDP, (RIL_SOCKET_ID)(id));
    pRI->lynqEvent = 1;
    //Radio on/off only allow one thread operate.
    if(request == RIL_REQUEST_RADIO_POWER)
    {
        speciaRequest_wait();
    }
    memset(Time_buf,0,sizeof(Time_buf));
    GetTimeString(Time_buf);
    //FUNCTION_CALLED(Time_buf,requestToString(request));
    int waittoken = pRI->token;
    (*(command->func)) (argc, argv, pRI->socket_id, pRI);
    FUNCTION_CALLED(Time_buf,requestToString(request));
    waitResponse(waittoken);
    memset(Time_buf,0,sizeof(Time_buf));
    GetTimeString(Time_buf);
    FUNCTION_RETURN(Time_buf,requestToString(request));
    return 0;
}

int sendRespToUsb(char *cmd)
{
    return 0;
}
int sendUrcToUsb(char *cmd)
{
    return 0;
}
/*Warren add for  FAW 2021/09/23 end*/

void startPMLoop(void)
{
    pthread_t atciSocketThread;

    RLOGD("startPMLoop()");
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&atciSocketThread, &attr, StartPMSocket, NULL);
    if (result != 0) {
        RLOGW("Failed to create PM thread: %s", strerror(result));
        goto done;
    }

done:
    pthread_mutex_unlock(&s_startupMutex);
}

void startGdbusLoop(void)
{
    pthread_t atciSocketThread;

    RLOGD("startGdbusLoop()");
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&atciSocketThread, &attr, init_data_gdbus_cb, NULL);
    if (result != 0) {
        RLOGW("Failed to create gdbus thread: %s", strerror(result));
        goto done;
    }

done:
    pthread_mutex_unlock(&s_startupMutex);
}

void startATCILoop(void)
{
    pthread_t atciSocketThread;

    RLOGD("startATCILoop()");
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&atciSocketThread, &attr, StartATCISocket, NULL);
    if (result != 0) {
        RLOGW("Failed to create ATCI thread: %s", strerror(result));
        goto done;
    }

done:
    pthread_mutex_unlock(&s_startupMutex);
}

void RIL_startEventLoop(void)
{
    RLOGD("RIL_startEventLoop()");
    lynq_init_sms_manager();
    /* spin up eventLoop thread and wait for it to get started */
    s_started = 0;
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&s_tid_dispatch, &attr, eventLoop, NULL);
    if (result != 0) {
        RLOGW("Failed to create dispatch thread: %s", strerror(result));
        goto done;
    }
   
    while (s_started == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
    //warren delete,beacuse of update at fwk.
    /*mobiletek add*
    s_started = 0;
    result = pthread_create(&s_tid_dispatch, &attr, eventLoop_at, NULL);
    if (result != 0) {
        RLOGW("Failed to create dispatch thread: %s", strerror(result));
        goto done;
    }

    while (s_started == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
    *mobiletek add*/ 
    result = pthread_create(&s_tid_dispatch, &attr, responseLoop, NULL);
    if (result != 0) {
        RLOGW("Failed to create response dispatch thread: %s", strerror(result));
        goto done;
    }

    while (s_responseDispatch == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
done:
    pthread_mutex_unlock(&s_startupMutex);
}

void printInputArgs(int argc, char** argv)
{
    int i=0;

    for(i=0; i<argc; i++)
    {
        RLOGD("%s", argv[i]);
    }
}

void initRequestInfo(RequestInfo *pRI, int  request, int mode, RIL_SOCKET_ID soc_id)
{
    pRI->token = GenerateToken(mode, request);
    if (request < RIL_REQUEST_VENDOR_BASE) {
        pRI->pCI = &(s_commands[request]);
    } else {
        pRI->pCI = find_mtk_command(request);
    }
    pRI->socket_id = soc_id;

    pRI->p_next = NULL;
}

void getVoiceAndDataRegistrationState(RIL_SOCKET_ID soc_id)
{
    ARspRequest(RIL_REQUEST_DATA_REGISTRATION_STATE,soc_id);
    ARspRequest(RIL_REQUEST_VOICE_REGISTRATION_STATE,soc_id);
}

void requestAnswer(RIL_SOCKET_ID soc_id)
{
    ARspRequest(RIL_REQUEST_ANSWER,soc_id);
    return;
}
void requestSMSACKNOWLEDGE(RIL_SOCKET_ID soc_id)
{
    ARspRequest(RIL_REQUEST_SMS_ACKNOWLEDGE,soc_id);
    return;
}

#if EM_MODE_SUPPORT
void registerForNetworkInfo(netwokInfoNotify cb)
{
    networkCb = cb;
    return ;
}
void unregisterNetwork()
{
    networkCb = NULL;
    //AT+EINFO= flag & 0xFFFFFFF7
}
void registerForATcmdResponse(atCmdResponse cb)
{
    atResponseCb = cb;
    return ;
}

void unregisterATcmd()
{
    atResponseCb = NULL;
}

#endif
int emResultNotify(const char *str)
{
    RLOGD("emResultNotify %s",str);
    int len_s = sendto(server_socket_fd,str,strlen(str),0,(struct sockaddr *)&client_addr,sizeof(client_addr));

    sendto(server_socket_fd,"stopemdone",strlen("stopemdone"),0,(struct sockaddr *)&client_addr,sizeof(client_addr));
    return len_s;
}

void processUnsolicited (Parcel &p, int type)
{
    int32_t response = -1;
    p.readInt32(&response);
    switch(response){
        case RIL_UNSOL_MAL_AT_INFO:
        {
#if EM_MODE_SUPPORT
            char *stringresponse = strdupReadString(p);
            if(strstr(stringresponse,"+ENWINFO") !=  NULL){
                RLOGD("processUnsolicited ENWINFO \n");
                char *start = strstr(stringresponse,":");
                char *end = strstr(stringresponse,",");
                if(start == NULL ||end == NULL ){
                    break;
                }
                if(networkCb){
                    //parse type & data, notify to registrants
                    char ctype[5] = {0};
                    int type = 0;
                    memcpy(ctype,start+1, end - start -1);
                     type = atoi(ctype);
                    char *data = end+1;
                    RLOGD("ctype %s type %d data %s\n",ctype,type,data);
                    //parse response
                    networkCb(type,data);
                }
            }
            if(stringresponse){
                free(stringresponse);
            }
#endif
            break;
        }
        default:
            break;
    }
}
void processSolicited(Parcel &p, int type) {
    int32_t serial, error;
    serial = 0;
    p.readInt32(&serial); //telematic it is the same as ril request num
    p.readInt32(&error);
    RLOGD("processSolicited serial %d\n", serial);
    switch (serial) {
    case RIL_REQUEST_OEM_HOOK_RAW: {
        if (error != RIL_E_SUCCESS) {
            RLOGW("RIL_E_fail");
            if (atResponseCb) {
               atResponseCb(NULL, 0);
            }
            if(m_RfDesense){
                m_RfDesense->handle_request("", 0, 0, (RIL_Errno)error);
            }
            return;
        }
        int len;
        status_t status = 0;
        status = p.readInt32(&len);
        if (status != 0) {
            RLOGW("read int32 fail");
            return;
        }
        char *stringresponse = (char*) calloc(len, sizeof(char));
        status = p.read((void*) stringresponse, len);
        if (status != 0) {
            if (stringresponse) {
                free(stringresponse);
            }
            RLOGW("read int32 fail");
            return;
        }
        parseAtCmd(stringresponse);
        RLOGD("processSolicited AT string %s %d\n", stringresponse, len);
#if EM_MODE_SUPPORT
        if (atResponseCb) {
            if (stringresponse) {

                atResponseCb(stringresponse, len);
            } else {
                atResponseCb(stringresponse, 0);
            }
        }
        if(m_RfDesense){
            if(stringresponse && (!isFinalResponseErrorEx(stringresponse))) {
                m_RfDesense->handle_request(stringresponse,len,0, (RIL_Errno)RIL_E_SUCCESS);
            } else {
                RLOGD("isFinalResponseErrorEx error or response is null");
                m_RfDesense->handle_request(stringresponse, 0, 0, (RIL_Errno)RIL_E_GENERIC_FAILURE);
            }
        }
#endif
        if (stringresponse) {
            free(stringresponse);
        }
        break;
    }
    case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE: {
#if EM_MODE_SUPPORT
        if (atResponseCb) {
            if (error != RIL_E_SUCCESS) {
                atResponseCb(NULL, 0);
            } else {
                atResponseCb("OK", 2);
            }
        }
#endif
        break;
    }
    case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE: {
#if EM_MODE_SUPPORT
        int nums = 0;
        int prefertype = 0;
        p.readInt32(&nums);
        if (nums != 1) {
            RLOGD("getpreferrednetworktype nums > 1");
        }
        p.readInt32(&prefertype);
        char prefertype_str[3] = { 0 };
        sprintf(prefertype_str, "%d", prefertype);
        if (atResponseCb) {
            if (error != RIL_E_SUCCESS) {
                atResponseCb(NULL, 0);
            } else {
                atResponseCb(prefertype_str, strlen(prefertype_str));
            }
        }
#endif
        break;
    }
    case RIL_REQUEST_GET_IMSI: {
        if (error != RIL_E_SUCCESS) {
            RLOGD("RIL_REQUEST_GET_IMSI error %d\n", error);
        }
        break;
    }
    }
}

#ifdef ECALL_SUPPORT
static int responseEcallStatus(Parcel &p, void *response, size_t responselen) {
  if (response == NULL || responselen != sizeof(RIL_Ecall_Unsol_Indications)) {
    if (response == NULL) {
      RLOGE("invalid response: NULL");
    }
    else {
      RLOGE("responseEcallStatus: invalid response length %d expecting len: %d",
            sizeof(RIL_Ecall_Unsol_Indications), responselen);
    }
    return RIL_ERRNO_INVALID_RESPONSE;
  }

  RIL_Ecall_Unsol_Indications *p_cur = (RIL_Ecall_Unsol_Indications *)response;
  p.writeInt32(p_cur->ind);
  p.writeInt32(p_cur->call_id);

  startResponse;
  appendPrintBuf("ECall Status: %d, call_id: %d",
                 p_cur->ind, p_cur->call_id);
  closeResponse;

  return 0;
}

/**
 * Callee expects const RIL_ECallReqMsg *
 * Payload is:
 *   RIL_ECall_Category ecall_cat
 *   RIL_ECall_Variant ecall_variant
 *   String address
 *   String msd_data
 */
static void dispatchFastEcall (Parcel &p, RequestInfo *pRI) {
    RIL_ECallReqMsg eCallReqMsg;

    int32_t t = -1;
    int size;
    status_t status;
    int digitCount;
    int digitLimit;
    uint8_t uct;

    memset(&eCallReqMsg, 0, sizeof(eCallReqMsg));

    status = p.readInt32(&t);
    eCallReqMsg.ecall_cat= (RIL_ECall_Category)t;

    status = p.readInt32(&t);
    eCallReqMsg.ecall_variant = (RIL_ECall_Variant)t;

    eCallReqMsg.address = strdupReadString(p);

    status = p.readInt32(&t);
    eCallReqMsg.length = (uint8_t) t;

    digitLimit= MIN((eCallReqMsg.length), MSD_MAX_LENGTH);
    eCallReqMsg.msd_data = (unsigned char *)alloca(digitLimit);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct, sizeof(uint8_t));
        eCallReqMsg.msd_data[digitCount] = (uint8_t) uct;
    }

    startRequest;
    appendPrintBuf("%secall_cat=%d,ecall_variant=%d, address=%s", printBuf,
        eCallReqMsg.ecall_cat, eCallReqMsg.ecall_variant, (char*)eCallReqMsg.address);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    size = sizeof(eCallReqMsg);
    CALL_ONREQUEST(pRI->pCI->requestNumber, &eCallReqMsg, size, pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString(eCallReqMsg.address);
    memset(eCallReqMsg.msd_data, 0, digitLimit);
#endif

    free(eCallReqMsg.address);

#ifdef MEMSET_FREED
    memset(&eCallReqMsg, 0, sizeof(eCallReqMsg));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_ECallSetMSD *
 * Payload is:
 *   int call_id
 *   String msd_data
 */
static void dispatchSetMsd (Parcel &p, RequestInfo *pRI) {
    RIL_ECallSetMSD eCallSetMsd;

    int32_t t = -1;
    int size;
    status_t status;
    int digitCount;
    int digitLimit;
    uint8_t uct;

    memset(&eCallSetMsd, 0, sizeof(eCallSetMsd));

    status = p.readInt32(&t);
    eCallSetMsd.call_id = (int)t;

    status = p.readInt32(&t);
    eCallSetMsd.length = (uint8_t) t;

    digitLimit= MIN((eCallSetMsd.length), MSD_MAX_LENGTH);
    eCallSetMsd.msd_data = (unsigned char *)alloca(digitLimit);

    for(digitCount = 0 ; digitCount < digitLimit; digitCount ++) {
        status = p.read(&uct, sizeof(uint8_t));
        eCallSetMsd.msd_data[digitCount] = (uint8_t) uct;
    }

    startRequest;
    appendPrintBuf("%scall_id=%d,msd_data=%s", printBuf, eCallSetMsd.call_id, (char*)eCallSetMsd.msd_data);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    if (status != NO_ERROR) {
        goto invalid;
    }

    size = sizeof(eCallSetMsd);
    CALL_ONREQUEST(pRI->pCI->requestNumber, &eCallSetMsd, size, pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memset(eCallSetMsd.msd_data, 0, eCallSetMsd.length);
#endif

#ifdef MEMSET_FREED
    memset(&eCallSetMsd, 0, sizeof(eCallSetMsd));
#endif

    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}

/**
 * Callee expects const RIL_ECallSetNum *
 * Payload is:
 *   int arg_num;
 *   int type
 *   char* address
 */
static void dispatchEcallRecord (Parcel &p, RequestInfo *pRI) {
    RIL_ECallSetNum args;
    int32_t t = -1;
    status_t status;

    RLOGD("dispatchSmsWrite");
    memset (&args, 0, sizeof(args));

    status = p.readInt32(&t);
    args.arg_num = (int)t;

    status = p.readInt32(&t);
    args.type = (int)t;

    args.address = strdupReadString(p);

    if (status != NO_ERROR || args.address == NULL) {
        goto invalid;
    }

    startRequest;
    appendPrintBuf("%s%d,%s,%d", printBuf, args.type, args.address,args.arg_num);
    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber, &args, sizeof(args), pRI, pRI->socket_id);

#ifdef MEMSET_FREED
    memsetString (args.address);
#endif

    free (args.address);
#ifdef MEMSET_FREED
    memset(&args, 0, sizeof(args));
#endif
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
}
#endif /*ECALL_SUPPORT*/

#ifdef KEEP_ALIVE
static void dispatchStartKeepalivePro(Parcel &p, RequestInfo *pRI){
#ifdef LYNQ_MAY_SUPPORT 
    RIL_RequestKeepalive_Pro kp;
    int32_t t = -1;
    status_t status;
    std::vector<uint8_t> sadr;
    std::vector<uint8_t> dadr;

    memset (&kp, 0, sizeof(RIL_RequestKeepalive_Pro));

    status = p.readInt32(&t);
    kp.type = (RIL_PacketType)t;
    if (status != NO_ERROR) {
        goto invalid;
    }


      status = p.readByteVector(&sadr);
    if (status != NO_ERROR) {
        goto invalid;
    } else {
        for(int i = 0; i < sadr.size(); i++) {
            kp.sourceAddress[i] = sadr[i];
        }
    }

    status = p.readInt32(&t);
    kp.sourcePort= (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readByteVector(&dadr);
    if (status != NO_ERROR) {
        goto invalid;
    } else {
        for(int i = 0; i < dadr.size(); i++) {
            kp.destinationAddress[i] = dadr[i];
        }
    }

    status = p.readInt32(&t);
    kp.destinationPort= (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    kp.netif_id = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    kp.keepIdleTime = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    kp.keepIntervalTime = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }

    status = p.readInt32(&t);
    kp.retryCount = (int)t;
    if (status != NO_ERROR) {
        goto invalid;
    }
    startRequest;
    appendPrintBuf("%s [type:%d, sourceAddress:",printBuf, kp.type);

    for(auto v: sadr) {
        appendPrintBuf("%s %d",printBuf,v);
    }
    appendPrintBuf("%s, sourcePort:%d, destinationAddress:",printBuf, kp.sourcePort);

    for(auto v: dadr) {
        appendPrintBuf("%s %d",printBuf,v);
    }
    appendPrintBuf("%s, destinationPort:%d, netif_id:%d, keepIdleTime:%d,, keepIntervalTime:%d, retryCount:%d",
            printBuf, kp.destinationPort, kp.netif_id, kp.keepIdleTime, kp.keepIntervalTime, kp.retryCount);

    closeRequest;
    printRequest(pRI->token, pRI->pCI->requestNumber);

    CALL_ONREQUEST(pRI->pCI->requestNumber,&kp,sizeof(RIL_RequestKeepalive_Pro),pRI, pRI->socket_id);
    return;
invalid:
    invalidCommandBlock(pRI);
    return;
#endif //LYNQ_MAY_SUPPORT
return;
}
#endif /* KEEP_ALIVE*/
} /* namespace android */

#if 0
void rilEventAddWakeup_helper(struct ril_event *ev) {
    android::rilEventAddWakeup(ev);
}

void listenCallback_helper(int fd, short flags, void *param) {
    android::listenCallback(fd, flags, param);
}

int blockingWrite_helper(int fd, void *buffer, size_t len) {
    return android::blockingWrite(fd, buffer, len);
}
#endif
