// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef MODEMCATEGORY_H_
#define MODEMCATEGORY_H_

#include <string>
#include <vector>
#include <sstream>
#include <cstring>

class utils {
public:
    utils();
    virtual ~utils();
    static bool is97Modem();
    static bool is93ModemAndAbove();
    static bool is93Modem();
    static bool is90Modem();
    static bool isC2KSupport();
    static bool isMt2635();
    static bool isMt2731();
    static bool isMt2735();
    static bool is_support_dsds();
    static bool is_suppport_dsss();
    static int find_index(std::vector<std::string> v, std::string& str);
    static std::string format(const std::string& format, ...);
    static void tokenize(std::string const &str, const char delim, std::vector<std::string> &out);
    static void tokenize(std::string const &str, const char* delim, std::vector<std::string> &out);
    static std::string addZeroForNum(std::string const &str, int strLength);
    static int mtk_property_set(const char *key, const char *value);
    static int mtk_property_get(const char *key, char *value, const char *default_value);
    static bool mtk_property_get_bool(const char *key, bool default_value);
    static int64_t mtk_property_get_int64(const char *key, int64_t default_value);
    static int32_t mtk_property_get_int32(const char *key, int32_t default_value);
    static void setMSimProperty(int phoneId, char *pPropertyName, char *pUpdateValue);
    static void getMSimProperty(int phoneId, char *pPropertyName,char *pPropertyValue);
    static bool is_number(const std::string& s);
public:
    static intmax_t property_get_imax(const char *key, intmax_t lower_bound, intmax_t upper_bound,
            intmax_t default_value);
    static constexpr int MODEM_UNKNOWN = 0;
    static constexpr int MODEM_GSM = 1;
    static constexpr int MODEM_TDSCDMA = 2;
    static constexpr int MODEM_WCDMA = 3;
    static constexpr int MODEM_LTE_TDD = 4;
    static constexpr int MODEM_LTE_FDD = 5;
    static constexpr int MODEM_CDMA_EVDO = 6;
    static constexpr int MODEM_CDMA_1X = 7;
};

#endif /* MODEMCATEGORY_H_ */
