#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <error.h>
#include <string.h>
#include <errno.h>
#include <liblog/lynq_deflog.h>
#include "include/liblynq-at-common.h"
#include <include/lynq-qser-autosuspend.h>
#include <libled/lynq_led.h>

DEFINE_LYNQ_LIB_LOG(LYNQ_AT_COMMON)

lynq_atsvc_outcb handle_output;
typedef struct
{
    char *cmd;
    void (*func)(char *input);
}Command;

enum
{
    Response = 0,
    Urc
};

void lynq_response_ok()
{
    char *str = "OK\r\n";
    handle_output(str, strlen(str), Response);
}

void lynq_response_error(int error_code)
{
    char str[32] = {0};
    sprintf(str, "+CME ERROR: %d\r\n", error_code);
    handle_output(str, strlen(str), Response);
}

void lynq_handle_version()
{
    char buf[64] = {0};
    sprintf(buf,"+CGIR:%s\r\n",LYNQ_SW_INSIDE_VERSION);
    handle_output(buf, strlen(buf), Response);
    lynq_response_ok();
    return;
}

void lynq_handle_autosuspend(char* input)
{
    int len;
    int ret;
    char buf[64] = {0};
    ALOGE("lynq_handle_autosuspend start\n");
    len = strlen(input);
    system("echo 0 >/sys/devices/platform/soc/1307000.gmac/gmac_power");
    ret = qser_autosuspend_enable(input[len-1]);
    if(ret != 0)
    {
        sprintf(buf,"+CME ERROR: 100\r\n");
        handle_output(buf, strlen(buf), Response);
    }
    else
    {
        lynq_response_ok();
    }

    return;
}

void lynq_handle_netled(char* input)
{
    int ret;
    char buf[64] = {0};
    int mode = input[strlen(input)-1]-'0';
    ALOGE("lynq_handle_netled start\n");

    ret = lynq_set_netled_on(mode);
    if(ret != 0)
    {
        sprintf(buf,"+CME ERROR: 100\r\n");
        handle_output(buf, strlen(buf), Response);
    }
    else
    {
        lynq_response_ok();
    }

    return;
}

void lynq_handle_statusled(char* input)
{
    int ret;
    char buf[64] = {0};
    int mode = input[strlen(input)-1]-'0';

    ALOGE("lynq_handle_statusled start\n");
    ret = lynq_set_statusled_on(mode);

    if(ret != 0)
    {
        sprintf(buf,"+CME ERROR: 100\r\n");
        handle_output(buf, strlen(buf), Response);
    }
    else
    {
        lynq_response_ok();
    }

    return;
}
#define mem_addr_lenth 10
void lynq_handle_ddr_identify()
{
    char buf[64] = {0};
    char *command = "devmem 0x0121b040";
    char result[64] = {0};
    FILE *fp;

    fp = popen(command, "r");
    if(fp == NULL)
    {
        lynq_response_error(100);
        return;
    }
    fgets(result, sizeof(result), fp);
    pclose(fp);
    
    if(strncmp(result,"0xF8631600",mem_addr_lenth) == 0 || strncmp(result,"0xF8631700",mem_addr_lenth) == 0)
    {
        sprintf(buf,"+DDRID:2Gb ddr\r\n");
        handle_output(buf, strlen(buf), Response);
    }
    else if(strncmp(result,"0xF8631300",mem_addr_lenth) == 0 || strncmp(result,"0xF8631500",mem_addr_lenth) == 0)
    {
        sprintf(buf,"+DDRID:4Gb ddr\r\n");
        handle_output(buf, strlen(buf), Response);
    }
    else
    {
        sprintf(buf,"+DDRID:no matching ddr\r\n");
        handle_output(buf, strlen(buf), Response);
        lynq_response_error(100);
        return;
    }
    lynq_response_ok();
    return;
}

void lynq_handle_halt_enable()
{
    int ret;
    ret = system("echo 0x7:0x0  >/sys/kernel/debug/pmu_zx29/regs");
    if(ret != 0)
    {
        lynq_response_error(100);
        return;
    }
    lynq_response_ok();
    return;
}

static Command commands[] =
{
    {"CGIR",lynq_handle_version},
    {"LEELSP",lynq_handle_autosuspend},
    {"NETLED",lynq_handle_netled},
    {"STATUSLED",lynq_handle_statusled},
    {"DDRID",lynq_handle_ddr_identify},
    {"HALTENABLE",lynq_handle_halt_enable},
    {NULL, NULL}
};

Command* find_command(char *input)
{
    ALOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
    int i;
    int ret = -1;
    for (i = 0; commands[i].cmd; i++)
    {
        ret = strncmp(input, commands[i].cmd, strlen(commands[i].cmd));
        if(ret == 0)
        {
            ALOGD("function %s line %d find input %s commands[i].cmd %s  strlen %d ret %d\n", __FUNCTION__, __LINE__, input, commands[i].cmd, strlen(commands[i].cmd), ret);
            return (&commands[i]);
        }
    }
    ALOGD("function %s line %d not find ret %d \n", __FUNCTION__, __LINE__, ret);
    return ((Command *)NULL);
}

void lynq_at_common_cb(char *input, int input_max_size)
{
    if(handle_output != NULL)
    {
        ALOGD("function %s line %d input %s\n", __FUNCTION__, __LINE__, input);
        if(input != NULL)
        {
            char *handle_string = input + strlen("AT+");
            ALOGE("HJAHS:%s\n",handle_string);
            if(!strlen(handle_string))
            {
                ALOGE("function %s line %d strlen %d\n", __FUNCTION__, __LINE__, strlen(handle_string));
                return;
            }
            ALOGD("function %s line %d  handle_string %s\n", __FUNCTION__, __LINE__, handle_string);
            Command *cmd = find_command(handle_string);
            if(cmd != NULL)
            {
                ALOGD("function %s line %d\n", __FUNCTION__, __LINE__);
                (*(cmd->func))(handle_string);
                return;
            }
        }
    }
}

lynq_atsvc_incb lynq_register_at_common(lynq_atsvc_outcb out_cb)
{
    if(out_cb != NULL)
    {
        handle_output = out_cb;
        ALOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        return lynq_at_common_cb;
    }
}
