﻿#include <stdio.h>
#include <stdlib.h>
//#include <unistd.h>
#include <pthread.h>
#include <string.h>
#include <log/log.h>
#include "lynq_monitor_internal.h"
#include "lynq_monitor_cfg.h"
#include "lynq_monitor_api.h"
#include "liblog/lynq_deflog.h"

#define USER_LOG_TAG "LYNQ_MONITOR"

static int lynq_monitor_ping(const char *address)
{
    char command[256] = "";
    int exit_status = 0;

    // 构造ping命令
    snprintf(command, sizeof(command), "ping -c 1 %s", address);

    // 使用system调用ping命令
    exit_status = system(command);

    // system函数返回值解析
    if (exit_status == 0)
    {
        return 0; // 成功
    }
    else if (WIFEXITED(exit_status))
    {
        return WEXITSTATUS(exit_status); // 非0退出码，失败
    }
    else
    {
        return -1; // 错误
    }
}

static int lynq_monitor_is_ping_ok(void)
{
    if (lynq_monitor_ping(g_monitor_config.ping_addr1) == 0)
    {
        return 1;
    }

    if (lynq_monitor_ping(g_monitor_config.ping_addr2) == 0)
    {
        return 1;
    }

    // ping URL failed, try ping IP
    //lynq_monitor_ping(g_monitor_config.ping_addr3);

    return 0;
}
static void * lynq_monitor_ping_check_thread(void *arg)
{
    int ret=0;
    int ping_error_count = 0;
    LYINFLOG("lynq_monitor_ping_check_thread start\n");

    while (1)
    {
        // 延时等待
        lynq_monitor_sleep(g_monitor_config.ping_monitor_period);

        if (g_monitor_config.ping_monitor_enabled == 0)
        {
            continue;
        }

        if (lynq_monitor_check_state())
        {
            continue;
        }

        if (lynq_monitor_is_data_connected() == 0)
        {
            LYERRLOG("lynq_monitor_is_data_connected ret 0\n");
            ping_error_count = 0;
            continue;
        }

        // 网络连通性检测
        if (lynq_monitor_is_ping_ok())
        {
            LYERRLOG("lynq_monitor_is_ping_ok ret 1\n");
            ping_error_count = 0;
            continue;
        }
        else
        {
            LYERRLOG("lynq_monitor_is_ping_ok ret 0\n");
            ping_error_count++;
        }

        // 检查ping_error_count并采取相应措施
        if ((g_monitor_config.limit_reset_nad_2 != 0) && (ping_error_count > g_monitor_config.limit_reset_nad_2))
        {
            lynq_monitor_need_reset_nad(LYNQ_EXCEPTION_TYPE_PING, LYNQ_ERR_PING_TIMEOUT);
            ping_error_count = 0;
            continue;
        }
        if ((g_monitor_config.limit_reset_nw_2 != 0) && (ping_error_count >= g_monitor_config.limit_reset_nw_2) &&(ping_error_count % g_monitor_config.limit_reset_nw_2 == 0))
        {
            lynq_monitor_need_reset_flight_mode(LYNQ_EXCEPTION_TYPE_PING, LYNQ_ERR_PING_TIMEOUT);
            continue;
        }
        if (g_monitor_config.limit_reset_data_2 != 0 && (ping_error_count >= g_monitor_config.limit_reset_data_2) && (ping_error_count % g_monitor_config.limit_reset_data_2 == 0))
        {
            lynq_monitor_need_reset_data(LYNQ_EXCEPTION_TYPE_PING, LYNQ_ERR_PING_TIMEOUT);
        }
    }


    return NULL;
}

int lynq_monitor_start_ping_check_thread()
{
    int result = 0;
    pthread_t thread_id;
    if ((result = pthread_create(&thread_id, NULL, lynq_monitor_ping_check_thread, NULL)) != 0)
    {
        LYERRLOG("Error creating ping check thread: %s\n", strerror(result));
        return result;
    }

    return 0;
}
/*
#include <stdio.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <unistd.h>

#define PING_TIMEOUT 5 // 5秒超时
#define PING_PACKET_SIZE 64

int ping2(const char *address)
{
    int sock;
    struct sockaddr_storage dest_addr;
    socklen_t dest_len;
    struct icmp *icmp;
    struct timeval timeout;
    char packet[PING_PACKET_SIZE];
    char ip_str[INET6_ADDRSTRLEN];
    struct addrinfo hints, *res;
    struct sockaddr_in *ipv4_addr;
    struct sockaddr_in6 *ipv6_addr;
    int bytes_received;

    // DNS解析
    memset(&hints, 0, sizeof(hints));
    hints.ai_family = AF_UNSPEC; // 允许IPv4或IPv6
    hints.ai_socktype = SOCK_RAW;
    hints.ai_protocol = IPPROTO_ICMP;
    if (getaddrinfo(address, NULL, &hints, &res) != 0)
    {
        perror("getaddrinfo");
        return -1;
    }

    // 获取第一个地址
    dest_addr.ss_family = res->ai_family;
    if (res->ai_family == AF_INET)
    {
        ipv4_addr = (struct sockaddr_in *)res->ai_addr;
        inet_ntop(AF_INET, &ipv4_addr->sin_addr, ip_str, INET_ADDRSTRLEN);
    }
    else if (res->ai_family == AF_INET6)
    {
        ipv6_addr = (struct sockaddr_in6 *)res->ai_addr;
        inet_ntop(AF_INET6, &ipv6_addr->sin6_addr, ip_str, INET6_ADDRSTRLEN);
    }
    else
    {
        freeaddrinfo(res);
        return -1;
    }
    freeaddrinfo(res);

    // 创建原始套接字
    if ((sock = socket(dest_addr.ss_family, SOCK_RAW, IPPROTO_ICMP)) < 0)
    {
        perror("socket");
        return -1;
    }

    // 设置超时
    timeout.tv_sec = PING_TIMEOUT;
    timeout.tv_usec = 0;
    setsockopt(sock, SOL_SOCKET, SO_RCVTIMEO, (struct timeval *)&timeout, sizeof(timeout));

    // 初始化ICMP包
    icmp = (struct icmp *)packet;
    icmp->icmp_type = ICMP_ECHO;
    icmp->icmp_code = 0;
    icmp->icmp_cksum = 0;
    icmp->icmp_seq = 1; // 序列号
    icmp->icmp_id = getpid(); // 进程ID作为识别号

    // 计算校验和
    icmp->icmp_cksum = in_checksum((unsigned short *)icmp, PING_PACKET_SIZE);

    // 发送ICMP包
    dest_len = (dest_addr.ss_family == AF_INET) ? sizeof(struct sockaddr_in) : sizeof(struct sockaddr_in6);
    if (sendto(sock, packet, PING_PACKET_SIZE, 0, (struct sockaddr *)&dest_addr, dest_len) < 0)
    {
        perror("sendto");
        return -1;
    }

    // 接收ICMP回应
    if ((bytes_received = recvfrom(sock, packet, PING_PACKET_SIZE, 0, (struct sockaddr *)&dest_addr, &dest_len)) < 0)
    {
        perror("recvfrom");
        return -1;
    }

    // 检查回应是否是ICMP_ECHOREPLY
    if (ntohs(((struct sockaddr_in *)&dest_addr)->sin_port) == 0 && ntohs(dest_addr.ss_family) == res->ai_family)
    {
        icmp = (struct icmp *)packet;
        if (icmp->icmp_type == ICMP_ECHOREPLY && icmp->icmp_seq == 1)
        {
            return 0; // 成功
        }
    }

    return -1; // 失败
}
*/

/*
int ping3(const char *address)
{
    char command[256] = "";
    char output_file[] = "/tmp/ping_output.txt";
    FILE *file = NULL;
    int exit_status = 0;
    int timeout_detected = 0;

    // 清除可能存在的旧输出文件
    remove(output_file);

    // 构造ping命令，将输出重定向到临时文件
    snprintf(command, sizeof(command), "ping -c 1 %s > %s 2>&1", address, output_file);

    // 执行ping命令
    exit_status = system(command);

    // 检查命令执行状态
    if (exit_status == 0)
    {
        printf("Ping successful.\n");
    }
    else if (WIFEXITED(exit_status))
    {
        // 分析输出文件，检查是否有超时信息
        file = fopen(output_file, "r");
        if (file)
        {
            char line[256];
            while (fgets(line, sizeof(line), file))
            {
                if (strstr(line, "100% packet loss") || strstr(line, "Destination Host Unreachable") || strstr(line, "time="))
                {
                    timeout_detected = 1;
                    break;
                }
            }
            fclose(file);
        }
        if (timeout_detected)
        {
            printf("Ping timed out or encountered network issues.\n");
        }
        else
        {
            printf("Ping failed with unknown error.\n");
        }
    }
    else
    {
        printf("Error executing ping command.\n");
    }

    // 清理临时文件
    remove(output_file);

    return timeout_detected ? 1 : (exit_status != 0);
}
*/
