#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include <vendor-ril/telephony/ril.h>
#include <vendor-ril/telephony/mtk_ril_sp.h>
#include "liblog/lynq_deflog.h"
#include "lynq_network.h"
#include "lynq_module_common.h"
#include "lynq_module_socket.h"
#include "lynq_module_state_buffer.h"

#define LYNQ_RESP_STRING_MAX_NUM 128
#define LYNQ_TYPE_BUF 10
#define LYNQ_URC_MSG_HEAD_ELEMENT_NUM 3
#define USER_LOG_TAG "LYNQ_NETWORK"

/*in CR AUTO00210807 MTK confirm set network selection mode max time is 14min 30s, first set 5 min 10s*/
#define WAIT_TIME_LENGTH_FOR_SET_NETWORK_SELECTION_MODE (310)
/*in CR AUTO00207414, in modem, 23G detach need 10s, 5g ims detach need 5s, so set length to 12s */
#define WAIT_TIME_LENGTH_FOR_SET_PREFFERRED_NETWORK_TYPE (12) 
/*For T800-API-1475, cfun 0 need 7s */
#define WAIT_TIME_LENGTH_FOR_RADIO_ON (65) 

#define WAIT_TIME_LENGTH_FOR_QUERY_AVAILABLE_NETWORK (600) 
#define WAIT_TIME_LENGTH_FOR_SET_IMS (65) 

#define MAX_AT_INT_RSP_NUM  32


using ::android::Parcel;

static int s_module_wait_urc_id;
static int s_module_urc_slot_id;
static signalStrength_t s_network_urc_solSigStren;

/**g_module_init_flag
* @brief mark network initialization state
* 0:deinit status
* 1:init state
*/
int g_module_init_flag = 0;

int lynq_network_init(int utoken){

    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);

    LYERRLOG("%s start, parameter is %d", __func__,utoken);

    if(g_module_init_flag != MODULE_CLOSED)
    {
        LYERRLOG("module state is %d",g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
   if(utoken <0){
        LYERRLOG("utoken  is less than 0",utoken);      
        return LYNQ_E_PARAMETER_ANONALY;
    }

    g_module_init_flag = MODULE_SWITCHING;

    g_module_Global_uToken = utoken;
	   
    int ret;

    init_network_timer_all();
    
    ret = lynq_start_all_urc_socket_thread();
    if(ret != 0)
    {
        LYERRLOG("init socket urc fail!!!");
        g_module_init_flag = MODULE_CLOSED;  
        return LYNQ_E_INNER_ERROR;
    }

    ret = lynq_start_all_rc_socket_thread();
    if(ret !=0)
    {
        LYERRLOG("init socket client fail!!!");
        lynq_close_all_urc_socket_thread();
        g_module_init_flag = MODULE_CLOSED;  
        return LYNQ_E_INNER_ERROR;
    }
    g_module_init_flag = MODULE_RUNNING;

    LYERRLOG("%s end suc", __func__);
    
    return RESULT_OK;    
}

int lynq_network_deinit(void){

    LYERRLOG("%s start", __func__);

    if (g_module_init_flag != MODULE_RUNNING)
    {
       LYERRLOG("module state is %d",g_module_init_flag);
       return LYNQ_E_CONFLICT;
    }  
    g_module_init_flag = MODULE_SWITCHING;

    lynq_close_all_urc_socket_thread();
    lynq_close_all_rc_socket_thread();    
    deinit_network_timer_all();

    g_module_init_flag = MODULE_CLOSED;

    LYERRLOG("%s end suc", __func__);
    return RESULT_OK;    
}

int strUpper(char * str)
{
    int i=0;
    while(1)
    {
        if(str[i]=='\0')
        {
            break;
        }
        if(str[i]>='a'&&str[i]<='z')
        {
             str[i]=str[i]-32;
        }
        i++;
    }
    return RESULT_OK;      
}

#if 0    
for (i = 0; i < num; i++) {
        appendPrintBuf("%s[%d: type=%d,registered=%d,timeStampType=%d,timeStamp=%lld", printBuf, i,
            p_cur->cellInfoType, p_cur->registered, p_cur->timeStampType, p_cur->timeStamp);
        p.writeInt32((int)p_cur->cellInfoType);//1
        p.writeInt32(p_cur->registered);//2
        p.writeInt32(p_cur->timeStampType);//3
        p.writeInt64(p_cur->timeStamp);//4
        case RIL_CELL_INFO_TYPE_GSM: {
               appendPrintBuf("%s GSM id: mcc=%d,mnc=%d,lac=%d,cid=%d,", printBuf,
                   p_cur->CellInfo.gsm.cellIdentityGsm.mcc,
                   p_cur->CellInfo.gsm.cellIdentityGsm.mnc,
                   p_cur->CellInfo.gsm.cellIdentityGsm.lac,
                   p_cur->CellInfo.gsm.cellIdentityGsm.cid);
               appendPrintBuf("%s gsmSS: ss=%d,ber=%d],", printBuf,
                   p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength,
                   p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);

               p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mcc);//1
               p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.mnc);//2
               p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.lac);//3
               p.writeInt32(p_cur->CellInfo.gsm.cellIdentityGsm.cid);//4
               p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.signalStrength); //5
               p.writeInt32(p_cur->CellInfo.gsm.signalStrengthGsm.bitErrorRate);//6
               break;
           }
           case RIL_CELL_INFO_TYPE_WCDMA: {
               appendPrintBuf("%s WCDMA id: mcc=%d,mnc=%d,lac=%d,cid=%d,psc=%d,", printBuf,
                   p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc,
                   p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc,
                   p_cur->CellInfo.wcdma.cellIdentityWcdma.lac,
                   p_cur->CellInfo.wcdma.cellIdentityWcdma.cid,
                   p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);
               appendPrintBuf("%s wcdmaSS: ss=%d,ber=%d],", printBuf,
                   p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength,
                   p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);

               p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mcc);//1
               p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.mnc);//2
               p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.lac);//3
               p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.cid);//4
               p.writeInt32(p_cur->CellInfo.wcdma.cellIdentityWcdma.psc);//5
               p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.signalStrength);//6
               p.writeInt32(p_cur->CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);//7
               break;
           }
           case RIL_CELL_INFO_TYPE_CDMA: {
               appendPrintBuf("%s CDMA id: nId=%d,sId=%d,bsId=%d,long=%d,lat=%d", printBuf,
                   p_cur->CellInfo.cdma.cellIdentityCdma.networkId,
                   p_cur->CellInfo.cdma.cellIdentityCdma.systemId,
                   p_cur->CellInfo.cdma.cellIdentityCdma.basestationId,
                   p_cur->CellInfo.cdma.cellIdentityCdma.longitude,
                   p_cur->CellInfo.cdma.cellIdentityCdma.latitude);

               p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.networkId);//1
               p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.systemId);//2
               p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.basestationId);//3
               p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.longitude);//4
               p.writeInt32(p_cur->CellInfo.cdma.cellIdentityCdma.latitude);//5

               appendPrintBuf("%s cdmaSS: dbm=%d ecio=%d evdoSS: dbm=%d,ecio=%d,snr=%d", printBuf,
                   p_cur->CellInfo.cdma.signalStrengthCdma.dbm,
                   p_cur->CellInfo.cdma.signalStrengthCdma.ecio,
                   p_cur->CellInfo.cdma.signalStrengthEvdo.dbm,
                   p_cur->CellInfo.cdma.signalStrengthEvdo.ecio,
                   p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);

               p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.dbm);//6
               p.writeInt32(p_cur->CellInfo.cdma.signalStrengthCdma.ecio);//7
               p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.dbm);//8
               p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.ecio);//9
               p.writeInt32(p_cur->CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);//10
               break;
           }
           case RIL_CELL_INFO_TYPE_LTE: {
               /*Typethree add for T800 earfcn 2022/06/09 start*/
               appendPrintBuf("%s LTE id: mcc=%d,mnc=%d,ci=%d,pci=%d,tac=%d,earfcn=%d", printBuf,
                   p_cur->CellInfo.lte.cellIdentityLte.mcc,
                   p_cur->CellInfo.lte.cellIdentityLte.mnc,
                   p_cur->CellInfo.lte.cellIdentityLte.ci,
                   p_cur->CellInfo.lte.cellIdentityLte.pci,
                   p_cur->CellInfo.lte.cellIdentityLte.tac,
                   p_cur->CellInfo.lte.cellIdentityLte.earfcn);

               p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mcc);
               p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.mnc);
               p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.ci);
               p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.pci);
               p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.tac);//5
               p.writeInt32(p_cur->CellInfo.lte.cellIdentityLte.earfcn);//6
               /*Typethree add for T800 earfcn 2022/06/09 end*/
               appendPrintBuf("%s lteSS: ss=%d,rsrp=%d,rsrq=%d,rssnr=%d,cqi=%d,ta=%d", printBuf,
                   p_cur->CellInfo.lte.signalStrengthLte.signalStrength,
                   p_cur->CellInfo.lte.signalStrengthLte.rsrp,
                   p_cur->CellInfo.lte.signalStrengthLte.rsrq,
                   p_cur->CellInfo.lte.signalStrengthLte.rssnr,
                   p_cur->CellInfo.lte.signalStrengthLte.cqi,
                   p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);
               p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.signalStrength); //7
               p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrp);//8
               p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rsrq);//9
               p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.rssnr);//10
               p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.cqi);//11
               p.writeInt32(p_cur->CellInfo.lte.signalStrengthLte.timingAdvance);//12
               break;
           }
           case RIL_CELL_INFO_TYPE_TD_SCDMA: {
               appendPrintBuf("%s TDSCDMA id: mcc=%d,mnc=%d,lac=%d,cid=%d,cpid=%d,", printBuf,
                   p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc,
                   p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc,
                   p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac,
                   p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid,
                   p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);
               appendPrintBuf("%s tdscdmaSS: rscp=%d],", printBuf,
                   p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);

               p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mcc);//1
               p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.mnc);//2
               p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.lac);//3
               p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cid);//4
               p.writeInt32(p_cur->CellInfo.tdscdma.cellIdentityTdscdma.cpid);//5
               p.writeInt32(p_cur->CellInfo.tdscdma.signalStrengthTdscdma.rscp);//6
               break;
           }
           #ifdef TELEMATIC_5G_SUPPORT
            case RIL_CELL_INFO_TYPE_NR: {
                /*Typethree add for T800 5G cid 2022/06/09 start*/
                appendPrintBuf("%s NR id: mcc=%d,mnc=%d,nci=%llu,pci=%d,tac=%d", printBuf,
                    p_cur->CellInfo.nr.cellidentity.mcc,
                    p_cur->CellInfo.nr.cellidentity.mnc,
                    p_cur->CellInfo.nr.cellidentity.nci,
                    p_cur->CellInfo.nr.cellidentity.pci,
                    p_cur->CellInfo.nr.cellidentity.tac,
                    p_cur->CellInfo.nr.cellidentity.nrarfcn);

                p.writeInt32(p_cur->CellInfo.nr.cellidentity.mcc);//1
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.mnc);//2
                p.writeUint64(p_cur->CellInfo.nr.cellidentity.nci);//3
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.pci);//4
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.tac);//5
                p.writeInt32(p_cur->CellInfo.nr.cellidentity.nrarfcn);//6
                /*Typethree add for T800 5G cid 2022/06/09 end*/
                appendPrintBuf("%s NRSS: ssRsrp=%d,ssRsrq=%d,ssSinr=%d,csiRsrp=%d,csiRsrq=%d,csiSinr=%d", printBuf,
                    p_cur->CellInfo.nr.signalStrength.ssRsrp,
                    p_cur->CellInfo.nr.signalStrength.ssRsrq,
                    p_cur->CellInfo.nr.signalStrength.ssSinr,
                    p_cur->CellInfo.nr.signalStrength.csiRsrp,
                    p_cur->CellInfo.nr.signalStrength.csiRsrq,
                    p_cur->CellInfo.nr.signalStrength.csiSinr);
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.ssRsrp);//7
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.ssRsrq);//8
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.ssSinr);//9
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.csiRsrp);//10
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.csiRsrq);//11
                p.writeInt32(p_cur->CellInfo.nr.signalStrength.csiSinr);//12
                break;
            }
            #endif
#endif

int copyCellInfoList(Parcel* &p,uint64_t *cellinfo,int *tac,int *earfcn)
{
    int32_t v=0;
    int64_t v6=0;
    if(NULL == cellinfo)
    {
        LYERRLOG("*cellinfo error");
        return LYNQ_E_PARAMETER_ANONALY;   
    }

    int nothing = 0;
    int cell_id = 0;
    int i;
    p->readInt32(&v);//1
    RIL_CellInfoType cellinfoType  = RIL_CellInfoType(v);
    p->readInt32(&nothing);//2
    // cellinfo->cellinfo.cellInfoType = RIL_CellInfoType(v);
    // p->readInt32(&cellinfo->cellinfo.registered);
    p->readInt32(&v);//3
    // cellinfo->cellinfo.timeStampType = RIL_TimeStampType(v);
    p->readInt64(&v6);//4
    // cellinfo->cellinfo.timeStamp = v6;
    switch(cellinfoType) {
        case RIL_CELL_INFO_TYPE_GSM: {
            p->readInt32(&nothing);//1
            p->readInt32(&nothing); //2
            p->readInt32(tac);//lac
            p->readInt32(&cell_id);//4
            p->readInt32(earfcn);// 5 signalStrength
            p->readInt32(&nothing);//6    
            *cellinfo = (uint64_t)cell_id;            
            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            p->readInt32(&nothing);//1
            p->readInt32(&nothing);//2
            p->readInt32(tac);//3 lac
            p->readInt32(&cell_id);//4
            p->readInt32(earfcn);//5 psc
            p->readInt32(&nothing); //6
            p->readInt32(&nothing);//7
            *cellinfo = (uint64_t)cell_id;            
            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            for(i=0;i<10;i++)
            {
                p->readInt32(&nothing);            
            }            
            *cellinfo = 0;
            *tac = 0;
            *earfcn = 0;
            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {
            p->readInt32(&nothing);//1
            p->readInt32(&nothing);//2
            p->readInt32(&cell_id);//3
            p->readInt32(&nothing);//4 pci
            p->readInt32(tac);//5
            p->readInt32(earfcn);//6
            for(i=0;i<6;i++)
            {
                p->readInt32(&nothing);
            }            
            *cellinfo = (uint64_t)cell_id;
            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            p->readInt32(&nothing);//1
            p->readInt32(&nothing);//2
            p->readInt32(tac);//lac
            p->readInt32(&cell_id);//4
            p->readInt32(&nothing);//5
            p->readInt32(&nothing);//6
            *cellinfo = (uint64_t)cell_id;       
            *earfcn = 0;
            break;
        }
        case RIL_CELL_INFO_TYPE_NR: {
            p->readInt32(&nothing);//1
            p->readInt32(&nothing);//2
            p->readUint64(cellinfo);//3
            p->readInt32(&nothing);//4 pci
            p->readInt32(tac);//5
            p->readInt32(earfcn);//6
            for(i=0;i<6;i++)
            {
                p->readInt32(&nothing);
            }         
            break;
        }
    }
    LYINFLOG("CID:%llu, tac:%d, earfcn:%d",*cellinfo,*tac,*earfcn);   
    return RESULT_OK;    
}

int copyCellInfo(Parcel* &p, int cell_info[MAX_CELLINFO_ITEM_NUMBER], int* valid_number)
{
    int32_t v=0;
    int64_t timeStamp=0;
    uint64_t cell_id=0;
    int head_num=2;   
    int i;
    *valid_number=0;
    p->readInt32(&v);//1
    RIL_CellInfoType cellinfoType  = RIL_CellInfoType(v);
    p->readInt32(&(cell_info[1]));//2
    // cellinfo->cellinfo.cellInfoType = RIL_CellInfoType(v);
    // p->readInt32(&cellinfo->cellinfo.registered);
    p->readInt32(&(cell_info[2]));//3
    // cellinfo->cellinfo.timeStampType = RIL_TimeStampType(v);
    p->readInt64(&timeStamp);//4
    // cellinfo->cellinfo.timeStamp = v6;
    //cell_info[3]=(timeStamp & 0x00000000ffffffff);
    //cell_info[4]=((timeStamp & 0xffffffff00000000) >> 32);
    switch(cellinfoType) 
    {
        case RIL_CELL_INFO_TYPE_GSM: 
        {
            cell_info[0] = LYNQ_CELL_INFO_TYPE_GSM;
            for(i=0;i<6;i++)
            {
                p->readInt32(&(cell_info[head_num+i]));
            }      
            *valid_number=6+head_num;
            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: 
        {
            cell_info[0] = LYNQ_CELL_INFO_TYPE_WCDMA;
            for(i=0;i<7;i++)
            {
                p->readInt32(&(cell_info[head_num+i]));
            }         
            *valid_number=7+head_num;
            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: 
        {
            for(i=0;i<10;i++)
            {
                p->readInt32(&(cell_info[head_num+i]));
            }                                
            *valid_number=0;
            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: 
        {
            cell_info[0] = LYNQ_CELL_INFO_TYPE_LTE;
            for(i=0;i<2;i++)
            {
                p->readInt32(&(cell_info[head_num+i]));
            }   
            p->readInt32(&(cell_info[head_num+2+1]));//cid            
            p->readInt32(&(cell_info[head_num+2+2]));//pci
             p->readInt32(&(cell_info[head_num+2+0]));//tac
            for(i=0;i<7;i++) //arfcn+signal strength + cqi+time advance 
            {
                p->readInt32(&(cell_info[head_num+5+i]));
            } 
            *valid_number=12+head_num;
            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: 
        {
            for(i=0;i<12;i++)
            {
                p->readInt32(&(cell_info[head_num+i]));
            }                   
            *valid_number=0;
            break;
        }
        case RIL_CELL_INFO_TYPE_NR: 
        {
            cell_info[0] = LYNQ_CELL_INFO_TYPE_NR;
            for(i=0;i<2;i++)
            {
                p->readInt32(&(cell_info[head_num+i]));
            }                   
            p->readUint64(&cell_id);//3
            cell_info[head_num+2+1] = (cell_id & 0x00000000ffffffff);
            cell_info[head_num+2+2]=((cell_id & 0xffffffff00000000) >> 32);
            p->readInt32(&(cell_info[head_num+2+3]));//pci
            p->readInt32(&(cell_info[head_num+2+0]));//tac
            for(i=0;i<7;i++)  //arfcn+signal strength 
            {
                p->readInt32(&(cell_info[head_num+6+i]));
            }    
            *valid_number=13+head_num;
            break;
        }
    }
    for(i=0; i<(*valid_number); i++)
    {
        LYDBGLOG("cell info %d is %d",i, cell_info[i]);
    }    
    return RESULT_OK;    
}

static char * lynqStrdupReadString(Parcel* &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

int lynq_query_operater(char *OperatorFN,char *OperatorSH,char *MccMnc)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
    if(NULL == OperatorFN||NULL == OperatorSH|| NULL == MccMnc)
    {
        LYERRLOG("%s some parameter OperatorFN OperatorSH MccMnc %s %s %s is NULL",__func__,OperatorFN,OperatorSH,MccMnc);  
        return LYNQ_E_PARAMETER_ANONALY;   
    }    

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OPERATOR,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }       
 
    int num ;
    char *resp[LYNQ_RESP_STRING_MAX_NUM];

    p->readInt32(&num);
    if(num == 0 || num > LYNQ_RESP_STRING_MAX_NUM)
    {
        LYERRLOG("no paramters or num %d too great",num);        
        delete p;      
        return LYNQ_E_INNER_ERROR;    
    }else{
        int i;
        for(i = 0; i<num;i++)
        {
            resp[i] = lynqStrdupReadString(p);
        }
        if(NULL != resp[0])
        {
            strcpy(OperatorFN,resp[0]);
        }
        if(NULL != resp[1])
        {
            strcpy(OperatorSH,resp[1]);
        }
        if(NULL != resp[2])
        {
            strcpy(MccMnc,resp[2]);
        }
        for(i = 0; i<num;i++)
        {
            if(resp[i]!=NULL)
            {
                free(resp[i]);            
            }            
        }
    }

    LYDBGLOG("%s suc",__func__);   
    delete p;       
    return RESULT_OK;    
}

int lynq_query_network_selection_mode(int *netselMode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    if(NULL == netselMode)
    {
        LYERRLOG("%s parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;   
    }    
 
    Parcel* p=NULL;    
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int readnum;
    p->readInt32(&readnum);
    p->readInt32(netselMode);

    LYINFLOG("%s suc %d",__func__,*netselMode);   
    delete p;       
    return RESULT_OK;  
}

int lynq_set_network_selection_mode(const char *mode,const char* mccmnc)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
    if(NULL == mode || (strlen(mode) == 0))
    {
        LYERRLOG("%s parameter mod %s is error",__func__,mode);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    if(!strcmp(mode,"Manual"))
    {
        if(mccmnc == NULL || strlen(mccmnc) == 0)
        {
             LYERRLOG("%s parameter mccmnc %s is error",__func__,mccmnc);  
             return LYNQ_E_PARAMETER_ANONALY;
        }        
    }
    
    Parcel* p=NULL;
    int ret;

    if(!strcmp(mode,"Auto"))
    {
        ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_NETWORK_SELECTION_MODE,RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC,0,"");
    }
    else if(!strcmp(mode,"Manual"))
    {
        ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_NETWORK_SELECTION_MODE,RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL,1,"%s",mccmnc); 
    }
    else 
    {
        LYERRLOG("%s parameter mode %s is errir",__func__,mode);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
        
    LYDBGLOG("%s set mode %s mccmnc %s suc",__func__,mode,mccmnc);   
    delete p;
    return RESULT_OK;  
}

int lynq_query_available_network(char *OperatorFN,char *OperatorSH,char *MccMnc,char * NetStatus)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == OperatorFN||NULL == OperatorSH||NULL == MccMnc||NULL == NetStatus)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }  

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_QUERY_AVAILABLE_NETWORK,RIL_REQUEST_QUERY_AVAILABLE_NETWORKS,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   

    int num =p->readInt32();
    char *resp[LYNQ_RESP_STRING_MAX_NUM];
    if(num == 0 || num > LYNQ_RESP_STRING_MAX_NUM)
    {
        LYERRLOG("no paramters or num %d too great",num);        
        delete p;      
        return LYNQ_E_INNER_ERROR;    
    }else{
        int i;
        for(i = 0; i<num;i++)
        {
            resp[i] = lynqStrdupReadString(p);
        }
        if(NULL != resp[0])
        {
            strcpy(OperatorFN,resp[0]);
        }
        if(NULL != resp[1])
        {
            strcpy(OperatorSH,resp[1]);
        }
        if(NULL != resp[2])
        {
            strcpy(MccMnc,resp[2]);
        }
        if(NULL != resp[3])
        {
            strcpy(NetStatus,resp[3]);
        }
        for(i = 0; i<num;i++)
        {
            if(resp[i]!=NULL)
            {
                free(resp[i]);            
            }            
        }
    }
    delete p;
    LYDBGLOG("%s suc",__func__);   
    return RESULT_OK;  
}

int lynq_query_registration_state_from_parcel(Parcel* p, int num,int reject_index, int* regState,char * LAC,char * CID,int *netType,int *netRejected)
{
    int i;
    char *resp[LYNQ_RESP_STRING_MAX_NUM]={0};    
    int ret = RESULT_OK;
    for(i=0;i<num;i++)
    {
        resp[i]=lynqStrdupReadString(p);
    }            
    if(resp[0]==NULL)
    {
        LYERRLOG("%s resp[0] %s is NULL",__func__,resp[0]);
        ret = LYNQ_E_INNER_ERROR;
        goto registration_from_parcel_return;
    }
    *regState = atoi(resp[0]);   
    strcpy(CID,""); 
    strcpy(LAC,"");
    *netType = RADIO_TECH_UNKNOWN;            
    *netRejected = -1;                   
    if((*regState)==1 || (*regState)==5) 
    {   
        if(resp[1]!=NULL) 
        {
            strcpy(LAC,resp[1]);
        }
        else 
        {           
            LYERRLOG("%s resp[1] %s is NULL",__func__);
        }
        
        if(resp[2]!=NULL) 
        {
            strcpy(CID,resp[2]);
        }
        else 
        {                
            LYERRLOG("%s resp[2] %s is NULL",__func__);
        }

        if(resp[3]!=NULL) 
        {
            *netType = atoi(resp[3]);
        }
        else 
        {            
            LYERRLOG("%s data resp[3] %s is NULL",__func__);
        }
    }
    else //if((*regState)==3 || (*regState)==13) //LYNQ_HUANG_QING_AT_20250421_ZXW_TASK_1355_CR_202504112CA2ADB1_MODIFY
    {    
        if(resp[reject_index]==NULL)
        {    
            LYERRLOG("%s resp[%d] is NULL",__func__,reject_index);            
        }  
        else 
        {
            *netRejected = atoi(resp[reject_index]);            
        }        
    }    
    LYINFLOG("regstate:%d, CID:%s, LAC:%s, netType:%d, reject_code:%d",*regState,CID,LAC,*netType,*netRejected);

registration_from_parcel_return:

    for(i=0;i<num;i++)
    {
        if(resp[i]!=NULL)
        {
            free(resp[i]);             
        }            
    }                  
    return ret;
}


int lynq_query_registration_state(const char *type,int* regState,int* imsRegState,char * LAC,char * CID,int *netType,int *radioTechFam,int *netRejected)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    
    if(NULL == type || NULL ==regState ||NULL ==imsRegState ||NULL ==LAC ||NULL ==CID ||NULL ==netType ||NULL ==radioTechFam || NULL == netRejected)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }  
    if(strlen(type)>LYNQ_TYPE_BUF)
    {
        LYERRLOG("[%s]the parameter is inavaliable !",__FUNCTION__);
        return LYNQ_E_PARAMETER_ANONALY;   
    }   
    
    int request;
    char str[LYNQ_TYPE_BUF];   
    memcpy(str,type,strlen(type)+1);
    strUpper(str);
    if(!strcmp(str,"VOICE"))
    {    
        if(get_state_from_buf(NETWORK_STATE_BUFFER_TYPE_VOICE_REG,3,regState,netType,netRejected,2,LAC,CID)==0)
        {
            return RESULT_OK;  
        }       
        request = RIL_REQUEST_VOICE_REGISTRATION_STATE;
    }else if(!strcmp(str,"DATA")){
        if(get_state_from_buf(NETWORK_STATE_BUFFER_TYPE_DATA_REG,3,regState,netType,netRejected,2,LAC,CID)==0)
        {
            return RESULT_OK;  
        }      
        request = RIL_REQUEST_DATA_REGISTRATION_STATE;
    }else if(!strcmp(str,"IMS")){
        if(get_state_from_buf(NETWORK_STATE_BUFFER_TYPE_IMS_REG,2,imsRegState,radioTechFam,0)==0)
        {
            return RESULT_OK;  
        }       
        request = RIL_REQUEST_IMS_REGISTRATION_STATE;
    }else{
        LYERRLOG("request error");
        return LYNQ_E_PARAMETER_ANONALY;
    }    

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,request,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num;
    char *resp[LYNQ_RESP_STRING_MAX_NUM]={0};       
    if(!strcmp(str,"VOICE"))
    {        
        p->readInt32(&num);        
        if(num >0 && num<=15)
        {
            ret=lynq_query_registration_state_from_parcel(p, num, 13, regState, LAC,CID,netType,netRejected);
            if(ret!=RESULT_OK)
            {
                LYERRLOG("%s call lynq_query_registration_state_from_parcel fail",__func__);             
                goto registration_return;       
            }  
            set_state_to_buf(NETWORK_STATE_BUFFER_TYPE_VOICE_REG,3,*regState,*netType,*netRejected,2,LAC,CID);
            goto registration_return;
        }
        else 
        {
            LYERRLOG("%s type %s num %d error",__func__,str,num);
            delete p;
            return LYNQ_E_INNER_ERROR;
        }            
    }
    else if(!strcmp(str,"DATA")){
        p->readInt32(&num);
        if(num >0 && num <=11)
        {        
            ret=lynq_query_registration_state_from_parcel(p, num, 4, regState, LAC,CID,netType,netRejected);
            if(ret!=RESULT_OK)
            {
                LYERRLOG("%s call lynq_query_registration_state_from_parcel fail",__func__);             
                goto registration_return;       
            }              
                        
            set_state_to_buf(NETWORK_STATE_BUFFER_TYPE_DATA_REG,3,*regState,*netType,*netRejected,2,LAC,CID);                
            goto registration_return;
        }
        else 
        {
            LYERRLOG("%s type %s num %d error",__func__,str,num);
            delete p;
            return LYNQ_E_INNER_ERROR;
        }            

    }
    else // "IMS"
    {
        p->readInt32(&num);
        if(num == 2)
        {
            p->readInt32(imsRegState);
            p->readInt32(radioTechFam);
            set_state_to_buf(NETWORK_STATE_BUFFER_TYPE_IMS_REG,2,*imsRegState,*radioTechFam,0);
			LYINFLOG("imsRegState:%d, radioTechFam:%d",*imsRegState,*radioTechFam);
        }
        else 
        {
            LYERRLOG("%s type %s num %d error",__func__,str,num);
            delete p;
            return LYNQ_E_INNER_ERROR;
        }            
    }  
     
registration_return:

    if(ret==RESULT_OK)
    {
        LYDBGLOG("%s suc",__func__); 
    }    
   
    delete p;
    return ret;
    
}

int lynq_query_prefferred_networktype(int *preNetType)
{    
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == preNetType)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }          

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE,0,"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num;
    p->readInt32(&num);
    p->readInt32(preNetType);  
    
    LYINFLOG("%s suc %d",__func__,*preNetType); 
    delete p;
    return RESULT_OK;  
}

int lynq_set_prefferred_networktype(const int preffertype)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(preffertype < 0||preffertype >33)
    {
        LYERRLOG("%s parameter %d error",__func__,preffertype);  
        return LYNQ_E_PARAMETER_ANONALY;
    }     

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_PREFFERRED_NETWORK_TYPE,RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE,1,"%d",preffertype);
     
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    LYDBGLOG("%s set %d suc",__func__,preffertype);     
    delete p;
    return RESULT_OK;  
   
}

int lynq_query_cell_info(uint64_t cellinfo[CELLINFO_MAX_NUM],int tac[CELLINFO_MAX_NUM],int earfcn[CELLINFO_MAX_NUM],int * realNum)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == realNum)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }      
    
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_GET_CELL_INFO_LIST,0,"");
    
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num;

    p->readInt32(&num);
    LYINFLOG("cell info num:%d",num);
    *realNum = num;
    for(int i = 0;i<num;i++)
    {
        copyCellInfoList(p,&cellinfo[i],&tac[i],&earfcn[i]);
    }
    
    LYDBGLOG("%s suc",__func__); 
    delete p;
    return RESULT_OK;  
}

int copy_local_cellinfo_to_user_server_cell_info(int local_cell_info[MAX_CELLINFO_ITEM_NUMBER],int cell_info[MAX_CELLINFO_ITEM_NUMBER])
{
     int cellinfo_type= local_cell_info[0];
     int head_num=1;
     int i;
     cell_info[0] = cellinfo_type;
    
     switch(cellinfo_type) 
     {
        case LYNQ_CELL_INFO_TYPE_GSM: 
        {
            for(i=0;i<4;i++)
            {
                cell_info[head_num+i]=local_cell_info[2+i];
            }      
            return head_num+4;            
        }
        case LYNQ_CELL_INFO_TYPE_WCDMA: 
        {
            for(i=0;i<5;i++)
            {
                cell_info[head_num+i]=local_cell_info[2+i];
            }         
            return head_num+5;            
        }
        case LYNQ_CELL_INFO_TYPE_LTE: 
        {
            for(i=0;i<6;i++)
            {
                cell_info[head_num+i]=local_cell_info[2+i];
            }                                   
            return  head_num+6;          
        }
        case LYNQ_CELL_INFO_TYPE_NR: 
        {
            for(i=0;i<7;i++)
            {
                cell_info[head_num+i]=local_cell_info[2+i];
            }                                   
            return  head_num+7;            
        }
        default:
        {
            LYINFLOG("%s cell type %d not support",__func__,cellinfo_type); 
            return 0;
        }           
     }

}

#if 0
return 0  :query success
return not 0 :query failure

serve_cell_info       serve cell info
serve_cell_info[0]    corresponding to lynq_network_cell_info_type 
serve_cell_info[1]    /* 3-digit Mobile Country Code, 0..999, INT_MAX if unknown  */
serve_cell_info[2]    /* 2 or 3-digit Mobile Network Code, 0..999, INT_MAX if unknown  */
                      /* 2 or 3-digit Mobile Network Code, 0..999, INT_MAX if unknown  */
serve_cell_info[3]    lac or tac
                      for LYNQ_CELL_INFO_TYPE_GSM or LYNQ_CELL_INFO_TYPE_WCDMA
                      /* 16-bit Location Area Code, 0..65535, INT_MAX if unknown  */
                       for  LYNQ_CELL_INFO_TYPE_LTE or LYNQ_CELL_INFO_TYPE_NR
                       /* 16-bit tracking area code, INT_MAX if unknown  */
serve_cell_info[4]  cellid
                    for LYNQ_CELL_INFO_TYPE_GSM
                    /* 16-bit GSM Cell Identity described in TS 27.007, 0..65535, INT_MAX if unknown  */            
                    for LYNQ_CELL_INFO_TYPE_WCDMA 
                    /* 28-bit UMTS Cell Identity described in TS 25.331, 0..268435455, INT_MAX if unknown  */
                    for LYNQ_CELL_INFO_TYPE_LTE
                    /* 28-bit Cell Identity described in TS 36.331, INT_MAX if unknown */        
                    for LYNQ_CELL_INFO_TYPE_NR
                    NR Cell Identity 'S low 32 bit
                    /**
                      * NR Cell Identity in range [0, 68719476735] (36 bits) described in 3GPP TS 38.331, which
                      * unambiguously identifies a cell within a PLMN. This value must be valid for registered or
                      * camped cells; LONG_MAX (2^63-1) means invalid/unreported.
                    */                    
serve_cell_info[5]
                 for LYNQ_CELL_INFO_TYPE_WCDMA  psc  /* 9-bit UMTS Primary Scrambling Code described in TS 25.331, 0..511, INT_MAX if unknown */
                 for LYNQ_CELL_INFO_TYPE_LTE    pci    /* physical cell id 0..503, INT_MAX if unknown  */
                 for LYNQ_CELL_INFO_TYPE_NR     NR Cell Identity 's high 32 bit 
                 /**
                      * NR Cell Identity in range [0, 68719476735] (36 bits) described in 3GPP TS 38.331, which
                      * unambiguously identifies a cell within a PLMN. This value must be valid for registered or
                      * camped cells; LONG_MAX (2^63-1) means invalid/unreported.
                 */        
                 
serve_cell_info[6]                 
                 for LYNQ_CELL_INFO_TYPE_LTE    earfcn; /* 18-bit LTE Absolute RF Channel Number; this value must be reported */
                 for LYNQ_CELL_INFO_TYPE_NR     pci     /* Physical cell id in range [0, 1007] described in 3GPP TS 38.331. This value must be valid. */
                 
serve_cell_info[7]                  
                 for LYNQ_CELL_INFO_TYPE_NR     nrarfcn     /**
                                                         * NR Absolute Radio Frequency Channel Number, in range [0, 3279165].
                                                         * Reference: 3GPP TS 38.101-1 and 3GPP TS 38.101-2 section 5.4.2.1.
                                                         * This value must be valid.
                                                         */ 
valid_number  serve_cell_info's valid data length

for LYNQ_CELL_INFO_TYPE_GSM    valid_number >= 5 &&  <= MAX_CELLINFO_ITEM_NUMBER
for LYNQ_CELL_INFO_TYPE_WCDMA  valid_number >= 6 &&  <= MAX_CELLINFO_ITEM_NUMBER
for LYNQ_CELL_INFO_TYPE_LTE     valid_number  >= 7 &&  <= MAX_CELLINFO_ITEM_NUMBER
for LYNQ_CELL_INFO_TYPE_NR     valid_number  >= 8 &&  <= MAX_CELLINFO_ITEM_NUMBER
#endif

int lynq_query_serve_cell_info(int serve_cell_info[MAX_CELLINFO_ITEM_NUMBER], int *valid_number)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == valid_number || NULL == serve_cell_info)
    {
        LYERRLOG("%s there is parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }      
    
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_GET_CELL_INFO_LIST,0,"");
    
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num;
    int local_valid_number;
    int local_cell_info[MAX_CELLINFO_ITEM_NUMBER];

    p->readInt32(&num);
    *valid_number=0;
    LYINFLOG("cell info num:%d",num);
    for(int i = 0;i<num;i++)
    {
        copyCellInfo(p,local_cell_info,&local_valid_number);
        if(local_valid_number>0 && local_cell_info[1]!=0)
        {
              (*valid_number)=copy_local_cellinfo_to_user_server_cell_info(local_cell_info,serve_cell_info);
              if((*valid_number)>0)
              {
                  break;
              }
            else 
            {
                LYINFLOG("%s fail",__func__); 
                delete p;
                return LYNQ_E_INNER_ERROR;
            }
        }
        
    }
    
    LYDBGLOG("%s suc",__func__); 
    delete p;
    return RESULT_OK;  
}


int lynq_set_unsol_cell_info_listrate(const int rate)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE,1,"%d",rate);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    LYINFLOG("%s set %d suc",__func__,rate);    
    delete p;
    return RESULT_OK;      
}

int lynq_set_band_mode(const int bandmode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    Parcel* p=NULL;      
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SET_BAND_MODE,1,"%d",bandmode);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    LYINFLOG("%s set %d suc",__func__,bandmode);    
    delete p;
    return RESULT_OK;  
}

int lynq_query_available_bandmode(int availBanMode[])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == availBanMode)
    {
        LYERRLOG("%s parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE,0,"");
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   
    
    int num = 0;
    int res = 0;
    int i;

    p->readInt32(&num);
    LYINFLOG("num = %d",num);
    availBanMode[0] = num;
    for(i=1 ;i<=num;i++)
    {
        p->readInt32(&res);
        availBanMode[i]=res;
    }
 
    LYINFLOG("%s suc",__func__);  
    delete p;
    return RESULT_OK;                
}

const char * lynq_get_raw_data(Parcel* &p, int* data_len) 
{
    int32_t len;
    int status;
    char *data;

    *data_len=0;

    status = p->readInt32(&len);

    if (status != 0) {
        LYERRLOG("%s status is %d",__func__,status);
        return NULL;
    }

    // The java code writes -1 for null arrays
    if (((int)len) == -1 || ((int)len) == 0) 
    {
        LYERRLOG("%s len is %d",__func__,len);
        return NULL;
    }
    LYINFLOG("%s len is %d",__func__,len);

    data = (char*) p->readInplace(len); 
    *data_len=len;

    return data;
}

int GetIntArrayInRespString(Parcel* &p, const char* tagString, int int_array_in_resp[MAX_AT_INT_RSP_NUM], int* valid_num)
{
    int bfind=false;
    const char* data;
    int data_len;
    char* data_str;
    char* start;
    int length;
    int i;
    int num_start;
    int ret=RESULT_OK;
    int pos = p->dataPosition();
    data = lynq_get_raw_data(p,&data_len);
    p->setDataPosition(pos);
    if(data==NULL || data_len == 0)
    {
        LYERRLOG("%s lynq_get_raw_data NULL or data_len is 0",__func__);          
        return LYNQ_E_INNER_ERROR; 
    }
    data_str = (char*) calloc(1,data_len+1);
    if (NULL == data_str) 
    {
        LYERRLOG("%s alloc mem error, data_len is %d",__func__,data_len+1);              
        return LYNQ_E_MALLOC_ERROR;
    }
    memmove(data_str, data, data_len);     
    data_str[data_len]='\0';           
    LYINFLOG("AT Rsp string is %s",data_str);  
    start = strstr(data_str,tagString);
    int local_valid_num=0;
    if(start!=NULL)
    {
         start=start+strlen(tagString);
         length=strlen(start)+1;
         for(i=0; i<length;i++)
         {
             if((!bfind) && (start[i] >= '0') && (start[i] <= '9'))
             {
                 bfind=true;  
                 num_start=i;
             }
             else if(bfind && ((start[i] < '0') || (start[i] > '9')))
             {
                start[i]='\0';
                int_array_in_resp[local_valid_num]=atoi(start+num_start);
                local_valid_num++;
                bfind=false;                
             }             
         }                
    }           
    else
    {
         LYERRLOG("AT Rsp can't find tag %s",tagString);         
         ret=LYNQ_E_INNER_ERROR; 
    }

    *valid_num = local_valid_num; 
    LYINFLOG("AT Rsp ret is %d v num is %d",ret,*valid_num);  
    free(data_str);
    return ret;
}

int get_ret_code_for_hook(Parcel* &p)
{
    int ret;
    int int_array_in_resp[MAX_AT_INT_RSP_NUM];
    int valid_num;
    
    ret=GetIntArrayInRespString(p,"OK",int_array_in_resp,&valid_num);
    
    if(ret!=RESULT_OK)    
    {
        ret=GetIntArrayInRespString(p,"ERROR",int_array_in_resp,&valid_num);
        if(ret==RESULT_OK && valid_num > 0)
        {
            ret=int_array_in_resp[0];
        }
        else
        {
            ret=LYNQ_E_INNER_ERROR;
        }
    }
    return ret;
}

int lynq_radio_on(const lynq_network_radio_on_type type)
{     
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if (type != NETWORK_RADIO_ON_TYPE_CFUN_0  && type != NETWORK_RADIO_ON_TYPE_NORMAL_MODE && type!=NETWORK_RADIO_ON_TYPE_FLIGHT_MODE)
    {
        LYERRLOG("%s parameter %d error",__func__,type);  
        return LYNQ_E_PARAMETER_ANONALY;
    }     
    
    Parcel* p=NULL;      
    int ret;

    if(type==NETWORK_RADIO_ON_TYPE_CFUN_0)
    {
        ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_RADIO_ON,RIL_REQUEST_OEM_HOOK_RAW,1,"%s","AT+CFUN=0");
    }
    else 
    {
        ret=lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_RADIO_ON,RIL_REQUEST_RADIO_POWER,1,"%d",(type==NETWORK_RADIO_ON_TYPE_NORMAL_MODE));
    }

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }   

    if(type==NETWORK_RADIO_ON_TYPE_CFUN_0)
    {
        ret=get_ret_code_for_hook(p);    
    }    

    LYINFLOG("%s set %d ret is %d",__func__,type,ret);  
    delete p;
    return RESULT_OK;  
}

int lynq_query_radio_state(int *radio_state)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == radio_state)
    {
        LYERRLOG("%s radio state is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s","AT+CFUN?");
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }         

    int int_array_in_resp[MAX_AT_INT_RSP_NUM];
    int valid_num;

    ret=GetIntArrayInRespString(p,"CFUN",int_array_in_resp,&valid_num);

    if(ret==RESULT_OK && valid_num > 0)
    {
        *radio_state=int_array_in_resp[0];
    }
    else 
    {
        ret=GetIntArrayInRespString(p,"ERROR",int_array_in_resp,&valid_num);
        if(ret==RESULT_OK && valid_num > 0)
        {
            ret=int_array_in_resp[0];
        }
        else
        {
            ret=LYNQ_E_INNER_ERROR;
        }
    }
    
    delete p;
    return ret;                
} 
int lynq_query_radio_tech(int* radioTech)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == radioTech)
    {
        LYERRLOG("%s radio tech is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;   
    }    

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_VOICE_RADIO_TECH,0,"");
    
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }              
         
    int num;
    p->readInt32(&num);
    p->readInt32(radioTech);

    LYINFLOG("%s suc",__func__);  
    delete p;
    return RESULT_OK;   
}

void convert_rscp(int relative_value, int* abs_value)
{
    if (0 == relative_value) {
        (*abs_value) = 120;
    } 
    else if (0 < relative_value && relative_value <= 96) {
        (*abs_value) = 121 - relative_value;
    } 
    else 
    {
        (*abs_value) = 0x7FFFFFFF;
    }
}

void convert_ecno(int relative_value, int* opposite_value_10_times)
{
    if (0 == relative_value)
    {
        (*opposite_value_10_times) = 240 ;
    }
    else if (0 < relative_value  && relative_value <= 49) 
    {
        (*opposite_value_10_times) = 245 - relative_value*5;
    } 
    else 
    {
        (*opposite_value_10_times) = 0x7FFFFFFF;    
    }
}

int is_rssi_valid(int rssi)
{
    if(rssi < 99 && rssi >=0)
    {
        return true;
    }
    return false;
}

int is_nr_ss_rsrp_valid(int ss_rsrp)
{
    if(ss_rsrp > 0 && ss_rsrp < 255)
    {
        return  true;
    }
    return false;
}

int lynq_solicited_signal_strength(signalStrength_t *solSigStren)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(NULL == solSigStren)
    {
        LYERRLOG("%s parameter is NULL",__func__);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_SIGNAL_STRENGTH,0,"");
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }               


    int none = 0;
    int rscp;
    int ecno;

    p->readInt32(&solSigStren->rssi);
    if(is_rssi_valid(solSigStren->rssi))
    {
        solSigStren->gw_sig_valid = 1;
    }else{
        solSigStren->gw_sig_valid = 0;
    }


    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&solSigStren->lte_signalstrength);

    // p->readInt32(&solSigStren->signalStrength.LTE_SignalStrength.signalStrength);
    p->readInt32(&solSigStren->rsrp);
    p->readInt32(&solSigStren->rsrq);
    p->readInt32(&solSigStren->rssnr);

    if(is_rssi_valid(solSigStren->lte_signalstrength))
    {
        solSigStren->lte_sig_valid = 1;
        LYINFLOG("LTE_rsrp:%d",-solSigStren->rsrp);
    }else{
        solSigStren->lte_sig_valid = 0;
    }


    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&none);
    p->readInt32(&solSigStren->wcdma_signalstrength);
    p->readInt32(&none);
    p->readInt32(&rscp);
    p->readInt32(&ecno);
    
    if(is_rssi_valid(solSigStren->wcdma_signalstrength))
    {
        LYINFLOG("W_ss:%d",solSigStren->wcdma_signalstrength);
        solSigStren->wcdma_sig_valid = 1;
        convert_rscp(rscp,&solSigStren->rscp);
        convert_ecno(ecno,&solSigStren->ecno);
    }else{
        solSigStren->wcdma_sig_valid = 0;
    }
    /*bug fix*/
    p->readInt32(&solSigStren->ssRsrp);  
    
    if(is_nr_ss_rsrp_valid(solSigStren->ssRsrp))
    {
        solSigStren->nr_sig_valid = 1;
        p->readInt32(&solSigStren->ssRsrq);
        p->readInt32(&solSigStren->ssSinr);
        p->readInt32(&solSigStren->csiRsrp);
        p->readInt32(&solSigStren->csiRsrq);
        p->readInt32(&solSigStren->csiSinr);
        LYINFLOG("Nr_ssrp:%d",-(solSigStren->ssRsrp));
    }
    else{
        solSigStren->nr_sig_valid = 0;
    }        

    LYDBGLOG("%s suc",__func__);  
    delete p;
    return RESULT_OK;    
}

int lynq_set_ims(const int ims_mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if (ims_mode < 0 || ims_mode > 1)
    {
        LYERRLOG("%s parameter %d error",__func__,ims_mode);  
        return LYNQ_E_PARAMETER_ANONALY;
    }     

    Parcel* p=NULL;
    int ret = lynq_send_common_request(p,WAIT_TIME_LENGTH_FOR_SET_IMS,RIL_REQUEST_SET_IMS_ENABLE,1,"%d",ims_mode);
    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }        
    
    LYINFLOG("%s set %d suc",__func__,ims_mode);    
    delete p;
    return RESULT_OK;   
}

/*Used to get urc info*/
int lynq_get_urc_info(const int handle,signalStrength_t *solSigStren,int *slot_id)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    LYINFLOG("get urc info, handle is %d, slot is %d",handle,s_module_urc_slot_id);
    if(is_support_urc(handle)==false)
    {
        LYERRLOG("not support handle!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if((handle ==RIL_UNSOL_SIGNAL_STRENGTH && NULL == solSigStren) || 
        (handle !=RIL_UNSOL_SIGNAL_STRENGTH && NULL == slot_id))
    {
        LYERRLOG("solSigStren or slot_id is NULL!!!");
        return LYNQ_E_PARAMETER_ANONALY;
    }  

    if(slot_id!=NULL)
    {
        *slot_id = s_module_urc_slot_id;
    }
  
    if(handle==RIL_UNSOL_SIGNAL_STRENGTH)
    {
        LYDBGLOG("get state update to signal info");
        solSigStren->gw_sig_valid = s_network_urc_solSigStren.gw_sig_valid;
        solSigStren->rssi = s_network_urc_solSigStren.rssi;
        solSigStren->wcdma_signalstrength = s_network_urc_solSigStren.wcdma_signalstrength;
        solSigStren->wcdma_sig_valid = s_network_urc_solSigStren.wcdma_sig_valid;
        solSigStren->rscp = s_network_urc_solSigStren.rscp;
        solSigStren->ecno = s_network_urc_solSigStren.ecno;
        solSigStren->lte_signalstrength = s_network_urc_solSigStren.lte_signalstrength;
        solSigStren->lte_sig_valid = s_network_urc_solSigStren.lte_sig_valid;
        solSigStren->rsrp = s_network_urc_solSigStren.rsrp;
        solSigStren->rsrq = s_network_urc_solSigStren.rsrq;
        solSigStren->rssnr = s_network_urc_solSigStren.rssnr;
        solSigStren->nr_sig_valid = s_network_urc_solSigStren.nr_sig_valid;
        solSigStren->ssRsrp = s_network_urc_solSigStren.ssRsrp;
        solSigStren->ssRsrq = s_network_urc_solSigStren.ssRsrq;
        solSigStren->ssSinr = s_network_urc_solSigStren.ssSinr;
        solSigStren->csiRsrp = s_network_urc_solSigStren.csiRsrp;
        solSigStren->csiRsrq = s_network_urc_solSigStren.csiRsrq;
        solSigStren->csiSinr = s_network_urc_solSigStren.csiSinr;
    }        
    return RESULT_OK;   
}


static pthread_mutex_t urc_signal_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t urc_signal_state_change_cond = PTHREAD_COND_INITIALIZER;

int wait_urc_signal_changes()
{
    pthread_mutex_lock(&urc_signal_state_change_mutex);
    pthread_cond_wait(&urc_signal_state_change_cond,&urc_signal_state_change_mutex);
    pthread_mutex_unlock(&urc_signal_state_change_mutex);
    return RESULT_OK;   
}

void send_urc_signal_changes()
{
    pthread_mutex_lock(&urc_signal_state_change_mutex);
    pthread_cond_signal(&urc_signal_state_change_cond);
    pthread_mutex_unlock(&urc_signal_state_change_mutex);
    return;
}

bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
        case RIL_UNSOL_SIGNAL_STRENGTH:
            return true;                
        default:
            return false;
    }    
}

void urc_msg_process(Parcel *p)
{ 
    int resp_type; 
    int none = 0;
    int NR_sum = 0;
    int size=p->dataSize();    
    int rscp;
    int ecno;
    p->readInt32(&resp_type);
    p->readInt32(&s_module_wait_urc_id);
    p->readInt32(&s_module_urc_slot_id);
    LYINFLOG("%s urc id = %d, slot_id = %d, size is %d, msg is %s",__func__, s_module_wait_urc_id,s_module_urc_slot_id,size,requestToString(s_module_wait_urc_id));
    switch(s_module_wait_urc_id)
    {
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
        {
            set_state_buffer_valid(NETWORK_STATE_BUFFER_TYPE_VOICE_REG,false);
            send_urc_signal_changes();
            break;
        }
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
        {                    
            set_state_buffer_valid(NETWORK_STATE_BUFFER_TYPE_DATA_REG,false);
            send_urc_signal_changes();
            break;
        }
        case RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED:
        {                   
            set_state_buffer_valid(NETWORK_STATE_BUFFER_TYPE_IMS_REG,false);                                       
            send_urc_signal_changes();
            break;
        }
        case RIL_UNSOL_SIGNAL_STRENGTH:
        {
            p->readInt32(&s_network_urc_solSigStren.rssi);
            if(is_rssi_valid(s_network_urc_solSigStren.rssi))
            {
                s_network_urc_solSigStren.gw_sig_valid = 1;
                LYINFLOG("urc_GSM_signalstrength:%d",s_network_urc_solSigStren.rssi);
            }else{
                s_network_urc_solSigStren.gw_sig_valid = 0;
            }
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&s_network_urc_solSigStren.lte_signalstrength);
            p->readInt32(&s_network_urc_solSigStren.rsrp);
            p->readInt32(&s_network_urc_solSigStren.rsrq);
            p->readInt32(&s_network_urc_solSigStren.rssnr);
            if(is_rssi_valid(s_network_urc_solSigStren.lte_signalstrength))
            {
                s_network_urc_solSigStren.lte_sig_valid = 1;
                LYINFLOG("urc_L_rsrp:%d",-(s_network_urc_solSigStren.rsrp));
            }else{
                s_network_urc_solSigStren.lte_sig_valid = 0;
            }
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&none);
            p->readInt32(&s_network_urc_solSigStren.wcdma_signalstrength);
            p->readInt32(&none);//bitErrorRate
            p->readInt32(&rscp);
            p->readInt32(&ecno);
            if(is_rssi_valid(s_network_urc_solSigStren.wcdma_signalstrength))
            {
                s_network_urc_solSigStren.wcdma_sig_valid = 1;
                convert_rscp(rscp,&s_network_urc_solSigStren.rscp);
                convert_ecno(ecno,&s_network_urc_solSigStren.ecno);
                LYINFLOG("urc_W_ss:%d",s_network_urc_solSigStren.wcdma_signalstrength);                
            }else{
                s_network_urc_solSigStren.wcdma_sig_valid = 0;
            }

            if(size >= sizeof(RIL_SignalStrength_v14)+sizeof(int)*LYNQ_URC_MSG_HEAD_ELEMENT_NUM)
            {
                p->readInt32(&s_network_urc_solSigStren.ssRsrp);
                if(is_nr_ss_rsrp_valid(s_network_urc_solSigStren.ssRsrp))
                {
                    s_network_urc_solSigStren.nr_sig_valid = 1;
                    p->readInt32(&s_network_urc_solSigStren.ssRsrq);
                    p->readInt32(&s_network_urc_solSigStren.ssSinr);
                    p->readInt32(&s_network_urc_solSigStren.csiRsrp);
                    p->readInt32(&s_network_urc_solSigStren.csiRsrq);
                    p->readInt32(&s_network_urc_solSigStren.csiSinr);
                    LYINFLOG("[NR signal]ssRsrp is %d , ssRsrq is %d , ssSinr is %d , csiRsrp is %d , csiRsrq is %d , csiSinr is %d",\
                            s_network_urc_solSigStren.ssRsrp,s_network_urc_solSigStren.ssRsrq,s_network_urc_solSigStren.ssSinr, \
                            s_network_urc_solSigStren.csiRsrp,s_network_urc_solSigStren.csiRsrq,s_network_urc_solSigStren.csiSinr);
                }
                else
                {
                    s_network_urc_solSigStren.nr_sig_valid = 0;
                }    
            }
            else
            {
                 s_network_urc_solSigStren.nr_sig_valid = 0;
            }
            send_urc_signal_changes();
            break;
        }
    }
}

/*Used to wait for an update signal*/
int lynq_wait_signalchanges(int *handle)
{
    LYDBGLOG("start wait signalchanges info");
    if(NULL == handle)
    {
        LYERRLOG("illegal input");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    wait_urc_signal_changes();
    LYDBGLOG("get signalchanges");
    *handle = s_module_wait_urc_id;
    return RESULT_OK;   
}

#ifdef MOBILETEK_TARGET_PLATFORM_T106

int lynq_set_oos_net_scan_cfg_fast(int t_fast_scan_enable,  int t_fast_scan_interval)
{
    if(! (
               (t_fast_scan_enable==0) ||
               (t_fast_scan_enable == 1 &&  
                t_fast_scan_interval > 0 && t_fast_scan_interval <= 65535 )
             )    )    
        {
            LYERRLOG("%s paramter %d %d error!",__func__, t_fast_scan_enable, t_fast_scan_interval);
            return LYNQ_E_PARAMETER_ANONALY;
        }
    
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s,%d,%d","AT+ZSET=\"FAST_FREQ_SCAN\"",t_fast_scan_enable,t_fast_scan_interval);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }  

    ret=get_ret_code_for_hook(p);    

    LYINFLOG("%s %d %d ret is %d",__func__,t_fast_scan_enable,t_fast_scan_interval,ret);     
    delete p;
    return ret;  
}

int lynq_get_oos_net_scan_cfg_fast(int* t_fast_scan_enable,  int* t_fast_scan_interval)
{    
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s","AT+ZSET=\"FAST_FREQ_SCAN\"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }       
    
    int int_array_in_resp[MAX_AT_INT_RSP_NUM];
    int valid_num;

    ret=GetIntArrayInRespString(p,"FAST_FREQ_SCAN",int_array_in_resp,&valid_num);

    if(ret==RESULT_OK && valid_num > 1)
    {
        *t_fast_scan_enable = int_array_in_resp[0];
        *t_fast_scan_interval = int_array_in_resp[1];        
    }
    else 
    {
        ret=GetIntArrayInRespString(p,"ERROR",int_array_in_resp,&valid_num);
        if(ret==RESULT_OK && valid_num > 0)
        {
            ret=int_array_in_resp[0];
        }
        else
        {
            ret=LYNQ_E_INNER_ERROR;
        }
    }
    
    delete p;
    return ret;                
}


int lynq_set_oos_net_scan_cfg_full_band(int t_full_band_min, int t_full_band_step, int t_full_band_num, int t_full_band_max, int t_full_band_fast_num)
{      
    if(! (
           (t_full_band_min==0 && t_full_band_step ==0  && t_full_band_num ==0 && t_full_band_max ==0 && t_full_band_fast_num==0) ||
           (t_full_band_min > 0 && t_full_band_min <= 65535 && 
            t_full_band_step > 0 && t_full_band_step <= 65535 && 
            t_full_band_num > 0 && t_full_band_num <= 65535 && 
            t_full_band_max > 0 && t_full_band_max <= 65535 &&
            t_full_band_fast_num >=0 && t_full_band_fast_num < t_full_band_num)
         )    )  
    {
        LYERRLOG("%s paramter  %d %d %d %d %d error!",__func__, t_full_band_min, t_full_band_step, t_full_band_num, t_full_band_max, t_full_band_fast_num);
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;

    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s,%d,%d,%d,%d,%d","AT+ZSET=\"SLEEP_FREQ_SCAN\"",t_full_band_min,t_full_band_step,t_full_band_num,t_full_band_max,t_full_band_fast_num);
    

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }     

    ret=get_ret_code_for_hook(p);    

    LYINFLOG("%s %d %d %d %d %d ret is %d",__func__,t_full_band_min,t_full_band_step,t_full_band_num,t_full_band_max,t_full_band_fast_num,ret);     
    delete p;
    return ret;      
}

int lynq_get_oos_net_scan_cfg_full_band(int* t_full_band_min, int* t_full_band_step, int* t_full_band_num, int* t_full_band_max)
{    
    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"%s","AT+ZSET=\"SLEEP_FREQ_SCAN\"");

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }       
    
    int int_array_in_resp[MAX_AT_INT_RSP_NUM];
    int valid_num;

    ret=GetIntArrayInRespString(p,"SLEEP_FREQ_SCAN",int_array_in_resp,&valid_num);

    if(ret==RESULT_OK && valid_num > 3)
    {
        *t_full_band_min = int_array_in_resp[0];
        *t_full_band_step = int_array_in_resp[1];
        *t_full_band_num = int_array_in_resp[2];
        *t_full_band_max = int_array_in_resp[3];              
    }
    else 
    {
        ret=GetIntArrayInRespString(p,"ERROR",int_array_in_resp,&valid_num);
        if(ret==RESULT_OK && valid_num > 0)
        {
            ret=int_array_in_resp[0];
        }
        else
        {
            ret=LYNQ_E_INNER_ERROR;
        }
    }

    LYDBGLOG("%s ret is %d",__func__,ret);  
    delete p;
    return ret;                
}


#define OOS_NET_SCAN_CFG_TYPE_FAST 0
#define OOS_NET_SCAN_CFG_TYPE_FULL_BAND 1

#elif defined(MODEM_GEN97) 
/**@brief parse at response,return error code,and the response
* @param response [IN] <response>:original at response,This parameter must be a character array.

* @param value [OUT] <value>: Used to receive the parsed value, if multiple values are separated by ";".
*  field:
*    eg:
*       "+cnum: 123456\n+cnum: 456"
*       value:12345;456;
* @param value_len [IN] <value_len>: The value length.

* @return:AT error code
*/
static int parse_at_result(char response[],char value[],int value_len)
{
    if(response == NULL || value == NULL)
    {
        LYERRLOG("parameter invalid");
        return LYNQ_E_PARAMETER_ANONALY;
    }
    if(strstr(response,"ERROR"))
    {
        int i;
        for(i = 0;i < strlen(response);i++)
        {
            if(response[i]==':')
            {
                break;
            }
        }
        if(i < strlen(response))
        {
            LYINFLOG("parse_result:%d\n",atoi(response+i+1));
            return atoi(response+i+1);
        }
        else
        {
            LYINFLOG("%s parse_result:fail,this response invalid\n",response);
            return 100; //unknown
        }
    }
    else if(strstr(response,"OK"))
    {
        /** parse the at response value
        * eg:
        * --> at+cnum
        * <-- +CNUM:"1243452"
        * need parse the "1243452" to <value>
        *@  To-Do
        */
        int count;
        int resp_addr[32] = {0};
        char temp_buf[1024] = {0};
        char *dest;
        dest = NULL;
        count = 0;
        int res_len = strlen(response);
        LYINFLOG("res_len:%d",res_len);
        for(int i = 0; i < res_len; i++)
        {
            if(response[i]==':')
            {
                resp_addr[count] = i;
                count++;
            }
            if(response[i] == '\n')
            {
                response[i] = '\0';
            }
        }
        LYINFLOG("count:%d",count);
        if(count > 0)
        {
            for(int i = 0; i < count; i++)
            {
                if((strlen(temp_buf) + strlen(response+resp_addr[i]+2)) >= 1023)
                {
                    LYINFLOG("2 will be out of range\n");
                    break;
                }
                if(strlen(temp_buf) >= 1023)
                {
                    LYINFLOG("1 will be out of range\n");
                    break;
                }
                strcat(temp_buf,response+resp_addr[i]+2);

                if(strlen(temp_buf) >= 1023)
                {
                    LYINFLOG("1 will be out of range\n");
                    break;
                }
                strcat(temp_buf,";");
                printf("parse_result[%d]:%s,strcated:%s\n",i,response+resp_addr[i]+2,temp_buf);
            }
            LYINFLOG("parse_result:%s\n",temp_buf);
            if(strlen(temp_buf) > value_len)
            {
                printf("result length over value:%ld,%d\n",strlen(temp_buf),value_len);
                memcpy(value,temp_buf,value_len);
            }
            else
            {
                memcpy(value,temp_buf,strlen(temp_buf));
            }
        }
        return RESULT_OK;   
    }
    else
    {
        LYINFLOG("%s this response invalid\n",response);
        return LYNQ_E_INNER_ERROR;
    }
}

int lynq_oos_recover_timer_interval(int mode, char interval[LY_RECOVER_TIMER_INTERVAL],char result[LY_RECOVER_TIMER_INTERVAL])
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    if((mode < 0) || (mode >1) || (mode == 0 && NULL == interval) || (NULL == result))
    {
        LYERRLOG("%s mode %d interval %s result %s error",__func__,mode,interval,result);  
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret;

    if(mode == 0)
    {
        ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"AT+ERSCFG=%s",interval);
    }
    else 
    {
        ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"AT+ERSCFG?");
    }

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }        

    int recv_len;    
    char res_data[LY_RECOVER_TIMER_INTERVAL] = {0};
    char response_interval[LY_RECOVER_TIMER_INTERVAL*2] = {0};

    LYINFLOG("get recover timer interval");
    p->readInt32(&recv_len);
    if(recv_len == -1)
    {
        LYINFLOG("no responset");
        delete p;
        return LYNQ_E_INNER_ERROR;
    }
    else
    {
        LYINFLOG("recv_len:%d",recv_len);
        p->read(response_interval,recv_len);
    }
    LYINFLOG("response_interval:%s",response_interval);
    ret = parse_at_result(response_interval,res_data,LY_RECOVER_TIMER_INTERVAL);
    if(mode == 1)
    {
        if(strlen(res_data) <= LY_RECOVER_TIMER_INTERVAL)
        {
            memcpy(result,res_data,strlen(res_data));
        }
    }
    LYERRLOG("%s ret:%d",__func__,ret);
    delete p;
    return ret;         
}

int lynq_oos_deep_sleep_recover_timer_interval(int recovery_threshold,int fullband_timer,int sniffer_timer,int inactive_mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
     if(((recovery_threshold < 2) || (recovery_threshold > 10)) || (fullband_timer < 90) || 
    ((sniffer_timer < 10) || (sniffer_timer > 60)) || ((inactive_mode < 0) || (inactive_mode > 1)))
    {
        LYERRLOG("%s paramter recovery_threshold %d fullband_timer %d sniffer_timer %d inactive_mode %d error!",__func__,recovery_threshold,fullband_timer,sniffer_timer,inactive_mode);
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,RIL_REQUEST_OEM_HOOK_RAW,1,"AT+ESRVREC=%d,%d,%d,%d",recovery_threshold,fullband_timer,sniffer_timer,inactive_mode);

    if(ret!=RESULT_OK)
    {
        LYERRLOG("%s call lynq_send_common_request failure, ret is %d",__func__,ret);
        return ret;  
    }        
 
    int recv_len;   
    char res_data[LY_RECOVER_TIMER_INTERVAL] = {0};
    char response_interval[LY_RECOVER_TIMER_INTERVAL*2] = {0};
 
    p->readInt32(&recv_len);
    if(recv_len == -1)
    {
        LYINFLOG("no responset");
        delete p;
        return LYNQ_E_INNER_ERROR;
    }
    else
    {
        LYINFLOG("recv_len:%d",recv_len);
        p->read(response_interval,recv_len);
    }
    LYINFLOG("response_interval:%s",response_interval);
    ret = parse_at_result(response_interval,res_data,LY_RECOVER_TIMER_INTERVAL);
    LYERRLOG("%s ret:%d",__func__,ret);
    delete p;
    return ret;      
 
}

#endif

#if (defined MOBILETEK_TARGET_PLATFORM_T106) || (defined MODEM_GEN97)

int lynq_set_oos_net_scan_cfg(int config_list[MAX_OOS_CFG_ITEM_NUMBER], int valid_num)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

#ifdef MOBILETEK_TARGET_PLATFORM_T106
    if(valid_num < 1)
    {
        LYERRLOG("%s paramter valid_num  %d error!",__func__,valid_num);
        return LYNQ_E_PARAMETER_ANONALY;
    }

    if(config_list[0] == OOS_NET_SCAN_CFG_TYPE_FAST)  
    {
        if(valid_num <3 )
        {            
            LYERRLOG("%s paramter valid_num %d error!",__func__, valid_num);
            return LYNQ_E_PARAMETER_ANONALY;
        }        
        return lynq_set_oos_net_scan_cfg_fast(config_list[1],config_list[2]);
    }        
    else if (config_list[0] == OOS_NET_SCAN_CFG_TYPE_FULL_BAND)
    {
        if(valid_num <6 )
        {            
            LYERRLOG("%s paramter valid_num %d error!",__func__, valid_num);
            return LYNQ_E_PARAMETER_ANONALY;
        } 
        return lynq_set_oos_net_scan_cfg_full_band(config_list[1],config_list[2],config_list[3],config_list[4],config_list[5]);
    }
    else 
    {
        LYERRLOG("%s paramter type %d error!",__func__, config_list[0]);
        return LYNQ_E_PARAMETER_ANONALY;
    }     

#else
    if(valid_num < 4)
    {
        LYERRLOG("%s paramter valid_num  %d error!",__func__,valid_num);
        return LYNQ_E_PARAMETER_ANONALY;
    }
    return lynq_oos_deep_sleep_recover_timer_interval(config_list[0],config_list[1],config_list[2],config_list[3]);   
#endif    
}


int lynq_get_oos_net_scan_cfg(int config_list[MAX_OOS_CFG_ITEM_NUMBER], int* valid_num)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

#ifdef MOBILETEK_TARGET_PLATFORM_T106   

    if(NULL == valid_num || NULL == config_list)
    {
          LYERRLOG("%s there is parameter is NULL",__func__);  
          return LYNQ_E_PARAMETER_ANONALY;
    }      
      

    if(config_list[0] == OOS_NET_SCAN_CFG_TYPE_FAST)  
    {
        *valid_num=2;
        return lynq_get_oos_net_scan_cfg_fast(&(config_list[0]),&(config_list[1]));
    }        
    else if (config_list[0] == OOS_NET_SCAN_CFG_TYPE_FULL_BAND)
    {
         *valid_num=4;
         return lynq_get_oos_net_scan_cfg_full_band(&(config_list[0]),&(config_list[1]),&(config_list[2]),&(config_list[3]));
    }
    else 
    {
        LYERRLOG("%s paramter type %d error!",__func__, config_list[0]);
        return LYNQ_E_PARAMETER_ANONALY;
    }           
#else    
    return LYNQ_E_PARAMETER_ANONALY;
#endif    
}

#endif

DEFINE_LYNQ_LIB_LOG(LYNQ_NETWORK)
