#include <inttypes.h>
#include <stddef.h>
#include <assert.h>
/**
 * Prototypes and structures for the ring buffer module.
 */

#ifndef RINGBUFFER_H
#define RINGBUFFER_H

#ifdef __cplusplus
extern "C"
{
#endif

#define RING_BUFFER_ASSERT(x) assert(x)


#define RING_BUFFER_IS_POWER_OF_TWO(buffer_size) ((buffer_size & (buffer_size - 1)) == 0)

typedef size_t ring_buffer_size_t;
#define RING_BUFFER_MASK(rb) (rb->buffer_mask)
typedef struct ring_buffer_t ring_buffer_t;
struct ring_buffer_t {
    /** Buffer memory. */
    char *buffer;
    /** Buffer mask. */
    ring_buffer_size_t buffer_mask;
    /** Index of tail. */
    ring_buffer_size_t tail_index;
    /** Index of head. */
    ring_buffer_size_t head_index;
};

void ring_buffer_init(ring_buffer_t *buffer, char *buf, size_t buf_size);
void ring_buffer_queue(ring_buffer_t *buffer, char data);
void ring_buffer_queue_arr(ring_buffer_t *buffer, const char *data, ring_buffer_size_t size);
uint8_t ring_buffer_dequeue(ring_buffer_t *buffer, char *data);
ring_buffer_size_t ring_buffer_dequeue_arr(ring_buffer_t *buffer, char *data, ring_buffer_size_t len);
uint8_t ring_buffer_peek(ring_buffer_t *buffer, char *data, ring_buffer_size_t index);
uint8_t ring_buffer_is_empty(ring_buffer_t *buffer);
uint8_t ring_buffer_is_full(ring_buffer_t *buffer);
ring_buffer_size_t ring_buffer_num_items(ring_buffer_t *buffer);
void ring_buffer_clean(ring_buffer_t *buffer);

#ifdef __cplusplus
}
#endif

#endif /* RINGBUFFER_H */
