#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include "lynq_qser_thermal.h"

#define MAX_SIZE 100

void parseBuffer(const char *buf, int *numbers, int *count) {
    int i = 0;
    *count = 0;

    while (buf[i] != '\0' && *count < MAX_SIZE) {
        while (buf[i] != '\0' && (buf[i] < '0' || buf[i] > '9') && buf[i] != '-' && buf[i] != '+') {
            ++i;
        }

        bool negative = false;
        if (buf[i] == '-') {
            negative = true;
            ++i;
        } else if (buf[i] == '+') {
            ++i;
        }

        int num = 0;

        while (buf[i] != '\0' && buf[i] >= '0' && buf[i] <= '9') {
            num = num * 10 + (buf[i] - '0');
            ++i;
        }

        if (negative) {
            num = -num;
        }


        if (*count < MAX_SIZE) {
            numbers[(*count)++] = num;
        }

        while (buf[i] != '\0' && (buf[i] >= '0' && buf[i] <= '9')) {
            ++i;
        }
    }
}


int get_thermal_zone(int *numbers, int size) {
    char path[] = "/sys/zx_tsc/tsc_value";
    int ch;
    char buf[MAX_SIZE];
    int i = 0;


    if(NULL == numbers ){
        printf("Error para\n");
        return -1;
    }

    if(size < 6){
        printf("Error para\n");
        return -1;
    }

    FILE *file = fopen(path, "r");
    if (file == NULL) {
        printf("Error opening file.\n");
        return -2;
    }

    while ((ch = fgetc(file)) != EOF && i < MAX_SIZE - 1) 
    {
        if (ch != '\0') {
            buf[i++] = (char)ch;
        }
    }
    
    buf[i] = '\0';
    fclose(file);

    int count = 0;
    parseBuffer(buf, numbers, &count);

    return count;
}


