#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include "liblog/lynq_deflog.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "sc_usb.h"
#include "nv_api.h"
#include "lynq-qser-usb.h"

/********************************************************************
* @brief: qser_get_usb_usermode_net_state, Get Net user mode adb status
* @return : int, Be greater than zero if successful, Less than zero if failed
* @todo: NA
* @see: NA
* @warning: NA
*********************************************************************/
int  qser_get_usb_usermode_net_state(void)
{
    return sc_usb_usermode_net_state();
}

/********************************************************************
* @brief: qser_get_usb_usermode_adb_state, Get Usb user mode adb status
* @return : int, Be greater than zero if successful, Less than zero if failed
* @todo: NA
* @see: NA
* @warning: NA
*********************************************************************/
int  qser_get_usb_usermode_adb_state(void)
{
    return sc_usb_usermode_adb_state();
}

DEFINE_LYNQ_LIB_LOG(LYNQ_USB)

#ifdef __cplusplus
}
#endif
