#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <binder/Parcel.h>
//#include <sys/socket.h>
#include <errno.h>
#include <stdbool.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/shm.h>
#include <liblog/lynq_deflog.h>
#include <pthread.h>
#include "lynq_shm.h"

#undef LOG_TAG
#define LOG_TAG "SHM"

#define shm_key "shm_key"    

int shmid=-1; 

static int s_use_count=0;

typedef struct{
    int num_of_buffer;
    int size_of_buffer;
    int cur_index;
}lynq_shm_type_config;

typedef enum{
    shm_buf_type_256,
    shm_buf_type_1k,
    shm_buf_type_max,
}lynq_shm_buf_type;

lynq_shm_type_config s_lynq_shm_config[shm_buf_type_max]={
    {10,256,0},
    {5,1024,0}
};

static void * s_ril_shm_buf=(void*) -1L;

static pthread_mutex_t s_shm_mtx = PTHREAD_MUTEX_INITIALIZER;

bool get_cur_shem_buffer_index(int size, int* level, int* index)
{
    pthread_mutex_lock(&s_shm_mtx);
    for(int i=0;i<shm_buf_type_max;i++)
    {
        if(size<=s_lynq_shm_config[i].size_of_buffer)
        {
            (*level)=i;
            (*index)=(s_lynq_shm_config[i].cur_index)%s_lynq_shm_config[i].num_of_buffer;
            s_lynq_shm_config[i].cur_index++;    
            pthread_mutex_unlock(&s_shm_mtx);
            return true;
        }
    }    
    pthread_mutex_unlock(&s_shm_mtx);
    return false;
}

bool get_shem_buffer_level(int size, int* level)
{
    for(int i=0;i<shm_buf_type_max;i++)
    {
        if(size<=s_lynq_shm_config[i].size_of_buffer)
        {
            (*level)=i;
            return true;
        }
    }    
    return false;
}


char* get_shem_buffer(int level,int index)
{    
    int offset=0;
    for(int i=0;i<level;i++)
    {
        offset+=s_lynq_shm_config[i].num_of_buffer*s_lynq_shm_config[i].size_of_buffer;
    }
    offset+=s_lynq_shm_config[level].size_of_buffer*index;
    return ((char*) s_ril_shm_buf)+offset;
}

int get_max_shem_buffer_size()
{
    return s_lynq_shm_config[shm_buf_type_max-1].size_of_buffer;
}

int get_total_shem_buffer_size()
{
    int total_size=0;
    for(int i=0;i<shm_buf_type_max;i++)
    {
        total_size+=s_lynq_shm_config[i].num_of_buffer*s_lynq_shm_config[i].size_of_buffer;
    }
    return total_size;
}

static int create_shm_common(int size,int flags)
{
    LYDBGLOG("create shared memory\n");
 
//  key_t key = ftok(shm_key, 's');
    key_t key=0x123456;
    if (key == -1) 
    {
        LYERRLOG("ftok error.\n");
        return -1;
    }
    LYDBGLOG("key is 0x%x\n", key);
 
    int shmid = shmget(key,size , flags);
    if (shmid == -1) 
    {
        LYERRLOG("shmget error.\n");
        return -1;
    }
    LYDBGLOG("shmid is %d\n", shmid);
 
    return shmid;
}

int create_shm()
{
    shmid = create_shm_common(get_total_shem_buffer_size(),IPC_CREAT|0644);

    if(shmid==-1)
    {
        return -1;
    }
    s_ril_shm_buf = shmat(shmid, NULL, 0);
    if (s_ril_shm_buf == (void*) -1L) 
    {
        LYERRLOG("shmat error.\n");
        return -1;
    }
    return 0;    
}
 
void remove_shm()
{
    if(shmid!=-1)
    {
        if (shmdt(s_ril_shm_buf) != 0) 
        {
            LYERRLOG("shmdt error.\n");      
        }        
        shmid = -1;
    }
    s_ril_shm_buf = (void*) -1L;
    return ;
}

int ril_init_mem()
{   
    pthread_mutex_lock(&s_shm_mtx);
    LYERRLOG("init begin, use count is %d.\n",s_use_count);      
    if(s_use_count==0)
    {
        if(create_shm()!=0)
        {
            LYERRLOG("init end, use count is %d.\n",s_use_count);       
            pthread_mutex_unlock(&s_shm_mtx);
            return -1;
        }    
    }
    s_use_count++;
    LYERRLOG("init end, use count is %d.\n",s_use_count);       
    pthread_mutex_unlock(&s_shm_mtx);
    return 0;
}

void ril_deinit_mem()
{
    pthread_mutex_lock(&s_shm_mtx);

    LYERRLOG("de-init begin, use count is %d.\n",s_use_count);      
    if(s_use_count==1)
    {
        remove_shm();        
    }

    if(s_use_count>0)
    {
        s_use_count--;    
    }
    LYERRLOG("de-init end, use count is %d.\n",s_use_count);      
    pthread_mutex_unlock(&s_shm_mtx);
    return ;
}

DEFINE_LYNQ_LIB_LOG(LYNQ_SHM)

