//SPDX-License-Identifier: MediaTekProprietary
#ifndef __PAL_NM_H__
#define __PAL_NM_H__

/**
 * @file pal_nm.h
 * @brief
 * @author MediaTek
 * @version v0.1
 * @date 2016-07-11
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define NM_INTERFACE_FLAG_UP   			(0x1<<0) //IFF_UP
#define NM_INTERFACE_FLAG_LOOPBACK  	(0x1<<2) //IPP_LOOPBACK

typedef enum {
    NM_IP_TYPE_UNKNOWN = 0,
    NM_IP_TYPE_V6_UNSPEC = 0x1,
    NM_IP_TYPE_V6_LOOPBACK = 0x2,
    NM_IP_TYPE_V6_MULTICAST = 0x4,
    NM_IP_TYPE_V6_LINKLOCAL = 0x8,
	NM_IP_TYPE_V6_SITELOCAL = 0x10,

    NM_IP_TYPE_V6_GLOBAL_PERNAMENT = 0x20,
    NM_IP_TYPE_V6_GLOBAL_TEMP = 0x40,
    NM_IP_TYPE_V6_GLOBAL_DYNAMIC =0x80,
	NM_IP_TYPE_V6_GLOBAL = NM_IP_TYPE_V6_GLOBAL_PERNAMENT | NM_IP_TYPE_V6_GLOBAL_TEMP | NM_IP_TYPE_V6_GLOBAL_DYNAMIC,
    NM_IP_TYPE_V6_UNIQUE = 0x100,

	NM_IP_TYPE_V6_ALLCONFIG = NM_IP_TYPE_V6_GLOBAL | NM_IP_TYPE_V6_UNIQUE,
	NM_IP_TYPE_V6_VALIDIP = NM_IP_TYPE_V6_GLOBAL_PERNAMENT | NM_IP_TYPE_V6_GLOBAL_DYNAMIC | NM_IP_TYPE_V6_UNIQUE, /*For App use*/

} NM_IP_TYPE_V6;

typedef enum {
    NM_NETWORK_TYPE_UNKNOW = 0,
    NM_NETWORK_TYPE_IMS = 1,
    NM_NETWORK_TYPE_INTERNET = 2
} NM_NETWORK_TYPE;

/*interface ipv4 related APIs*/
int nm_interface_ipv4_set(const char *intf_name, const char* addr, int prefix_len);
int nm_interface_ipv4_up(const char *intf_name);
int nm_interface_ipv4_down(const char *intf_name);
int nm_interface_ipv4_mtu_set(const char *intf_name, int mtu);
int nm_interface_ipv4_info_get(const char *intf_name, unsigned long *addr,
                                                   int *prefix_len, int *mtu, unsigned int*flags);
int nm_interface_ipv4_hwaddr_get(const char *intf_name, unsigned char *hw_addr);
int nm_interface_ipv4_addr_clear(const char *intf_name);


/*interface ipv6 related APIs*/
int nm_interface_ipv6_mtu_set(const char *intf_name, int mtu);
int nm_interface_ipv6_addr_clear(const char *intf_name);
int nm_interface_ipv6_set(const char *intf_name, int on);
int nm_interface_ipv6_privacyextenstion_enable_set(const char *intf_name, int on);
int nm_interface_ipv6_ndoffload_enable_set(const char *intf_name, int on);
int nm_interface_ipv6_addr_set(const char *intf_name, const char *addr, int prefix_len);
int nm_interface_ipv6_addr_get(const char *intf_name, int addr_type, char *addr, int *prefix_len);


/*network related APIs*/
int nm_network_create(unsigned net_id, const char *permission);
int nm_network_destroy(unsigned net_id);
int nm_network_default_set(unsigned net_id);
int nm_network_default_clear();
int nm_network_interface_add(unsigned net_id, const char* intf_name);
int nm_network_interface_remove(unsigned net_id, const char* intf_name);
int nm_network_route_add(unsigned net_id, const char* intf_name,
                                      const char  *destination, const char *nexthop,
                                      int legacy, unsigned int uid);
int nm_network_route_remove( unsigned net_id, const char* intf_name,
                                            const char *destination, const char *nexthop,
                                            int legacy, unsigned int uid);



/*ipfwd related APIs*/
int nm_fwd_ipv4_set(int enable, const char *requestor);
int nm_fwd_ipv4_get(int *enable);
int nm_fwd_ipv6_set(int enable, const char *requestor);
int nm_fwd_ipv6_get(int *enable);


/*DNS related APIs*/
//set ipv6 dns name server
int nm_resolver_ipv6_dns_set(unsigned net_id, const char *domains, const char* const* servers,  int numservers, NM_NETWORK_TYPE type);

//set ipv4 dns name server
int nm_resolver_ipv4_dns_set(unsigned net_id, const char *domains, const char* const* servers,  int numservers, NM_NETWORK_TYPE type);

//set ipv4 && ipv6 dns name server
int nm_resolver_dns_set(unsigned net_id, const char *domains, const char* const* servers,  int numservers, NM_NETWORK_TYPE type);


//clear name server for both ipv4/ipv6
int nm_resolver_dns_clear(unsigned net_id);

//flush dns cache
int nm_resolver_dns_cache_flush(unsigned net_id);

int nm_command_test(char *intf);

int nm_interface_get_netid(const char *intf_name,unsigned int *netid);


void nm_network_policy_route_init();
int nm_network_ipv6_policy_route_modify(uint16_t action, uint32_t table, const char* interface);
int nm_network_ipv6_policy_rule_modify(uint16_t action, uint32_t priority, uint32_t table, uint32_t fwmark, uint32_t mask, const char* iif, const char* oif);
int nm_network_ipv4_policy_route_modify(uint16_t action, uint32_t table, const char* interface);
int nm_network_ipv4_policy_rule_modify(uint16_t action, uint32_t priority, uint32_t table, uint32_t fwmark, uint32_t mask, const char* iif, const char* oif);
struct Stats {
    uint64_t rxBytes;
    uint64_t rxPackets;
    uint64_t txBytes;
    uint64_t txPackets;
    uint64_t tcpRxPackets;
    uint64_t tcpTxPackets;
};

int parseIfaceStats(const char* iface, struct Stats* stats);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __PAL_NM_H__*/
