#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <libdata/lynq_data.h>
#include <include/lynq-qser-data.h>
#include "data.h"
#define TEST_RESULT "lynq_result="

int init_data(int argc, char *argv[], int sp_test)
{   
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int uToken = atoi(argv[1]);
    ret = lynq_init_data(uToken);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int deinit_data(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    ret = lynq_deinit_data();
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int setup_data_call(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int handle = atoi(argv[1]);

    ret = lynq_setup_data_call(&handle);
    
    printf("%s%d\n",TEST_RESULT,ret);
    printf("handle = %d\n", handle);
    return ret;
}
int deactivte_data_call(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int handle = atoi(argv[1]);

    ret = lynq_deactive_data_call(&handle);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;   
}
int wait_data_call(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int handle = atoi(argv[1]);

    ret = lynq_wait_data_call_state_change(&handle);
    printf("LYNQ_WAIT_DATA_CALL: handle = %d\n", handle);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;   
}
int setup_data_call_sp(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int flag = atoi(argv[5]);
    int handle = atoi(argv[1]);

    ret = lynq_setup_data_call_sp(&handle, argv[2], argv[3], NULL, NULL, NULL, argv[4], NULL);
    
    printf("%s%d\n",TEST_RESULT,ret);
    printf("handle = %d\n", handle);
    return ret;
}
int get_data_call_list(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int handle = atoi(argv[1]);
    lynq_data_call_response_v11_t dataCallList = {-1, -1, -1, -1,"", "", "", "", "", "", -1};

    ret = lynq_get_data_call_list(&handle, &dataCallList);

    printf("LYNQ_GET_DATA_CALL_LIST: handle = %d\n", handle);
    printf("LYNQ_GET_DATA_CALL_LIST: status=%d, suggestedRetryTime=%d, cid=%d, active=%d, type=%s, ifname=%s, addresses=%s, dnses=%s, gateways=%s, pcscf=%s, mtu=%d\n",
        dataCallList.status, dataCallList.suggestedRetryTime, dataCallList.cid, dataCallList.active, 
        dataCallList.type, dataCallList.ifname, dataCallList.addresses, dataCallList.dnses, dataCallList.gateways, dataCallList.pcscf, 
        dataCallList.mtu);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;  
}
//=====================================QSER-DATA=========================================================

qser_data_call_state_s state = {0};
void evt_cb(qser_data_call_state_s *state)
{
    char buf_ip[64] = {0};
    char buf_gateway[64] = {0};
    char buf_pri_dns[64] = {0};
    char buf_sec_dns[64] = {0};
    printf("LYNQ_QSER_DATA_INIT: profile_idx=%d, name=%s, ip_family=%d, state=%d, error=%d\n"
        , state->profile_idx, state->name, state->ip_family, state->state, state->err);
    printf("LYNQ_QSER_DATA_INIT: v4.ip=%s\n"
        , inet_ntoa(state->v4.ip));
    printf("LYNQ_QSER_DATA_INIT: v4.gateway=%s\n"
        , inet_ntoa(state->v4.gateway));
    printf("LYNQ_QSER_DATA_INIT: v4.pri_dns=%s\n"
        , inet_ntoa(state->v4.pri_dns));
    printf("LYNQ_QSER_DATA_INIT: v4.sec_dns=%s\n"
        , inet_ntoa(state->v4.sec_dns));
    inet_ntop(AF_INET6, &(state->v6.ip), buf_ip, sizeof(buf_ip));
    inet_ntop(AF_INET6, &(state->v6.gateway), buf_gateway, sizeof(buf_gateway));
    inet_ntop(AF_INET6, &(state->v6.pri_dns), buf_pri_dns, sizeof(buf_pri_dns));
    inet_ntop(AF_INET6, &(state->v6.sec_dns), buf_sec_dns, sizeof(buf_sec_dns));
    printf("LYNQ_QSER_DATA_INIT: v6.ip=%s, v6.gateway=%s, v6.pri_dns=%s, v6.sec_dns=%s\n"
        , buf_ip, buf_gateway, buf_pri_dns, buf_sec_dns);
}

int qser_init_data(int argc, char *argv[], int sp_test)
{   
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int uToken = atoi(argv[1]);
    ret = qser_data_call_init(evt_cb);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}

int qser_deinit_data(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);

    qser_data_call_destroy();
    printf("LYNQ_QSER_DATA_DEINIT end\n");
    return 0;
}
int qser_setup_data_call(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    qser_data_call_s datacall;
    qser_data_call_error_e err = QSER_DATA_CALL_ERROR_NONE;
    int ip_family_flag = atoi(argv[3]);

    datacall.profile_idx = atoi(argv[1]);
    datacall.reconnect = (bool)atoi(argv[2]);

    if(strcmp(argv[3], "QSER_DATA_CALL_TYPE_IPV4") == 0)
    {
        datacall.ip_family = QSER_DATA_CALL_TYPE_IPV4;
    }
    else if(strcmp(argv[3], "QSER_DATA_CALL_TYPE_IPV6") == 0)
    {
        datacall.ip_family = QSER_DATA_CALL_TYPE_IPV6;
    }
    else if(strcmp(argv[3], "QSER_DATA_CALL_TYPE_IPV4V6") == 0)
    {
        datacall.ip_family = QSER_DATA_CALL_TYPE_IPV4V6;
    }
    else
    {
        printf("LYNQ_QSER_SETUP_DATA_CALL: ip_family input error\n");
        return ret;
    }

    memcpy(datacall.cdma_username, argv[4], QSER_APN_USERNAME_SIZE);
    memcpy(datacall.cdma_password, argv[5], QSER_APN_PASSWORD_SIZE);    
    
    ret = qser_data_call_start(&datacall, &err);
    printf("LYNQ_QSER_SETUP_DATA_CALL err = %d\n", err);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int qser_setup_data_call_async(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    qser_data_call_s datacall;
    qser_data_call_error_e err = QSER_DATA_CALL_ERROR_NONE;
    int ip_family_flag = atoi(argv[3]);

    datacall.profile_idx = atoi(argv[1]);
    datacall.reconnect = (bool)atoi(argv[2]);

    if(strcmp(argv[3], "QSER_DATA_CALL_TYPE_IPV4") == 0)
    {
        datacall.ip_family = QSER_DATA_CALL_TYPE_IPV4;
    }
    else if(strcmp(argv[3], "QSER_DATA_CALL_TYPE_IPV6") == 0)
    {
        datacall.ip_family = QSER_DATA_CALL_TYPE_IPV6;
    }
    else if(strcmp(argv[3], "QSER_DATA_CALL_TYPE_IPV4V6") == 0)
    {
        datacall.ip_family = QSER_DATA_CALL_TYPE_IPV4V6;
    }
    else
    {
        printf("LYNQ_QSER_SETUP_DATA_CALL_ASYNC: ip_family input error\n");
        return ret;
    }

    memcpy(datacall.cdma_username, argv[4], QSER_APN_USERNAME_SIZE);
    memcpy(datacall.cdma_password, argv[5], QSER_APN_PASSWORD_SIZE);    
    
    ret = qser_data_call_start_async(&datacall, &err);
    printf("LYNQ_QSER_SETUP_DATA_CALL_ASYNC err = %d\n", err);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int qser_deactivte_data_call(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int profile_idx_int = atoi(argv[1]);
    qser_data_call_ip_family_e ip_family = QSER_DATA_CALL_TYPE_IPV4V6;
    qser_data_call_error_e err = QSER_DATA_CALL_ERROR_NONE;

    if(strcmp(argv[2], "QSER_DATA_CALL_TYPE_IPV4") == 0)
    {
        ip_family = QSER_DATA_CALL_TYPE_IPV4;
    }
    else if(strcmp(argv[2], "QSER_DATA_CALL_TYPE_IPV6") == 0)
    {
        ip_family = QSER_DATA_CALL_TYPE_IPV6;
    }
    else if(strcmp(argv[2], "QSER_DATA_CALL_TYPE_IPV4V6") == 0)
    {
        ip_family = QSER_DATA_CALL_TYPE_IPV4V6;
    }
    else
    {
        printf("LYNQ_QSER_DEACTIVATE_DATA_CALL: ip_family input error\n");
        return ret;
    }

    ret = qser_data_call_stop(profile_idx_int, ip_family, &err);
    printf("LYNQ_QSER_DEACTIVATE_DATA_CALL err = %d\n", err);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int qser_get_data_call_list(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char buf_ip[64] = {0};
    char buf_gateway[64] = {0};
    char buf_pri_dns[64] = {0};
    char buf_sec_dns[64] = {0};
    qser_data_call_info_s info = {0};
    int profile_idx_int = atoi(argv[1]);
    qser_data_call_error_e err = QSER_DATA_CALL_ERROR_NONE;
    qser_data_call_ip_family_e ip_family = QSER_DATA_CALL_TYPE_IPV4V6;

    if(strcmp(argv[2], "QSER_DATA_CALL_TYPE_IPV4") == 0)
    {
        ip_family = QSER_DATA_CALL_TYPE_IPV4;
    }
    else if(strcmp(argv[2], "QSER_DATA_CALL_TYPE_IPV6") == 0)
    {
        ip_family = QSER_DATA_CALL_TYPE_IPV6;
    }
    else if(strcmp(argv[2], "QSER_DATA_CALL_TYPE_IPV4V6") == 0)
    {
        ip_family = QSER_DATA_CALL_TYPE_IPV4V6;
    }
    else
    {
        printf("LYNQ_QSER_GET_DATA_CALL_LIST: ip_family input error\n");
        return ret;
    }
    
    ret = qser_data_call_info_get(profile_idx_int, ip_family, &info, &err);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: error=%d, profile_idx=%d, ip_family=%d\n", err, info.profile_idx, info.ip_family);
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v4.name=%s, v4.state=%d, v4.reconnect=%d\n", info.v4.name, info.v4.state, info.v4.reconnect);
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v4.ip=%s\n"
        , inet_ntoa(info.v4.addr.ip));
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v4.gateway=%s\n"
        , inet_ntoa(info.v4.addr.gateway));
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v4.pri_dns=%s\n"
        , inet_ntoa(info.v4.addr.pri_dns));
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v4.sec_dns=%s\n"
        , inet_ntoa(info.v4.addr.sec_dns));

    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v6.name=%s, v6.state=%d, v6.reconnect=%d\n", info.v6.name, info.v6.state, info.v6.reconnect);
    inet_ntop(AF_INET6, &(info.v6.addr.ip), buf_ip, sizeof(buf_ip));
    inet_ntop(AF_INET6, &(info.v6.addr.gateway), buf_gateway, sizeof(buf_gateway));
    inet_ntop(AF_INET6, &(info.v6.addr.pri_dns), buf_pri_dns, sizeof(buf_pri_dns));
    inet_ntop(AF_INET6, &(info.v6.addr.sec_dns), buf_sec_dns, sizeof(buf_sec_dns));
    printf("LYNQ_QSER_GET_DATA_CALL_LIST: v6.ip=%s, v6.gateway=%s, v6.pri_dns=%s, v6.sec_dns=%s\n"
        , buf_ip, buf_gateway, buf_pri_dns, buf_sec_dns);
    return ret;
}

int lynq_qser_apn_set(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    qser_apn_info_s apn = {'1', QSER_APN_PDP_TYPE_IPV4V6, QSER_APN_AUTH_PROTO_DEFAULT, NULL, NULL, NULL, NULL};

    apn.profile_idx = atoi(argv[1]);
    //set pdptype
    if(strcmp(argv[2], "QSER_APN_PDP_TYPE_IPV4") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_IPV4;
    }
    else if(strcmp(argv[2], "QSER_APN_PDP_TYPE_PPP") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_PPP;
    }
    else if(strcmp(argv[2], "QSER_APN_PDP_TYPE_IPV6") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_IPV6;
    }
    else if(strcmp(argv[2], "QSER_APN_PDP_TYPE_IPV4V6") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_IPV4V6;
    }
    else
    {
        printf("LYNQ_QSER_APN_SET: pdp_type input error\n");
        return ret;
    }
    //set auth_proto
    if(strcmp(argv[3], "QSER_APN_AUTH_PROTO_DEFAULT") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_DEFAULT;
    }
    else if(strcmp(argv[3], "QSER_APN_AUTH_PROTO_NONE") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_NONE;
    }
    else if(strcmp(argv[3], "QSER_APN_AUTH_PROTO_PAP") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_PAP;
    }
    else if(strcmp(argv[3], "QSER_APN_AUTH_PROTO_CHAP") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_CHAP;
    }
    else if(strcmp(argv[3], "QSER_APN_AUTH_PROTO_PAP_CHAP") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_PAP_CHAP;
    }
    else
    {
        printf("LYNQ_QSER_APN_SET: auth_proto input error\n");
        return ret;
    }
    memcpy(apn.apn_name,argv[4],QSER_APN_NAME_SIZE);
    memcpy(apn.username,argv[5],QSER_APN_USERNAME_SIZE);
    memcpy(apn.password,argv[6],QSER_APN_PASSWORD_SIZE);
    memcpy(apn.apn_type,argv[7],QSER_APN_NAME_SIZE);
    ret = qser_apn_set(&apn);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int lynq_qser_apn_get(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    qser_apn_info_s apn = {0};
    int profile_idx_int = atoi(argv[1]);
    ret = qser_apn_get(profile_idx_int, &apn);
    printf("%s%d\n",TEST_RESULT,ret);
    printf("LYNQ_QSER_APN_GET: pdp_type=%d, auth_proto=%d, apn_name=%s, username=%s, password=%s, apn_type=%s\n"
        ,apn.pdp_type, apn.auth_proto, apn.apn_name, apn.username, apn.password, apn.apn_type);
    return ret;
}
int lynq_qser_apn_add(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    unsigned char profile_idx_char;
    qser_apn_add_s apn = {QSER_APN_PDP_TYPE_IPV4V6, QSER_APN_AUTH_PROTO_DEFAULT, "cmnet", NULL, NULL, NULL};

    if(strcmp(argv[1], "QSER_APN_PDP_TYPE_IPV4") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_IPV4;
    }
    else if(strcmp(argv[1], "QSER_APN_PDP_TYPE_PPP") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_PPP;
    }
    else if(strcmp(argv[1], "QSER_APN_PDP_TYPE_IPV6") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_IPV6;
    }
    else if(strcmp(argv[1], "QSER_APN_PDP_TYPE_IPV4V6") == 0)
    {
        apn.pdp_type = QSER_APN_PDP_TYPE_IPV4V6;
    }
    else
    {
        printf("LYNQ_QSER_APN_ADD: pdp_type input error\n");
        return ret;
    }
    //set auth_proto
    if(strcmp(argv[2], "QSER_APN_AUTH_PROTO_DEFAULT") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_DEFAULT;
    }
    else if(strcmp(argv[2], "QSER_APN_AUTH_PROTO_NONE") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_NONE;
    }
    else if(strcmp(argv[2], "QSER_APN_AUTH_PROTO_PAP") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_PAP;
    }
    else if(strcmp(argv[2], "QSER_APN_AUTH_PROTO_CHAP") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_CHAP;
    }
    else if(strcmp(argv[2], "QSER_APN_AUTH_PROTO_PAP_CHAP") == 0)
    {
        apn.auth_proto = QSER_APN_AUTH_PROTO_PAP_CHAP;
    }
    else
    {
        printf("LYNQ_QSER_APN_ADD: auth_proto input error\n");
        return ret;
    }

    memcpy(apn.apn_name,argv[3],QSER_APN_NAME_SIZE);
    memcpy(apn.username,argv[4],QSER_APN_USERNAME_SIZE);
    memcpy(apn.password,argv[5],QSER_APN_PASSWORD_SIZE);
    memcpy(apn.apn_type,argv[6],QSER_APN_NAME_SIZE);

    printf("LYNQ_QSER_APN_ADD: ready to qser_apn_add\n");
    ret = qser_apn_add(&apn, &profile_idx_char);
    printf("%s%d,profile = %d\n",TEST_RESULT,ret,profile_idx_char);
    return ret;
}
int lynq_qser_apn_del(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    int profile_idx_int = atoi(argv[1]);
    ret = qser_apn_del(profile_idx_int);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int lynq_qser_apn_get_list(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    qser_apn_info_list_s apn_list = {0};
    ret = qser_apn_get_list(&apn_list);
    printf("%s%d\n",TEST_RESULT,ret);
    for(int i = 0; i < apn_list.cnt; i++)
    {
        printf("LYNQ_QSER_APN_GET_LIST: profile_idx=%d, pdp_type=%d, auth_proto=%d, apn_name=%s, username=%s, password=%s, apn_type=%s\n"
            ,apn_list.apn[i].profile_idx, apn_list.apn[i].pdp_type, apn_list.apn[i].auth_proto, apn_list.apn[i].apn_name, apn_list.apn[i].username, apn_list.apn[i].password, apn_list.apn[i].apn_type);
    }
    return ret;
}
int lynq_qser_set_initial_apnname(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;

    ret = qser_set_initial_apnname(argv[1]);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}
int lynq_qser_get_initial_apnname(int argc, char *argv[], int sp_test)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    int ret = -1;
    char apnname[QSER_APN_NAME_SIZE] = "\0";

    ret = qser_get_initial_apnname(apnname);
    printf("LYNQ_QSER_GET_INITIAL_APNNAME:apnname is %s\n", apnname);
    printf("%s%d\n",TEST_RESULT,ret);
    return ret;
}