#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include <pthread.h>
#include <errno.h>

#include "dispatch.h"
#include "lynq.h"
#include "cc.h"
#include "sms.h"
#include "network.h"
#include "data.h"
#include "qser-voice.h"
#include "sim.h"

#define SOCKET_BUF_SIZE 512
typedef struct {
    char *name;           /* User printable name of the function. */
    int (*func)(int argc, char *argv[], int sp_test);       /* Function to call to do the job. */
    char *doc;            /* Documentation for this function.  */
    int request;
} COMMAND;

COMMAND commands[] = {
#include "req_commands.h"
};

int g_rdit_socket_fd = 0;
int g_rdit_client_connect = -1;
static pthread_mutex_t s_startupMutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_startupCond = PTHREAD_COND_INITIALIZER;

int has_registe_cmd = 0;
struct sockaddr_un g_remote_addr = {0};
struct sockaddr_un g_local_addr = {0};
int g_create_socket = 0;
int g_start_main_loop = 0;


COMMAND* find_command (char *name)
{
  register int i;

  for (i = 0; commands[i].name; i++)
    if (strcmp (name, commands[i].name) == 0)
      return (&commands[i]);

  return ((COMMAND *)NULL);
}

const char *requestToString(int request)
{
    switch(request)
    {
        case LYNQ_DIAL: return "LYNQ_DIAL";
        case LYNQ_ANSWER: return "LYNQ_ANSWER";
        case LYNQ_HUNGUP: return "LYNQ_HUNGUP";
        case LYNQ_QSER_CALL_INIT :return  "LYNQ_QSER_CALL_INIT";
        case LYNQ_QSER_CALL_DEINIT : return "LYNQ_QSER_CALL_DEINIT";
        case LYNQ_QSER_CALL_START : return "LYNQ_QSER_CALL_START";
        case LYNQ_QSER_CALL_ANSWER : return "LYNQ_QSER_CALL_ANSWER";
        case LYNQ_QSER_CALL_END : return "LYNQ_QSER_CALL_END";
        case LYNQ_QSER_CALL_HANDLER : return "LYNQ_QSER_CALL_HANDLER";
        case LYNQ_QSER_CALL_REMOVE : return "LYNQ_QSER_CALL_REMOVE ";
        default: return "<unknown request>";
    }
}
int parse_param(char *cmd, char *argv[], int max_args)
{
    char *pos, *pos2;
    int argc = 0;
    printf("recive tester cmd=%s\n",cmd);
    pos = cmd;
    while (1) {
        // Trim the space characters.
        while (*pos == ' ') {
            pos++;
        }

        if (*pos == '\0') {
            break;
        }

        // One token may start with '"' or other characters.
        if (*pos == '"' && (pos2 = strrchr(pos+1, '"'))) {
            argv[argc++] = pos + 1;
            *pos2 = '\0';
            pos = pos2 + 1;
            if(*pos == '\n'){
                *pos = '\0';
                pos = pos + 1;
            }

        } else {
            argv[argc++] = pos;
            while (*pos != '\0' && *pos != ' '&& *pos != '\n') {
                pos++;
            }
            *pos++ = '\0';

            if(argc == 1) {
              char* at_cmd = strstr(argv[0], "RIL_REQUEST_OEM_HOOK_RAW");
              if(at_cmd != NULL) {
                while (*pos == ' ') {
                    pos++;
                }
                argv[argc++] = pos;
                while (*pos != '\0' && *pos != '\n') {
                    pos++;
                }
                *pos++ = '\0';
                break;
              }
            }

        }

        // Check if the maximum of arguments is reached.
        if (argc == max_args) {
            break;
        }
    }

    return argc;
}
dispatch_manager::dispatch_manager()
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    __init_msg();
}
dispatch_manager::~ dispatch_manager(){}

int dispatch_manager::__init_msg()
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    __request = 0;
    __argc = 0;
    __argv = NULL;
    __socket_name = NULL;
    return 0;
}
int dispatch_manager::__set_request_msg(int req,int argc,char *argv)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    printf("requet=%d,argc=%d,argv p=%x\n");
    __request = req;
    __argc = argc;
    __argv = argv;
}
int dispatch_manager::set_request_msg(int req,int argc,char *argv)
{
    printf("[%s][%d] enter!\n",__FUNCTION__,__LINE__);
    __set_request_msg(req,argc,argv);
}


int actsvc_cmd_recv(int fd, char *buf, int len)
{
    int ret = 0;
    ret = recv(fd, buf, len, 0);
    printf("[%d][%s] recv before\n",__LINE__,__FUNCTION__);
    if (ret < 0)
    {
        printf("acti_cmd_recv service select error, ret=%d, error=%s(%d),fd=%d\n", ret,strerror(errno), errno, fd);
        return LYNQ_E_SOCKET_FAIL;
    }
    else if(ret == 0)
    {
        printf("acti_cmd_recv service recv error, ret=%d, error=%s(%d),fd=%d\n", ret,strerror(errno), errno, fd);
        return LYNQ_E_SOCKET_ZERO;
    }
    else
    {
        printf("[%d][%s] buf is:%s\n",__LINE__,__FUNCTION__,buf);
        return LYNQ_E_SOCKET_SUCC;
    }
}

int create_socket(const int domain, const int type, const int protocol,const int port,const char *IP,const char *socket_name,void * addr,int backlog,int cs)
{
    printf("[%d][%s]start create socket\n",__LINE__,__FUNCTION__);
    printf("domain:%d,type:%d,protocol:%d,port:%d,IP:%s,socket_name:%s,backlog:%d\n",domain,type,protocol,port,IP,socket_name,backlog);
    int socket_fd = -1;
    char acBuf[1024] = {0};
    struct sockaddr_un *local_addr = NULL;
    local_addr = (struct sockaddr_un *)addr;
    socket_fd = socket(domain, type,protocol);
    if(0 > socket_fd)
    {
        printf("create socket fail:fd = %d\n",socket_fd);
        return socket_fd;
    }
    switch (domain)
    {
        case AF_UNIX:
        {
            if (strlen(socket_name) > sizeof(local_addr->sun_path) - 1)
            {
                printf("Server socket path too long: %s\n", socket_name);
                return (-strlen(socket_name));
            }
            if(cs == 0)//0:service 1:client
            {
                printf("remove %s\n", socket_name);
                if (remove(socket_name) == -1 && errno != ENOENT)
                { 
                    printf("remove-%s fail and errno:%d\n", socket_name,errno);
                }
            }
            if(type == SOCK_STREAM)
            {
                while(access(socket_name, R_OK)==0)
                {
                    printf("%s still exist\n", socket_name);
                    usleep(10);
                }
            }
            local_addr->sun_family = AF_UNIX;
            sprintf(local_addr->sun_path, socket_name);
            if(cs == 0)//0:service 1:client
            {
                if(bind(socket_fd, (struct sockaddr *)local_addr, sizeof(struct sockaddr_un)) < 0)
                {
                    printf("bind failed name=[%s] reason=[%s]\n", socket_name, strerror(errno));
                    //printf("[%d][%s]bind fail and errno: %d",LINE,FUNC,errno);
                    close(socket_fd);
                    return -1;
                }
                if(type == SOCK_STREAM)
                {
                    if(listen(socket_fd,backlog) == -1)
                    {
                        printf("[%d]listen fd: %dfail\n",__LINE__);
                        close(socket_fd);
                        return -1;
                    }
                }
            }
            else
            {
                printf("init this client\n");
            }
            break;
        }
        case AF_INET:
        {
            break;
        }
        default:
            break;
    }
    return socket_fd;
}

int dispatch_manager::init_socket(char *socket_name)
{
    socklen_t client_len;
    int ret;
    char parser_buf[SOCKET_BUF_SIZE];
    TryNewSocket:
    g_rdit_socket_fd = create_socket(AF_UNIX, SOCK_DGRAM,0, 0, NULL,socket_name, (void *)&g_local_addr, 2, 0);
    if(0 > g_rdit_socket_fd)
    {
        printf("init socket fail and fd:%d",g_rdit_socket_fd);
        g_create_socket++;
        if(g_create_socket == 10)
        {
            printf("create_socket max try count is %d\n", g_create_socket);
            return LYNQ_E_SOCKET_CREATE_FAIL;
        }
        else
        {
            printf("create_socket try again %d\n", g_create_socket);
            usleep(500*1000);
            goto TryNewSocket;
        }
    }
    set_socket_fd(g_rdit_socket_fd);
    return LYNQ_E_SUCCESS;
}

void *socket_read_loop(void *param)
{
    socklen_t client_len;
    int ret = -1;
    int socket_fd = -1;
    char parser_buf[SOCKET_BUF_SIZE];
    char *argv[32] = {0};
    int  argc = 0;
    int *temp = (int*)param;
    printf("[%d][%s] TryNewLink!\n", __LINE__,__FUNCTION__);
    pthread_mutex_lock(&s_startupMutex);
    g_start_main_loop = 1;
    pthread_cond_broadcast(&s_startupCond);
    pthread_mutex_unlock(&s_startupMutex);
    client_len = sizeof(g_local_addr);
    socket_fd = *temp;
    printf("[%d][%s] socket_fd = %d,%p!\n",__LINE__,__FUNCTION__,socket_fd,temp);
#if 0
    int conn = accept(socket_fd,(struct sockaddr *) &g_local_addr, &client_len);
    if (conn <= 0)
    {
        printf("[%d][%s] accept error!",__LINE__,__FUNCTION__);
        close(conn);
        return NULL;
    }
    printf("Accept a client , fd is %d", conn);
    if(g_rdit_client_connect >= 0)
    {
        printf("g_rdit_client_connect need close!");
        close(g_rdit_client_connect);
    }
    g_rdit_client_connect = conn;
#endif
    /* tranlate data */
    while (true)
    {
        memset(parser_buf, 0, sizeof(parser_buf));
        ret = actsvc_cmd_recv(socket_fd, parser_buf, SOCKET_BUF_SIZE);
        if (ret == LYNQ_E_SOCKET_FAIL)
        {
            printf("[%d][%s] LYNQ_E_SOCKET_FAIL receive CMD error\n",__LINE__,__FUNCTION__);
            continue;
        }
        argc = parse_param(parser_buf,argv,32);
        if(argc < 1)
        {
            printf("%s: error input.\n", parser_buf);
            continue;
        }
        for(int i = 0;i < argc;i++)
        {
            printf("argc:%d---argv = %s\n",i,argv[i]);
        }
        COMMAND *command =  find_command(argv[0]);
        if(!command)
        {
            printf("%s: No such command for MobileTek_Tester_RDIT\n", argv[0]);
            continue;
        }
        (*(command->func))(argc,argv,0);
    }
    return NULL;
}


void dispatch_manager::start_main_loop()
{
    printf("[%d][%s] enter!\n",__LINE__,__FUNCTION__);
    g_start_main_loop = 0;
    pthread_t s_tid_dispatch;
    pthread_mutex_lock(&s_startupMutex);
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    int socket_fd = get_socket_fd();
    printf("[%d][%s] socket_fd = %d,%p!\n",__LINE__,__FUNCTION__,socket_fd,&socket_fd);
    int result = pthread_create(&s_tid_dispatch, &attr,socket_read_loop, (void *)&socket_fd);
    if (result != 0) {
        printf("Failed to create dispatch thread: %s\n", strerror(result));
        goto done;
    }
   
    while (g_start_main_loop == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
    //warren delete,beacuse of update at fwk.
    /*mobiletek add*
    s_started = 0;
    result = pthread_create(&s_tid_dispatch, &attr, eventLoop_at, NULL);
    if (result != 0) {
        printf("Failed to create dispatch thread: %s", strerror(result));
        goto done;
    }

    while (s_started == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
    *mobiletek add
    result = pthread_create(&s_tid_dispatch, &attr, responseLoop, NULL);
    if (result != 0) {
        printf("Failed to create response dispatch thread: %s", strerror(result));
        goto done;
    }

    while (s_responseDispatch == 0) {
        pthread_cond_wait(&s_startupCond, &s_startupMutex);
    }
    */
done:
    pthread_mutex_unlock(&s_startupMutex);
}
