
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <string.h>
#include "lynq_call.h"
#include "lynq_module_common.h"
#include "lynq_call_common.h"
#include "lynq_module_socket.h"

#define USER_LOG_TAG "LYNQ_CALL"

/*set*/
int lynq_set_voice_audio_mode(const LYNQ_Audio_Mode audio_mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }
    if(audio_mode < AUDIO_MODE_CODEC)
    {
        return LYNQ_E_PARAMETER_ANONALY;
    }

    Parcel* p=NULL;
    int ret=lynq_send_common_request(p,g_wait_time,LYNQ_REQUEST_SET_VOICE_AUDIO_MODE,1,"%d",audio_mode);
    if(ret==RESULT_OK)
    {
        delete p;        
    }
    return ret;
}
/*get*/
int lynq_get_voice_audio_mode(LYNQ_Audio_Mode* voice_audio_mode)
{
    if(g_module_init_flag != MODULE_RUNNING)
    {
        LYERRLOG("%s module state %d error",__func__,g_module_init_flag);
        return LYNQ_E_CONFLICT;
    }

    if(voice_audio_mode==NULL)
    {
        LYERRLOG("parameter is NULL");
        return LYNQ_E_PARAMETER_ANONALY;
    }    

    int local_mode;

    int ret=lynq_get_common_request(LYNQ_REQUEST_GET_VOICE_AUDIO_MODE,&local_mode);

    *voice_audio_mode = (LYNQ_Audio_Mode) local_mode;
    return ret;
}
